# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ManagedMySqlDatabaseInboundReplicationSummary(object):
    """
    Inbound replication information of a MySQL replica.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ManagedMySqlDatabaseInboundReplicationSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param source_host:
            The value to assign to the source_host property of this ManagedMySqlDatabaseInboundReplicationSummary.
        :type source_host: str

        :param source_port:
            The value to assign to the source_port property of this ManagedMySqlDatabaseInboundReplicationSummary.
        :type source_port: int

        :param fetch_status:
            The value to assign to the fetch_status property of this ManagedMySqlDatabaseInboundReplicationSummary.
        :type fetch_status: str

        :param apply_status:
            The value to assign to the apply_status property of this ManagedMySqlDatabaseInboundReplicationSummary.
        :type apply_status: str

        :param desired_delay_seconds:
            The value to assign to the desired_delay_seconds property of this ManagedMySqlDatabaseInboundReplicationSummary.
        :type desired_delay_seconds: int

        :param remaining_delay_seconds:
            The value to assign to the remaining_delay_seconds property of this ManagedMySqlDatabaseInboundReplicationSummary.
        :type remaining_delay_seconds: int

        :param channel_name:
            The value to assign to the channel_name property of this ManagedMySqlDatabaseInboundReplicationSummary.
        :type channel_name: str

        :param source_uuid:
            The value to assign to the source_uuid property of this ManagedMySqlDatabaseInboundReplicationSummary.
        :type source_uuid: str

        :param source_server_id:
            The value to assign to the source_server_id property of this ManagedMySqlDatabaseInboundReplicationSummary.
        :type source_server_id: int

        :param gtid_assignment:
            The value to assign to the gtid_assignment property of this ManagedMySqlDatabaseInboundReplicationSummary.
        :type gtid_assignment: str

        :param applier_filters:
            The value to assign to the applier_filters property of this ManagedMySqlDatabaseInboundReplicationSummary.
        :type applier_filters: list[oci.database_management.models.MySqlReplicationApplierFilter]

        :param seconds_behind_source:
            The value to assign to the seconds_behind_source property of this ManagedMySqlDatabaseInboundReplicationSummary.
        :type seconds_behind_source: int

        :param retrieved_gtid_set:
            The value to assign to the retrieved_gtid_set property of this ManagedMySqlDatabaseInboundReplicationSummary.
        :type retrieved_gtid_set: str

        :param relay_log_storage_space_used:
            The value to assign to the relay_log_storage_space_used property of this ManagedMySqlDatabaseInboundReplicationSummary.
        :type relay_log_storage_space_used: int

        :param transactions_received:
            The value to assign to the transactions_received property of this ManagedMySqlDatabaseInboundReplicationSummary.
        :type transactions_received: int

        :param apply_delay:
            The value to assign to the apply_delay property of this ManagedMySqlDatabaseInboundReplicationSummary.
        :type apply_delay: float

        :param busy_workers:
            The value to assign to the busy_workers property of this ManagedMySqlDatabaseInboundReplicationSummary.
        :type busy_workers: int

        :param fetch_error:
            The value to assign to the fetch_error property of this ManagedMySqlDatabaseInboundReplicationSummary.
        :type fetch_error: oci.database_management.models.MySqlFetchError

        :param apply_error:
            The value to assign to the apply_error property of this ManagedMySqlDatabaseInboundReplicationSummary.
        :type apply_error: oci.database_management.models.MySqlApplyError

        """
        self.swagger_types = {
            'source_host': 'str',
            'source_port': 'int',
            'fetch_status': 'str',
            'apply_status': 'str',
            'desired_delay_seconds': 'int',
            'remaining_delay_seconds': 'int',
            'channel_name': 'str',
            'source_uuid': 'str',
            'source_server_id': 'int',
            'gtid_assignment': 'str',
            'applier_filters': 'list[MySqlReplicationApplierFilter]',
            'seconds_behind_source': 'int',
            'retrieved_gtid_set': 'str',
            'relay_log_storage_space_used': 'int',
            'transactions_received': 'int',
            'apply_delay': 'float',
            'busy_workers': 'int',
            'fetch_error': 'MySqlFetchError',
            'apply_error': 'MySqlApplyError'
        }
        self.attribute_map = {
            'source_host': 'sourceHost',
            'source_port': 'sourcePort',
            'fetch_status': 'fetchStatus',
            'apply_status': 'applyStatus',
            'desired_delay_seconds': 'desiredDelaySeconds',
            'remaining_delay_seconds': 'remainingDelaySeconds',
            'channel_name': 'channelName',
            'source_uuid': 'sourceUuid',
            'source_server_id': 'sourceServerId',
            'gtid_assignment': 'gtidAssignment',
            'applier_filters': 'applierFilters',
            'seconds_behind_source': 'secondsBehindSource',
            'retrieved_gtid_set': 'retrievedGtidSet',
            'relay_log_storage_space_used': 'relayLogStorageSpaceUsed',
            'transactions_received': 'transactionsReceived',
            'apply_delay': 'applyDelay',
            'busy_workers': 'busyWorkers',
            'fetch_error': 'fetchError',
            'apply_error': 'applyError'
        }
        self._source_host = None
        self._source_port = None
        self._fetch_status = None
        self._apply_status = None
        self._desired_delay_seconds = None
        self._remaining_delay_seconds = None
        self._channel_name = None
        self._source_uuid = None
        self._source_server_id = None
        self._gtid_assignment = None
        self._applier_filters = None
        self._seconds_behind_source = None
        self._retrieved_gtid_set = None
        self._relay_log_storage_space_used = None
        self._transactions_received = None
        self._apply_delay = None
        self._busy_workers = None
        self._fetch_error = None
        self._apply_error = None

    @property
    def source_host(self):
        """
        **[Required]** Gets the source_host of this ManagedMySqlDatabaseInboundReplicationSummary.
        The host name or IP address of the source this replica is connected to.


        :return: The source_host of this ManagedMySqlDatabaseInboundReplicationSummary.
        :rtype: str
        """
        return self._source_host

    @source_host.setter
    def source_host(self, source_host):
        """
        Sets the source_host of this ManagedMySqlDatabaseInboundReplicationSummary.
        The host name or IP address of the source this replica is connected to.


        :param source_host: The source_host of this ManagedMySqlDatabaseInboundReplicationSummary.
        :type: str
        """
        self._source_host = source_host

    @property
    def source_port(self):
        """
        **[Required]** Gets the source_port of this ManagedMySqlDatabaseInboundReplicationSummary.
        The port used to connect to the source.


        :return: The source_port of this ManagedMySqlDatabaseInboundReplicationSummary.
        :rtype: int
        """
        return self._source_port

    @source_port.setter
    def source_port(self, source_port):
        """
        Sets the source_port of this ManagedMySqlDatabaseInboundReplicationSummary.
        The port used to connect to the source.


        :param source_port: The source_port of this ManagedMySqlDatabaseInboundReplicationSummary.
        :type: int
        """
        self._source_port = source_port

    @property
    def fetch_status(self):
        """
        Gets the fetch_status of this ManagedMySqlDatabaseInboundReplicationSummary.
        The current status of fetch operations.


        :return: The fetch_status of this ManagedMySqlDatabaseInboundReplicationSummary.
        :rtype: str
        """
        return self._fetch_status

    @fetch_status.setter
    def fetch_status(self, fetch_status):
        """
        Sets the fetch_status of this ManagedMySqlDatabaseInboundReplicationSummary.
        The current status of fetch operations.


        :param fetch_status: The fetch_status of this ManagedMySqlDatabaseInboundReplicationSummary.
        :type: str
        """
        self._fetch_status = fetch_status

    @property
    def apply_status(self):
        """
        Gets the apply_status of this ManagedMySqlDatabaseInboundReplicationSummary.
        The current status of apply operations.


        :return: The apply_status of this ManagedMySqlDatabaseInboundReplicationSummary.
        :rtype: str
        """
        return self._apply_status

    @apply_status.setter
    def apply_status(self, apply_status):
        """
        Sets the apply_status of this ManagedMySqlDatabaseInboundReplicationSummary.
        The current status of apply operations.


        :param apply_status: The apply_status of this ManagedMySqlDatabaseInboundReplicationSummary.
        :type: str
        """
        self._apply_status = apply_status

    @property
    def desired_delay_seconds(self):
        """
        Gets the desired_delay_seconds of this ManagedMySqlDatabaseInboundReplicationSummary.
        The desired number of seconds that the replica must lag the source.


        :return: The desired_delay_seconds of this ManagedMySqlDatabaseInboundReplicationSummary.
        :rtype: int
        """
        return self._desired_delay_seconds

    @desired_delay_seconds.setter
    def desired_delay_seconds(self, desired_delay_seconds):
        """
        Sets the desired_delay_seconds of this ManagedMySqlDatabaseInboundReplicationSummary.
        The desired number of seconds that the replica must lag the source.


        :param desired_delay_seconds: The desired_delay_seconds of this ManagedMySqlDatabaseInboundReplicationSummary.
        :type: int
        """
        self._desired_delay_seconds = desired_delay_seconds

    @property
    def remaining_delay_seconds(self):
        """
        Gets the remaining_delay_seconds of this ManagedMySqlDatabaseInboundReplicationSummary.
        If the replica is waiting for the desired delay seconds to pass since the source applied an event, this field contains the number of delay seconds remaining.


        :return: The remaining_delay_seconds of this ManagedMySqlDatabaseInboundReplicationSummary.
        :rtype: int
        """
        return self._remaining_delay_seconds

    @remaining_delay_seconds.setter
    def remaining_delay_seconds(self, remaining_delay_seconds):
        """
        Sets the remaining_delay_seconds of this ManagedMySqlDatabaseInboundReplicationSummary.
        If the replica is waiting for the desired delay seconds to pass since the source applied an event, this field contains the number of delay seconds remaining.


        :param remaining_delay_seconds: The remaining_delay_seconds of this ManagedMySqlDatabaseInboundReplicationSummary.
        :type: int
        """
        self._remaining_delay_seconds = remaining_delay_seconds

    @property
    def channel_name(self):
        """
        Gets the channel_name of this ManagedMySqlDatabaseInboundReplicationSummary.
        The name of the replication channel.


        :return: The channel_name of this ManagedMySqlDatabaseInboundReplicationSummary.
        :rtype: str
        """
        return self._channel_name

    @channel_name.setter
    def channel_name(self, channel_name):
        """
        Sets the channel_name of this ManagedMySqlDatabaseInboundReplicationSummary.
        The name of the replication channel.


        :param channel_name: The channel_name of this ManagedMySqlDatabaseInboundReplicationSummary.
        :type: str
        """
        self._channel_name = channel_name

    @property
    def source_uuid(self):
        """
        **[Required]** Gets the source_uuid of this ManagedMySqlDatabaseInboundReplicationSummary.
        The Universally Unique Identifier (UUID) value from the source server.


        :return: The source_uuid of this ManagedMySqlDatabaseInboundReplicationSummary.
        :rtype: str
        """
        return self._source_uuid

    @source_uuid.setter
    def source_uuid(self, source_uuid):
        """
        Sets the source_uuid of this ManagedMySqlDatabaseInboundReplicationSummary.
        The Universally Unique Identifier (UUID) value from the source server.


        :param source_uuid: The source_uuid of this ManagedMySqlDatabaseInboundReplicationSummary.
        :type: str
        """
        self._source_uuid = source_uuid

    @property
    def source_server_id(self):
        """
        Gets the source_server_id of this ManagedMySqlDatabaseInboundReplicationSummary.
        The server ID value from the source server.


        :return: The source_server_id of this ManagedMySqlDatabaseInboundReplicationSummary.
        :rtype: int
        """
        return self._source_server_id

    @source_server_id.setter
    def source_server_id(self, source_server_id):
        """
        Sets the source_server_id of this ManagedMySqlDatabaseInboundReplicationSummary.
        The server ID value from the source server.


        :param source_server_id: The source_server_id of this ManagedMySqlDatabaseInboundReplicationSummary.
        :type: int
        """
        self._source_server_id = source_server_id

    @property
    def gtid_assignment(self):
        """
        Gets the gtid_assignment of this ManagedMySqlDatabaseInboundReplicationSummary.
        Indicates whether the channel assigns global transaction identifiers (GTIDs) to anonymous replicated transactions. OFF means no GTIDs are assigned. LOCAL means a GTID is assigned that includes this replica's own universally unique identifier (UUID). A UUID as value indicates that a GTID is assigned, which includes that manually set UUID value.


        :return: The gtid_assignment of this ManagedMySqlDatabaseInboundReplicationSummary.
        :rtype: str
        """
        return self._gtid_assignment

    @gtid_assignment.setter
    def gtid_assignment(self, gtid_assignment):
        """
        Sets the gtid_assignment of this ManagedMySqlDatabaseInboundReplicationSummary.
        Indicates whether the channel assigns global transaction identifiers (GTIDs) to anonymous replicated transactions. OFF means no GTIDs are assigned. LOCAL means a GTID is assigned that includes this replica's own universally unique identifier (UUID). A UUID as value indicates that a GTID is assigned, which includes that manually set UUID value.


        :param gtid_assignment: The gtid_assignment of this ManagedMySqlDatabaseInboundReplicationSummary.
        :type: str
        """
        self._gtid_assignment = gtid_assignment

    @property
    def applier_filters(self):
        """
        Gets the applier_filters of this ManagedMySqlDatabaseInboundReplicationSummary.
        A list of MySqlReplicationApplierFilter records.


        :return: The applier_filters of this ManagedMySqlDatabaseInboundReplicationSummary.
        :rtype: list[oci.database_management.models.MySqlReplicationApplierFilter]
        """
        return self._applier_filters

    @applier_filters.setter
    def applier_filters(self, applier_filters):
        """
        Sets the applier_filters of this ManagedMySqlDatabaseInboundReplicationSummary.
        A list of MySqlReplicationApplierFilter records.


        :param applier_filters: The applier_filters of this ManagedMySqlDatabaseInboundReplicationSummary.
        :type: list[oci.database_management.models.MySqlReplicationApplierFilter]
        """
        self._applier_filters = applier_filters

    @property
    def seconds_behind_source(self):
        """
        Gets the seconds_behind_source of this ManagedMySqlDatabaseInboundReplicationSummary.
        The number of seconds the replica is behind the source server.


        :return: The seconds_behind_source of this ManagedMySqlDatabaseInboundReplicationSummary.
        :rtype: int
        """
        return self._seconds_behind_source

    @seconds_behind_source.setter
    def seconds_behind_source(self, seconds_behind_source):
        """
        Sets the seconds_behind_source of this ManagedMySqlDatabaseInboundReplicationSummary.
        The number of seconds the replica is behind the source server.


        :param seconds_behind_source: The seconds_behind_source of this ManagedMySqlDatabaseInboundReplicationSummary.
        :type: int
        """
        self._seconds_behind_source = seconds_behind_source

    @property
    def retrieved_gtid_set(self):
        """
        Gets the retrieved_gtid_set of this ManagedMySqlDatabaseInboundReplicationSummary.
        The set of global transaction IDs corresponding to all transactions received by this replica from the source server. Empty if GTIDs are not in use.


        :return: The retrieved_gtid_set of this ManagedMySqlDatabaseInboundReplicationSummary.
        :rtype: str
        """
        return self._retrieved_gtid_set

    @retrieved_gtid_set.setter
    def retrieved_gtid_set(self, retrieved_gtid_set):
        """
        Sets the retrieved_gtid_set of this ManagedMySqlDatabaseInboundReplicationSummary.
        The set of global transaction IDs corresponding to all transactions received by this replica from the source server. Empty if GTIDs are not in use.


        :param retrieved_gtid_set: The retrieved_gtid_set of this ManagedMySqlDatabaseInboundReplicationSummary.
        :type: str
        """
        self._retrieved_gtid_set = retrieved_gtid_set

    @property
    def relay_log_storage_space_used(self):
        """
        Gets the relay_log_storage_space_used of this ManagedMySqlDatabaseInboundReplicationSummary.
        The total size in bytes of all the existing relay log files pertaining to this channel.


        :return: The relay_log_storage_space_used of this ManagedMySqlDatabaseInboundReplicationSummary.
        :rtype: int
        """
        return self._relay_log_storage_space_used

    @relay_log_storage_space_used.setter
    def relay_log_storage_space_used(self, relay_log_storage_space_used):
        """
        Sets the relay_log_storage_space_used of this ManagedMySqlDatabaseInboundReplicationSummary.
        The total size in bytes of all the existing relay log files pertaining to this channel.


        :param relay_log_storage_space_used: The relay_log_storage_space_used of this ManagedMySqlDatabaseInboundReplicationSummary.
        :type: int
        """
        self._relay_log_storage_space_used = relay_log_storage_space_used

    @property
    def transactions_received(self):
        """
        Gets the transactions_received of this ManagedMySqlDatabaseInboundReplicationSummary.
        The number of transactions received by this replica from the source server.


        :return: The transactions_received of this ManagedMySqlDatabaseInboundReplicationSummary.
        :rtype: int
        """
        return self._transactions_received

    @transactions_received.setter
    def transactions_received(self, transactions_received):
        """
        Sets the transactions_received of this ManagedMySqlDatabaseInboundReplicationSummary.
        The number of transactions received by this replica from the source server.


        :param transactions_received: The transactions_received of this ManagedMySqlDatabaseInboundReplicationSummary.
        :type: int
        """
        self._transactions_received = transactions_received

    @property
    def apply_delay(self):
        """
        Gets the apply_delay of this ManagedMySqlDatabaseInboundReplicationSummary.
        The time in seconds that the current transaction took between being committed on the source and being applied on the replica.


        :return: The apply_delay of this ManagedMySqlDatabaseInboundReplicationSummary.
        :rtype: float
        """
        return self._apply_delay

    @apply_delay.setter
    def apply_delay(self, apply_delay):
        """
        Sets the apply_delay of this ManagedMySqlDatabaseInboundReplicationSummary.
        The time in seconds that the current transaction took between being committed on the source and being applied on the replica.


        :param apply_delay: The apply_delay of this ManagedMySqlDatabaseInboundReplicationSummary.
        :type: float
        """
        self._apply_delay = apply_delay

    @property
    def busy_workers(self):
        """
        Gets the busy_workers of this ManagedMySqlDatabaseInboundReplicationSummary.
        The number of workers currently busy applying transactions from the source server.


        :return: The busy_workers of this ManagedMySqlDatabaseInboundReplicationSummary.
        :rtype: int
        """
        return self._busy_workers

    @busy_workers.setter
    def busy_workers(self, busy_workers):
        """
        Sets the busy_workers of this ManagedMySqlDatabaseInboundReplicationSummary.
        The number of workers currently busy applying transactions from the source server.


        :param busy_workers: The busy_workers of this ManagedMySqlDatabaseInboundReplicationSummary.
        :type: int
        """
        self._busy_workers = busy_workers

    @property
    def fetch_error(self):
        """
        Gets the fetch_error of this ManagedMySqlDatabaseInboundReplicationSummary.

        :return: The fetch_error of this ManagedMySqlDatabaseInboundReplicationSummary.
        :rtype: oci.database_management.models.MySqlFetchError
        """
        return self._fetch_error

    @fetch_error.setter
    def fetch_error(self, fetch_error):
        """
        Sets the fetch_error of this ManagedMySqlDatabaseInboundReplicationSummary.

        :param fetch_error: The fetch_error of this ManagedMySqlDatabaseInboundReplicationSummary.
        :type: oci.database_management.models.MySqlFetchError
        """
        self._fetch_error = fetch_error

    @property
    def apply_error(self):
        """
        Gets the apply_error of this ManagedMySqlDatabaseInboundReplicationSummary.

        :return: The apply_error of this ManagedMySqlDatabaseInboundReplicationSummary.
        :rtype: oci.database_management.models.MySqlApplyError
        """
        return self._apply_error

    @apply_error.setter
    def apply_error(self, apply_error):
        """
        Sets the apply_error of this ManagedMySqlDatabaseInboundReplicationSummary.

        :param apply_error: The apply_error of this ManagedMySqlDatabaseInboundReplicationSummary.
        :type: oci.database_management.models.MySqlApplyError
        """
        self._apply_error = apply_error

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
