# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PeerTargetDatabase(object):
    """
    The details of the peer target database in Data Safe.
    """

    #: A constant which can be used with the lifecycle_state property of a PeerTargetDatabase.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a PeerTargetDatabase.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a PeerTargetDatabase.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a PeerTargetDatabase.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    #: A constant which can be used with the lifecycle_state property of a PeerTargetDatabase.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a PeerTargetDatabase.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a PeerTargetDatabase.
    #: This constant has a value of "NEEDS_ATTENTION"
    LIFECYCLE_STATE_NEEDS_ATTENTION = "NEEDS_ATTENTION"

    #: A constant which can be used with the lifecycle_state property of a PeerTargetDatabase.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new PeerTargetDatabase object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this PeerTargetDatabase.
        :type display_name: str

        :param description:
            The value to assign to the description property of this PeerTargetDatabase.
        :type description: str

        :param key:
            The value to assign to the key property of this PeerTargetDatabase.
        :type key: int

        :param dataguard_association_id:
            The value to assign to the dataguard_association_id property of this PeerTargetDatabase.
        :type dataguard_association_id: str

        :param time_created:
            The value to assign to the time_created property of this PeerTargetDatabase.
        :type time_created: datetime

        :param role:
            The value to assign to the role property of this PeerTargetDatabase.
        :type role: str

        :param database_unique_name:
            The value to assign to the database_unique_name property of this PeerTargetDatabase.
        :type database_unique_name: str

        :param database_details:
            The value to assign to the database_details property of this PeerTargetDatabase.
        :type database_details: oci.data_safe.models.DatabaseDetails

        :param tls_config:
            The value to assign to the tls_config property of this PeerTargetDatabase.
        :type tls_config: oci.data_safe.models.TlsConfig

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this PeerTargetDatabase.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "INACTIVE", "DELETING", "DELETED", "NEEDS_ATTENTION", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this PeerTargetDatabase.
        :type lifecycle_details: str

        """
        self.swagger_types = {
            'display_name': 'str',
            'description': 'str',
            'key': 'int',
            'dataguard_association_id': 'str',
            'time_created': 'datetime',
            'role': 'str',
            'database_unique_name': 'str',
            'database_details': 'DatabaseDetails',
            'tls_config': 'TlsConfig',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'description': 'description',
            'key': 'key',
            'dataguard_association_id': 'dataguardAssociationId',
            'time_created': 'timeCreated',
            'role': 'role',
            'database_unique_name': 'databaseUniqueName',
            'database_details': 'databaseDetails',
            'tls_config': 'tlsConfig',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails'
        }
        self._display_name = None
        self._description = None
        self._key = None
        self._dataguard_association_id = None
        self._time_created = None
        self._role = None
        self._database_unique_name = None
        self._database_details = None
        self._tls_config = None
        self._lifecycle_state = None
        self._lifecycle_details = None

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this PeerTargetDatabase.
        The display name of the peer target database in Data Safe.


        :return: The display_name of this PeerTargetDatabase.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this PeerTargetDatabase.
        The display name of the peer target database in Data Safe.


        :param display_name: The display_name of this PeerTargetDatabase.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this PeerTargetDatabase.
        The description of the peer target database in Data Safe.


        :return: The description of this PeerTargetDatabase.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this PeerTargetDatabase.
        The description of the peer target database in Data Safe.


        :param description: The description of this PeerTargetDatabase.
        :type: str
        """
        self._description = description

    @property
    def key(self):
        """
        **[Required]** Gets the key of this PeerTargetDatabase.
        The secondary key assigned for the peer target database in Data Safe.


        :return: The key of this PeerTargetDatabase.
        :rtype: int
        """
        return self._key

    @key.setter
    def key(self, key):
        """
        Sets the key of this PeerTargetDatabase.
        The secondary key assigned for the peer target database in Data Safe.


        :param key: The key of this PeerTargetDatabase.
        :type: int
        """
        self._key = key

    @property
    def dataguard_association_id(self):
        """
        **[Required]** Gets the dataguard_association_id of this PeerTargetDatabase.
        The OCID of the Data Guard Association resource in which the database associated to the peer target database is considered as peer database to the primary database.


        :return: The dataguard_association_id of this PeerTargetDatabase.
        :rtype: str
        """
        return self._dataguard_association_id

    @dataguard_association_id.setter
    def dataguard_association_id(self, dataguard_association_id):
        """
        Sets the dataguard_association_id of this PeerTargetDatabase.
        The OCID of the Data Guard Association resource in which the database associated to the peer target database is considered as peer database to the primary database.


        :param dataguard_association_id: The dataguard_association_id of this PeerTargetDatabase.
        :type: str
        """
        self._dataguard_association_id = dataguard_association_id

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this PeerTargetDatabase.
        The date and time of the peer target database registration in Data Safe.


        :return: The time_created of this PeerTargetDatabase.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this PeerTargetDatabase.
        The date and time of the peer target database registration in Data Safe.


        :param time_created: The time_created of this PeerTargetDatabase.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def role(self):
        """
        Gets the role of this PeerTargetDatabase.
        Role of the database associated to the peer target database.


        :return: The role of this PeerTargetDatabase.
        :rtype: str
        """
        return self._role

    @role.setter
    def role(self, role):
        """
        Sets the role of this PeerTargetDatabase.
        Role of the database associated to the peer target database.


        :param role: The role of this PeerTargetDatabase.
        :type: str
        """
        self._role = role

    @property
    def database_unique_name(self):
        """
        Gets the database_unique_name of this PeerTargetDatabase.
        Unique name of the database associated to the peer target database.


        :return: The database_unique_name of this PeerTargetDatabase.
        :rtype: str
        """
        return self._database_unique_name

    @database_unique_name.setter
    def database_unique_name(self, database_unique_name):
        """
        Sets the database_unique_name of this PeerTargetDatabase.
        Unique name of the database associated to the peer target database.


        :param database_unique_name: The database_unique_name of this PeerTargetDatabase.
        :type: str
        """
        self._database_unique_name = database_unique_name

    @property
    def database_details(self):
        """
        **[Required]** Gets the database_details of this PeerTargetDatabase.

        :return: The database_details of this PeerTargetDatabase.
        :rtype: oci.data_safe.models.DatabaseDetails
        """
        return self._database_details

    @database_details.setter
    def database_details(self, database_details):
        """
        Sets the database_details of this PeerTargetDatabase.

        :param database_details: The database_details of this PeerTargetDatabase.
        :type: oci.data_safe.models.DatabaseDetails
        """
        self._database_details = database_details

    @property
    def tls_config(self):
        """
        Gets the tls_config of this PeerTargetDatabase.

        :return: The tls_config of this PeerTargetDatabase.
        :rtype: oci.data_safe.models.TlsConfig
        """
        return self._tls_config

    @tls_config.setter
    def tls_config(self, tls_config):
        """
        Sets the tls_config of this PeerTargetDatabase.

        :param tls_config: The tls_config of this PeerTargetDatabase.
        :type: oci.data_safe.models.TlsConfig
        """
        self._tls_config = tls_config

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this PeerTargetDatabase.
        The current state of the peer target database in Data Safe.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "INACTIVE", "DELETING", "DELETED", "NEEDS_ATTENTION", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this PeerTargetDatabase.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this PeerTargetDatabase.
        The current state of the peer target database in Data Safe.


        :param lifecycle_state: The lifecycle_state of this PeerTargetDatabase.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "INACTIVE", "DELETING", "DELETED", "NEEDS_ATTENTION", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this PeerTargetDatabase.
        Details about the current state of the peer target database in Data Safe.


        :return: The lifecycle_details of this PeerTargetDatabase.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this PeerTargetDatabase.
        Details about the current state of the peer target database in Data Safe.


        :param lifecycle_details: The lifecycle_details of this PeerTargetDatabase.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
