# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class StartClusterShapeConfigs(object):
    """
    The shape configuration to be used to start the cluster. If the value is not set, the start cluster operation will try to start the cluster as is.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new StartClusterShapeConfigs object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param node_type_shape_configs:
            The value to assign to the node_type_shape_configs property of this StartClusterShapeConfigs.
        :type node_type_shape_configs: list[oci.bds.models.NodeTypeShapeConfig]

        """
        self.swagger_types = {
            'node_type_shape_configs': 'list[NodeTypeShapeConfig]'
        }
        self.attribute_map = {
            'node_type_shape_configs': 'nodeTypeShapeConfigs'
        }
        self._node_type_shape_configs = None

    @property
    def node_type_shape_configs(self):
        """
        **[Required]** Gets the node_type_shape_configs of this StartClusterShapeConfigs.
        Shape configurations for each node type.


        :return: The node_type_shape_configs of this StartClusterShapeConfigs.
        :rtype: list[oci.bds.models.NodeTypeShapeConfig]
        """
        return self._node_type_shape_configs

    @node_type_shape_configs.setter
    def node_type_shape_configs(self, node_type_shape_configs):
        """
        Sets the node_type_shape_configs of this StartClusterShapeConfigs.
        Shape configurations for each node type.


        :param node_type_shape_configs: The node_type_shape_configs of this StartClusterShapeConfigs.
        :type: list[oci.bds.models.NodeTypeShapeConfig]
        """
        self._node_type_shape_configs = node_type_shape_configs

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
