/* Machine generated file -- Do NOT edit */

#include <afsconfig.h>
#include <afs/param.h>
#include <roken.h>
#include <afs/opr.h>
#ifdef AFS_PTHREAD_ENV
# include <opr/lock.h>
#endif
#include "ptint.h"

#define PR_SF_ALLBITS 0xff /* set all access bits */
#define PR_SF_NGROUPS (1u<<31) /* set field limiting group creation */
#define PR_SF_NUSERS (1u<<30) /*  "  "  foreign users  "  */
int PR_INewEntry(struct rx_connection *z_conn,const char * name,afs_int32 id,afs_int32 oid)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 500;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_string(&z_xdrs, (char **) &name, PR_MAXNAMELEN))
	     || (!xdr_afs_int32(&z_xdrs, &id))
	     || (!xdr_afs_int32(&z_xdrs, &oid))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, PR_STATINDEX,
		0, PR_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_PR_INewEntry(struct ubik_client *aclient, afs_int32 aflags,const char * name,afs_int32 id,afs_int32 oid)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = PR_INewEntry(tc
, name, id, oid);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int PR_WhereIsIt(struct rx_connection *z_conn,afs_int32 id,afs_int32 * ps)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 501;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_afs_int32(&z_xdrs, &id))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_afs_int32(&z_xdrs, ps))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, PR_STATINDEX,
		1, PR_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_PR_WhereIsIt(struct ubik_client *aclient, afs_int32 aflags,afs_int32 id,afs_int32 * ps)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = PR_WhereIsIt(tc
, id, ps);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int PR_DumpEntry(struct rx_connection *z_conn,afs_int32 pos,struct prdebugentry * entry)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 502;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_afs_int32(&z_xdrs, &pos))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_prdebugentry(&z_xdrs, entry))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, PR_STATINDEX,
		2, PR_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_PR_DumpEntry(struct ubik_client *aclient, afs_int32 aflags,afs_int32 pos,struct prdebugentry * entry)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = PR_DumpEntry(tc
, pos, entry);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int PR_AddToGroup(struct rx_connection *z_conn,afs_int32 uid,afs_int32 gid)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 503;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_afs_int32(&z_xdrs, &uid))
	     || (!xdr_afs_int32(&z_xdrs, &gid))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, PR_STATINDEX,
		3, PR_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_PR_AddToGroup(struct ubik_client *aclient, afs_int32 aflags,afs_int32 uid,afs_int32 gid)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = PR_AddToGroup(tc
, uid, gid);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int PR_NameToID(struct rx_connection *z_conn,namelist * nlist,idlist * ilist)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 504;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_namelist(&z_xdrs, nlist))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_idlist(&z_xdrs, ilist))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, PR_STATINDEX,
		4, PR_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_PR_NameToID(struct ubik_client *aclient, afs_int32 aflags,namelist * nlist,idlist * ilist)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = PR_NameToID(tc
, nlist, ilist);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int PR_IDToName(struct rx_connection *z_conn,idlist * ilist,namelist * nlist)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 505;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_idlist(&z_xdrs, ilist))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_namelist(&z_xdrs, nlist))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, PR_STATINDEX,
		5, PR_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_PR_IDToName(struct ubik_client *aclient, afs_int32 aflags,idlist * ilist,namelist * nlist)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = PR_IDToName(tc
, ilist, nlist);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int PR_Delete(struct rx_connection *z_conn,afs_int32 id)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 506;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_afs_int32(&z_xdrs, &id))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, PR_STATINDEX,
		6, PR_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_PR_Delete(struct ubik_client *aclient, afs_int32 aflags,afs_int32 id)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = PR_Delete(tc
, id);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int PR_RemoveFromGroup(struct rx_connection *z_conn,afs_int32 id,afs_int32 gid)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 507;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_afs_int32(&z_xdrs, &id))
	     || (!xdr_afs_int32(&z_xdrs, &gid))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, PR_STATINDEX,
		7, PR_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_PR_RemoveFromGroup(struct ubik_client *aclient, afs_int32 aflags,afs_int32 id,afs_int32 gid)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = PR_RemoveFromGroup(tc
, id, gid);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int PR_GetCPS(struct rx_connection *z_conn,afs_int32 id,prlist * elist,afs_int32 * over)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 508;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_afs_int32(&z_xdrs, &id))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_prlist(&z_xdrs, elist))
	     || (!xdr_afs_int32(&z_xdrs, over))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, PR_STATINDEX,
		8, PR_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_PR_GetCPS(struct ubik_client *aclient, afs_int32 aflags,afs_int32 id,prlist * elist,afs_int32 * over)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = PR_GetCPS(tc
, id, elist, over);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int PR_NewEntry(struct rx_connection *z_conn,const char * name,afs_int32 flag,afs_int32 oid,afs_int32 * id)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 509;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_string(&z_xdrs, (char **) &name, PR_MAXNAMELEN))
	     || (!xdr_afs_int32(&z_xdrs, &flag))
	     || (!xdr_afs_int32(&z_xdrs, &oid))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_afs_int32(&z_xdrs, id))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, PR_STATINDEX,
		9, PR_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_PR_NewEntry(struct ubik_client *aclient, afs_int32 aflags,const char * name,afs_int32 flag,afs_int32 oid,afs_int32 * id)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = PR_NewEntry(tc
, name, flag, oid, id);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int PR_ListMax(struct rx_connection *z_conn,afs_int32 * uid,afs_int32 * gid)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 510;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_afs_int32(&z_xdrs, uid))
	     || (!xdr_afs_int32(&z_xdrs, gid))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, PR_STATINDEX,
		10, PR_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_PR_ListMax(struct ubik_client *aclient, afs_int32 aflags,afs_int32 * uid,afs_int32 * gid)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = PR_ListMax(tc
, uid, gid);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int PR_SetMax(struct rx_connection *z_conn,afs_int32 id,afs_int32 gflag)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 511;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_afs_int32(&z_xdrs, &id))
	     || (!xdr_afs_int32(&z_xdrs, &gflag))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, PR_STATINDEX,
		11, PR_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_PR_SetMax(struct ubik_client *aclient, afs_int32 aflags,afs_int32 id,afs_int32 gflag)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = PR_SetMax(tc
, id, gflag);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int PR_ListEntry(struct rx_connection *z_conn,afs_int32 id,struct prcheckentry * entry)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 512;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_afs_int32(&z_xdrs, &id))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_prcheckentry(&z_xdrs, entry))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, PR_STATINDEX,
		12, PR_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_PR_ListEntry(struct ubik_client *aclient, afs_int32 aflags,afs_int32 id,struct prcheckentry * entry)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = PR_ListEntry(tc
, id, entry);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int PR_ChangeEntry(struct rx_connection *z_conn,afs_int32 id,const char * name,afs_int32 oid,afs_int32 newid)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 513;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_afs_int32(&z_xdrs, &id))
	     || (!xdr_string(&z_xdrs, (char **) &name, PR_MAXNAMELEN))
	     || (!xdr_afs_int32(&z_xdrs, &oid))
	     || (!xdr_afs_int32(&z_xdrs, &newid))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, PR_STATINDEX,
		13, PR_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_PR_ChangeEntry(struct ubik_client *aclient, afs_int32 aflags,afs_int32 id,const char * name,afs_int32 oid,afs_int32 newid)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = PR_ChangeEntry(tc
, id, name, oid, newid);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int PR_ListElements(struct rx_connection *z_conn,afs_int32 id,prlist * elist,afs_int32 * over)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 514;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_afs_int32(&z_xdrs, &id))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_prlist(&z_xdrs, elist))
	     || (!xdr_afs_int32(&z_xdrs, over))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, PR_STATINDEX,
		14, PR_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_PR_ListElements(struct ubik_client *aclient, afs_int32 aflags,afs_int32 id,prlist * elist,afs_int32 * over)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = PR_ListElements(tc
, id, elist, over);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int PR_IsAMemberOf(struct rx_connection *z_conn,afs_int32 uid,afs_int32 gid,afs_int32 * flag)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 515;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_afs_int32(&z_xdrs, &uid))
	     || (!xdr_afs_int32(&z_xdrs, &gid))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_afs_int32(&z_xdrs, flag))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, PR_STATINDEX,
		15, PR_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_PR_IsAMemberOf(struct ubik_client *aclient, afs_int32 aflags,afs_int32 uid,afs_int32 gid,afs_int32 * flag)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = PR_IsAMemberOf(tc
, uid, gid, flag);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int PR_SetFieldsEntry(struct rx_connection *z_conn,afs_int32 id,afs_int32 mask,afs_int32 flags,afs_int32 ngroups,afs_int32 nusers,afs_int32 spare1,afs_int32 spare2)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 516;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_afs_int32(&z_xdrs, &id))
	     || (!xdr_afs_int32(&z_xdrs, &mask))
	     || (!xdr_afs_int32(&z_xdrs, &flags))
	     || (!xdr_afs_int32(&z_xdrs, &ngroups))
	     || (!xdr_afs_int32(&z_xdrs, &nusers))
	     || (!xdr_afs_int32(&z_xdrs, &spare1))
	     || (!xdr_afs_int32(&z_xdrs, &spare2))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, PR_STATINDEX,
		16, PR_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_PR_SetFieldsEntry(struct ubik_client *aclient, afs_int32 aflags,afs_int32 id,afs_int32 mask,afs_int32 flags,afs_int32 ngroups,afs_int32 nusers,afs_int32 spare1,afs_int32 spare2)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = PR_SetFieldsEntry(tc
, id, mask, flags, ngroups, nusers, spare1, spare2);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int PR_ListOwned(struct rx_connection *z_conn,afs_int32 id,prlist * elist,afs_int32 * lastp)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 517;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_afs_int32(&z_xdrs, &id))
	     || (!xdr_afs_int32(&z_xdrs, lastp))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_prlist(&z_xdrs, elist))
	     || (!xdr_afs_int32(&z_xdrs, lastp))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, PR_STATINDEX,
		17, PR_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_PR_ListOwned(struct ubik_client *aclient, afs_int32 aflags,afs_int32 id,prlist * elist,afs_int32 * lastp)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = PR_ListOwned(tc
, id, elist, lastp);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int PR_GetCPS2(struct rx_connection *z_conn,afs_int32 id,afs_int32 host,prlist * elist,afs_int32 * over)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 518;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_afs_int32(&z_xdrs, &id))
	     || (!xdr_afs_int32(&z_xdrs, &host))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_prlist(&z_xdrs, elist))
	     || (!xdr_afs_int32(&z_xdrs, over))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, PR_STATINDEX,
		18, PR_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_PR_GetCPS2(struct ubik_client *aclient, afs_int32 aflags,afs_int32 id,afs_int32 host,prlist * elist,afs_int32 * over)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = PR_GetCPS2(tc
, id, host, elist, over);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int PR_GetHostCPS(struct rx_connection *z_conn,afs_int32 host,prlist * elist,afs_int32 * over)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 519;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_afs_int32(&z_xdrs, &host))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_prlist(&z_xdrs, elist))
	     || (!xdr_afs_int32(&z_xdrs, over))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, PR_STATINDEX,
		19, PR_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_PR_GetHostCPS(struct ubik_client *aclient, afs_int32 aflags,afs_int32 host,prlist * elist,afs_int32 * over)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = PR_GetHostCPS(tc
, host, elist, over);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int PR_UpdateEntry(struct rx_connection *z_conn,afs_int32 id,const char * name,PrUpdateEntry * uentry)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 520;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_afs_int32(&z_xdrs, &id))
	     || (!xdr_string(&z_xdrs, (char **) &name, PR_MAXNAMELEN))
	     || (!xdr_PrUpdateEntry(&z_xdrs, uentry))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, PR_STATINDEX,
		20, PR_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_PR_UpdateEntry(struct ubik_client *aclient, afs_int32 aflags,afs_int32 id,const char * name,PrUpdateEntry * uentry)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = PR_UpdateEntry(tc
, id, name, uentry);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int PR_ListEntries(struct rx_connection *z_conn,afs_int32 flags,afs_int32 startindex,prentries * bulkentries,afs_int32 * nextstartindex)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 521;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_afs_int32(&z_xdrs, &flags))
	     || (!xdr_afs_int32(&z_xdrs, &startindex))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_prentries(&z_xdrs, bulkentries))
	     || (!xdr_afs_int32(&z_xdrs, nextstartindex))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, PR_STATINDEX,
		21, PR_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_PR_ListEntries(struct ubik_client *aclient, afs_int32 aflags,afs_int32 flags,afs_int32 startindex,prentries * bulkentries,afs_int32 * nextstartindex)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = PR_ListEntries(tc
, flags, startindex, bulkentries, nextstartindex);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int PR_ListSuperGroups(struct rx_connection *z_conn,afs_int32 id,prlist * elist,afs_int32 * over)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 530;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_afs_int32(&z_xdrs, &id))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_prlist(&z_xdrs, elist))
	     || (!xdr_afs_int32(&z_xdrs, over))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, PR_STATINDEX,
		22, PR_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_PR_ListSuperGroups(struct ubik_client *aclient, afs_int32 aflags,afs_int32 id,prlist * elist,afs_int32 * over)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = PR_ListSuperGroups(tc
, id, elist, over);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

