/* Machine generated file -- Do NOT edit */

#include <afsconfig.h>
#include <afs/param.h>
#include <roken.h>
#include <afs/opr.h>
#ifdef AFS_PTHREAD_ENV
# include <opr/lock.h>
#endif
#include "vldbint.h"

#include <afs/vl_opcodes.h> /* directly to other places */
#ifdef KERNEL
#define afs_xdr_array(a,b,c,d,e,f) afs_xdr_arrayN(a,b,c,d,e,f)
#endif
#define VldbVersion "4"
#define VLOP_ADDSITE VLOP_DELETE
#define VLOP_RESTORE VLOP_DUMP
#define VLOP_ALLOPERS ( VLOP_MOVE | VLOP_RELEASE | VLOP_BACKUP | VLOP_DELETE | VLOP_DUMP)
#define VLF_RWEXISTS 0x1000 /* flags for whole vldb entry */
#define VLF_ROEXISTS 0x2000
#define VLF_BACKEXISTS 0x4000
#define VLF_DFSFILESET 0x8000 /* Volume is really DFS fileset */
#define VLSF_NEWREPSITE 0x01 /* flags for indiv. server entry */
#define VLSF_ROVOL 0x02
#define VLSF_RWVOL 0x04
#define VLSF_BACKVOL 0x08
#define VLSF_UUID 0x10
#define VLSF_DONTUSE 0x20
#define VLSF_RWREPLICA 0x40 /* Volume is a RW replica */
int VL_ProbeServer(struct rx_connection *z_conn)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 514;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, VL_STATINDEX,
		0, VL_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_VL_ProbeServer(struct ubik_client *aclient, afs_int32 aflags)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = VL_ProbeServer(tc
);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int StartVL_ProbeServer(struct rx_call *z_call)
{
	static int z_op = 514;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	return z_result;
}

int EndVL_ProbeServer(struct rx_call *z_call)
{
	int z_result;
	z_result = RXGEN_SUCCESS;
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, VL_STATINDEX,
		0, VL_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int VL_GetEntryByNameO(struct rx_connection *z_conn,const char * volumename,vldbentry * entry)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 504;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_string(&z_xdrs, (char **) &volumename, VL_MAXNAMELEN))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_vldbentry(&z_xdrs, entry))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, VL_STATINDEX,
		1, VL_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_VL_GetEntryByNameO(struct ubik_client *aclient, afs_int32 aflags,const char * volumename,vldbentry * entry)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = VL_GetEntryByNameO(tc
, volumename, entry);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int VL_GetEntryByNameN(struct rx_connection *z_conn,const char * volumename,nvldbentry * entry)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 519;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_string(&z_xdrs, (char **) &volumename, VL_MAXNAMELEN))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_nvldbentry(&z_xdrs, entry))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, VL_STATINDEX,
		2, VL_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_VL_GetEntryByNameN(struct ubik_client *aclient, afs_int32 aflags,const char * volumename,nvldbentry * entry)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = VL_GetEntryByNameN(tc
, volumename, entry);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int VL_GetEntryByNameU(struct rx_connection *z_conn,const char * volumename,uvldbentry * entry)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 527;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_string(&z_xdrs, (char **) &volumename, VL_MAXNAMELEN))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_uvldbentry(&z_xdrs, entry))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, VL_STATINDEX,
		3, VL_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_VL_GetEntryByNameU(struct ubik_client *aclient, afs_int32 aflags,const char * volumename,uvldbentry * entry)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = VL_GetEntryByNameU(tc
, volumename, entry);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int VL_GetAddrsU(struct rx_connection *z_conn,ListAddrByAttributes * inaddr,afsUUID * uuidp1,afs_int32 * uniquifier,afs_int32 * nentries,bulkaddrs * blkaddrs)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 533;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_ListAddrByAttributes(&z_xdrs, inaddr))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_afsUUID(&z_xdrs, uuidp1))
	     || (!xdr_afs_int32(&z_xdrs, uniquifier))
	     || (!xdr_afs_int32(&z_xdrs, nentries))
	     || (!xdr_bulkaddrs(&z_xdrs, blkaddrs))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, VL_STATINDEX,
		4, VL_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_VL_GetAddrsU(struct ubik_client *aclient, afs_int32 aflags,ListAddrByAttributes * inaddr,afsUUID * uuidp1,afs_int32 * uniquifier,afs_int32 * nentries,bulkaddrs * blkaddrs)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = VL_GetAddrsU(tc
, inaddr, uuidp1, uniquifier, nentries, blkaddrs);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

#if !defined(KERNEL)
int VL_CreateEntry(struct rx_connection *z_conn,vldbentry * newentry)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 501;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_vldbentry(&z_xdrs, newentry))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, VL_STATINDEX,
		5, VL_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_VL_CreateEntry(struct ubik_client *aclient, afs_int32 aflags,vldbentry * newentry)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = VL_CreateEntry(tc
, newentry);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int VL_DeleteEntry(struct rx_connection *z_conn,afs_uint32 Volid,afs_int32 voltype)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 502;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_afs_uint32(&z_xdrs, &Volid))
	     || (!xdr_afs_int32(&z_xdrs, &voltype))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, VL_STATINDEX,
		6, VL_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_VL_DeleteEntry(struct ubik_client *aclient, afs_int32 aflags,afs_uint32 Volid,afs_int32 voltype)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = VL_DeleteEntry(tc
, Volid, voltype);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int VL_GetEntryByID(struct rx_connection *z_conn,afs_uint32 Volid,afs_int32 voltype,vldbentry * entry)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 503;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_afs_uint32(&z_xdrs, &Volid))
	     || (!xdr_afs_int32(&z_xdrs, &voltype))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_vldbentry(&z_xdrs, entry))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, VL_STATINDEX,
		7, VL_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_VL_GetEntryByID(struct ubik_client *aclient, afs_int32 aflags,afs_uint32 Volid,afs_int32 voltype,vldbentry * entry)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = VL_GetEntryByID(tc
, Volid, voltype, entry);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int VL_GetNewVolumeId(struct rx_connection *z_conn,afs_uint32 bumpcount,afs_uint32 * newvolumid)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 505;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_afs_uint32(&z_xdrs, &bumpcount))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_afs_uint32(&z_xdrs, newvolumid))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, VL_STATINDEX,
		8, VL_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_VL_GetNewVolumeId(struct ubik_client *aclient, afs_int32 aflags,afs_uint32 bumpcount,afs_uint32 * newvolumid)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = VL_GetNewVolumeId(tc
, bumpcount, newvolumid);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int VL_ReplaceEntry(struct rx_connection *z_conn,afs_uint32 Volid,afs_int32 voltype,vldbentry * newentry,afs_int32 ReleaseType)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 506;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_afs_uint32(&z_xdrs, &Volid))
	     || (!xdr_afs_int32(&z_xdrs, &voltype))
	     || (!xdr_vldbentry(&z_xdrs, newentry))
	     || (!xdr_afs_int32(&z_xdrs, &ReleaseType))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, VL_STATINDEX,
		9, VL_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_VL_ReplaceEntry(struct ubik_client *aclient, afs_int32 aflags,afs_uint32 Volid,afs_int32 voltype,vldbentry * newentry,afs_int32 ReleaseType)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = VL_ReplaceEntry(tc
, Volid, voltype, newentry, ReleaseType);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int VL_UpdateEntry(struct rx_connection *z_conn,afs_uint32 Volid,afs_int32 voltype,VldbUpdateEntry * UpdateEntry,afs_int32 ReleaseType)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 507;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_afs_uint32(&z_xdrs, &Volid))
	     || (!xdr_afs_int32(&z_xdrs, &voltype))
	     || (!xdr_VldbUpdateEntry(&z_xdrs, UpdateEntry))
	     || (!xdr_afs_int32(&z_xdrs, &ReleaseType))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, VL_STATINDEX,
		10, VL_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_VL_UpdateEntry(struct ubik_client *aclient, afs_int32 aflags,afs_uint32 Volid,afs_int32 voltype,VldbUpdateEntry * UpdateEntry,afs_int32 ReleaseType)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = VL_UpdateEntry(tc
, Volid, voltype, UpdateEntry, ReleaseType);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int VL_SetLock(struct rx_connection *z_conn,afs_uint32 Volid,afs_int32 voltype,afs_int32 voloper)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 508;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_afs_uint32(&z_xdrs, &Volid))
	     || (!xdr_afs_int32(&z_xdrs, &voltype))
	     || (!xdr_afs_int32(&z_xdrs, &voloper))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, VL_STATINDEX,
		11, VL_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_VL_SetLock(struct ubik_client *aclient, afs_int32 aflags,afs_uint32 Volid,afs_int32 voltype,afs_int32 voloper)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = VL_SetLock(tc
, Volid, voltype, voloper);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int VL_ReleaseLock(struct rx_connection *z_conn,afs_uint32 Volid,afs_int32 voltype,afs_int32 ReleaseType)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 509;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_afs_uint32(&z_xdrs, &Volid))
	     || (!xdr_afs_int32(&z_xdrs, &voltype))
	     || (!xdr_afs_int32(&z_xdrs, &ReleaseType))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, VL_STATINDEX,
		12, VL_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_VL_ReleaseLock(struct ubik_client *aclient, afs_int32 aflags,afs_uint32 Volid,afs_int32 voltype,afs_int32 ReleaseType)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = VL_ReleaseLock(tc
, Volid, voltype, ReleaseType);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int VL_ListEntry(struct rx_connection *z_conn,afs_int32 previous_index,afs_int32 * count,afs_int32 * next_index,vldbentry * entry)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 510;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_afs_int32(&z_xdrs, &previous_index))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_afs_int32(&z_xdrs, count))
	     || (!xdr_afs_int32(&z_xdrs, next_index))
	     || (!xdr_vldbentry(&z_xdrs, entry))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, VL_STATINDEX,
		13, VL_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_VL_ListEntry(struct ubik_client *aclient, afs_int32 aflags,afs_int32 previous_index,afs_int32 * count,afs_int32 * next_index,vldbentry * entry)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = VL_ListEntry(tc
, previous_index, count, next_index, entry);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int VL_ListAttributes(struct rx_connection *z_conn,VldbListByAttributes * attributes,afs_int32 * nentries,bulkentries * blkentries)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 511;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_VldbListByAttributes(&z_xdrs, attributes))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_afs_int32(&z_xdrs, nentries))
	     || (!xdr_bulkentries(&z_xdrs, blkentries))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, VL_STATINDEX,
		14, VL_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_VL_ListAttributes(struct ubik_client *aclient, afs_int32 aflags,VldbListByAttributes * attributes,afs_int32 * nentries,bulkentries * blkentries)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = VL_ListAttributes(tc
, attributes, nentries, blkentries);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int VL_LinkedList(struct rx_connection *z_conn,VldbListByAttributes * attributes,afs_int32 * nentries,vldb_list * linkedentries)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 512;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_VldbListByAttributes(&z_xdrs, attributes))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_afs_int32(&z_xdrs, nentries))
	     || (!xdr_vldb_list(&z_xdrs, linkedentries))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, VL_STATINDEX,
		15, VL_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_VL_LinkedList(struct ubik_client *aclient, afs_int32 aflags,VldbListByAttributes * attributes,afs_int32 * nentries,vldb_list * linkedentries)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = VL_LinkedList(tc
, attributes, nentries, linkedentries);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int VL_GetStats(struct rx_connection *z_conn,vldstats * stats,vital_vlheader * vital_header)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 513;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_vldstats(&z_xdrs, stats))
	     || (!xdr_vital_vlheader(&z_xdrs, vital_header))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, VL_STATINDEX,
		16, VL_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_VL_GetStats(struct ubik_client *aclient, afs_int32 aflags,vldstats * stats,vital_vlheader * vital_header)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = VL_GetStats(tc
, stats, vital_header);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int VL_GetAddrs(struct rx_connection *z_conn,afs_int32 Handle,afs_int32 spare2,VLCallBack * spare3,afs_int32 * nentries,bulkaddrs * blkaddrs)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 515;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_afs_int32(&z_xdrs, &Handle))
	     || (!xdr_afs_int32(&z_xdrs, &spare2))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_VLCallBack(&z_xdrs, spare3))
	     || (!xdr_afs_int32(&z_xdrs, nentries))
	     || (!xdr_bulkaddrs(&z_xdrs, blkaddrs))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, VL_STATINDEX,
		17, VL_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_VL_GetAddrs(struct ubik_client *aclient, afs_int32 aflags,afs_int32 Handle,afs_int32 spare2,VLCallBack * spare3,afs_int32 * nentries,bulkaddrs * blkaddrs)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = VL_GetAddrs(tc
, Handle, spare2, spare3, nentries, blkaddrs);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int VL_ChangeAddr(struct rx_connection *z_conn,afs_uint32 ip1,afs_uint32 ip2)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 516;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_afs_uint32(&z_xdrs, &ip1))
	     || (!xdr_afs_uint32(&z_xdrs, &ip2))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, VL_STATINDEX,
		18, VL_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_VL_ChangeAddr(struct ubik_client *aclient, afs_int32 aflags,afs_uint32 ip1,afs_uint32 ip2)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = VL_ChangeAddr(tc
, ip1, ip2);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int VL_CreateEntryN(struct rx_connection *z_conn,nvldbentry * newentry)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 517;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_nvldbentry(&z_xdrs, newentry))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, VL_STATINDEX,
		19, VL_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_VL_CreateEntryN(struct ubik_client *aclient, afs_int32 aflags,nvldbentry * newentry)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = VL_CreateEntryN(tc
, newentry);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int VL_GetEntryByIDN(struct rx_connection *z_conn,afs_uint32 Volid,afs_int32 voltype,nvldbentry * entry)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 518;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_afs_uint32(&z_xdrs, &Volid))
	     || (!xdr_afs_int32(&z_xdrs, &voltype))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_nvldbentry(&z_xdrs, entry))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, VL_STATINDEX,
		20, VL_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_VL_GetEntryByIDN(struct ubik_client *aclient, afs_int32 aflags,afs_uint32 Volid,afs_int32 voltype,nvldbentry * entry)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = VL_GetEntryByIDN(tc
, Volid, voltype, entry);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int VL_ReplaceEntryN(struct rx_connection *z_conn,afs_uint32 Volid,afs_int32 voltype,nvldbentry * newentry,afs_int32 ReleaseType)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 520;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_afs_uint32(&z_xdrs, &Volid))
	     || (!xdr_afs_int32(&z_xdrs, &voltype))
	     || (!xdr_nvldbentry(&z_xdrs, newentry))
	     || (!xdr_afs_int32(&z_xdrs, &ReleaseType))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, VL_STATINDEX,
		21, VL_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_VL_ReplaceEntryN(struct ubik_client *aclient, afs_int32 aflags,afs_uint32 Volid,afs_int32 voltype,nvldbentry * newentry,afs_int32 ReleaseType)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = VL_ReplaceEntryN(tc
, Volid, voltype, newentry, ReleaseType);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int VL_ListEntryN(struct rx_connection *z_conn,afs_int32 previous_index,afs_int32 * count,afs_int32 * next_index,nvldbentry * entry)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 521;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_afs_int32(&z_xdrs, &previous_index))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_afs_int32(&z_xdrs, count))
	     || (!xdr_afs_int32(&z_xdrs, next_index))
	     || (!xdr_nvldbentry(&z_xdrs, entry))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, VL_STATINDEX,
		22, VL_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_VL_ListEntryN(struct ubik_client *aclient, afs_int32 aflags,afs_int32 previous_index,afs_int32 * count,afs_int32 * next_index,nvldbentry * entry)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = VL_ListEntryN(tc
, previous_index, count, next_index, entry);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int VL_ListAttributesN(struct rx_connection *z_conn,VldbListByAttributes * attributes,afs_int32 * nentries,nbulkentries * blkentries)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 522;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_VldbListByAttributes(&z_xdrs, attributes))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_afs_int32(&z_xdrs, nentries))
	     || (!xdr_nbulkentries(&z_xdrs, blkentries))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, VL_STATINDEX,
		23, VL_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_VL_ListAttributesN(struct ubik_client *aclient, afs_int32 aflags,VldbListByAttributes * attributes,afs_int32 * nentries,nbulkentries * blkentries)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = VL_ListAttributesN(tc
, attributes, nentries, blkentries);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int VL_LinkedListN(struct rx_connection *z_conn,VldbListByAttributes * attributes,afs_int32 * nentries,nvldb_list * linkedentries)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 523;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_VldbListByAttributes(&z_xdrs, attributes))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_afs_int32(&z_xdrs, nentries))
	     || (!xdr_nvldb_list(&z_xdrs, linkedentries))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, VL_STATINDEX,
		24, VL_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_VL_LinkedListN(struct ubik_client *aclient, afs_int32 aflags,VldbListByAttributes * attributes,afs_int32 * nentries,nvldb_list * linkedentries)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = VL_LinkedListN(tc
, attributes, nentries, linkedentries);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int VL_UpdateEntryByName(struct rx_connection *z_conn,const char * volumename,VldbUpdateEntry * UpdateEntry,afs_int32 ReleaseType)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 524;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_string(&z_xdrs, (char **) &volumename, VL_MAXNAMELEN))
	     || (!xdr_VldbUpdateEntry(&z_xdrs, UpdateEntry))
	     || (!xdr_afs_int32(&z_xdrs, &ReleaseType))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, VL_STATINDEX,
		25, VL_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_VL_UpdateEntryByName(struct ubik_client *aclient, afs_int32 aflags,const char * volumename,VldbUpdateEntry * UpdateEntry,afs_int32 ReleaseType)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = VL_UpdateEntryByName(tc
, volumename, UpdateEntry, ReleaseType);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int VL_RegisterAddrs(struct rx_connection *z_conn,afsUUID * uuidp,afs_int32 spare1,bulkaddrs * ipaddr)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 532;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_afsUUID(&z_xdrs, uuidp))
	     || (!xdr_afs_int32(&z_xdrs, &spare1))
	     || (!xdr_bulkaddrs(&z_xdrs, ipaddr))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, VL_STATINDEX,
		26, VL_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_VL_RegisterAddrs(struct ubik_client *aclient, afs_int32 aflags,afsUUID * uuidp,afs_int32 spare1,bulkaddrs * ipaddr)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = VL_RegisterAddrs(tc
, uuidp, spare1, ipaddr);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

int VL_ListAttributesN2(struct rx_connection *z_conn,VldbListByAttributes * attributes,const char * volumename,afs_int32 startindex,afs_int32 * nentries,nbulkentries * blkentries,afs_int32 * nextstartindex)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 534;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_VldbListByAttributes(&z_xdrs, attributes))
	     || (!xdr_string(&z_xdrs, (char **) &volumename, VL_MAXNAMELEN))
	     || (!xdr_afs_int32(&z_xdrs, &startindex))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_afs_int32(&z_xdrs, nentries))
	     || (!xdr_nbulkentries(&z_xdrs, blkentries))
	     || (!xdr_afs_int32(&z_xdrs, nextstartindex))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, VL_STATINDEX,
		27, VL_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int ubik_VL_ListAttributesN2(struct ubik_client *aclient, afs_int32 aflags,VldbListByAttributes * attributes,const char * volumename,afs_int32 startindex,afs_int32 * nentries,nbulkentries * blkentries,afs_int32 * nextstartindex)
{	afs_int32 rcode, code, newHost, thisHost, i, _ucount;
	int chaseCount, pass, needsync;
	struct rx_connection *tc;
	struct rx_peer *rxp;
	short origLevel;

	if (!aclient)
		return UNOENT;
	LOCK_UBIK_CLIENT(aclient);

	 restart:
	origLevel = aclient->initializationState;
	rcode = UNOSERVERS;
	chaseCount = needsync = 0;

	/* 
	* First  pass, we try all servers that are up.
	* Second pass, we try all servers.
	*/
	for (pass = 0; pass < 2; pass++) {  /*p */
		/* For each entry in our servers list */
		for (_ucount = 0;; _ucount++) {     /*s */

		if (needsync) {
			/* Need a sync site. Lets try to quickly find it */
			if (aclient->syncSite) {
				newHost = aclient->syncSite;        /* already in network order */
				aclient->syncSite = 0;      /* Will reset if it works */
			} else if (aclient->conns[3]) {
				/* If there are fewer than four db servers in a cell,
				* there's no point in making the GetSyncSite call.
				* At best, it's a wash. At worst, it results in more
				* RPCs than you would otherwise make.
				*/
				tc = aclient->conns[_ucount];
				if (tc && rx_ConnError(tc)) {
					aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
				}
				if (!tc)
					break;
				code = VOTE_GetSyncSite(tc, &newHost);
				if (aclient->initializationState != origLevel)
					goto restart;   /* somebody did a ubik_ClientInit */
				if (code)
					newHost = 0;
				newHost = htonl(newHost);   /* convert to network order */
			} else {
				newHost = 0;
			}
			if (newHost) {
				/* position count at the appropriate slot in the client
				* structure and retry. If we can't find in slot, we'll
				* just continue through the whole list 
				*/
				for (i = 0; i < MAXSERVERS && aclient->conns[i]; i++) {
					rxp = rx_PeerOf(aclient->conns[i]);
					thisHost = rx_HostOf(rxp);
					if (!thisHost)
						break;
					if (thisHost == newHost) {
						if (chaseCount++ > 2)
							break;  /* avoid loop asking */
						_ucount = i;  /* this index is the sync site */
						break;
					}
				}
			}
		}
		/*needsync */
		tc = aclient->conns[_ucount];
		if (tc && rx_ConnError(tc)) {
			aclient->conns[_ucount] = tc = ubik_RefreshConn(tc);
		}
		if (!tc)
			break;

		if ((pass == 0) && (aclient->states[_ucount] & CFLastFailed)) {
			continue;       /* this guy's down */
		}
		rcode = VL_ListAttributesN2(tc
, attributes, volumename, startindex, nentries, blkentries, nextstartindex);
		if (aclient->initializationState != origLevel) {
			/* somebody did a ubik_ClientInit */
			if (rcode)
				goto restart;       /* call failed */
			else
				goto done;  /* call suceeded */
		}
		if (rcode < 0) {    /* network errors */
			aclient->states[_ucount] |= CFLastFailed; /* Mark server down */
		} else if (rcode == UNOTSYNC) {
			needsync = 1;
		} else if (rcode != UNOQUORUM) {
			/* either misc ubik code, or misc appl code, or success. */
			aclient->states[_ucount] &= ~CFLastFailed;        /* mark server up*/
			goto done;      /* all done */
		}
		}                       /*s */
	}                           /*p */

	done:
	if (needsync) {
		if (!rcode) {           /* Remember the sync site - cmd successful */
			rxp = rx_PeerOf(aclient->conns[_ucount]);
			aclient->syncSite = rx_HostOf(rxp);
		}
	}
	UNLOCK_UBIK_CLIENT(aclient);
	return rcode;
}

#endif /* !defined(KERNEL) */
