/* Machine generated file -- Do NOT edit */

#include <afsconfig.h>
#include <afs/param.h>
#include <roken.h>
#include <afs/opr.h>
#ifdef AFS_PTHREAD_ENV
# include <opr/lock.h>
#endif
#include "afsint.h"

#ifndef FSINT_COMMON_XG
#endif /* FSINT_COMMON_XG */
#define VICECONNBAD 1234
#define VICETOKENDEAD 1235
#define AFS_LOCKWAIT (5*60)
#define Invalid 0
#define File 1
#define Directory 2
#define SymbolicLink 3
#ifdef KERNEL
#define afs_xdr_array(a,b,c,d,e,f) afs_xdr_arrayN(a,b,c,d,e,f)
#endif
#define AFS_SETMODTIME 1
#define AFS_SETOWNER 2
#define AFS_SETGROUP 4
#define AFS_SETMODE 8
#define AFS_SETSEGSIZE 16
#define AFS_FSYNC 1024
#define ReadOnly 0
#define ReadWrite 1
#define LockRead 0
#define LockWrite 1
#define LockExtend 2
#define LockRelease 3
#define NoSalvage 0
#define Salvage 1
#define MAXCMDINT64S 3
#define MAXCMDINT32S 200
#define MAXCMDCHARS 256
#define CMD_GETRESIDENCIES 1
#define CMD_CHANGERESIDENCIES 2
#define CMD_IMPORTRESIDENCIES 3
#define CMD_GETEXTVOLATTR 4
#define CMD_SETEXTVOLATTR 5
#define CMD_GETACCESSHISTORY 6
#define CMD_MIGRATEFILE 7
#define CMD_CHECKHSMMETADATA 8
#define CMD_FETCHSTATUS 9
#define VOLATTR_DESIREDRESIDENCYMASK 1
#define VOLATTR_UNDESIREDRESIDENCYMASK 2
#define VOLATTR_SETSPECIALACCESSFLAG 4
#define ResidencyCmdInputs FsCmdInputs
#define ResidencyCmdOutputs FsCmdOutputs
int StartRXAFS_FetchData(struct rx_call *z_call,AFSFid * Fid,afs_int32 Pos,afs_int32 Length)
{
	static int z_op = 130;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_AFSFid(&z_xdrs, Fid))
	     || (!xdr_afs_int32(&z_xdrs, &Pos))
	     || (!xdr_afs_int32(&z_xdrs, &Length))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	return z_result;
}

int EndRXAFS_FetchData(struct rx_call *z_call,AFSFetchStatus * OutStatus,AFSCallBack * CallBack,AFSVolSync * Sync)
{
	int z_result;
	XDR z_xdrs;
	/* Un-marshal the reply arguments */
	xdrrx_create(&z_xdrs, z_call, XDR_DECODE);
	if ((!xdr_AFSFetchStatus(&z_xdrs, OutStatus))
	     || (!xdr_AFSCallBack(&z_xdrs, CallBack))
	     || (!xdr_AFSVolSync(&z_xdrs, Sync))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, RXAFS_STATINDEX,
		0, RXAFS_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int RXAFS_FetchACL(struct rx_connection *z_conn,AFSFid * Fid,AFSOpaque * AccessList,AFSFetchStatus * OutStatus,AFSVolSync * Sync)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 131;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_AFSFid(&z_xdrs, Fid))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_AFSOpaque(&z_xdrs, AccessList))
	     || (!xdr_AFSFetchStatus(&z_xdrs, OutStatus))
	     || (!xdr_AFSVolSync(&z_xdrs, Sync))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, RXAFS_STATINDEX,
		1, RXAFS_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int RXAFS_FetchStatus(struct rx_connection *z_conn,AFSFid * Fid,AFSFetchStatus * OutStatus,AFSCallBack * CallBack,AFSVolSync * Sync)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 132;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_AFSFid(&z_xdrs, Fid))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_AFSFetchStatus(&z_xdrs, OutStatus))
	     || (!xdr_AFSCallBack(&z_xdrs, CallBack))
	     || (!xdr_AFSVolSync(&z_xdrs, Sync))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, RXAFS_STATINDEX,
		2, RXAFS_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int StartRXAFS_StoreData(struct rx_call *z_call,AFSFid * Fid,AFSStoreStatus * InStatus,afs_uint32 Pos,afs_uint32 Length,afs_uint32 FileLength)
{
	static int z_op = 133;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_AFSFid(&z_xdrs, Fid))
	     || (!xdr_AFSStoreStatus(&z_xdrs, InStatus))
	     || (!xdr_afs_uint32(&z_xdrs, &Pos))
	     || (!xdr_afs_uint32(&z_xdrs, &Length))
	     || (!xdr_afs_uint32(&z_xdrs, &FileLength))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	return z_result;
}

int EndRXAFS_StoreData(struct rx_call *z_call,AFSFetchStatus * OutStatus,AFSVolSync * Sync)
{
	int z_result;
	XDR z_xdrs;
	/* Un-marshal the reply arguments */
	xdrrx_create(&z_xdrs, z_call, XDR_DECODE);
	if ((!xdr_AFSFetchStatus(&z_xdrs, OutStatus))
	     || (!xdr_AFSVolSync(&z_xdrs, Sync))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, RXAFS_STATINDEX,
		3, RXAFS_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int RXAFS_OldStoreACL(struct rx_connection *z_conn,AFSFid * Fid,AFSOpaque * AccessList,AFSFetchStatus * OutStatus,AFSVolSync * Sync)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 134;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_AFSFid(&z_xdrs, Fid))
	     || (!xdr_AFSOpaque(&z_xdrs, AccessList))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_AFSFetchStatus(&z_xdrs, OutStatus))
	     || (!xdr_AFSVolSync(&z_xdrs, Sync))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, RXAFS_STATINDEX,
		4, RXAFS_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int RXAFS_StoreStatus(struct rx_connection *z_conn,AFSFid * Fid,AFSStoreStatus * InStatus,AFSFetchStatus * OutStatus,AFSVolSync * Sync)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 135;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_AFSFid(&z_xdrs, Fid))
	     || (!xdr_AFSStoreStatus(&z_xdrs, InStatus))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_AFSFetchStatus(&z_xdrs, OutStatus))
	     || (!xdr_AFSVolSync(&z_xdrs, Sync))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, RXAFS_STATINDEX,
		5, RXAFS_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int RXAFS_RemoveFile(struct rx_connection *z_conn,AFSFid * DirFid,const char * Name,AFSFetchStatus * OutStatus,AFSVolSync * Sync)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 136;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_AFSFid(&z_xdrs, DirFid))
	     || (!xdr_string(&z_xdrs, (char **) &Name, AFSNAMEMAX))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_AFSFetchStatus(&z_xdrs, OutStatus))
	     || (!xdr_AFSVolSync(&z_xdrs, Sync))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, RXAFS_STATINDEX,
		6, RXAFS_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int RXAFS_CreateFile(struct rx_connection *z_conn,AFSFid * DirFid,const char * Name,AFSStoreStatus * InStatus,AFSFid * OutFid,AFSFetchStatus * OutFidStatus,AFSFetchStatus * OutDirStatus,AFSCallBack * CallBack,AFSVolSync * Sync)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 137;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_AFSFid(&z_xdrs, DirFid))
	     || (!xdr_string(&z_xdrs, (char **) &Name, AFSNAMEMAX))
	     || (!xdr_AFSStoreStatus(&z_xdrs, InStatus))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_AFSFid(&z_xdrs, OutFid))
	     || (!xdr_AFSFetchStatus(&z_xdrs, OutFidStatus))
	     || (!xdr_AFSFetchStatus(&z_xdrs, OutDirStatus))
	     || (!xdr_AFSCallBack(&z_xdrs, CallBack))
	     || (!xdr_AFSVolSync(&z_xdrs, Sync))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, RXAFS_STATINDEX,
		7, RXAFS_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int RXAFS_Rename(struct rx_connection *z_conn,AFSFid * OldDirFid,const char * OldName,AFSFid * NewDirFid,const char * NewName,AFSFetchStatus * OutOldDirStatus,AFSFetchStatus * OutNewDirStatus,AFSVolSync * Sync)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 138;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_AFSFid(&z_xdrs, OldDirFid))
	     || (!xdr_string(&z_xdrs, (char **) &OldName, AFSNAMEMAX))
	     || (!xdr_AFSFid(&z_xdrs, NewDirFid))
	     || (!xdr_string(&z_xdrs, (char **) &NewName, AFSNAMEMAX))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_AFSFetchStatus(&z_xdrs, OutOldDirStatus))
	     || (!xdr_AFSFetchStatus(&z_xdrs, OutNewDirStatus))
	     || (!xdr_AFSVolSync(&z_xdrs, Sync))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, RXAFS_STATINDEX,
		8, RXAFS_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int RXAFS_Symlink(struct rx_connection *z_conn,AFSFid * DirFid,const char * Name,const char * LinkContents,AFSStoreStatus * InStatus,AFSFid * OutFid,AFSFetchStatus * OutFidStatus,AFSFetchStatus * OutDirStatus,AFSVolSync * Sync)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 139;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_AFSFid(&z_xdrs, DirFid))
	     || (!xdr_string(&z_xdrs, (char **) &Name, AFSNAMEMAX))
	     || (!xdr_string(&z_xdrs, (char **) &LinkContents, AFSPATHMAX))
	     || (!xdr_AFSStoreStatus(&z_xdrs, InStatus))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_AFSFid(&z_xdrs, OutFid))
	     || (!xdr_AFSFetchStatus(&z_xdrs, OutFidStatus))
	     || (!xdr_AFSFetchStatus(&z_xdrs, OutDirStatus))
	     || (!xdr_AFSVolSync(&z_xdrs, Sync))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, RXAFS_STATINDEX,
		9, RXAFS_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int RXAFS_Link(struct rx_connection *z_conn,AFSFid * DirFid,const char * Name,AFSFid * ExistingFid,AFSFetchStatus * OutFidStatus,AFSFetchStatus * OutDirStatus,AFSVolSync * Sync)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 140;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_AFSFid(&z_xdrs, DirFid))
	     || (!xdr_string(&z_xdrs, (char **) &Name, AFSNAMEMAX))
	     || (!xdr_AFSFid(&z_xdrs, ExistingFid))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_AFSFetchStatus(&z_xdrs, OutFidStatus))
	     || (!xdr_AFSFetchStatus(&z_xdrs, OutDirStatus))
	     || (!xdr_AFSVolSync(&z_xdrs, Sync))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, RXAFS_STATINDEX,
		10, RXAFS_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int RXAFS_MakeDir(struct rx_connection *z_conn,AFSFid * DirFid,const char * Name,AFSStoreStatus * InStatus,AFSFid * OutFid,AFSFetchStatus * OutFidStatus,AFSFetchStatus * OutDirStatus,AFSCallBack * CallBack,AFSVolSync * Sync)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 141;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_AFSFid(&z_xdrs, DirFid))
	     || (!xdr_string(&z_xdrs, (char **) &Name, AFSNAMEMAX))
	     || (!xdr_AFSStoreStatus(&z_xdrs, InStatus))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_AFSFid(&z_xdrs, OutFid))
	     || (!xdr_AFSFetchStatus(&z_xdrs, OutFidStatus))
	     || (!xdr_AFSFetchStatus(&z_xdrs, OutDirStatus))
	     || (!xdr_AFSCallBack(&z_xdrs, CallBack))
	     || (!xdr_AFSVolSync(&z_xdrs, Sync))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, RXAFS_STATINDEX,
		11, RXAFS_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int RXAFS_RemoveDir(struct rx_connection *z_conn,AFSFid * DirFid,const char * Name,AFSFetchStatus * OutDirStatus,AFSVolSync * Sync)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 142;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_AFSFid(&z_xdrs, DirFid))
	     || (!xdr_string(&z_xdrs, (char **) &Name, AFSNAMEMAX))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_AFSFetchStatus(&z_xdrs, OutDirStatus))
	     || (!xdr_AFSVolSync(&z_xdrs, Sync))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, RXAFS_STATINDEX,
		12, RXAFS_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int RXAFS_OldSetLock(struct rx_connection *z_conn,AFSFid * Fid,ViceLockType Type,AFSVolSync * Sync)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 143;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_AFSFid(&z_xdrs, Fid))
	     || (!xdr_ViceLockType(&z_xdrs, &Type))
	     || (!xdr_AFSVolSync(&z_xdrs, Sync))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, RXAFS_STATINDEX,
		13, RXAFS_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int RXAFS_OldExtendLock(struct rx_connection *z_conn,AFSFid * Fid,AFSVolSync * Sync)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 144;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_AFSFid(&z_xdrs, Fid))
	     || (!xdr_AFSVolSync(&z_xdrs, Sync))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, RXAFS_STATINDEX,
		14, RXAFS_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int RXAFS_OldReleaseLock(struct rx_connection *z_conn,AFSFid * Fid,AFSVolSync * Sync)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 145;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_AFSFid(&z_xdrs, Fid))
	     || (!xdr_AFSVolSync(&z_xdrs, Sync))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, RXAFS_STATINDEX,
		15, RXAFS_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int RXAFS_GetStatistics(struct rx_connection *z_conn,ViceStatistics * Statistics)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 146;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_ViceStatistics(&z_xdrs, Statistics))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, RXAFS_STATINDEX,
		16, RXAFS_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int RXAFS_GiveUpCallBacks(struct rx_connection *z_conn,AFSCBFids * Fids_Array,AFSCBs * CallBacks_Array)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 147;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_AFSCBFids(&z_xdrs, Fids_Array))
	     || (!xdr_AFSCBs(&z_xdrs, CallBacks_Array))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, RXAFS_STATINDEX,
		17, RXAFS_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int RXAFS_GetVolumeInfo(struct rx_connection *z_conn,const char * VolumeName,VolumeInfo * Volumeinfo)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 148;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_string(&z_xdrs, (char **) &VolumeName, AFSNAMEMAX))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_VolumeInfo(&z_xdrs, Volumeinfo))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, RXAFS_STATINDEX,
		18, RXAFS_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int RXAFS_GetVolumeStatus(struct rx_connection *z_conn,afs_int32 Volumeid,AFSFetchVolumeStatus * Volumestatus,char * *Name,char * *OfflineMsg,char * *Motd)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 149;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_afs_int32(&z_xdrs, &Volumeid))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_AFSFetchVolumeStatus(&z_xdrs, Volumestatus))
	     || (!xdr_string(&z_xdrs, Name, AFSNAMEMAX))
	     || (!xdr_string(&z_xdrs, OfflineMsg, AFSOPAQUEMAX))
	     || (!xdr_string(&z_xdrs, Motd, AFSOPAQUEMAX))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, RXAFS_STATINDEX,
		19, RXAFS_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int RXAFS_SetVolumeStatus(struct rx_connection *z_conn,afs_int32 Volumeid,AFSStoreVolumeStatus * Volumestatus,const char * Name,const char * OfflineMsg,const char * Motd)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 150;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_afs_int32(&z_xdrs, &Volumeid))
	     || (!xdr_AFSStoreVolumeStatus(&z_xdrs, Volumestatus))
	     || (!xdr_string(&z_xdrs, (char **) &Name, AFSNAMEMAX))
	     || (!xdr_string(&z_xdrs, (char **) &OfflineMsg, AFSOPAQUEMAX))
	     || (!xdr_string(&z_xdrs, (char **) &Motd, AFSOPAQUEMAX))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, RXAFS_STATINDEX,
		20, RXAFS_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int RXAFS_GetRootVolume(struct rx_connection *z_conn,char * *VolumeName)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 151;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_string(&z_xdrs, VolumeName, AFSNAMEMAX))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, RXAFS_STATINDEX,
		21, RXAFS_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int RXAFS_CheckToken(struct rx_connection *z_conn,afs_int32 ViceId,AFSOpaque * token)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 152;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_afs_int32(&z_xdrs, &ViceId))
	     || (!xdr_AFSOpaque(&z_xdrs, token))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, RXAFS_STATINDEX,
		22, RXAFS_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int RXAFS_GetTime(struct rx_connection *z_conn,afs_uint32 * Seconds,afs_uint32 * USeconds)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 153;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_afs_uint32(&z_xdrs, Seconds))
	     || (!xdr_afs_uint32(&z_xdrs, USeconds))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, RXAFS_STATINDEX,
		23, RXAFS_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int StartRXAFS_GetTime(struct rx_call *z_call)
{
	static int z_op = 153;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	return z_result;
}

int EndRXAFS_GetTime(struct rx_call *z_call,afs_uint32 * Seconds,afs_uint32 * USeconds)
{
	int z_result;
	XDR z_xdrs;
	/* Un-marshal the reply arguments */
	xdrrx_create(&z_xdrs, z_call, XDR_DECODE);
	if ((!xdr_afs_uint32(&z_xdrs, Seconds))
	     || (!xdr_afs_uint32(&z_xdrs, USeconds))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, RXAFS_STATINDEX,
		23, RXAFS_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int RXAFS_NGetVolumeInfo(struct rx_connection *z_conn,const char * VolumeName,AFSVolumeInfo * stuff)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 154;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_string(&z_xdrs, (char **) &VolumeName, AFSNAMEMAX))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_AFSVolumeInfo(&z_xdrs, stuff))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, RXAFS_STATINDEX,
		24, RXAFS_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int RXAFS_BulkStatus(struct rx_connection *z_conn,AFSCBFids * FidsArray,AFSBulkStats * StatArray,AFSCBs * CBArray,AFSVolSync * Sync)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 155;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_AFSCBFids(&z_xdrs, FidsArray))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_AFSBulkStats(&z_xdrs, StatArray))
	     || (!xdr_AFSCBs(&z_xdrs, CBArray))
	     || (!xdr_AFSVolSync(&z_xdrs, Sync))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, RXAFS_STATINDEX,
		25, RXAFS_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int RXAFS_SetLock(struct rx_connection *z_conn,AFSFid * Fid,ViceLockType Type,AFSVolSync * Sync)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 156;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_AFSFid(&z_xdrs, Fid))
	     || (!xdr_ViceLockType(&z_xdrs, &Type))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_AFSVolSync(&z_xdrs, Sync))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, RXAFS_STATINDEX,
		26, RXAFS_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int RXAFS_ExtendLock(struct rx_connection *z_conn,AFSFid * Fid,AFSVolSync * Sync)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 157;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_AFSFid(&z_xdrs, Fid))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_AFSVolSync(&z_xdrs, Sync))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, RXAFS_STATINDEX,
		27, RXAFS_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int RXAFS_ReleaseLock(struct rx_connection *z_conn,AFSFid * Fid,AFSVolSync * Sync)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 158;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_AFSFid(&z_xdrs, Fid))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_AFSVolSync(&z_xdrs, Sync))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, RXAFS_STATINDEX,
		28, RXAFS_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int RXAFS_XStatsVersion(struct rx_connection *z_conn,afs_int32 * versionNumberP)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 159;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_afs_int32(&z_xdrs, versionNumberP))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, RXAFS_STATINDEX,
		29, RXAFS_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int RXAFS_GetXStats(struct rx_connection *z_conn,afs_int32 clientVersionNumber,afs_int32 collectionNumber,afs_int32 * srvVersionNumberP,afs_int32 * timeP,AFS_CollData * dataP)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 160;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_afs_int32(&z_xdrs, &clientVersionNumber))
	     || (!xdr_afs_int32(&z_xdrs, &collectionNumber))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_afs_int32(&z_xdrs, srvVersionNumberP))
	     || (!xdr_afs_int32(&z_xdrs, timeP))
	     || (!xdr_AFS_CollData(&z_xdrs, dataP))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, RXAFS_STATINDEX,
		30, RXAFS_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int RXAFS_Lookup(struct rx_connection *z_conn,AFSFid * DirFid,const char * Name,AFSFid * OutFid,AFSFetchStatus * OutFidStatus,AFSFetchStatus * OutDirStatus,AFSCallBack * CallBack,AFSVolSync * Sync)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 161;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_AFSFid(&z_xdrs, DirFid))
	     || (!xdr_string(&z_xdrs, (char **) &Name, AFSNAMEMAX))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_AFSFid(&z_xdrs, OutFid))
	     || (!xdr_AFSFetchStatus(&z_xdrs, OutFidStatus))
	     || (!xdr_AFSFetchStatus(&z_xdrs, OutDirStatus))
	     || (!xdr_AFSCallBack(&z_xdrs, CallBack))
	     || (!xdr_AFSVolSync(&z_xdrs, Sync))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, RXAFS_STATINDEX,
		31, RXAFS_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int RXAFS_FlushCPS(struct rx_connection *z_conn,ViceIds * IdsArray,IPAddrs * AddrsArray,afs_int32 spare1,afs_int32 * spare2,afs_int32 * spare3)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 162;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_ViceIds(&z_xdrs, IdsArray))
	     || (!xdr_IPAddrs(&z_xdrs, AddrsArray))
	     || (!xdr_afs_int32(&z_xdrs, &spare1))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_afs_int32(&z_xdrs, spare2))
	     || (!xdr_afs_int32(&z_xdrs, spare3))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, RXAFS_STATINDEX,
		32, RXAFS_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int RXAFS_DFSSymlink(struct rx_connection *z_conn,AFSFid * DirFid,const char * Name,const char * LinkContents,AFSStoreStatus * InStatus,AFSFid * OutFid,AFSFetchStatus * OutFidStatus,AFSFetchStatus * OutDirStatus,AFSCallBack * CallBack,AFSVolSync * Sync)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 163;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_AFSFid(&z_xdrs, DirFid))
	     || (!xdr_string(&z_xdrs, (char **) &Name, AFSNAMEMAX))
	     || (!xdr_string(&z_xdrs, (char **) &LinkContents, AFSPATHMAX))
	     || (!xdr_AFSStoreStatus(&z_xdrs, InStatus))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_AFSFid(&z_xdrs, OutFid))
	     || (!xdr_AFSFetchStatus(&z_xdrs, OutFidStatus))
	     || (!xdr_AFSFetchStatus(&z_xdrs, OutDirStatus))
	     || (!xdr_AFSCallBack(&z_xdrs, CallBack))
	     || (!xdr_AFSVolSync(&z_xdrs, Sync))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, RXAFS_STATINDEX,
		33, RXAFS_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int RXAFS_FsCmd(struct rx_connection *z_conn,AFSFid * Fid,struct FsCmdInputs * Inputs,struct FsCmdOutputs * Outputs)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 220;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_AFSFid(&z_xdrs, Fid))
	     || (!xdr_FsCmdInputs(&z_xdrs, Inputs))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_FsCmdOutputs(&z_xdrs, Outputs))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, RXAFS_STATINDEX,
		34, RXAFS_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int RXAFS_ResidencyCmd(struct rx_connection *z_conn, AFSFid *Fid, struct FsCmdInputs *Inputs, struct FsCmdOutputs *Outputs);
int RXAFS_ResidencyCmd(struct rx_connection *z_conn, AFSFid *Fid, struct FsCmdInputs *Inputs, struct FsCmdOutputs *Outputs)
{
 return RXAFS_FsCmd(z_conn, Fid, Inputs, Outputs);
}
int RXAFS_InlineBulkStatus(struct rx_connection *z_conn,AFSCBFids * FidsArray,AFSBulkStats * StatArray,AFSCBs * CBArray,AFSVolSync * Sync)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 65536;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_AFSCBFids(&z_xdrs, FidsArray))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_AFSBulkStats(&z_xdrs, StatArray))
	     || (!xdr_AFSCBs(&z_xdrs, CBArray))
	     || (!xdr_AFSVolSync(&z_xdrs, Sync))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, RXAFS_STATINDEX,
		35, RXAFS_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int StartRXAFS_FetchData64(struct rx_call *z_call,AFSFid * Fid,afs_int64 Pos,afs_int64 Length)
{
	static int z_op = 65537;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_AFSFid(&z_xdrs, Fid))
	     || (!xdr_afs_int64(&z_xdrs, &Pos))
	     || (!xdr_afs_int64(&z_xdrs, &Length))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	return z_result;
}

int EndRXAFS_FetchData64(struct rx_call *z_call,AFSFetchStatus * OutStatus,AFSCallBack * CallBack,AFSVolSync * Sync)
{
	int z_result;
	XDR z_xdrs;
	/* Un-marshal the reply arguments */
	xdrrx_create(&z_xdrs, z_call, XDR_DECODE);
	if ((!xdr_AFSFetchStatus(&z_xdrs, OutStatus))
	     || (!xdr_AFSCallBack(&z_xdrs, CallBack))
	     || (!xdr_AFSVolSync(&z_xdrs, Sync))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, RXAFS_STATINDEX,
		36, RXAFS_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int StartRXAFS_StoreData64(struct rx_call *z_call,AFSFid * Fid,AFSStoreStatus * InStatus,afs_uint64 Pos,afs_uint64 Length,afs_uint64 FileLength)
{
	static int z_op = 65538;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_AFSFid(&z_xdrs, Fid))
	     || (!xdr_AFSStoreStatus(&z_xdrs, InStatus))
	     || (!xdr_afs_uint64(&z_xdrs, &Pos))
	     || (!xdr_afs_uint64(&z_xdrs, &Length))
	     || (!xdr_afs_uint64(&z_xdrs, &FileLength))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	return z_result;
}

int EndRXAFS_StoreData64(struct rx_call *z_call,AFSFetchStatus * OutStatus,AFSVolSync * Sync)
{
	int z_result;
	XDR z_xdrs;
	/* Un-marshal the reply arguments */
	xdrrx_create(&z_xdrs, z_call, XDR_DECODE);
	if ((!xdr_AFSFetchStatus(&z_xdrs, OutStatus))
	     || (!xdr_AFSVolSync(&z_xdrs, Sync))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, RXAFS_STATINDEX,
		37, RXAFS_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int RXAFS_GiveUpAllCallBacks(struct rx_connection *z_conn)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 65539;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, RXAFS_STATINDEX,
		38, RXAFS_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int StartRXAFS_GiveUpAllCallBacks(struct rx_call *z_call)
{
	static int z_op = 65539;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	return z_result;
}

int EndRXAFS_GiveUpAllCallBacks(struct rx_call *z_call)
{
	int z_result;
	z_result = RXGEN_SUCCESS;
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, RXAFS_STATINDEX,
		38, RXAFS_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int RXAFS_GetCapabilities(struct rx_connection *z_conn,Capabilities * capabilities)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 65540;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_Capabilities(&z_xdrs, capabilities))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, RXAFS_STATINDEX,
		39, RXAFS_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int StartRXAFS_GetCapabilities(struct rx_call *z_call)
{
	static int z_op = 65540;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	return z_result;
}

int EndRXAFS_GetCapabilities(struct rx_call *z_call,Capabilities * capabilities)
{
	int z_result;
	XDR z_xdrs;
	/* Un-marshal the reply arguments */
	xdrrx_create(&z_xdrs, z_call, XDR_DECODE);
	if ((!xdr_Capabilities(&z_xdrs, capabilities))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, RXAFS_STATINDEX,
		39, RXAFS_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int RXAFS_CallBackRxConnAddr(struct rx_connection *z_conn,afs_int32 * addr)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 65541;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_afs_int32(&z_xdrs, addr))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, RXAFS_STATINDEX,
		40, RXAFS_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

#define STATS64_CURRENTTIME 0
#define STATS64_BOOTTIME 1
#define STATS64_STARTTIME 2
#define STATS64_CURRENTCONNECTIONS 3
#define STATS64_TOTALFETCHES 4
#define STATS64_FETCHDATAS 5
#define STATS64_FETCHEDBYTES 6
#define STATS64_FETCHDATARATE 7
#define STATS64_TOTALSTORES 8
#define STATS64_STOREDATAS 9
#define STATS64_STOREDBYTES 10
#define STATS64_STOREDATARATE 11
#define STATS64_TOTALVICECALLS 12
#define STATS64_WORKSTATIONS 13
#define STATS64_ACTIVEWORKSTATIONS 14
#define STATS64_PROCESSSIZE 15
int RXAFS_GetStatistics64(struct rx_connection *z_conn,afs_int32 statsVersion,ViceStatistics64 * Statistics)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 65542;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_afs_int32(&z_xdrs, &statsVersion))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_ViceStatistics64(&z_xdrs, Statistics))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, RXAFS_STATINDEX,
		41, RXAFS_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

int RXAFS_StoreACL(struct rx_connection *z_conn,AFSFid * Fid,AFSOpaque * AccessList,AFSFetchStatus * OutStatus,AFSVolSync * Sync)
{
	struct rx_call *z_call = rx_NewCall(z_conn);
	static int z_op = 164;
	int z_result;
	XDR z_xdrs;
	xdrrx_create(&z_xdrs, z_call, XDR_ENCODE);

	/* Marshal the arguments */
	if ((!xdr_int(&z_xdrs, &z_op))
	     || (!xdr_AFSFid(&z_xdrs, Fid))
	     || (!xdr_AFSOpaque(&z_xdrs, AccessList))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	/* Un-marshal the reply arguments */
	z_xdrs.x_op = XDR_DECODE;
	if ((!xdr_AFSFetchStatus(&z_xdrs, OutStatus))
	     || (!xdr_AFSVolSync(&z_xdrs, Sync))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	z_result = RXGEN_SUCCESS;
fail:
	z_result = rx_EndCall(z_call, z_result);
	if (rx_enable_stats) {
	    rx_RecordCallStatistics(z_call, RXAFS_STATINDEX,
		42, RXAFS_NO_OF_STAT_FUNCS, 1);
	}

	return z_result;
}

