# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220315

from __future__ import print_function
import click
import oci  # noqa: F401
import six  # noqa: F401
import sys  # noqa: F401
from oci_cli import cli_constants  # noqa: F401
from oci_cli import cli_util
from oci_cli import json_skeleton_utils
from oci_cli import custom_types  # noqa: F401
from oci_cli.aliasing import CommandGroupWithAlias
from services.redis.src.oci_cli_redis.generated import redis_service_cli


@click.command(cli_util.override('oci_cache_default_config_set.oci_cache_default_config_set_root_group.command_name', 'oci-cache-default-config-set'), cls=CommandGroupWithAlias, help=cli_util.override('oci_cache_default_config_set.oci_cache_default_config_set_root_group.help', """Use the OCI Cache API to create and manage clusters. A cluster is a memory-based storage solution. For more information, see [OCI Cache]."""), short_help=cli_util.override('oci_cache_default_config_set.oci_cache_default_config_set_root_group.short_help', """OCI Cache API"""))
@cli_util.help_option_group
def oci_cache_default_config_set_root_group():
    pass


@click.command(cli_util.override('oci_cache_default_config_set.oci_cache_default_config_set_group.command_name', 'oci-cache-default-config-set'), cls=CommandGroupWithAlias, help="""Default configurations for OCI Cache to manage the behavior, performance, and functionality of the underlying cache engine.""")
@cli_util.help_option_group
def oci_cache_default_config_set_group():
    pass


@click.command(cli_util.override('oci_cache_default_config_set.oci_cache_default_config_set_summary_group.command_name', 'oci-cache-default-config-set-summary'), cls=CommandGroupWithAlias, help="""Summary of information about an OCI Cache Default Config Set.""")
@cli_util.help_option_group
def oci_cache_default_config_set_summary_group():
    pass


redis_service_cli.redis_service_group.add_command(oci_cache_default_config_set_root_group)
oci_cache_default_config_set_root_group.add_command(oci_cache_default_config_set_group)
oci_cache_default_config_set_root_group.add_command(oci_cache_default_config_set_summary_group)


@oci_cache_default_config_set_group.command(name=cli_util.override('oci_cache_default_config_set.get_oci_cache_default_config_set.command_name', 'get'), help=u"""Retrieves the specified OCI Cache Default Config Set. \n[Command Reference](getOciCacheDefaultConfigSet)""")
@cli_util.option('--compartment-id', required=True, help=u"""The unique identifier for the compartment.""")
@cli_util.option('--oci-cache-default-config-set-id', required=True, help=u"""Unique OCI Cache Default Config Set identifier.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'redis', 'class': 'OciCacheDefaultConfigSet'})
@cli_util.wrap_exceptions
def get_oci_cache_default_config_set(ctx, from_json, compartment_id, oci_cache_default_config_set_id):

    if isinstance(oci_cache_default_config_set_id, six.string_types) and len(oci_cache_default_config_set_id.strip()) == 0:
        raise click.UsageError('Parameter --oci-cache-default-config-set-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('redis', 'oci_cache_default_config_set', ctx)
    result = client.get_oci_cache_default_config_set(
        compartment_id=compartment_id,
        oci_cache_default_config_set_id=oci_cache_default_config_set_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@oci_cache_default_config_set_summary_group.command(name=cli_util.override('oci_cache_default_config_set.list_oci_cache_default_config_sets.command_name', 'list-oci-cache-default-config-sets'), help=u"""Lists the OCI Cache Default Config Sets in the specified compartment. \n[Command Reference](listOciCacheDefaultConfigSets)""")
@cli_util.option('--compartment-id', required=True, help=u"""The unique identifier for the compartment.""")
@cli_util.option('--id', help=u"""Unique OCI Cache Default Config Set identifier.""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "INACTIVE"]), help=u"""A filter to return the OCI Cache Default Config Set resources, whose lifecycle state matches with the given lifecycle state.""")
@cli_util.option('--software-version', type=custom_types.CliCaseInsensitiveChoice(["V7_0_5", "REDIS_7_0", "VALKEY_7_2"]), help=u"""A filter to return the OCI Cache Config Set resources, whose software version matches with the given software version.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the entire display name given.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'redis', 'class': 'OciCacheDefaultConfigSetCollection'})
@cli_util.wrap_exceptions
def list_oci_cache_default_config_sets(ctx, from_json, all_pages, page_size, compartment_id, id, lifecycle_state, software_version, display_name, sort_by, sort_order, limit, page):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if id is not None:
        kwargs['id'] = id
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    if software_version is not None:
        kwargs['software_version'] = software_version
    if display_name is not None:
        kwargs['display_name'] = display_name
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('redis', 'oci_cache_default_config_set', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_oci_cache_default_config_sets,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_oci_cache_default_config_sets,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_oci_cache_default_config_sets(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)
