# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180828

from __future__ import print_function
import click
import oci  # noqa: F401
import six  # noqa: F401
import sys  # noqa: F401
from oci_cli import cli_constants  # noqa: F401
from oci_cli import cli_util
from oci_cli import json_skeleton_utils
from oci_cli import custom_types  # noqa: F401
from oci_cli.aliasing import CommandGroupWithAlias
from services.opensearch.src.oci_cli_opensearch.generated import opensearch_service_cli


@click.command(cli_util.override('opensearch_cluster_pipeline.opensearch_cluster_pipeline_root_group.command_name', 'opensearch-cluster-pipeline'), cls=CommandGroupWithAlias, help=cli_util.override('opensearch_cluster_pipeline.opensearch_cluster_pipeline_root_group.help', """The OpenSearch service API provides access to OCI Search Service with OpenSearch."""), short_help=cli_util.override('opensearch_cluster_pipeline.opensearch_cluster_pipeline_root_group.short_help', """OpenSearch Service API"""))
@cli_util.help_option_group
def opensearch_cluster_pipeline_root_group():
    pass


@click.command(cli_util.override('opensearch_cluster_pipeline.opensearch_cluster_pipeline_group.command_name', 'opensearch-cluster-pipeline'), cls=CommandGroupWithAlias, help="""An OpenSearch cluster Pipeline resource. An cluster is set of instances that provide OpenSearch functionality in OCI Search Service with OpenSearch. For more information, see [Cluster Pipelines].""")
@cli_util.help_option_group
def opensearch_cluster_pipeline_group():
    pass


@click.command(cli_util.override('opensearch_cluster_pipeline.opensearch_cluster_pipeline_collection_group.command_name', 'opensearch-cluster-pipeline-collection'), cls=CommandGroupWithAlias, help="""The list of cluster pipelines returned in a cluster pipeline search.""")
@cli_util.help_option_group
def opensearch_cluster_pipeline_collection_group():
    pass


opensearch_service_cli.opensearch_service_group.add_command(opensearch_cluster_pipeline_root_group)
opensearch_cluster_pipeline_root_group.add_command(opensearch_cluster_pipeline_group)
opensearch_cluster_pipeline_root_group.add_command(opensearch_cluster_pipeline_collection_group)


@opensearch_cluster_pipeline_group.command(name=cli_util.override('opensearch_cluster_pipeline.create_opensearch_cluster_pipeline.command_name', 'create'), help=u"""Creates a new OpensearchCluster Pipeline. \n[Command Reference](createOpensearchClusterPipeline)""")
@cli_util.option('--display-name', required=True, help=u"""The name of the cluster pipeline. Avoid entering confidential information.""")
@cli_util.option('--ocpu-count', required=True, type=click.INT, help=u"""The number of OCPUs configured for each pipeline node.""")
@cli_util.option('--memory-gb', required=True, type=click.INT, help=u"""The amount of memory in GB, for each pipeline node.""")
@cli_util.option('--node-count', required=True, type=click.INT, help=u"""The number of nodes configured for the pipeline.""")
@cli_util.option('--pipeline-configuration-body', required=True, help=u"""The pipeline configuration in YAML format. The command accepts the pipeline configuration as a string or within a .yaml file. If you provide the configuration as a string, each new line must be escaped with \\.""")
@cli_util.option('--data-prepper-configuration-body', required=True, help=u"""The data prepper config in YAML format. The command accepts the data prepper config as a string or within a .yaml file. If you provide the configuration as a string, each new line must be escaped with \\.""")
@cli_util.option('--compartment-id', required=True, help=u"""The OCID of the compartment to create the pipeline in.""")
@cli_util.option('--node-shape', help=u"""The pipeline node shape.""")
@cli_util.option('--vcn-id', help=u"""The OCID of the pipeline's VCN.""")
@cli_util.option('--subnet-id', help=u"""The OCID of the pipeline's subnet.""")
@cli_util.option('--vcn-compartment-id', help=u"""The OCID for the compartment where the pipeline's VCN is located.""")
@cli_util.option('--subnet-compartment-id', help=u"""The OCID for the compartment where the pipeline's subnet is located.""")
@cli_util.option('--nsg-id', help=u"""The OCID of the NSG where the pipeline private endpoint vnic will be attached.""")
@cli_util.option('--reverse-connection-endpoints', type=custom_types.CLI_COMPLEX_TYPE, help=u"""The customer IP and the corresponding fully qualified domain name that the pipeline will connect to.

This option is a JSON list with items of type OpensearchPipelineReverseConnectionEndpoint.  For documentation on OpensearchPipelineReverseConnectionEndpoint please see our API reference: https://docs.cloud.oracle.com/api/#/en/opensearchclusterpipeline/20180828/datatypes/OpensearchPipelineReverseConnectionEndpoint.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--opc-dry-run', type=click.BOOL, help=u"""Indicates that the request is a dry run, if set to \"true\". A dry run request does not modify the configuration item details and is used only to perform validation on the submitted data.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'reverse-connection-endpoints': {'module': 'opensearch', 'class': 'list[OpensearchPipelineReverseConnectionEndpoint]'}, 'freeform-tags': {'module': 'opensearch', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'opensearch', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'reverse-connection-endpoints': {'module': 'opensearch', 'class': 'list[OpensearchPipelineReverseConnectionEndpoint]'}, 'freeform-tags': {'module': 'opensearch', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'opensearch', 'class': 'dict(str, dict(str, object))'}})
@cli_util.wrap_exceptions
def create_opensearch_cluster_pipeline(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, display_name, ocpu_count, memory_gb, node_count, pipeline_configuration_body, data_prepper_configuration_body, compartment_id, node_shape, vcn_id, subnet_id, vcn_compartment_id, subnet_compartment_id, nsg_id, reverse_connection_endpoints, freeform_tags, defined_tags, opc_dry_run):

    kwargs = {}
    if opc_dry_run is not None:
        kwargs['opc_dry_run'] = opc_dry_run
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['displayName'] = display_name
    _details['ocpuCount'] = ocpu_count
    _details['memoryGB'] = memory_gb
    _details['nodeCount'] = node_count
    _details['pipelineConfigurationBody'] = pipeline_configuration_body
    _details['dataPrepperConfigurationBody'] = data_prepper_configuration_body
    _details['compartmentId'] = compartment_id

    if node_shape is not None:
        _details['nodeShape'] = node_shape

    if vcn_id is not None:
        _details['vcnId'] = vcn_id

    if subnet_id is not None:
        _details['subnetId'] = subnet_id

    if vcn_compartment_id is not None:
        _details['vcnCompartmentId'] = vcn_compartment_id

    if subnet_compartment_id is not None:
        _details['subnetCompartmentId'] = subnet_compartment_id

    if nsg_id is not None:
        _details['nsgId'] = nsg_id

    if reverse_connection_endpoints is not None:
        _details['reverseConnectionEndpoints'] = cli_util.parse_json_parameter("reverse_connection_endpoints", reverse_connection_endpoints)

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('opensearch', 'opensearch_cluster_pipeline', ctx)
    result = client.create_opensearch_cluster_pipeline(
        create_opensearch_cluster_pipeline_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@opensearch_cluster_pipeline_group.command(name=cli_util.override('opensearch_cluster_pipeline.delete_opensearch_cluster_pipeline.command_name', 'delete'), help=u"""Deletes a OpensearchCluster Pipeline resource by identifier \n[Command Reference](deleteOpensearchClusterPipeline)""")
@cli_util.option('--opensearch-cluster-pipeline-id', required=True, help=u"""unique OpensearchClusterPipeline identifier""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_opensearch_cluster_pipeline(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, opensearch_cluster_pipeline_id, if_match):

    if isinstance(opensearch_cluster_pipeline_id, six.string_types) and len(opensearch_cluster_pipeline_id.strip()) == 0:
        raise click.UsageError('Parameter --opensearch-cluster-pipeline-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('opensearch', 'opensearch_cluster_pipeline', ctx)
    result = client.delete_opensearch_cluster_pipeline(
        opensearch_cluster_pipeline_id=opensearch_cluster_pipeline_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Please retrieve the work request to find its current state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@opensearch_cluster_pipeline_group.command(name=cli_util.override('opensearch_cluster_pipeline.get_opensearch_cluster_pipeline.command_name', 'get'), help=u"""Gets a OpensearchCluster Pipeline by identifier \n[Command Reference](getOpensearchClusterPipeline)""")
@cli_util.option('--opensearch-cluster-pipeline-id', required=True, help=u"""unique OpensearchClusterPipeline identifier""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'opensearch', 'class': 'OpensearchClusterPipeline'})
@cli_util.wrap_exceptions
def get_opensearch_cluster_pipeline(ctx, from_json, opensearch_cluster_pipeline_id):

    if isinstance(opensearch_cluster_pipeline_id, six.string_types) and len(opensearch_cluster_pipeline_id.strip()) == 0:
        raise click.UsageError('Parameter --opensearch-cluster-pipeline-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('opensearch', 'opensearch_cluster_pipeline', ctx)
    result = client.get_opensearch_cluster_pipeline(
        opensearch_cluster_pipeline_id=opensearch_cluster_pipeline_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@opensearch_cluster_pipeline_collection_group.command(name=cli_util.override('opensearch_cluster_pipeline.list_opensearch_cluster_pipelines.command_name', 'list-opensearch-cluster-pipelines'), help=u"""Returns a list of OpensearchClusterPipelines. \n[Command Reference](listOpensearchClusterPipelines)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ID of the compartment in which to list resources.""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]), help=u"""A filter to return only resources their lifecycleState matches the given lifecycleState.""")
@cli_util.option('--pipeline-component-id', help=u"""A filter to return pipelines whose any component has the given pipelineComponentId.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the entire display name given.""")
@cli_util.option('--id', help=u"""unique OpensearchClusterPipeline identifier""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'asc' or 'desc'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending. If no value is specified timeCreated is default.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'opensearch', 'class': 'OpensearchClusterPipelineCollection'})
@cli_util.wrap_exceptions
def list_opensearch_cluster_pipelines(ctx, from_json, all_pages, page_size, compartment_id, lifecycle_state, pipeline_component_id, display_name, id, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    if pipeline_component_id is not None:
        kwargs['pipeline_component_id'] = pipeline_component_id
    if display_name is not None:
        kwargs['display_name'] = display_name
    if id is not None:
        kwargs['id'] = id
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('opensearch', 'opensearch_cluster_pipeline', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_opensearch_cluster_pipelines,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_opensearch_cluster_pipelines,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_opensearch_cluster_pipelines(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@opensearch_cluster_pipeline_group.command(name=cli_util.override('opensearch_cluster_pipeline.update_opensearch_cluster_pipeline.command_name', 'update'), help=u"""Updates the OpensearchCluster Pipeline \n[Command Reference](updateOpensearchClusterPipeline)""")
@cli_util.option('--opensearch-cluster-pipeline-id', required=True, help=u"""unique OpensearchClusterPipeline identifier""")
@cli_util.option('--display-name', required=True, help=u"""The name of the pipeline. Avoid entering confidential information.""")
@cli_util.option('--ocpu-count', type=click.INT, help=u"""The number of OCPUs configured for each pipeline node.""")
@cli_util.option('--memory-gb', type=click.INT, help=u"""The amount of memory in GB, for each pipeline node.""")
@cli_util.option('--node-count', type=click.INT, help=u"""The number of nodes configured for the pipeline.""")
@cli_util.option('--node-shape', help=u"""The pipeline node shape.""")
@cli_util.option('--pipeline-configuration-body', help=u"""The pipeline configuration in YAML format. The command accepts the pipeline configuration as a string or within a .yaml file. If you provide the configuration as a string, each new line must be escaped with \\.""")
@cli_util.option('--data-prepper-configuration-body', help=u"""The data prepper config in YAML format. The command accepts the data prepper config as a string or within a .yaml file. If you provide the configuration as a string, each new line must be escaped with \\.""")
@cli_util.option('--vcn-id', help=u"""The OCID of the pipeline's VCN.""")
@cli_util.option('--subnet-id', help=u"""The OCID of the pipeline's subnet.""")
@cli_util.option('--vcn-compartment-id', help=u"""The OCID for the compartment where the pipeline's VCN is located.""")
@cli_util.option('--subnet-compartment-id', help=u"""The OCID for the compartment where the pipeline's subnet is located.""")
@cli_util.option('--nsg-id', help=u"""The OCID of the NSG where the pipeline private endpoint vnic will be attached.""")
@cli_util.option('--reverse-connection-endpoints', type=custom_types.CLI_COMPLEX_TYPE, help=u"""The customer IP and the corresponding fully qualified domain name that the pipeline will connect to.

This option is a JSON list with items of type OpensearchPipelineReverseConnectionEndpoint.  For documentation on OpensearchPipelineReverseConnectionEndpoint please see our API reference: https://docs.cloud.oracle.com/api/#/en/opensearchclusterpipeline/20180828/datatypes/OpensearchPipelineReverseConnectionEndpoint.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--opc-dry-run', type=click.BOOL, help=u"""Indicates that the request is a dry run, if set to \"true\". A dry run request does not modify the configuration item details and is used only to perform validation on the submitted data.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'reverse-connection-endpoints': {'module': 'opensearch', 'class': 'list[OpensearchPipelineReverseConnectionEndpoint]'}, 'freeform-tags': {'module': 'opensearch', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'opensearch', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'reverse-connection-endpoints': {'module': 'opensearch', 'class': 'list[OpensearchPipelineReverseConnectionEndpoint]'}, 'freeform-tags': {'module': 'opensearch', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'opensearch', 'class': 'dict(str, dict(str, object))'}})
@cli_util.wrap_exceptions
def update_opensearch_cluster_pipeline(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, opensearch_cluster_pipeline_id, display_name, ocpu_count, memory_gb, node_count, node_shape, pipeline_configuration_body, data_prepper_configuration_body, vcn_id, subnet_id, vcn_compartment_id, subnet_compartment_id, nsg_id, reverse_connection_endpoints, freeform_tags, defined_tags, if_match, opc_dry_run):

    if isinstance(opensearch_cluster_pipeline_id, six.string_types) and len(opensearch_cluster_pipeline_id.strip()) == 0:
        raise click.UsageError('Parameter --opensearch-cluster-pipeline-id cannot be whitespace or empty string')
    if not force:
        if reverse_connection_endpoints or freeform_tags or defined_tags:
            if not click.confirm("WARNING: Updates to reverse-connection-endpoints and freeform-tags and defined-tags will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    if opc_dry_run is not None:
        kwargs['opc_dry_run'] = opc_dry_run
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['displayName'] = display_name

    if ocpu_count is not None:
        _details['ocpuCount'] = ocpu_count

    if memory_gb is not None:
        _details['memoryGB'] = memory_gb

    if node_count is not None:
        _details['nodeCount'] = node_count

    if node_shape is not None:
        _details['nodeShape'] = node_shape

    if pipeline_configuration_body is not None:
        _details['pipelineConfigurationBody'] = pipeline_configuration_body

    if data_prepper_configuration_body is not None:
        _details['dataPrepperConfigurationBody'] = data_prepper_configuration_body

    if vcn_id is not None:
        _details['vcnId'] = vcn_id

    if subnet_id is not None:
        _details['subnetId'] = subnet_id

    if vcn_compartment_id is not None:
        _details['vcnCompartmentId'] = vcn_compartment_id

    if subnet_compartment_id is not None:
        _details['subnetCompartmentId'] = subnet_compartment_id

    if nsg_id is not None:
        _details['nsgId'] = nsg_id

    if reverse_connection_endpoints is not None:
        _details['reverseConnectionEndpoints'] = cli_util.parse_json_parameter("reverse_connection_endpoints", reverse_connection_endpoints)

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('opensearch', 'opensearch_cluster_pipeline', ctx)
    result = client.update_opensearch_cluster_pipeline(
        opensearch_cluster_pipeline_id=opensearch_cluster_pipeline_id,
        update_opensearch_cluster_pipeline_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)
