# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228

from __future__ import print_function
import click
import oci  # noqa: F401
import six  # noqa: F401
import sys  # noqa: F401
from oci_cli import cli_constants  # noqa: F401
from oci_cli import cli_util
from oci_cli import json_skeleton_utils
from oci_cli import custom_types  # noqa: F401
from oci_cli.aliasing import CommandGroupWithAlias
from services.fleet_apps_management.src.oci_cli_fleet_apps_management.generated import fleet_apps_management_service_cli


@click.command(cli_util.override('fleet_apps_management_runbooks.fleet_apps_management_runbooks_root_group.command_name', 'fleet-apps-management-runbooks'), cls=CommandGroupWithAlias, help=cli_util.override('fleet_apps_management_runbooks.fleet_apps_management_runbooks_root_group.help', """Fleet Application Management provides a centralized platform to help you automate resource management tasks, validate patch compliance, and enhance operational efficiency across an enterprise."""), short_help=cli_util.override('fleet_apps_management_runbooks.fleet_apps_management_runbooks_root_group.short_help', """Fleet Application Management Service API"""))
@cli_util.help_option_group
def fleet_apps_management_runbooks_root_group():
    pass


@click.command(cli_util.override('fleet_apps_management_runbooks.import_runbook_details_group.command_name', 'import-runbook-details'), cls=CommandGroupWithAlias, help="""Request to Import Runbook.""")
@cli_util.help_option_group
def import_runbook_details_group():
    pass


@click.command(cli_util.override('fleet_apps_management_runbooks.runbook_import_status_collection_group.command_name', 'runbook-import-status-collection'), cls=CommandGroupWithAlias, help="""Results of a runbook search. Contains RunbookImportStatusSummary items and other information.""")
@cli_util.help_option_group
def runbook_import_status_collection_group():
    pass


@click.command(cli_util.override('fleet_apps_management_runbooks.import_runbook_version_details_group.command_name', 'import-runbook-version-details'), cls=CommandGroupWithAlias, help="""Request to Export Runbook Version.""")
@cli_util.help_option_group
def import_runbook_version_details_group():
    pass


@click.command(cli_util.override('fleet_apps_management_runbooks.import_runbook_precheck_details_group.command_name', 'import-runbook-precheck-details'), cls=CommandGroupWithAlias, help="""Request for precheck of Runbook import.""")
@cli_util.help_option_group
def import_runbook_precheck_details_group():
    pass


@click.command(cli_util.override('fleet_apps_management_runbooks.runbook_import_group.command_name', 'runbook-import'), cls=CommandGroupWithAlias, help="""Runbook Import Status check details.""")
@cli_util.help_option_group
def runbook_import_group():
    pass


@click.command(cli_util.override('fleet_apps_management_runbooks.runbook_version_group.command_name', 'runbook-version'), cls=CommandGroupWithAlias, help="""Version for the runbook. Versioning runbooks in Fleet Application Management involve assigning unique identifiers or version numbers to different iterations of the runbook to track changes, improvements, and updates over time.""")
@cli_util.help_option_group
def runbook_version_group():
    pass


@click.command(cli_util.override('fleet_apps_management_runbooks.runbook_import_dependency_collection_group.command_name', 'runbook-import-dependency-collection'), cls=CommandGroupWithAlias, help="""Results of a find runbook import dependency. Contains RunbookTransferDependencySummary.""")
@cli_util.help_option_group
def runbook_import_dependency_collection_group():
    pass


@click.command(cli_util.override('fleet_apps_management_runbooks.task_record_group.command_name', 'task-record'), cls=CommandGroupWithAlias, help="""Attributes of a task record.""")
@cli_util.help_option_group
def task_record_group():
    pass


@click.command(cli_util.override('fleet_apps_management_runbooks.task_record_collection_group.command_name', 'task-record-collection'), cls=CommandGroupWithAlias, help="""Results of a task record search. Contains boh TaskRecordSummary items and other information, such as metadata.""")
@cli_util.help_option_group
def task_record_collection_group():
    pass


@click.command(cli_util.override('fleet_apps_management_runbooks.runbook_export_status_collection_group.command_name', 'runbook-export-status-collection'), cls=CommandGroupWithAlias, help="""Results of a runbook search. Contains RunbookExportStatusSummary items and other information.""")
@cli_util.help_option_group
def runbook_export_status_collection_group():
    pass


@click.command(cli_util.override('fleet_apps_management_runbooks.runbook_export_dependency_collection_group.command_name', 'runbook-export-dependency-collection'), cls=CommandGroupWithAlias, help="""Results of a find runbook export dependency. Contains RunbookExportDependencySummary.""")
@cli_util.help_option_group
def runbook_export_dependency_collection_group():
    pass


@click.command(cli_util.override('fleet_apps_management_runbooks.runbook_version_collection_group.command_name', 'runbook-version-collection'), cls=CommandGroupWithAlias, help="""Results of a RunbookVersion search. Contains RunbookVersionSummary.""")
@cli_util.help_option_group
def runbook_version_collection_group():
    pass


@click.command(cli_util.override('fleet_apps_management_runbooks.runbook_collection_group.command_name', 'runbook-collection'), cls=CommandGroupWithAlias, help="""Results of a runbook search. Contains RunbookSummary items and other information, such as metadata.""")
@cli_util.help_option_group
def runbook_collection_group():
    pass


@click.command(cli_util.override('fleet_apps_management_runbooks.runbook_group.command_name', 'runbook'), cls=CommandGroupWithAlias, help="""Runbook definition. Runbooks allow you to capture procedural tasks for handling a workflow. Only active versions of runbook will be available for executions.""")
@cli_util.help_option_group
def runbook_group():
    pass


@click.command(cli_util.override('fleet_apps_management_runbooks.runbook_export_group.command_name', 'runbook-export'), cls=CommandGroupWithAlias, help="""Runbook Export Status check details.""")
@cli_util.help_option_group
def runbook_export_group():
    pass


fleet_apps_management_service_cli.fleet_apps_management_service_group.add_command(fleet_apps_management_runbooks_root_group)
fleet_apps_management_runbooks_root_group.add_command(import_runbook_details_group)
fleet_apps_management_runbooks_root_group.add_command(runbook_import_status_collection_group)
fleet_apps_management_runbooks_root_group.add_command(import_runbook_version_details_group)
fleet_apps_management_runbooks_root_group.add_command(import_runbook_precheck_details_group)
fleet_apps_management_runbooks_root_group.add_command(runbook_import_group)
fleet_apps_management_runbooks_root_group.add_command(runbook_version_group)
fleet_apps_management_runbooks_root_group.add_command(runbook_import_dependency_collection_group)
fleet_apps_management_runbooks_root_group.add_command(task_record_group)
fleet_apps_management_runbooks_root_group.add_command(task_record_collection_group)
fleet_apps_management_runbooks_root_group.add_command(runbook_export_status_collection_group)
fleet_apps_management_runbooks_root_group.add_command(runbook_export_dependency_collection_group)
fleet_apps_management_runbooks_root_group.add_command(runbook_version_collection_group)
fleet_apps_management_runbooks_root_group.add_command(runbook_collection_group)
fleet_apps_management_runbooks_root_group.add_command(runbook_group)
fleet_apps_management_runbooks_root_group.add_command(runbook_export_group)


@runbook_group.command(name=cli_util.override('fleet_apps_management_runbooks.change_runbook_compartment.command_name', 'change-compartment'), help=u"""Moves a Runbook into a different compartment within the same tenancy. For information about moving resources between compartments, see [Moving Resources to a Different Compartment]. \n[Command Reference](changeRunbookCompartment)""")
@cli_util.option('--runbook-id', required=True, help=u"""Unique Runbook identifier""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment to move the Planner to.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def change_runbook_compartment(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, runbook_id, compartment_id, if_match):

    if isinstance(runbook_id, six.string_types) and len(runbook_id.strip()) == 0:
        raise click.UsageError('Parameter --runbook-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management_runbooks', ctx)
    result = client.change_runbook_compartment(
        runbook_id=runbook_id,
        change_runbook_compartment_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@task_record_group.command(name=cli_util.override('fleet_apps_management_runbooks.change_task_record_compartment.command_name', 'change-compartment'), help=u"""Moves a task record into a different compartment within the same tenancy. For information about moving resources between compartments, see [Moving Resources to a Different Compartment]. \n[Command Reference](changeTaskRecordCompartment)""")
@cli_util.option('--task-record-id', required=True, help=u"""The OCID of the task record.""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment to move the task record to.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def change_task_record_compartment(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, task_record_id, compartment_id, if_match):

    if isinstance(task_record_id, six.string_types) and len(task_record_id.strip()) == 0:
        raise click.UsageError('Parameter --task-record-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management_runbooks', ctx)
    result = client.change_task_record_compartment(
        task_record_id=task_record_id,
        change_task_record_compartment_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@runbook_group.command(name=cli_util.override('fleet_apps_management_runbooks.create_runbook.command_name', 'create'), help=u"""Creates a runbook. \n[Command Reference](createRunbook)""")
@cli_util.option('--display-name', required=True, help=u"""A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.

Example: `My new resource`""")
@cli_util.option('--operation', required=True, help=u"""The lifecycle operation performed by the task.""")
@cli_util.option('--runbook-version', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--compartment-id', required=True, help=u"""OCID of the compartment to which the resource belongs to.""")
@cli_util.option('--description', help=u"""A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.""")
@cli_util.option('--os-type', type=custom_types.CliCaseInsensitiveChoice(["WINDOWS", "LINUX", "GENERIC"]), help=u"""The OS type for the runbook.""")
@cli_util.option('--platform', help=u"""The platform of the runbook.""")
@cli_util.option('--is-default', type=click.BOOL, help=u"""Is the runbook default?""")
@cli_util.option('--is-sudo-access-needed', type=click.BOOL, help=u"""Does this runbook need SUDO access to execute?""")
@cli_util.option('--estimated-time', help=u"""Estimated time to successfully complete the runbook execution.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'runbook-version': {'module': 'fleet_apps_management', 'class': 'Version'}, 'freeform-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'runbook-version': {'module': 'fleet_apps_management', 'class': 'Version'}, 'freeform-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'fleet_apps_management', 'class': 'Runbook'})
@cli_util.wrap_exceptions
def create_runbook(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, display_name, operation, runbook_version, compartment_id, description, os_type, platform, is_default, is_sudo_access_needed, estimated_time, freeform_tags, defined_tags):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['displayName'] = display_name
    _details['operation'] = operation
    _details['runbookVersion'] = cli_util.parse_json_parameter("runbook_version", runbook_version)
    _details['compartmentId'] = compartment_id

    if description is not None:
        _details['description'] = description

    if os_type is not None:
        _details['osType'] = os_type

    if platform is not None:
        _details['platform'] = platform

    if is_default is not None:
        _details['isDefault'] = is_default

    if is_sudo_access_needed is not None:
        _details['isSudoAccessNeeded'] = is_sudo_access_needed

    if estimated_time is not None:
        _details['estimatedTime'] = estimated_time

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management_runbooks', ctx)
    result = client.create_runbook(
        create_runbook_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@runbook_version_group.command(name=cli_util.override('fleet_apps_management_runbooks.create_runbook_version.command_name', 'create'), help=u"""Add RunbookVersion in Fleet Application Management. \n[Command Reference](createRunbookVersion)""")
@cli_util.option('--runbook-id', required=True, help=u"""The OCID of the resource.""")
@cli_util.option('--tasks', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""A set of tasks to execute in the runbook.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--groups', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""The groups of the runbook version.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--execution-workflow-details', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--rollback-workflow-details', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'tasks': {'module': 'fleet_apps_management', 'class': 'list[Task]'}, 'groups': {'module': 'fleet_apps_management', 'class': 'list[Group]'}, 'execution-workflow-details': {'module': 'fleet_apps_management', 'class': 'ExecutionWorkflowDetails'}, 'rollback-workflow-details': {'module': 'fleet_apps_management', 'class': 'RollbackWorkflowDetails'}, 'freeform-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'tasks': {'module': 'fleet_apps_management', 'class': 'list[Task]'}, 'groups': {'module': 'fleet_apps_management', 'class': 'list[Group]'}, 'execution-workflow-details': {'module': 'fleet_apps_management', 'class': 'ExecutionWorkflowDetails'}, 'rollback-workflow-details': {'module': 'fleet_apps_management', 'class': 'RollbackWorkflowDetails'}, 'freeform-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'fleet_apps_management', 'class': 'RunbookVersion'})
@cli_util.wrap_exceptions
def create_runbook_version(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, runbook_id, tasks, groups, execution_workflow_details, rollback_workflow_details, freeform_tags, defined_tags):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['runbookId'] = runbook_id
    _details['tasks'] = cli_util.parse_json_parameter("tasks", tasks)
    _details['groups'] = cli_util.parse_json_parameter("groups", groups)
    _details['executionWorkflowDetails'] = cli_util.parse_json_parameter("execution_workflow_details", execution_workflow_details)

    if rollback_workflow_details is not None:
        _details['rollbackWorkflowDetails'] = cli_util.parse_json_parameter("rollback_workflow_details", rollback_workflow_details)

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management_runbooks', ctx)
    result = client.create_runbook_version(
        create_runbook_version_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@task_record_group.command(name=cli_util.override('fleet_apps_management_runbooks.create_task_record.command_name', 'create'), help=u"""Creates a new task record. \n[Command Reference](createTaskRecord)""")
@cli_util.option('--display-name', required=True, help=u"""A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.

Example: `My new resource`""")
@cli_util.option('--details', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--compartment-id', required=True, help=u"""OCID of the compartment to which the resource belongs to.""")
@cli_util.option('--description', help=u"""A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "INACTIVE", "DELETED", "DELETING", "FAILED", "UPDATING"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'details': {'module': 'fleet_apps_management', 'class': 'Details'}, 'freeform-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'details': {'module': 'fleet_apps_management', 'class': 'Details'}, 'freeform-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'fleet_apps_management', 'class': 'TaskRecord'})
@cli_util.wrap_exceptions
def create_task_record(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, display_name, details, compartment_id, description, freeform_tags, defined_tags):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['displayName'] = display_name
    _details['details'] = cli_util.parse_json_parameter("details", details)
    _details['compartmentId'] = compartment_id

    if description is not None:
        _details['description'] = description

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management_runbooks', ctx)
    result = client.create_task_record(
        create_task_record_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_task_record') and callable(getattr(client, 'get_task_record')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_task_record(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@runbook_group.command(name=cli_util.override('fleet_apps_management_runbooks.delete_runbook.command_name', 'delete'), help=u"""Deletes a runbook specified by the identifier. \n[Command Reference](deleteRunbook)""")
@cli_util.option('--runbook-id', required=True, help=u"""Unique Runbook identifier""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_runbook(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, runbook_id, if_match):

    if isinstance(runbook_id, six.string_types) and len(runbook_id.strip()) == 0:
        raise click.UsageError('Parameter --runbook-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management_runbooks', ctx)
    result = client.delete_runbook(
        runbook_id=runbook_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Please retrieve the work request to find its current state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@runbook_version_group.command(name=cli_util.override('fleet_apps_management_runbooks.delete_runbook_version.command_name', 'delete'), help=u"""Removes a Runbook Version from the runbook in Fleet Application Management. \n[Command Reference](deleteRunbookVersion)""")
@cli_util.option('--runbook-version-id', required=True, help=u"""Unique Runbook Version identifier""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_runbook_version(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, runbook_version_id, if_match):

    if isinstance(runbook_version_id, six.string_types) and len(runbook_version_id.strip()) == 0:
        raise click.UsageError('Parameter --runbook-version-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management_runbooks', ctx)
    result = client.delete_runbook_version(
        runbook_version_id=runbook_version_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Please retrieve the work request to find its current state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@task_record_group.command(name=cli_util.override('fleet_apps_management_runbooks.delete_task_record.command_name', 'delete'), help=u"""Deletes the task record specified by an identifier. \n[Command Reference](deleteTaskRecord)""")
@cli_util.option('--task-record-id', required=True, help=u"""The OCID of the task record.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_task_record(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, task_record_id, if_match):

    if isinstance(task_record_id, six.string_types) and len(task_record_id.strip()) == 0:
        raise click.UsageError('Parameter --task-record-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management_runbooks', ctx)
    result = client.delete_task_record(
        task_record_id=task_record_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Please retrieve the work request to find its current state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@runbook_group.command(name=cli_util.override('fleet_apps_management_runbooks.export_runbook.command_name', 'export'), help=u"""Export the specified version of the runbook. \n[Command Reference](exportRunbook)""")
@cli_util.option('--content-destination', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--runbook-id', required=True, help=u"""Unique Runbook identifier""")
@cli_util.option('--export-as', type=custom_types.CliCaseInsensitiveChoice(["TERRAFORM", "NON_TERRAFORM"]), help=u"""Export Runbook As Type.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'content-destination': {'module': 'fleet_apps_management', 'class': 'TransferRunbookContentDetails'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'content-destination': {'module': 'fleet_apps_management', 'class': 'TransferRunbookContentDetails'}})
@cli_util.wrap_exceptions
def export_runbook(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, content_destination, runbook_id, export_as, if_match):

    if isinstance(runbook_id, six.string_types) and len(runbook_id.strip()) == 0:
        raise click.UsageError('Parameter --runbook-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['contentDestination'] = cli_util.parse_json_parameter("content_destination", content_destination)

    if export_as is not None:
        _details['exportAs'] = export_as

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management_runbooks', ctx)
    result = client.export_runbook(
        runbook_id=runbook_id,
        export_runbook_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@runbook_group.command(name=cli_util.override('fleet_apps_management_runbooks.export_runbook_transfer_runbook_object_storage_bucket_content_details.command_name', 'export-runbook-transfer-runbook-object-storage-bucket-content-details'), help=u"""Export the specified version of the runbook. \n[Command Reference](exportRunbook)""")
@cli_util.option('--runbook-id', required=True, help=u"""Unique Runbook identifier""")
@cli_util.option('--content-destination-namespace-name', required=True, help=u"""Namespace.""")
@cli_util.option('--content-destination-bucket-name', required=True, help=u"""Bucket Name.""")
@cli_util.option('--export-as', type=custom_types.CliCaseInsensitiveChoice(["TERRAFORM", "NON_TERRAFORM"]), help=u"""Export Runbook As Type.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--content-destination-object-name', help=u"""Object Name.""")
@cli_util.option('--content-destination-checksum', help=u"""md5 checksum of the artifact.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def export_runbook_transfer_runbook_object_storage_bucket_content_details(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, runbook_id, content_destination_namespace_name, content_destination_bucket_name, export_as, if_match, content_destination_object_name, content_destination_checksum):

    if isinstance(runbook_id, six.string_types) and len(runbook_id.strip()) == 0:
        raise click.UsageError('Parameter --runbook-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['contentDestination'] = {}
    _details['contentDestination']['namespaceName'] = content_destination_namespace_name
    _details['contentDestination']['bucketName'] = content_destination_bucket_name

    if export_as is not None:
        _details['exportAs'] = export_as

    if content_destination_object_name is not None:
        _details['contentDestination']['objectName'] = content_destination_object_name

    if content_destination_checksum is not None:
        _details['contentDestination']['checksum'] = content_destination_checksum

    _details['contentDestination']['sourceType'] = 'OBJECT_STORAGE_BUCKET'

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management_runbooks', ctx)
    result = client.export_runbook(
        runbook_id=runbook_id,
        export_runbook_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@runbook_group.command(name=cli_util.override('fleet_apps_management_runbooks.export_runbook_transfer_runbook_par_url_content_details.command_name', 'export-runbook-transfer-runbook-par-url-content-details'), help=u"""Export the specified version of the runbook. \n[Command Reference](exportRunbook)""")
@cli_util.option('--runbook-id', required=True, help=u"""Unique Runbook identifier""")
@cli_util.option('--content-destination-url', required=True, help=u"""PAR url.""")
@cli_util.option('--export-as', type=custom_types.CliCaseInsensitiveChoice(["TERRAFORM", "NON_TERRAFORM"]), help=u"""Export Runbook As Type.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def export_runbook_transfer_runbook_par_url_content_details(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, runbook_id, content_destination_url, export_as, if_match):

    if isinstance(runbook_id, six.string_types) and len(runbook_id.strip()) == 0:
        raise click.UsageError('Parameter --runbook-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['contentDestination'] = {}
    _details['contentDestination']['url'] = content_destination_url

    if export_as is not None:
        _details['exportAs'] = export_as

    _details['contentDestination']['sourceType'] = 'PAR_URL'

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management_runbooks', ctx)
    result = client.export_runbook(
        runbook_id=runbook_id,
        export_runbook_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@runbook_group.command(name=cli_util.override('fleet_apps_management_runbooks.export_runbook_version.command_name', 'export-runbook-version'), help=u"""Export the specified version of the runbook. \n[Command Reference](exportRunbookVersion)""")
@cli_util.option('--content-destination', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--runbook-version-id', required=True, help=u"""Unique Runbook Version identifier""")
@cli_util.option('--version-parameterconflict', type=click.FLOAT, help=u"""Export Runbook Version Details.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'content-destination': {'module': 'fleet_apps_management', 'class': 'TransferRunbookContentDetails'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'content-destination': {'module': 'fleet_apps_management', 'class': 'TransferRunbookContentDetails'}})
@cli_util.wrap_exceptions
def export_runbook_version(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, content_destination, runbook_version_id, version_parameterconflict, if_match):

    if isinstance(runbook_version_id, six.string_types) and len(runbook_version_id.strip()) == 0:
        raise click.UsageError('Parameter --runbook-version-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['contentDestination'] = cli_util.parse_json_parameter("content_destination", content_destination)

    if version_parameterconflict is not None:
        _details['version'] = version_parameterconflict

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management_runbooks', ctx)
    result = client.export_runbook_version(
        runbook_version_id=runbook_version_id,
        export_runbook_version_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@runbook_group.command(name=cli_util.override('fleet_apps_management_runbooks.export_runbook_version_transfer_runbook_object_storage_bucket_content_details.command_name', 'export-runbook-version-transfer-runbook-object-storage-bucket-content-details'), help=u"""Export the specified version of the runbook. \n[Command Reference](exportRunbookVersion)""")
@cli_util.option('--runbook-version-id', required=True, help=u"""Unique Runbook Version identifier""")
@cli_util.option('--content-destination-namespace-name', required=True, help=u"""Namespace.""")
@cli_util.option('--content-destination-bucket-name', required=True, help=u"""Bucket Name.""")
@cli_util.option('--version-parameterconflict', type=click.FLOAT, help=u"""Export Runbook Version Details.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--content-destination-object-name', help=u"""Object Name.""")
@cli_util.option('--content-destination-checksum', help=u"""md5 checksum of the artifact.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def export_runbook_version_transfer_runbook_object_storage_bucket_content_details(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, runbook_version_id, content_destination_namespace_name, content_destination_bucket_name, version_parameterconflict, if_match, content_destination_object_name, content_destination_checksum):

    if isinstance(runbook_version_id, six.string_types) and len(runbook_version_id.strip()) == 0:
        raise click.UsageError('Parameter --runbook-version-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['contentDestination'] = {}
    _details['contentDestination']['namespaceName'] = content_destination_namespace_name
    _details['contentDestination']['bucketName'] = content_destination_bucket_name

    if version_parameterconflict is not None:
        _details['version'] = version_parameterconflict

    if content_destination_object_name is not None:
        _details['contentDestination']['objectName'] = content_destination_object_name

    if content_destination_checksum is not None:
        _details['contentDestination']['checksum'] = content_destination_checksum

    _details['contentDestination']['sourceType'] = 'OBJECT_STORAGE_BUCKET'

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management_runbooks', ctx)
    result = client.export_runbook_version(
        runbook_version_id=runbook_version_id,
        export_runbook_version_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@runbook_group.command(name=cli_util.override('fleet_apps_management_runbooks.export_runbook_version_transfer_runbook_par_url_content_details.command_name', 'export-runbook-version-transfer-runbook-par-url-content-details'), help=u"""Export the specified version of the runbook. \n[Command Reference](exportRunbookVersion)""")
@cli_util.option('--runbook-version-id', required=True, help=u"""Unique Runbook Version identifier""")
@cli_util.option('--content-destination-url', required=True, help=u"""PAR url.""")
@cli_util.option('--version-parameterconflict', type=click.FLOAT, help=u"""Export Runbook Version Details.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def export_runbook_version_transfer_runbook_par_url_content_details(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, runbook_version_id, content_destination_url, version_parameterconflict, if_match):

    if isinstance(runbook_version_id, six.string_types) and len(runbook_version_id.strip()) == 0:
        raise click.UsageError('Parameter --runbook-version-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['contentDestination'] = {}
    _details['contentDestination']['url'] = content_destination_url

    if version_parameterconflict is not None:
        _details['version'] = version_parameterconflict

    _details['contentDestination']['sourceType'] = 'PAR_URL'

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management_runbooks', ctx)
    result = client.export_runbook_version(
        runbook_version_id=runbook_version_id,
        export_runbook_version_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@runbook_export_dependency_collection_group.command(name=cli_util.override('fleet_apps_management_runbooks.find_runbook_export_dependency.command_name', 'find-runbook-export-dependency'), help=u"""Find runbook export Dependencies \n[Command Reference](findRunbookExportDependency)""")
@cli_util.option('--runbook-id', required=True, help=u"""The OCID of the resource.""")
@cli_util.option('--runbook-version-id', help=u"""The OCID of the resource.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'fleet_apps_management', 'class': 'RunbookExportDependencyCollection'})
@cli_util.wrap_exceptions
def find_runbook_export_dependency(ctx, from_json, runbook_id, runbook_version_id, limit, page):

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['runbookId'] = runbook_id

    if runbook_version_id is not None:
        _details['runbookVersionId'] = runbook_version_id

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management_runbooks', ctx)
    result = client.find_runbook_export_dependency(
        find_runbook_export_dependency_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@runbook_import_dependency_collection_group.command(name=cli_util.override('fleet_apps_management_runbooks.find_runbook_import_dependency.command_name', 'find-runbook-import-dependency'), help=u"""Find runbook import Dependencies \n[Command Reference](findRunbookImportDependency)""")
@cli_util.option('--compartment-id', required=True, help=u"""OCID of the compartment to which the resource belongs to.""")
@cli_util.option('--content', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@json_skeleton_utils.get_cli_json_input_option({'content': {'module': 'fleet_apps_management', 'class': 'TransferRunbookContentDetails'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'content': {'module': 'fleet_apps_management', 'class': 'TransferRunbookContentDetails'}}, output_type={'module': 'fleet_apps_management', 'class': 'RunbookImportDependencyCollection'})
@cli_util.wrap_exceptions
def find_runbook_import_dependency(ctx, from_json, compartment_id, content, limit, page):

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id
    _details['content'] = cli_util.parse_json_parameter("content", content)

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management_runbooks', ctx)
    result = client.find_runbook_import_dependency(
        find_runbook_import_dependency_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@runbook_import_dependency_collection_group.command(name=cli_util.override('fleet_apps_management_runbooks.find_runbook_import_dependency_transfer_runbook_object_storage_bucket_content_details.command_name', 'find-runbook-import-dependency-transfer-runbook-object-storage-bucket-content-details'), help=u"""Find runbook import Dependencies \n[Command Reference](findRunbookImportDependency)""")
@cli_util.option('--compartment-id', required=True, help=u"""OCID of the compartment to which the resource belongs to.""")
@cli_util.option('--content-namespace-name', required=True, help=u"""Namespace.""")
@cli_util.option('--content-bucket-name', required=True, help=u"""Bucket Name.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@cli_util.option('--content-object-name', help=u"""Object Name.""")
@cli_util.option('--content-checksum', help=u"""md5 checksum of the artifact.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'fleet_apps_management', 'class': 'RunbookImportDependencyCollection'})
@cli_util.wrap_exceptions
def find_runbook_import_dependency_transfer_runbook_object_storage_bucket_content_details(ctx, from_json, compartment_id, content_namespace_name, content_bucket_name, limit, page, content_object_name, content_checksum):

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['content'] = {}
    _details['compartmentId'] = compartment_id
    _details['content']['namespaceName'] = content_namespace_name
    _details['content']['bucketName'] = content_bucket_name

    if content_object_name is not None:
        _details['content']['objectName'] = content_object_name

    if content_checksum is not None:
        _details['content']['checksum'] = content_checksum

    _details['content']['sourceType'] = 'OBJECT_STORAGE_BUCKET'

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management_runbooks', ctx)
    result = client.find_runbook_import_dependency(
        find_runbook_import_dependency_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@runbook_import_dependency_collection_group.command(name=cli_util.override('fleet_apps_management_runbooks.find_runbook_import_dependency_transfer_runbook_par_url_content_details.command_name', 'find-runbook-import-dependency-transfer-runbook-par-url-content-details'), help=u"""Find runbook import Dependencies \n[Command Reference](findRunbookImportDependency)""")
@cli_util.option('--compartment-id', required=True, help=u"""OCID of the compartment to which the resource belongs to.""")
@cli_util.option('--content-url', required=True, help=u"""PAR url.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'fleet_apps_management', 'class': 'RunbookImportDependencyCollection'})
@cli_util.wrap_exceptions
def find_runbook_import_dependency_transfer_runbook_par_url_content_details(ctx, from_json, compartment_id, content_url, limit, page):

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['content'] = {}
    _details['compartmentId'] = compartment_id
    _details['content']['url'] = content_url

    _details['content']['sourceType'] = 'PAR_URL'

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management_runbooks', ctx)
    result = client.find_runbook_import_dependency(
        find_runbook_import_dependency_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@runbook_group.command(name=cli_util.override('fleet_apps_management_runbooks.get_runbook.command_name', 'get'), help=u"""Get the details of a runbook in Fleet Application Management. \n[Command Reference](getRunbook)""")
@cli_util.option('--runbook-id', required=True, help=u"""Unique Runbook identifier""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'fleet_apps_management', 'class': 'Runbook'})
@cli_util.wrap_exceptions
def get_runbook(ctx, from_json, runbook_id):

    if isinstance(runbook_id, six.string_types) and len(runbook_id.strip()) == 0:
        raise click.UsageError('Parameter --runbook-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management_runbooks', ctx)
    result = client.get_runbook(
        runbook_id=runbook_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@runbook_export_group.command(name=cli_util.override('fleet_apps_management_runbooks.get_runbook_export.command_name', 'get'), help=u"""Get the runbook export status for provided runbook and exportId. \n[Command Reference](getRunbookExport)""")
@cli_util.option('--runbook-id', required=True, help=u"""Unique Runbook identifier""")
@cli_util.option('--export-id', required=True, help=u"""Unique tracking identifier to fetch runbook export status""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'fleet_apps_management', 'class': 'RunbookExport'})
@cli_util.wrap_exceptions
def get_runbook_export(ctx, from_json, runbook_id, export_id):

    if isinstance(runbook_id, six.string_types) and len(runbook_id.strip()) == 0:
        raise click.UsageError('Parameter --runbook-id cannot be whitespace or empty string')

    if isinstance(export_id, six.string_types) and len(export_id.strip()) == 0:
        raise click.UsageError('Parameter --export-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management_runbooks', ctx)
    result = client.get_runbook_export(
        runbook_id=runbook_id,
        export_id=export_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@runbook_import_group.command(name=cli_util.override('fleet_apps_management_runbooks.get_runbook_import.command_name', 'get'), help=u"""Get the runbook import status for provided runbook and importId. \n[Command Reference](getRunbookImport)""")
@cli_util.option('--runbook-id', required=True, help=u"""Unique Runbook identifier""")
@cli_util.option('--import-id', required=True, help=u"""Unique tracking identifier to fetch runbook import status""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'fleet_apps_management', 'class': 'RunbookImport'})
@cli_util.wrap_exceptions
def get_runbook_import(ctx, from_json, runbook_id, import_id):

    if isinstance(runbook_id, six.string_types) and len(runbook_id.strip()) == 0:
        raise click.UsageError('Parameter --runbook-id cannot be whitespace or empty string')

    if isinstance(import_id, six.string_types) and len(import_id.strip()) == 0:
        raise click.UsageError('Parameter --import-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management_runbooks', ctx)
    result = client.get_runbook_import(
        runbook_id=runbook_id,
        import_id=import_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@runbook_version_group.command(name=cli_util.override('fleet_apps_management_runbooks.get_runbook_version.command_name', 'get'), help=u"""Gets a Runbook Version by identifier. \n[Command Reference](getRunbookVersion)""")
@cli_util.option('--runbook-version-id', required=True, help=u"""Unique Runbook Version identifier""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'fleet_apps_management', 'class': 'RunbookVersion'})
@cli_util.wrap_exceptions
def get_runbook_version(ctx, from_json, runbook_version_id):

    if isinstance(runbook_version_id, six.string_types) and len(runbook_version_id.strip()) == 0:
        raise click.UsageError('Parameter --runbook-version-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management_runbooks', ctx)
    result = client.get_runbook_version(
        runbook_version_id=runbook_version_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@task_record_group.command(name=cli_util.override('fleet_apps_management_runbooks.get_task_record.command_name', 'get'), help=u"""Gets information for the specified task record. \n[Command Reference](getTaskRecord)""")
@cli_util.option('--task-record-id', required=True, help=u"""The OCID of the task record.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'fleet_apps_management', 'class': 'TaskRecord'})
@cli_util.wrap_exceptions
def get_task_record(ctx, from_json, task_record_id):

    if isinstance(task_record_id, six.string_types) and len(task_record_id.strip()) == 0:
        raise click.UsageError('Parameter --task-record-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management_runbooks', ctx)
    result = client.get_task_record(
        task_record_id=task_record_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@import_runbook_details_group.command(name=cli_util.override('fleet_apps_management_runbooks.import_runbook.command_name', 'import-runbook'), help=u"""Import the specified version of the runbook. \n[Command Reference](importRunbook)""")
@cli_util.option('--compartment-id', required=True, help=u"""OCID of the compartment to which the resource belongs to.""")
@cli_util.option('--content-source', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--content-destination', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--runbook-name', help=u"""The name of the runbook.""")
@cli_util.option('--import-option', type=custom_types.CliCaseInsensitiveChoice(["RETAIN", "REPLACE", "INCREMENT"]), help=u"""ImportOptions for Runbook.""")
@cli_util.option('--version-parameterconflict', help=u"""Version number.""")
@cli_util.option('--required-values', type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of required values.

This option is a JSON list with items of type RunbookImportRequiredValue.  For documentation on RunbookImportRequiredValue please see our API reference: https://docs.cloud.oracle.com/api/#/en/fleetappsmanagementrunbooks/20250228/datatypes/RunbookImportRequiredValue.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'content-source': {'module': 'fleet_apps_management', 'class': 'TransferRunbookContentDetails'}, 'content-destination': {'module': 'fleet_apps_management', 'class': 'TransferRunbookContentDetails'}, 'required-values': {'module': 'fleet_apps_management', 'class': 'list[RunbookImportRequiredValue]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'content-source': {'module': 'fleet_apps_management', 'class': 'TransferRunbookContentDetails'}, 'content-destination': {'module': 'fleet_apps_management', 'class': 'TransferRunbookContentDetails'}, 'required-values': {'module': 'fleet_apps_management', 'class': 'list[RunbookImportRequiredValue]'}})
@cli_util.wrap_exceptions
def import_runbook(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, compartment_id, content_source, content_destination, runbook_name, import_option, version_parameterconflict, required_values, if_match):

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id
    _details['contentSource'] = cli_util.parse_json_parameter("content_source", content_source)
    _details['contentDestination'] = cli_util.parse_json_parameter("content_destination", content_destination)

    if runbook_name is not None:
        _details['runbookName'] = runbook_name

    if import_option is not None:
        _details['importOption'] = import_option

    if version_parameterconflict is not None:
        _details['version'] = version_parameterconflict

    if required_values is not None:
        _details['requiredValues'] = cli_util.parse_json_parameter("required_values", required_values)

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management_runbooks', ctx)
    result = client.import_runbook(
        import_runbook_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@import_runbook_precheck_details_group.command(name=cli_util.override('fleet_apps_management_runbooks.import_runbook_precheck.command_name', 'import-runbook-precheck'), help=u"""Precheck for import runbook. \n[Command Reference](importRunbookPrecheck)""")
@cli_util.option('--compartment-id', required=True, help=u"""OCID of the compartment to which the resource belongs to.""")
@cli_util.option('--content-source', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--content-destination', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--import-as', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--required-values', type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of required values.

This option is a JSON list with items of type ImportRunbookPrecheckRequiredValue.  For documentation on ImportRunbookPrecheckRequiredValue please see our API reference: https://docs.cloud.oracle.com/api/#/en/fleetappsmanagementrunbooks/20250228/datatypes/ImportRunbookPrecheckRequiredValue.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'content-source': {'module': 'fleet_apps_management', 'class': 'TransferRunbookContentDetails'}, 'content-destination': {'module': 'fleet_apps_management', 'class': 'TransferRunbookContentDetails'}, 'import-as': {'module': 'fleet_apps_management', 'class': 'RunbookImportAs'}, 'required-values': {'module': 'fleet_apps_management', 'class': 'list[ImportRunbookPrecheckRequiredValue]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'content-source': {'module': 'fleet_apps_management', 'class': 'TransferRunbookContentDetails'}, 'content-destination': {'module': 'fleet_apps_management', 'class': 'TransferRunbookContentDetails'}, 'import-as': {'module': 'fleet_apps_management', 'class': 'RunbookImportAs'}, 'required-values': {'module': 'fleet_apps_management', 'class': 'list[ImportRunbookPrecheckRequiredValue]'}})
@cli_util.wrap_exceptions
def import_runbook_precheck(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, compartment_id, content_source, content_destination, import_as, required_values, if_match):

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id
    _details['contentSource'] = cli_util.parse_json_parameter("content_source", content_source)
    _details['contentDestination'] = cli_util.parse_json_parameter("content_destination", content_destination)

    if import_as is not None:
        _details['importAs'] = cli_util.parse_json_parameter("import_as", import_as)

    if required_values is not None:
        _details['requiredValues'] = cli_util.parse_json_parameter("required_values", required_values)

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management_runbooks', ctx)
    result = client.import_runbook_precheck(
        import_runbook_precheck_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@import_runbook_version_details_group.command(name=cli_util.override('fleet_apps_management_runbooks.import_runbook_version.command_name', 'import-runbook-version'), help=u"""Export the specified version of the runbook. \n[Command Reference](importRunbookVersion)""")
@cli_util.option('--compartment-id', required=True, help=u"""OCID of the compartment to which the resource belongs to.""")
@cli_util.option('--content-source', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--content-destination', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--runbook-id', help=u"""The OCID of the resource.""")
@cli_util.option('--import-option', help=u"""ImportOptions for Runbook.""")
@cli_util.option('--version-parameterconflict', help=u"""Version number.""")
@cli_util.option('--required-values', type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of required values.

This option is a JSON list with items of type RunbookImportRequiredValue.  For documentation on RunbookImportRequiredValue please see our API reference: https://docs.cloud.oracle.com/api/#/en/fleetappsmanagementrunbooks/20250228/datatypes/RunbookImportRequiredValue.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'content-source': {'module': 'fleet_apps_management', 'class': 'TransferRunbookContentDetails'}, 'content-destination': {'module': 'fleet_apps_management', 'class': 'TransferRunbookContentDetails'}, 'required-values': {'module': 'fleet_apps_management', 'class': 'list[RunbookImportRequiredValue]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'content-source': {'module': 'fleet_apps_management', 'class': 'TransferRunbookContentDetails'}, 'content-destination': {'module': 'fleet_apps_management', 'class': 'TransferRunbookContentDetails'}, 'required-values': {'module': 'fleet_apps_management', 'class': 'list[RunbookImportRequiredValue]'}})
@cli_util.wrap_exceptions
def import_runbook_version(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, compartment_id, content_source, content_destination, runbook_id, import_option, version_parameterconflict, required_values, if_match):

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id
    _details['contentSource'] = cli_util.parse_json_parameter("content_source", content_source)
    _details['contentDestination'] = cli_util.parse_json_parameter("content_destination", content_destination)

    if runbook_id is not None:
        _details['runbookId'] = runbook_id

    if import_option is not None:
        _details['importOption'] = import_option

    if version_parameterconflict is not None:
        _details['version'] = version_parameterconflict

    if required_values is not None:
        _details['requiredValues'] = cli_util.parse_json_parameter("required_values", required_values)

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management_runbooks', ctx)
    result = client.import_runbook_version(
        import_runbook_version_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@runbook_export_status_collection_group.command(name=cli_util.override('fleet_apps_management_runbooks.list_runbook_export_statuses.command_name', 'list-runbook-export-statuses'), help=u"""Returns a list of all the Runbook export status in the specified compartment. The query parameter `compartmentId` is required. \n[Command Reference](listRunbookExportStatuses)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ID of the compartment in which to list resources.""")
@cli_util.option('--id', help=u"""Unique identifier or OCID for listing a single Runbook by id. Either compartmentId or id must be provided.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'fleet_apps_management', 'class': 'RunbookExportStatusCollection'})
@cli_util.wrap_exceptions
def list_runbook_export_statuses(ctx, from_json, all_pages, page_size, compartment_id, id, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if id is not None:
        kwargs['id'] = id
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management_runbooks', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_runbook_export_statuses,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_runbook_export_statuses,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_runbook_export_statuses(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@runbook_import_status_collection_group.command(name=cli_util.override('fleet_apps_management_runbooks.list_runbook_import_statuses.command_name', 'list-runbook-import-statuses'), help=u"""Returns a list of all the Runbook import status in the specified compartment. The query parameter `compartmentId` is required. \n[Command Reference](listRunbookImportStatuses)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ID of the compartment in which to list resources.""")
@cli_util.option('--id', help=u"""Unique identifier or OCID for listing a single Runbook by id. Either compartmentId or id must be provided.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'fleet_apps_management', 'class': 'RunbookImportStatusCollection'})
@cli_util.wrap_exceptions
def list_runbook_import_statuses(ctx, from_json, all_pages, page_size, compartment_id, id, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if id is not None:
        kwargs['id'] = id
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management_runbooks', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_runbook_import_statuses,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_runbook_import_statuses,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_runbook_import_statuses(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@runbook_version_collection_group.command(name=cli_util.override('fleet_apps_management_runbooks.list_runbook_versions.command_name', 'list-runbook-versions'), help=u"""List versions for a runbook in Fleet Application Management. \n[Command Reference](listRunbookVersions)""")
@cli_util.option('--compartment-id', help=u"""The ID of the compartment in which to list resources. Empty only if the resource OCID query param is not specified.""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "DELETED", "FAILED", "NEEDS_ATTENTION", "INACTIVE", "CREATING", "DELETING", "UPDATING"]), help=u"""A filter to return only resources whose lifecycleState matches the given lifecycleState.""")
@cli_util.option('--runbook-id', help=u"""A filter to return only schedule definitions whose associated runbookId matches the given runbookId.""")
@cli_util.option('--id', help=u"""A filter to return runbook versions whose identifier matches the given identifier.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.""")
@cli_util.option('--name', help=u"""A filter to return only resources that match the entire name given.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'fleet_apps_management', 'class': 'RunbookVersionCollection'})
@cli_util.wrap_exceptions
def list_runbook_versions(ctx, from_json, all_pages, page_size, compartment_id, lifecycle_state, runbook_id, id, limit, page, sort_order, sort_by, name):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if compartment_id is not None:
        kwargs['compartment_id'] = compartment_id
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    if runbook_id is not None:
        kwargs['runbook_id'] = runbook_id
    if id is not None:
        kwargs['id'] = id
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if name is not None:
        kwargs['name'] = name
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management_runbooks', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_runbook_versions,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_runbook_versions,
            limit,
            page_size,
            **kwargs
        )
    else:
        result = client.list_runbook_versions(
            **kwargs
        )
    cli_util.render_response(result, ctx)


@runbook_collection_group.command(name=cli_util.override('fleet_apps_management_runbooks.list_runbooks.command_name', 'list-runbooks'), help=u"""Returns a list of all the runbooks in the specified compartment. The query parameter `compartmentId` is required unless the query parameter `id` is specified. \n[Command Reference](listRunbooks)""")
@cli_util.option('--compartment-id', help=u"""The ID of the compartment in which to list resources. Empty only if the resource OCID query param is not specified.""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "DELETED", "FAILED", "INACTIVE", "CREATING", "DELETING", "UPDATING"]), help=u"""A filter to return only resources whose lifecycleState matches the given lifecycleState.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the entire display name given.""")
@cli_util.option('--id', help=u"""Unique identifier or OCID for listing a single Runbook by id. Either compartmentId or id must be provided.""")
@cli_util.option('--type', type=custom_types.CliCaseInsensitiveChoice(["USER_DEFINED", "ORACLE_DEFINED", "SYSTEM_DEFINED"]), help=u"""A filter to return runbooks whose type matches the given type.""")
@cli_util.option('--platform', help=u"""A filter to return runbooks whose platform matches the given platform.""")
@cli_util.option('--operation', help=u"""A filter to return runbooks whose operation matches the given lifecycle operation.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'fleet_apps_management', 'class': 'RunbookCollection'})
@cli_util.wrap_exceptions
def list_runbooks(ctx, from_json, all_pages, page_size, compartment_id, lifecycle_state, display_name, id, type, platform, operation, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if compartment_id is not None:
        kwargs['compartment_id'] = compartment_id
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    if display_name is not None:
        kwargs['display_name'] = display_name
    if id is not None:
        kwargs['id'] = id
    if type is not None:
        kwargs['type'] = type
    if platform is not None:
        kwargs['platform'] = platform
    if operation is not None:
        kwargs['operation'] = operation
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management_runbooks', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_runbooks,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_runbooks,
            limit,
            page_size,
            **kwargs
        )
    else:
        result = client.list_runbooks(
            **kwargs
        )
    cli_util.render_response(result, ctx)


@task_record_collection_group.command(name=cli_util.override('fleet_apps_management_runbooks.list_task_records.command_name', 'list-task-records'), help=u"""Returns a list of all the task records in the specified compartment. The query parameter `compartmentId` is required unless the query parameter `id` is specified. \n[Command Reference](listTaskRecords)""")
@cli_util.option('--compartment-id', help=u"""The ID of the compartment in which to list resources. Empty only if the resource OCID query param is not specified.""")
@cli_util.option('--platform', help=u"""The platform for the task record.""")
@cli_util.option('--type', type=custom_types.CliCaseInsensitiveChoice(["USER_DEFINED", "ORACLE_DEFINED", "SYSTEM_DEFINED"]), help=u"""The type of the Task.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the entire display name given.""")
@cli_util.option('--operation', help=u"""A filter to return task records whose operation matches the given lifecycle operation.""")
@cli_util.option('--id', help=u"""Unique identifier or OCID for listing a single task record by id. Either compartmentId or id must be provided.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "INACTIVE", "DELETED", "DELETING", "FAILED", "UPDATING"]), help=u"""The current state of the task record.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'fleet_apps_management', 'class': 'TaskRecordCollection'})
@cli_util.wrap_exceptions
def list_task_records(ctx, from_json, all_pages, page_size, compartment_id, platform, type, display_name, operation, id, limit, page, lifecycle_state, sort_by, sort_order):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if compartment_id is not None:
        kwargs['compartment_id'] = compartment_id
    if platform is not None:
        kwargs['platform'] = platform
    if type is not None:
        kwargs['type'] = type
    if display_name is not None:
        kwargs['display_name'] = display_name
    if operation is not None:
        kwargs['operation'] = operation
    if id is not None:
        kwargs['id'] = id
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management_runbooks', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_task_records,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_task_records,
            limit,
            page_size,
            **kwargs
        )
    else:
        result = client.list_task_records(
            **kwargs
        )
    cli_util.render_response(result, ctx)


@runbook_group.command(name=cli_util.override('fleet_apps_management_runbooks.publish_runbook.command_name', 'publish'), help=u"""Publish the specified version of the runbook. The specified version of the runbook becomes acitve when it is published.Only active versions of runbook can be used in execution. \n[Command Reference](publishRunbook)""")
@cli_util.option('--runbook-id', required=True, help=u"""The OCID of the resource.""")
@cli_util.option('--runbook-version-id', required=True, help=u"""The OCID of the resource.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def publish_runbook(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, runbook_id, runbook_version_id, if_match):

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['runbookId'] = runbook_id
    _details['runbookVersionId'] = runbook_version_id

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management_runbooks', ctx)
    result = client.publish_runbook(
        publish_runbook_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@runbook_group.command(name=cli_util.override('fleet_apps_management_runbooks.set_default_runbook.command_name', 'set-default'), help=u"""Set a runbook as default. \n[Command Reference](setDefaultRunbook)""")
@cli_util.option('--runbook-id', required=True, help=u"""The OCID of the resource.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'fleet_apps_management', 'class': 'Runbook'})
@cli_util.wrap_exceptions
def set_default_runbook(ctx, from_json, runbook_id, if_match):

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['runbookId'] = runbook_id

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management_runbooks', ctx)
    result = client.set_default_runbook(
        set_default_runbook_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@runbook_group.command(name=cli_util.override('fleet_apps_management_runbooks.update_runbook.command_name', 'update'), help=u"""Updates the runbook specified by the identifier. \n[Command Reference](updateRunbook)""")
@cli_util.option('--runbook-id', required=True, help=u"""Unique Runbook identifier""")
@cli_util.option('--display-name', help=u"""A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.

Example: `My new resource`""")
@cli_util.option('--description', help=u"""A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.""")
@cli_util.option('--is-sudo-access-needed', type=click.BOOL, help=u"""Does this runbook need SUDO access to execute?""")
@cli_util.option('--operation', help=u"""The lifecycle operation performed by the runbook.""")
@cli_util.option('--os-type', type=custom_types.CliCaseInsensitiveChoice(["WINDOWS", "LINUX", "GENERIC"]), help=u"""The OS type for the runbook.""")
@cli_util.option('--platform', help=u"""The platform of the runbook.""")
@cli_util.option('--is-default', type=click.BOOL, help=u"""Is the runbook default?""")
@cli_util.option('--estimated-time', help=u"""Estimated time to successfully complete the runbook execution.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, dict(str, object))'}})
@cli_util.wrap_exceptions
def update_runbook(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, runbook_id, display_name, description, is_sudo_access_needed, operation, os_type, platform, is_default, estimated_time, freeform_tags, defined_tags, if_match):

    if isinstance(runbook_id, six.string_types) and len(runbook_id.strip()) == 0:
        raise click.UsageError('Parameter --runbook-id cannot be whitespace or empty string')
    if not force:
        if freeform_tags or defined_tags:
            if not click.confirm("WARNING: Updates to freeform-tags and defined-tags will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if display_name is not None:
        _details['displayName'] = display_name

    if description is not None:
        _details['description'] = description

    if is_sudo_access_needed is not None:
        _details['isSudoAccessNeeded'] = is_sudo_access_needed

    if operation is not None:
        _details['operation'] = operation

    if os_type is not None:
        _details['osType'] = os_type

    if platform is not None:
        _details['platform'] = platform

    if is_default is not None:
        _details['isDefault'] = is_default

    if estimated_time is not None:
        _details['estimatedTime'] = estimated_time

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management_runbooks', ctx)
    result = client.update_runbook(
        runbook_id=runbook_id,
        update_runbook_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@runbook_version_group.command(name=cli_util.override('fleet_apps_management_runbooks.update_runbook_version.command_name', 'update'), help=u"""Updates the RunbookVersion. \n[Command Reference](updateRunbookVersion)""")
@cli_util.option('--runbook-version-id', required=True, help=u"""Unique Runbook Version identifier""")
@cli_util.option('--tasks', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A set of tasks to execute in the runbook.

This option is a JSON list with items of type Task.  For documentation on Task please see our API reference: https://docs.cloud.oracle.com/api/#/en/fleetappsmanagementrunbooks/20250228/datatypes/Task.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--groups', type=custom_types.CLI_COMPLEX_TYPE, help=u"""The groups of the runbook version.

This option is a JSON list with items of type Group.  For documentation on Group please see our API reference: https://docs.cloud.oracle.com/api/#/en/fleetappsmanagementrunbooks/20250228/datatypes/Group.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--execution-workflow-details', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--rollback-workflow-details', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'tasks': {'module': 'fleet_apps_management', 'class': 'list[Task]'}, 'groups': {'module': 'fleet_apps_management', 'class': 'list[Group]'}, 'execution-workflow-details': {'module': 'fleet_apps_management', 'class': 'ExecutionWorkflowDetails'}, 'rollback-workflow-details': {'module': 'fleet_apps_management', 'class': 'RollbackWorkflowDetails'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'tasks': {'module': 'fleet_apps_management', 'class': 'list[Task]'}, 'groups': {'module': 'fleet_apps_management', 'class': 'list[Group]'}, 'execution-workflow-details': {'module': 'fleet_apps_management', 'class': 'ExecutionWorkflowDetails'}, 'rollback-workflow-details': {'module': 'fleet_apps_management', 'class': 'RollbackWorkflowDetails'}})
@cli_util.wrap_exceptions
def update_runbook_version(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, runbook_version_id, tasks, groups, execution_workflow_details, rollback_workflow_details, if_match):

    if isinstance(runbook_version_id, six.string_types) and len(runbook_version_id.strip()) == 0:
        raise click.UsageError('Parameter --runbook-version-id cannot be whitespace or empty string')
    if not force:
        if tasks or groups or execution_workflow_details or rollback_workflow_details:
            if not click.confirm("WARNING: Updates to tasks and groups and execution-workflow-details and rollback-workflow-details will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if tasks is not None:
        _details['tasks'] = cli_util.parse_json_parameter("tasks", tasks)

    if groups is not None:
        _details['groups'] = cli_util.parse_json_parameter("groups", groups)

    if execution_workflow_details is not None:
        _details['executionWorkflowDetails'] = cli_util.parse_json_parameter("execution_workflow_details", execution_workflow_details)

    if rollback_workflow_details is not None:
        _details['rollbackWorkflowDetails'] = cli_util.parse_json_parameter("rollback_workflow_details", rollback_workflow_details)

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management_runbooks', ctx)
    result = client.update_runbook_version(
        runbook_version_id=runbook_version_id,
        update_runbook_version_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@task_record_group.command(name=cli_util.override('fleet_apps_management_runbooks.update_task_record.command_name', 'update'), help=u"""Updates certain attributes for the specified task record. \n[Command Reference](updateTaskRecord)""")
@cli_util.option('--task-record-id', required=True, help=u"""The OCID of the task record.""")
@cli_util.option('--display-name', help=u"""A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.

Example: `My new resource`""")
@cli_util.option('--description', help=u"""A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.""")
@cli_util.option('--details', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'details': {'module': 'fleet_apps_management', 'class': 'Details'}, 'freeform-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'details': {'module': 'fleet_apps_management', 'class': 'Details'}, 'freeform-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, dict(str, object))'}})
@cli_util.wrap_exceptions
def update_task_record(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, task_record_id, display_name, description, details, freeform_tags, defined_tags, if_match):

    if isinstance(task_record_id, six.string_types) and len(task_record_id.strip()) == 0:
        raise click.UsageError('Parameter --task-record-id cannot be whitespace or empty string')
    if not force:
        if details or freeform_tags or defined_tags:
            if not click.confirm("WARNING: Updates to details and freeform-tags and defined-tags will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if display_name is not None:
        _details['displayName'] = display_name

    if description is not None:
        _details['description'] = description

    if details is not None:
        _details['details'] = cli_util.parse_json_parameter("details", details)

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management_runbooks', ctx)
    result = client.update_task_record(
        task_record_id=task_record_id,
        update_task_record_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)
