# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228

from __future__ import print_function
import click
import oci  # noqa: F401
import six  # noqa: F401
import sys  # noqa: F401
from oci_cli import cli_constants  # noqa: F401
from oci_cli import cli_util
from oci_cli import json_skeleton_utils
from oci_cli import custom_types  # noqa: F401
from oci_cli.aliasing import CommandGroupWithAlias
from services.fleet_apps_management.src.oci_cli_fleet_apps_management.generated import fleet_apps_management_service_cli


@click.command(cli_util.override('fleet_apps_management.fleet_apps_management_root_group.command_name', 'fleet-apps-management'), cls=CommandGroupWithAlias, help=cli_util.override('fleet_apps_management.fleet_apps_management_root_group.help', """Fleet Application Management provides a centralized platform to help you automate resource management tasks, validate patch compliance, and enhance operational efficiency across an enterprise."""), short_help=cli_util.override('fleet_apps_management.fleet_apps_management_root_group.short_help', """Fleet Application Management Service API"""))
@cli_util.help_option_group
def fleet_apps_management_root_group():
    pass


@click.command(cli_util.override('fleet_apps_management.fleet_group.command_name', 'fleet'), cls=CommandGroupWithAlias, help="""A fleet is a collection or grouping of resources based on criteria.""")
@cli_util.help_option_group
def fleet_group():
    pass


@click.command(cli_util.override('fleet_apps_management.fleet_product_collection_group.command_name', 'fleet-product-collection'), cls=CommandGroupWithAlias, help="""Results of a fleetProduct search. Contains boh FleetProductSummary items and other information, such as metadata.""")
@cli_util.help_option_group
def fleet_product_collection_group():
    pass


@click.command(cli_util.override('fleet_apps_management.inventory_resource_collection_group.command_name', 'inventory-resource-collection'), cls=CommandGroupWithAlias, help="""Results of a inventoryResource search. Contains both InventoryResourceSummary items and other information, such as metadata.""")
@cli_util.help_option_group
def inventory_resource_collection_group():
    pass


@click.command(cli_util.override('fleet_apps_management.fleet_property_collection_group.command_name', 'fleet-property-collection'), cls=CommandGroupWithAlias, help="""Results of a fleetProperty search. Contains both FleetPropertySummary items and other information, such as metadata.""")
@cli_util.help_option_group
def fleet_property_collection_group():
    pass


@click.command(cli_util.override('fleet_apps_management.announcement_collection_group.command_name', 'announcement-collection'), cls=CommandGroupWithAlias, help="""Results of list announcements. Contains AnnouncementSummary items.""")
@cli_util.help_option_group
def announcement_collection_group():
    pass


@click.command(cli_util.override('fleet_apps_management.fleet_credential_group.command_name', 'fleet-credential'), cls=CommandGroupWithAlias, help="""Credential in Fleet Application Management.""")
@cli_util.help_option_group
def fleet_credential_group():
    pass


@click.command(cli_util.override('fleet_apps_management.fleet_resource_collection_group.command_name', 'fleet-resource-collection'), cls=CommandGroupWithAlias, help="""Results of a fleetResource search. Contains both FleetResourceSummary items and other information, such as metadata.""")
@cli_util.help_option_group
def fleet_resource_collection_group():
    pass


@click.command(cli_util.override('fleet_apps_management.compliance_report_group.command_name', 'compliance-report'), cls=CommandGroupWithAlias, help="""Compliance details for a fleet in Fleet Application Management.""")
@cli_util.help_option_group
def compliance_report_group():
    pass


@click.command(cli_util.override('fleet_apps_management.fleet_target_collection_group.command_name', 'fleet-target-collection'), cls=CommandGroupWithAlias, help="""Results of a fleetTarget search. Contains both FleetTargetSummary items and other information, such as metadata.""")
@cli_util.help_option_group
def fleet_target_collection_group():
    pass


@click.command(cli_util.override('fleet_apps_management.fleet_resource_group.command_name', 'fleet-resource'), cls=CommandGroupWithAlias, help="""Resource added to a fleet in Fleet Application Management.""")
@cli_util.help_option_group
def fleet_resource_group():
    pass


@click.command(cli_util.override('fleet_apps_management.compliance_group.command_name', 'compliance'), cls=CommandGroupWithAlias, help="""Compliance Summary""")
@cli_util.help_option_group
def compliance_group():
    pass


@click.command(cli_util.override('fleet_apps_management.fleet_property_group.command_name', 'fleet-property'), cls=CommandGroupWithAlias, help="""Property to manage fleet metadata details in Fleet Application Management.""")
@cli_util.help_option_group
def fleet_property_group():
    pass


@click.command(cli_util.override('fleet_apps_management.fleet_credential_collection_group.command_name', 'fleet-credential-collection'), cls=CommandGroupWithAlias, help="""Results of a fleetCredential search. Contains boh FleetCredentialSummary items and other information, such as metadata.""")
@cli_util.help_option_group
def fleet_credential_collection_group():
    pass


@click.command(cli_util.override('fleet_apps_management.fleet_collection_group.command_name', 'fleet-collection'), cls=CommandGroupWithAlias, help="""Results of a fleet search. Contains both FleetSummary items and other information, such as metadata.""")
@cli_util.help_option_group
def fleet_collection_group():
    pass


fleet_apps_management_service_cli.fleet_apps_management_service_group.add_command(fleet_apps_management_root_group)
fleet_apps_management_root_group.add_command(fleet_group)
fleet_apps_management_root_group.add_command(fleet_product_collection_group)
fleet_apps_management_root_group.add_command(inventory_resource_collection_group)
fleet_apps_management_root_group.add_command(fleet_property_collection_group)
fleet_apps_management_root_group.add_command(announcement_collection_group)
fleet_apps_management_root_group.add_command(fleet_credential_group)
fleet_apps_management_root_group.add_command(fleet_resource_collection_group)
fleet_apps_management_root_group.add_command(compliance_report_group)
fleet_apps_management_root_group.add_command(fleet_target_collection_group)
fleet_apps_management_root_group.add_command(fleet_resource_group)
fleet_apps_management_root_group.add_command(compliance_group)
fleet_apps_management_root_group.add_command(fleet_property_group)
fleet_apps_management_root_group.add_command(fleet_credential_collection_group)
fleet_apps_management_root_group.add_command(fleet_collection_group)
# oci fleet_apps_management fleet_apps_management --> oci fleet_apps_management
fleet_apps_management_service_cli.fleet_apps_management_service_group.commands.pop(fleet_apps_management_root_group.name)
fleet_apps_management_service_cli.fleet_apps_management_service_group.add_command(fleet_group)
fleet_apps_management_service_cli.fleet_apps_management_service_group.add_command(fleet_product_collection_group)
fleet_apps_management_service_cli.fleet_apps_management_service_group.add_command(inventory_resource_collection_group)
fleet_apps_management_service_cli.fleet_apps_management_service_group.add_command(fleet_property_collection_group)
fleet_apps_management_service_cli.fleet_apps_management_service_group.add_command(announcement_collection_group)
fleet_apps_management_service_cli.fleet_apps_management_service_group.add_command(fleet_credential_group)
fleet_apps_management_service_cli.fleet_apps_management_service_group.add_command(fleet_resource_collection_group)
fleet_apps_management_service_cli.fleet_apps_management_service_group.add_command(compliance_report_group)
fleet_apps_management_service_cli.fleet_apps_management_service_group.add_command(fleet_target_collection_group)
fleet_apps_management_service_cli.fleet_apps_management_service_group.add_command(fleet_resource_group)
fleet_apps_management_service_cli.fleet_apps_management_service_group.add_command(compliance_group)
fleet_apps_management_service_cli.fleet_apps_management_service_group.add_command(fleet_property_group)
fleet_apps_management_service_cli.fleet_apps_management_service_group.add_command(fleet_credential_collection_group)
fleet_apps_management_service_cli.fleet_apps_management_service_group.add_command(fleet_collection_group)


@fleet_group.command(name=cli_util.override('fleet_apps_management.change_fleet_compartment.command_name', 'change-compartment'), help=u"""Moves a Fleet into a different compartment within the same tenancy. For information about moving resources between compartments, see [Moving Resources to a Different Compartment]. \n[Command Reference](changeFleetCompartment)""")
@cli_util.option('--fleet-id', required=True, help=u"""Unique Fleet identifier.""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment to move the Fleet to.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def change_fleet_compartment(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, fleet_id, compartment_id, if_match):

    if isinstance(fleet_id, six.string_types) and len(fleet_id.strip()) == 0:
        raise click.UsageError('Parameter --fleet-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management', ctx)
    result = client.change_fleet_compartment(
        fleet_id=fleet_id,
        change_fleet_compartment_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@fleet_group.command(name=cli_util.override('fleet_apps_management.check_resource_tagging.command_name', 'check-resource-tagging'), help=u"""Check if Fleet Application Management tags can be added to the resources. \n[Command Reference](checkResourceTagging)""")
@cli_util.option('--compartment-id', required=True, help=u"""Compartment OCID""")
@cli_util.option('--resource-ids', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""Resource OCIDS that need to be verified if a tag can be enabled for them.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--fleet-display-name', help=u"""Fleet Display Name.""")
@json_skeleton_utils.get_cli_json_input_option({'resource-ids': {'module': 'fleet_apps_management', 'class': 'list[string]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'resource-ids': {'module': 'fleet_apps_management', 'class': 'list[string]'}}, output_type={'module': 'fleet_apps_management', 'class': 'ResourceTagCheckDetails'})
@cli_util.wrap_exceptions
def check_resource_tagging(ctx, from_json, compartment_id, resource_ids, fleet_display_name):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id
    _details['resourceIds'] = cli_util.parse_json_parameter("resource_ids", resource_ids)

    if fleet_display_name is not None:
        _details['fleetDisplayName'] = fleet_display_name

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management', ctx)
    result = client.check_resource_tagging(
        check_resource_tagging_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@fleet_group.command(name=cli_util.override('fleet_apps_management.confirm_targets.command_name', 'confirm-targets'), help=u"""Confirm targets to be managed for a Fleet. Only targets that are confirmed will be managed by Fleet Application Management. \n[Command Reference](confirmTargets)""")
@cli_util.option('--targets', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""The targets to confirm.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--fleet-id', required=True, help=u"""Unique Fleet identifier.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'targets': {'module': 'fleet_apps_management', 'class': 'list[DiscoveredTarget]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'targets': {'module': 'fleet_apps_management', 'class': 'list[DiscoveredTarget]'}})
@cli_util.wrap_exceptions
def confirm_targets(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, targets, fleet_id):

    if isinstance(fleet_id, six.string_types) and len(fleet_id.strip()) == 0:
        raise click.UsageError('Parameter --fleet-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['targets'] = cli_util.parse_json_parameter("targets", targets)

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management', ctx)
    result = client.confirm_targets(
        fleet_id=fleet_id,
        confirm_targets_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@fleet_group.command(name=cli_util.override('fleet_apps_management.create_fleet.command_name', 'create'), help=u"""Create a fleet in Fleet Application Management. \n[Command Reference](createFleet)""")
@cli_util.option('--display-name', required=True, help=u"""A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.

Example: `My new resource`""")
@cli_util.option('--compartment-id', required=True, help=u"""compartment OCID""")
@cli_util.option('--resource-selection', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--description', help=u"""A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.""")
@cli_util.option('--details', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--products', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Products associated with the Fleet. Provide PlatformConfiguration Ids corresponding to all the Products that need to be managed.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--environment-type', help=u"""Environment Type associated with the Fleet. Applicable for ENVIRONMENT fleet types.""")
@cli_util.option('--notification-preferences', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Notification Preferences associated with the Fleet.

This option is a JSON list with items of type NotificationPreference.  For documentation on NotificationPreference please see our API reference: https://docs.cloud.oracle.com/api/#/en/fleetappsmanagement/20250228/datatypes/NotificationPreference.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--resources', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Resources associated with the Fleet if resourceSelectionType is MANUAL.

This option is a JSON list with items of type AssociatedFleetResourceDetails.  For documentation on AssociatedFleetResourceDetails please see our API reference: https://docs.cloud.oracle.com/api/#/en/fleetappsmanagement/20250228/datatypes/AssociatedFleetResourceDetails.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--credentials', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Credentials associated with the Fleet.

This option is a JSON list with items of type AssociatedFleetCredentialDetails.  For documentation on AssociatedFleetCredentialDetails please see our API reference: https://docs.cloud.oracle.com/api/#/en/fleetappsmanagement/20250228/datatypes/AssociatedFleetCredentialDetails.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--properties', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Properties associated with the Fleet.

This option is a JSON list with items of type AssociatedFleetPropertyDetails.  For documentation on AssociatedFleetPropertyDetails please see our API reference: https://docs.cloud.oracle.com/api/#/en/fleetappsmanagement/20250228/datatypes/AssociatedFleetPropertyDetails.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--parent-fleet-id', help=u"""The [OCID] of the fleet that would be the parent for this fleet.""")
@cli_util.option('--is-target-auto-confirm', type=click.BOOL, help=u"""A value that represents if auto-confirming of the targets can be enabled. This will allow targets to be auto-confirmed in the fleet without manual intervention.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'details': {'module': 'fleet_apps_management', 'class': 'FleetDetails'}, 'products': {'module': 'fleet_apps_management', 'class': 'list[string]'}, 'resource-selection': {'module': 'fleet_apps_management', 'class': 'ResourceSelection'}, 'notification-preferences': {'module': 'fleet_apps_management', 'class': 'list[NotificationPreference]'}, 'resources': {'module': 'fleet_apps_management', 'class': 'list[AssociatedFleetResourceDetails]'}, 'credentials': {'module': 'fleet_apps_management', 'class': 'list[AssociatedFleetCredentialDetails]'}, 'properties': {'module': 'fleet_apps_management', 'class': 'list[AssociatedFleetPropertyDetails]'}, 'freeform-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'details': {'module': 'fleet_apps_management', 'class': 'FleetDetails'}, 'products': {'module': 'fleet_apps_management', 'class': 'list[string]'}, 'resource-selection': {'module': 'fleet_apps_management', 'class': 'ResourceSelection'}, 'notification-preferences': {'module': 'fleet_apps_management', 'class': 'list[NotificationPreference]'}, 'resources': {'module': 'fleet_apps_management', 'class': 'list[AssociatedFleetResourceDetails]'}, 'credentials': {'module': 'fleet_apps_management', 'class': 'list[AssociatedFleetCredentialDetails]'}, 'properties': {'module': 'fleet_apps_management', 'class': 'list[AssociatedFleetPropertyDetails]'}, 'freeform-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'fleet_apps_management', 'class': 'Fleet'})
@cli_util.wrap_exceptions
def create_fleet(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, display_name, compartment_id, resource_selection, description, details, products, environment_type, notification_preferences, resources, credentials, properties, parent_fleet_id, is_target_auto_confirm, freeform_tags, defined_tags):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['displayName'] = display_name
    _details['compartmentId'] = compartment_id
    _details['resourceSelection'] = cli_util.parse_json_parameter("resource_selection", resource_selection)

    if description is not None:
        _details['description'] = description

    if details is not None:
        _details['details'] = cli_util.parse_json_parameter("details", details)

    if products is not None:
        _details['products'] = cli_util.parse_json_parameter("products", products)

    if environment_type is not None:
        _details['environmentType'] = environment_type

    if notification_preferences is not None:
        _details['notificationPreferences'] = cli_util.parse_json_parameter("notification_preferences", notification_preferences)

    if resources is not None:
        _details['resources'] = cli_util.parse_json_parameter("resources", resources)

    if credentials is not None:
        _details['credentials'] = cli_util.parse_json_parameter("credentials", credentials)

    if properties is not None:
        _details['properties'] = cli_util.parse_json_parameter("properties", properties)

    if parent_fleet_id is not None:
        _details['parentFleetId'] = parent_fleet_id

    if is_target_auto_confirm is not None:
        _details['isTargetAutoConfirm'] = is_target_auto_confirm

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management', ctx)
    result = client.create_fleet(
        create_fleet_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@fleet_group.command(name=cli_util.override('fleet_apps_management.create_fleet_dynamic_resource_selection.command_name', 'create-fleet-dynamic-resource-selection'), help=u"""Create a fleet in Fleet Application Management. \n[Command Reference](createFleet)""")
@cli_util.option('--display-name', required=True, help=u"""A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.

Example: `My new resource`""")
@cli_util.option('--compartment-id', required=True, help=u"""compartment OCID""")
@cli_util.option('--resource-selection-rule-selection-criteria', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--description', help=u"""A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.""")
@cli_util.option('--details', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--products', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Products associated with the Fleet. Provide PlatformConfiguration Ids corresponding to all the Products that need to be managed.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--environment-type', help=u"""Environment Type associated with the Fleet. Applicable for ENVIRONMENT fleet types.""")
@cli_util.option('--notification-preferences', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Notification Preferences associated with the Fleet.

This option is a JSON list with items of type NotificationPreference.  For documentation on NotificationPreference please see our API reference: https://docs.cloud.oracle.com/api/#/en/fleetappsmanagement/20250228/datatypes/NotificationPreference.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--resources', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Resources associated with the Fleet if resourceSelectionType is MANUAL.

This option is a JSON list with items of type AssociatedFleetResourceDetails.  For documentation on AssociatedFleetResourceDetails please see our API reference: https://docs.cloud.oracle.com/api/#/en/fleetappsmanagement/20250228/datatypes/AssociatedFleetResourceDetails.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--credentials', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Credentials associated with the Fleet.

This option is a JSON list with items of type AssociatedFleetCredentialDetails.  For documentation on AssociatedFleetCredentialDetails please see our API reference: https://docs.cloud.oracle.com/api/#/en/fleetappsmanagement/20250228/datatypes/AssociatedFleetCredentialDetails.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--properties', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Properties associated with the Fleet.

This option is a JSON list with items of type AssociatedFleetPropertyDetails.  For documentation on AssociatedFleetPropertyDetails please see our API reference: https://docs.cloud.oracle.com/api/#/en/fleetappsmanagement/20250228/datatypes/AssociatedFleetPropertyDetails.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--parent-fleet-id', help=u"""The [OCID] of the fleet that would be the parent for this fleet.""")
@cli_util.option('--is-target-auto-confirm', type=click.BOOL, help=u"""A value that represents if auto-confirming of the targets can be enabled. This will allow targets to be auto-confirmed in the fleet without manual intervention.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'details': {'module': 'fleet_apps_management', 'class': 'FleetDetails'}, 'products': {'module': 'fleet_apps_management', 'class': 'list[string]'}, 'notification-preferences': {'module': 'fleet_apps_management', 'class': 'list[NotificationPreference]'}, 'resources': {'module': 'fleet_apps_management', 'class': 'list[AssociatedFleetResourceDetails]'}, 'credentials': {'module': 'fleet_apps_management', 'class': 'list[AssociatedFleetCredentialDetails]'}, 'properties': {'module': 'fleet_apps_management', 'class': 'list[AssociatedFleetPropertyDetails]'}, 'freeform-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, dict(str, object))'}, 'resource-selection-rule-selection-criteria': {'module': 'fleet_apps_management', 'class': 'SelectionCriteria'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'details': {'module': 'fleet_apps_management', 'class': 'FleetDetails'}, 'products': {'module': 'fleet_apps_management', 'class': 'list[string]'}, 'notification-preferences': {'module': 'fleet_apps_management', 'class': 'list[NotificationPreference]'}, 'resources': {'module': 'fleet_apps_management', 'class': 'list[AssociatedFleetResourceDetails]'}, 'credentials': {'module': 'fleet_apps_management', 'class': 'list[AssociatedFleetCredentialDetails]'}, 'properties': {'module': 'fleet_apps_management', 'class': 'list[AssociatedFleetPropertyDetails]'}, 'freeform-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, dict(str, object))'}, 'resource-selection-rule-selection-criteria': {'module': 'fleet_apps_management', 'class': 'SelectionCriteria'}}, output_type={'module': 'fleet_apps_management', 'class': 'Fleet'})
@cli_util.wrap_exceptions
def create_fleet_dynamic_resource_selection(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, display_name, compartment_id, resource_selection_rule_selection_criteria, description, details, products, environment_type, notification_preferences, resources, credentials, properties, parent_fleet_id, is_target_auto_confirm, freeform_tags, defined_tags):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['resourceSelection'] = {}
    _details['displayName'] = display_name
    _details['compartmentId'] = compartment_id
    _details['resourceSelection']['ruleSelectionCriteria'] = cli_util.parse_json_parameter("resource_selection_rule_selection_criteria", resource_selection_rule_selection_criteria)

    if description is not None:
        _details['description'] = description

    if details is not None:
        _details['details'] = cli_util.parse_json_parameter("details", details)

    if products is not None:
        _details['products'] = cli_util.parse_json_parameter("products", products)

    if environment_type is not None:
        _details['environmentType'] = environment_type

    if notification_preferences is not None:
        _details['notificationPreferences'] = cli_util.parse_json_parameter("notification_preferences", notification_preferences)

    if resources is not None:
        _details['resources'] = cli_util.parse_json_parameter("resources", resources)

    if credentials is not None:
        _details['credentials'] = cli_util.parse_json_parameter("credentials", credentials)

    if properties is not None:
        _details['properties'] = cli_util.parse_json_parameter("properties", properties)

    if parent_fleet_id is not None:
        _details['parentFleetId'] = parent_fleet_id

    if is_target_auto_confirm is not None:
        _details['isTargetAutoConfirm'] = is_target_auto_confirm

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    _details['resourceSelection']['resourceSelectionType'] = 'DYNAMIC'

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management', ctx)
    result = client.create_fleet(
        create_fleet_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@fleet_group.command(name=cli_util.override('fleet_apps_management.create_fleet_manual_resource_selection.command_name', 'create-fleet-manual-resource-selection'), help=u"""Create a fleet in Fleet Application Management. \n[Command Reference](createFleet)""")
@cli_util.option('--display-name', required=True, help=u"""A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.

Example: `My new resource`""")
@cli_util.option('--compartment-id', required=True, help=u"""compartment OCID""")
@cli_util.option('--description', help=u"""A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.""")
@cli_util.option('--details', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--products', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Products associated with the Fleet. Provide PlatformConfiguration Ids corresponding to all the Products that need to be managed.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--environment-type', help=u"""Environment Type associated with the Fleet. Applicable for ENVIRONMENT fleet types.""")
@cli_util.option('--notification-preferences', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Notification Preferences associated with the Fleet.

This option is a JSON list with items of type NotificationPreference.  For documentation on NotificationPreference please see our API reference: https://docs.cloud.oracle.com/api/#/en/fleetappsmanagement/20250228/datatypes/NotificationPreference.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--resources', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Resources associated with the Fleet if resourceSelectionType is MANUAL.

This option is a JSON list with items of type AssociatedFleetResourceDetails.  For documentation on AssociatedFleetResourceDetails please see our API reference: https://docs.cloud.oracle.com/api/#/en/fleetappsmanagement/20250228/datatypes/AssociatedFleetResourceDetails.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--credentials', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Credentials associated with the Fleet.

This option is a JSON list with items of type AssociatedFleetCredentialDetails.  For documentation on AssociatedFleetCredentialDetails please see our API reference: https://docs.cloud.oracle.com/api/#/en/fleetappsmanagement/20250228/datatypes/AssociatedFleetCredentialDetails.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--properties', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Properties associated with the Fleet.

This option is a JSON list with items of type AssociatedFleetPropertyDetails.  For documentation on AssociatedFleetPropertyDetails please see our API reference: https://docs.cloud.oracle.com/api/#/en/fleetappsmanagement/20250228/datatypes/AssociatedFleetPropertyDetails.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--parent-fleet-id', help=u"""The [OCID] of the fleet that would be the parent for this fleet.""")
@cli_util.option('--is-target-auto-confirm', type=click.BOOL, help=u"""A value that represents if auto-confirming of the targets can be enabled. This will allow targets to be auto-confirmed in the fleet without manual intervention.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'details': {'module': 'fleet_apps_management', 'class': 'FleetDetails'}, 'products': {'module': 'fleet_apps_management', 'class': 'list[string]'}, 'notification-preferences': {'module': 'fleet_apps_management', 'class': 'list[NotificationPreference]'}, 'resources': {'module': 'fleet_apps_management', 'class': 'list[AssociatedFleetResourceDetails]'}, 'credentials': {'module': 'fleet_apps_management', 'class': 'list[AssociatedFleetCredentialDetails]'}, 'properties': {'module': 'fleet_apps_management', 'class': 'list[AssociatedFleetPropertyDetails]'}, 'freeform-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'details': {'module': 'fleet_apps_management', 'class': 'FleetDetails'}, 'products': {'module': 'fleet_apps_management', 'class': 'list[string]'}, 'notification-preferences': {'module': 'fleet_apps_management', 'class': 'list[NotificationPreference]'}, 'resources': {'module': 'fleet_apps_management', 'class': 'list[AssociatedFleetResourceDetails]'}, 'credentials': {'module': 'fleet_apps_management', 'class': 'list[AssociatedFleetCredentialDetails]'}, 'properties': {'module': 'fleet_apps_management', 'class': 'list[AssociatedFleetPropertyDetails]'}, 'freeform-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'fleet_apps_management', 'class': 'Fleet'})
@cli_util.wrap_exceptions
def create_fleet_manual_resource_selection(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, display_name, compartment_id, description, details, products, environment_type, notification_preferences, resources, credentials, properties, parent_fleet_id, is_target_auto_confirm, freeform_tags, defined_tags):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['resourceSelection'] = {}
    _details['displayName'] = display_name
    _details['compartmentId'] = compartment_id

    if description is not None:
        _details['description'] = description

    if details is not None:
        _details['details'] = cli_util.parse_json_parameter("details", details)

    if products is not None:
        _details['products'] = cli_util.parse_json_parameter("products", products)

    if environment_type is not None:
        _details['environmentType'] = environment_type

    if notification_preferences is not None:
        _details['notificationPreferences'] = cli_util.parse_json_parameter("notification_preferences", notification_preferences)

    if resources is not None:
        _details['resources'] = cli_util.parse_json_parameter("resources", resources)

    if credentials is not None:
        _details['credentials'] = cli_util.parse_json_parameter("credentials", credentials)

    if properties is not None:
        _details['properties'] = cli_util.parse_json_parameter("properties", properties)

    if parent_fleet_id is not None:
        _details['parentFleetId'] = parent_fleet_id

    if is_target_auto_confirm is not None:
        _details['isTargetAutoConfirm'] = is_target_auto_confirm

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    _details['resourceSelection']['resourceSelectionType'] = 'MANUAL'

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management', ctx)
    result = client.create_fleet(
        create_fleet_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@fleet_group.command(name=cli_util.override('fleet_apps_management.create_fleet_group_fleet_details.command_name', 'create-fleet-group-fleet-details'), help=u"""Create a fleet in Fleet Application Management. \n[Command Reference](createFleet)""")
@cli_util.option('--display-name', required=True, help=u"""A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.

Example: `My new resource`""")
@cli_util.option('--compartment-id', required=True, help=u"""compartment OCID""")
@cli_util.option('--resource-selection', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--description', help=u"""A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.""")
@cli_util.option('--products', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Products associated with the Fleet. Provide PlatformConfiguration Ids corresponding to all the Products that need to be managed.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--environment-type', help=u"""Environment Type associated with the Fleet. Applicable for ENVIRONMENT fleet types.""")
@cli_util.option('--notification-preferences', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Notification Preferences associated with the Fleet.

This option is a JSON list with items of type NotificationPreference.  For documentation on NotificationPreference please see our API reference: https://docs.cloud.oracle.com/api/#/en/fleetappsmanagement/20250228/datatypes/NotificationPreference.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--resources', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Resources associated with the Fleet if resourceSelectionType is MANUAL.

This option is a JSON list with items of type AssociatedFleetResourceDetails.  For documentation on AssociatedFleetResourceDetails please see our API reference: https://docs.cloud.oracle.com/api/#/en/fleetappsmanagement/20250228/datatypes/AssociatedFleetResourceDetails.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--credentials', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Credentials associated with the Fleet.

This option is a JSON list with items of type AssociatedFleetCredentialDetails.  For documentation on AssociatedFleetCredentialDetails please see our API reference: https://docs.cloud.oracle.com/api/#/en/fleetappsmanagement/20250228/datatypes/AssociatedFleetCredentialDetails.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--properties', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Properties associated with the Fleet.

This option is a JSON list with items of type AssociatedFleetPropertyDetails.  For documentation on AssociatedFleetPropertyDetails please see our API reference: https://docs.cloud.oracle.com/api/#/en/fleetappsmanagement/20250228/datatypes/AssociatedFleetPropertyDetails.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--parent-fleet-id', help=u"""The [OCID] of the fleet that would be the parent for this fleet.""")
@cli_util.option('--is-target-auto-confirm', type=click.BOOL, help=u"""A value that represents if auto-confirming of the targets can be enabled. This will allow targets to be auto-confirmed in the fleet without manual intervention.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'products': {'module': 'fleet_apps_management', 'class': 'list[string]'}, 'resource-selection': {'module': 'fleet_apps_management', 'class': 'ResourceSelection'}, 'notification-preferences': {'module': 'fleet_apps_management', 'class': 'list[NotificationPreference]'}, 'resources': {'module': 'fleet_apps_management', 'class': 'list[AssociatedFleetResourceDetails]'}, 'credentials': {'module': 'fleet_apps_management', 'class': 'list[AssociatedFleetCredentialDetails]'}, 'properties': {'module': 'fleet_apps_management', 'class': 'list[AssociatedFleetPropertyDetails]'}, 'freeform-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'products': {'module': 'fleet_apps_management', 'class': 'list[string]'}, 'resource-selection': {'module': 'fleet_apps_management', 'class': 'ResourceSelection'}, 'notification-preferences': {'module': 'fleet_apps_management', 'class': 'list[NotificationPreference]'}, 'resources': {'module': 'fleet_apps_management', 'class': 'list[AssociatedFleetResourceDetails]'}, 'credentials': {'module': 'fleet_apps_management', 'class': 'list[AssociatedFleetCredentialDetails]'}, 'properties': {'module': 'fleet_apps_management', 'class': 'list[AssociatedFleetPropertyDetails]'}, 'freeform-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'fleet_apps_management', 'class': 'Fleet'})
@cli_util.wrap_exceptions
def create_fleet_group_fleet_details(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, display_name, compartment_id, resource_selection, description, products, environment_type, notification_preferences, resources, credentials, properties, parent_fleet_id, is_target_auto_confirm, freeform_tags, defined_tags):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['details'] = {}
    _details['displayName'] = display_name
    _details['compartmentId'] = compartment_id
    _details['resourceSelection'] = cli_util.parse_json_parameter("resource_selection", resource_selection)

    if description is not None:
        _details['description'] = description

    if products is not None:
        _details['products'] = cli_util.parse_json_parameter("products", products)

    if environment_type is not None:
        _details['environmentType'] = environment_type

    if notification_preferences is not None:
        _details['notificationPreferences'] = cli_util.parse_json_parameter("notification_preferences", notification_preferences)

    if resources is not None:
        _details['resources'] = cli_util.parse_json_parameter("resources", resources)

    if credentials is not None:
        _details['credentials'] = cli_util.parse_json_parameter("credentials", credentials)

    if properties is not None:
        _details['properties'] = cli_util.parse_json_parameter("properties", properties)

    if parent_fleet_id is not None:
        _details['parentFleetId'] = parent_fleet_id

    if is_target_auto_confirm is not None:
        _details['isTargetAutoConfirm'] = is_target_auto_confirm

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    _details['details']['fleetType'] = 'GROUP'

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management', ctx)
    result = client.create_fleet(
        create_fleet_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@fleet_group.command(name=cli_util.override('fleet_apps_management.create_fleet_product_fleet_details.command_name', 'create-fleet-product-fleet-details'), help=u"""Create a fleet in Fleet Application Management. \n[Command Reference](createFleet)""")
@cli_util.option('--display-name', required=True, help=u"""A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.

Example: `My new resource`""")
@cli_util.option('--compartment-id', required=True, help=u"""compartment OCID""")
@cli_util.option('--resource-selection', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--description', help=u"""A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.""")
@cli_util.option('--products', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Products associated with the Fleet. Provide PlatformConfiguration Ids corresponding to all the Products that need to be managed.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--environment-type', help=u"""Environment Type associated with the Fleet. Applicable for ENVIRONMENT fleet types.""")
@cli_util.option('--notification-preferences', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Notification Preferences associated with the Fleet.

This option is a JSON list with items of type NotificationPreference.  For documentation on NotificationPreference please see our API reference: https://docs.cloud.oracle.com/api/#/en/fleetappsmanagement/20250228/datatypes/NotificationPreference.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--resources', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Resources associated with the Fleet if resourceSelectionType is MANUAL.

This option is a JSON list with items of type AssociatedFleetResourceDetails.  For documentation on AssociatedFleetResourceDetails please see our API reference: https://docs.cloud.oracle.com/api/#/en/fleetappsmanagement/20250228/datatypes/AssociatedFleetResourceDetails.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--credentials', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Credentials associated with the Fleet.

This option is a JSON list with items of type AssociatedFleetCredentialDetails.  For documentation on AssociatedFleetCredentialDetails please see our API reference: https://docs.cloud.oracle.com/api/#/en/fleetappsmanagement/20250228/datatypes/AssociatedFleetCredentialDetails.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--properties', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Properties associated with the Fleet.

This option is a JSON list with items of type AssociatedFleetPropertyDetails.  For documentation on AssociatedFleetPropertyDetails please see our API reference: https://docs.cloud.oracle.com/api/#/en/fleetappsmanagement/20250228/datatypes/AssociatedFleetPropertyDetails.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--parent-fleet-id', help=u"""The [OCID] of the fleet that would be the parent for this fleet.""")
@cli_util.option('--is-target-auto-confirm', type=click.BOOL, help=u"""A value that represents if auto-confirming of the targets can be enabled. This will allow targets to be auto-confirmed in the fleet without manual intervention.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'products': {'module': 'fleet_apps_management', 'class': 'list[string]'}, 'resource-selection': {'module': 'fleet_apps_management', 'class': 'ResourceSelection'}, 'notification-preferences': {'module': 'fleet_apps_management', 'class': 'list[NotificationPreference]'}, 'resources': {'module': 'fleet_apps_management', 'class': 'list[AssociatedFleetResourceDetails]'}, 'credentials': {'module': 'fleet_apps_management', 'class': 'list[AssociatedFleetCredentialDetails]'}, 'properties': {'module': 'fleet_apps_management', 'class': 'list[AssociatedFleetPropertyDetails]'}, 'freeform-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'products': {'module': 'fleet_apps_management', 'class': 'list[string]'}, 'resource-selection': {'module': 'fleet_apps_management', 'class': 'ResourceSelection'}, 'notification-preferences': {'module': 'fleet_apps_management', 'class': 'list[NotificationPreference]'}, 'resources': {'module': 'fleet_apps_management', 'class': 'list[AssociatedFleetResourceDetails]'}, 'credentials': {'module': 'fleet_apps_management', 'class': 'list[AssociatedFleetCredentialDetails]'}, 'properties': {'module': 'fleet_apps_management', 'class': 'list[AssociatedFleetPropertyDetails]'}, 'freeform-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'fleet_apps_management', 'class': 'Fleet'})
@cli_util.wrap_exceptions
def create_fleet_product_fleet_details(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, display_name, compartment_id, resource_selection, description, products, environment_type, notification_preferences, resources, credentials, properties, parent_fleet_id, is_target_auto_confirm, freeform_tags, defined_tags):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['details'] = {}
    _details['displayName'] = display_name
    _details['compartmentId'] = compartment_id
    _details['resourceSelection'] = cli_util.parse_json_parameter("resource_selection", resource_selection)

    if description is not None:
        _details['description'] = description

    if products is not None:
        _details['products'] = cli_util.parse_json_parameter("products", products)

    if environment_type is not None:
        _details['environmentType'] = environment_type

    if notification_preferences is not None:
        _details['notificationPreferences'] = cli_util.parse_json_parameter("notification_preferences", notification_preferences)

    if resources is not None:
        _details['resources'] = cli_util.parse_json_parameter("resources", resources)

    if credentials is not None:
        _details['credentials'] = cli_util.parse_json_parameter("credentials", credentials)

    if properties is not None:
        _details['properties'] = cli_util.parse_json_parameter("properties", properties)

    if parent_fleet_id is not None:
        _details['parentFleetId'] = parent_fleet_id

    if is_target_auto_confirm is not None:
        _details['isTargetAutoConfirm'] = is_target_auto_confirm

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    _details['details']['fleetType'] = 'PRODUCT'

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management', ctx)
    result = client.create_fleet(
        create_fleet_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@fleet_group.command(name=cli_util.override('fleet_apps_management.create_fleet_generic_fleet_details.command_name', 'create-fleet-generic-fleet-details'), help=u"""Create a fleet in Fleet Application Management. \n[Command Reference](createFleet)""")
@cli_util.option('--display-name', required=True, help=u"""A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.

Example: `My new resource`""")
@cli_util.option('--compartment-id', required=True, help=u"""compartment OCID""")
@cli_util.option('--resource-selection', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--description', help=u"""A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.""")
@cli_util.option('--products', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Products associated with the Fleet. Provide PlatformConfiguration Ids corresponding to all the Products that need to be managed.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--environment-type', help=u"""Environment Type associated with the Fleet. Applicable for ENVIRONMENT fleet types.""")
@cli_util.option('--notification-preferences', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Notification Preferences associated with the Fleet.

This option is a JSON list with items of type NotificationPreference.  For documentation on NotificationPreference please see our API reference: https://docs.cloud.oracle.com/api/#/en/fleetappsmanagement/20250228/datatypes/NotificationPreference.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--resources', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Resources associated with the Fleet if resourceSelectionType is MANUAL.

This option is a JSON list with items of type AssociatedFleetResourceDetails.  For documentation on AssociatedFleetResourceDetails please see our API reference: https://docs.cloud.oracle.com/api/#/en/fleetappsmanagement/20250228/datatypes/AssociatedFleetResourceDetails.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--credentials', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Credentials associated with the Fleet.

This option is a JSON list with items of type AssociatedFleetCredentialDetails.  For documentation on AssociatedFleetCredentialDetails please see our API reference: https://docs.cloud.oracle.com/api/#/en/fleetappsmanagement/20250228/datatypes/AssociatedFleetCredentialDetails.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--properties', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Properties associated with the Fleet.

This option is a JSON list with items of type AssociatedFleetPropertyDetails.  For documentation on AssociatedFleetPropertyDetails please see our API reference: https://docs.cloud.oracle.com/api/#/en/fleetappsmanagement/20250228/datatypes/AssociatedFleetPropertyDetails.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--parent-fleet-id', help=u"""The [OCID] of the fleet that would be the parent for this fleet.""")
@cli_util.option('--is-target-auto-confirm', type=click.BOOL, help=u"""A value that represents if auto-confirming of the targets can be enabled. This will allow targets to be auto-confirmed in the fleet without manual intervention.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'products': {'module': 'fleet_apps_management', 'class': 'list[string]'}, 'resource-selection': {'module': 'fleet_apps_management', 'class': 'ResourceSelection'}, 'notification-preferences': {'module': 'fleet_apps_management', 'class': 'list[NotificationPreference]'}, 'resources': {'module': 'fleet_apps_management', 'class': 'list[AssociatedFleetResourceDetails]'}, 'credentials': {'module': 'fleet_apps_management', 'class': 'list[AssociatedFleetCredentialDetails]'}, 'properties': {'module': 'fleet_apps_management', 'class': 'list[AssociatedFleetPropertyDetails]'}, 'freeform-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'products': {'module': 'fleet_apps_management', 'class': 'list[string]'}, 'resource-selection': {'module': 'fleet_apps_management', 'class': 'ResourceSelection'}, 'notification-preferences': {'module': 'fleet_apps_management', 'class': 'list[NotificationPreference]'}, 'resources': {'module': 'fleet_apps_management', 'class': 'list[AssociatedFleetResourceDetails]'}, 'credentials': {'module': 'fleet_apps_management', 'class': 'list[AssociatedFleetCredentialDetails]'}, 'properties': {'module': 'fleet_apps_management', 'class': 'list[AssociatedFleetPropertyDetails]'}, 'freeform-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'fleet_apps_management', 'class': 'Fleet'})
@cli_util.wrap_exceptions
def create_fleet_generic_fleet_details(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, display_name, compartment_id, resource_selection, description, products, environment_type, notification_preferences, resources, credentials, properties, parent_fleet_id, is_target_auto_confirm, freeform_tags, defined_tags):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['details'] = {}
    _details['displayName'] = display_name
    _details['compartmentId'] = compartment_id
    _details['resourceSelection'] = cli_util.parse_json_parameter("resource_selection", resource_selection)

    if description is not None:
        _details['description'] = description

    if products is not None:
        _details['products'] = cli_util.parse_json_parameter("products", products)

    if environment_type is not None:
        _details['environmentType'] = environment_type

    if notification_preferences is not None:
        _details['notificationPreferences'] = cli_util.parse_json_parameter("notification_preferences", notification_preferences)

    if resources is not None:
        _details['resources'] = cli_util.parse_json_parameter("resources", resources)

    if credentials is not None:
        _details['credentials'] = cli_util.parse_json_parameter("credentials", credentials)

    if properties is not None:
        _details['properties'] = cli_util.parse_json_parameter("properties", properties)

    if parent_fleet_id is not None:
        _details['parentFleetId'] = parent_fleet_id

    if is_target_auto_confirm is not None:
        _details['isTargetAutoConfirm'] = is_target_auto_confirm

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    _details['details']['fleetType'] = 'GENERIC'

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management', ctx)
    result = client.create_fleet(
        create_fleet_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@fleet_group.command(name=cli_util.override('fleet_apps_management.create_fleet_environment_fleet_details.command_name', 'create-fleet-environment-fleet-details'), help=u"""Create a fleet in Fleet Application Management. \n[Command Reference](createFleet)""")
@cli_util.option('--display-name', required=True, help=u"""A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.

Example: `My new resource`""")
@cli_util.option('--compartment-id', required=True, help=u"""compartment OCID""")
@cli_util.option('--resource-selection', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--description', help=u"""A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.""")
@cli_util.option('--products', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Products associated with the Fleet. Provide PlatformConfiguration Ids corresponding to all the Products that need to be managed.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--environment-type', help=u"""Environment Type associated with the Fleet. Applicable for ENVIRONMENT fleet types.""")
@cli_util.option('--notification-preferences', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Notification Preferences associated with the Fleet.

This option is a JSON list with items of type NotificationPreference.  For documentation on NotificationPreference please see our API reference: https://docs.cloud.oracle.com/api/#/en/fleetappsmanagement/20250228/datatypes/NotificationPreference.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--resources', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Resources associated with the Fleet if resourceSelectionType is MANUAL.

This option is a JSON list with items of type AssociatedFleetResourceDetails.  For documentation on AssociatedFleetResourceDetails please see our API reference: https://docs.cloud.oracle.com/api/#/en/fleetappsmanagement/20250228/datatypes/AssociatedFleetResourceDetails.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--credentials', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Credentials associated with the Fleet.

This option is a JSON list with items of type AssociatedFleetCredentialDetails.  For documentation on AssociatedFleetCredentialDetails please see our API reference: https://docs.cloud.oracle.com/api/#/en/fleetappsmanagement/20250228/datatypes/AssociatedFleetCredentialDetails.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--properties', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Properties associated with the Fleet.

This option is a JSON list with items of type AssociatedFleetPropertyDetails.  For documentation on AssociatedFleetPropertyDetails please see our API reference: https://docs.cloud.oracle.com/api/#/en/fleetappsmanagement/20250228/datatypes/AssociatedFleetPropertyDetails.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--parent-fleet-id', help=u"""The [OCID] of the fleet that would be the parent for this fleet.""")
@cli_util.option('--is-target-auto-confirm', type=click.BOOL, help=u"""A value that represents if auto-confirming of the targets can be enabled. This will allow targets to be auto-confirmed in the fleet without manual intervention.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'products': {'module': 'fleet_apps_management', 'class': 'list[string]'}, 'resource-selection': {'module': 'fleet_apps_management', 'class': 'ResourceSelection'}, 'notification-preferences': {'module': 'fleet_apps_management', 'class': 'list[NotificationPreference]'}, 'resources': {'module': 'fleet_apps_management', 'class': 'list[AssociatedFleetResourceDetails]'}, 'credentials': {'module': 'fleet_apps_management', 'class': 'list[AssociatedFleetCredentialDetails]'}, 'properties': {'module': 'fleet_apps_management', 'class': 'list[AssociatedFleetPropertyDetails]'}, 'freeform-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'products': {'module': 'fleet_apps_management', 'class': 'list[string]'}, 'resource-selection': {'module': 'fleet_apps_management', 'class': 'ResourceSelection'}, 'notification-preferences': {'module': 'fleet_apps_management', 'class': 'list[NotificationPreference]'}, 'resources': {'module': 'fleet_apps_management', 'class': 'list[AssociatedFleetResourceDetails]'}, 'credentials': {'module': 'fleet_apps_management', 'class': 'list[AssociatedFleetCredentialDetails]'}, 'properties': {'module': 'fleet_apps_management', 'class': 'list[AssociatedFleetPropertyDetails]'}, 'freeform-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'fleet_apps_management', 'class': 'Fleet'})
@cli_util.wrap_exceptions
def create_fleet_environment_fleet_details(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, display_name, compartment_id, resource_selection, description, products, environment_type, notification_preferences, resources, credentials, properties, parent_fleet_id, is_target_auto_confirm, freeform_tags, defined_tags):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['details'] = {}
    _details['displayName'] = display_name
    _details['compartmentId'] = compartment_id
    _details['resourceSelection'] = cli_util.parse_json_parameter("resource_selection", resource_selection)

    if description is not None:
        _details['description'] = description

    if products is not None:
        _details['products'] = cli_util.parse_json_parameter("products", products)

    if environment_type is not None:
        _details['environmentType'] = environment_type

    if notification_preferences is not None:
        _details['notificationPreferences'] = cli_util.parse_json_parameter("notification_preferences", notification_preferences)

    if resources is not None:
        _details['resources'] = cli_util.parse_json_parameter("resources", resources)

    if credentials is not None:
        _details['credentials'] = cli_util.parse_json_parameter("credentials", credentials)

    if properties is not None:
        _details['properties'] = cli_util.parse_json_parameter("properties", properties)

    if parent_fleet_id is not None:
        _details['parentFleetId'] = parent_fleet_id

    if is_target_auto_confirm is not None:
        _details['isTargetAutoConfirm'] = is_target_auto_confirm

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    _details['details']['fleetType'] = 'ENVIRONMENT'

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management', ctx)
    result = client.create_fleet(
        create_fleet_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@fleet_credential_group.command(name=cli_util.override('fleet_apps_management.create_fleet_credential.command_name', 'create'), help=u"""Add credentials to a fleet in Fleet Application Management. \n[Command Reference](createFleetCredential)""")
@cli_util.option('--display-name', required=True, help=u"""A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.

Example: `My new resource`""")
@cli_util.option('--entity-specifics', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--user', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--password', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--fleet-id', required=True, help=u"""Unique Fleet identifier.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'entity-specifics': {'module': 'fleet_apps_management', 'class': 'CredentialEntitySpecificDetails'}, 'user': {'module': 'fleet_apps_management', 'class': 'CredentialDetails'}, 'password': {'module': 'fleet_apps_management', 'class': 'CredentialDetails'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'entity-specifics': {'module': 'fleet_apps_management', 'class': 'CredentialEntitySpecificDetails'}, 'user': {'module': 'fleet_apps_management', 'class': 'CredentialDetails'}, 'password': {'module': 'fleet_apps_management', 'class': 'CredentialDetails'}}, output_type={'module': 'fleet_apps_management', 'class': 'FleetCredential'})
@cli_util.wrap_exceptions
def create_fleet_credential(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, display_name, entity_specifics, user, password, fleet_id):

    if isinstance(fleet_id, six.string_types) and len(fleet_id.strip()) == 0:
        raise click.UsageError('Parameter --fleet-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['displayName'] = display_name
    _details['entitySpecifics'] = cli_util.parse_json_parameter("entity_specifics", entity_specifics)
    _details['user'] = cli_util.parse_json_parameter("user", user)
    _details['password'] = cli_util.parse_json_parameter("password", password)

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management', ctx)
    result = client.create_fleet_credential(
        fleet_id=fleet_id,
        create_fleet_credential_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@fleet_property_group.command(name=cli_util.override('fleet_apps_management.create_fleet_property.command_name', 'create'), help=u"""Add an existing global property to a fleet in Fleet Application Management. \n[Command Reference](createFleetProperty)""")
@cli_util.option('--value', required=True, help=u"""Value of the Property.""")
@cli_util.option('--property-id', required=True, help=u"""OCID referring to global level metadata property.""")
@cli_util.option('--fleet-id', required=True, help=u"""Unique Fleet identifier.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "DELETED", "FAILED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'fleet_apps_management', 'class': 'FleetProperty'})
@cli_util.wrap_exceptions
def create_fleet_property(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, value, property_id, fleet_id):

    if isinstance(fleet_id, six.string_types) and len(fleet_id.strip()) == 0:
        raise click.UsageError('Parameter --fleet-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['value'] = value
    _details['propertyId'] = property_id

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management', ctx)
    result = client.create_fleet_property(
        fleet_id=fleet_id,
        create_fleet_property_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_fleet_property') and callable(getattr(client, 'get_fleet_property')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_fleet_property(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@fleet_resource_group.command(name=cli_util.override('fleet_apps_management.create_fleet_resource.command_name', 'create'), help=u"""Add resource to a fleet in Fleet Application Management. \n[Command Reference](createFleetResource)""")
@cli_util.option('--resource-id', required=True, help=u"""The OCID of the resource.""")
@cli_util.option('--tenancy-id', required=True, help=u"""OCID of the tenancy to which the resource belongs to.""")
@cli_util.option('--compartment-id', required=True, help=u"""OCID of the compartment to which the resource belongs to.""")
@cli_util.option('--fleet-id', required=True, help=u"""Unique Fleet identifier.""")
@cli_util.option('--resource-region', help=u"""Associated region""")
@cli_util.option('--resource-type', help=u"""Type of the Resource.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'fleet_apps_management', 'class': 'FleetResource'})
@cli_util.wrap_exceptions
def create_fleet_resource(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, resource_id, tenancy_id, compartment_id, fleet_id, resource_region, resource_type):

    if isinstance(fleet_id, six.string_types) and len(fleet_id.strip()) == 0:
        raise click.UsageError('Parameter --fleet-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['resourceId'] = resource_id
    _details['tenancyId'] = tenancy_id
    _details['compartmentId'] = compartment_id

    if resource_region is not None:
        _details['resourceRegion'] = resource_region

    if resource_type is not None:
        _details['resourceType'] = resource_type

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management', ctx)
    result = client.create_fleet_resource(
        fleet_id=fleet_id,
        create_fleet_resource_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@fleet_group.command(name=cli_util.override('fleet_apps_management.delete_fleet.command_name', 'delete'), help=u"""Delete a fleet in Fleet Application Management. \n[Command Reference](deleteFleet)""")
@cli_util.option('--fleet-id', required=True, help=u"""Unique Fleet identifier.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_fleet(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, fleet_id, if_match):

    if isinstance(fleet_id, six.string_types) and len(fleet_id.strip()) == 0:
        raise click.UsageError('Parameter --fleet-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management', ctx)
    result = client.delete_fleet(
        fleet_id=fleet_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Please retrieve the work request to find its current state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@fleet_credential_group.command(name=cli_util.override('fleet_apps_management.delete_fleet_credential.command_name', 'delete'), help=u"""Deletes a credential associated with a fleet or with a product/target with in a fleet. \n[Command Reference](deleteFleetCredential)""")
@cli_util.option('--fleet-credential-id', required=True, help=u"""unique FleetCredential identifier""")
@cli_util.option('--fleet-id', required=True, help=u"""Unique Fleet identifier.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_fleet_credential(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, fleet_credential_id, fleet_id, if_match):

    if isinstance(fleet_credential_id, six.string_types) and len(fleet_credential_id.strip()) == 0:
        raise click.UsageError('Parameter --fleet-credential-id cannot be whitespace or empty string')

    if isinstance(fleet_id, six.string_types) and len(fleet_id.strip()) == 0:
        raise click.UsageError('Parameter --fleet-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management', ctx)
    result = client.delete_fleet_credential(
        fleet_credential_id=fleet_credential_id,
        fleet_id=fleet_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Please retrieve the work request to find its current state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@fleet_property_group.command(name=cli_util.override('fleet_apps_management.delete_fleet_property.command_name', 'delete'), help=u"""Deletes a property associated with a fleet in Fleet Application Management. \n[Command Reference](deleteFleetProperty)""")
@cli_util.option('--fleet-property-id', required=True, help=u"""Unique fleetProperty identifier.""")
@cli_util.option('--fleet-id', required=True, help=u"""Unique Fleet identifier.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_fleet_property(ctx, from_json, fleet_property_id, fleet_id, if_match):

    if isinstance(fleet_property_id, six.string_types) and len(fleet_property_id.strip()) == 0:
        raise click.UsageError('Parameter --fleet-property-id cannot be whitespace or empty string')

    if isinstance(fleet_id, six.string_types) and len(fleet_id.strip()) == 0:
        raise click.UsageError('Parameter --fleet-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management', ctx)
    result = client.delete_fleet_property(
        fleet_property_id=fleet_property_id,
        fleet_id=fleet_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@fleet_resource_group.command(name=cli_util.override('fleet_apps_management.delete_fleet_resource.command_name', 'delete'), help=u"""Removes a resource from the fleet in Fleet Application Management. \n[Command Reference](deleteFleetResource)""")
@cli_util.option('--fleet-resource-id', required=True, help=u"""unique FleetResource identifier""")
@cli_util.option('--fleet-id', required=True, help=u"""Unique Fleet identifier.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_fleet_resource(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, fleet_resource_id, fleet_id, if_match):

    if isinstance(fleet_resource_id, six.string_types) and len(fleet_resource_id.strip()) == 0:
        raise click.UsageError('Parameter --fleet-resource-id cannot be whitespace or empty string')

    if isinstance(fleet_id, six.string_types) and len(fleet_id.strip()) == 0:
        raise click.UsageError('Parameter --fleet-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management', ctx)
    result = client.delete_fleet_resource(
        fleet_resource_id=fleet_resource_id,
        fleet_id=fleet_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Please retrieve the work request to find its current state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@fleet_group.command(name=cli_util.override('fleet_apps_management.generate_compliance_report.command_name', 'generate-compliance-report'), help=u"""Generate compliance report for a Fleet. \n[Command Reference](generateComplianceReport)""")
@cli_util.option('--fleet-id', required=True, help=u"""Unique Fleet identifier.""")
@cli_util.option('--are-details-required', help=u"""A value that specifies if compliance details are required at the target level also? Allowed values are N and Y.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def generate_compliance_report(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, fleet_id, are_details_required):

    if isinstance(fleet_id, six.string_types) and len(fleet_id.strip()) == 0:
        raise click.UsageError('Parameter --fleet-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if are_details_required is not None:
        _details['areDetailsRequired'] = are_details_required

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management', ctx)
    result = client.generate_compliance_report(
        fleet_id=fleet_id,
        generate_compliance_report_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@compliance_group.command(name=cli_util.override('fleet_apps_management.get_compliance.command_name', 'get'), help=u"""Retrieve compliance for a fleet. \n[Command Reference](getCompliance)""")
@cli_util.option('--fleet-id', required=True, help=u"""Unique Fleet identifier.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'fleet_apps_management', 'class': 'Compliance'})
@cli_util.wrap_exceptions
def get_compliance(ctx, from_json, fleet_id):

    if isinstance(fleet_id, six.string_types) and len(fleet_id.strip()) == 0:
        raise click.UsageError('Parameter --fleet-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management', ctx)
    result = client.get_compliance(
        fleet_id=fleet_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@compliance_report_group.command(name=cli_util.override('fleet_apps_management.get_compliance_report.command_name', 'get'), help=u"""Retrieve compliance report for a fleet. \n[Command Reference](getComplianceReport)""")
@cli_util.option('--fleet-id', required=True, help=u"""Unique Fleet identifier.""")
@cli_util.option('--compliance-report-id', required=True, help=u"""compliance report identifier.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'fleet_apps_management', 'class': 'ComplianceReport'})
@cli_util.wrap_exceptions
def get_compliance_report(ctx, from_json, fleet_id, compliance_report_id):

    if isinstance(fleet_id, six.string_types) and len(fleet_id.strip()) == 0:
        raise click.UsageError('Parameter --fleet-id cannot be whitespace or empty string')

    if isinstance(compliance_report_id, six.string_types) and len(compliance_report_id.strip()) == 0:
        raise click.UsageError('Parameter --compliance-report-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management', ctx)
    result = client.get_compliance_report(
        fleet_id=fleet_id,
        compliance_report_id=compliance_report_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@fleet_group.command(name=cli_util.override('fleet_apps_management.get_fleet.command_name', 'get'), help=u"""Get the details of a fleet in Fleet Application Management. \n[Command Reference](getFleet)""")
@cli_util.option('--fleet-id', required=True, help=u"""Unique Fleet identifier.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'fleet_apps_management', 'class': 'Fleet'})
@cli_util.wrap_exceptions
def get_fleet(ctx, from_json, fleet_id):

    if isinstance(fleet_id, six.string_types) and len(fleet_id.strip()) == 0:
        raise click.UsageError('Parameter --fleet-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management', ctx)
    result = client.get_fleet(
        fleet_id=fleet_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@fleet_credential_group.command(name=cli_util.override('fleet_apps_management.get_fleet_credential.command_name', 'get'), help=u"""Gets a fleet credential by identifier. \n[Command Reference](getFleetCredential)""")
@cli_util.option('--fleet-credential-id', required=True, help=u"""unique FleetCredential identifier""")
@cli_util.option('--fleet-id', required=True, help=u"""Unique Fleet identifier.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'fleet_apps_management', 'class': 'FleetCredential'})
@cli_util.wrap_exceptions
def get_fleet_credential(ctx, from_json, fleet_credential_id, fleet_id):

    if isinstance(fleet_credential_id, six.string_types) and len(fleet_credential_id.strip()) == 0:
        raise click.UsageError('Parameter --fleet-credential-id cannot be whitespace or empty string')

    if isinstance(fleet_id, six.string_types) and len(fleet_id.strip()) == 0:
        raise click.UsageError('Parameter --fleet-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management', ctx)
    result = client.get_fleet_credential(
        fleet_credential_id=fleet_credential_id,
        fleet_id=fleet_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@fleet_property_group.command(name=cli_util.override('fleet_apps_management.get_fleet_property.command_name', 'get'), help=u"""Gets a fleet property by identifier. \n[Command Reference](getFleetProperty)""")
@cli_util.option('--fleet-property-id', required=True, help=u"""Unique fleetProperty identifier.""")
@cli_util.option('--fleet-id', required=True, help=u"""Unique Fleet identifier.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'fleet_apps_management', 'class': 'FleetProperty'})
@cli_util.wrap_exceptions
def get_fleet_property(ctx, from_json, fleet_property_id, fleet_id):

    if isinstance(fleet_property_id, six.string_types) and len(fleet_property_id.strip()) == 0:
        raise click.UsageError('Parameter --fleet-property-id cannot be whitespace or empty string')

    if isinstance(fleet_id, six.string_types) and len(fleet_id.strip()) == 0:
        raise click.UsageError('Parameter --fleet-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management', ctx)
    result = client.get_fleet_property(
        fleet_property_id=fleet_property_id,
        fleet_id=fleet_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@fleet_resource_group.command(name=cli_util.override('fleet_apps_management.get_fleet_resource.command_name', 'get'), help=u"""Gets a fleet resource by identifier. \n[Command Reference](getFleetResource)""")
@cli_util.option('--fleet-resource-id', required=True, help=u"""unique FleetResource identifier""")
@cli_util.option('--fleet-id', required=True, help=u"""Unique Fleet identifier.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'fleet_apps_management', 'class': 'FleetResource'})
@cli_util.wrap_exceptions
def get_fleet_resource(ctx, from_json, fleet_resource_id, fleet_id):

    if isinstance(fleet_resource_id, six.string_types) and len(fleet_resource_id.strip()) == 0:
        raise click.UsageError('Parameter --fleet-resource-id cannot be whitespace or empty string')

    if isinstance(fleet_id, six.string_types) and len(fleet_id.strip()) == 0:
        raise click.UsageError('Parameter --fleet-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management', ctx)
    result = client.get_fleet_resource(
        fleet_resource_id=fleet_resource_id,
        fleet_id=fleet_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@announcement_collection_group.command(name=cli_util.override('fleet_apps_management.list_announcements.command_name', 'list-announcements'), help=u"""Return a list of Announcement Summary items in a tenancy. \n[Command Reference](listAnnouncements)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ID of the compartment in which to list resources.""")
@cli_util.option('--summary-contains', help=u"""Filter the list of announcements that contains the given summary value.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the entire display name given.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeReleased", "summary"]), help=u"""The field to sort AnnouncementSummary by. Only one sort order may be provided. If no value is specified timeReleased is default.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'fleet_apps_management', 'class': 'AnnouncementCollection'})
@cli_util.wrap_exceptions
def list_announcements(ctx, from_json, all_pages, page_size, compartment_id, summary_contains, display_name, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if summary_contains is not None:
        kwargs['summary_contains'] = summary_contains
    if display_name is not None:
        kwargs['display_name'] = display_name
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_announcements,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_announcements,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_announcements(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@fleet_credential_collection_group.command(name=cli_util.override('fleet_apps_management.list_fleet_credentials.command_name', 'list-fleet-credentials'), help=u"""List credentials associated with a fleet. \n[Command Reference](listFleetCredentials)""")
@cli_util.option('--fleet-id', required=True, help=u"""Unique Fleet identifier.""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "DELETED", "FAILED"]), help=u"""A filter to return only resources whose lifecycleState matches the given lifecycleState.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the entire display name given.""")
@cli_util.option('--resource-id', help=u"""Resource Identifier""")
@cli_util.option('--target', help=u"""A filter to return only resources whose target matches the given target name.""")
@cli_util.option('--credential-level', type=custom_types.CliCaseInsensitiveChoice(["FLEET", "RESOURCE", "TARGET"]), help=u"""A filter to return only resources whose credentialLevel matches the given credentialLevel.""")
@cli_util.option('--id', help=u"""A filter to return only resources whose credential identifier matches the given identifier.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'fleet_apps_management', 'class': 'FleetCredentialCollection'})
@cli_util.wrap_exceptions
def list_fleet_credentials(ctx, from_json, all_pages, page_size, fleet_id, lifecycle_state, display_name, resource_id, target, credential_level, id, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(fleet_id, six.string_types) and len(fleet_id.strip()) == 0:
        raise click.UsageError('Parameter --fleet-id cannot be whitespace or empty string')

    kwargs = {}
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    if display_name is not None:
        kwargs['display_name'] = display_name
    if resource_id is not None:
        kwargs['resource_id'] = resource_id
    if target is not None:
        kwargs['target'] = target
    if credential_level is not None:
        kwargs['credential_level'] = credential_level
    if id is not None:
        kwargs['id'] = id
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_fleet_credentials,
            fleet_id=fleet_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_fleet_credentials,
            limit,
            page_size,
            fleet_id=fleet_id,
            **kwargs
        )
    else:
        result = client.list_fleet_credentials(
            fleet_id=fleet_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@fleet_product_collection_group.command(name=cli_util.override('fleet_apps_management.list_fleet_products.command_name', 'list-fleet-products'), help=u"""Returns a list of products associated with the confirmed targets. \n[Command Reference](listFleetProducts)""")
@cli_util.option('--fleet-id', required=True, help=u"""Unique Fleet identifier.""")
@cli_util.option('--compartment-id', help=u"""The ID of the compartment in which to list resources. Empty only if the resource OCID query param is not specified.""")
@cli_util.option('--resource-id', help=u"""Resource Identifier""")
@cli_util.option('--resource-display-name', help=u"""Resource Display Name.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the entire display name given.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["displayName", "resourceDisplayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for displayName and resourceDisplayName is ascending.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'fleet_apps_management', 'class': 'FleetProductCollection'})
@cli_util.wrap_exceptions
def list_fleet_products(ctx, from_json, all_pages, page_size, fleet_id, compartment_id, resource_id, resource_display_name, display_name, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(fleet_id, six.string_types) and len(fleet_id.strip()) == 0:
        raise click.UsageError('Parameter --fleet-id cannot be whitespace or empty string')

    kwargs = {}
    if compartment_id is not None:
        kwargs['compartment_id'] = compartment_id
    if resource_id is not None:
        kwargs['resource_id'] = resource_id
    if resource_display_name is not None:
        kwargs['resource_display_name'] = resource_display_name
    if display_name is not None:
        kwargs['display_name'] = display_name
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_fleet_products,
            fleet_id=fleet_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_fleet_products,
            limit,
            page_size,
            fleet_id=fleet_id,
            **kwargs
        )
    else:
        result = client.list_fleet_products(
            fleet_id=fleet_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@fleet_property_collection_group.command(name=cli_util.override('fleet_apps_management.list_fleet_properties.command_name', 'list-fleet-properties'), help=u"""List properties associated with a fleet. \n[Command Reference](listFleetProperties)""")
@cli_util.option('--fleet-id', required=True, help=u"""Unique Fleet identifier.""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "DELETED", "FAILED"]), help=u"""A filter to return only resources whose lifecycleState matches the given lifecycleState.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the entire display name given.""")
@cli_util.option('--id', help=u"""A filter to return only resources whose fleetProperty identifier matches the given identifier.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'fleet_apps_management', 'class': 'FleetPropertyCollection'})
@cli_util.wrap_exceptions
def list_fleet_properties(ctx, from_json, all_pages, page_size, fleet_id, lifecycle_state, display_name, id, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(fleet_id, six.string_types) and len(fleet_id.strip()) == 0:
        raise click.UsageError('Parameter --fleet-id cannot be whitespace or empty string')

    kwargs = {}
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    if display_name is not None:
        kwargs['display_name'] = display_name
    if id is not None:
        kwargs['id'] = id
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_fleet_properties,
            fleet_id=fleet_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_fleet_properties,
            limit,
            page_size,
            fleet_id=fleet_id,
            **kwargs
        )
    else:
        result = client.list_fleet_properties(
            fleet_id=fleet_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@fleet_resource_collection_group.command(name=cli_util.override('fleet_apps_management.list_fleet_resources.command_name', 'list-fleet-resources'), help=u"""List resources for a fleet in Fleet Application Management. \n[Command Reference](listFleetResources)""")
@cli_util.option('--fleet-id', required=True, help=u"""Unique Fleet identifier.""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "DELETED", "FAILED", "NEEDS_ATTENTION"]), help=u"""A filter to return only resources whose lifecycleState matches the given lifecycleState.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the entire display name given.""")
@cli_util.option('--id', help=u"""A filter to return only resources whose identifier matches the given identifier.""")
@cli_util.option('--fleet-resource-type', help=u"""A filter to return only resources whose resourceType matches the given resourceType.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'fleet_apps_management', 'class': 'FleetResourceCollection'})
@cli_util.wrap_exceptions
def list_fleet_resources(ctx, from_json, all_pages, page_size, fleet_id, lifecycle_state, display_name, id, fleet_resource_type, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(fleet_id, six.string_types) and len(fleet_id.strip()) == 0:
        raise click.UsageError('Parameter --fleet-id cannot be whitespace or empty string')

    kwargs = {}
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    if display_name is not None:
        kwargs['display_name'] = display_name
    if id is not None:
        kwargs['id'] = id
    if fleet_resource_type is not None:
        kwargs['fleet_resource_type'] = fleet_resource_type
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_fleet_resources,
            fleet_id=fleet_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_fleet_resources,
            limit,
            page_size,
            fleet_id=fleet_id,
            **kwargs
        )
    else:
        result = client.list_fleet_resources(
            fleet_id=fleet_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@fleet_target_collection_group.command(name=cli_util.override('fleet_apps_management.list_fleet_targets.command_name', 'list-fleet-targets'), help=u"""Returns the list of all confirmed targets within a fleet. \n[Command Reference](listFleetTargets)""")
@cli_util.option('--fleet-id', required=True, help=u"""Unique Fleet identifier.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the entire display name given.""")
@cli_util.option('--product', help=u"""Product Name.""")
@cli_util.option('--resource-id', help=u"""Resource Identifier""")
@cli_util.option('--resource-display-name', help=u"""Resource Display Name.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["displayName", "product", "resourceDisplayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for displayName,product and resourceDisplayName is ascending.""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "DELETED", "FAILED"]), help=u"""A filter to return fleets whose lifecycleState matches the given lifecycleState.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'fleet_apps_management', 'class': 'FleetTargetCollection'})
@cli_util.wrap_exceptions
def list_fleet_targets(ctx, from_json, all_pages, page_size, fleet_id, display_name, product, resource_id, resource_display_name, limit, page, sort_order, sort_by, lifecycle_state):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(fleet_id, six.string_types) and len(fleet_id.strip()) == 0:
        raise click.UsageError('Parameter --fleet-id cannot be whitespace or empty string')

    kwargs = {}
    if display_name is not None:
        kwargs['display_name'] = display_name
    if product is not None:
        kwargs['product'] = product
    if resource_id is not None:
        kwargs['resource_id'] = resource_id
    if resource_display_name is not None:
        kwargs['resource_display_name'] = resource_display_name
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_fleet_targets,
            fleet_id=fleet_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_fleet_targets,
            limit,
            page_size,
            fleet_id=fleet_id,
            **kwargs
        )
    else:
        result = client.list_fleet_targets(
            fleet_id=fleet_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@fleet_collection_group.command(name=cli_util.override('fleet_apps_management.list_fleets.command_name', 'list-fleets'), help=u"""Returns a list of all the Fleets in the specified compartment. The query parameter `compartmentId` is required unless the query parameter `id` is specified. \n[Command Reference](listFleets)""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "INACTIVE", "CREATING", "DELETED", "DELETING", "FAILED", "UPDATING", "NEEDS_ATTENTION"]), help=u"""A filter to return fleets whose lifecycleState matches the given lifecycleState.""")
@cli_util.option('--compartment-id', help=u"""The ID of the compartment in which to list resources. Empty only if the resource OCID query param is not specified.""")
@cli_util.option('--fleet-type', type=custom_types.CliCaseInsensitiveChoice(["GENERIC", "PRODUCT", "ENVIRONMENT", "GROUP"]), help=u"""A filter to return fleets whose fleetType matches the given fleetType.""")
@cli_util.option('--application-type', help=u"""A filter to return resources that match the Application Type/Product Stack given..""")
@cli_util.option('--product', help=u"""A filter to return resources that match the Product/Product Stack given.""")
@cli_util.option('--environment-type', help=u"""A filter to return resources that match the Environment Type given.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the entire display name given.""")
@cli_util.option('--id', help=u"""Unique identifier or OCID for listing a single fleet by id. Either compartmentId or id must be provided.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'fleet_apps_management', 'class': 'FleetCollection'})
@cli_util.wrap_exceptions
def list_fleets(ctx, from_json, all_pages, page_size, lifecycle_state, compartment_id, fleet_type, application_type, product, environment_type, display_name, id, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    if compartment_id is not None:
        kwargs['compartment_id'] = compartment_id
    if fleet_type is not None:
        kwargs['fleet_type'] = fleet_type
    if application_type is not None:
        kwargs['application_type'] = application_type
    if product is not None:
        kwargs['product'] = product
    if environment_type is not None:
        kwargs['environment_type'] = environment_type
    if display_name is not None:
        kwargs['display_name'] = display_name
    if id is not None:
        kwargs['id'] = id
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_fleets,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_fleets,
            limit,
            page_size,
            **kwargs
        )
    else:
        result = client.list_fleets(
            **kwargs
        )
    cli_util.render_response(result, ctx)


@inventory_resource_collection_group.command(name=cli_util.override('fleet_apps_management.list_inventory_resources.command_name', 'list-inventory-resources'), help=u"""Returns a list of Inventory Resources based on the criteria provided. instance, dbsystem, cloudvmcluster resources are supported. \n[Command Reference](listInventoryResources)""")
@cli_util.option('--compartment-id', required=True, help=u"""A filter to return only resources whose base Compartment ID(TenancyId) matches the given base Compartment ID.""")
@cli_util.option('--resource-compartment-id', required=True, help=u"""A filter to return only resources whose resource Compartment ID matches the given resource Compartment ID.""")
@cli_util.option('--lifecycle-state', help=u"""A filter to return only resources their lifecycleState matches the given lifecycleState.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the entire display name given.""")
@cli_util.option('--resource-region', help=u"""Resource Region""")
@cli_util.option('--defined-tag-equals', multiple=True, help=u"""A list of tag filters to apply.  Only resources with a defined tag matching the value will be returned. Each item in the list has the format \"{namespace}.{tagName}={value}\".  All inputs are case-insensitive. Multiple values for the same key (i.e. same namespace and tag name) are interpreted as \"OR\". Values for different keys (i.e. different namespaces, different tag names, or both) are interpreted as \"AND\". Example: Identification.Development=Yes""")
@cli_util.option('--freeform-tag-equals', multiple=True, help=u"""A list of tag filters to apply.  Only resources with a freeform tag matching the value will be returned. The key for each tag is \"{tagName}.{value}\".  All inputs are case-insensitive. Multiple values for the same tag name are interpreted as \"OR\".  Values for different tag names are interpreted as \"AND\".""")
@cli_util.option('--inventory-properties', multiple=True, help=u"""A list of inventory properties filters to apply. The key for each inventory property and value for each resource type is \"{resourceType}.{inventoryProperty}={value}\". Example: Instance.displayName=TEST_INSTANCE""")
@cli_util.option('--matching-criteria', help=u"""Fetch resources matching ANY or ALL criteria passed as params in \"tags\" and \"inventoryProperties\". Example: matchingCriteria=ANY""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({'defined-tag-equals': {'module': 'fleet_apps_management', 'class': 'list[string]'}, 'freeform-tag-equals': {'module': 'fleet_apps_management', 'class': 'list[string]'}, 'inventory-properties': {'module': 'fleet_apps_management', 'class': 'list[string]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'defined-tag-equals': {'module': 'fleet_apps_management', 'class': 'list[string]'}, 'freeform-tag-equals': {'module': 'fleet_apps_management', 'class': 'list[string]'}, 'inventory-properties': {'module': 'fleet_apps_management', 'class': 'list[string]'}}, output_type={'module': 'fleet_apps_management', 'class': 'InventoryResourceCollection'})
@cli_util.wrap_exceptions
def list_inventory_resources(ctx, from_json, all_pages, page_size, compartment_id, resource_compartment_id, lifecycle_state, display_name, resource_region, defined_tag_equals, freeform_tag_equals, inventory_properties, matching_criteria, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    if display_name is not None:
        kwargs['display_name'] = display_name
    if resource_region is not None:
        kwargs['resource_region'] = resource_region
    if defined_tag_equals is not None and len(defined_tag_equals) > 0:
        kwargs['defined_tag_equals'] = defined_tag_equals
    if freeform_tag_equals is not None and len(freeform_tag_equals) > 0:
        kwargs['freeform_tag_equals'] = freeform_tag_equals
    if inventory_properties is not None and len(inventory_properties) > 0:
        kwargs['inventory_properties'] = inventory_properties
    if matching_criteria is not None:
        kwargs['matching_criteria'] = matching_criteria
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_inventory_resources,
            compartment_id=compartment_id,
            resource_compartment_id=resource_compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_inventory_resources,
            limit,
            page_size,
            compartment_id=compartment_id,
            resource_compartment_id=resource_compartment_id,
            **kwargs
        )
    else:
        result = client.list_inventory_resources(
            compartment_id=compartment_id,
            resource_compartment_id=resource_compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@fleet_target_collection_group.command(name=cli_util.override('fleet_apps_management.list_targets.command_name', 'list-targets'), help=u"""Return all targets belonging to the resources within a fleet. It will include both confirmed and unconfirmed targets. \n[Command Reference](listTargets)""")
@cli_util.option('--fleet-id', required=True, help=u"""Unique Fleet identifier.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the entire display name given.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.""")
@cli_util.option('--is-confirmed-targets', type=click.BOOL, help=u"""If set to true, confirmed targets will be returned.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'fleet_apps_management', 'class': 'FleetTargetCollection'})
@cli_util.wrap_exceptions
def list_targets(ctx, from_json, all_pages, page_size, fleet_id, display_name, limit, page, sort_order, sort_by, is_confirmed_targets):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(fleet_id, six.string_types) and len(fleet_id.strip()) == 0:
        raise click.UsageError('Parameter --fleet-id cannot be whitespace or empty string')

    kwargs = {}
    if display_name is not None:
        kwargs['display_name'] = display_name
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if is_confirmed_targets is not None:
        kwargs['is_confirmed_targets'] = is_confirmed_targets
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_targets,
            fleet_id=fleet_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_targets,
            limit,
            page_size,
            fleet_id=fleet_id,
            **kwargs
        )
    else:
        result = client.list_targets(
            fleet_id=fleet_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@fleet_group.command(name=cli_util.override('fleet_apps_management.request_resource_validation.command_name', 'request-resource-validation'), help=u"""Request validation for resources within a fleet. \n[Command Reference](requestResourceValidation)""")
@cli_util.option('--fleet-id', required=True, help=u"""Unique Fleet identifier.""")
@cli_util.option('--is-applicable-to-all-resources', type=click.BOOL, help=u"""A boolean flag that decides if all resources within the fleet should be part of the validation.""")
@cli_util.option('--resource-ids', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Resource OCIDS to be included for validation.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'resource-ids': {'module': 'fleet_apps_management', 'class': 'list[string]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'resource-ids': {'module': 'fleet_apps_management', 'class': 'list[string]'}})
@cli_util.wrap_exceptions
def request_resource_validation(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, fleet_id, is_applicable_to_all_resources, resource_ids):

    if isinstance(fleet_id, six.string_types) and len(fleet_id.strip()) == 0:
        raise click.UsageError('Parameter --fleet-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if is_applicable_to_all_resources is not None:
        _details['isApplicableToAllResources'] = is_applicable_to_all_resources

    if resource_ids is not None:
        _details['resourceIds'] = cli_util.parse_json_parameter("resource_ids", resource_ids)

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management', ctx)
    result = client.request_resource_validation(
        fleet_id=fleet_id,
        request_resource_validation_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@fleet_group.command(name=cli_util.override('fleet_apps_management.request_target_discovery.command_name', 'request-target-discovery'), help=u"""Request target discovery for resources with in a fleet. \n[Command Reference](requestTargetDiscovery)""")
@cli_util.option('--fleet-id', required=True, help=u"""Unique Fleet identifier.""")
@cli_util.option('--is-applicable-to-all-resources', type=click.BOOL, help=u"""A boolean flag that decides if all resources within the fleet should be part of discovery.""")
@cli_util.option('--resource-ids', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Resource OCIDS to be included for discovery.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'resource-ids': {'module': 'fleet_apps_management', 'class': 'list[string]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'resource-ids': {'module': 'fleet_apps_management', 'class': 'list[string]'}})
@cli_util.wrap_exceptions
def request_target_discovery(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, fleet_id, is_applicable_to_all_resources, resource_ids):

    if isinstance(fleet_id, six.string_types) and len(fleet_id.strip()) == 0:
        raise click.UsageError('Parameter --fleet-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if is_applicable_to_all_resources is not None:
        _details['isApplicableToAllResources'] = is_applicable_to_all_resources

    if resource_ids is not None:
        _details['resourceIds'] = cli_util.parse_json_parameter("resource_ids", resource_ids)

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management', ctx)
    result = client.request_target_discovery(
        fleet_id=fleet_id,
        request_target_discovery_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@fleet_group.command(name=cli_util.override('fleet_apps_management.update_fleet.command_name', 'update'), help=u"""Update fleet information in Fleet Application Management. \n[Command Reference](updateFleet)""")
@cli_util.option('--fleet-id', required=True, help=u"""Unique Fleet identifier.""")
@cli_util.option('--display-name', help=u"""A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.

Example: `My new resource`""")
@cli_util.option('--description', help=u"""A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.""")
@cli_util.option('--notification-preferences', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Notification Preferences associated with the Fleet. An UPDATE operation replaces the existing notification preferences list entirely

This option is a JSON list with items of type NotificationPreference.  For documentation on NotificationPreference please see our API reference: https://docs.cloud.oracle.com/api/#/en/fleetappsmanagement/20250228/datatypes/NotificationPreference.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--is-target-auto-confirm', type=click.BOOL, help=u"""A value that represents if auto-confirming of the targets can be enabled. This will allow targets to be auto-confirmed in the fleet without manual intervention.""")
@cli_util.option('--resource-selection', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--products', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Products associated with the Fleet. Provide PlatformConfiguration Ids corresponding to all the Products that need to be managed.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--environment-type', help=u"""Environment Type associated with the Fleet. Applicable for ENVIRONMENT fleet types.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "INACTIVE", "CREATING", "DELETED", "DELETING", "FAILED", "UPDATING", "NEEDS_ATTENTION"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'notification-preferences': {'module': 'fleet_apps_management', 'class': 'list[NotificationPreference]'}, 'resource-selection': {'module': 'fleet_apps_management', 'class': 'ResourceSelection'}, 'products': {'module': 'fleet_apps_management', 'class': 'list[string]'}, 'freeform-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'notification-preferences': {'module': 'fleet_apps_management', 'class': 'list[NotificationPreference]'}, 'resource-selection': {'module': 'fleet_apps_management', 'class': 'ResourceSelection'}, 'products': {'module': 'fleet_apps_management', 'class': 'list[string]'}, 'freeform-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'fleet_apps_management', 'class': 'Fleet'})
@cli_util.wrap_exceptions
def update_fleet(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, fleet_id, display_name, description, notification_preferences, is_target_auto_confirm, resource_selection, products, freeform_tags, defined_tags, environment_type, if_match):

    if isinstance(fleet_id, six.string_types) and len(fleet_id.strip()) == 0:
        raise click.UsageError('Parameter --fleet-id cannot be whitespace or empty string')
    if not force:
        if notification_preferences or resource_selection or products or freeform_tags or defined_tags:
            if not click.confirm("WARNING: Updates to notification-preferences and resource-selection and products and freeform-tags and defined-tags will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if display_name is not None:
        _details['displayName'] = display_name

    if description is not None:
        _details['description'] = description

    if notification_preferences is not None:
        _details['notificationPreferences'] = cli_util.parse_json_parameter("notification_preferences", notification_preferences)

    if is_target_auto_confirm is not None:
        _details['isTargetAutoConfirm'] = is_target_auto_confirm

    if resource_selection is not None:
        _details['resourceSelection'] = cli_util.parse_json_parameter("resource_selection", resource_selection)

    if products is not None:
        _details['products'] = cli_util.parse_json_parameter("products", products)

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    if environment_type is not None:
        _details['environmentType'] = environment_type

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management', ctx)
    result = client.update_fleet(
        fleet_id=fleet_id,
        update_fleet_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_fleet') and callable(getattr(client, 'get_fleet')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_fleet(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@fleet_group.command(name=cli_util.override('fleet_apps_management.update_fleet_dynamic_resource_selection.command_name', 'update-fleet-dynamic-resource-selection'), help=u"""Update fleet information in Fleet Application Management. \n[Command Reference](updateFleet)""")
@cli_util.option('--fleet-id', required=True, help=u"""Unique Fleet identifier.""")
@cli_util.option('--resource-selection-rule-selection-criteria', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--display-name', help=u"""A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.

Example: `My new resource`""")
@cli_util.option('--description', help=u"""A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.""")
@cli_util.option('--notification-preferences', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Notification Preferences associated with the Fleet. An UPDATE operation replaces the existing notification preferences list entirely

This option is a JSON list with items of type NotificationPreference.  For documentation on NotificationPreference please see our API reference: https://docs.cloud.oracle.com/api/#/en/fleetappsmanagement/20250228/datatypes/NotificationPreference.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--is-target-auto-confirm', type=click.BOOL, help=u"""A value that represents if auto-confirming of the targets can be enabled. This will allow targets to be auto-confirmed in the fleet without manual intervention.""")
@cli_util.option('--products', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Products associated with the Fleet. Provide PlatformConfiguration Ids corresponding to all the Products that need to be managed.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--environment-type', help=u"""Environment Type associated with the Fleet. Applicable for ENVIRONMENT fleet types.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "INACTIVE", "CREATING", "DELETED", "DELETING", "FAILED", "UPDATING", "NEEDS_ATTENTION"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'notification-preferences': {'module': 'fleet_apps_management', 'class': 'list[NotificationPreference]'}, 'products': {'module': 'fleet_apps_management', 'class': 'list[string]'}, 'freeform-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, dict(str, object))'}, 'resource-selection-rule-selection-criteria': {'module': 'fleet_apps_management', 'class': 'SelectionCriteria'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'notification-preferences': {'module': 'fleet_apps_management', 'class': 'list[NotificationPreference]'}, 'products': {'module': 'fleet_apps_management', 'class': 'list[string]'}, 'freeform-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, dict(str, object))'}, 'resource-selection-rule-selection-criteria': {'module': 'fleet_apps_management', 'class': 'SelectionCriteria'}}, output_type={'module': 'fleet_apps_management', 'class': 'Fleet'})
@cli_util.wrap_exceptions
def update_fleet_dynamic_resource_selection(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, fleet_id, resource_selection_rule_selection_criteria, display_name, description, notification_preferences, is_target_auto_confirm, products, freeform_tags, defined_tags, environment_type, if_match):

    if isinstance(fleet_id, six.string_types) and len(fleet_id.strip()) == 0:
        raise click.UsageError('Parameter --fleet-id cannot be whitespace or empty string')
    if not force:
        if notification_preferences or products or freeform_tags or defined_tags:
            if not click.confirm("WARNING: Updates to notification-preferences and products and freeform-tags and defined-tags will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['resourceSelection'] = {}
    _details['resourceSelection']['ruleSelectionCriteria'] = cli_util.parse_json_parameter("resource_selection_rule_selection_criteria", resource_selection_rule_selection_criteria)

    if display_name is not None:
        _details['displayName'] = display_name

    if description is not None:
        _details['description'] = description

    if notification_preferences is not None:
        _details['notificationPreferences'] = cli_util.parse_json_parameter("notification_preferences", notification_preferences)

    if is_target_auto_confirm is not None:
        _details['isTargetAutoConfirm'] = is_target_auto_confirm

    if products is not None:
        _details['products'] = cli_util.parse_json_parameter("products", products)

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    if environment_type is not None:
        _details['environmentType'] = environment_type

    _details['resourceSelection']['resourceSelectionType'] = 'DYNAMIC'

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management', ctx)
    result = client.update_fleet(
        fleet_id=fleet_id,
        update_fleet_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_fleet') and callable(getattr(client, 'get_fleet')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_fleet(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@fleet_group.command(name=cli_util.override('fleet_apps_management.update_fleet_manual_resource_selection.command_name', 'update-fleet-manual-resource-selection'), help=u"""Update fleet information in Fleet Application Management. \n[Command Reference](updateFleet)""")
@cli_util.option('--fleet-id', required=True, help=u"""Unique Fleet identifier.""")
@cli_util.option('--display-name', help=u"""A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.

Example: `My new resource`""")
@cli_util.option('--description', help=u"""A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.""")
@cli_util.option('--notification-preferences', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Notification Preferences associated with the Fleet. An UPDATE operation replaces the existing notification preferences list entirely

This option is a JSON list with items of type NotificationPreference.  For documentation on NotificationPreference please see our API reference: https://docs.cloud.oracle.com/api/#/en/fleetappsmanagement/20250228/datatypes/NotificationPreference.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--is-target-auto-confirm', type=click.BOOL, help=u"""A value that represents if auto-confirming of the targets can be enabled. This will allow targets to be auto-confirmed in the fleet without manual intervention.""")
@cli_util.option('--products', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Products associated with the Fleet. Provide PlatformConfiguration Ids corresponding to all the Products that need to be managed.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--environment-type', help=u"""Environment Type associated with the Fleet. Applicable for ENVIRONMENT fleet types.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "INACTIVE", "CREATING", "DELETED", "DELETING", "FAILED", "UPDATING", "NEEDS_ATTENTION"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'notification-preferences': {'module': 'fleet_apps_management', 'class': 'list[NotificationPreference]'}, 'products': {'module': 'fleet_apps_management', 'class': 'list[string]'}, 'freeform-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'notification-preferences': {'module': 'fleet_apps_management', 'class': 'list[NotificationPreference]'}, 'products': {'module': 'fleet_apps_management', 'class': 'list[string]'}, 'freeform-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'fleet_apps_management', 'class': 'Fleet'})
@cli_util.wrap_exceptions
def update_fleet_manual_resource_selection(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, fleet_id, display_name, description, notification_preferences, is_target_auto_confirm, products, freeform_tags, defined_tags, environment_type, if_match):

    if isinstance(fleet_id, six.string_types) and len(fleet_id.strip()) == 0:
        raise click.UsageError('Parameter --fleet-id cannot be whitespace or empty string')
    if not force:
        if notification_preferences or products or freeform_tags or defined_tags:
            if not click.confirm("WARNING: Updates to notification-preferences and products and freeform-tags and defined-tags will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['resourceSelection'] = {}

    if display_name is not None:
        _details['displayName'] = display_name

    if description is not None:
        _details['description'] = description

    if notification_preferences is not None:
        _details['notificationPreferences'] = cli_util.parse_json_parameter("notification_preferences", notification_preferences)

    if is_target_auto_confirm is not None:
        _details['isTargetAutoConfirm'] = is_target_auto_confirm

    if products is not None:
        _details['products'] = cli_util.parse_json_parameter("products", products)

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    if environment_type is not None:
        _details['environmentType'] = environment_type

    _details['resourceSelection']['resourceSelectionType'] = 'MANUAL'

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management', ctx)
    result = client.update_fleet(
        fleet_id=fleet_id,
        update_fleet_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_fleet') and callable(getattr(client, 'get_fleet')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_fleet(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@fleet_credential_group.command(name=cli_util.override('fleet_apps_management.update_fleet_credential.command_name', 'update'), help=u"""Edit credential associated with a fleet or with a product/target with in a fleet. \n[Command Reference](updateFleetCredential)""")
@cli_util.option('--fleet-credential-id', required=True, help=u"""unique FleetCredential identifier""")
@cli_util.option('--fleet-id', required=True, help=u"""Unique Fleet identifier.""")
@cli_util.option('--display-name', help=u"""A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.

Example: `My new resource`""")
@cli_util.option('--entity-specifics', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--password', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'entity-specifics': {'module': 'fleet_apps_management', 'class': 'CredentialEntitySpecificDetails'}, 'user': {'module': 'fleet_apps_management', 'class': 'CredentialDetails'}, 'password': {'module': 'fleet_apps_management', 'class': 'CredentialDetails'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'entity-specifics': {'module': 'fleet_apps_management', 'class': 'CredentialEntitySpecificDetails'}, 'user': {'module': 'fleet_apps_management', 'class': 'CredentialDetails'}, 'password': {'module': 'fleet_apps_management', 'class': 'CredentialDetails'}})
@cli_util.wrap_exceptions
def update_fleet_credential(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, fleet_credential_id, fleet_id, display_name, entity_specifics, user, password, if_match):

    if isinstance(fleet_credential_id, six.string_types) and len(fleet_credential_id.strip()) == 0:
        raise click.UsageError('Parameter --fleet-credential-id cannot be whitespace or empty string')

    if isinstance(fleet_id, six.string_types) and len(fleet_id.strip()) == 0:
        raise click.UsageError('Parameter --fleet-id cannot be whitespace or empty string')
    if not force:
        if entity_specifics or user or password:
            if not click.confirm("WARNING: Updates to entity-specifics and user and password will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if display_name is not None:
        _details['displayName'] = display_name

    if entity_specifics is not None:
        _details['entitySpecifics'] = cli_util.parse_json_parameter("entity_specifics", entity_specifics)

    if user is not None:
        _details['user'] = cli_util.parse_json_parameter("user", user)

    if password is not None:
        _details['password'] = cli_util.parse_json_parameter("password", password)

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management', ctx)
    result = client.update_fleet_credential(
        fleet_credential_id=fleet_credential_id,
        fleet_id=fleet_id,
        update_fleet_credential_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@fleet_property_group.command(name=cli_util.override('fleet_apps_management.update_fleet_property.command_name', 'update'), help=u"""Edit a property associated with a fleet in Fleet Application Management. \n[Command Reference](updateFleetProperty)""")
@cli_util.option('--fleet-property-id', required=True, help=u"""Unique fleetProperty identifier.""")
@cli_util.option('--fleet-id', required=True, help=u"""Unique Fleet identifier.""")
@cli_util.option('--value', help=u"""Value of the Property.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "DELETED", "FAILED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'fleet_apps_management', 'class': 'FleetProperty'})
@cli_util.wrap_exceptions
def update_fleet_property(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, fleet_property_id, fleet_id, value, if_match):

    if isinstance(fleet_property_id, six.string_types) and len(fleet_property_id.strip()) == 0:
        raise click.UsageError('Parameter --fleet-property-id cannot be whitespace or empty string')

    if isinstance(fleet_id, six.string_types) and len(fleet_id.strip()) == 0:
        raise click.UsageError('Parameter --fleet-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if value is not None:
        _details['value'] = value

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management', ctx)
    result = client.update_fleet_property(
        fleet_property_id=fleet_property_id,
        fleet_id=fleet_id,
        update_fleet_property_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_fleet_property') and callable(getattr(client, 'get_fleet_property')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_fleet_property(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@fleet_resource_group.command(name=cli_util.override('fleet_apps_management.update_fleet_resource.command_name', 'update'), help=u"""Updates the FleetResource. \n[Command Reference](updateFleetResource)""")
@cli_util.option('--fleet-resource-id', required=True, help=u"""unique FleetResource identifier""")
@cli_util.option('--fleet-id', required=True, help=u"""Unique Fleet identifier.""")
@cli_util.option('--tenancy-id', help=u"""OCID of the tenancy to which the resource belongs to.""")
@cli_util.option('--compartment-id', help=u"""OCID of the compartment to which the resource belongs to.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def update_fleet_resource(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, fleet_resource_id, fleet_id, tenancy_id, compartment_id, if_match):

    if isinstance(fleet_resource_id, six.string_types) and len(fleet_resource_id.strip()) == 0:
        raise click.UsageError('Parameter --fleet-resource-id cannot be whitespace or empty string')

    if isinstance(fleet_id, six.string_types) and len(fleet_id.strip()) == 0:
        raise click.UsageError('Parameter --fleet-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if tenancy_id is not None:
        _details['tenancyId'] = tenancy_id

    if compartment_id is not None:
        _details['compartmentId'] = compartment_id

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management', ctx)
    result = client.update_fleet_resource(
        fleet_resource_id=fleet_resource_id,
        fleet_id=fleet_id,
        update_fleet_resource_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)
