# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240501

from __future__ import print_function
import click
import oci  # noqa: F401
import six  # noqa: F401
import sys  # noqa: F401
from oci_cli import cli_constants  # noqa: F401
from oci_cli import cli_util
from oci_cli import json_skeleton_utils
from oci_cli import custom_types  # noqa: F401
from oci_cli.aliasing import CommandGroupWithAlias
from services.dbmulticloud.src.oci_cli_dbmulticloud.generated import dbmulticloud_service_cli


@click.command(cli_util.override('db_multicloud_gcp_provider.db_multicloud_gcp_provider_root_group.command_name', 'db-multicloud-gcp-provider'), cls=CommandGroupWithAlias, help=cli_util.override('db_multicloud_gcp_provider.db_multicloud_gcp_provider_root_group.help', """<b>Microsoft Azure:</b> <br>
<b>Oracle Azure Connector Resource:</b>:&nbsp;&nbsp;The Oracle Azure Connector Resource is used to install the Azure Arc Server on an Exadata VM cluster in Oracle Exadata Database Service on Dedicated Infrastructure (ExaDB-D).
 The supported method to install the Azure Arc Server (Azure Identity) on the Exadata VM cluster:
<ul>
 <li>Using a Bearer Access Token</li>
</ul>

<b>Oracle Azure Blob Container Resource:</b>&nbsp;&nbsp;The Oracle Azure Blob Container Resource is used to capture the details of an Azure Blob Container.
This resource can then be reused across multiple Exadata VM clusters in Oracle Exadata Database Service on Dedicated Infrastructure (ExaDB-D) to mount the Azure container.

<b>Oracle Azure Blob Mount Resource:</b>&nbsp;&nbsp;The Oracle Azure Blob Mount Resource is used to mount an Azure Blob Container on an Exadata VM cluster in Oracle Exadata Database Service on Dedicated Infrastructure (ExaDB-D).
It relies on both the Oracle Azure Connector and the Oracle Azure Blob Container Resource to perform the mount operation.

<b>Discover Azure Vaults and Keys Resource:</b>&nbsp;&nbsp;The Discover Oracle Azure Vaults and Azure Keys Resource is used to discover Azure Vaults and the associated encryption keys available in your Azure project.

<b>Oracle Azure Vault:</b>&nbsp;&nbsp;The Oracle Azure Vault Resource is used to manage Azure Vaults within Oracle Cloud Infrastructure (OCI) for use with services such as Oracle Exadata Database Service on Dedicated Infrastructure.

<b>Oracle Azure Key:</b>&nbsp;&nbsp;Oracle Azure Key Resource is used to register and manage a Oracle Azure Key Key within Oracle Cloud Infrastructure (OCI) under an associated Azure Vault.

<br>

<b>Google Cloud:</b><br>
<b>Oracle Google Cloud Connector Resource:</b>&nbsp;&nbsp;The Oracle Google Cloud Connector Resource is used to install the Google Cloud Identity Connector on an Exadata VM cluster in Oracle Exadata Database Service on Dedicated Infrastructure (ExaDB-D).

<b>Discover Google Key Rings and Keys Resource:</b>&nbsp;&nbsp;The Discover Google Key Rings and Keys Resource is used to discover Google Cloud Key Rings and the associated encryption keys available in your Google Cloud project.

<b>Google Key Rings Resource:</b>&nbsp;&nbsp;The Google Key Rings Resource is used to register and manage Google Cloud Key Rings within Oracle Cloud Infrastructure (OCI) for use with services such as Oracle Exadata Database Service on Dedicated Infrastructure.

<b>Google Key Resource:</b>&nbsp;&nbsp;The Google Key Resource is used to register and manage a Google Cloud Key within Oracle Cloud Infrastructure (OCI) under an associated Google Key Ring."""), short_help=cli_util.override('db_multicloud_gcp_provider.db_multicloud_gcp_provider_root_group.short_help', """Oracle Database MultiCloud Data Plane Integration"""))
@cli_util.help_option_group
def db_multicloud_gcp_provider_root_group():
    pass


@click.command(cli_util.override('db_multicloud_gcp_provider.oracle_db_gcp_identity_connector_group.command_name', 'oracle-db-gcp-identity-connector'), cls=CommandGroupWithAlias, help="""This resource is used to create and manage a GCP Identity Connector for Oracle Database running on Oracle Exadata Database Service on Dedicated Infrastructure (ExaDB-D). The Identity Connector enables secure communication between Oracle Cloud and Google Cloud services.""")
@cli_util.help_option_group
def oracle_db_gcp_identity_connector_group():
    pass


@click.command(cli_util.override('db_multicloud_gcp_provider.oracle_db_gcp_key_ring_group.command_name', 'oracle-db-gcp-key-ring'), cls=CommandGroupWithAlias, help="""Oracle DB GCP Key Ring resource object.""")
@cli_util.help_option_group
def oracle_db_gcp_key_ring_group():
    pass


@click.command(cli_util.override('db_multicloud_gcp_provider.oracle_db_gcp_key_group.command_name', 'oracle-db-gcp-key'), cls=CommandGroupWithAlias, help="""Oracle DB Google Cloud Key resource.""")
@cli_util.help_option_group
def oracle_db_gcp_key_group():
    pass


dbmulticloud_service_cli.dbmulticloud_service_group.add_command(db_multicloud_gcp_provider_root_group)
db_multicloud_gcp_provider_root_group.add_command(oracle_db_gcp_identity_connector_group)
db_multicloud_gcp_provider_root_group.add_command(oracle_db_gcp_key_ring_group)
db_multicloud_gcp_provider_root_group.add_command(oracle_db_gcp_key_group)


@oracle_db_gcp_identity_connector_group.command(name=cli_util.override('db_multicloud_gcp_provider.change_oracle_db_gcp_identity_connector_compartment.command_name', 'change-compartment'), help=u"""Moves the Oracle DB GCP Identity Connector resource into a different compartment. When provided, 'If-Match' is checked against 'ETag' values of the resource. \n[Command Reference](changeOracleDbGcpIdentityConnectorCompartment)""")
@cli_util.option('--oracle-db-gcp-identity-connector-id', required=True, help=u"""The [OCID] of the Oracle DB GCP Identity Configuration Resource.""")
@cli_util.option('--compartment-id', help=u"""The OCID of the compartment that contains the Oracle DB GCP Identity Connector resource.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def change_oracle_db_gcp_identity_connector_compartment(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, oracle_db_gcp_identity_connector_id, compartment_id, if_match):

    if isinstance(oracle_db_gcp_identity_connector_id, six.string_types) and len(oracle_db_gcp_identity_connector_id.strip()) == 0:
        raise click.UsageError('Parameter --oracle-db-gcp-identity-connector-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if compartment_id is not None:
        _details['compartmentId'] = compartment_id

    client = cli_util.build_client('dbmulticloud', 'db_multicloud_gcp_provider', ctx)
    result = client.change_oracle_db_gcp_identity_connector_compartment(
        oracle_db_gcp_identity_connector_id=oracle_db_gcp_identity_connector_id,
        change_oracle_db_gcp_identity_connector_compartment_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@oracle_db_gcp_key_ring_group.command(name=cli_util.override('db_multicloud_gcp_provider.change_oracle_db_gcp_key_ring_compartment.command_name', 'change-compartment'), help=u"""Moves the GCP Key Ring resource into a different compartment. When provided, 'If-Match' is checked against 'ETag' values of the resource. \n[Command Reference](changeOracleDbGcpKeyRingCompartment)""")
@cli_util.option('--oracle-db-gcp-key-ring-id', required=True, help=u"""The [OCID] of the Oracle DB GCP Key-Ring resource.""")
@cli_util.option('--compartment-id', help=u"""The compartment [OCID] where the Oracle DB GCP Key Ring resource resides.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def change_oracle_db_gcp_key_ring_compartment(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, oracle_db_gcp_key_ring_id, compartment_id, if_match):

    if isinstance(oracle_db_gcp_key_ring_id, six.string_types) and len(oracle_db_gcp_key_ring_id.strip()) == 0:
        raise click.UsageError('Parameter --oracle-db-gcp-key-ring-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if compartment_id is not None:
        _details['compartmentId'] = compartment_id

    client = cli_util.build_client('dbmulticloud', 'db_multicloud_gcp_provider', ctx)
    result = client.change_oracle_db_gcp_key_ring_compartment(
        oracle_db_gcp_key_ring_id=oracle_db_gcp_key_ring_id,
        change_oracle_db_gcp_key_ring_compartment_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@oracle_db_gcp_identity_connector_group.command(name=cli_util.override('db_multicloud_gcp_provider.create_oracle_db_gcp_identity_connector.command_name', 'create'), help=u"""Creates Oracle DB GCP Identity Connector resource. \n[Command Reference](createOracleDbGcpIdentityConnector)""")
@cli_util.option('--display-name', required=True, help=u"""Oracle DB Google GCP Identity Connector resource name.""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment that contains the Oracle DB GCP Identity Connector resource.""")
@cli_util.option('--issuer-url', required=True, help=u"""OIDC token issuer Url""")
@cli_util.option('--project-id', required=True, help=u"""Project id of the customer project.""")
@cli_util.option('--resource-id', required=True, help=u"""The [OCID] of the GCP VM Cluster resource.""")
@cli_util.option('--gcp-location', required=True, help=u"""GCP Location.""")
@cli_util.option('--gcp-workload-identity-pool-id', required=True, help=u"""The ID of the cloud GCP Workload Identity Pool.""")
@cli_util.option('--gcp-workload-identity-provider-id', required=True, help=u"""The ID of the GCP Workload Identity Provider.""")
@cli_util.option('--gcp-resource-service-agent-id', required=True, help=u"""The ID of the GCP resource service agent.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags].

Example: `{\"Department\": \"Finance\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags].

Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'dbmulticloud', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'dbmulticloud', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'dbmulticloud', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'dbmulticloud', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'dbmulticloud', 'class': 'OracleDbGcpIdentityConnector'})
@cli_util.wrap_exceptions
def create_oracle_db_gcp_identity_connector(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, display_name, compartment_id, issuer_url, project_id, resource_id, gcp_location, gcp_workload_identity_pool_id, gcp_workload_identity_provider_id, gcp_resource_service_agent_id, freeform_tags, defined_tags):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['displayName'] = display_name
    _details['compartmentId'] = compartment_id
    _details['issuerUrl'] = issuer_url
    _details['projectId'] = project_id
    _details['resourceId'] = resource_id
    _details['gcpLocation'] = gcp_location
    _details['gcpWorkloadIdentityPoolId'] = gcp_workload_identity_pool_id
    _details['gcpWorkloadIdentityProviderId'] = gcp_workload_identity_provider_id
    _details['gcpResourceServiceAgentId'] = gcp_resource_service_agent_id

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('dbmulticloud', 'db_multicloud_gcp_provider', ctx)
    result = client.create_oracle_db_gcp_identity_connector(
        create_oracle_db_gcp_identity_connector_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@oracle_db_gcp_key_ring_group.command(name=cli_util.override('db_multicloud_gcp_provider.create_oracle_db_gcp_key_ring.command_name', 'create'), help=u"""Creates DB GCP Key Rings based on the provided information and retrieves the associated keys. \n[Command Reference](createOracleDbGcpKeyRing)""")
@cli_util.option('--compartment-id', required=True, help=u"""The compartment [OCID] where the Oracle DB GCP Key Ring resource resides.""")
@cli_util.option('--oracle-db-connector-id', required=True, help=u"""The [OCID] of the compartment where the Oracle DB GCP Identity Connector resource resides.""")
@cli_util.option('--display-name', required=True, help=u"""Display name of DB GCP Key Ring resource.""")
@cli_util.option('--gcp-key-ring-id', help=u"""GCP Key Ring ID.""")
@cli_util.option('--type', help=u"""Oracle DB GCP Key Ring resource Type.""")
@cli_util.option('--location', help=u"""Location of the GCP Key Ring resource.""")
@cli_util.option('--properties', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Oracle DB GCP Key Ring resource's properties.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags].

Example: `{\"Department\": \"Finance\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags].

Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'properties': {'module': 'dbmulticloud', 'class': 'dict(str, string)'}, 'freeform-tags': {'module': 'dbmulticloud', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'dbmulticloud', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'properties': {'module': 'dbmulticloud', 'class': 'dict(str, string)'}, 'freeform-tags': {'module': 'dbmulticloud', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'dbmulticloud', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'dbmulticloud', 'class': 'OracleDbGcpKeyRing'})
@cli_util.wrap_exceptions
def create_oracle_db_gcp_key_ring(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, compartment_id, oracle_db_connector_id, display_name, gcp_key_ring_id, type, location, properties, freeform_tags, defined_tags, if_match):

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id
    _details['oracleDbConnectorId'] = oracle_db_connector_id
    _details['displayName'] = display_name

    if gcp_key_ring_id is not None:
        _details['gcpKeyRingId'] = gcp_key_ring_id

    if type is not None:
        _details['type'] = type

    if location is not None:
        _details['location'] = location

    if properties is not None:
        _details['properties'] = cli_util.parse_json_parameter("properties", properties)

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('dbmulticloud', 'db_multicloud_gcp_provider', ctx)
    result = client.create_oracle_db_gcp_key_ring(
        create_oracle_db_gcp_key_ring_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@oracle_db_gcp_identity_connector_group.command(name=cli_util.override('db_multicloud_gcp_provider.delete_oracle_db_gcp_identity_connector.command_name', 'delete'), help=u"""Deletes the Oracle DB GCP Identity Connector resource and removes the associated connector from the database resource. \n[Command Reference](deleteOracleDbGcpIdentityConnector)""")
@cli_util.option('--oracle-db-gcp-identity-connector-id', required=True, help=u"""The [OCID] of the Oracle DB GCP Identity Configuration Resource.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_oracle_db_gcp_identity_connector(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, oracle_db_gcp_identity_connector_id, if_match):

    if isinstance(oracle_db_gcp_identity_connector_id, six.string_types) and len(oracle_db_gcp_identity_connector_id.strip()) == 0:
        raise click.UsageError('Parameter --oracle-db-gcp-identity-connector-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('dbmulticloud', 'db_multicloud_gcp_provider', ctx)
    result = client.delete_oracle_db_gcp_identity_connector(
        oracle_db_gcp_identity_connector_id=oracle_db_gcp_identity_connector_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Please retrieve the work request to find its current state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@oracle_db_gcp_key_ring_group.command(name=cli_util.override('db_multicloud_gcp_provider.delete_oracle_db_gcp_key_ring.command_name', 'delete'), help=u"""Deletes the GCP Key Ring and its associated metadata. \n[Command Reference](deleteOracleDbGcpKeyRing)""")
@cli_util.option('--oracle-db-gcp-key-ring-id', required=True, help=u"""The [OCID] of the Oracle DB GCP Key-Ring resource.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_oracle_db_gcp_key_ring(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, oracle_db_gcp_key_ring_id, if_match):

    if isinstance(oracle_db_gcp_key_ring_id, six.string_types) and len(oracle_db_gcp_key_ring_id.strip()) == 0:
        raise click.UsageError('Parameter --oracle-db-gcp-key-ring-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('dbmulticloud', 'db_multicloud_gcp_provider', ctx)
    result = client.delete_oracle_db_gcp_key_ring(
        oracle_db_gcp_key_ring_id=oracle_db_gcp_key_ring_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Please retrieve the work request to find its current state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@oracle_db_gcp_identity_connector_group.command(name=cli_util.override('db_multicloud_gcp_provider.get_oracle_db_gcp_identity_connector.command_name', 'get'), help=u"""Retrieves the Oracle DB GCP Identity Connector for a specified resource [OCID]. \n[Command Reference](getOracleDbGcpIdentityConnector)""")
@cli_util.option('--oracle-db-gcp-identity-connector-id', required=True, help=u"""The [OCID] of the Oracle DB GCP Identity Configuration Resource.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'dbmulticloud', 'class': 'OracleDbGcpIdentityConnector'})
@cli_util.wrap_exceptions
def get_oracle_db_gcp_identity_connector(ctx, from_json, oracle_db_gcp_identity_connector_id):

    if isinstance(oracle_db_gcp_identity_connector_id, six.string_types) and len(oracle_db_gcp_identity_connector_id.strip()) == 0:
        raise click.UsageError('Parameter --oracle-db-gcp-identity-connector-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('dbmulticloud', 'db_multicloud_gcp_provider', ctx)
    result = client.get_oracle_db_gcp_identity_connector(
        oracle_db_gcp_identity_connector_id=oracle_db_gcp_identity_connector_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@oracle_db_gcp_key_group.command(name=cli_util.override('db_multicloud_gcp_provider.get_oracle_db_gcp_key.command_name', 'get'), help=u"""Retrieves Oracle DB Google Cloud Key details using a specific resource [OCID]. \n[Command Reference](getOracleDbGcpKey)""")
@cli_util.option('--oracle-db-gcp-key-id', required=True, help=u"""The [OCID] of the Oracle DB Google Cloud Key resource.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'dbmulticloud', 'class': 'OracleDbGcpKey'})
@cli_util.wrap_exceptions
def get_oracle_db_gcp_key(ctx, from_json, oracle_db_gcp_key_id):

    if isinstance(oracle_db_gcp_key_id, six.string_types) and len(oracle_db_gcp_key_id.strip()) == 0:
        raise click.UsageError('Parameter --oracle-db-gcp-key-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('dbmulticloud', 'db_multicloud_gcp_provider', ctx)
    result = client.get_oracle_db_gcp_key(
        oracle_db_gcp_key_id=oracle_db_gcp_key_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@oracle_db_gcp_key_ring_group.command(name=cli_util.override('db_multicloud_gcp_provider.get_oracle_db_gcp_key_ring.command_name', 'get'), help=u"""Retrieves the Oracle GCP Key Ring details using a specific Container resource [OCID]. \n[Command Reference](getOracleDbGcpKeyRing)""")
@cli_util.option('--oracle-db-gcp-key-ring-id', required=True, help=u"""The [OCID] of the Oracle DB GCP Key-Ring resource.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'asc' or 'desc'.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'dbmulticloud', 'class': 'OracleDbGcpKeyRing'})
@cli_util.wrap_exceptions
def get_oracle_db_gcp_key_ring(ctx, from_json, oracle_db_gcp_key_ring_id, limit, page, sort_order):

    if isinstance(oracle_db_gcp_key_ring_id, six.string_types) and len(oracle_db_gcp_key_ring_id.strip()) == 0:
        raise click.UsageError('Parameter --oracle-db-gcp-key-ring-id cannot be whitespace or empty string')

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('dbmulticloud', 'db_multicloud_gcp_provider', ctx)
    result = client.get_oracle_db_gcp_key_ring(
        oracle_db_gcp_key_ring_id=oracle_db_gcp_key_ring_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@oracle_db_gcp_identity_connector_group.command(name=cli_util.override('db_multicloud_gcp_provider.list_oracle_db_gcp_identity_connectors.command_name', 'list'), help=u"""Lists all Oracle DB GCP Identity Connectors based on the specified filters. \n[Command Reference](listOracleDbGcpIdentityConnectors)""")
@cli_util.option('--compartment-id', required=True, help=u"""The [ID] of the compartment.""")
@cli_util.option('--display-name', help=u"""A filter to return Oracle DB GCP Identity Connector resources that match the specified display name.""")
@cli_util.option('--resource-id', help=u"""A filter to return Oracle DB GCP Identity Connector resource that match the given resource [OCID].""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "ACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED"]), help=u"""A filter to return only resources that match the specified lifecycle state. The state value is case-insensitive.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'asc' or 'desc'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending. If no value is specified, default is timeCreated.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'dbmulticloud', 'class': 'OracleDbGcpIdentityConnectorSummaryCollection'})
@cli_util.wrap_exceptions
def list_oracle_db_gcp_identity_connectors(ctx, from_json, all_pages, page_size, compartment_id, display_name, resource_id, lifecycle_state, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if display_name is not None:
        kwargs['display_name'] = display_name
    if resource_id is not None:
        kwargs['resource_id'] = resource_id
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('dbmulticloud', 'db_multicloud_gcp_provider', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_oracle_db_gcp_identity_connectors,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_oracle_db_gcp_identity_connectors,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_oracle_db_gcp_identity_connectors(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@oracle_db_gcp_key_ring_group.command(name=cli_util.override('db_multicloud_gcp_provider.list_oracle_db_gcp_key_rings.command_name', 'list'), help=u"""Lists the all DB GCP Key Rings based on filters. \n[Command Reference](listOracleDbGcpKeyRings)""")
@cli_util.option('--compartment-id', required=True, help=u"""The [ID] of the compartment.""")
@cli_util.option('--display-name', help=u"""A filter to return Oracle DB GCP Key Ring resources that match the specified display name.""")
@cli_util.option('--oracle-db-gcp-key-ring-id', help=u"""A filter to return Oracle DB GCP Key Rings.""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "ACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED"]), help=u"""A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.""")
@cli_util.option('--oracle-db-gcp-connector-id', help=u"""A filter to return Oracle DB GCP Identity Connector resources that match the specified resource [OCID].""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'asc' or 'desc'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending. If no value is specified, default is timeCreated.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'dbmulticloud', 'class': 'OracleDbGcpKeyRingSummaryCollection'})
@cli_util.wrap_exceptions
def list_oracle_db_gcp_key_rings(ctx, from_json, all_pages, page_size, compartment_id, display_name, oracle_db_gcp_key_ring_id, lifecycle_state, oracle_db_gcp_connector_id, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if display_name is not None:
        kwargs['display_name'] = display_name
    if oracle_db_gcp_key_ring_id is not None:
        kwargs['oracle_db_gcp_key_ring_id'] = oracle_db_gcp_key_ring_id
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    if oracle_db_gcp_connector_id is not None:
        kwargs['oracle_db_gcp_connector_id'] = oracle_db_gcp_connector_id
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('dbmulticloud', 'db_multicloud_gcp_provider', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_oracle_db_gcp_key_rings,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_oracle_db_gcp_key_rings,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_oracle_db_gcp_key_rings(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@oracle_db_gcp_key_group.command(name=cli_util.override('db_multicloud_gcp_provider.list_oracle_db_gcp_keys.command_name', 'list'), help=u"""Lists all Oracle DB Google Cloud Keys based on the specified filters. \n[Command Reference](listOracleDbGcpKeys)""")
@cli_util.option('--compartment-id', required=True, help=u"""The [ID] of the compartment.""")
@cli_util.option('--display-name', help=u"""A filter to return Oracle DB Google Cloud Key resources that match the specified display name.""")
@cli_util.option('--oracle-db-gcp-key-ring-id', help=u"""A filter to return Oracle DB GCP Key Rings.""")
@cli_util.option('--oracle-db-gcp-key-id', help=u"""A filter to return Oracle DB Google Cloud Key resources.""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "ACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED"]), help=u"""A filter to return only resources that match the specified lifecycle state. The state value is case-insensitive.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'asc' or 'desc'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending. If no value is specified, default is timeCreated.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'dbmulticloud', 'class': 'OracleDbGcpKeySummaryCollection'})
@cli_util.wrap_exceptions
def list_oracle_db_gcp_keys(ctx, from_json, all_pages, page_size, compartment_id, display_name, oracle_db_gcp_key_ring_id, oracle_db_gcp_key_id, lifecycle_state, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if display_name is not None:
        kwargs['display_name'] = display_name
    if oracle_db_gcp_key_ring_id is not None:
        kwargs['oracle_db_gcp_key_ring_id'] = oracle_db_gcp_key_ring_id
    if oracle_db_gcp_key_id is not None:
        kwargs['oracle_db_gcp_key_id'] = oracle_db_gcp_key_id
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('dbmulticloud', 'db_multicloud_gcp_provider', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_oracle_db_gcp_keys,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_oracle_db_gcp_keys,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_oracle_db_gcp_keys(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@oracle_db_gcp_identity_connector_group.command(name=cli_util.override('db_multicloud_gcp_provider.refresh_oracle_db_gcp_identity_connector.command_name', 'refresh'), help=u"""Refreshes the Oracle DB GCP Connector resource. \n[Command Reference](refreshOracleDbGcpIdentityConnector)""")
@cli_util.option('--oracle-db-gcp-identity-connector-id', required=True, help=u"""The [OCID] of the Oracle DB GCP Identity Configuration Resource.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def refresh_oracle_db_gcp_identity_connector(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, oracle_db_gcp_identity_connector_id, if_match):

    if isinstance(oracle_db_gcp_identity_connector_id, six.string_types) and len(oracle_db_gcp_identity_connector_id.strip()) == 0:
        raise click.UsageError('Parameter --oracle-db-gcp-identity-connector-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('dbmulticloud', 'db_multicloud_gcp_provider', ctx)
    result = client.refresh_oracle_db_gcp_identity_connector(
        oracle_db_gcp_identity_connector_id=oracle_db_gcp_identity_connector_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@oracle_db_gcp_key_ring_group.command(name=cli_util.override('db_multicloud_gcp_provider.refresh_oracle_db_gcp_key_ring.command_name', 'refresh'), help=u"""Refreshes Oracle GCP Key Ring details from the backend. \n[Command Reference](refreshOracleDbGcpKeyRing)""")
@cli_util.option('--oracle-db-gcp-key-ring-id', required=True, help=u"""The [OCID] of the Oracle DB GCP Key-Ring resource.""")
@cli_util.option('--oracle-db-gcp-connector-id', help=u"""The [OCID] of the Oracle DB GCP Connector resource.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def refresh_oracle_db_gcp_key_ring(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, oracle_db_gcp_key_ring_id, oracle_db_gcp_connector_id, if_match):

    if isinstance(oracle_db_gcp_key_ring_id, six.string_types) and len(oracle_db_gcp_key_ring_id.strip()) == 0:
        raise click.UsageError('Parameter --oracle-db-gcp-key-ring-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if oracle_db_gcp_connector_id is not None:
        _details['oracleDbGcpConnectorId'] = oracle_db_gcp_connector_id

    client = cli_util.build_client('dbmulticloud', 'db_multicloud_gcp_provider', ctx)
    result = client.refresh_oracle_db_gcp_key_ring(
        oracle_db_gcp_key_ring_id=oracle_db_gcp_key_ring_id,
        refresh_oracle_db_gcp_key_ring_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@oracle_db_gcp_identity_connector_group.command(name=cli_util.override('db_multicloud_gcp_provider.update_oracle_db_gcp_identity_connector.command_name', 'update'), help=u"""Modifies the existing Oracle DB GCP Identity Connector resource for a given [OCID]. \n[Command Reference](updateOracleDbGcpIdentityConnector)""")
@cli_util.option('--oracle-db-gcp-identity-connector-id', required=True, help=u"""The [OCID] of the Oracle DB GCP Identity Configuration Resource.""")
@cli_util.option('--display-name', help=u"""Oracle DB Google GCP Identity Connector resource name.""")
@cli_util.option('--issuer-url', help=u"""OIDC token issuer Url""")
@cli_util.option('--project-id', help=u"""Project ID of the customer project.""")
@cli_util.option('--resource-id', help=u"""The [OCID] of the GCP VM Cluster resource.""")
@cli_util.option('--gcp-location', help=u"""GCP Location.""")
@cli_util.option('--gcp-workload-identity-pool-id', help=u"""The ID of the cloud GCP Workload Identity Pool.""")
@cli_util.option('--gcp-workload-identity-provider-id', help=u"""The ID of the GCP Workload Identity Provider.""")
@cli_util.option('--gcp-resource-service-agent-id', help=u"""The ID of the GCP resource service agent.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags].

Example: `{\"Department\": \"Finance\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags].

Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'dbmulticloud', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'dbmulticloud', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'dbmulticloud', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'dbmulticloud', 'class': 'dict(str, dict(str, object))'}})
@cli_util.wrap_exceptions
def update_oracle_db_gcp_identity_connector(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, oracle_db_gcp_identity_connector_id, display_name, issuer_url, project_id, resource_id, gcp_location, gcp_workload_identity_pool_id, gcp_workload_identity_provider_id, gcp_resource_service_agent_id, freeform_tags, defined_tags, if_match):

    if isinstance(oracle_db_gcp_identity_connector_id, six.string_types) and len(oracle_db_gcp_identity_connector_id.strip()) == 0:
        raise click.UsageError('Parameter --oracle-db-gcp-identity-connector-id cannot be whitespace or empty string')
    if not force:
        if freeform_tags or defined_tags:
            if not click.confirm("WARNING: Updates to freeform-tags and defined-tags will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if display_name is not None:
        _details['displayName'] = display_name

    if issuer_url is not None:
        _details['issuerUrl'] = issuer_url

    if project_id is not None:
        _details['projectId'] = project_id

    if resource_id is not None:
        _details['resourceId'] = resource_id

    if gcp_location is not None:
        _details['gcpLocation'] = gcp_location

    if gcp_workload_identity_pool_id is not None:
        _details['gcpWorkloadIdentityPoolId'] = gcp_workload_identity_pool_id

    if gcp_workload_identity_provider_id is not None:
        _details['gcpWorkloadIdentityProviderId'] = gcp_workload_identity_provider_id

    if gcp_resource_service_agent_id is not None:
        _details['gcpResourceServiceAgentId'] = gcp_resource_service_agent_id

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('dbmulticloud', 'db_multicloud_gcp_provider', ctx)
    result = client.update_oracle_db_gcp_identity_connector(
        oracle_db_gcp_identity_connector_id=oracle_db_gcp_identity_connector_id,
        update_oracle_db_gcp_identity_connector_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@oracle_db_gcp_key_ring_group.command(name=cli_util.override('db_multicloud_gcp_provider.update_oracle_db_gcp_key_ring.command_name', 'update'), help=u"""Modifies the existing Oracle GCP Key Ring Details for a given [OCID]. \n[Command Reference](updateOracleDbGcpKeyRing)""")
@cli_util.option('--oracle-db-gcp-key-ring-id', required=True, help=u"""The [OCID] of the Oracle DB GCP Key-Ring resource.""")
@cli_util.option('--display-name', help=u"""Display name of DB GCP Key Ring resource.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags].

Example: `{\"Department\": \"Finance\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags].

Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'dbmulticloud', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'dbmulticloud', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'dbmulticloud', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'dbmulticloud', 'class': 'dict(str, dict(str, object))'}})
@cli_util.wrap_exceptions
def update_oracle_db_gcp_key_ring(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, oracle_db_gcp_key_ring_id, display_name, freeform_tags, defined_tags, if_match):

    if isinstance(oracle_db_gcp_key_ring_id, six.string_types) and len(oracle_db_gcp_key_ring_id.strip()) == 0:
        raise click.UsageError('Parameter --oracle-db-gcp-key-ring-id cannot be whitespace or empty string')
    if not force:
        if freeform_tags or defined_tags:
            if not click.confirm("WARNING: Updates to freeform-tags and defined-tags will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if display_name is not None:
        _details['displayName'] = display_name

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('dbmulticloud', 'db_multicloud_gcp_provider', ctx)
    result = client.update_oracle_db_gcp_key_ring(
        oracle_db_gcp_key_ring_id=oracle_db_gcp_key_ring_id,
        update_oracle_db_gcp_key_ring_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)
