# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231107

from __future__ import print_function
import click
import oci  # noqa: F401
import six  # noqa: F401
import sys  # noqa: F401
from oci_cli import cli_constants  # noqa: F401
from oci_cli import cli_util
from oci_cli import json_skeleton_utils
from oci_cli import custom_types  # noqa: F401
from oci_cli.aliasing import CommandGroupWithAlias
from services.capacity_management.src.oci_cli_capacity_management.generated import capacity_management_service_cli


@click.command(cli_util.override('internal_demand_signal.internal_demand_signal_root_group.command_name', 'internal-demand-signal'), cls=CommandGroupWithAlias, help=cli_util.override('internal_demand_signal.internal_demand_signal_root_group.help', """OCI Control Center (OCC) Capacity Management enables you to manage capacity requests in realms where OCI Control Center Capacity Management is available. For more information, see [OCI Control Center]."""), short_help=cli_util.override('internal_demand_signal.internal_demand_signal_root_group.short_help', """OCI Control Center Capacity Management API"""))
@cli_util.help_option_group
def internal_demand_signal_root_group():
    pass


@click.command(cli_util.override('internal_demand_signal.internal_occm_demand_signal_delivery_group.command_name', 'internal-occm-demand-signal-delivery'), cls=CommandGroupWithAlias, help="""An internal model that contains information about the demand signal item delivery from OCI to customers.""")
@cli_util.help_option_group
def internal_occm_demand_signal_delivery_group():
    pass


@click.command(cli_util.override('internal_demand_signal.occm_demand_signal_catalog_group.command_name', 'occm-demand-signal-catalog'), cls=CommandGroupWithAlias, help="""A model for the demand signal catalog.""")
@cli_util.help_option_group
def occm_demand_signal_catalog_group():
    pass


@click.command(cli_util.override('internal_demand_signal.internal_occm_demand_signal_item_collection_group.command_name', 'internal-occm-demand-signal-item-collection'), cls=CommandGroupWithAlias, help="""A list containing detailed information about different resources demanded as part of a given demand signal.""")
@cli_util.help_option_group
def internal_occm_demand_signal_item_collection_group():
    pass


@click.command(cli_util.override('internal_demand_signal.internal_occm_demand_signal_group.command_name', 'internal-occm-demand-signal'), cls=CommandGroupWithAlias, help="""An internal model describing the demand signal.""")
@cli_util.help_option_group
def internal_occm_demand_signal_group():
    pass


@click.command(cli_util.override('internal_demand_signal.occm_demand_signal_catalog_resource_group.command_name', 'occm-demand-signal-catalog-resource'), cls=CommandGroupWithAlias, help="""A model containing information about the details of a demand signal catalog resource.""")
@cli_util.help_option_group
def occm_demand_signal_catalog_resource_group():
    pass


@click.command(cli_util.override('internal_demand_signal.internal_occm_demand_signal_catalog_resource_group.command_name', 'internal-occm-demand-signal-catalog-resource'), cls=CommandGroupWithAlias, help="""A model containing information about the details of a demand signal catalog resource.""")
@cli_util.help_option_group
def internal_occm_demand_signal_catalog_resource_group():
    pass


capacity_management_service_cli.capacity_management_service_group.add_command(internal_demand_signal_root_group)
internal_demand_signal_root_group.add_command(internal_occm_demand_signal_delivery_group)
internal_demand_signal_root_group.add_command(occm_demand_signal_catalog_group)
internal_demand_signal_root_group.add_command(internal_occm_demand_signal_item_collection_group)
internal_demand_signal_root_group.add_command(internal_occm_demand_signal_group)
internal_demand_signal_root_group.add_command(occm_demand_signal_catalog_resource_group)
internal_demand_signal_root_group.add_command(internal_occm_demand_signal_catalog_resource_group)


@internal_occm_demand_signal_delivery_group.command(name=cli_util.override('internal_demand_signal.create_internal_occm_demand_signal_delivery.command_name', 'create'), help=u"""This is a post API which is used to create a demand signal delivery resource. operationId: CreateInternalOccmDemandSignalDelivery summary: A post call to create a demand signal delivery. \n[Command Reference](createInternalOccmDemandSignalDelivery)""")
@cli_util.option('--compartment-id', required=True, help=u"""The OCID of the tenancy from which the demand signal delivery resource is created.""")
@cli_util.option('--occ-customer-group-id', required=True, help=u"""The OCID of the corresponding customer group to which this demand signal delivery resource belongs to.""")
@cli_util.option('--ds-id', required=True, help=u"""The OCID of the demand signal under which this delivery will be grouped.""")
@cli_util.option('--ds-item-id', required=True, help=u"""The OCID of the demand signal item corresponding to which this delivery is made.""")
@cli_util.option('--accepted-quantity', required=True, type=click.INT, help=u"""The quantity of the resource that OCI will supply to the customer.""")
@cli_util.option('--justification', help=u"""This field could be used by OCI to communicate the reason for declining the request.""")
@cli_util.option('--notes', help=u"""This field acts as a notes section for operators.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "ACTIVE", "UPDATING", "DELETED", "DELETING", "FAILED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'capacity_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'capacity_management', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'capacity_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'capacity_management', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'capacity_management', 'class': 'InternalOccmDemandSignalDelivery'})
@cli_util.wrap_exceptions
def create_internal_occm_demand_signal_delivery(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, compartment_id, occ_customer_group_id, ds_id, ds_item_id, accepted_quantity, justification, notes, freeform_tags, defined_tags):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id
    _details['occCustomerGroupId'] = occ_customer_group_id
    _details['demandSignalId'] = ds_id
    _details['demandSignalItemId'] = ds_item_id
    _details['acceptedQuantity'] = accepted_quantity

    if justification is not None:
        _details['justification'] = justification

    if notes is not None:
        _details['notes'] = notes

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('capacity_management', 'internal_demand_signal', ctx)
    result = client.create_internal_occm_demand_signal_delivery(
        create_internal_occm_demand_signal_delivery_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_internal_occm_demand_signal_delivery') and callable(getattr(client, 'get_internal_occm_demand_signal_delivery')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_internal_occm_demand_signal_delivery(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@internal_occm_demand_signal_delivery_group.command(name=cli_util.override('internal_demand_signal.delete_internal_occm_demand_signal_delivery.command_name', 'delete'), help=u"""This is an internal DELETE API which is used to delete a demand signal delivery resource. \n[Command Reference](deleteInternalOccmDemandSignalDelivery)""")
@cli_util.option('--ds-delivery-id', required=True, help=u"""The OCID of the demand signal delivery.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "ACTIVE", "UPDATING", "DELETED", "DELETING", "FAILED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_internal_occm_demand_signal_delivery(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, ds_delivery_id, if_match):

    if isinstance(ds_delivery_id, six.string_types) and len(ds_delivery_id.strip()) == 0:
        raise click.UsageError('Parameter --ds-delivery-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('capacity_management', 'internal_demand_signal', ctx)
    result = client.delete_internal_occm_demand_signal_delivery(
        occm_demand_signal_delivery_id=ds_delivery_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_internal_occm_demand_signal_delivery') and callable(getattr(client, 'get_internal_occm_demand_signal_delivery')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                oci.wait_until(client, client.get_internal_occm_demand_signal_delivery(ds_delivery_id), 'lifecycle_state', wait_for_state, succeed_on_not_found=True, **wait_period_kwargs)
            except oci.exceptions.ServiceError as e:
                # We make an initial service call so we can pass the result to oci.wait_until(), however if we are waiting on the
                # outcome of a delete operation it is possible that the resource is already gone and so the initial service call
                # will result in an exception that reflects a HTTP 404. In this case, we can exit with success (rather than raising
                # the exception) since this would have been the behaviour in the waiter anyway (as for delete we provide the argument
                # succeed_on_not_found=True to the waiter).
                #
                # Any non-404 should still result in the exception being thrown.
                if e.status == 404:
                    pass
                else:
                    raise
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Please retrieve the resource to find its current state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@internal_occm_demand_signal_group.command(name=cli_util.override('internal_demand_signal.get_internal_occm_demand_signal.command_name', 'get'), help=u"""This is an internal GET API which gets the detailed information about a specific demand signal. \n[Command Reference](getInternalOccmDemandSignal)""")
@cli_util.option('--ds-id', required=True, help=u"""The OCID of the demand signal.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'capacity_management', 'class': 'InternalOccmDemandSignal'})
@cli_util.wrap_exceptions
def get_internal_occm_demand_signal(ctx, from_json, ds_id):

    if isinstance(ds_id, six.string_types) and len(ds_id.strip()) == 0:
        raise click.UsageError('Parameter --ds-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('capacity_management', 'internal_demand_signal', ctx)
    result = client.get_internal_occm_demand_signal(
        occm_demand_signal_id=ds_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@occm_demand_signal_catalog_resource_group.command(name=cli_util.override('internal_demand_signal.get_internal_occm_demand_signal_catalog.command_name', 'get'), help=u"""This API helps in getting the details about a specific occm demand signal catalog. \n[Command Reference](getInternalOccmDemandSignalCatalog)""")
@cli_util.option('--ds-catalog-id', required=True, help=u"""The OCID of the demand signal catalog.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'capacity_management', 'class': 'OccmDemandSignalCatalog'})
@cli_util.wrap_exceptions
def get_internal_occm_demand_signal_catalog(ctx, from_json, ds_catalog_id):

    if isinstance(ds_catalog_id, six.string_types) and len(ds_catalog_id.strip()) == 0:
        raise click.UsageError('Parameter --ds-catalog-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('capacity_management', 'internal_demand_signal', ctx)
    result = client.get_internal_occm_demand_signal_catalog(
        occm_demand_signal_catalog_id=ds_catalog_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@internal_occm_demand_signal_delivery_group.command(name=cli_util.override('internal_demand_signal.get_internal_occm_demand_signal_delivery.command_name', 'get'), help=u"""This is an internal GET API to get the details of a demand signal delivery resource corresponding to a demand signal item. \n[Command Reference](getInternalOccmDemandSignalDelivery)""")
@cli_util.option('--ds-delivery-id', required=True, help=u"""The OCID of the demand signal delivery.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'capacity_management', 'class': 'InternalOccmDemandSignalDelivery'})
@cli_util.wrap_exceptions
def get_internal_occm_demand_signal_delivery(ctx, from_json, ds_delivery_id):

    if isinstance(ds_delivery_id, six.string_types) and len(ds_delivery_id.strip()) == 0:
        raise click.UsageError('Parameter --ds-delivery-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('capacity_management', 'internal_demand_signal', ctx)
    result = client.get_internal_occm_demand_signal_delivery(
        occm_demand_signal_delivery_id=ds_delivery_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@internal_occm_demand_signal_catalog_resource_group.command(name=cli_util.override('internal_demand_signal.list_internal_occm_demand_signal_catalog_resources.command_name', 'list'), help=u"""This API will list all the  resources across all demand signal catalogs for a given namespace and customer group. \n[Command Reference](listInternalOccmDemandSignalCatalogResources)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ocid of the compartment or tenancy in which resources are to be listed. This will also be used for authorization purposes.""")
@cli_util.option('--occ-customer-group-id', required=True, help=u"""The customer group ocid by which we would filter the list.""")
@cli_util.option('--ds-catalog-id', required=True, help=u"""The ocid of demand signal catalog id.""")
@cli_util.option('--name', help=u"""A query parameter to filter the list of demand signal catalog resource based on the resource name.""")
@cli_util.option('--namespace', type=custom_types.CliCaseInsensitiveChoice(["COMPUTE", "NETWORK", "GPU", "STORAGE"]), help=u"""A query parameter to filter the list of demand signal catalog resources based on the namespace.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["name"]), help=u"""The field to sort the response of List Demand catalog resources API. Only one sort order may be provided. The default order for name is case sensitive alphabetical order.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'capacity_management', 'class': 'InternalOccmDemandSignalCatalogResourceCollection'})
@cli_util.wrap_exceptions
def list_internal_occm_demand_signal_catalog_resources(ctx, from_json, all_pages, page_size, compartment_id, occ_customer_group_id, ds_catalog_id, name, namespace, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if name is not None:
        kwargs['name'] = name
    if namespace is not None:
        kwargs['demand_signal_namespace'] = namespace
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('capacity_management', 'internal_demand_signal', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_internal_occm_demand_signal_catalog_resources,
            compartment_id=compartment_id,
            occ_customer_group_id=occ_customer_group_id,
            occm_demand_signal_catalog_id=ds_catalog_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_internal_occm_demand_signal_catalog_resources,
            limit,
            page_size,
            compartment_id=compartment_id,
            occ_customer_group_id=occ_customer_group_id,
            occm_demand_signal_catalog_id=ds_catalog_id,
            **kwargs
        )
    else:
        result = client.list_internal_occm_demand_signal_catalog_resources(
            compartment_id=compartment_id,
            occ_customer_group_id=occ_customer_group_id,
            occm_demand_signal_catalog_id=ds_catalog_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@occm_demand_signal_catalog_group.command(name=cli_util.override('internal_demand_signal.list_internal_occm_demand_signal_catalogs.command_name', 'list-internal'), help=u"""This API will list demand signal catalogs for a given customer group. \n[Command Reference](listInternalOccmDemandSignalCatalogs)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ocid of the compartment or tenancy in which resources are to be listed. This will also be used for authorization purposes.""")
@cli_util.option('--occ-customer-group-id', required=True, help=u"""The customer group ocid by which we would filter the list.""")
@cli_util.option('--display-name', help=u"""A filter to return only the resources that match the entire display name. The match is not case sensitive.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["name"]), help=u"""The field to sort the response of List Demand catalog  API. Only one sort order may be provided. The default order for name is case sensitive alphabetical order.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'capacity_management', 'class': 'OccmDemandSignalCatalogCollection'})
@cli_util.wrap_exceptions
def list_internal_occm_demand_signal_catalogs(ctx, from_json, all_pages, page_size, compartment_id, occ_customer_group_id, display_name, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if display_name is not None:
        kwargs['display_name'] = display_name
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('capacity_management', 'internal_demand_signal', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_internal_occm_demand_signal_catalogs,
            compartment_id=compartment_id,
            occ_customer_group_id=occ_customer_group_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_internal_occm_demand_signal_catalogs,
            limit,
            page_size,
            compartment_id=compartment_id,
            occ_customer_group_id=occ_customer_group_id,
            **kwargs
        )
    else:
        result = client.list_internal_occm_demand_signal_catalogs(
            compartment_id=compartment_id,
            occ_customer_group_id=occ_customer_group_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@internal_occm_demand_signal_delivery_group.command(name=cli_util.override('internal_demand_signal.list_internal_occm_demand_signal_deliveries.command_name', 'list'), help=u"""This GET call is used to list all demand signal delivery resources within the customer group passed as a query parameter. \n[Command Reference](listInternalOccmDemandSignalDeliveries)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ocid of the compartment or tenancy in which resources are to be listed. This will also be used for authorization purposes.""")
@cli_util.option('--occ-customer-group-id', required=True, help=u"""The customer group ocid by which we would filter the list.""")
@cli_util.option('--id', help=u"""A query parameter to filter the list of demand signals based on it's OCID.""")
@cli_util.option('--ds-item-id', help=u"""A query parameter to filter the list of demand signal items based on it's OCID.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["resourceName"]), help=u"""The field to sort the response of List Demand Signal Delivery API. Only one sort order may be provided. The default order for resource name is case sensitive alphabetical order.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'capacity_management', 'class': 'InternalOccmDemandSignalDeliveryCollection'})
@cli_util.wrap_exceptions
def list_internal_occm_demand_signal_deliveries(ctx, from_json, all_pages, page_size, compartment_id, occ_customer_group_id, id, ds_item_id, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if id is not None:
        kwargs['id'] = id
    if ds_item_id is not None:
        kwargs['occm_demand_signal_item_id'] = ds_item_id
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('capacity_management', 'internal_demand_signal', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_internal_occm_demand_signal_deliveries,
            compartment_id=compartment_id,
            occ_customer_group_id=occ_customer_group_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_internal_occm_demand_signal_deliveries,
            limit,
            page_size,
            compartment_id=compartment_id,
            occ_customer_group_id=occ_customer_group_id,
            **kwargs
        )
    else:
        result = client.list_internal_occm_demand_signal_deliveries(
            compartment_id=compartment_id,
            occ_customer_group_id=occ_customer_group_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@internal_occm_demand_signal_item_collection_group.command(name=cli_util.override('internal_demand_signal.list_internal_occm_demand_signal_items.command_name', 'list-internal'), help=u"""This internal API will list the detailed information about the resources demanded as part of the demand signal. \n[Command Reference](listInternalOccmDemandSignalItems)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ocid of the compartment or tenancy in which resources are to be listed. This will also be used for authorization purposes.""")
@cli_util.option('--occ-customer-group-id', required=True, help=u"""The customer group ocid by which we would filter the list.""")
@cli_util.option('--ds-id', help=u"""A query parameter to filter the list of demand signal items based on a demand signal id.""")
@cli_util.option('--resource-name', help=u"""A query parameter to filter the list of demand signal details based on the resource name.""")
@cli_util.option('--namespace', type=custom_types.CliCaseInsensitiveChoice(["COMPUTE", "NETWORK", "GPU", "STORAGE"]), help=u"""A query parameter to filter the list of demand signal details based on the namespace.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["resourceName"]), help=u"""The field to sort the response of List Demand Signal Details API. Only one sort order may be provided. The default order for resource name is case sensitive alphabetical order.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'capacity_management', 'class': 'InternalOccmDemandSignalItemCollection'})
@cli_util.wrap_exceptions
def list_internal_occm_demand_signal_items(ctx, from_json, all_pages, page_size, compartment_id, occ_customer_group_id, ds_id, resource_name, namespace, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if ds_id is not None:
        kwargs['occm_demand_signal_id'] = ds_id
    if resource_name is not None:
        kwargs['resource_name'] = resource_name
    if namespace is not None:
        kwargs['demand_signal_namespace'] = namespace
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('capacity_management', 'internal_demand_signal', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_internal_occm_demand_signal_items,
            compartment_id=compartment_id,
            occ_customer_group_id=occ_customer_group_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_internal_occm_demand_signal_items,
            limit,
            page_size,
            compartment_id=compartment_id,
            occ_customer_group_id=occ_customer_group_id,
            **kwargs
        )
    else:
        result = client.list_internal_occm_demand_signal_items(
            compartment_id=compartment_id,
            occ_customer_group_id=occ_customer_group_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@internal_occm_demand_signal_group.command(name=cli_util.override('internal_demand_signal.list_internal_occm_demand_signals.command_name', 'list'), help=u"""This is an internal GET call is used to list all demand signals within the compartment passed as a query parameter. \n[Command Reference](listInternalOccmDemandSignals)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ocid of the compartment or tenancy in which resources are to be listed. This will also be used for authorization purposes.""")
@cli_util.option('--occ-customer-group-id', required=True, help=u"""The customer group ocid by which we would filter the list.""")
@cli_util.option('--id', help=u"""A query parameter to filter the list of demand signals based on it's OCID.""")
@cli_util.option('--lifecycle-details', help=u"""A query parameter to filter the list of demand signals based on its state.""")
@cli_util.option('--display-name', help=u"""A filter to return only the resources that match the entire display name. The match is not case sensitive.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort the response of List Demand Signal API. Only one sort order may be provided. The default order for timeCreated is reverse chronological order (latest date at the top). The default order for displayName is case sensitive alphabetical order.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'capacity_management', 'class': 'InternalOccmDemandSignalCollection'})
@cli_util.wrap_exceptions
def list_internal_occm_demand_signals(ctx, from_json, all_pages, page_size, compartment_id, occ_customer_group_id, id, lifecycle_details, display_name, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if id is not None:
        kwargs['id'] = id
    if lifecycle_details is not None:
        kwargs['lifecycle_details'] = lifecycle_details
    if display_name is not None:
        kwargs['display_name'] = display_name
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('capacity_management', 'internal_demand_signal', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_internal_occm_demand_signals,
            compartment_id=compartment_id,
            occ_customer_group_id=occ_customer_group_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_internal_occm_demand_signals,
            limit,
            page_size,
            compartment_id=compartment_id,
            occ_customer_group_id=occ_customer_group_id,
            **kwargs
        )
    else:
        result = client.list_internal_occm_demand_signals(
            compartment_id=compartment_id,
            occ_customer_group_id=occ_customer_group_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@internal_occm_demand_signal_group.command(name=cli_util.override('internal_demand_signal.update_internal_occm_demand_signal.command_name', 'update'), help=u"""This is a internal PUT API which shall be used to update the metadata of the demand signal. \n[Command Reference](updateInternalOccmDemandSignal)""")
@cli_util.option('--ds-id', required=True, help=u"""The OCID of the demand signal.""")
@cli_util.option('--lifecycle-details', type=custom_types.CliCaseInsensitiveChoice(["IN_PROGRESS", "COMPLETED", "REJECTED"]), help=u"""The subset of demand signal states available for operators for updating the demand signal.

IN_PROGRESS -> Transitions the demand signal to IN_PROGRESS state. REJECTED -> Transitions the demand signal to REJECTED state. COMPLETED -> This will transition the demand signal to COMPLETED state.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'capacity_management', 'class': 'InternalOccmDemandSignal'})
@cli_util.wrap_exceptions
def update_internal_occm_demand_signal(ctx, from_json, ds_id, lifecycle_details, if_match):

    if isinstance(ds_id, six.string_types) and len(ds_id.strip()) == 0:
        raise click.UsageError('Parameter --ds-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if lifecycle_details is not None:
        _details['lifecycleDetails'] = lifecycle_details

    client = cli_util.build_client('capacity_management', 'internal_demand_signal', ctx)
    result = client.update_internal_occm_demand_signal(
        occm_demand_signal_id=ds_id,
        update_internal_occm_demand_signal_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@internal_occm_demand_signal_delivery_group.command(name=cli_util.override('internal_demand_signal.update_internal_occm_demand_signal_delivery.command_name', 'update'), help=u"""This is an internal PUT API which is used to update the demand signal delivery resource. \n[Command Reference](updateInternalOccmDemandSignalDelivery)""")
@cli_util.option('--ds-delivery-id', required=True, help=u"""The OCID of the demand signal delivery.""")
@cli_util.option('--accepted-quantity', type=click.INT, help=u"""The quantity of the resource that OCI will supply to the customer.""")
@cli_util.option('--lifecycle-details', help=u"""The state in which we want to transition the demand signal delivery resource.""")
@cli_util.option('--time-delivered', type=custom_types.CLI_DATETIME, help=u"""The date on which the OCI delivered the resource to the customers.""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--justification', help=u"""This field could be used by OCI to communicate the reason for declining the request.""")
@cli_util.option('--notes', help=u"""This field acts as a notes section for operators.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "ACTIVE", "UPDATING", "DELETED", "DELETING", "FAILED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'capacity_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'capacity_management', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'capacity_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'capacity_management', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'capacity_management', 'class': 'InternalOccmDemandSignalDelivery'})
@cli_util.wrap_exceptions
def update_internal_occm_demand_signal_delivery(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, ds_delivery_id, accepted_quantity, lifecycle_details, time_delivered, justification, notes, freeform_tags, defined_tags, if_match):

    if isinstance(ds_delivery_id, six.string_types) and len(ds_delivery_id.strip()) == 0:
        raise click.UsageError('Parameter --ds-delivery-id cannot be whitespace or empty string')
    if not force:
        if freeform_tags or defined_tags:
            if not click.confirm("WARNING: Updates to freeform-tags and defined-tags will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if accepted_quantity is not None:
        _details['acceptedQuantity'] = accepted_quantity

    if lifecycle_details is not None:
        _details['lifecycleDetails'] = lifecycle_details

    if time_delivered is not None:
        _details['timeDelivered'] = time_delivered

    if justification is not None:
        _details['justification'] = justification

    if notes is not None:
        _details['notes'] = notes

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('capacity_management', 'internal_demand_signal', ctx)
    result = client.update_internal_occm_demand_signal_delivery(
        occm_demand_signal_delivery_id=ds_delivery_id,
        update_internal_occm_demand_signal_delivery_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_internal_occm_demand_signal_delivery') and callable(getattr(client, 'get_internal_occm_demand_signal_delivery')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_internal_occm_demand_signal_delivery(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)
