# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630

from __future__ import print_function
import click
import oci  # noqa: F401
import six  # noqa: F401
import sys  # noqa: F401
from oci_cli import cli_constants  # noqa: F401
from oci_cli import cli_util
from oci_cli import json_skeleton_utils
from oci_cli import custom_types  # noqa: F401
from oci_cli.aliasing import CommandGroupWithAlias
from services.apm_traces.src.oci_cli_apm_traces.generated import apm_traces_service_cli


@click.command(cli_util.override('scheduled_query.scheduled_query_root_group.command_name', 'scheduled-query'), cls=CommandGroupWithAlias, help=cli_util.override('scheduled_query.scheduled_query_root_group.help', """Use the Application Performance Monitoring Trace Explorer API to query traces and associated spans in Trace Explorer. For more information, see [Application Performance Monitoring]."""), short_help=cli_util.override('scheduled_query.scheduled_query_root_group.short_help', """Application Performance Monitoring Trace Explorer API"""))
@cli_util.help_option_group
def scheduled_query_root_group():
    pass


@click.command(cli_util.override('scheduled_query.scheduled_query_group.command_name', 'scheduled-query'), cls=CommandGroupWithAlias, help="""Scheduled Query object.""")
@cli_util.help_option_group
def scheduled_query_group():
    pass


@click.command(cli_util.override('scheduled_query.scheduled_query_collection_group.command_name', 'scheduled-query-collection'), cls=CommandGroupWithAlias, help="""A collection of scheduled queries in the APM Domain.""")
@cli_util.help_option_group
def scheduled_query_collection_group():
    pass


apm_traces_service_cli.apm_traces_service_group.add_command(scheduled_query_root_group)
scheduled_query_root_group.add_command(scheduled_query_group)
scheduled_query_root_group.add_command(scheduled_query_collection_group)


@scheduled_query_group.command(name=cli_util.override('scheduled_query.create_scheduled_query.command_name', 'create'), help=u"""Create a scheduled query in the APM Domain. \n[Command Reference](createScheduledQuery)""")
@cli_util.option('--apm-domain-id', required=True, help=u"""The APM Domain ID for the intended request.""")
@cli_util.option('--scheduled-query-name', help=u"""Name of the scheduled query.""")
@cli_util.option('--scheduled-query-processing-type', type=custom_types.CliCaseInsensitiveChoice(["EXPORT", "QUERY", "ALERT"]), help=u"""Type of the scheduled query.""")
@cli_util.option('--scheduled-query-text', help=u"""Scheduled query to be run.""")
@cli_util.option('--scheduled-query-schedule', help=u"""Schedule for the scheduled query.""")
@cli_util.option('--scheduled-query-description', help=u"""Description for the scheduled query.""")
@cli_util.option('--scheduled-query-maximum-runtime-in-seconds', type=click.INT, help=u"""Maximum runtime for the scheduled query in seconds.""")
@cli_util.option('--scheduled-query-retention-period-in-ms', type=click.INT, help=u"""Retention period for the scheduled query in milliseconds.""")
@cli_util.option('--scheduled-query-processing-sub-type', type=custom_types.CliCaseInsensitiveChoice(["OBJECT_STORAGE", "STREAMING", "CUSTOM_METRIC", "NONE"]), help=u"""Processing sub type of the scheduled query.""")
@cli_util.option('--scheduled-query-processing-configuration', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--scheduled-query-retention-criteria', type=custom_types.CliCaseInsensitiveChoice(["KEEP_DATA_UNTIL_RETENTION_PERIOD", "UPDATE"]), help=u"""Retention criteria for the scheduled query.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--opc-dry-run', help=u"""Indicates that the request is a dry run, if set to \"true\". A dry run request does not create or modify the resource and is used only to perform validation on the submitted data.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'scheduled-query-processing-configuration': {'module': 'apm_traces', 'class': 'ScheduledQueryProcessingConfig'}, 'freeform-tags': {'module': 'apm_traces', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'apm_traces', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'scheduled-query-processing-configuration': {'module': 'apm_traces', 'class': 'ScheduledQueryProcessingConfig'}, 'freeform-tags': {'module': 'apm_traces', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'apm_traces', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'apm_traces', 'class': 'ScheduledQuery'})
@cli_util.wrap_exceptions
def create_scheduled_query(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, apm_domain_id, scheduled_query_name, scheduled_query_processing_type, scheduled_query_text, scheduled_query_schedule, scheduled_query_description, scheduled_query_maximum_runtime_in_seconds, scheduled_query_retention_period_in_ms, scheduled_query_processing_sub_type, scheduled_query_processing_configuration, scheduled_query_retention_criteria, freeform_tags, defined_tags, opc_dry_run):

    kwargs = {}
    if opc_dry_run is not None:
        kwargs['opc_dry_run'] = opc_dry_run
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if scheduled_query_name is not None:
        _details['scheduledQueryName'] = scheduled_query_name

    if scheduled_query_processing_type is not None:
        _details['scheduledQueryProcessingType'] = scheduled_query_processing_type

    if scheduled_query_text is not None:
        _details['scheduledQueryText'] = scheduled_query_text

    if scheduled_query_schedule is not None:
        _details['scheduledQuerySchedule'] = scheduled_query_schedule

    if scheduled_query_description is not None:
        _details['scheduledQueryDescription'] = scheduled_query_description

    if scheduled_query_maximum_runtime_in_seconds is not None:
        _details['scheduledQueryMaximumRuntimeInSeconds'] = scheduled_query_maximum_runtime_in_seconds

    if scheduled_query_retention_period_in_ms is not None:
        _details['scheduledQueryRetentionPeriodInMs'] = scheduled_query_retention_period_in_ms

    if scheduled_query_processing_sub_type is not None:
        _details['scheduledQueryProcessingSubType'] = scheduled_query_processing_sub_type

    if scheduled_query_processing_configuration is not None:
        _details['scheduledQueryProcessingConfiguration'] = cli_util.parse_json_parameter("scheduled_query_processing_configuration", scheduled_query_processing_configuration)

    if scheduled_query_retention_criteria is not None:
        _details['scheduledQueryRetentionCriteria'] = scheduled_query_retention_criteria

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('apm_traces', 'scheduled_query', ctx)
    result = client.create_scheduled_query(
        apm_domain_id=apm_domain_id,
        create_scheduled_query_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_scheduled_query') and callable(getattr(client, 'get_scheduled_query')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_scheduled_query(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@scheduled_query_group.command(name=cli_util.override('scheduled_query.delete_scheduled_query.command_name', 'delete'), help=u"""Delete a scheduled query in the APM Domain. \n[Command Reference](deleteScheduledQuery)""")
@cli_util.option('--apm-domain-id', required=True, help=u"""The APM Domain ID for the intended request.""")
@cli_util.option('--scheduled-query-id', required=True, help=u"""Id of the scheduled query.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_scheduled_query(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, apm_domain_id, scheduled_query_id, if_match):

    if isinstance(scheduled_query_id, six.string_types) and len(scheduled_query_id.strip()) == 0:
        raise click.UsageError('Parameter --scheduled-query-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('apm_traces', 'scheduled_query', ctx)
    result = client.delete_scheduled_query(
        apm_domain_id=apm_domain_id,
        scheduled_query_id=scheduled_query_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_scheduled_query') and callable(getattr(client, 'get_scheduled_query')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                oci.wait_until(client, client.get_scheduled_query(scheduled_query_id), 'lifecycle_state', wait_for_state, succeed_on_not_found=True, **wait_period_kwargs)
            except oci.exceptions.ServiceError as e:
                # We make an initial service call so we can pass the result to oci.wait_until(), however if we are waiting on the
                # outcome of a delete operation it is possible that the resource is already gone and so the initial service call
                # will result in an exception that reflects a HTTP 404. In this case, we can exit with success (rather than raising
                # the exception) since this would have been the behaviour in the waiter anyway (as for delete we provide the argument
                # succeed_on_not_found=True to the waiter).
                #
                # Any non-404 should still result in the exception being thrown.
                if e.status == 404:
                    pass
                else:
                    raise
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Please retrieve the resource to find its current state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@scheduled_query_group.command(name=cli_util.override('scheduled_query.get_scheduled_query.command_name', 'get'), help=u"""Retrieve a scheduled query in the APM Domain. \n[Command Reference](getScheduledQuery)""")
@cli_util.option('--apm-domain-id', required=True, help=u"""The APM Domain ID for the intended request.""")
@cli_util.option('--scheduled-query-id', required=True, help=u"""Id of the scheduled query.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'apm_traces', 'class': 'ScheduledQuery'})
@cli_util.wrap_exceptions
def get_scheduled_query(ctx, from_json, apm_domain_id, scheduled_query_id):

    if isinstance(scheduled_query_id, six.string_types) and len(scheduled_query_id.strip()) == 0:
        raise click.UsageError('Parameter --scheduled-query-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('apm_traces', 'scheduled_query', ctx)
    result = client.get_scheduled_query(
        apm_domain_id=apm_domain_id,
        scheduled_query_id=scheduled_query_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@scheduled_query_collection_group.command(name=cli_util.override('scheduled_query.list_scheduled_queries.command_name', 'list-scheduled-queries'), help=u"""Returns a list of all scheduled queries in the APM Domain. \n[Command Reference](listScheduledQueries)""")
@cli_util.option('--apm-domain-id', required=True, help=u"""The APM Domain ID for the intended request.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token representing the page where to start retrieving results. This is usually retrieved from a previous response.""")
@cli_util.option('--display-name', help=u"""A filter to return resources that match the given display name.  This will return resources that have name starting with this filter.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either ascending (`ASC`) or descending (`DESC`). The displayName sort order is case-sensitive.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["SCHEDULED_QUERY_NAME", "SCHEDULED_QUERY_TYPE", "SCHEDULED_QUERY_SUB_TYPE", "SCHEDULED_QUERY_NEXT_RUN", "SCHEDULED_QUERY_SCHEDULE"]), help=u"""The field to sort by. You can provide one \"sortBy\" value.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'apm_traces', 'class': 'ScheduledQueryCollection'})
@cli_util.wrap_exceptions
def list_scheduled_queries(ctx, from_json, all_pages, page_size, apm_domain_id, limit, page, display_name, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if display_name is not None:
        kwargs['display_name'] = display_name
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('apm_traces', 'scheduled_query', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_scheduled_queries,
            apm_domain_id=apm_domain_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_scheduled_queries,
            limit,
            page_size,
            apm_domain_id=apm_domain_id,
            **kwargs
        )
    else:
        result = client.list_scheduled_queries(
            apm_domain_id=apm_domain_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@scheduled_query_group.command(name=cli_util.override('scheduled_query.update_scheduled_query.command_name', 'update'), help=u"""Update a scheduled query in the APM Domain. \n[Command Reference](updateScheduledQuery)""")
@cli_util.option('--apm-domain-id', required=True, help=u"""The APM Domain ID for the intended request.""")
@cli_util.option('--scheduled-query-id', required=True, help=u"""Id of the scheduled query.""")
@cli_util.option('--scheduled-query-name', help=u"""Name of the scheduled query.""")
@cli_util.option('--scheduled-query-processing-type', type=custom_types.CliCaseInsensitiveChoice(["EXPORT", "QUERY", "ALERT"]), help=u"""Type of the scheduled query.""")
@cli_util.option('--scheduled-query-processing-sub-type', type=custom_types.CliCaseInsensitiveChoice(["OBJECT_STORAGE", "STREAMING", "CUSTOM_METRIC", "NONE"]), help=u"""Processing sub type of the scheduled query.""")
@cli_util.option('--scheduled-query-text', help=u"""Scheduled query to be run.""")
@cli_util.option('--scheduled-query-schedule', help=u"""Schedule for the scheduled query.""")
@cli_util.option('--scheduled-query-description', help=u"""Description for the scheduled query.""")
@cli_util.option('--scheduled-query-maximum-runtime-in-seconds', type=click.INT, help=u"""Maximum runtime for the scheduled query in seconds.""")
@cli_util.option('--scheduled-query-retention-period-in-ms', type=click.INT, help=u"""Retention period for the scheduled query in milliseconds.""")
@cli_util.option('--scheduled-query-processing-configuration', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--scheduled-query-retention-criteria', type=custom_types.CliCaseInsensitiveChoice(["KEEP_DATA_UNTIL_RETENTION_PERIOD", "UPDATE"]), help=u"""Retention criteria for the scheduled query.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--opc-dry-run', help=u"""Indicates that the request is a dry run, if set to \"true\". A dry run request does not create or modify the resource and is used only to perform validation on the submitted data.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'scheduled-query-processing-configuration': {'module': 'apm_traces', 'class': 'ScheduledQueryProcessingConfig'}, 'freeform-tags': {'module': 'apm_traces', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'apm_traces', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'scheduled-query-processing-configuration': {'module': 'apm_traces', 'class': 'ScheduledQueryProcessingConfig'}, 'freeform-tags': {'module': 'apm_traces', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'apm_traces', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'apm_traces', 'class': 'ScheduledQuery'})
@cli_util.wrap_exceptions
def update_scheduled_query(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, apm_domain_id, scheduled_query_id, scheduled_query_name, scheduled_query_processing_type, scheduled_query_processing_sub_type, scheduled_query_text, scheduled_query_schedule, scheduled_query_description, scheduled_query_maximum_runtime_in_seconds, scheduled_query_retention_period_in_ms, scheduled_query_processing_configuration, scheduled_query_retention_criteria, freeform_tags, defined_tags, if_match, opc_dry_run):

    if isinstance(scheduled_query_id, six.string_types) and len(scheduled_query_id.strip()) == 0:
        raise click.UsageError('Parameter --scheduled-query-id cannot be whitespace or empty string')
    if not force:
        if scheduled_query_processing_configuration or freeform_tags or defined_tags:
            if not click.confirm("WARNING: Updates to scheduled-query-processing-configuration and freeform-tags and defined-tags will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    if opc_dry_run is not None:
        kwargs['opc_dry_run'] = opc_dry_run
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if scheduled_query_name is not None:
        _details['scheduledQueryName'] = scheduled_query_name

    if scheduled_query_processing_type is not None:
        _details['scheduledQueryProcessingType'] = scheduled_query_processing_type

    if scheduled_query_processing_sub_type is not None:
        _details['scheduledQueryProcessingSubType'] = scheduled_query_processing_sub_type

    if scheduled_query_text is not None:
        _details['scheduledQueryText'] = scheduled_query_text

    if scheduled_query_schedule is not None:
        _details['scheduledQuerySchedule'] = scheduled_query_schedule

    if scheduled_query_description is not None:
        _details['scheduledQueryDescription'] = scheduled_query_description

    if scheduled_query_maximum_runtime_in_seconds is not None:
        _details['scheduledQueryMaximumRuntimeInSeconds'] = scheduled_query_maximum_runtime_in_seconds

    if scheduled_query_retention_period_in_ms is not None:
        _details['scheduledQueryRetentionPeriodInMs'] = scheduled_query_retention_period_in_ms

    if scheduled_query_processing_configuration is not None:
        _details['scheduledQueryProcessingConfiguration'] = cli_util.parse_json_parameter("scheduled_query_processing_configuration", scheduled_query_processing_configuration)

    if scheduled_query_retention_criteria is not None:
        _details['scheduledQueryRetentionCriteria'] = scheduled_query_retention_criteria

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('apm_traces', 'scheduled_query', ctx)
    result = client.update_scheduled_query(
        apm_domain_id=apm_domain_id,
        scheduled_query_id=scheduled_query_id,
        update_scheduled_query_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_scheduled_query') and callable(getattr(client, 'get_scheduled_query')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_scheduled_query(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)
