# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180828

from __future__ import print_function
import click
import oci  # noqa: F401
import six  # noqa: F401
import sys  # noqa: F401
from oci_cli import cli_constants  # noqa: F401
from oci_cli import cli_util
from oci_cli import json_skeleton_utils
from oci_cli import custom_types  # noqa: F401
from oci_cli.aliasing import CommandGroupWithAlias
from services.multicloud.src.oci_cli_multicloud.generated import multicloud_service_cli


@click.command(cli_util.override('omhub_resource_anchor.omhub_resource_anchor_root_group.command_name', 'omhub-resource-anchor'), cls=CommandGroupWithAlias, help=cli_util.override('omhub_resource_anchor.omhub_resource_anchor_root_group.help', """Use the Oracle Multicloud API to retrieve resource anchors and network anchors, and the metadata mappings related a Cloud Service Provider. For more information, see <link to docs>."""), short_help=cli_util.override('omhub_resource_anchor.omhub_resource_anchor_root_group.short_help', """Oracle Multicloud API"""))
@cli_util.help_option_group
def omhub_resource_anchor_root_group():
    pass


@click.command(cli_util.override('omhub_resource_anchor.resource_anchor_collection_group.command_name', 'resource-anchor-collection'), cls=CommandGroupWithAlias, help="""Results of a resourceAnchor search. Contains both ResourceAnchorSummary items and other information, such as metadata.""")
@cli_util.help_option_group
def resource_anchor_collection_group():
    pass


@click.command(cli_util.override('omhub_resource_anchor.resource_anchor_group.command_name', 'resource-anchor'), cls=CommandGroupWithAlias, help="""A ResourceAnchor is a description of a ResourceAnchor.

To use any of the API operations, you must be authorized in an IAM policy. If you're not authorized, talk to an administrator. If you're an administrator who needs to write policies to give users access, see [Getting Started with Policies].""")
@cli_util.help_option_group
def resource_anchor_group():
    pass


multicloud_service_cli.multicloud_service_group.add_command(omhub_resource_anchor_root_group)
omhub_resource_anchor_root_group.add_command(resource_anchor_collection_group)
omhub_resource_anchor_root_group.add_command(resource_anchor_group)


@resource_anchor_group.command(name=cli_util.override('omhub_resource_anchor.get_resource_anchor.command_name', 'get'), help=u"""Gets information about a ResourceAnchor. \n[Command Reference](getResourceAnchor)""")
@cli_util.option('--resource-anchor-id', required=True, help=u"""The [OCID] of the ResourceAnchor.""")
@cli_util.option('--subscription-service-name', required=True, type=custom_types.CliCaseInsensitiveChoice(["ORACLEDBATAZURE", "ORACLEDBATGOOGLE", "ORACLEDBATAWS"]), help=u"""The subscription service name values from [ORACLEDBATAZURE, ORACLEDBATGOOGLE, ORACLEDBATAWS]""")
@cli_util.option('--subscription-id', required=True, help=u"""The [OCID] of the subscription in which to list resources.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'multicloud', 'class': 'ResourceAnchor'})
@cli_util.wrap_exceptions
def get_resource_anchor(ctx, from_json, resource_anchor_id, subscription_service_name, subscription_id):

    if isinstance(resource_anchor_id, six.string_types) and len(resource_anchor_id.strip()) == 0:
        raise click.UsageError('Parameter --resource-anchor-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('multicloud', 'omhub_resource_anchor', ctx)
    result = client.get_resource_anchor(
        resource_anchor_id=resource_anchor_id,
        subscription_service_name=subscription_service_name,
        subscription_id=subscription_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@resource_anchor_collection_group.command(name=cli_util.override('omhub_resource_anchor.list_resource_anchors.command_name', 'list-resource-anchors'), help=u"""Gets a list of ResourceAnchors. \n[Command Reference](listResourceAnchors)""")
@cli_util.option('--subscription-service-name', required=True, type=custom_types.CliCaseInsensitiveChoice(["ORACLEDBATAZURE", "ORACLEDBATGOOGLE", "ORACLEDBATAWS"]), help=u"""The subscription service name values from [ORACLEDBATAZURE, ORACLEDBATGOOGLE, ORACLEDBATAWS]""")
@cli_util.option('--subscription-id', required=True, help=u"""The [OCID] of the subscription in which to list resources.""")
@cli_util.option('--compartment-id', help=u"""The [OCID] of the compartment in which to list resources.""")
@cli_util.option('--linked-compartment-id', help=u"""The [OCID] of the compartment in which linked to Resource.""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]), help=u"""A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the given display name exactly.""")
@cli_util.option('--id', help=u"""The [OCID] of the ResourceAnchor.""")
@cli_util.option('--limit', type=click.INT, help=u"""For list pagination. The maximum number of results per page, or items to return in a paginated \"List\" call. For important details about how pagination works, see [List Pagination].""")
@cli_util.option('--page', help=u"""For list pagination. The value of the opc-next-page response header from the previous \"List\" call. For important details about how pagination works, see [List Pagination].""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either ascending (`ASC`) or descending (`DESC`).""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. You can provide only one sort order. Default order for `timeCreated` is descending. Default order for `displayName` is ascending.""")
@cli_util.option('--is-compartment-id-in-subtree', type=click.BOOL, help=u"""Check the sub-compartments of a given compartmentId""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'multicloud', 'class': 'ResourceAnchorCollection'})
@cli_util.wrap_exceptions
def list_resource_anchors(ctx, from_json, all_pages, page_size, subscription_service_name, subscription_id, compartment_id, linked_compartment_id, lifecycle_state, display_name, id, limit, page, sort_order, sort_by, is_compartment_id_in_subtree):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if compartment_id is not None:
        kwargs['compartment_id'] = compartment_id
    if linked_compartment_id is not None:
        kwargs['linked_compartment_id'] = linked_compartment_id
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    if display_name is not None:
        kwargs['display_name'] = display_name
    if id is not None:
        kwargs['id'] = id
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if is_compartment_id_in_subtree is not None:
        kwargs['is_compartment_id_in_subtree'] = is_compartment_id_in_subtree
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('multicloud', 'omhub_resource_anchor', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_resource_anchors,
            subscription_service_name=subscription_service_name,
            subscription_id=subscription_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_resource_anchors,
            limit,
            page_size,
            subscription_service_name=subscription_service_name,
            subscription_id=subscription_id,
            **kwargs
        )
    else:
        result = client.list_resource_anchors(
            subscription_service_name=subscription_service_name,
            subscription_id=subscription_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)
