# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: v1

from __future__ import print_function
import click
import oci  # noqa: F401
import six  # noqa: F401
import sys  # noqa: F401
from oci_cli.cli_root import cli
from oci_cli import cli_constants  # noqa: F401
from oci_cli import cli_util
from oci_cli import json_skeleton_utils
from oci_cli import custom_types  # noqa: F401
from oci_cli.aliasing import CommandGroupWithAlias


@cli.command(cli_util.override('identity_domains.identity_domains_root_group.command_name', 'identity-domains'), cls=CommandGroupWithAlias, help=cli_util.override('identity_domains.identity_domains_root_group.help', """Use the Identity Domains API to manage resources within an identity domain, for example, users, dynamic resource groups, groups, and identity providers. For information about managing resources within identity domains, see [Identity and Access Management (with identity domains)].
Use this pattern to construct endpoints for identity domains: `https://<domainURL>/admin/v1/`. See [Finding an Identity Domain URL] to locate the domain URL you need.
Use the table of contents and search tool to explore the Identity Domains API."""), short_help=cli_util.override('identity_domains.identity_domains_root_group.short_help', """Identity Domains API"""))
@cli_util.help_option_group
def identity_domains_root_group():
    pass


@click.command(cli_util.override('identity_domains.my_pending_approval_group.command_name', 'my-pending-approval'), cls=CommandGroupWithAlias, help="""Schema for MyPendingApproval and MyCompletedApproval""")
@cli_util.help_option_group
def my_pending_approval_group():
    pass


@click.command(cli_util.override('identity_domains.my_user_db_credential_group.command_name', 'my-user-db-credential'), cls=CommandGroupWithAlias, help="""User's Database Credential""")
@cli_util.help_option_group
def my_user_db_credential_group():
    pass


@click.command(cli_util.override('identity_domains.identity_propagation_trusts_group.command_name', 'identity-propagation-trusts'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def identity_propagation_trusts_group():
    pass


@click.command(cli_util.override('identity_domains.dynamic_resource_groups_group.command_name', 'dynamic-resource-groups'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def dynamic_resource_groups_group():
    pass


@click.command(cli_util.override('identity_domains.my_api_keys_group.command_name', 'my-api-keys'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def my_api_keys_group():
    pass


@click.command(cli_util.override('identity_domains.my_authentication_factors_remover_group.command_name', 'my-authentication-factors-remover'), cls=CommandGroupWithAlias, help="""This schema defines the attributes of Authentication Factors Remover call.""")
@cli_util.help_option_group
def my_authentication_factors_remover_group():
    pass


@click.command(cli_util.override('identity_domains.setting_group.command_name', 'setting'), cls=CommandGroupWithAlias, help="""Settings schema""")
@cli_util.help_option_group
def setting_group():
    pass


@click.command(cli_util.override('identity_domains.user_db_credentials_group.command_name', 'user-db-credentials'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def user_db_credentials_group():
    pass


@click.command(cli_util.override('identity_domains.branding_setting_group.command_name', 'branding-setting'), cls=CommandGroupWithAlias, help="""Brand Settings schema""")
@cli_util.help_option_group
def branding_setting_group():
    pass


@click.command(cli_util.override('identity_domains.identity_providers_group.command_name', 'identity-providers'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def identity_providers_group():
    pass


@click.command(cli_util.override('identity_domains.user_password_changer_group.command_name', 'user-password-changer'), cls=CommandGroupWithAlias, help="""The schema used to handle a user password change by an administrator.""")
@cli_util.help_option_group
def user_password_changer_group():
    pass


@click.command(cli_util.override('identity_domains.app_group.command_name', 'app'), cls=CommandGroupWithAlias, help="""Schema for App resource.""")
@cli_util.help_option_group
def app_group():
    pass


@click.command(cli_util.override('identity_domains.resource_type_schema_attributes_group.command_name', 'resource-type-schema-attributes'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def resource_type_schema_attributes_group():
    pass


@click.command(cli_util.override('identity_domains.my_device_group.command_name', 'my-device'), cls=CommandGroupWithAlias, help="""Device Resource.""")
@cli_util.help_option_group
def my_device_group():
    pass


@click.command(cli_util.override('identity_domains.authentication_factors_remover_group.command_name', 'authentication-factors-remover'), cls=CommandGroupWithAlias, help="""This schema defines the attributes of Authentication Factors Remover call.""")
@cli_util.help_option_group
def authentication_factors_remover_group():
    pass


@click.command(cli_util.override('identity_domains.account_recovery_setting_group.command_name', 'account-recovery-setting'), cls=CommandGroupWithAlias, help="""Account Recovery Settings""")
@cli_util.help_option_group
def account_recovery_setting_group():
    pass


@click.command(cli_util.override('identity_domains.self_registration_profiles_group.command_name', 'self-registration-profiles'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def self_registration_profiles_group():
    pass


@click.command(cli_util.override('identity_domains.my_completed_approvals_group.command_name', 'my-completed-approvals'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def my_completed_approvals_group():
    pass


@click.command(cli_util.override('identity_domains.network_perimeter_group.command_name', 'network-perimeter'), cls=CommandGroupWithAlias, help="""NetworkPerimeter resource. A unit that captures a NetworkPerimeter as a collection of IP Addresses.""")
@cli_util.help_option_group
def network_perimeter_group():
    pass


@click.command(cli_util.override('identity_domains.my_customer_secret_key_group.command_name', 'my-customer-secret-key'), cls=CommandGroupWithAlias, help="""The user's customer secret key.""")
@cli_util.help_option_group
def my_customer_secret_key_group():
    pass


@click.command(cli_util.override('identity_domains.schema_group.command_name', 'schema'), cls=CommandGroupWithAlias, help="""SCIM schema""")
@cli_util.help_option_group
def schema_group():
    pass


@click.command(cli_util.override('identity_domains.password_policies_group.command_name', 'password-policies'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def password_policies_group():
    pass


@click.command(cli_util.override('identity_domains.customer_secret_keys_group.command_name', 'customer-secret-keys'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def customer_secret_keys_group():
    pass


@click.command(cli_util.override('identity_domains.app_role_group.command_name', 'app-role'), cls=CommandGroupWithAlias, help="""AppRole resource.""")
@cli_util.help_option_group
def app_role_group():
    pass


@click.command(cli_util.override('identity_domains.my_auth_tokens_group.command_name', 'my-auth-tokens'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def my_auth_tokens_group():
    pass


@click.command(cli_util.override('identity_domains.user_password_resetter_group.command_name', 'user-password-resetter'), cls=CommandGroupWithAlias, help="""The schema used to handle a user password reset by an administrator.""")
@cli_util.help_option_group
def user_password_resetter_group():
    pass


@click.command(cli_util.override('identity_domains.security_questions_group.command_name', 'security-questions'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def security_questions_group():
    pass


@click.command(cli_util.override('identity_domains.my_support_accounts_group.command_name', 'my-support-accounts'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def my_support_accounts_group():
    pass


@click.command(cli_util.override('identity_domains.approval_workflow_step_group.command_name', 'approval-workflow-step'), cls=CommandGroupWithAlias, help="""Schema for ApprovalWorkflowStep""")
@cli_util.help_option_group
def approval_workflow_step_group():
    pass


@click.command(cli_util.override('identity_domains.my_api_key_group.command_name', 'my-api-key'), cls=CommandGroupWithAlias, help="""The user's API key.""")
@cli_util.help_option_group
def my_api_key_group():
    pass


@click.command(cli_util.override('identity_domains.user_attributes_setting_group.command_name', 'user-attributes-setting'), cls=CommandGroupWithAlias, help="""Schema for End User Attribute mutability""")
@cli_util.help_option_group
def user_attributes_setting_group():
    pass


@click.command(cli_util.override('identity_domains.api_keys_group.command_name', 'api-keys'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def api_keys_group():
    pass


@click.command(cli_util.override('identity_domains.apps_group.command_name', 'apps'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def apps_group():
    pass


@click.command(cli_util.override('identity_domains.my_requestable_groups_group.command_name', 'my-requestable-groups'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def my_requestable_groups_group():
    pass


@click.command(cli_util.override('identity_domains.policy_group.command_name', 'policy'), cls=CommandGroupWithAlias, help="""Policy resource. A named list of rules.""")
@cli_util.help_option_group
def policy_group():
    pass


@click.command(cli_util.override('identity_domains.kmsi_settings_group.command_name', 'kmsi-settings'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def kmsi_settings_group():
    pass


@click.command(cli_util.override('identity_domains.o_auth_partner_certificate_group.command_name', 'o-auth-partner-certificate'), cls=CommandGroupWithAlias, help="""OAuth Partner Certificate schema""")
@cli_util.help_option_group
def o_auth_partner_certificate_group():
    pass


@click.command(cli_util.override('identity_domains.o_auth2_client_credentials_group.command_name', 'o-auth2-client-credentials'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def o_auth2_client_credentials_group():
    pass


@click.command(cli_util.override('identity_domains.o_auth_client_certificate_group.command_name', 'o-auth-client-certificate'), cls=CommandGroupWithAlias, help="""OAuth Client Certificate schema""")
@cli_util.help_option_group
def o_auth_client_certificate_group():
    pass


@click.command(cli_util.override('identity_domains.my_devices_group.command_name', 'my-devices'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def my_devices_group():
    pass


@click.command(cli_util.override('identity_domains.password_policy_group.command_name', 'password-policy'), cls=CommandGroupWithAlias, help="""PasswordPolicy resource.""")
@cli_util.help_option_group
def password_policy_group():
    pass


@click.command(cli_util.override('identity_domains.auth_tokens_group.command_name', 'auth-tokens'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def auth_tokens_group():
    pass


@click.command(cli_util.override('identity_domains.smtp_credentials_group.command_name', 'smtp-credentials'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def smtp_credentials_group():
    pass


@click.command(cli_util.override('identity_domains.account_mgmt_infos_group.command_name', 'account-mgmt-infos'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def account_mgmt_infos_group():
    pass


@click.command(cli_util.override('identity_domains.identity_settings_group.command_name', 'identity-settings'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def identity_settings_group():
    pass


@click.command(cli_util.override('identity_domains.approval_workflows_group.command_name', 'approval-workflows'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def approval_workflows_group():
    pass


@click.command(cli_util.override('identity_domains.my_request_group.command_name', 'my-request'), cls=CommandGroupWithAlias, help="""Request resource""")
@cli_util.help_option_group
def my_request_group():
    pass


@click.command(cli_util.override('identity_domains.security_question_group.command_name', 'security-question'), cls=CommandGroupWithAlias, help="""Security Question""")
@cli_util.help_option_group
def security_question_group():
    pass


@click.command(cli_util.override('identity_domains.authentication_factor_settings_group.command_name', 'authentication-factor-settings'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def authentication_factor_settings_group():
    pass


@click.command(cli_util.override('identity_domains.o_auth2_client_credential_group.command_name', 'o-auth2-client-credential'), cls=CommandGroupWithAlias, help="""The user's OAuth2 client credentials.""")
@cli_util.help_option_group
def o_auth2_client_credential_group():
    pass


@click.command(cli_util.override('identity_domains.my_o_auth2_client_credentials_group.command_name', 'my-o-auth2-client-credentials'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def my_o_auth2_client_credentials_group():
    pass


@click.command(cli_util.override('identity_domains.my_smtp_credential_group.command_name', 'my-smtp-credential'), cls=CommandGroupWithAlias, help="""User's smtp credential""")
@cli_util.help_option_group
def my_smtp_credential_group():
    pass


@click.command(cli_util.override('identity_domains.dynamic_resource_group_group.command_name', 'dynamic-resource-group'), cls=CommandGroupWithAlias, help="""Schema for DynamicResourceGroup resource.""")
@cli_util.help_option_group
def dynamic_resource_group_group():
    pass


@click.command(cli_util.override('identity_domains.my_completed_approval_group.command_name', 'my-completed-approval'), cls=CommandGroupWithAlias, help="""Schema for MyPendingApproval and MyCompletedApproval""")
@cli_util.help_option_group
def my_completed_approval_group():
    pass


@click.command(cli_util.override('identity_domains.my_user_db_credentials_group.command_name', 'my-user-db-credentials'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def my_user_db_credentials_group():
    pass


@click.command(cli_util.override('identity_domains.me_group.command_name', 'me'), cls=CommandGroupWithAlias, help="""User Account""")
@cli_util.help_option_group
def me_group():
    pass


@click.command(cli_util.override('identity_domains.user_db_credential_group.command_name', 'user-db-credential'), cls=CommandGroupWithAlias, help="""User's Database Credential""")
@cli_util.help_option_group
def user_db_credential_group():
    pass


@click.command(cli_util.override('identity_domains.cloud_gates_group.command_name', 'cloud-gates'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def cloud_gates_group():
    pass


@click.command(cli_util.override('identity_domains.group_group.command_name', 'group'), cls=CommandGroupWithAlias, help="""The Group resource.""")
@cli_util.help_option_group
def group_group():
    pass


@click.command(cli_util.override('identity_domains.social_identity_provider_group.command_name', 'social-identity-provider'), cls=CommandGroupWithAlias, help="""Social Identity Provider""")
@cli_util.help_option_group
def social_identity_provider_group():
    pass


@click.command(cli_util.override('identity_domains.network_perimeters_group.command_name', 'network-perimeters'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def network_perimeters_group():
    pass


@click.command(cli_util.override('identity_domains.settings_group.command_name', 'settings'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def settings_group():
    pass


@click.command(cli_util.override('identity_domains.o_auth_client_certificates_group.command_name', 'o-auth-client-certificates'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def o_auth_client_certificates_group():
    pass


@click.command(cli_util.override('identity_domains.cloud_gate_group.command_name', 'cloud-gate'), cls=CommandGroupWithAlias, help="""Resource representing a Cloud Gate""")
@cli_util.help_option_group
def cloud_gate_group():
    pass


@click.command(cli_util.override('identity_domains.restore_oci_console_policy_group.command_name', 'restore-oci-console-policy'), cls=CommandGroupWithAlias, help="""Schema to restoring OCI Console Policy to Factory Defaults.""")
@cli_util.help_option_group
def restore_oci_console_policy_group():
    pass


@click.command(cli_util.override('identity_domains.cloud_gate_mappings_group.command_name', 'cloud-gate-mappings'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def cloud_gate_mappings_group():
    pass


@click.command(cli_util.override('identity_domains.users_group.command_name', 'users'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def users_group():
    pass


@click.command(cli_util.override('identity_domains.my_pending_approvals_group.command_name', 'my-pending-approvals'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def my_pending_approvals_group():
    pass


@click.command(cli_util.override('identity_domains.condition_group.command_name', 'condition'), cls=CommandGroupWithAlias, help="""Condition resource. A unit that captures a condition.""")
@cli_util.help_option_group
def condition_group():
    pass


@click.command(cli_util.override('identity_domains.my_smtp_credentials_group.command_name', 'my-smtp-credentials'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def my_smtp_credentials_group():
    pass


@click.command(cli_util.override('identity_domains.my_o_auth2_client_credential_group.command_name', 'my-o-auth2-client-credential'), cls=CommandGroupWithAlias, help="""The user's OAuth2 client credentials.""")
@cli_util.help_option_group
def my_o_auth2_client_credential_group():
    pass


@click.command(cli_util.override('identity_domains.schemas_group.command_name', 'schemas'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def schemas_group():
    pass


@click.command(cli_util.override('identity_domains.me_password_changer_group.command_name', 'me-password-changer'), cls=CommandGroupWithAlias, help="""The schema used for a user changing their own password.""")
@cli_util.help_option_group
def me_password_changer_group():
    pass


@click.command(cli_util.override('identity_domains.authentication_factor_setting_group.command_name', 'authentication-factor-setting'), cls=CommandGroupWithAlias, help="""Multi Factor Authentication Settings for Tenant""")
@cli_util.help_option_group
def authentication_factor_setting_group():
    pass


@click.command(cli_util.override('identity_domains.my_authentication_factor_validator_group.command_name', 'my-authentication-factor-validator'), cls=CommandGroupWithAlias, help="""Validate any given Authentication Factor""")
@cli_util.help_option_group
def my_authentication_factor_validator_group():
    pass


@click.command(cli_util.override('identity_domains.self_registration_profile_group.command_name', 'self-registration-profile'), cls=CommandGroupWithAlias, help="""Self Registration Profile""")
@cli_util.help_option_group
def self_registration_profile_group():
    pass


@click.command(cli_util.override('identity_domains.my_authentication_factor_initiator_group.command_name', 'my-authentication-factor-initiator'), cls=CommandGroupWithAlias, help="""This schema defines the attributes of Initiator call.""")
@cli_util.help_option_group
def my_authentication_factor_initiator_group():
    pass


@click.command(cli_util.override('identity_domains.notification_settings_group.command_name', 'notification-settings'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def notification_settings_group():
    pass


@click.command(cli_util.override('identity_domains.rule_group.command_name', 'rule'), cls=CommandGroupWithAlias, help="""Rule resource. A unit that has a condition which on evaluation with input returns defined values.""")
@cli_util.help_option_group
def rule_group():
    pass


@click.command(cli_util.override('identity_domains.user_status_changer_group.command_name', 'user-status-changer'), cls=CommandGroupWithAlias, help="""Schema to handle user status change by administrator.""")
@cli_util.help_option_group
def user_status_changer_group():
    pass


@click.command(cli_util.override('identity_domains.my_apps_group.command_name', 'my-apps'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def my_apps_group():
    pass


@click.command(cli_util.override('identity_domains.notification_setting_group.command_name', 'notification-setting'), cls=CommandGroupWithAlias, help="""Notification resource.""")
@cli_util.help_option_group
def notification_setting_group():
    pass


@click.command(cli_util.override('identity_domains.my_customer_secret_keys_group.command_name', 'my-customer-secret-keys'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def my_customer_secret_keys_group():
    pass


@click.command(cli_util.override('identity_domains.cloud_gate_server_group.command_name', 'cloud-gate-server'), cls=CommandGroupWithAlias, help="""Resource representing a Cloud Gate server block""")
@cli_util.help_option_group
def cloud_gate_server_group():
    pass


@click.command(cli_util.override('identity_domains.branding_settings_group.command_name', 'branding-settings'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def branding_settings_group():
    pass


@click.command(cli_util.override('identity_domains.kmsi_setting_group.command_name', 'kmsi-setting'), cls=CommandGroupWithAlias, help="""Kmsi Settings schema""")
@cli_util.help_option_group
def kmsi_setting_group():
    pass


@click.command(cli_util.override('identity_domains.approval_workflow_assignment_group.command_name', 'approval-workflow-assignment'), cls=CommandGroupWithAlias, help="""Schema for ApprovalWorkflowAssignment""")
@cli_util.help_option_group
def approval_workflow_assignment_group():
    pass


@click.command(cli_util.override('identity_domains.smtp_credential_group.command_name', 'smtp-credential'), cls=CommandGroupWithAlias, help="""User's smtp credential""")
@cli_util.help_option_group
def smtp_credential_group():
    pass


@click.command(cli_util.override('identity_domains.my_trusted_user_agent_group.command_name', 'my-trusted-user-agent'), cls=CommandGroupWithAlias, help="""This schema defines the attributes of Trusted User Agents owned by users. Multi-Factor Authentication uses Trusted User Agents to authenticate users.  A User Agent is software application that a user uses to issue requests.\r    For example, a User Agent could be a particular browser (possibly one of several executing on a desktop or laptop) or a particular mobile application (again, one of several executing on a particular mobile device). \r    A User Agent is trusted once the Multi-Factor Authentication has verified it in some way.""")
@cli_util.help_option_group
def my_trusted_user_agent_group():
    pass


@click.command(cli_util.override('identity_domains.security_question_setting_group.command_name', 'security-question-setting'), cls=CommandGroupWithAlias, help="""Security Question Settings""")
@cli_util.help_option_group
def security_question_setting_group():
    pass


@click.command(cli_util.override('identity_domains.approval_workflow_assignments_group.command_name', 'approval-workflow-assignments'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def approval_workflow_assignments_group():
    pass


@click.command(cli_util.override('identity_domains.app_roles_group.command_name', 'app-roles'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def app_roles_group():
    pass


@click.command(cli_util.override('identity_domains.account_mgmt_info_group.command_name', 'account-mgmt-info'), cls=CommandGroupWithAlias, help="""Schema for AccountMgmtInfo resource.""")
@cli_util.help_option_group
def account_mgmt_info_group():
    pass


@click.command(cli_util.override('identity_domains.grants_group.command_name', 'grants'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def grants_group():
    pass


@click.command(cli_util.override('identity_domains.app_status_changer_group.command_name', 'app-status-changer'), cls=CommandGroupWithAlias, help="""Schema for AppStatusChanger resource.""")
@cli_util.help_option_group
def app_status_changer_group():
    pass


@click.command(cli_util.override('identity_domains.approval_workflow_steps_group.command_name', 'approval-workflow-steps'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def approval_workflow_steps_group():
    pass


@click.command(cli_util.override('identity_domains.cloud_gate_mapping_group.command_name', 'cloud-gate-mapping'), cls=CommandGroupWithAlias, help="""Resource representing a Cloud Gate mapping""")
@cli_util.help_option_group
def cloud_gate_mapping_group():
    pass


@click.command(cli_util.override('identity_domains.my_trusted_user_agents_group.command_name', 'my-trusted-user-agents'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def my_trusted_user_agents_group():
    pass


@click.command(cli_util.override('identity_domains.customer_secret_key_group.command_name', 'customer-secret-key'), cls=CommandGroupWithAlias, help="""The user's customer secret key.""")
@cli_util.help_option_group
def customer_secret_key_group():
    pass


@click.command(cli_util.override('identity_domains.my_auth_token_group.command_name', 'my-auth-token'), cls=CommandGroupWithAlias, help="""The user's Auth token resource.""")
@cli_util.help_option_group
def my_auth_token_group():
    pass


@click.command(cli_util.override('identity_domains.groups_group.command_name', 'groups'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def groups_group():
    pass


@click.command(cli_util.override('identity_domains.o_auth_partner_certificates_group.command_name', 'o-auth-partner-certificates'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def o_auth_partner_certificates_group():
    pass


@click.command(cli_util.override('identity_domains.security_question_settings_group.command_name', 'security-question-settings'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def security_question_settings_group():
    pass


@click.command(cli_util.override('identity_domains.user_capabilities_changer_group.command_name', 'user-capabilities-changer'), cls=CommandGroupWithAlias, help="""User Capabilities Changer""")
@cli_util.help_option_group
def user_capabilities_changer_group():
    pass


@click.command(cli_util.override('identity_domains.my_support_account_group.command_name', 'my-support-account'), cls=CommandGroupWithAlias, help="""Support Provider Account""")
@cli_util.help_option_group
def my_support_account_group():
    pass


@click.command(cli_util.override('identity_domains.identity_provider_group.command_name', 'identity-provider'), cls=CommandGroupWithAlias, help="""Federation trusted partner Identity Provider""")
@cli_util.help_option_group
def identity_provider_group():
    pass


@click.command(cli_util.override('identity_domains.api_key_group.command_name', 'api-key'), cls=CommandGroupWithAlias, help="""The user's API key.""")
@cli_util.help_option_group
def api_key_group():
    pass


@click.command(cli_util.override('identity_domains.oci_console_sign_on_policy_consent_group.command_name', 'oci-console-sign-on-policy-consent'), cls=CommandGroupWithAlias, help="""The \"Security Policy for OCI Console\" sign-on policy consent resource used to record consents. The schema to record the \"Security Policy for OCI Console\" sign-on policy consent.""")
@cli_util.help_option_group
def oci_console_sign_on_policy_consent_group():
    pass


@click.command(cli_util.override('identity_domains.my_groups_group.command_name', 'my-groups'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def my_groups_group():
    pass


@click.command(cli_util.override('identity_domains.account_recovery_settings_group.command_name', 'account-recovery-settings'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def account_recovery_settings_group():
    pass


@click.command(cli_util.override('identity_domains.auth_token_group.command_name', 'auth-token'), cls=CommandGroupWithAlias, help="""The user's Auth token resource.""")
@cli_util.help_option_group
def auth_token_group():
    pass


@click.command(cli_util.override('identity_domains.grant_group.command_name', 'grant'), cls=CommandGroupWithAlias, help="""Schema for Grant Resource""")
@cli_util.help_option_group
def grant_group():
    pass


@click.command(cli_util.override('identity_domains.my_requests_group.command_name', 'my-requests'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def my_requests_group():
    pass


@click.command(cli_util.override('identity_domains.approval_workflow_group.command_name', 'approval-workflow'), cls=CommandGroupWithAlias, help="""Schema for ApprovalWorkflow""")
@cli_util.help_option_group
def approval_workflow_group():
    pass


@click.command(cli_util.override('identity_domains.identity_propagation_trust_group.command_name', 'identity-propagation-trust'), cls=CommandGroupWithAlias, help="""Schema used for Identity Propagation Trust.""")
@cli_util.help_option_group
def identity_propagation_trust_group():
    pass


@click.command(cli_util.override('identity_domains.user_group.command_name', 'user'), cls=CommandGroupWithAlias, help="""User Account""")
@cli_util.help_option_group
def user_group():
    pass


@click.command(cli_util.override('identity_domains.cloud_gate_servers_group.command_name', 'cloud-gate-servers'), cls=CommandGroupWithAlias, help="""The SCIM protocol defines a standard set of query parameters that can be used to filter, sort, and paginate to return zero or more resources in a query response. Queries MAY be made against a single resource or a resource type endpoint (e.g., /Users), or the service provider Base URI.""")
@cli_util.help_option_group
def cloud_gate_servers_group():
    pass


@click.command(cli_util.override('identity_domains.identity_setting_group.command_name', 'identity-setting'), cls=CommandGroupWithAlias, help="""Identity Settings""")
@cli_util.help_option_group
def identity_setting_group():
    pass


identity_domains_root_group.add_command(my_pending_approval_group)
identity_domains_root_group.add_command(my_user_db_credential_group)
identity_domains_root_group.add_command(identity_propagation_trusts_group)
identity_domains_root_group.add_command(dynamic_resource_groups_group)
identity_domains_root_group.add_command(my_api_keys_group)
identity_domains_root_group.add_command(my_authentication_factors_remover_group)
identity_domains_root_group.add_command(setting_group)
identity_domains_root_group.add_command(user_db_credentials_group)
identity_domains_root_group.add_command(branding_setting_group)
identity_domains_root_group.add_command(identity_providers_group)
identity_domains_root_group.add_command(user_password_changer_group)
identity_domains_root_group.add_command(app_group)
identity_domains_root_group.add_command(resource_type_schema_attributes_group)
identity_domains_root_group.add_command(my_device_group)
identity_domains_root_group.add_command(authentication_factors_remover_group)
identity_domains_root_group.add_command(account_recovery_setting_group)
identity_domains_root_group.add_command(self_registration_profiles_group)
identity_domains_root_group.add_command(my_completed_approvals_group)
identity_domains_root_group.add_command(network_perimeter_group)
identity_domains_root_group.add_command(my_customer_secret_key_group)
identity_domains_root_group.add_command(schema_group)
identity_domains_root_group.add_command(password_policies_group)
identity_domains_root_group.add_command(customer_secret_keys_group)
identity_domains_root_group.add_command(app_role_group)
identity_domains_root_group.add_command(my_auth_tokens_group)
identity_domains_root_group.add_command(user_password_resetter_group)
identity_domains_root_group.add_command(security_questions_group)
identity_domains_root_group.add_command(my_support_accounts_group)
identity_domains_root_group.add_command(approval_workflow_step_group)
identity_domains_root_group.add_command(my_api_key_group)
identity_domains_root_group.add_command(user_attributes_setting_group)
identity_domains_root_group.add_command(api_keys_group)
identity_domains_root_group.add_command(apps_group)
identity_domains_root_group.add_command(my_requestable_groups_group)
identity_domains_root_group.add_command(policy_group)
identity_domains_root_group.add_command(kmsi_settings_group)
identity_domains_root_group.add_command(o_auth_partner_certificate_group)
identity_domains_root_group.add_command(o_auth2_client_credentials_group)
identity_domains_root_group.add_command(o_auth_client_certificate_group)
identity_domains_root_group.add_command(my_devices_group)
identity_domains_root_group.add_command(password_policy_group)
identity_domains_root_group.add_command(auth_tokens_group)
identity_domains_root_group.add_command(smtp_credentials_group)
identity_domains_root_group.add_command(account_mgmt_infos_group)
identity_domains_root_group.add_command(identity_settings_group)
identity_domains_root_group.add_command(approval_workflows_group)
identity_domains_root_group.add_command(my_request_group)
identity_domains_root_group.add_command(security_question_group)
identity_domains_root_group.add_command(authentication_factor_settings_group)
identity_domains_root_group.add_command(o_auth2_client_credential_group)
identity_domains_root_group.add_command(my_o_auth2_client_credentials_group)
identity_domains_root_group.add_command(my_smtp_credential_group)
identity_domains_root_group.add_command(dynamic_resource_group_group)
identity_domains_root_group.add_command(my_completed_approval_group)
identity_domains_root_group.add_command(my_user_db_credentials_group)
identity_domains_root_group.add_command(me_group)
identity_domains_root_group.add_command(user_db_credential_group)
identity_domains_root_group.add_command(cloud_gates_group)
identity_domains_root_group.add_command(group_group)
identity_domains_root_group.add_command(social_identity_provider_group)
identity_domains_root_group.add_command(network_perimeters_group)
identity_domains_root_group.add_command(settings_group)
identity_domains_root_group.add_command(o_auth_client_certificates_group)
identity_domains_root_group.add_command(cloud_gate_group)
identity_domains_root_group.add_command(restore_oci_console_policy_group)
identity_domains_root_group.add_command(cloud_gate_mappings_group)
identity_domains_root_group.add_command(users_group)
identity_domains_root_group.add_command(my_pending_approvals_group)
identity_domains_root_group.add_command(condition_group)
identity_domains_root_group.add_command(my_smtp_credentials_group)
identity_domains_root_group.add_command(my_o_auth2_client_credential_group)
identity_domains_root_group.add_command(schemas_group)
identity_domains_root_group.add_command(me_password_changer_group)
identity_domains_root_group.add_command(authentication_factor_setting_group)
identity_domains_root_group.add_command(my_authentication_factor_validator_group)
identity_domains_root_group.add_command(self_registration_profile_group)
identity_domains_root_group.add_command(my_authentication_factor_initiator_group)
identity_domains_root_group.add_command(notification_settings_group)
identity_domains_root_group.add_command(rule_group)
identity_domains_root_group.add_command(user_status_changer_group)
identity_domains_root_group.add_command(my_apps_group)
identity_domains_root_group.add_command(notification_setting_group)
identity_domains_root_group.add_command(my_customer_secret_keys_group)
identity_domains_root_group.add_command(cloud_gate_server_group)
identity_domains_root_group.add_command(branding_settings_group)
identity_domains_root_group.add_command(kmsi_setting_group)
identity_domains_root_group.add_command(approval_workflow_assignment_group)
identity_domains_root_group.add_command(smtp_credential_group)
identity_domains_root_group.add_command(my_trusted_user_agent_group)
identity_domains_root_group.add_command(security_question_setting_group)
identity_domains_root_group.add_command(approval_workflow_assignments_group)
identity_domains_root_group.add_command(app_roles_group)
identity_domains_root_group.add_command(account_mgmt_info_group)
identity_domains_root_group.add_command(grants_group)
identity_domains_root_group.add_command(app_status_changer_group)
identity_domains_root_group.add_command(approval_workflow_steps_group)
identity_domains_root_group.add_command(cloud_gate_mapping_group)
identity_domains_root_group.add_command(my_trusted_user_agents_group)
identity_domains_root_group.add_command(customer_secret_key_group)
identity_domains_root_group.add_command(my_auth_token_group)
identity_domains_root_group.add_command(groups_group)
identity_domains_root_group.add_command(o_auth_partner_certificates_group)
identity_domains_root_group.add_command(security_question_settings_group)
identity_domains_root_group.add_command(user_capabilities_changer_group)
identity_domains_root_group.add_command(my_support_account_group)
identity_domains_root_group.add_command(identity_provider_group)
identity_domains_root_group.add_command(api_key_group)
identity_domains_root_group.add_command(oci_console_sign_on_policy_consent_group)
identity_domains_root_group.add_command(my_groups_group)
identity_domains_root_group.add_command(account_recovery_settings_group)
identity_domains_root_group.add_command(auth_token_group)
identity_domains_root_group.add_command(grant_group)
identity_domains_root_group.add_command(my_requests_group)
identity_domains_root_group.add_command(approval_workflow_group)
identity_domains_root_group.add_command(identity_propagation_trust_group)
identity_domains_root_group.add_command(user_group)
identity_domains_root_group.add_command(cloud_gate_servers_group)
identity_domains_root_group.add_command(identity_setting_group)


@api_key_group.command(name=cli_util.override('identity_domains.create_api_key.command_name', 'create'), help=u"""Create a user's API key.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](createApiKey)""")
@cli_util.option('--schemas', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--fingerprint', required=True, help=u"""Fingerprint

**Added In:** 2010242156

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - type: string  - mutability: readOnly  - required: true  - returned: default""")
@cli_util.option('--key', required=True, help=u"""Key

**Added In:** 2010242156

**SCIM++ Properties:**  - caseExact: true  - idcsPii: true  - type: string  - mutability: immutable  - required: true  - returned: default""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--attributes', help=u"""A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.""")
@cli_util.option('--attribute-sets', type=custom_types.CliCaseInsensitiveChoice(["all", "always", "never", "request", "default"]), multiple=True, help=u"""A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.""")
@cli_util.option('--id', help=u"""Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--ocid', help=u"""Unique OCI identifier for the SCIM Resource.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: string  - uniqueness: global""")
@cli_util.option('--meta', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-created-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-last-modified-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-prevented-operations', type=custom_types.CliCaseInsensitiveChoice(["replace", "update", "delete"]), help=u"""Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of tags on this resource.

**SCIM++ Properties:**  - idcsCompositeKey: [key, value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type Tags.  For documentation on tags please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/Tags.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--delete-in-progress', type=click.BOOL, help=u"""A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--idcs-last-upgraded-in-release', help=u"""The release number when the resource was upgraded.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--domain-ocid', help=u"""OCI Domain Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--compartment-ocid', help=u"""OCI Compartment Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--tenancy-ocid', help=u"""OCI Tenant Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--description', help=u"""Description

**Added In:** 2101262133

**SCIM++ Properties:**  - caseExact: false  - type: string  - mutability: readWrite  - required: false  - returned: default""")
@cli_util.option('--user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionself-change-user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'user': {'module': 'identity_domains', 'class': 'ApiKeyUser'}, 'urnietfparamsscimschemasoracleidcsextensionself-change-user': {'module': 'identity_domains', 'class': 'ExtensionSelfChangeUser'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'user': {'module': 'identity_domains', 'class': 'ApiKeyUser'}, 'urnietfparamsscimschemasoracleidcsextensionself-change-user': {'module': 'identity_domains', 'class': 'ExtensionSelfChangeUser'}}, output_type={'module': 'identity_domains', 'class': 'ApiKey'})
@cli_util.wrap_exceptions
def create_api_key(ctx, from_json, schemas, fingerprint, key, authorization, resource_type_schema_version, attributes, attribute_sets, id, ocid, meta, idcs_created_by, idcs_last_modified_by, idcs_prevented_operations, tags, delete_in_progress, idcs_last_upgraded_in_release, domain_ocid, compartment_ocid, tenancy_ocid, description, user, urnietfparamsscimschemasoracleidcsextensionself_change_user):

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if attributes is not None:
        kwargs['attributes'] = attributes
    if attribute_sets is not None and len(attribute_sets) > 0:
        kwargs['attribute_sets'] = attribute_sets

    _details = {}
    _details['schemas'] = cli_util.parse_json_parameter("schemas", schemas)
    _details['fingerprint'] = fingerprint
    _details['key'] = key

    if id is not None:
        _details['id'] = id

    if ocid is not None:
        _details['ocid'] = ocid

    if meta is not None:
        _details['meta'] = cli_util.parse_json_parameter("meta", meta)

    if idcs_created_by is not None:
        _details['idcsCreatedBy'] = cli_util.parse_json_parameter("idcs_created_by", idcs_created_by)

    if idcs_last_modified_by is not None:
        _details['idcsLastModifiedBy'] = cli_util.parse_json_parameter("idcs_last_modified_by", idcs_last_modified_by)

    if idcs_prevented_operations is not None:
        _details['idcsPreventedOperations'] = cli_util.parse_json_parameter("idcs_prevented_operations", idcs_prevented_operations)

    if tags is not None:
        _details['tags'] = cli_util.parse_json_parameter("tags", tags)

    if delete_in_progress is not None:
        _details['deleteInProgress'] = delete_in_progress

    if idcs_last_upgraded_in_release is not None:
        _details['idcsLastUpgradedInRelease'] = idcs_last_upgraded_in_release

    if domain_ocid is not None:
        _details['domainOcid'] = domain_ocid

    if compartment_ocid is not None:
        _details['compartmentOcid'] = compartment_ocid

    if tenancy_ocid is not None:
        _details['tenancyOcid'] = tenancy_ocid

    if description is not None:
        _details['description'] = description

    if user is not None:
        _details['user'] = cli_util.parse_json_parameter("user", user)

    if urnietfparamsscimschemasoracleidcsextensionself_change_user is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:selfChange:User'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionself_change_user", urnietfparamsscimschemasoracleidcsextensionself_change_user)

    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.create_api_key(
        api_key=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@app_group.command(name=cli_util.override('identity_domains.create_app.command_name', 'create'), help=u"""Create an App

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](createApp)""")
@cli_util.option('--schemas', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--display-name', required=True, help=u"""Display name of the application. Display name is intended to be user-friendly, and an administrator can change the value at any time.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: true  - returned: always  - type: string  - uniqueness: server""")
@cli_util.option('--based-on-template', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--attributes', help=u"""A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.""")
@cli_util.option('--attribute-sets', type=custom_types.CliCaseInsensitiveChoice(["all", "always", "never", "request", "default"]), multiple=True, help=u"""A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.""")
@cli_util.option('--id', help=u"""Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--ocid', help=u"""Unique OCI identifier for the SCIM Resource.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: string  - uniqueness: global""")
@cli_util.option('--meta', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-created-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-last-modified-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-prevented-operations', type=custom_types.CliCaseInsensitiveChoice(["replace", "update", "delete"]), help=u"""Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of tags on this resource.

**SCIM++ Properties:**  - idcsCompositeKey: [key, value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type Tags.  For documentation on tags please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/Tags.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--delete-in-progress', type=click.BOOL, help=u"""A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--idcs-last-upgraded-in-release', help=u"""The release number when the resource was upgraded.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--domain-ocid', help=u"""OCI Domain Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--compartment-ocid', help=u"""OCI Compartment Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--tenancy-ocid', help=u"""OCI Tenant Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--meter-as-opc-service', type=click.BOOL, help=u"""Indicates whether the application is billed as an OPCService. If true, customer is not billed for runtime operations of the app.

**Added In:** 18.4.2

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: boolean  - uniqueness: none""")
@cli_util.option('--name', help=u"""Name of the application. Also serves as username if the application authenticates to Oracle Public Cloud infrastructure. This name may not be user-friendly and cannot be changed once an App is created.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: string  - uniqueness: server""")
@cli_util.option('--client-secret', help=u"""This value is the credential of this App, which this App supplies as a password when this App authenticates to the Oracle Public Cloud infrastructure. This value is also the client secret of this App when it acts as an OAuthClient.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - idcsSensitive: none  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--hashed-client-secret', help=u"""Hashed Client Secret. This hash-value is used to verify the 'clientSecret' credential of this App

**Added In:** 2106240046

**SCIM++ Properties:**  - idcsSearchable: false  - idcsSensitive: hash_sc  - multiValued: false  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--description', help=u"""Description of the application.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--id-token-enc-algo', help=u"""Encryption Alogrithm to use for encrypting ID token.

**Added In:** 2010242156

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--delegated-service-names', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Service Names allow to use OCI signature for client authentication instead of client credentials

**Added In:** 2207040824

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--active', type=click.BOOL, help=u"""If true, this App is able to participate in runtime services, such as automatic-login, OAuth, and SAML. If false, all runtime services are disabled for this App, and only administrative operations can be performed.

**SCIM++ Properties:**  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--app-icon', help=u"""Application icon.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--app-thumbnail', help=u"""Application thumbnail.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--migrated', type=click.BOOL, help=u"""If true, this App was migrated from an earlier version of Oracle Public Cloud infrastructure (and may therefore require special handling from runtime services such as OAuth or SAML). If false, this App requires no special handling from runtime services.

**SCIM++ Properties:**  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--infrastructure', type=click.BOOL, help=u"""If true, this App is an internal infrastructure App.

**SCIM++ Properties:**  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--is-login-target', type=click.BOOL, help=u"""If true, this App allows runtime services to log end users into this App automatically.

**SCIM++ Properties:**  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--show-in-my-apps', type=click.BOOL, help=u"""If true, this app will be displayed in the MyApps page of each end-user who has access to the App.

**Added In:** 18.1.2

**SCIM++ Properties:**  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--login-mechanism', type=custom_types.CliCaseInsensitiveChoice(["OIDC", "SAML", "FORMFILL", "RADIUS"]), help=u"""The protocol that runtime services will use to log end users in to this App automatically. If 'OIDC', then runtime services use the OpenID Connect protocol. If 'SAML', then runtime services use Security Assertion Markup Language protocol.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--landing-page-url', help=u"""The URL of the landing page for this App, which is the first page that an end user should see if runtime services log that end user in to this App automatically.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--product-logo-url', help=u"""Application Logo URL

**Added In:** 19.2.1

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--privacy-policy-url', help=u"""Privacy Policy URL

**Added In:** 19.2.1

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--terms-of-service-url', help=u"""Terms of Service URL

**Added In:** 19.2.1

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--contact-email-address', help=u"""Contact Email Address

**Added In:** 19.2.1

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--product-name', help=u"""Product Name

**Added In:** 19.2.1

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--home-page-url', help=u"""Home Page URL

**Added In:** 19.2.1

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--is-form-fill', type=click.BOOL, help=u"""If true, this application acts as FormFill Application

**SCIM++ Properties:**  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--is-o-auth-client', type=click.BOOL, help=u"""If true, this application acts as an OAuth Client

**SCIM++ Properties:**  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--is-radius-app', type=click.BOOL, help=u"""If true, this application acts as an Radius App

**Added In:** 20.1.3

**SCIM++ Properties:**  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--client-type', type=custom_types.CliCaseInsensitiveChoice(["confidential", "public", "trusted"]), help=u"""Specifies the type of access that this App has when it acts as an OAuthClient.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--redirect-uris', type=custom_types.CLI_COMPLEX_TYPE, help=u"""OPTIONAL. Each value is a URI within this App. This attribute is required when this App acts as an OAuthClient and is involved in three-legged flows (authorization-code flows).

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--all-url-schemes-allowed', type=click.BOOL, help=u"""If true, indicates that the system should allow all URL-schemes within each value of the 'redirectUris' attribute.  Also indicates that the system should not attempt to confirm that each value of the 'redirectUris' attribute is a valid URI.  In particular, the system should not confirm that the domain component of the URI is a top-level domain and the system should not confirm that the hostname portion is a valid system that is reachable over the network.

**SCIM++ Properties:**  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--logout-uri', help=u"""OAuth will use this URI to logout if this App wants to participate in SSO, and if this App's session gets cleared as part of global logout. Note: This attribute is used only if this App acts as an OAuthClient.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--post-logout-redirect-uris', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Each value of this attribute is the URI of a landing page within this App. It is used only when this App, acting as an OAuthClient, initiates the logout flow and wants to be redirected back to one of its landing pages.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--allowed-grants', type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of grant-types that this App is allowed to use when it acts as an OAuthClient.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--allowed-operations', type=custom_types.CliCaseInsensitiveChoice(["introspect", "onBehalfOfUser"]), help=u"""OPTIONAL. Required only when this App acts as an OAuthClient. Supported values are 'introspect' and 'onBehalfOfUser'. The value 'introspect' allows the client to look inside the access-token. The value 'onBehalfOfUser' overrides how the client's privileges are combined with the privileges of the Subject User. Ordinarily, authorization calculates the set of effective privileges as the intersection of the client's privileges and the user's privileges. The value 'onBehalfOf' indicates that authorization should ignore the privileges of the client and use only the user's privileges to calculate the effective privileges.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--client-ip-checking', type=custom_types.CliCaseInsensitiveChoice(["anywhere", "whitelisted"]), help=u"""Network Perimeters checking mode

**Added In:** 2010242156

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--is-opc-service', type=click.BOOL, help=u"""If true, this application is an Oracle Public Cloud service-instance.

**SCIM++ Properties:**  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--is-unmanaged-app', type=click.BOOL, help=u"""If true, indicates that this application accepts an Oracle Cloud Identity Service User as a login-identity (does not require an account) and relies for authorization on the User's memberships in AppRoles.

**SCIM++ Properties:**  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--allow-access-control', type=click.BOOL, help=u"""If true, any managed App that is based on this template is checked for access control that is, access to this app is subject to successful authorization at SSO service, viz. app grants to start with.

**SCIM++ Properties:**  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--is-o-auth-resource', type=click.BOOL, help=u"""If true, indicates that this application acts as an OAuth Resource.

**SCIM++ Properties:**  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--access-token-expiry', type=click.INT, help=u"""Expiry-time in seconds for an Access Token. Any token that allows access to this App will expire after the specified duration.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: integer  - uniqueness: none""")
@cli_util.option('--refresh-token-expiry', type=click.INT, help=u"""Expiry-time in seconds for a Refresh Token.  Any token that allows access to this App, once refreshed, will expire after the specified duration.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: integer  - uniqueness: none""")
@cli_util.option('--allow-offline', type=click.BOOL, help=u"""If true, indicates that the Refresh Token is allowed when this App acts as an OAuth Resource.

**SCIM++ Properties:**  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--callback-service-url', help=u"""Callback Service URL

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--audience', help=u"""The base URI for all of the scopes defined in this App. The value of 'audience' is combined with the 'value' of each scope to form an 'fqs' or fully qualified scope.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--is-mobile-target', type=click.BOOL, help=u"""If true, indicates that the App should be visible in each end-user's mobile application.

**SCIM++ Properties:**  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--login-page-url', help=u"""This attribute specifies the URL of the page that the App uses when an end-user signs in to that App.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--linking-callback-url', help=u"""This attribute specifies the callback URL for the social linking operation.

**Added In:** 18.2.4

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--logout-page-url', help=u"""This attribute specifies the URL of the page that the App uses when an end-user signs out.

**Added In:** 17.4.2

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--error-page-url', help=u"""This attribute specifies the URL of the page to which an application will redirect an end-user in case of error.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--is-saml-service-provider', type=click.BOOL, help=u"""If true, then this App acts as a SAML Service Provider.

**SCIM++ Properties:**  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--is-web-tier-policy', type=click.BOOL, help=u"""If true, the webtier policy is active

**SCIM++ Properties:**  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--is-kerberos-realm', type=click.BOOL, help=u"""If true, indicates that this App supports Kerberos Authentication

**SCIM++ Properties:**  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--icon', help=u"""URL of application icon.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: reference  - uniqueness: none""")
@cli_util.option('--is-alias-app', type=click.BOOL, help=u"""If true, this App is an AliasApp and it cannot be granted to an end-user directly.

**SCIM++ Properties:**  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: always  - type: boolean  - uniqueness: none""")
@cli_util.option('--is-managed-app', type=click.BOOL, help=u"""If true, indicates that access to this App requires an account. That is, in order to log in to the App, a User must use an application-specific identity that is maintained in the remote identity-repository of that App.

**SCIM++ Properties:**  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--service-type-urn', help=u"""This Uniform Resource Name (URN) value identifies the type of Oracle Public Cloud service of which this app is an instance.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--service-type-version', help=u"""This value specifies the version of the Oracle Public Cloud service of which this App is an instance

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--is-obligation-capable', type=click.BOOL, help=u"""This flag indicates if the App is capable of validating obligations with the token for allowing access to the App.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--ready-to-upgrade', type=click.BOOL, help=u"""If true, this App requires an upgrade and mandates attention from application administrator. The flag is used by UI to indicate this app is ready to upgrade.

**SCIM++ Properties:**  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--trust-scope', type=custom_types.CliCaseInsensitiveChoice(["Explicit", "Account", "Tags", "Default"]), help=u"""Indicates the scope of trust for this App when acting as an OAuthClient. A value of 'Explicit' indicates that the App is allowed to access only the scopes of OAuthResources that are explicitly specified as 'allowedScopes'. A value of 'Account' indicates that the App is allowed implicitly to access any scope of any OAuthResource within the same Oracle Cloud Account. A value of 'Tags' indicates that the App is allowed to access any scope of any OAuthResource with a matching tag within the same Oracle Cloud Account. A value of 'Default' indicates that the Tenant default trust scope configured in the Tenant Settings is used.

**Added In:** 17.4.2

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--is-database-service', type=click.BOOL, help=u"""If true, this application acts as database service Application

**Added In:** 18.2.2

**SCIM++ Properties:**  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - type: boolean""")
@cli_util.option('--secondary-audiences', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of secondary audiences--additional URIs to be added automatically to any OAuth token that allows access to this App. Note: This attribute is used mainly for backward compatibility in certain Oracle Public Cloud Apps.

**Deprecated Since: 18.2.6**

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--is-enterprise-app', type=click.BOOL, help=u"""If true, this app acts as Enterprise app with Authentication and URL Authz policy.

**Added In:** 19.2.1

**SCIM++ Properties:**  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--bypass-consent', type=click.BOOL, help=u"""If true, indicates that consent should be skipped for all scopes

**Added In:** 19.2.1

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--disable-kmsi-token-authentication', type=click.BOOL, help=u"""Indicates whether the application is allowed to be access using kmsi token.

**Added In:** 2111190457

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: always  - type: boolean  - uniqueness: none""")
@cli_util.option('--is-multicloud-service-app', type=click.BOOL, help=u"""If true, indicates the app is used for multicloud service integration.

**Added In:** 2301202328

**SCIM++ Properties:**  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--radius-policy', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--apps-network-perimeters', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Network Perimeter

**Added In:** 2010242156

**SCIM++ Properties:**  - idcsCompositeKey: [value]  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: complex

This option is a JSON list with items of type AppAppsNetworkPerimeters.  For documentation on AppAppsNetworkPerimeters please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/AppAppsNetworkPerimeters.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--cloud-control-properties', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A collection of arbitrary properties that scope the privileges of a cloud-control App.

**Added In:** 18.4.2

**SCIM++ Properties:**  - idcsCompositeKey: [name]  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type AppCloudControlProperties.  For documentation on AppCloudControlProperties please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/AppCloudControlProperties.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--editable-attributes', type=custom_types.CLI_COMPLEX_TYPE, help=u"""App attributes editable by subject

**Added In:** 18.2.6

**SCIM++ Properties:**  - caseExact: false  - idcsCompositeKey: [name]  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type AppEditableAttributes.  For documentation on AppEditableAttributes please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/AppEditableAttributes.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--terms-of-use', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--protectable-secondary-audiences', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of secondary audiences--additional URIs to be added automatically to any OAuth token that allows access to this App. Note: This attribute is used mainly for backward compatibility in certain Oracle Public Cloud Apps.

**Added In:** 18.2.2

**SCIM++ Properties:**  - caseExact: false  - idcsCompositeKey: [value]  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: complex  - uniqueness: none

This option is a JSON list with items of type AppProtectableSecondaryAudiences.  For documentation on AppProtectableSecondaryAudiences please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/AppProtectableSecondaryAudiences.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idp-policy', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--allowed-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of tags, acting as an OAuthClient, this App is allowed to access.

**Added In:** 17.4.6

**SCIM++ Properties:**  - idcsCompositeKey: [key, value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: complex  - uniqueness: none

This option is a JSON list with items of type AppAllowedTags.  For documentation on AppAllowedTags please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/AppAllowedTags.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--app-signon-policy', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--trust-policies', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Trust Policies.

**SCIM++ Properties:**  - idcsCompositeKey: [value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: complex

This option is a JSON list with items of type AppTrustPolicies.  For documentation on AppTrustPolicies please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/AppTrustPolicies.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--signon-policy', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--identity-providers', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of IdentityProvider assigned to app. A user trying to access this app will be automatically redirected to configured IdP during the authentication phase, before being able to access App.

**SCIM++ Properties:**  - idcsCompositeKey: [value]  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - type: complex

This option is a JSON list with items of type AppIdentityProviders.  For documentation on AppIdentityProviders please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/AppIdentityProviders.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--accounts', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Accounts of App

**SCIM++ Properties:**  - idcsCompositeKey: [value]  - idcsSearchable: true  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type AppAccounts.  For documentation on AppAccounts please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/AppAccounts.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--grants', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Grants assigned to the app

**SCIM++ Properties:**  - idcsCompositeKey: [value]  - idcsSearchable: true  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type AppGrants.  For documentation on AppGrants please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/AppGrants.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--service-params', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Custom attribute that is required to compute other attribute values during app creation.

**SCIM++ Properties:**  - idcsCompositeKey: [name]  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: false  - returned: always  - type: complex  - uniqueness: none

This option is a JSON list with items of type AppServiceParams.  For documentation on AppServiceParams please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/AppServiceParams.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--attr-rendering-metadata', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Label for the attribute to be shown in the UI.

**SCIM++ Properties:**  - idcsCompositeKey: [name]  - idcsSearchable: false  - multiValued: true  - mutability: immutable  - required: false  - returned: default  - type: complex  - uniqueness: none

This option is a JSON list with items of type AppAttrRenderingMetadata.  For documentation on AppAttrRenderingMetadata please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/AppAttrRenderingMetadata.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--granted-app-roles', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of AppRoles that are granted to this App (and that are defined by other Apps). Within the Oracle Public Cloud infrastructure, this allows AppID-based association. Such an association allows this App to act as a consumer and thus to access resources of another App that acts as a producer.

**SCIM++ Properties:**  - caseExact: true  - idcsCompositeKey: [value]  - idcsSearchable: true  - multiValued: true  - mutability: readOnly  - required: false  - returned: default  - type: complex  - uniqueness: none

This option is a JSON list with items of type AppGrantedAppRoles.  For documentation on AppGrantedAppRoles please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/AppGrantedAppRoles.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--saml-service-provider', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--allowed-scopes', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of scopes (exposed by this App or by other Apps) that this App is allowed to access when it acts as an OAuthClient.

**SCIM++ Properties:**  - caseExact: true  - idcsCompositeKey: [fqs]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: complex  - uniqueness: none

This option is a JSON list with items of type AppAllowedScopes.  For documentation on AppAllowedScopes please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/AppAllowedScopes.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--certificates', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Each value of this attribute represent a certificate that this App uses when it acts as an OAuthClient.

**SCIM++ Properties:**  - caseExact: false  - idcsCompositeKey: [certAlias]  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: complex  - uniqueness: none

This option is a JSON list with items of type AppCertificates.  For documentation on AppCertificates please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/AppCertificates.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--alias-apps', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Each value of this internal attribute refers to an Oracle Public Cloud infrastructure App on which this App depends.

**SCIM++ Properties:**  - caseExact: true  - idcsCompositeKey: [value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: complex  - uniqueness: none

This option is a JSON list with items of type AppAliasApps.  For documentation on AppAliasApps please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/AppAliasApps.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--as-opc-service', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--admin-roles', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of AppRoles defined by this UnmanagedApp. Membership in each of these AppRoles confers administrative privilege within this App.

**SCIM++ Properties:**  - idcsCompositeKey: [value]  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: complex

This option is a JSON list with items of type AppAdminRoles.  For documentation on AppAdminRoles please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/AppAdminRoles.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--user-roles', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of AppRoles defined by this UnmanagedApp. Membership in each of these AppRoles confers end-user privilege within this App.

**SCIM++ Properties:**  - idcsCompositeKey: [value]  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: complex

This option is a JSON list with items of type AppUserRoles.  For documentation on AppUserRoles please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/AppUserRoles.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--scopes', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Scopes defined by this App. Used when this App acts as an OAuth Resource.

**SCIM++ Properties:**  - caseExact: true  - idcsCompositeKey: [value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: complex  - uniqueness: none

This option is a JSON list with items of type AppScopes.  For documentation on AppScopes please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/AppScopes.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionradius-app-app', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionsaml-service-provider-app', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionweb-tier-policy-app', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionmanagedapp-app', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionform-fill-app-template-app-template', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionopc-service-app', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionkerberos-realm-app', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionrequestable-app', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionform-fill-app-app', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensiondbcs-app', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionenterprise-app-app', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextension-oci-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionmulticloud-service-app-app', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'delegated-service-names': {'module': 'identity_domains', 'class': 'list[string]'}, 'redirect-uris': {'module': 'identity_domains', 'class': 'list[string]'}, 'post-logout-redirect-uris': {'module': 'identity_domains', 'class': 'list[string]'}, 'allowed-grants': {'module': 'identity_domains', 'class': 'list[string]'}, 'secondary-audiences': {'module': 'identity_domains', 'class': 'list[string]'}, 'radius-policy': {'module': 'identity_domains', 'class': 'AppRadiusPolicy'}, 'apps-network-perimeters': {'module': 'identity_domains', 'class': 'list[AppAppsNetworkPerimeters]'}, 'cloud-control-properties': {'module': 'identity_domains', 'class': 'list[AppCloudControlProperties]'}, 'editable-attributes': {'module': 'identity_domains', 'class': 'list[AppEditableAttributes]'}, 'terms-of-use': {'module': 'identity_domains', 'class': 'AppTermsOfUse'}, 'protectable-secondary-audiences': {'module': 'identity_domains', 'class': 'list[AppProtectableSecondaryAudiences]'}, 'idp-policy': {'module': 'identity_domains', 'class': 'AppIdpPolicy'}, 'allowed-tags': {'module': 'identity_domains', 'class': 'list[AppAllowedTags]'}, 'app-signon-policy': {'module': 'identity_domains', 'class': 'AppAppSignonPolicy'}, 'trust-policies': {'module': 'identity_domains', 'class': 'list[AppTrustPolicies]'}, 'signon-policy': {'module': 'identity_domains', 'class': 'AppSignonPolicy'}, 'identity-providers': {'module': 'identity_domains', 'class': 'list[AppIdentityProviders]'}, 'accounts': {'module': 'identity_domains', 'class': 'list[AppAccounts]'}, 'grants': {'module': 'identity_domains', 'class': 'list[AppGrants]'}, 'service-params': {'module': 'identity_domains', 'class': 'list[AppServiceParams]'}, 'attr-rendering-metadata': {'module': 'identity_domains', 'class': 'list[AppAttrRenderingMetadata]'}, 'based-on-template': {'module': 'identity_domains', 'class': 'AppBasedOnTemplate'}, 'granted-app-roles': {'module': 'identity_domains', 'class': 'list[AppGrantedAppRoles]'}, 'saml-service-provider': {'module': 'identity_domains', 'class': 'AppSamlServiceProvider'}, 'allowed-scopes': {'module': 'identity_domains', 'class': 'list[AppAllowedScopes]'}, 'certificates': {'module': 'identity_domains', 'class': 'list[AppCertificates]'}, 'alias-apps': {'module': 'identity_domains', 'class': 'list[AppAliasApps]'}, 'as-opc-service': {'module': 'identity_domains', 'class': 'AppAsOPCService'}, 'admin-roles': {'module': 'identity_domains', 'class': 'list[AppAdminRoles]'}, 'user-roles': {'module': 'identity_domains', 'class': 'list[AppUserRoles]'}, 'scopes': {'module': 'identity_domains', 'class': 'list[AppScopes]'}, 'urnietfparamsscimschemasoracleidcsextensionradius-app-app': {'module': 'identity_domains', 'class': 'AppExtensionRadiusAppApp'}, 'urnietfparamsscimschemasoracleidcsextensionsaml-service-provider-app': {'module': 'identity_domains', 'class': 'AppExtensionSamlServiceProviderApp'}, 'urnietfparamsscimschemasoracleidcsextensionweb-tier-policy-app': {'module': 'identity_domains', 'class': 'AppExtensionWebTierPolicyApp'}, 'urnietfparamsscimschemasoracleidcsextensionmanagedapp-app': {'module': 'identity_domains', 'class': 'AppExtensionManagedappApp'}, 'urnietfparamsscimschemasoracleidcsextensionform-fill-app-template-app-template': {'module': 'identity_domains', 'class': 'AppExtensionFormFillAppTemplateAppTemplate'}, 'urnietfparamsscimschemasoracleidcsextensionopc-service-app': {'module': 'identity_domains', 'class': 'AppExtensionOpcServiceApp'}, 'urnietfparamsscimschemasoracleidcsextensionkerberos-realm-app': {'module': 'identity_domains', 'class': 'AppExtensionKerberosRealmApp'}, 'urnietfparamsscimschemasoracleidcsextensionrequestable-app': {'module': 'identity_domains', 'class': 'AppExtensionRequestableApp'}, 'urnietfparamsscimschemasoracleidcsextensionform-fill-app-app': {'module': 'identity_domains', 'class': 'AppExtensionFormFillAppApp'}, 'urnietfparamsscimschemasoracleidcsextensiondbcs-app': {'module': 'identity_domains', 'class': 'AppExtensionDbcsApp'}, 'urnietfparamsscimschemasoracleidcsextensionenterprise-app-app': {'module': 'identity_domains', 'class': 'AppExtensionEnterpriseAppApp'}, 'urnietfparamsscimschemasoracleidcsextension-oci-tags': {'module': 'identity_domains', 'class': 'ExtensionOCITags'}, 'urnietfparamsscimschemasoracleidcsextensionmulticloud-service-app-app': {'module': 'identity_domains', 'class': 'AppExtensionMulticloudServiceAppApp'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'delegated-service-names': {'module': 'identity_domains', 'class': 'list[string]'}, 'redirect-uris': {'module': 'identity_domains', 'class': 'list[string]'}, 'post-logout-redirect-uris': {'module': 'identity_domains', 'class': 'list[string]'}, 'allowed-grants': {'module': 'identity_domains', 'class': 'list[string]'}, 'secondary-audiences': {'module': 'identity_domains', 'class': 'list[string]'}, 'radius-policy': {'module': 'identity_domains', 'class': 'AppRadiusPolicy'}, 'apps-network-perimeters': {'module': 'identity_domains', 'class': 'list[AppAppsNetworkPerimeters]'}, 'cloud-control-properties': {'module': 'identity_domains', 'class': 'list[AppCloudControlProperties]'}, 'editable-attributes': {'module': 'identity_domains', 'class': 'list[AppEditableAttributes]'}, 'terms-of-use': {'module': 'identity_domains', 'class': 'AppTermsOfUse'}, 'protectable-secondary-audiences': {'module': 'identity_domains', 'class': 'list[AppProtectableSecondaryAudiences]'}, 'idp-policy': {'module': 'identity_domains', 'class': 'AppIdpPolicy'}, 'allowed-tags': {'module': 'identity_domains', 'class': 'list[AppAllowedTags]'}, 'app-signon-policy': {'module': 'identity_domains', 'class': 'AppAppSignonPolicy'}, 'trust-policies': {'module': 'identity_domains', 'class': 'list[AppTrustPolicies]'}, 'signon-policy': {'module': 'identity_domains', 'class': 'AppSignonPolicy'}, 'identity-providers': {'module': 'identity_domains', 'class': 'list[AppIdentityProviders]'}, 'accounts': {'module': 'identity_domains', 'class': 'list[AppAccounts]'}, 'grants': {'module': 'identity_domains', 'class': 'list[AppGrants]'}, 'service-params': {'module': 'identity_domains', 'class': 'list[AppServiceParams]'}, 'attr-rendering-metadata': {'module': 'identity_domains', 'class': 'list[AppAttrRenderingMetadata]'}, 'based-on-template': {'module': 'identity_domains', 'class': 'AppBasedOnTemplate'}, 'granted-app-roles': {'module': 'identity_domains', 'class': 'list[AppGrantedAppRoles]'}, 'saml-service-provider': {'module': 'identity_domains', 'class': 'AppSamlServiceProvider'}, 'allowed-scopes': {'module': 'identity_domains', 'class': 'list[AppAllowedScopes]'}, 'certificates': {'module': 'identity_domains', 'class': 'list[AppCertificates]'}, 'alias-apps': {'module': 'identity_domains', 'class': 'list[AppAliasApps]'}, 'as-opc-service': {'module': 'identity_domains', 'class': 'AppAsOPCService'}, 'admin-roles': {'module': 'identity_domains', 'class': 'list[AppAdminRoles]'}, 'user-roles': {'module': 'identity_domains', 'class': 'list[AppUserRoles]'}, 'scopes': {'module': 'identity_domains', 'class': 'list[AppScopes]'}, 'urnietfparamsscimschemasoracleidcsextensionradius-app-app': {'module': 'identity_domains', 'class': 'AppExtensionRadiusAppApp'}, 'urnietfparamsscimschemasoracleidcsextensionsaml-service-provider-app': {'module': 'identity_domains', 'class': 'AppExtensionSamlServiceProviderApp'}, 'urnietfparamsscimschemasoracleidcsextensionweb-tier-policy-app': {'module': 'identity_domains', 'class': 'AppExtensionWebTierPolicyApp'}, 'urnietfparamsscimschemasoracleidcsextensionmanagedapp-app': {'module': 'identity_domains', 'class': 'AppExtensionManagedappApp'}, 'urnietfparamsscimschemasoracleidcsextensionform-fill-app-template-app-template': {'module': 'identity_domains', 'class': 'AppExtensionFormFillAppTemplateAppTemplate'}, 'urnietfparamsscimschemasoracleidcsextensionopc-service-app': {'module': 'identity_domains', 'class': 'AppExtensionOpcServiceApp'}, 'urnietfparamsscimschemasoracleidcsextensionkerberos-realm-app': {'module': 'identity_domains', 'class': 'AppExtensionKerberosRealmApp'}, 'urnietfparamsscimschemasoracleidcsextensionrequestable-app': {'module': 'identity_domains', 'class': 'AppExtensionRequestableApp'}, 'urnietfparamsscimschemasoracleidcsextensionform-fill-app-app': {'module': 'identity_domains', 'class': 'AppExtensionFormFillAppApp'}, 'urnietfparamsscimschemasoracleidcsextensiondbcs-app': {'module': 'identity_domains', 'class': 'AppExtensionDbcsApp'}, 'urnietfparamsscimschemasoracleidcsextensionenterprise-app-app': {'module': 'identity_domains', 'class': 'AppExtensionEnterpriseAppApp'}, 'urnietfparamsscimschemasoracleidcsextension-oci-tags': {'module': 'identity_domains', 'class': 'ExtensionOCITags'}, 'urnietfparamsscimschemasoracleidcsextensionmulticloud-service-app-app': {'module': 'identity_domains', 'class': 'AppExtensionMulticloudServiceAppApp'}}, output_type={'module': 'identity_domains', 'class': 'App'})
@cli_util.wrap_exceptions
def create_app(ctx, from_json, schemas, display_name, based_on_template, authorization, resource_type_schema_version, attributes, attribute_sets, id, ocid, meta, idcs_created_by, idcs_last_modified_by, idcs_prevented_operations, tags, delete_in_progress, idcs_last_upgraded_in_release, domain_ocid, compartment_ocid, tenancy_ocid, meter_as_opc_service, name, client_secret, hashed_client_secret, description, id_token_enc_algo, delegated_service_names, active, app_icon, app_thumbnail, migrated, infrastructure, is_login_target, show_in_my_apps, login_mechanism, landing_page_url, product_logo_url, privacy_policy_url, terms_of_service_url, contact_email_address, product_name, home_page_url, is_form_fill, is_o_auth_client, is_radius_app, client_type, redirect_uris, all_url_schemes_allowed, logout_uri, post_logout_redirect_uris, allowed_grants, allowed_operations, client_ip_checking, is_opc_service, is_unmanaged_app, allow_access_control, is_o_auth_resource, access_token_expiry, refresh_token_expiry, allow_offline, callback_service_url, audience, is_mobile_target, login_page_url, linking_callback_url, logout_page_url, error_page_url, is_saml_service_provider, is_web_tier_policy, is_kerberos_realm, icon, is_alias_app, is_managed_app, service_type_urn, service_type_version, is_obligation_capable, ready_to_upgrade, trust_scope, is_database_service, secondary_audiences, is_enterprise_app, bypass_consent, disable_kmsi_token_authentication, is_multicloud_service_app, radius_policy, apps_network_perimeters, cloud_control_properties, editable_attributes, terms_of_use, protectable_secondary_audiences, idp_policy, allowed_tags, app_signon_policy, trust_policies, signon_policy, identity_providers, accounts, grants, service_params, attr_rendering_metadata, granted_app_roles, saml_service_provider, allowed_scopes, certificates, alias_apps, as_opc_service, admin_roles, user_roles, scopes, urnietfparamsscimschemasoracleidcsextensionradius_app_app, urnietfparamsscimschemasoracleidcsextensionsaml_service_provider_app, urnietfparamsscimschemasoracleidcsextensionweb_tier_policy_app, urnietfparamsscimschemasoracleidcsextensionmanagedapp_app, urnietfparamsscimschemasoracleidcsextensionform_fill_app_template_app_template, urnietfparamsscimschemasoracleidcsextensionopc_service_app, urnietfparamsscimschemasoracleidcsextensionkerberos_realm_app, urnietfparamsscimschemasoracleidcsextensionrequestable_app, urnietfparamsscimschemasoracleidcsextensionform_fill_app_app, urnietfparamsscimschemasoracleidcsextensiondbcs_app, urnietfparamsscimschemasoracleidcsextensionenterprise_app_app, urnietfparamsscimschemasoracleidcsextension_oci_tags, urnietfparamsscimschemasoracleidcsextensionmulticloud_service_app_app):

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if attributes is not None:
        kwargs['attributes'] = attributes
    if attribute_sets is not None and len(attribute_sets) > 0:
        kwargs['attribute_sets'] = attribute_sets

    _details = {}
    _details['schemas'] = cli_util.parse_json_parameter("schemas", schemas)
    _details['displayName'] = display_name
    _details['basedOnTemplate'] = cli_util.parse_json_parameter("based_on_template", based_on_template)

    if id is not None:
        _details['id'] = id

    if ocid is not None:
        _details['ocid'] = ocid

    if meta is not None:
        _details['meta'] = cli_util.parse_json_parameter("meta", meta)

    if idcs_created_by is not None:
        _details['idcsCreatedBy'] = cli_util.parse_json_parameter("idcs_created_by", idcs_created_by)

    if idcs_last_modified_by is not None:
        _details['idcsLastModifiedBy'] = cli_util.parse_json_parameter("idcs_last_modified_by", idcs_last_modified_by)

    if idcs_prevented_operations is not None:
        _details['idcsPreventedOperations'] = cli_util.parse_json_parameter("idcs_prevented_operations", idcs_prevented_operations)

    if tags is not None:
        _details['tags'] = cli_util.parse_json_parameter("tags", tags)

    if delete_in_progress is not None:
        _details['deleteInProgress'] = delete_in_progress

    if idcs_last_upgraded_in_release is not None:
        _details['idcsLastUpgradedInRelease'] = idcs_last_upgraded_in_release

    if domain_ocid is not None:
        _details['domainOcid'] = domain_ocid

    if compartment_ocid is not None:
        _details['compartmentOcid'] = compartment_ocid

    if tenancy_ocid is not None:
        _details['tenancyOcid'] = tenancy_ocid

    if meter_as_opc_service is not None:
        _details['meterAsOPCService'] = meter_as_opc_service

    if name is not None:
        _details['name'] = name

    if client_secret is not None:
        _details['clientSecret'] = client_secret

    if hashed_client_secret is not None:
        _details['hashedClientSecret'] = hashed_client_secret

    if description is not None:
        _details['description'] = description

    if id_token_enc_algo is not None:
        _details['idTokenEncAlgo'] = id_token_enc_algo

    if delegated_service_names is not None:
        _details['delegatedServiceNames'] = cli_util.parse_json_parameter("delegated_service_names", delegated_service_names)

    if active is not None:
        _details['active'] = active

    if app_icon is not None:
        _details['appIcon'] = app_icon

    if app_thumbnail is not None:
        _details['appThumbnail'] = app_thumbnail

    if migrated is not None:
        _details['migrated'] = migrated

    if infrastructure is not None:
        _details['infrastructure'] = infrastructure

    if is_login_target is not None:
        _details['isLoginTarget'] = is_login_target

    if show_in_my_apps is not None:
        _details['showInMyApps'] = show_in_my_apps

    if login_mechanism is not None:
        _details['loginMechanism'] = login_mechanism

    if landing_page_url is not None:
        _details['landingPageUrl'] = landing_page_url

    if product_logo_url is not None:
        _details['productLogoUrl'] = product_logo_url

    if privacy_policy_url is not None:
        _details['privacyPolicyUrl'] = privacy_policy_url

    if terms_of_service_url is not None:
        _details['termsOfServiceUrl'] = terms_of_service_url

    if contact_email_address is not None:
        _details['contactEmailAddress'] = contact_email_address

    if product_name is not None:
        _details['productName'] = product_name

    if home_page_url is not None:
        _details['homePageUrl'] = home_page_url

    if is_form_fill is not None:
        _details['isFormFill'] = is_form_fill

    if is_o_auth_client is not None:
        _details['isOAuthClient'] = is_o_auth_client

    if is_radius_app is not None:
        _details['isRadiusApp'] = is_radius_app

    if client_type is not None:
        _details['clientType'] = client_type

    if redirect_uris is not None:
        _details['redirectUris'] = cli_util.parse_json_parameter("redirect_uris", redirect_uris)

    if all_url_schemes_allowed is not None:
        _details['allUrlSchemesAllowed'] = all_url_schemes_allowed

    if logout_uri is not None:
        _details['logoutUri'] = logout_uri

    if post_logout_redirect_uris is not None:
        _details['postLogoutRedirectUris'] = cli_util.parse_json_parameter("post_logout_redirect_uris", post_logout_redirect_uris)

    if allowed_grants is not None:
        _details['allowedGrants'] = cli_util.parse_json_parameter("allowed_grants", allowed_grants)

    if allowed_operations is not None:
        _details['allowedOperations'] = cli_util.parse_json_parameter("allowed_operations", allowed_operations)

    if client_ip_checking is not None:
        _details['clientIPChecking'] = client_ip_checking

    if is_opc_service is not None:
        _details['isOPCService'] = is_opc_service

    if is_unmanaged_app is not None:
        _details['isUnmanagedApp'] = is_unmanaged_app

    if allow_access_control is not None:
        _details['allowAccessControl'] = allow_access_control

    if is_o_auth_resource is not None:
        _details['isOAuthResource'] = is_o_auth_resource

    if access_token_expiry is not None:
        _details['accessTokenExpiry'] = access_token_expiry

    if refresh_token_expiry is not None:
        _details['refreshTokenExpiry'] = refresh_token_expiry

    if allow_offline is not None:
        _details['allowOffline'] = allow_offline

    if callback_service_url is not None:
        _details['callbackServiceUrl'] = callback_service_url

    if audience is not None:
        _details['audience'] = audience

    if is_mobile_target is not None:
        _details['isMobileTarget'] = is_mobile_target

    if login_page_url is not None:
        _details['loginPageUrl'] = login_page_url

    if linking_callback_url is not None:
        _details['linkingCallbackUrl'] = linking_callback_url

    if logout_page_url is not None:
        _details['logoutPageUrl'] = logout_page_url

    if error_page_url is not None:
        _details['errorPageUrl'] = error_page_url

    if is_saml_service_provider is not None:
        _details['isSamlServiceProvider'] = is_saml_service_provider

    if is_web_tier_policy is not None:
        _details['isWebTierPolicy'] = is_web_tier_policy

    if is_kerberos_realm is not None:
        _details['isKerberosRealm'] = is_kerberos_realm

    if icon is not None:
        _details['icon'] = icon

    if is_alias_app is not None:
        _details['isAliasApp'] = is_alias_app

    if is_managed_app is not None:
        _details['isManagedApp'] = is_managed_app

    if service_type_urn is not None:
        _details['serviceTypeURN'] = service_type_urn

    if service_type_version is not None:
        _details['serviceTypeVersion'] = service_type_version

    if is_obligation_capable is not None:
        _details['isObligationCapable'] = is_obligation_capable

    if ready_to_upgrade is not None:
        _details['readyToUpgrade'] = ready_to_upgrade

    if trust_scope is not None:
        _details['trustScope'] = trust_scope

    if is_database_service is not None:
        _details['isDatabaseService'] = is_database_service

    if secondary_audiences is not None:
        _details['secondaryAudiences'] = cli_util.parse_json_parameter("secondary_audiences", secondary_audiences)

    if is_enterprise_app is not None:
        _details['isEnterpriseApp'] = is_enterprise_app

    if bypass_consent is not None:
        _details['bypassConsent'] = bypass_consent

    if disable_kmsi_token_authentication is not None:
        _details['disableKmsiTokenAuthentication'] = disable_kmsi_token_authentication

    if is_multicloud_service_app is not None:
        _details['isMulticloudServiceApp'] = is_multicloud_service_app

    if radius_policy is not None:
        _details['radiusPolicy'] = cli_util.parse_json_parameter("radius_policy", radius_policy)

    if apps_network_perimeters is not None:
        _details['appsNetworkPerimeters'] = cli_util.parse_json_parameter("apps_network_perimeters", apps_network_perimeters)

    if cloud_control_properties is not None:
        _details['cloudControlProperties'] = cli_util.parse_json_parameter("cloud_control_properties", cloud_control_properties)

    if editable_attributes is not None:
        _details['editableAttributes'] = cli_util.parse_json_parameter("editable_attributes", editable_attributes)

    if terms_of_use is not None:
        _details['termsOfUse'] = cli_util.parse_json_parameter("terms_of_use", terms_of_use)

    if protectable_secondary_audiences is not None:
        _details['protectableSecondaryAudiences'] = cli_util.parse_json_parameter("protectable_secondary_audiences", protectable_secondary_audiences)

    if idp_policy is not None:
        _details['idpPolicy'] = cli_util.parse_json_parameter("idp_policy", idp_policy)

    if allowed_tags is not None:
        _details['allowedTags'] = cli_util.parse_json_parameter("allowed_tags", allowed_tags)

    if app_signon_policy is not None:
        _details['appSignonPolicy'] = cli_util.parse_json_parameter("app_signon_policy", app_signon_policy)

    if trust_policies is not None:
        _details['trustPolicies'] = cli_util.parse_json_parameter("trust_policies", trust_policies)

    if signon_policy is not None:
        _details['signonPolicy'] = cli_util.parse_json_parameter("signon_policy", signon_policy)

    if identity_providers is not None:
        _details['identityProviders'] = cli_util.parse_json_parameter("identity_providers", identity_providers)

    if accounts is not None:
        _details['accounts'] = cli_util.parse_json_parameter("accounts", accounts)

    if grants is not None:
        _details['grants'] = cli_util.parse_json_parameter("grants", grants)

    if service_params is not None:
        _details['serviceParams'] = cli_util.parse_json_parameter("service_params", service_params)

    if attr_rendering_metadata is not None:
        _details['attrRenderingMetadata'] = cli_util.parse_json_parameter("attr_rendering_metadata", attr_rendering_metadata)

    if granted_app_roles is not None:
        _details['grantedAppRoles'] = cli_util.parse_json_parameter("granted_app_roles", granted_app_roles)

    if saml_service_provider is not None:
        _details['samlServiceProvider'] = cli_util.parse_json_parameter("saml_service_provider", saml_service_provider)

    if allowed_scopes is not None:
        _details['allowedScopes'] = cli_util.parse_json_parameter("allowed_scopes", allowed_scopes)

    if certificates is not None:
        _details['certificates'] = cli_util.parse_json_parameter("certificates", certificates)

    if alias_apps is not None:
        _details['aliasApps'] = cli_util.parse_json_parameter("alias_apps", alias_apps)

    if as_opc_service is not None:
        _details['asOPCService'] = cli_util.parse_json_parameter("as_opc_service", as_opc_service)

    if admin_roles is not None:
        _details['adminRoles'] = cli_util.parse_json_parameter("admin_roles", admin_roles)

    if user_roles is not None:
        _details['userRoles'] = cli_util.parse_json_parameter("user_roles", user_roles)

    if scopes is not None:
        _details['scopes'] = cli_util.parse_json_parameter("scopes", scopes)

    if urnietfparamsscimschemasoracleidcsextensionradius_app_app is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:radiusApp:App'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionradius_app_app", urnietfparamsscimschemasoracleidcsextensionradius_app_app)

    if urnietfparamsscimschemasoracleidcsextensionsaml_service_provider_app is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:samlServiceProvider:App'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionsaml_service_provider_app", urnietfparamsscimschemasoracleidcsextensionsaml_service_provider_app)

    if urnietfparamsscimschemasoracleidcsextensionweb_tier_policy_app is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:webTierPolicy:App'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionweb_tier_policy_app", urnietfparamsscimschemasoracleidcsextensionweb_tier_policy_app)

    if urnietfparamsscimschemasoracleidcsextensionmanagedapp_app is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:managedapp:App'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionmanagedapp_app", urnietfparamsscimschemasoracleidcsextensionmanagedapp_app)

    if urnietfparamsscimschemasoracleidcsextensionform_fill_app_template_app_template is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:formFillAppTemplate:AppTemplate'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionform_fill_app_template_app_template", urnietfparamsscimschemasoracleidcsextensionform_fill_app_template_app_template)

    if urnietfparamsscimschemasoracleidcsextensionopc_service_app is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:opcService:App'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionopc_service_app", urnietfparamsscimschemasoracleidcsextensionopc_service_app)

    if urnietfparamsscimschemasoracleidcsextensionkerberos_realm_app is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:kerberosRealm:App'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionkerberos_realm_app", urnietfparamsscimschemasoracleidcsextensionkerberos_realm_app)

    if urnietfparamsscimschemasoracleidcsextensionrequestable_app is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:requestable:App'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionrequestable_app", urnietfparamsscimschemasoracleidcsextensionrequestable_app)

    if urnietfparamsscimschemasoracleidcsextensionform_fill_app_app is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:formFillApp:App'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionform_fill_app_app", urnietfparamsscimschemasoracleidcsextensionform_fill_app_app)

    if urnietfparamsscimschemasoracleidcsextensiondbcs_app is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:dbcs:App'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensiondbcs_app", urnietfparamsscimschemasoracleidcsextensiondbcs_app)

    if urnietfparamsscimschemasoracleidcsextensionenterprise_app_app is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:enterpriseApp:App'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionenterprise_app_app", urnietfparamsscimschemasoracleidcsextensionenterprise_app_app)

    if urnietfparamsscimschemasoracleidcsextension_oci_tags is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:OCITags'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextension_oci_tags", urnietfparamsscimschemasoracleidcsextension_oci_tags)

    if urnietfparamsscimschemasoracleidcsextensionmulticloud_service_app_app is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:multicloudServiceApp:App'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionmulticloud_service_app_app", urnietfparamsscimschemasoracleidcsextensionmulticloud_service_app_app)

    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.create_app(
        app=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@app_role_group.command(name=cli_util.override('identity_domains.create_app_role.command_name', 'create'), help=u"""Create an AppRole

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](createAppRole)""")
@cli_util.option('--schemas', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--display-name', required=True, help=u"""AppRole name

**SCIM++ Properties:**  - caseExact: false  - idcsCsvAttributeName: Display Name  - idcsCsvAttributeNameMappings: [[columnHeaderName:Entitlement Value]]  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: true  - returned: always  - type: string  - uniqueness: none""")
@cli_util.option('--app', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--attributes', help=u"""A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.""")
@cli_util.option('--attribute-sets', type=custom_types.CliCaseInsensitiveChoice(["all", "always", "never", "request", "default"]), multiple=True, help=u"""A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.""")
@cli_util.option('--id', help=u"""Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--ocid', help=u"""Unique OCI identifier for the SCIM Resource.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: string  - uniqueness: global""")
@cli_util.option('--meta', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-created-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-last-modified-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-prevented-operations', type=custom_types.CliCaseInsensitiveChoice(["replace", "update", "delete"]), help=u"""Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of tags on this resource.

**SCIM++ Properties:**  - idcsCompositeKey: [key, value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type Tags.  For documentation on tags please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/Tags.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--delete-in-progress', type=click.BOOL, help=u"""A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--idcs-last-upgraded-in-release', help=u"""The release number when the resource was upgraded.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--domain-ocid', help=u"""OCI Domain Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--compartment-ocid', help=u"""OCI Compartment Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--tenancy-ocid', help=u"""OCI Tenant Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--unique-name', help=u"""AppRole unique name

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: string  - uniqueness: server""")
@cli_util.option('--description', help=u"""AppRole description

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--legacy-group-name', help=u"""The name of the legacy group associated with this AppRole.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: string  - uniqueness: server""")
@cli_util.option('--admin-role', type=click.BOOL, help=u"""If true, the role provides administrative access privileges.

**SCIM++ Properties:**  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--limited-to-one-or-more-groups', type=click.BOOL, help=u"""If true, indicates that this Oracle Identity Cloud Service AppRole can be granted to a delegated administrator whose scope is limited to users that are members of one or more groups.

**Added In:** 19.2.1

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--available-to-users', type=click.BOOL, help=u"""If true, this AppRole can be granted to Users.

**SCIM++ Properties:**  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--available-to-groups', type=click.BOOL, help=u"""If true, this AppRole can be granted to Groups.

**SCIM++ Properties:**  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--available-to-clients', type=click.BOOL, help=u"""If true, this AppRole can be granted to Apps.

**SCIM++ Properties:**  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--public', type=click.BOOL, help=u"""If true, this AppRole is available automatically to every Oracle Identity Cloud Service User in this tenancy. There is no need to grant it to individual Users or Groups.

**SCIM++ Properties:**  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--localized-display-name', help=u"""AppRole localization name

**Added In:** 2109090424

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--members', type=custom_types.CLI_COMPLEX_TYPE, help=u"""AppRole members - when requesting members attribute, it is recommended to use startIndex and count to return members in pages instead of in a single response, eg : #attributes=members[startIndex=1%26count=10]

**SCIM++ Properties:**  - idcsCompositeKey: [value, type]  - idcsCsvAttributeNameMappings: [[columnHeaderName:Grantee Name, mapsTo:members.value], [columnHeaderName:Grantee Type, mapsTo:members.type]]  - idcsSearchable: true  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - idcsPaginateResponse: true  - type: complex  - uniqueness: none

This option is a JSON list with items of type AppRoleMembers.  For documentation on AppRoleMembers please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/AppRoleMembers.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'app': {'module': 'identity_domains', 'class': 'AppRoleApp'}, 'members': {'module': 'identity_domains', 'class': 'list[AppRoleMembers]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'app': {'module': 'identity_domains', 'class': 'AppRoleApp'}, 'members': {'module': 'identity_domains', 'class': 'list[AppRoleMembers]'}}, output_type={'module': 'identity_domains', 'class': 'AppRole'})
@cli_util.wrap_exceptions
def create_app_role(ctx, from_json, schemas, display_name, app, authorization, resource_type_schema_version, attributes, attribute_sets, id, ocid, meta, idcs_created_by, idcs_last_modified_by, idcs_prevented_operations, tags, delete_in_progress, idcs_last_upgraded_in_release, domain_ocid, compartment_ocid, tenancy_ocid, unique_name, description, legacy_group_name, admin_role, limited_to_one_or_more_groups, available_to_users, available_to_groups, available_to_clients, public, localized_display_name, members):

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if attributes is not None:
        kwargs['attributes'] = attributes
    if attribute_sets is not None and len(attribute_sets) > 0:
        kwargs['attribute_sets'] = attribute_sets

    _details = {}
    _details['schemas'] = cli_util.parse_json_parameter("schemas", schemas)
    _details['displayName'] = display_name
    _details['app'] = cli_util.parse_json_parameter("app", app)

    if id is not None:
        _details['id'] = id

    if ocid is not None:
        _details['ocid'] = ocid

    if meta is not None:
        _details['meta'] = cli_util.parse_json_parameter("meta", meta)

    if idcs_created_by is not None:
        _details['idcsCreatedBy'] = cli_util.parse_json_parameter("idcs_created_by", idcs_created_by)

    if idcs_last_modified_by is not None:
        _details['idcsLastModifiedBy'] = cli_util.parse_json_parameter("idcs_last_modified_by", idcs_last_modified_by)

    if idcs_prevented_operations is not None:
        _details['idcsPreventedOperations'] = cli_util.parse_json_parameter("idcs_prevented_operations", idcs_prevented_operations)

    if tags is not None:
        _details['tags'] = cli_util.parse_json_parameter("tags", tags)

    if delete_in_progress is not None:
        _details['deleteInProgress'] = delete_in_progress

    if idcs_last_upgraded_in_release is not None:
        _details['idcsLastUpgradedInRelease'] = idcs_last_upgraded_in_release

    if domain_ocid is not None:
        _details['domainOcid'] = domain_ocid

    if compartment_ocid is not None:
        _details['compartmentOcid'] = compartment_ocid

    if tenancy_ocid is not None:
        _details['tenancyOcid'] = tenancy_ocid

    if unique_name is not None:
        _details['uniqueName'] = unique_name

    if description is not None:
        _details['description'] = description

    if legacy_group_name is not None:
        _details['legacyGroupName'] = legacy_group_name

    if admin_role is not None:
        _details['adminRole'] = admin_role

    if limited_to_one_or_more_groups is not None:
        _details['limitedToOneOrMoreGroups'] = limited_to_one_or_more_groups

    if available_to_users is not None:
        _details['availableToUsers'] = available_to_users

    if available_to_groups is not None:
        _details['availableToGroups'] = available_to_groups

    if available_to_clients is not None:
        _details['availableToClients'] = available_to_clients

    if public is not None:
        _details['public'] = public

    if localized_display_name is not None:
        _details['localizedDisplayName'] = localized_display_name

    if members is not None:
        _details['members'] = cli_util.parse_json_parameter("members", members)

    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.create_app_role(
        app_role=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@approval_workflow_group.command(name=cli_util.override('identity_domains.create_approval_workflow.command_name', 'create'), help=u"""Create ApprovalWorkflow

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](createApprovalWorkflow)""")
@cli_util.option('--schemas', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--name', required=True, help=u"""Name of the ApprovalWorkflow.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: true  - returned: default  - type: string  - uniqueness: server""")
@cli_util.option('--max-duration', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--attributes', help=u"""A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.""")
@cli_util.option('--attribute-sets', type=custom_types.CliCaseInsensitiveChoice(["all", "always", "never", "request", "default"]), multiple=True, help=u"""A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.""")
@cli_util.option('--id', help=u"""Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--ocid', help=u"""Unique OCI identifier for the SCIM Resource.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: string  - uniqueness: global""")
@cli_util.option('--meta', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-created-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-last-modified-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-prevented-operations', type=custom_types.CliCaseInsensitiveChoice(["replace", "update", "delete"]), help=u"""Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of tags on this resource.

**SCIM++ Properties:**  - idcsCompositeKey: [key, value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type Tags.  For documentation on tags please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/Tags.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--delete-in-progress', type=click.BOOL, help=u"""A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--idcs-last-upgraded-in-release', help=u"""The release number when the resource was upgraded.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--domain-ocid', help=u"""OCI Domain Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--compartment-ocid', help=u"""OCI Compartment Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--tenancy-ocid', help=u"""OCI Tenant Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--description', help=u"""Description of the ApprovalWorkflow.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--approval-workflow-steps', type=custom_types.CLI_COMPLEX_TYPE, help=u"""ApprovalWorkflowSteps applicable for the ApprovalWorkflowInstance.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - idcsCompositeKey: [value, type]  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: complex  - uniqueness: none

This option is a JSON list with items of type ApprovalWorkflowApprovalWorkflowSteps.  For documentation on ApprovalWorkflowApprovalWorkflowSteps please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/ApprovalWorkflowApprovalWorkflowSteps.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'max-duration': {'module': 'identity_domains', 'class': 'ApprovalWorkflowMaxDuration'}, 'approval-workflow-steps': {'module': 'identity_domains', 'class': 'list[ApprovalWorkflowApprovalWorkflowSteps]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'max-duration': {'module': 'identity_domains', 'class': 'ApprovalWorkflowMaxDuration'}, 'approval-workflow-steps': {'module': 'identity_domains', 'class': 'list[ApprovalWorkflowApprovalWorkflowSteps]'}}, output_type={'module': 'identity_domains', 'class': 'ApprovalWorkflow'})
@cli_util.wrap_exceptions
def create_approval_workflow(ctx, from_json, schemas, name, max_duration, authorization, resource_type_schema_version, attributes, attribute_sets, id, ocid, meta, idcs_created_by, idcs_last_modified_by, idcs_prevented_operations, tags, delete_in_progress, idcs_last_upgraded_in_release, domain_ocid, compartment_ocid, tenancy_ocid, description, approval_workflow_steps):

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if attributes is not None:
        kwargs['attributes'] = attributes
    if attribute_sets is not None and len(attribute_sets) > 0:
        kwargs['attribute_sets'] = attribute_sets

    _details = {}
    _details['schemas'] = cli_util.parse_json_parameter("schemas", schemas)
    _details['name'] = name
    _details['maxDuration'] = cli_util.parse_json_parameter("max_duration", max_duration)

    if id is not None:
        _details['id'] = id

    if ocid is not None:
        _details['ocid'] = ocid

    if meta is not None:
        _details['meta'] = cli_util.parse_json_parameter("meta", meta)

    if idcs_created_by is not None:
        _details['idcsCreatedBy'] = cli_util.parse_json_parameter("idcs_created_by", idcs_created_by)

    if idcs_last_modified_by is not None:
        _details['idcsLastModifiedBy'] = cli_util.parse_json_parameter("idcs_last_modified_by", idcs_last_modified_by)

    if idcs_prevented_operations is not None:
        _details['idcsPreventedOperations'] = cli_util.parse_json_parameter("idcs_prevented_operations", idcs_prevented_operations)

    if tags is not None:
        _details['tags'] = cli_util.parse_json_parameter("tags", tags)

    if delete_in_progress is not None:
        _details['deleteInProgress'] = delete_in_progress

    if idcs_last_upgraded_in_release is not None:
        _details['idcsLastUpgradedInRelease'] = idcs_last_upgraded_in_release

    if domain_ocid is not None:
        _details['domainOcid'] = domain_ocid

    if compartment_ocid is not None:
        _details['compartmentOcid'] = compartment_ocid

    if tenancy_ocid is not None:
        _details['tenancyOcid'] = tenancy_ocid

    if description is not None:
        _details['description'] = description

    if approval_workflow_steps is not None:
        _details['approvalWorkflowSteps'] = cli_util.parse_json_parameter("approval_workflow_steps", approval_workflow_steps)

    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.create_approval_workflow(
        approval_workflow=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@approval_workflow_assignment_group.command(name=cli_util.override('identity_domains.create_approval_workflow_assignment.command_name', 'create'), help=u"""Create Approval Workflow Assignment

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](createApprovalWorkflowAssignment)""")
@cli_util.option('--schemas', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--assignment-type', required=True, type=custom_types.CliCaseInsensitiveChoice(["MEMBERSHIP", "ACTIVATION"]), help=u"""Type of approval workflow assignment to the resource. Resources like Group have only one workflow associated (default assignment type is membership), but resources like TemporalBusinessRole can have atleast 2 AWs attached, one for membership to TPR, another for activation of that TPR membership

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--approval-workflow', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--assigned-to', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--attributes', help=u"""A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.""")
@cli_util.option('--attribute-sets', type=custom_types.CliCaseInsensitiveChoice(["all", "always", "never", "request", "default"]), multiple=True, help=u"""A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.""")
@cli_util.option('--id', help=u"""Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--ocid', help=u"""Unique OCI identifier for the SCIM Resource.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: string  - uniqueness: global""")
@cli_util.option('--meta', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-created-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-last-modified-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-prevented-operations', type=custom_types.CliCaseInsensitiveChoice(["replace", "update", "delete"]), help=u"""Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of tags on this resource.

**SCIM++ Properties:**  - idcsCompositeKey: [key, value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type Tags.  For documentation on tags please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/Tags.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--delete-in-progress', type=click.BOOL, help=u"""A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--idcs-last-upgraded-in-release', help=u"""The release number when the resource was upgraded.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--domain-ocid', help=u"""OCI Domain Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--compartment-ocid', help=u"""OCI Compartment Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--tenancy-ocid', help=u"""OCI Tenant Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@json_skeleton_utils.get_cli_json_input_option({'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'approval-workflow': {'module': 'identity_domains', 'class': 'ApprovalWorkflowAssignmentApprovalWorkflow'}, 'assigned-to': {'module': 'identity_domains', 'class': 'ApprovalWorkflowAssignmentAssignedTo'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'approval-workflow': {'module': 'identity_domains', 'class': 'ApprovalWorkflowAssignmentApprovalWorkflow'}, 'assigned-to': {'module': 'identity_domains', 'class': 'ApprovalWorkflowAssignmentAssignedTo'}}, output_type={'module': 'identity_domains', 'class': 'ApprovalWorkflowAssignment'})
@cli_util.wrap_exceptions
def create_approval_workflow_assignment(ctx, from_json, schemas, assignment_type, approval_workflow, assigned_to, authorization, resource_type_schema_version, attributes, attribute_sets, id, ocid, meta, idcs_created_by, idcs_last_modified_by, idcs_prevented_operations, tags, delete_in_progress, idcs_last_upgraded_in_release, domain_ocid, compartment_ocid, tenancy_ocid):

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if attributes is not None:
        kwargs['attributes'] = attributes
    if attribute_sets is not None and len(attribute_sets) > 0:
        kwargs['attribute_sets'] = attribute_sets

    _details = {}
    _details['schemas'] = cli_util.parse_json_parameter("schemas", schemas)
    _details['assignmentType'] = assignment_type
    _details['approvalWorkflow'] = cli_util.parse_json_parameter("approval_workflow", approval_workflow)
    _details['assignedTo'] = cli_util.parse_json_parameter("assigned_to", assigned_to)

    if id is not None:
        _details['id'] = id

    if ocid is not None:
        _details['ocid'] = ocid

    if meta is not None:
        _details['meta'] = cli_util.parse_json_parameter("meta", meta)

    if idcs_created_by is not None:
        _details['idcsCreatedBy'] = cli_util.parse_json_parameter("idcs_created_by", idcs_created_by)

    if idcs_last_modified_by is not None:
        _details['idcsLastModifiedBy'] = cli_util.parse_json_parameter("idcs_last_modified_by", idcs_last_modified_by)

    if idcs_prevented_operations is not None:
        _details['idcsPreventedOperations'] = cli_util.parse_json_parameter("idcs_prevented_operations", idcs_prevented_operations)

    if tags is not None:
        _details['tags'] = cli_util.parse_json_parameter("tags", tags)

    if delete_in_progress is not None:
        _details['deleteInProgress'] = delete_in_progress

    if idcs_last_upgraded_in_release is not None:
        _details['idcsLastUpgradedInRelease'] = idcs_last_upgraded_in_release

    if domain_ocid is not None:
        _details['domainOcid'] = domain_ocid

    if compartment_ocid is not None:
        _details['compartmentOcid'] = compartment_ocid

    if tenancy_ocid is not None:
        _details['tenancyOcid'] = tenancy_ocid

    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.create_approval_workflow_assignment(
        approval_workflow_assignment=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@approval_workflow_step_group.command(name=cli_util.override('identity_domains.create_approval_workflow_step.command_name', 'create'), help=u"""Create ApprovalWorkflowStep

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](createApprovalWorkflowStep)""")
@cli_util.option('--schemas', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--order', required=True, type=click.INT, help=u"""Order of the ApprovalWorkflowStep.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - idcsMaxValue: 2147483647  - required: true  - returned: default  - type: integer  - uniqueness: none""")
@cli_util.option('--type', required=True, type=custom_types.CliCaseInsensitiveChoice(["escalation", "regular"]), help=u"""Type of ApprovalWorkflowStep

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--attributes', help=u"""A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.""")
@cli_util.option('--attribute-sets', type=custom_types.CliCaseInsensitiveChoice(["all", "always", "never", "request", "default"]), multiple=True, help=u"""A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.""")
@cli_util.option('--id', help=u"""Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--ocid', help=u"""Unique OCI identifier for the SCIM Resource.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: string  - uniqueness: global""")
@cli_util.option('--meta', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-created-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-last-modified-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-prevented-operations', type=custom_types.CliCaseInsensitiveChoice(["replace", "update", "delete"]), help=u"""Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of tags on this resource.

**SCIM++ Properties:**  - idcsCompositeKey: [key, value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type Tags.  For documentation on tags please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/Tags.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--delete-in-progress', type=click.BOOL, help=u"""A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--idcs-last-upgraded-in-release', help=u"""The release number when the resource was upgraded.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--domain-ocid', help=u"""OCI Domain Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--compartment-ocid', help=u"""OCI Compartment Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--tenancy-ocid', help=u"""OCI Tenant Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--minimum-approvals', type=click.INT, help=u"""Minimum number of Approvals required for this step.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - idcsMinValue: 1  - idcsMaxValue: 2147483647  - required: false  - returned: default  - type: integer  - uniqueness: none""")
@cli_util.option('--approvers-expressions', type=custom_types.CLI_COMPLEX_TYPE, help=u"""approversExpressions of ApprovalWorkflowStep

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--approvers', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Approvers of the ApprovalWorkflowStep.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - idcsCompositeKey: [value, type]  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: complex  - uniqueness: none

This option is a JSON list with items of type ApprovalWorkflowStepApprovers.  For documentation on ApprovalWorkflowStepApprovers please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/ApprovalWorkflowStepApprovers.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'approvers-expressions': {'module': 'identity_domains', 'class': 'list[string]'}, 'approvers': {'module': 'identity_domains', 'class': 'list[ApprovalWorkflowStepApprovers]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'approvers-expressions': {'module': 'identity_domains', 'class': 'list[string]'}, 'approvers': {'module': 'identity_domains', 'class': 'list[ApprovalWorkflowStepApprovers]'}}, output_type={'module': 'identity_domains', 'class': 'ApprovalWorkflowStep'})
@cli_util.wrap_exceptions
def create_approval_workflow_step(ctx, from_json, schemas, order, type, authorization, resource_type_schema_version, attributes, attribute_sets, id, ocid, meta, idcs_created_by, idcs_last_modified_by, idcs_prevented_operations, tags, delete_in_progress, idcs_last_upgraded_in_release, domain_ocid, compartment_ocid, tenancy_ocid, minimum_approvals, approvers_expressions, approvers):

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if attributes is not None:
        kwargs['attributes'] = attributes
    if attribute_sets is not None and len(attribute_sets) > 0:
        kwargs['attribute_sets'] = attribute_sets

    _details = {}
    _details['schemas'] = cli_util.parse_json_parameter("schemas", schemas)
    _details['order'] = order
    _details['type'] = type

    if id is not None:
        _details['id'] = id

    if ocid is not None:
        _details['ocid'] = ocid

    if meta is not None:
        _details['meta'] = cli_util.parse_json_parameter("meta", meta)

    if idcs_created_by is not None:
        _details['idcsCreatedBy'] = cli_util.parse_json_parameter("idcs_created_by", idcs_created_by)

    if idcs_last_modified_by is not None:
        _details['idcsLastModifiedBy'] = cli_util.parse_json_parameter("idcs_last_modified_by", idcs_last_modified_by)

    if idcs_prevented_operations is not None:
        _details['idcsPreventedOperations'] = cli_util.parse_json_parameter("idcs_prevented_operations", idcs_prevented_operations)

    if tags is not None:
        _details['tags'] = cli_util.parse_json_parameter("tags", tags)

    if delete_in_progress is not None:
        _details['deleteInProgress'] = delete_in_progress

    if idcs_last_upgraded_in_release is not None:
        _details['idcsLastUpgradedInRelease'] = idcs_last_upgraded_in_release

    if domain_ocid is not None:
        _details['domainOcid'] = domain_ocid

    if compartment_ocid is not None:
        _details['compartmentOcid'] = compartment_ocid

    if tenancy_ocid is not None:
        _details['tenancyOcid'] = tenancy_ocid

    if minimum_approvals is not None:
        _details['minimumApprovals'] = minimum_approvals

    if approvers_expressions is not None:
        _details['approversExpressions'] = cli_util.parse_json_parameter("approvers_expressions", approvers_expressions)

    if approvers is not None:
        _details['approvers'] = cli_util.parse_json_parameter("approvers", approvers)

    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.create_approval_workflow_step(
        approval_workflow_step=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@auth_token_group.command(name=cli_util.override('identity_domains.create_auth_token.command_name', 'create'), help=u"""Create a user's Auth token.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](createAuthToken)""")
@cli_util.option('--schemas', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--attributes', help=u"""A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.""")
@cli_util.option('--attribute-sets', type=custom_types.CliCaseInsensitiveChoice(["all", "always", "never", "request", "default"]), multiple=True, help=u"""A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.""")
@cli_util.option('--id', help=u"""Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--ocid', help=u"""Unique OCI identifier for the SCIM Resource.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: string  - uniqueness: global""")
@cli_util.option('--meta', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-created-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-last-modified-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-prevented-operations', type=custom_types.CliCaseInsensitiveChoice(["replace", "update", "delete"]), help=u"""Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of tags on this resource.

**SCIM++ Properties:**  - idcsCompositeKey: [key, value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type Tags.  For documentation on tags please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/Tags.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--delete-in-progress', type=click.BOOL, help=u"""A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--idcs-last-upgraded-in-release', help=u"""The release number when the resource was upgraded.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--domain-ocid', help=u"""OCI Domain Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--compartment-ocid', help=u"""OCI Compartment Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--tenancy-ocid', help=u"""OCI Tenant Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--description', help=u"""Description

**Added In:** 2010242156

**SCIM++ Properties:**  - caseExact: false  - type: string  - mutability: readWrite  - required: false  - returned: default""")
@cli_util.option('--token', help=u"""token

**Added In:** 2010242156

**SCIM++ Properties:**  - caseExact: true  - type: string  - mutability: readOnly  - required: false  - returned: default  - idcsSensitive: hash_sc""")
@cli_util.option('--status', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "INACTIVE"]), help=u"""The user's credential status.

**Added In:** 2109090424

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: never  - type: string  - uniqueness: none""")
@cli_util.option('--expires-on', help=u"""When the user's credential expire.

**Added In:** 2109090424

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: dateTime  - uniqueness: none""")
@cli_util.option('--user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionself-change-user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'user': {'module': 'identity_domains', 'class': 'AuthTokenUser'}, 'urnietfparamsscimschemasoracleidcsextensionself-change-user': {'module': 'identity_domains', 'class': 'ExtensionSelfChangeUser'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'user': {'module': 'identity_domains', 'class': 'AuthTokenUser'}, 'urnietfparamsscimschemasoracleidcsextensionself-change-user': {'module': 'identity_domains', 'class': 'ExtensionSelfChangeUser'}}, output_type={'module': 'identity_domains', 'class': 'AuthToken'})
@cli_util.wrap_exceptions
def create_auth_token(ctx, from_json, schemas, authorization, resource_type_schema_version, attributes, attribute_sets, id, ocid, meta, idcs_created_by, idcs_last_modified_by, idcs_prevented_operations, tags, delete_in_progress, idcs_last_upgraded_in_release, domain_ocid, compartment_ocid, tenancy_ocid, description, token, status, expires_on, user, urnietfparamsscimschemasoracleidcsextensionself_change_user):

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if attributes is not None:
        kwargs['attributes'] = attributes
    if attribute_sets is not None and len(attribute_sets) > 0:
        kwargs['attribute_sets'] = attribute_sets

    _details = {}
    _details['schemas'] = cli_util.parse_json_parameter("schemas", schemas)

    if id is not None:
        _details['id'] = id

    if ocid is not None:
        _details['ocid'] = ocid

    if meta is not None:
        _details['meta'] = cli_util.parse_json_parameter("meta", meta)

    if idcs_created_by is not None:
        _details['idcsCreatedBy'] = cli_util.parse_json_parameter("idcs_created_by", idcs_created_by)

    if idcs_last_modified_by is not None:
        _details['idcsLastModifiedBy'] = cli_util.parse_json_parameter("idcs_last_modified_by", idcs_last_modified_by)

    if idcs_prevented_operations is not None:
        _details['idcsPreventedOperations'] = cli_util.parse_json_parameter("idcs_prevented_operations", idcs_prevented_operations)

    if tags is not None:
        _details['tags'] = cli_util.parse_json_parameter("tags", tags)

    if delete_in_progress is not None:
        _details['deleteInProgress'] = delete_in_progress

    if idcs_last_upgraded_in_release is not None:
        _details['idcsLastUpgradedInRelease'] = idcs_last_upgraded_in_release

    if domain_ocid is not None:
        _details['domainOcid'] = domain_ocid

    if compartment_ocid is not None:
        _details['compartmentOcid'] = compartment_ocid

    if tenancy_ocid is not None:
        _details['tenancyOcid'] = tenancy_ocid

    if description is not None:
        _details['description'] = description

    if token is not None:
        _details['token'] = token

    if status is not None:
        _details['status'] = status

    if expires_on is not None:
        _details['expiresOn'] = expires_on

    if user is not None:
        _details['user'] = cli_util.parse_json_parameter("user", user)

    if urnietfparamsscimschemasoracleidcsextensionself_change_user is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:selfChange:User'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionself_change_user", urnietfparamsscimschemasoracleidcsextensionself_change_user)

    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.create_auth_token(
        auth_token=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@authentication_factors_remover_group.command(name=cli_util.override('identity_domains.create_authentication_factors_remover.command_name', 'create'), help=u"""Remove All Authentication Factor Channels for a User

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](createAuthenticationFactorsRemover)""")
@cli_util.option('--schemas', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--user', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--id', help=u"""Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--ocid', help=u"""Unique OCI identifier for the SCIM Resource.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: string  - uniqueness: global""")
@cli_util.option('--meta', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-created-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-last-modified-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-prevented-operations', type=custom_types.CliCaseInsensitiveChoice(["replace", "update", "delete"]), help=u"""Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of tags on this resource.

**SCIM++ Properties:**  - idcsCompositeKey: [key, value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type Tags.  For documentation on tags please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/Tags.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--delete-in-progress', type=click.BOOL, help=u"""A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--idcs-last-upgraded-in-release', help=u"""The release number when the resource was upgraded.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--domain-ocid', help=u"""OCI Domain Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--compartment-ocid', help=u"""OCI Compartment Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--tenancy-ocid', help=u"""OCI Tenant Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--type', type=custom_types.CliCaseInsensitiveChoice(["KMSI", "MFA", "ACCOUNTRECOVERY", "ALL"]), help=u"""Specifies the type of factors to remove. Either MFA factors or AccountRecovery factors or All factors

**SCIM++ Properties:**  - type: string  - multiValued: false  - required: false  - mutability: readWrite  - returned: default  - uniqueness: none  - idcsSearchable: false""")
@cli_util.option('--token', help=u"""Specifies the token to be removed

**SCIM++ Properties:**  - type: string  - multiValued: false  - required: false  - mutability: readWrite  - returned: request  - uniqueness: none  - idcsSearchable: false""")
@json_skeleton_utils.get_cli_json_input_option({'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'user': {'module': 'identity_domains', 'class': 'AuthenticationFactorsRemoverUser'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'user': {'module': 'identity_domains', 'class': 'AuthenticationFactorsRemoverUser'}}, output_type={'module': 'identity_domains', 'class': 'AuthenticationFactorsRemover'})
@cli_util.wrap_exceptions
def create_authentication_factors_remover(ctx, from_json, schemas, user, authorization, resource_type_schema_version, id, ocid, meta, idcs_created_by, idcs_last_modified_by, idcs_prevented_operations, tags, delete_in_progress, idcs_last_upgraded_in_release, domain_ocid, compartment_ocid, tenancy_ocid, type, token):

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version

    _details = {}
    _details['schemas'] = cli_util.parse_json_parameter("schemas", schemas)
    _details['user'] = cli_util.parse_json_parameter("user", user)

    if id is not None:
        _details['id'] = id

    if ocid is not None:
        _details['ocid'] = ocid

    if meta is not None:
        _details['meta'] = cli_util.parse_json_parameter("meta", meta)

    if idcs_created_by is not None:
        _details['idcsCreatedBy'] = cli_util.parse_json_parameter("idcs_created_by", idcs_created_by)

    if idcs_last_modified_by is not None:
        _details['idcsLastModifiedBy'] = cli_util.parse_json_parameter("idcs_last_modified_by", idcs_last_modified_by)

    if idcs_prevented_operations is not None:
        _details['idcsPreventedOperations'] = cli_util.parse_json_parameter("idcs_prevented_operations", idcs_prevented_operations)

    if tags is not None:
        _details['tags'] = cli_util.parse_json_parameter("tags", tags)

    if delete_in_progress is not None:
        _details['deleteInProgress'] = delete_in_progress

    if idcs_last_upgraded_in_release is not None:
        _details['idcsLastUpgradedInRelease'] = idcs_last_upgraded_in_release

    if domain_ocid is not None:
        _details['domainOcid'] = domain_ocid

    if compartment_ocid is not None:
        _details['compartmentOcid'] = compartment_ocid

    if tenancy_ocid is not None:
        _details['tenancyOcid'] = tenancy_ocid

    if type is not None:
        _details['type'] = type

    if token is not None:
        _details['token'] = token

    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.create_authentication_factors_remover(
        authentication_factors_remover=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@cloud_gate_group.command(name=cli_util.override('identity_domains.create_cloud_gate.command_name', 'create'), help=u"""Create a Cloud Gate

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](createCloudGate)""")
@cli_util.option('--schemas', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--display-name', required=True, help=u"""Display name/Host identifier for this Cloud Gate

**Added In:** 19.2.1

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: true  - returned: always  - type: string  - uniqueness: server""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--attributes', help=u"""A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.""")
@cli_util.option('--attribute-sets', type=custom_types.CliCaseInsensitiveChoice(["all", "always", "never", "request", "default"]), multiple=True, help=u"""A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.""")
@cli_util.option('--id', help=u"""Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--ocid', help=u"""Unique OCI identifier for the SCIM Resource.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: string  - uniqueness: global""")
@cli_util.option('--meta', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-created-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-last-modified-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-prevented-operations', type=custom_types.CliCaseInsensitiveChoice(["replace", "update", "delete"]), help=u"""Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of tags on this resource.

**SCIM++ Properties:**  - idcsCompositeKey: [key, value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type Tags.  For documentation on tags please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/Tags.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--delete-in-progress', type=click.BOOL, help=u"""A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--idcs-last-upgraded-in-release', help=u"""The release number when the resource was upgraded.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--domain-ocid', help=u"""OCI Domain Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--compartment-ocid', help=u"""OCI Compartment Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--tenancy-ocid', help=u"""OCI Tenant Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--is-opc-service', type=click.BOOL, help=u"""Indicates whether this resource was created by OPC

**Added In:** 19.3.3

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: boolean  - uniqueness: none""")
@cli_util.option('--last-modified-time', help=u"""Last updated timestamp for this CloudGate's servers and mappings.

**Added In:** 19.2.1

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: dateTime  - uniqueness: none""")
@cli_util.option('--description', help=u"""Brief description for this Cloud Gate

**Added In:** 19.2.1

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--active', type=click.BOOL, help=u"""Activation status for this Cloud Gate

**Added In:** 19.2.1

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--type', type=custom_types.CliCaseInsensitiveChoice(["lbaas", "gateway"]), help=u"""Type of Cloud Gate

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--upstream-server-groups', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of upstream server groups

**Added In:** 20.1.3

**SCIM++ Properties:**  - caseExact: false  - idcsCompositeKey: [value]  - idcsSearchable: true  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type CloudGateExtUpstreamServerGroups.  For documentation on CloudGateExtUpstreamServerGroups please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/CloudGateExtUpstreamServerGroups.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--upstream-servers', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of upstream servers

**Added In:** 20.1.3

**SCIM++ Properties:**  - caseExact: false  - idcsCompositeKey: [value]  - idcsSearchable: true  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type CloudGateExtUpstreamServers.  For documentation on CloudGateExtUpstreamServers please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/CloudGateExtUpstreamServers.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--oauth-client', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--servers', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of Server Blocks on this Cloud Gate

**SCIM++ Properties:**  - caseExact: true  - idcsCompositeKey: [hostName]  - idcsSearchable: true  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type CloudGateExtServers.  For documentation on CloudGateExtServers please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/CloudGateExtServers.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--mappings', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of Cloud Gate Mappings that map Apps to this Cloud Gate

**SCIM++ Properties:**  - caseExact: true  - idcsCompositeKey: [serverId, resourcePrefix]  - idcsSearchable: true  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type CloudGateExtMappings.  For documentation on CloudGateExtMappings please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/CloudGateExtMappings.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'upstream-server-groups': {'module': 'identity_domains', 'class': 'list[CloudGateExtUpstreamServerGroups]'}, 'upstream-servers': {'module': 'identity_domains', 'class': 'list[CloudGateExtUpstreamServers]'}, 'oauth-client': {'module': 'identity_domains', 'class': 'CloudGateOauthClient'}, 'servers': {'module': 'identity_domains', 'class': 'list[CloudGateExtServers]'}, 'mappings': {'module': 'identity_domains', 'class': 'list[CloudGateExtMappings]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'upstream-server-groups': {'module': 'identity_domains', 'class': 'list[CloudGateExtUpstreamServerGroups]'}, 'upstream-servers': {'module': 'identity_domains', 'class': 'list[CloudGateExtUpstreamServers]'}, 'oauth-client': {'module': 'identity_domains', 'class': 'CloudGateOauthClient'}, 'servers': {'module': 'identity_domains', 'class': 'list[CloudGateExtServers]'}, 'mappings': {'module': 'identity_domains', 'class': 'list[CloudGateExtMappings]'}}, output_type={'module': 'identity_domains', 'class': 'CloudGate'})
@cli_util.wrap_exceptions
def create_cloud_gate(ctx, from_json, schemas, display_name, authorization, resource_type_schema_version, attributes, attribute_sets, id, ocid, meta, idcs_created_by, idcs_last_modified_by, idcs_prevented_operations, tags, delete_in_progress, idcs_last_upgraded_in_release, domain_ocid, compartment_ocid, tenancy_ocid, is_opc_service, last_modified_time, description, active, type, upstream_server_groups, upstream_servers, oauth_client, servers, mappings):

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if attributes is not None:
        kwargs['attributes'] = attributes
    if attribute_sets is not None and len(attribute_sets) > 0:
        kwargs['attribute_sets'] = attribute_sets

    _details = {}
    _details['schemas'] = cli_util.parse_json_parameter("schemas", schemas)
    _details['displayName'] = display_name

    if id is not None:
        _details['id'] = id

    if ocid is not None:
        _details['ocid'] = ocid

    if meta is not None:
        _details['meta'] = cli_util.parse_json_parameter("meta", meta)

    if idcs_created_by is not None:
        _details['idcsCreatedBy'] = cli_util.parse_json_parameter("idcs_created_by", idcs_created_by)

    if idcs_last_modified_by is not None:
        _details['idcsLastModifiedBy'] = cli_util.parse_json_parameter("idcs_last_modified_by", idcs_last_modified_by)

    if idcs_prevented_operations is not None:
        _details['idcsPreventedOperations'] = cli_util.parse_json_parameter("idcs_prevented_operations", idcs_prevented_operations)

    if tags is not None:
        _details['tags'] = cli_util.parse_json_parameter("tags", tags)

    if delete_in_progress is not None:
        _details['deleteInProgress'] = delete_in_progress

    if idcs_last_upgraded_in_release is not None:
        _details['idcsLastUpgradedInRelease'] = idcs_last_upgraded_in_release

    if domain_ocid is not None:
        _details['domainOcid'] = domain_ocid

    if compartment_ocid is not None:
        _details['compartmentOcid'] = compartment_ocid

    if tenancy_ocid is not None:
        _details['tenancyOcid'] = tenancy_ocid

    if is_opc_service is not None:
        _details['isOPCService'] = is_opc_service

    if last_modified_time is not None:
        _details['lastModifiedTime'] = last_modified_time

    if description is not None:
        _details['description'] = description

    if active is not None:
        _details['active'] = active

    if type is not None:
        _details['type'] = type

    if upstream_server_groups is not None:
        _details['upstreamServerGroups'] = cli_util.parse_json_parameter("upstream_server_groups", upstream_server_groups)

    if upstream_servers is not None:
        _details['upstreamServers'] = cli_util.parse_json_parameter("upstream_servers", upstream_servers)

    if oauth_client is not None:
        _details['oauthClient'] = cli_util.parse_json_parameter("oauth_client", oauth_client)

    if servers is not None:
        _details['servers'] = cli_util.parse_json_parameter("servers", servers)

    if mappings is not None:
        _details['mappings'] = cli_util.parse_json_parameter("mappings", mappings)

    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.create_cloud_gate(
        cloud_gate=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@cloud_gate_mapping_group.command(name=cli_util.override('identity_domains.create_cloud_gate_mapping.command_name', 'create'), help=u"""Create a Cloud Gate mapping

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](createCloudGateMapping)""")
@cli_util.option('--schemas', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--resource-prefix', required=True, help=u"""Resource prefix for this mapping.  This will be used to define the location block

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--policy-name', required=True, help=u"""The Web Tier policy name used for the App that is mapped to the owning Cloud Gate

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--server', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--gateway-app', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--cloud-gate', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--attributes', help=u"""A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.""")
@cli_util.option('--attribute-sets', type=custom_types.CliCaseInsensitiveChoice(["all", "always", "never", "request", "default"]), multiple=True, help=u"""A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.""")
@cli_util.option('--id', help=u"""Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--ocid', help=u"""Unique OCI identifier for the SCIM Resource.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: string  - uniqueness: global""")
@cli_util.option('--meta', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-created-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-last-modified-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-prevented-operations', type=custom_types.CliCaseInsensitiveChoice(["replace", "update", "delete"]), help=u"""Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of tags on this resource.

**SCIM++ Properties:**  - idcsCompositeKey: [key, value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type Tags.  For documentation on tags please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/Tags.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--delete-in-progress', type=click.BOOL, help=u"""A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--idcs-last-upgraded-in-release', help=u"""The release number when the resource was upgraded.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--domain-ocid', help=u"""OCI Domain Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--compartment-ocid', help=u"""OCI Compartment Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--tenancy-ocid', help=u"""OCI Tenant Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--is-opc-service', type=click.BOOL, help=u"""Indicates whether this resource was created by OPC

**Added In:** 19.3.3

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: boolean  - uniqueness: none""")
@cli_util.option('--description', help=u"""Brief description for this Cloud Gate

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--proxy-pass', help=u"""NGINX ProxyPass entry for this Mapping

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--nginx-settings', help=u"""More NGINX Settings. JSON encoded key value pairs similar to WTP encoding

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--upstream-server-group', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'upstream-server-group': {'module': 'identity_domains', 'class': 'CloudGateMappingUpstreamServerGroup'}, 'server': {'module': 'identity_domains', 'class': 'CloudGateMappingServer'}, 'gateway-app': {'module': 'identity_domains', 'class': 'CloudGateMappingGatewayApp'}, 'cloud-gate': {'module': 'identity_domains', 'class': 'CloudGateMappingCloudGate'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'upstream-server-group': {'module': 'identity_domains', 'class': 'CloudGateMappingUpstreamServerGroup'}, 'server': {'module': 'identity_domains', 'class': 'CloudGateMappingServer'}, 'gateway-app': {'module': 'identity_domains', 'class': 'CloudGateMappingGatewayApp'}, 'cloud-gate': {'module': 'identity_domains', 'class': 'CloudGateMappingCloudGate'}}, output_type={'module': 'identity_domains', 'class': 'CloudGateMapping'})
@cli_util.wrap_exceptions
def create_cloud_gate_mapping(ctx, from_json, schemas, resource_prefix, policy_name, server, gateway_app, cloud_gate, authorization, resource_type_schema_version, attributes, attribute_sets, id, ocid, meta, idcs_created_by, idcs_last_modified_by, idcs_prevented_operations, tags, delete_in_progress, idcs_last_upgraded_in_release, domain_ocid, compartment_ocid, tenancy_ocid, is_opc_service, description, proxy_pass, nginx_settings, upstream_server_group):

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if attributes is not None:
        kwargs['attributes'] = attributes
    if attribute_sets is not None and len(attribute_sets) > 0:
        kwargs['attribute_sets'] = attribute_sets

    _details = {}
    _details['schemas'] = cli_util.parse_json_parameter("schemas", schemas)
    _details['resourcePrefix'] = resource_prefix
    _details['policyName'] = policy_name
    _details['server'] = cli_util.parse_json_parameter("server", server)
    _details['gatewayApp'] = cli_util.parse_json_parameter("gateway_app", gateway_app)
    _details['cloudGate'] = cli_util.parse_json_parameter("cloud_gate", cloud_gate)

    if id is not None:
        _details['id'] = id

    if ocid is not None:
        _details['ocid'] = ocid

    if meta is not None:
        _details['meta'] = cli_util.parse_json_parameter("meta", meta)

    if idcs_created_by is not None:
        _details['idcsCreatedBy'] = cli_util.parse_json_parameter("idcs_created_by", idcs_created_by)

    if idcs_last_modified_by is not None:
        _details['idcsLastModifiedBy'] = cli_util.parse_json_parameter("idcs_last_modified_by", idcs_last_modified_by)

    if idcs_prevented_operations is not None:
        _details['idcsPreventedOperations'] = cli_util.parse_json_parameter("idcs_prevented_operations", idcs_prevented_operations)

    if tags is not None:
        _details['tags'] = cli_util.parse_json_parameter("tags", tags)

    if delete_in_progress is not None:
        _details['deleteInProgress'] = delete_in_progress

    if idcs_last_upgraded_in_release is not None:
        _details['idcsLastUpgradedInRelease'] = idcs_last_upgraded_in_release

    if domain_ocid is not None:
        _details['domainOcid'] = domain_ocid

    if compartment_ocid is not None:
        _details['compartmentOcid'] = compartment_ocid

    if tenancy_ocid is not None:
        _details['tenancyOcid'] = tenancy_ocid

    if is_opc_service is not None:
        _details['isOPCService'] = is_opc_service

    if description is not None:
        _details['description'] = description

    if proxy_pass is not None:
        _details['proxyPass'] = proxy_pass

    if nginx_settings is not None:
        _details['nginxSettings'] = nginx_settings

    if upstream_server_group is not None:
        _details['upstreamServerGroup'] = cli_util.parse_json_parameter("upstream_server_group", upstream_server_group)

    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.create_cloud_gate_mapping(
        cloud_gate_mapping=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@cloud_gate_server_group.command(name=cli_util.override('identity_domains.create_cloud_gate_server.command_name', 'create'), help=u"""Create a Cloud Gate server

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](createCloudGateServer)""")
@cli_util.option('--schemas', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--display-name', required=True, help=u"""Display name for the Server block

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: true  - returned: always  - type: string  - uniqueness: server""")
@cli_util.option('--host-name', required=True, help=u"""Hostname for the Server block

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: true  - returned: always  - type: string  - uniqueness: none""")
@cli_util.option('--port', required=True, type=click.INT, help=u"""Port for the Server Block

**SCIM++ Properties:**  - caseExact: true  - idcsMaxValue: 65535  - idcsMinValue: 1  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: true  - returned: default  - type: integer  - uniqueness: none""")
@cli_util.option('--ssl', required=True, type=click.BOOL, help=u"""SSL flag for the Server Block

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: true  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--cloud-gate', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--attributes', help=u"""A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.""")
@cli_util.option('--attribute-sets', type=custom_types.CliCaseInsensitiveChoice(["all", "always", "never", "request", "default"]), multiple=True, help=u"""A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.""")
@cli_util.option('--id', help=u"""Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--ocid', help=u"""Unique OCI identifier for the SCIM Resource.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: string  - uniqueness: global""")
@cli_util.option('--meta', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-created-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-last-modified-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-prevented-operations', type=custom_types.CliCaseInsensitiveChoice(["replace", "update", "delete"]), help=u"""Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of tags on this resource.

**SCIM++ Properties:**  - idcsCompositeKey: [key, value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type Tags.  For documentation on tags please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/Tags.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--delete-in-progress', type=click.BOOL, help=u"""A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--idcs-last-upgraded-in-release', help=u"""The release number when the resource was upgraded.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--domain-ocid', help=u"""OCI Domain Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--compartment-ocid', help=u"""OCI Compartment Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--tenancy-ocid', help=u"""OCI Tenant Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--is-opc-service', type=click.BOOL, help=u"""Indicates whether this resource was created by OPC

**Added In:** 19.3.3

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: boolean  - uniqueness: none""")
@cli_util.option('--description', help=u"""Brief description for this Cloud Gate server block

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--nginx-settings', help=u"""More nginx Settings. JSON encoded text block

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@json_skeleton_utils.get_cli_json_input_option({'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'cloud-gate': {'module': 'identity_domains', 'class': 'CloudGateServerCloudGate'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'cloud-gate': {'module': 'identity_domains', 'class': 'CloudGateServerCloudGate'}}, output_type={'module': 'identity_domains', 'class': 'CloudGateServer'})
@cli_util.wrap_exceptions
def create_cloud_gate_server(ctx, from_json, schemas, display_name, host_name, port, ssl, cloud_gate, authorization, resource_type_schema_version, attributes, attribute_sets, id, ocid, meta, idcs_created_by, idcs_last_modified_by, idcs_prevented_operations, tags, delete_in_progress, idcs_last_upgraded_in_release, domain_ocid, compartment_ocid, tenancy_ocid, is_opc_service, description, nginx_settings):

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if attributes is not None:
        kwargs['attributes'] = attributes
    if attribute_sets is not None and len(attribute_sets) > 0:
        kwargs['attribute_sets'] = attribute_sets

    _details = {}
    _details['schemas'] = cli_util.parse_json_parameter("schemas", schemas)
    _details['displayName'] = display_name
    _details['hostName'] = host_name
    _details['port'] = port
    _details['ssl'] = ssl
    _details['cloudGate'] = cli_util.parse_json_parameter("cloud_gate", cloud_gate)

    if id is not None:
        _details['id'] = id

    if ocid is not None:
        _details['ocid'] = ocid

    if meta is not None:
        _details['meta'] = cli_util.parse_json_parameter("meta", meta)

    if idcs_created_by is not None:
        _details['idcsCreatedBy'] = cli_util.parse_json_parameter("idcs_created_by", idcs_created_by)

    if idcs_last_modified_by is not None:
        _details['idcsLastModifiedBy'] = cli_util.parse_json_parameter("idcs_last_modified_by", idcs_last_modified_by)

    if idcs_prevented_operations is not None:
        _details['idcsPreventedOperations'] = cli_util.parse_json_parameter("idcs_prevented_operations", idcs_prevented_operations)

    if tags is not None:
        _details['tags'] = cli_util.parse_json_parameter("tags", tags)

    if delete_in_progress is not None:
        _details['deleteInProgress'] = delete_in_progress

    if idcs_last_upgraded_in_release is not None:
        _details['idcsLastUpgradedInRelease'] = idcs_last_upgraded_in_release

    if domain_ocid is not None:
        _details['domainOcid'] = domain_ocid

    if compartment_ocid is not None:
        _details['compartmentOcid'] = compartment_ocid

    if tenancy_ocid is not None:
        _details['tenancyOcid'] = tenancy_ocid

    if is_opc_service is not None:
        _details['isOPCService'] = is_opc_service

    if description is not None:
        _details['description'] = description

    if nginx_settings is not None:
        _details['nginxSettings'] = nginx_settings

    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.create_cloud_gate_server(
        cloud_gate_server=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@condition_group.command(name=cli_util.override('identity_domains.create_condition.command_name', 'create'), help=u"""Create a condition

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](createCondition)""")
@cli_util.option('--schemas', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--name', required=True, help=u"""Condition name

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: true  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--attribute-name', required=True, help=u"""AttributeName - RHS of condition

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--operator', required=True, type=custom_types.CliCaseInsensitiveChoice(["eq", "ne", "co", "coany", "sw", "ew", "gt", "ge", "lt", "le", "in", "nin"]), help=u"""**SCIM++ Properties:** - caseExact: true - idcsSearchable: false - multiValued: false - mutability: readWrite - required: true - returned: default - type: string - uniqueness: none Operator in the condition. It support all SCIM operators like eq, gt, lt, le, sw etc""")
@cli_util.option('--attribute-value', required=True, help=u"""attributeValue - RHS of condition

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--attributes', help=u"""A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.""")
@cli_util.option('--attribute-sets', type=custom_types.CliCaseInsensitiveChoice(["all", "always", "never", "request", "default"]), multiple=True, help=u"""A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.""")
@cli_util.option('--id', help=u"""Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--ocid', help=u"""Unique OCI identifier for the SCIM Resource.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: string  - uniqueness: global""")
@cli_util.option('--meta', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-created-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-last-modified-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-prevented-operations', type=custom_types.CliCaseInsensitiveChoice(["replace", "update", "delete"]), help=u"""Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of tags on this resource.

**SCIM++ Properties:**  - idcsCompositeKey: [key, value]  - idcsCsvAttributeNameMappings: [[columnHeaderName:Tag Key, mapsTo:tags.key], [columnHeaderName:Tag Value, mapsTo:tags.value]]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type Tags.  For documentation on tags please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/Tags.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--delete-in-progress', type=click.BOOL, help=u"""A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--idcs-last-upgraded-in-release', help=u"""The release number when the resource was upgraded.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--domain-ocid', help=u"""OCI Domain Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--compartment-ocid', help=u"""OCI Compartment Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--tenancy-ocid', help=u"""OCI Tenant Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--external-id', help=u"""An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value.  The value of the externalId attribute is always issued be the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--description', help=u"""Condition Description

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--evaluate-condition-if', help=u"""Evaluate the condition if this expression returns true, else skip condition evaluation

**Added In:** 18.1.6

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionociconsolesignonpolicyconsent-policy', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'urnietfparamsscimschemasoracleidcsextensionociconsolesignonpolicyconsent-policy': {'module': 'identity_domains', 'class': 'ConditionExtensionOciconsolesignonpolicyconsentPolicy'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'urnietfparamsscimschemasoracleidcsextensionociconsolesignonpolicyconsent-policy': {'module': 'identity_domains', 'class': 'ConditionExtensionOciconsolesignonpolicyconsentPolicy'}}, output_type={'module': 'identity_domains', 'class': 'Condition'})
@cli_util.wrap_exceptions
def create_condition(ctx, from_json, schemas, name, attribute_name, operator, attribute_value, authorization, resource_type_schema_version, attributes, attribute_sets, id, ocid, meta, idcs_created_by, idcs_last_modified_by, idcs_prevented_operations, tags, delete_in_progress, idcs_last_upgraded_in_release, domain_ocid, compartment_ocid, tenancy_ocid, external_id, description, evaluate_condition_if, urnietfparamsscimschemasoracleidcsextensionociconsolesignonpolicyconsent_policy):

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if attributes is not None:
        kwargs['attributes'] = attributes
    if attribute_sets is not None and len(attribute_sets) > 0:
        kwargs['attribute_sets'] = attribute_sets

    _details = {}
    _details['schemas'] = cli_util.parse_json_parameter("schemas", schemas)
    _details['name'] = name
    _details['attributeName'] = attribute_name
    _details['operator'] = operator
    _details['attributeValue'] = attribute_value

    if id is not None:
        _details['id'] = id

    if ocid is not None:
        _details['ocid'] = ocid

    if meta is not None:
        _details['meta'] = cli_util.parse_json_parameter("meta", meta)

    if idcs_created_by is not None:
        _details['idcsCreatedBy'] = cli_util.parse_json_parameter("idcs_created_by", idcs_created_by)

    if idcs_last_modified_by is not None:
        _details['idcsLastModifiedBy'] = cli_util.parse_json_parameter("idcs_last_modified_by", idcs_last_modified_by)

    if idcs_prevented_operations is not None:
        _details['idcsPreventedOperations'] = cli_util.parse_json_parameter("idcs_prevented_operations", idcs_prevented_operations)

    if tags is not None:
        _details['tags'] = cli_util.parse_json_parameter("tags", tags)

    if delete_in_progress is not None:
        _details['deleteInProgress'] = delete_in_progress

    if idcs_last_upgraded_in_release is not None:
        _details['idcsLastUpgradedInRelease'] = idcs_last_upgraded_in_release

    if domain_ocid is not None:
        _details['domainOcid'] = domain_ocid

    if compartment_ocid is not None:
        _details['compartmentOcid'] = compartment_ocid

    if tenancy_ocid is not None:
        _details['tenancyOcid'] = tenancy_ocid

    if external_id is not None:
        _details['externalId'] = external_id

    if description is not None:
        _details['description'] = description

    if evaluate_condition_if is not None:
        _details['evaluateConditionIf'] = evaluate_condition_if

    if urnietfparamsscimschemasoracleidcsextensionociconsolesignonpolicyconsent_policy is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:ociconsolesignonpolicyconsent:Policy'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionociconsolesignonpolicyconsent_policy", urnietfparamsscimschemasoracleidcsextensionociconsolesignonpolicyconsent_policy)

    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.create_condition(
        condition=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@customer_secret_key_group.command(name=cli_util.override('identity_domains.create_customer_secret_key.command_name', 'create'), help=u"""Create a user's customer secret key.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](createCustomerSecretKey)""")
@cli_util.option('--schemas', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--attributes', help=u"""A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.""")
@cli_util.option('--attribute-sets', type=custom_types.CliCaseInsensitiveChoice(["all", "always", "never", "request", "default"]), multiple=True, help=u"""A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.""")
@cli_util.option('--id', help=u"""Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--ocid', help=u"""Unique OCI identifier for the SCIM Resource.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: string  - uniqueness: global""")
@cli_util.option('--meta', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-created-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-last-modified-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-prevented-operations', type=custom_types.CliCaseInsensitiveChoice(["replace", "update", "delete"]), help=u"""Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of tags on this resource.

**SCIM++ Properties:**  - idcsCompositeKey: [key, value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type Tags.  For documentation on tags please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/Tags.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--delete-in-progress', type=click.BOOL, help=u"""A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--idcs-last-upgraded-in-release', help=u"""The release number when the resource was upgraded.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--domain-ocid', help=u"""OCI Domain Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--compartment-ocid', help=u"""OCI Compartment Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--tenancy-ocid', help=u"""OCI Tenant Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--display-name', help=u"""Display Name

**SCIM++ Properties:**  - caseExact: false  - type: string  - mutability: readWrite  - required: false  - returned: default""")
@cli_util.option('--description', help=u"""Description

**SCIM++ Properties:**  - caseExact: false  - type: string  - mutability: readWrite  - required: false  - returned: default""")
@cli_util.option('--status', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "INACTIVE"]), help=u"""The user's credential status.

**Added In:** 2109090424

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: never  - type: string  - uniqueness: none""")
@cli_util.option('--expires-on', help=u"""When the user's credential expire.

**Added In:** 2109090424

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: dateTime  - uniqueness: none""")
@cli_util.option('--access-key', help=u"""The access key.

**SCIM++ Properties:**  - caseExact: true  - type: string  - mutability: readOnly  - required: false  - returned: default""")
@cli_util.option('--secret-key', help=u"""The secret key.

**SCIM++ Properties:**  - caseExact: true  - type: string  - mutability: readOnly  - required: false  - returned: default""")
@cli_util.option('--user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionself-change-user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'user': {'module': 'identity_domains', 'class': 'CustomerSecretKeyUser'}, 'urnietfparamsscimschemasoracleidcsextensionself-change-user': {'module': 'identity_domains', 'class': 'ExtensionSelfChangeUser'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'user': {'module': 'identity_domains', 'class': 'CustomerSecretKeyUser'}, 'urnietfparamsscimschemasoracleidcsextensionself-change-user': {'module': 'identity_domains', 'class': 'ExtensionSelfChangeUser'}}, output_type={'module': 'identity_domains', 'class': 'CustomerSecretKey'})
@cli_util.wrap_exceptions
def create_customer_secret_key(ctx, from_json, schemas, authorization, resource_type_schema_version, attributes, attribute_sets, id, ocid, meta, idcs_created_by, idcs_last_modified_by, idcs_prevented_operations, tags, delete_in_progress, idcs_last_upgraded_in_release, domain_ocid, compartment_ocid, tenancy_ocid, display_name, description, status, expires_on, access_key, secret_key, user, urnietfparamsscimschemasoracleidcsextensionself_change_user):

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if attributes is not None:
        kwargs['attributes'] = attributes
    if attribute_sets is not None and len(attribute_sets) > 0:
        kwargs['attribute_sets'] = attribute_sets

    _details = {}
    _details['schemas'] = cli_util.parse_json_parameter("schemas", schemas)

    if id is not None:
        _details['id'] = id

    if ocid is not None:
        _details['ocid'] = ocid

    if meta is not None:
        _details['meta'] = cli_util.parse_json_parameter("meta", meta)

    if idcs_created_by is not None:
        _details['idcsCreatedBy'] = cli_util.parse_json_parameter("idcs_created_by", idcs_created_by)

    if idcs_last_modified_by is not None:
        _details['idcsLastModifiedBy'] = cli_util.parse_json_parameter("idcs_last_modified_by", idcs_last_modified_by)

    if idcs_prevented_operations is not None:
        _details['idcsPreventedOperations'] = cli_util.parse_json_parameter("idcs_prevented_operations", idcs_prevented_operations)

    if tags is not None:
        _details['tags'] = cli_util.parse_json_parameter("tags", tags)

    if delete_in_progress is not None:
        _details['deleteInProgress'] = delete_in_progress

    if idcs_last_upgraded_in_release is not None:
        _details['idcsLastUpgradedInRelease'] = idcs_last_upgraded_in_release

    if domain_ocid is not None:
        _details['domainOcid'] = domain_ocid

    if compartment_ocid is not None:
        _details['compartmentOcid'] = compartment_ocid

    if tenancy_ocid is not None:
        _details['tenancyOcid'] = tenancy_ocid

    if display_name is not None:
        _details['displayName'] = display_name

    if description is not None:
        _details['description'] = description

    if status is not None:
        _details['status'] = status

    if expires_on is not None:
        _details['expiresOn'] = expires_on

    if access_key is not None:
        _details['accessKey'] = access_key

    if secret_key is not None:
        _details['secretKey'] = secret_key

    if user is not None:
        _details['user'] = cli_util.parse_json_parameter("user", user)

    if urnietfparamsscimschemasoracleidcsextensionself_change_user is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:selfChange:User'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionself_change_user", urnietfparamsscimschemasoracleidcsextensionself_change_user)

    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.create_customer_secret_key(
        customer_secret_key=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@dynamic_resource_group_group.command(name=cli_util.override('identity_domains.create_dynamic_resource_group.command_name', 'create'), help=u"""Create a Dynamic Resource Group.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](createDynamicResourceGroup)""")
@cli_util.option('--schemas', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--matching-rule', required=True, help=u"""Store as a string the matching-rule for this Dynamic Resource Group. This may match any number of Apps in this Domain, as well as matching any number of OCI resources that are not in any Domain but that are in the OCI Compartment that contains this Domain.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: true  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--display-name', required=True, help=u"""User-friendly, mutable identifier

**SCIM++ Properties:**  - idcsCsvAttributeName: Display Name  - idcsCsvAttributeNameMappings: [[columnHeaderName:Name, deprecatedColumnHeaderName:Display Name]]  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: true  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--attributes', help=u"""A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.""")
@cli_util.option('--attribute-sets', type=custom_types.CliCaseInsensitiveChoice(["all", "always", "never", "request", "default"]), multiple=True, help=u"""A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.""")
@cli_util.option('--id', help=u"""Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--ocid', help=u"""Unique OCI identifier for the SCIM Resource.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: string  - uniqueness: global""")
@cli_util.option('--meta', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-created-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-last-modified-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-prevented-operations', type=custom_types.CliCaseInsensitiveChoice(["replace", "update", "delete"]), help=u"""Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of tags on this resource.

**SCIM++ Properties:**  - idcsCompositeKey: [key, value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type Tags.  For documentation on tags please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/Tags.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--delete-in-progress', type=click.BOOL, help=u"""A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--idcs-last-upgraded-in-release', help=u"""The release number when the resource was upgraded.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--domain-ocid', help=u"""OCI Domain Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--compartment-ocid', help=u"""OCI Compartment Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--tenancy-ocid', help=u"""OCI Tenant Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--description', help=u"""text that explains the purpose of this Dynamic Resource Group

**SCIM++ Properties:**  - caseExact: false  - idcsCsvAttributeName: Description  - idcsCsvAttributeNameMappings: [[columnHeaderName:Description]]  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: always  - type: string  - uniqueness: none""")
@cli_util.option('--grants', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Grants assigned to group

**SCIM++ Properties:**  - idcsAddedSinceVersion: 3  - idcsSearchable: true  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type DynamicResourceGroupGrants.  For documentation on DynamicResourceGroupGrants please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/DynamicResourceGroupGrants.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--dynamic-group-app-roles', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of appRoles that are currently granted to this Dynamic Resource Group.  The Identity service will assert these AppRoles for any resource that satisfies the matching-rule of this DynamicResourceGroup.

**SCIM++ Properties:**  - caseExact: false  - idcsCompositeKey: [value]  - idcsSearchable: true  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type DynamicResourceGroupDynamicGroupAppRoles.  For documentation on DynamicResourceGroupDynamicGroupAppRoles please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/DynamicResourceGroupDynamicGroupAppRoles.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextension-oci-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'grants': {'module': 'identity_domains', 'class': 'list[DynamicResourceGroupGrants]'}, 'dynamic-group-app-roles': {'module': 'identity_domains', 'class': 'list[DynamicResourceGroupDynamicGroupAppRoles]'}, 'urnietfparamsscimschemasoracleidcsextension-oci-tags': {'module': 'identity_domains', 'class': 'ExtensionOCITags'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'grants': {'module': 'identity_domains', 'class': 'list[DynamicResourceGroupGrants]'}, 'dynamic-group-app-roles': {'module': 'identity_domains', 'class': 'list[DynamicResourceGroupDynamicGroupAppRoles]'}, 'urnietfparamsscimschemasoracleidcsextension-oci-tags': {'module': 'identity_domains', 'class': 'ExtensionOCITags'}}, output_type={'module': 'identity_domains', 'class': 'DynamicResourceGroup'})
@cli_util.wrap_exceptions
def create_dynamic_resource_group(ctx, from_json, schemas, matching_rule, display_name, authorization, resource_type_schema_version, attributes, attribute_sets, id, ocid, meta, idcs_created_by, idcs_last_modified_by, idcs_prevented_operations, tags, delete_in_progress, idcs_last_upgraded_in_release, domain_ocid, compartment_ocid, tenancy_ocid, description, grants, dynamic_group_app_roles, urnietfparamsscimschemasoracleidcsextension_oci_tags):

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if attributes is not None:
        kwargs['attributes'] = attributes
    if attribute_sets is not None and len(attribute_sets) > 0:
        kwargs['attribute_sets'] = attribute_sets

    _details = {}
    _details['schemas'] = cli_util.parse_json_parameter("schemas", schemas)
    _details['matchingRule'] = matching_rule
    _details['displayName'] = display_name

    if id is not None:
        _details['id'] = id

    if ocid is not None:
        _details['ocid'] = ocid

    if meta is not None:
        _details['meta'] = cli_util.parse_json_parameter("meta", meta)

    if idcs_created_by is not None:
        _details['idcsCreatedBy'] = cli_util.parse_json_parameter("idcs_created_by", idcs_created_by)

    if idcs_last_modified_by is not None:
        _details['idcsLastModifiedBy'] = cli_util.parse_json_parameter("idcs_last_modified_by", idcs_last_modified_by)

    if idcs_prevented_operations is not None:
        _details['idcsPreventedOperations'] = cli_util.parse_json_parameter("idcs_prevented_operations", idcs_prevented_operations)

    if tags is not None:
        _details['tags'] = cli_util.parse_json_parameter("tags", tags)

    if delete_in_progress is not None:
        _details['deleteInProgress'] = delete_in_progress

    if idcs_last_upgraded_in_release is not None:
        _details['idcsLastUpgradedInRelease'] = idcs_last_upgraded_in_release

    if domain_ocid is not None:
        _details['domainOcid'] = domain_ocid

    if compartment_ocid is not None:
        _details['compartmentOcid'] = compartment_ocid

    if tenancy_ocid is not None:
        _details['tenancyOcid'] = tenancy_ocid

    if description is not None:
        _details['description'] = description

    if grants is not None:
        _details['grants'] = cli_util.parse_json_parameter("grants", grants)

    if dynamic_group_app_roles is not None:
        _details['dynamicGroupAppRoles'] = cli_util.parse_json_parameter("dynamic_group_app_roles", dynamic_group_app_roles)

    if urnietfparamsscimschemasoracleidcsextension_oci_tags is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:OCITags'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextension_oci_tags", urnietfparamsscimschemasoracleidcsextension_oci_tags)

    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.create_dynamic_resource_group(
        dynamic_resource_group=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@grant_group.command(name=cli_util.override('identity_domains.create_grant.command_name', 'create'), help=u"""Add a Grantee to an AppRole

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](createGrant)""")
@cli_util.option('--schemas', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--grant-mechanism', required=True, type=custom_types.CliCaseInsensitiveChoice(["IMPORT_APPROLE_MEMBERS", "ADMINISTRATOR_TO_USER", "ADMINISTRATOR_TO_DELEGATED_USER", "ADMINISTRATOR_TO_GROUP", "SERVICE_MANAGER_TO_USER", "ADMINISTRATOR_TO_APP", "SERVICE_MANAGER_TO_APP", "OPC_INFRA_TO_APP", "GROUP_MEMBERSHIP", "IMPORT_GRANTS", "SYNC_TO_USER", "ACCESS_REQUEST", "APP_ENTITLEMENT_COLLECTION", "ADMINISTRATOR_TO_DYNAMIC_RESOURCE_GROUP"]), help=u"""Each value of grantMechanism indicates how (or by what component) some App (or App-Entitlement) was granted. A customer or the UI should use only grantMechanism values that start with 'ADMINISTRATOR':   - 'ADMINISTRATOR_TO_USER' is for a direct grant to a specific User.   - 'ADMINISTRATOR_TO_GROUP' is for a grant to a specific Group, which results in indirect grants to Users who are members of that Group.   - 'ADMINISTRATOR_TO_APP' is for a grant to a specific App.  The grantee (client) App gains access to the granted (server) App.

**SCIM++ Properties:**  - caseExact: true  - idcsCsvAttributeNameMappings: [[defaultValue:IMPORT_GRANTS]]  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: true  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--grantee', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--attributes', help=u"""A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.""")
@cli_util.option('--attribute-sets', type=custom_types.CliCaseInsensitiveChoice(["all", "always", "never", "request", "default"]), multiple=True, help=u"""A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.""")
@cli_util.option('--id', help=u"""Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--ocid', help=u"""Unique OCI identifier for the SCIM Resource.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: string  - uniqueness: global""")
@cli_util.option('--meta', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-created-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-last-modified-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-prevented-operations', type=custom_types.CliCaseInsensitiveChoice(["replace", "update", "delete"]), help=u"""Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of tags on this resource.

**SCIM++ Properties:**  - idcsCompositeKey: [key, value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type Tags.  For documentation on tags please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/Tags.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--delete-in-progress', type=click.BOOL, help=u"""A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--idcs-last-upgraded-in-release', help=u"""The release number when the resource was upgraded.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--domain-ocid', help=u"""OCI Domain Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--compartment-ocid', help=u"""OCI Compartment Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--tenancy-ocid', help=u"""OCI Tenant Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--composite-key', help=u"""Unique key of grant, composed by combining a subset of app, entitlement, grantee, grantor and grantMechanism.  Used to prevent duplicate Grants.

**Added In:** 18.1.2

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: server""")
@cli_util.option('--is-fulfilled', type=click.BOOL, help=u"""If true, this Grant has been fulfilled successfully.

**SCIM++ Properties:**  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--granted-attribute-values-json', help=u"""Store granted attribute-values as a string in Javascript Object Notation (JSON) format.

**Added In:** 18.3.4

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--app-entitlement-collection', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--grantor', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--app', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--entitlement', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'app-entitlement-collection': {'module': 'identity_domains', 'class': 'GrantAppEntitlementCollection'}, 'grantor': {'module': 'identity_domains', 'class': 'GrantGrantor'}, 'grantee': {'module': 'identity_domains', 'class': 'GrantGrantee'}, 'app': {'module': 'identity_domains', 'class': 'GrantApp'}, 'entitlement': {'module': 'identity_domains', 'class': 'GrantEntitlement'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'app-entitlement-collection': {'module': 'identity_domains', 'class': 'GrantAppEntitlementCollection'}, 'grantor': {'module': 'identity_domains', 'class': 'GrantGrantor'}, 'grantee': {'module': 'identity_domains', 'class': 'GrantGrantee'}, 'app': {'module': 'identity_domains', 'class': 'GrantApp'}, 'entitlement': {'module': 'identity_domains', 'class': 'GrantEntitlement'}}, output_type={'module': 'identity_domains', 'class': 'Grant'})
@cli_util.wrap_exceptions
def create_grant(ctx, from_json, schemas, grant_mechanism, grantee, authorization, resource_type_schema_version, attributes, attribute_sets, id, ocid, meta, idcs_created_by, idcs_last_modified_by, idcs_prevented_operations, tags, delete_in_progress, idcs_last_upgraded_in_release, domain_ocid, compartment_ocid, tenancy_ocid, composite_key, is_fulfilled, granted_attribute_values_json, app_entitlement_collection, grantor, app, entitlement):

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if attributes is not None:
        kwargs['attributes'] = attributes
    if attribute_sets is not None and len(attribute_sets) > 0:
        kwargs['attribute_sets'] = attribute_sets

    _details = {}
    _details['schemas'] = cli_util.parse_json_parameter("schemas", schemas)
    _details['grantMechanism'] = grant_mechanism
    _details['grantee'] = cli_util.parse_json_parameter("grantee", grantee)

    if id is not None:
        _details['id'] = id

    if ocid is not None:
        _details['ocid'] = ocid

    if meta is not None:
        _details['meta'] = cli_util.parse_json_parameter("meta", meta)

    if idcs_created_by is not None:
        _details['idcsCreatedBy'] = cli_util.parse_json_parameter("idcs_created_by", idcs_created_by)

    if idcs_last_modified_by is not None:
        _details['idcsLastModifiedBy'] = cli_util.parse_json_parameter("idcs_last_modified_by", idcs_last_modified_by)

    if idcs_prevented_operations is not None:
        _details['idcsPreventedOperations'] = cli_util.parse_json_parameter("idcs_prevented_operations", idcs_prevented_operations)

    if tags is not None:
        _details['tags'] = cli_util.parse_json_parameter("tags", tags)

    if delete_in_progress is not None:
        _details['deleteInProgress'] = delete_in_progress

    if idcs_last_upgraded_in_release is not None:
        _details['idcsLastUpgradedInRelease'] = idcs_last_upgraded_in_release

    if domain_ocid is not None:
        _details['domainOcid'] = domain_ocid

    if compartment_ocid is not None:
        _details['compartmentOcid'] = compartment_ocid

    if tenancy_ocid is not None:
        _details['tenancyOcid'] = tenancy_ocid

    if composite_key is not None:
        _details['compositeKey'] = composite_key

    if is_fulfilled is not None:
        _details['isFulfilled'] = is_fulfilled

    if granted_attribute_values_json is not None:
        _details['grantedAttributeValuesJson'] = granted_attribute_values_json

    if app_entitlement_collection is not None:
        _details['appEntitlementCollection'] = cli_util.parse_json_parameter("app_entitlement_collection", app_entitlement_collection)

    if grantor is not None:
        _details['grantor'] = cli_util.parse_json_parameter("grantor", grantor)

    if app is not None:
        _details['app'] = cli_util.parse_json_parameter("app", app)

    if entitlement is not None:
        _details['entitlement'] = cli_util.parse_json_parameter("entitlement", entitlement)

    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.create_grant(
        grant=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@group_group.command(name=cli_util.override('identity_domains.create_group.command_name', 'create'), help=u"""Create a group.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](createGroup)""")
@cli_util.option('--schemas', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--display-name', required=True, help=u"""The Group display name.

**SCIM++ Properties:**  - caseExact: false  - idcsCsvAttributeName: Display Name  - idcsCsvAttributeNameMappings: [[columnHeaderName:Name, deprecatedColumnHeaderName:Display Name]]  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: true  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--attributes', help=u"""A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.""")
@cli_util.option('--attribute-sets', type=custom_types.CliCaseInsensitiveChoice(["all", "always", "never", "request", "default"]), multiple=True, help=u"""A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.""")
@cli_util.option('--id', help=u"""Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--ocid', help=u"""Unique OCI identifier for the SCIM Resource.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: string  - uniqueness: global""")
@cli_util.option('--meta', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-created-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-last-modified-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-prevented-operations', type=custom_types.CliCaseInsensitiveChoice(["replace", "update", "delete"]), help=u"""Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of tags on this resource.

**SCIM++ Properties:**  - idcsCompositeKey: [key, value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type Tags.  For documentation on tags please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/Tags.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--delete-in-progress', type=click.BOOL, help=u"""A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--idcs-last-upgraded-in-release', help=u"""The release number when the resource was upgraded.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--domain-ocid', help=u"""OCI Domain Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--compartment-ocid', help=u"""OCI Compartment Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--tenancy-ocid', help=u"""OCI Tenant Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--external-id', help=u"""An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--non-unique-display-name', help=u"""A human readable name for the group as defined by the Service Consumer.

**Added In:** 2011192329

**SCIM++ Properties:**  - caseExact: false  - idcsCsvAttributeName: Non-Unique Display Name  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: always  - type: string""")
@cli_util.option('--members', type=custom_types.CLI_COMPLEX_TYPE, help=u"""The group members. <b>Important:</b> When requesting group members, a maximum of 10,000 members can be returned in a single request. If the response contains more than 10,000 members, the request will fail. Use 'startIndex' and 'count' to return members in pages instead of in a single response, for example: #attributes=members[startIndex=1%26count=10]. This REST API is SCIM compliant.

**SCIM++ Properties:**  - caseExact: false  - idcsCompositeKey: [value]  - idcsCsvAttributeNameMappings: [[columnHeaderName:User Members, mapsTo:members[User].value, multiValueDelimiter:;]]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - idcsPaginateResponse: true  - type: complex  - uniqueness: none

This option is a JSON list with items of type GroupMembers.  For documentation on GroupMembers please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/GroupMembers.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensiongroup-group', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionposix-group', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionrequestable-group', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensiondbcs-group', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensiondynamic-group', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextension-oci-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'members': {'module': 'identity_domains', 'class': 'list[GroupMembers]'}, 'urnietfparamsscimschemasoracleidcsextensiongroup-group': {'module': 'identity_domains', 'class': 'ExtensionGroupGroup'}, 'urnietfparamsscimschemasoracleidcsextensionposix-group': {'module': 'identity_domains', 'class': 'ExtensionPosixGroup'}, 'urnietfparamsscimschemasoracleidcsextensionrequestable-group': {'module': 'identity_domains', 'class': 'ExtensionRequestableGroup'}, 'urnietfparamsscimschemasoracleidcsextensiondbcs-group': {'module': 'identity_domains', 'class': 'ExtensionDbcsGroup'}, 'urnietfparamsscimschemasoracleidcsextensiondynamic-group': {'module': 'identity_domains', 'class': 'ExtensionDynamicGroup'}, 'urnietfparamsscimschemasoracleidcsextension-oci-tags': {'module': 'identity_domains', 'class': 'ExtensionOCITags'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'members': {'module': 'identity_domains', 'class': 'list[GroupMembers]'}, 'urnietfparamsscimschemasoracleidcsextensiongroup-group': {'module': 'identity_domains', 'class': 'ExtensionGroupGroup'}, 'urnietfparamsscimschemasoracleidcsextensionposix-group': {'module': 'identity_domains', 'class': 'ExtensionPosixGroup'}, 'urnietfparamsscimschemasoracleidcsextensionrequestable-group': {'module': 'identity_domains', 'class': 'ExtensionRequestableGroup'}, 'urnietfparamsscimschemasoracleidcsextensiondbcs-group': {'module': 'identity_domains', 'class': 'ExtensionDbcsGroup'}, 'urnietfparamsscimschemasoracleidcsextensiondynamic-group': {'module': 'identity_domains', 'class': 'ExtensionDynamicGroup'}, 'urnietfparamsscimschemasoracleidcsextension-oci-tags': {'module': 'identity_domains', 'class': 'ExtensionOCITags'}}, output_type={'module': 'identity_domains', 'class': 'Group'})
@cli_util.wrap_exceptions
def create_group(ctx, from_json, schemas, display_name, authorization, resource_type_schema_version, attributes, attribute_sets, id, ocid, meta, idcs_created_by, idcs_last_modified_by, idcs_prevented_operations, tags, delete_in_progress, idcs_last_upgraded_in_release, domain_ocid, compartment_ocid, tenancy_ocid, external_id, non_unique_display_name, members, urnietfparamsscimschemasoracleidcsextensiongroup_group, urnietfparamsscimschemasoracleidcsextensionposix_group, urnietfparamsscimschemasoracleidcsextensionrequestable_group, urnietfparamsscimschemasoracleidcsextensiondbcs_group, urnietfparamsscimschemasoracleidcsextensiondynamic_group, urnietfparamsscimschemasoracleidcsextension_oci_tags):

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if attributes is not None:
        kwargs['attributes'] = attributes
    if attribute_sets is not None and len(attribute_sets) > 0:
        kwargs['attribute_sets'] = attribute_sets

    _details = {}
    _details['schemas'] = cli_util.parse_json_parameter("schemas", schemas)
    _details['displayName'] = display_name

    if id is not None:
        _details['id'] = id

    if ocid is not None:
        _details['ocid'] = ocid

    if meta is not None:
        _details['meta'] = cli_util.parse_json_parameter("meta", meta)

    if idcs_created_by is not None:
        _details['idcsCreatedBy'] = cli_util.parse_json_parameter("idcs_created_by", idcs_created_by)

    if idcs_last_modified_by is not None:
        _details['idcsLastModifiedBy'] = cli_util.parse_json_parameter("idcs_last_modified_by", idcs_last_modified_by)

    if idcs_prevented_operations is not None:
        _details['idcsPreventedOperations'] = cli_util.parse_json_parameter("idcs_prevented_operations", idcs_prevented_operations)

    if tags is not None:
        _details['tags'] = cli_util.parse_json_parameter("tags", tags)

    if delete_in_progress is not None:
        _details['deleteInProgress'] = delete_in_progress

    if idcs_last_upgraded_in_release is not None:
        _details['idcsLastUpgradedInRelease'] = idcs_last_upgraded_in_release

    if domain_ocid is not None:
        _details['domainOcid'] = domain_ocid

    if compartment_ocid is not None:
        _details['compartmentOcid'] = compartment_ocid

    if tenancy_ocid is not None:
        _details['tenancyOcid'] = tenancy_ocid

    if external_id is not None:
        _details['externalId'] = external_id

    if non_unique_display_name is not None:
        _details['nonUniqueDisplayName'] = non_unique_display_name

    if members is not None:
        _details['members'] = cli_util.parse_json_parameter("members", members)

    if urnietfparamsscimschemasoracleidcsextensiongroup_group is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:group:Group'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensiongroup_group", urnietfparamsscimschemasoracleidcsextensiongroup_group)

    if urnietfparamsscimschemasoracleidcsextensionposix_group is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:posix:Group'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionposix_group", urnietfparamsscimschemasoracleidcsextensionposix_group)

    if urnietfparamsscimschemasoracleidcsextensionrequestable_group is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:requestable:Group'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionrequestable_group", urnietfparamsscimschemasoracleidcsextensionrequestable_group)

    if urnietfparamsscimschemasoracleidcsextensiondbcs_group is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:dbcs:Group'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensiondbcs_group", urnietfparamsscimschemasoracleidcsextensiondbcs_group)

    if urnietfparamsscimschemasoracleidcsextensiondynamic_group is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:dynamic:Group'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensiondynamic_group", urnietfparamsscimschemasoracleidcsextensiondynamic_group)

    if urnietfparamsscimschemasoracleidcsextension_oci_tags is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:OCITags'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextension_oci_tags", urnietfparamsscimschemasoracleidcsextension_oci_tags)

    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.create_group(
        group=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@identity_propagation_trust_group.command(name=cli_util.override('identity_domains.create_identity_propagation_trust.command_name', 'create'), help=u"""Register a new Identity Propagation Trust configuration.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](createIdentityPropagationTrust)""")
@cli_util.option('--schemas', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--name', required=True, help=u"""The name of the the Identity Propagation Trust.

**SCIM++ Properties:**  - type: string  - caseExact: false  - idcsSearchable: true  - multiValued: false  - required: true  - mutability: immutable  - returned: default  - uniqueness: none""")
@cli_util.option('--type', required=True, type=custom_types.CliCaseInsensitiveChoice(["JWT", "SAML", "SPNEGO", "AWS"]), help=u"""The type of the inbound token from the Identity cloud provider.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: false  - required: true  - mutability: readWrite  - returned: default  - type: string  - multiValued: false  - uniqueness: none""")
@cli_util.option('--issuer', required=True, help=u"""The issuer claim of the Identity provider.

**SCIM++ Properties:**  - type: string  - multiValued: false  - required: true  - mutability: readWrite  - returned: always  - caseExact: true  - idcsSearchable: true  - uniqueness: server""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--attributes', help=u"""A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.""")
@cli_util.option('--attribute-sets', type=custom_types.CliCaseInsensitiveChoice(["all", "always", "never", "request", "default"]), multiple=True, help=u"""A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.""")
@cli_util.option('--id', help=u"""Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--ocid', help=u"""Unique OCI identifier for the SCIM Resource.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: string  - uniqueness: global""")
@cli_util.option('--meta', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-created-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-last-modified-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-prevented-operations', type=custom_types.CliCaseInsensitiveChoice(["replace", "update", "delete"]), help=u"""Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of tags on this resource.

**SCIM++ Properties:**  - idcsCompositeKey: [key, value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type Tags.  For documentation on tags please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/Tags.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--delete-in-progress', type=click.BOOL, help=u"""A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--idcs-last-upgraded-in-release', help=u"""The release number when the resource was upgraded.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--domain-ocid', help=u"""OCI Domain Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--compartment-ocid', help=u"""OCI Compartment Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--tenancy-ocid', help=u"""OCI Tenant Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--description', help=u"""The description of the Identity Propagation Trust.

**SCIM++ Properties:**  - type: string  - multiValued: false  - required: false  - mutability: readWrite  - returned: default  - uniqueness: none  - caseExact: false  - idcsSearchable: false""")
@cli_util.option('--account-id', help=u"""The Identity cloud provider service identifier, for example, the Azure Tenancy ID, AWS Account ID, or GCP Project ID.

**SCIM++ Properties:**  - type: string  - multiValued: false  - required: false  - mutability: readWrite  - returned: default  - caseExact: true  - idcsSearchable: true  - uniqueness: none""")
@cli_util.option('--subject-claim-name', help=u"""Used for locating the subject claim from the incoming token.

**SCIM++ Properties:**  - type: string  - multiValued: false  - required: false  - mutability: readWrite  - returned: default  - uniqueness: none  - caseExact: true  - idcsSearchable: false""")
@cli_util.option('--subject-mapping-attribute', help=u"""Subject Mapping Attribute to which the value from subject claim name value would be used for identity lookup.

**SCIM++ Properties:**  - type: string  - multiValued: false  - idcsSearchable: false  - required: false  - mutability: readWrite  - returned: default  - uniqueness: none""")
@cli_util.option('--subject-type', type=custom_types.CliCaseInsensitiveChoice(["User", "App"]), help=u"""The type of the resource against which lookup will be made in the identity domain in IAM for the incoming subject claim value.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--client-claim-name', help=u"""The claim name that identifies to whom the JWT/SAML token is issued. If AWS, then \\\"aud\\\" or \\\"client_id\\\". If Azure, then \\\"appid\\\". If GCP, then \\\"aud\\\".

**SCIM++ Properties:**  - type: string  - multiValued: false  - required: false  - mutability: readWrite  - returned: default  - uniqueness: none  - idcsSearchable: false""")
@cli_util.option('--client-claim-values', type=custom_types.CLI_COMPLEX_TYPE, help=u"""The value that corresponds to the client claim name used to identify to whom the token is issued.

**SCIM++ Properties:**  - type: string  - multiValued: true  - required: false  - mutability: readWrite  - returned: default  - uniqueness: none  - caseExact: true  - idcsSearchable: false""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--active', type=click.BOOL, help=u"""If true, specifies that this Identity Propagation Trust is in an enabled state. The default value is false.

**SCIM++ Properties:**  - type: boolean  - multiValued: false  - required: false  - mutability: readWrite  - returned: default  - uniqueness: none  - idcsSearchable: true""")
@cli_util.option('--public-key-endpoint', help=u"""The cloud provider's public key API of SAML and OIDC providers for signature validation.

**SCIM++ Properties:**  - type: string  - multiValued: false  - required: false  - mutability: readWrite  - returned: default  - uniqueness: none  - caseExact: false  - idcsSearchable: false""")
@cli_util.option('--public-certificate', help=u"""Store the public key if public key cert.

**SCIM++ Properties:**  - type: string  - multiValued: false  - required: false  - mutability: readWrite  - returned: default  - uniqueness: none  - idcsSearchable: false""")
@cli_util.option('--oauth-clients', type=custom_types.CLI_COMPLEX_TYPE, help=u"""The value of all the authorized OAuth Clients.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--allow-impersonation', type=click.BOOL, help=u"""Allow customers to define whether the resulting token should contain the authenticated user as the subject or whether the token should impersonate another Application Principal in IAM.

**SCIM++ Properties:**  - type: boolean  - multiValued: false  - required: false  - mutability: readWrite  - returned: default  - uniqueness: none  - idcsSearchable: false""")
@cli_util.option('--clock-skew-seconds', type=click.INT, help=u"""The clock skew (in secs) that's allowed for the token issue and expiry time.

**Added In:** 2308181911

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: integer  - uniqueness: none""")
@cli_util.option('--impersonation-service-users', type=custom_types.CLI_COMPLEX_TYPE, help=u"""The Impersonating Principal.

**SCIM++ Properties:**  - idcsCompositeKey: [rule, value]  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type IdentityPropagationTrustImpersonationServiceUsers.  For documentation on IdentityPropagationTrustImpersonationServiceUsers please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/IdentityPropagationTrustImpersonationServiceUsers.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--keytab', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'client-claim-values': {'module': 'identity_domains', 'class': 'list[string]'}, 'oauth-clients': {'module': 'identity_domains', 'class': 'list[string]'}, 'impersonation-service-users': {'module': 'identity_domains', 'class': 'list[IdentityPropagationTrustImpersonationServiceUsers]'}, 'keytab': {'module': 'identity_domains', 'class': 'IdentityPropagationTrustKeytab'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'client-claim-values': {'module': 'identity_domains', 'class': 'list[string]'}, 'oauth-clients': {'module': 'identity_domains', 'class': 'list[string]'}, 'impersonation-service-users': {'module': 'identity_domains', 'class': 'list[IdentityPropagationTrustImpersonationServiceUsers]'}, 'keytab': {'module': 'identity_domains', 'class': 'IdentityPropagationTrustKeytab'}}, output_type={'module': 'identity_domains', 'class': 'IdentityPropagationTrust'})
@cli_util.wrap_exceptions
def create_identity_propagation_trust(ctx, from_json, schemas, name, type, issuer, authorization, resource_type_schema_version, attributes, attribute_sets, id, ocid, meta, idcs_created_by, idcs_last_modified_by, idcs_prevented_operations, tags, delete_in_progress, idcs_last_upgraded_in_release, domain_ocid, compartment_ocid, tenancy_ocid, description, account_id, subject_claim_name, subject_mapping_attribute, subject_type, client_claim_name, client_claim_values, active, public_key_endpoint, public_certificate, oauth_clients, allow_impersonation, clock_skew_seconds, impersonation_service_users, keytab):

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if attributes is not None:
        kwargs['attributes'] = attributes
    if attribute_sets is not None and len(attribute_sets) > 0:
        kwargs['attribute_sets'] = attribute_sets

    _details = {}
    _details['schemas'] = cli_util.parse_json_parameter("schemas", schemas)
    _details['name'] = name
    _details['type'] = type
    _details['issuer'] = issuer

    if id is not None:
        _details['id'] = id

    if ocid is not None:
        _details['ocid'] = ocid

    if meta is not None:
        _details['meta'] = cli_util.parse_json_parameter("meta", meta)

    if idcs_created_by is not None:
        _details['idcsCreatedBy'] = cli_util.parse_json_parameter("idcs_created_by", idcs_created_by)

    if idcs_last_modified_by is not None:
        _details['idcsLastModifiedBy'] = cli_util.parse_json_parameter("idcs_last_modified_by", idcs_last_modified_by)

    if idcs_prevented_operations is not None:
        _details['idcsPreventedOperations'] = cli_util.parse_json_parameter("idcs_prevented_operations", idcs_prevented_operations)

    if tags is not None:
        _details['tags'] = cli_util.parse_json_parameter("tags", tags)

    if delete_in_progress is not None:
        _details['deleteInProgress'] = delete_in_progress

    if idcs_last_upgraded_in_release is not None:
        _details['idcsLastUpgradedInRelease'] = idcs_last_upgraded_in_release

    if domain_ocid is not None:
        _details['domainOcid'] = domain_ocid

    if compartment_ocid is not None:
        _details['compartmentOcid'] = compartment_ocid

    if tenancy_ocid is not None:
        _details['tenancyOcid'] = tenancy_ocid

    if description is not None:
        _details['description'] = description

    if account_id is not None:
        _details['accountId'] = account_id

    if subject_claim_name is not None:
        _details['subjectClaimName'] = subject_claim_name

    if subject_mapping_attribute is not None:
        _details['subjectMappingAttribute'] = subject_mapping_attribute

    if subject_type is not None:
        _details['subjectType'] = subject_type

    if client_claim_name is not None:
        _details['clientClaimName'] = client_claim_name

    if client_claim_values is not None:
        _details['clientClaimValues'] = cli_util.parse_json_parameter("client_claim_values", client_claim_values)

    if active is not None:
        _details['active'] = active

    if public_key_endpoint is not None:
        _details['publicKeyEndpoint'] = public_key_endpoint

    if public_certificate is not None:
        _details['publicCertificate'] = public_certificate

    if oauth_clients is not None:
        _details['oauthClients'] = cli_util.parse_json_parameter("oauth_clients", oauth_clients)

    if allow_impersonation is not None:
        _details['allowImpersonation'] = allow_impersonation

    if clock_skew_seconds is not None:
        _details['clockSkewSeconds'] = clock_skew_seconds

    if impersonation_service_users is not None:
        _details['impersonationServiceUsers'] = cli_util.parse_json_parameter("impersonation_service_users", impersonation_service_users)

    if keytab is not None:
        _details['keytab'] = cli_util.parse_json_parameter("keytab", keytab)

    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.create_identity_propagation_trust(
        identity_propagation_trust=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@identity_provider_group.command(name=cli_util.override('identity_domains.create_identity_provider.command_name', 'create'), help=u"""Create an Identity Provider

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](createIdentityProvider)""")
@cli_util.option('--schemas', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--partner-name', required=True, help=u"""Unique name of the trusted Identity Provider.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: true  - returned: always  - type: string  - uniqueness: server""")
@cli_util.option('--enabled', required=True, type=click.BOOL, help=u"""Set to true to indicate Partner enabled.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: true  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--attributes', help=u"""A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.""")
@cli_util.option('--attribute-sets', type=custom_types.CliCaseInsensitiveChoice(["all", "always", "never", "request", "default"]), multiple=True, help=u"""A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.""")
@cli_util.option('--id', help=u"""Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--ocid', help=u"""Unique OCI identifier for the SCIM Resource.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: string  - uniqueness: global""")
@cli_util.option('--meta', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-created-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-last-modified-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-prevented-operations', type=custom_types.CliCaseInsensitiveChoice(["replace", "update", "delete"]), help=u"""Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of tags on this resource.

**SCIM++ Properties:**  - idcsCompositeKey: [key, value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type Tags.  For documentation on tags please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/Tags.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--delete-in-progress', type=click.BOOL, help=u"""A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--idcs-last-upgraded-in-release', help=u"""The release number when the resource was upgraded.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--domain-ocid', help=u"""OCI Domain Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--compartment-ocid', help=u"""OCI Compartment Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--tenancy-ocid', help=u"""OCI Tenant Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--external-id', help=u"""An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

**SCIM++ Properties:**  - caseExact: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--description', help=u"""Description

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--metadata', help=u"""Metadata

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--partner-provider-id', help=u"""Provider ID

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: server""")
@cli_util.option('--tenant-provider-id', help=u"""The alternate Provider ID to be used as the Oracle Identity Cloud Service providerID (instead of the one in SamlSettings) when interacting with this IdP.

**Added In:** 19.2.1

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--succinct-id', help=u"""Succinct ID

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: server""")
@cli_util.option('--idp-sso-url', help=u"""Identity Provider SSO URL

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--logout-request-url', help=u"""Logout request URL

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--logout-response-url', help=u"""Logout response URL

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--signing-certificate', help=u"""Signing certificate

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--encryption-certificate', help=u"""Encryption certificate

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--name-id-format', help=u"""Default authentication request name ID format.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--include-signing-cert-in-signature', type=click.BOOL, help=u"""Set to true to include the signing certificate in the signature.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--authn-request-binding', type=custom_types.CliCaseInsensitiveChoice(["Redirect", "Post"]), help=u"""HTTP binding to use for authentication requests.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--logout-binding', type=custom_types.CliCaseInsensitiveChoice(["Redirect", "Post"]), help=u"""HTTP binding to use for logout.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--logout-enabled', type=click.BOOL, help=u"""Set to true to enable logout.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--signature-hash-algorithm', type=custom_types.CliCaseInsensitiveChoice(["SHA-1", "SHA-256"]), help=u"""Signature hash algorithm.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--icon-url', help=u"""Identity Provider Icon URL.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--shown-on-login-page', type=click.BOOL, help=u"""Set to true to indicate whether to show IdP in login page or not.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--jit-user-prov-enabled', type=click.BOOL, help=u"""Set to true to indicate JIT User Provisioning is enabled

**Added In:** 20.1.3

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--jit-user-prov-group-assertion-attribute-enabled', type=click.BOOL, help=u"""Set to true to indicate JIT User Provisioning Groups should be assigned based on assertion attribute

**Added In:** 20.1.3

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--jit-user-prov-group-static-list-enabled', type=click.BOOL, help=u"""Set to true to indicate JIT User Provisioning Groups should be assigned from a static list

**Added In:** 20.1.3

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--jit-user-prov-create-user-enabled', type=click.BOOL, help=u"""Set to true to indicate JIT User Creation is enabled

**Added In:** 20.1.3

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--jit-user-prov-attribute-update-enabled', type=click.BOOL, help=u"""Set to true to indicate JIT User Creation is enabled

**Added In:** 20.1.3

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--jit-user-prov-group-assignment-method', type=custom_types.CliCaseInsensitiveChoice(["Overwrite", "Merge"]), help=u"""The default value is 'Overwrite', which tells Just-In-Time user-provisioning to replace any current group-assignments for a User with those assigned by assertions and/or those assigned statically. Specify 'Merge' if you want Just-In-Time user-provisioning to combine its group-assignments with those the user already has.

**Added In:** 20.1.3

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--jit-user-prov-group-mapping-mode', type=custom_types.CliCaseInsensitiveChoice(["implicit", "explicit"]), help=u"""Property to indicate the mode of group mapping

**Added In:** 2205120021

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--jit-user-prov-group-saml-attribute-name', help=u"""Name of the assertion attribute containing the users groups

**Added In:** 20.1.3

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--service-instance-identifier', help=u"""The serviceInstanceIdentifier of the App that hosts this IdP. This value will match the opcServiceInstanceGUID of any service-instance that the IdP represents.

**Added In:** 18.2.6

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: never  - type: string  - uniqueness: server""")
@cli_util.option('--user-mapping-method', type=custom_types.CliCaseInsensitiveChoice(["NameIDToUserAttribute", "AssertionAttributeToUserAttribute", "CorrelationPolicyRule"]), help=u"""User mapping method.

**Deprecated Since: 20.1.3**

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none  - idcsValuePersistedInOtherAttribute: true""")
@cli_util.option('--user-mapping-store-attribute', help=u"""This property specifies the userstore attribute value that must match the incoming assertion attribute value or the incoming nameid attribute value in order to identify the user during SSO.<br>You can construct the userMappingStoreAttribute value by specifying attributes from the Oracle Identity Cloud Service Core Users schema. For examples of how to construct the userMappingStoreAttribute value, see the <b>Example of a Request Body</b> section of the Examples tab for the <a href='./op-admin-v1-identityproviders-post.html'>POST</a> and <a href='./op-admin-v1-identityproviders-id-put.html'>PUT</a> methods of the /IdentityProviders endpoint.

**Deprecated Since: 20.1.3**

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none  - idcsValuePersistedInOtherAttribute: true""")
@cli_util.option('--assertion-attribute', help=u"""Assertion attribute name.

**Deprecated Since: 20.1.3**

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none  - idcsValuePersistedInOtherAttribute: true""")
@cli_util.option('--type', type=custom_types.CliCaseInsensitiveChoice(["SAML", "SOCIAL", "IWA", "X509", "LOCAL"]), help=u"""Identity Provider Type

**Added In:** 20.1.3

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: always  - type: string  - uniqueness: none""")
@cli_util.option('--require-force-authn', type=click.BOOL, help=u"""This SP requires requests SAML IdP to enforce re-authentication.

**Added In:** 2102181953

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--requires-encrypted-assertion', type=click.BOOL, help=u"""SAML SP must accept encrypted assertion only.

**Added In:** 2102181953

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--saml-ho-k-required', type=click.BOOL, help=u"""SAML SP HoK Enabled.

**Added In:** 2102181953

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--requested-authentication-context', type=custom_types.CLI_COMPLEX_TYPE, help=u"""SAML SP authentication type.

**Added In:** 2102181953

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--jit-user-prov-ignore-error-on-absent-groups', type=click.BOOL, help=u"""Set to true to indicate ignoring absence of group while provisioning

**Added In:** 2111112015

**SCIM++ Properties:**  - caseExact: false  - idcsAddedSinceVersion: 30  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--last-notification-sent-time', help=u"""Records the notification timestamp for the IdP whose signing certificate is about to expire

**Added In:** 2302092332

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: dateTime  - uniqueness: none""")
@cli_util.option('--jit-user-prov-group-mappings', type=custom_types.CLI_COMPLEX_TYPE, help=u"""The list of mappings between the Identity Domain Group and the IDP group.

**Added In:** 2205120021

**SCIM++ Properties:**  - idcsCompositeKey: [idpGroup]  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: complex  - uniqueness: none

This option is a JSON list with items of type IdentityProviderJitUserProvGroupMappings.  For documentation on IdentityProviderJitUserProvGroupMappings please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/IdentityProviderJitUserProvGroupMappings.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--jit-user-prov-attributes', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--jit-user-prov-assigned-groups', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Refers to every group of which a JIT-provisioned User should be a member.  Just-in-Time user-provisioning applies this static list when jitUserProvGroupStaticListEnabled:true.

**Added In:** 20.1.3

**SCIM++ Properties:**  - idcsCompositeKey: [value]  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: complex  - uniqueness: none

This option is a JSON list with items of type IdentityProviderJitUserProvAssignedGroups.  For documentation on IdentityProviderJitUserProvAssignedGroups please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/IdentityProviderJitUserProvAssignedGroups.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--correlation-policy', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionsocial-identity-provider', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionx509-identity-provider', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'requested-authentication-context': {'module': 'identity_domains', 'class': 'list[string]'}, 'jit-user-prov-group-mappings': {'module': 'identity_domains', 'class': 'list[IdentityProviderJitUserProvGroupMappings]'}, 'jit-user-prov-attributes': {'module': 'identity_domains', 'class': 'IdentityProviderJitUserProvAttributes'}, 'jit-user-prov-assigned-groups': {'module': 'identity_domains', 'class': 'list[IdentityProviderJitUserProvAssignedGroups]'}, 'correlation-policy': {'module': 'identity_domains', 'class': 'IdentityProviderCorrelationPolicy'}, 'urnietfparamsscimschemasoracleidcsextensionsocial-identity-provider': {'module': 'identity_domains', 'class': 'ExtensionSocialIdentityProvider'}, 'urnietfparamsscimschemasoracleidcsextensionx509-identity-provider': {'module': 'identity_domains', 'class': 'ExtensionX509IdentityProvider'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'requested-authentication-context': {'module': 'identity_domains', 'class': 'list[string]'}, 'jit-user-prov-group-mappings': {'module': 'identity_domains', 'class': 'list[IdentityProviderJitUserProvGroupMappings]'}, 'jit-user-prov-attributes': {'module': 'identity_domains', 'class': 'IdentityProviderJitUserProvAttributes'}, 'jit-user-prov-assigned-groups': {'module': 'identity_domains', 'class': 'list[IdentityProviderJitUserProvAssignedGroups]'}, 'correlation-policy': {'module': 'identity_domains', 'class': 'IdentityProviderCorrelationPolicy'}, 'urnietfparamsscimschemasoracleidcsextensionsocial-identity-provider': {'module': 'identity_domains', 'class': 'ExtensionSocialIdentityProvider'}, 'urnietfparamsscimschemasoracleidcsextensionx509-identity-provider': {'module': 'identity_domains', 'class': 'ExtensionX509IdentityProvider'}}, output_type={'module': 'identity_domains', 'class': 'IdentityProvider'})
@cli_util.wrap_exceptions
def create_identity_provider(ctx, from_json, schemas, partner_name, enabled, authorization, resource_type_schema_version, attributes, attribute_sets, id, ocid, meta, idcs_created_by, idcs_last_modified_by, idcs_prevented_operations, tags, delete_in_progress, idcs_last_upgraded_in_release, domain_ocid, compartment_ocid, tenancy_ocid, external_id, description, metadata, partner_provider_id, tenant_provider_id, succinct_id, idp_sso_url, logout_request_url, logout_response_url, signing_certificate, encryption_certificate, name_id_format, include_signing_cert_in_signature, authn_request_binding, logout_binding, logout_enabled, signature_hash_algorithm, icon_url, shown_on_login_page, jit_user_prov_enabled, jit_user_prov_group_assertion_attribute_enabled, jit_user_prov_group_static_list_enabled, jit_user_prov_create_user_enabled, jit_user_prov_attribute_update_enabled, jit_user_prov_group_assignment_method, jit_user_prov_group_mapping_mode, jit_user_prov_group_saml_attribute_name, service_instance_identifier, user_mapping_method, user_mapping_store_attribute, assertion_attribute, type, require_force_authn, requires_encrypted_assertion, saml_ho_k_required, requested_authentication_context, jit_user_prov_ignore_error_on_absent_groups, last_notification_sent_time, jit_user_prov_group_mappings, jit_user_prov_attributes, jit_user_prov_assigned_groups, correlation_policy, urnietfparamsscimschemasoracleidcsextensionsocial_identity_provider, urnietfparamsscimschemasoracleidcsextensionx509_identity_provider):

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if attributes is not None:
        kwargs['attributes'] = attributes
    if attribute_sets is not None and len(attribute_sets) > 0:
        kwargs['attribute_sets'] = attribute_sets

    _details = {}
    _details['schemas'] = cli_util.parse_json_parameter("schemas", schemas)
    _details['partnerName'] = partner_name
    _details['enabled'] = enabled

    if id is not None:
        _details['id'] = id

    if ocid is not None:
        _details['ocid'] = ocid

    if meta is not None:
        _details['meta'] = cli_util.parse_json_parameter("meta", meta)

    if idcs_created_by is not None:
        _details['idcsCreatedBy'] = cli_util.parse_json_parameter("idcs_created_by", idcs_created_by)

    if idcs_last_modified_by is not None:
        _details['idcsLastModifiedBy'] = cli_util.parse_json_parameter("idcs_last_modified_by", idcs_last_modified_by)

    if idcs_prevented_operations is not None:
        _details['idcsPreventedOperations'] = cli_util.parse_json_parameter("idcs_prevented_operations", idcs_prevented_operations)

    if tags is not None:
        _details['tags'] = cli_util.parse_json_parameter("tags", tags)

    if delete_in_progress is not None:
        _details['deleteInProgress'] = delete_in_progress

    if idcs_last_upgraded_in_release is not None:
        _details['idcsLastUpgradedInRelease'] = idcs_last_upgraded_in_release

    if domain_ocid is not None:
        _details['domainOcid'] = domain_ocid

    if compartment_ocid is not None:
        _details['compartmentOcid'] = compartment_ocid

    if tenancy_ocid is not None:
        _details['tenancyOcid'] = tenancy_ocid

    if external_id is not None:
        _details['externalId'] = external_id

    if description is not None:
        _details['description'] = description

    if metadata is not None:
        _details['metadata'] = metadata

    if partner_provider_id is not None:
        _details['partnerProviderId'] = partner_provider_id

    if tenant_provider_id is not None:
        _details['tenantProviderId'] = tenant_provider_id

    if succinct_id is not None:
        _details['succinctId'] = succinct_id

    if idp_sso_url is not None:
        _details['idpSsoUrl'] = idp_sso_url

    if logout_request_url is not None:
        _details['logoutRequestUrl'] = logout_request_url

    if logout_response_url is not None:
        _details['logoutResponseUrl'] = logout_response_url

    if signing_certificate is not None:
        _details['signingCertificate'] = signing_certificate

    if encryption_certificate is not None:
        _details['encryptionCertificate'] = encryption_certificate

    if name_id_format is not None:
        _details['nameIdFormat'] = name_id_format

    if include_signing_cert_in_signature is not None:
        _details['includeSigningCertInSignature'] = include_signing_cert_in_signature

    if authn_request_binding is not None:
        _details['authnRequestBinding'] = authn_request_binding

    if logout_binding is not None:
        _details['logoutBinding'] = logout_binding

    if logout_enabled is not None:
        _details['logoutEnabled'] = logout_enabled

    if signature_hash_algorithm is not None:
        _details['signatureHashAlgorithm'] = signature_hash_algorithm

    if icon_url is not None:
        _details['iconUrl'] = icon_url

    if shown_on_login_page is not None:
        _details['shownOnLoginPage'] = shown_on_login_page

    if jit_user_prov_enabled is not None:
        _details['jitUserProvEnabled'] = jit_user_prov_enabled

    if jit_user_prov_group_assertion_attribute_enabled is not None:
        _details['jitUserProvGroupAssertionAttributeEnabled'] = jit_user_prov_group_assertion_attribute_enabled

    if jit_user_prov_group_static_list_enabled is not None:
        _details['jitUserProvGroupStaticListEnabled'] = jit_user_prov_group_static_list_enabled

    if jit_user_prov_create_user_enabled is not None:
        _details['jitUserProvCreateUserEnabled'] = jit_user_prov_create_user_enabled

    if jit_user_prov_attribute_update_enabled is not None:
        _details['jitUserProvAttributeUpdateEnabled'] = jit_user_prov_attribute_update_enabled

    if jit_user_prov_group_assignment_method is not None:
        _details['jitUserProvGroupAssignmentMethod'] = jit_user_prov_group_assignment_method

    if jit_user_prov_group_mapping_mode is not None:
        _details['jitUserProvGroupMappingMode'] = jit_user_prov_group_mapping_mode

    if jit_user_prov_group_saml_attribute_name is not None:
        _details['jitUserProvGroupSAMLAttributeName'] = jit_user_prov_group_saml_attribute_name

    if service_instance_identifier is not None:
        _details['serviceInstanceIdentifier'] = service_instance_identifier

    if user_mapping_method is not None:
        _details['userMappingMethod'] = user_mapping_method

    if user_mapping_store_attribute is not None:
        _details['userMappingStoreAttribute'] = user_mapping_store_attribute

    if assertion_attribute is not None:
        _details['assertionAttribute'] = assertion_attribute

    if type is not None:
        _details['type'] = type

    if require_force_authn is not None:
        _details['requireForceAuthn'] = require_force_authn

    if requires_encrypted_assertion is not None:
        _details['requiresEncryptedAssertion'] = requires_encrypted_assertion

    if saml_ho_k_required is not None:
        _details['samlHoKRequired'] = saml_ho_k_required

    if requested_authentication_context is not None:
        _details['requestedAuthenticationContext'] = cli_util.parse_json_parameter("requested_authentication_context", requested_authentication_context)

    if jit_user_prov_ignore_error_on_absent_groups is not None:
        _details['jitUserProvIgnoreErrorOnAbsentGroups'] = jit_user_prov_ignore_error_on_absent_groups

    if last_notification_sent_time is not None:
        _details['lastNotificationSentTime'] = last_notification_sent_time

    if jit_user_prov_group_mappings is not None:
        _details['jitUserProvGroupMappings'] = cli_util.parse_json_parameter("jit_user_prov_group_mappings", jit_user_prov_group_mappings)

    if jit_user_prov_attributes is not None:
        _details['jitUserProvAttributes'] = cli_util.parse_json_parameter("jit_user_prov_attributes", jit_user_prov_attributes)

    if jit_user_prov_assigned_groups is not None:
        _details['jitUserProvAssignedGroups'] = cli_util.parse_json_parameter("jit_user_prov_assigned_groups", jit_user_prov_assigned_groups)

    if correlation_policy is not None:
        _details['correlationPolicy'] = cli_util.parse_json_parameter("correlation_policy", correlation_policy)

    if urnietfparamsscimschemasoracleidcsextensionsocial_identity_provider is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:social:IdentityProvider'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionsocial_identity_provider", urnietfparamsscimschemasoracleidcsextensionsocial_identity_provider)

    if urnietfparamsscimschemasoracleidcsextensionx509_identity_provider is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:x509:IdentityProvider'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionx509_identity_provider", urnietfparamsscimschemasoracleidcsextensionx509_identity_provider)

    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.create_identity_provider(
        identity_provider=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@me_group.command(name=cli_util.override('identity_domains.create_me.command_name', 'create'), help=u"""Self register a user.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](createMe)""")
@cli_util.option('--schemas', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--user-name', required=True, help=u"""User name

**SCIM++ Properties:**  - caseExact: false  - idcsCsvAttributeName: User ID  - idcsCsvAttributeNameMappings: [[columnHeaderName:User Name, deprecatedColumnHeaderName:User ID]]  - idcsPii: true  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: true  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--attributes', help=u"""A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.""")
@cli_util.option('--attribute-sets', type=custom_types.CliCaseInsensitiveChoice(["all", "always", "never", "request", "default"]), multiple=True, help=u"""A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.""")
@cli_util.option('--id', help=u"""Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--ocid', help=u"""Unique OCI identifier for the SCIM Resource.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: string  - uniqueness: global""")
@cli_util.option('--meta', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-created-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-last-modified-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-prevented-operations', type=custom_types.CliCaseInsensitiveChoice(["replace", "update", "delete"]), help=u"""Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of tags on this resource.

**SCIM++ Properties:**  - idcsCompositeKey: [key, value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type Tags.  For documentation on tags please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/Tags.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--delete-in-progress', type=click.BOOL, help=u"""A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--idcs-last-upgraded-in-release', help=u"""The release number when the resource was upgraded.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--domain-ocid', help=u"""OCI Domain Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--compartment-ocid', help=u"""OCI Compartment Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--tenancy-ocid', help=u"""OCI Tenant Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--external-id', help=u"""An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

**SCIM++ Properties:**  - caseExact: false  - idcsCsvAttributeNameMappings: [[columnHeaderName:External Id]]  - idcsPii: true  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--description', help=u"""Description of the user

**Added In:** 2012271618

**SCIM++ Properties:**  - caseExact: false  - idcsPii: true  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--display-name', help=u"""Display name

**SCIM++ Properties:**  - caseExact: false  - idcsCsvAttributeName: Display Name  - idcsCsvAttributeNameMappings: [[columnHeaderName:Display Name]]  - idcsPii: true  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--nick-name', help=u"""Nick name

**SCIM++ Properties:**  - caseExact: false  - idcsCsvAttributeName: Nick Name  - idcsCsvAttributeNameMappings: [[columnHeaderName:Nick Name]]  - idcsPii: true  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--profile-url', help=u"""A fully-qualified URL to a page representing the User's online profile

**SCIM++ Properties:**  - caseExact: false  - idcsCsvAttributeName: Profile URL  - idcsCsvAttributeNameMappings: [[columnHeaderName:Profile Url]]  - idcsPii: true  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: reference  - uniqueness: none""")
@cli_util.option('--title', help=u"""Title

**SCIM++ Properties:**  - caseExact: false  - idcsCsvAttributeName: Title  - idcsCsvAttributeNameMappings: [[columnHeaderName:Title]]  - idcsPii: true  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--user-type', type=custom_types.CliCaseInsensitiveChoice(["Contractor", "Employee", "Intern", "Temp", "External", "Service", "Generic"]), help=u"""Used to identify the organization-to-user relationship

**SCIM++ Properties:**  - caseExact: false  - idcsCsvAttributeName: User Type  - idcsCsvAttributeNameMappings: [[columnHeaderName:User Type]]  - idcsPii: true  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--locale', help=u"""Used to indicate the User's default location for purposes of localizing items such as currency, date and time format, numerical representations, and so on.

**SCIM++ Properties:**  - caseExact: false  - idcsCsvAttributeName: Locale  - idcsCsvAttributeNameMappings: [[columnHeaderName:Locale]]  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--preferred-language', help=u"""User's preferred written or spoken language used for localized user interfaces

**SCIM++ Properties:**  - caseExact: false  - idcsCsvAttributeName: Preferred Language  - idcsCsvAttributeNameMappings: [[columnHeaderName:Preferred Language]]  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--timezone', help=u"""User's timezone

**SCIM++ Properties:**  - caseExact: false  - idcsCanonicalValueSourceFilter: attrName eq \"timezones\" and attrValues.value eq \"$(timezone)\"  - idcsCanonicalValueSourceResourceType: AllowedValue  - idcsCsvAttributeName: TimeZone  - idcsCsvAttributeNameMappings: [[columnHeaderName:Time Zone, deprecatedColumnHeaderName:TimeZone]]  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--active', type=click.BOOL, help=u"""User status

**SCIM++ Properties:**  - caseExact: false  - idcsCsvAttributeName: Active  - idcsCsvAttributeNameMappings: [[columnHeaderName:Active]]  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--password', help=u"""Password attribute. Max length for password is controlled via Password Policy.

**SCIM++ Properties:**  - idcsCsvAttributeName: Password  - idcsCsvAttributeNameMappings: [[columnHeaderName:Password]]  - idcsPii: true  - idcsSearchable: false  - idcsSensitive: hash  - multiValued: false  - mutability: writeOnly  - required: false  - returned: never  - type: string  - uniqueness: none""")
@cli_util.option('--name', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--emails', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A complex attribute representing emails

**SCIM++ Properties:**  - idcsCompositeKey: [value, type]  - idcsCsvAttributeNameMappings: [[columnHeaderName:Work Email, mapsTo:emails[work].value], [columnHeaderName:Home Email, mapsTo:emails[home].value], [columnHeaderName:Primary Email Type, mapsTo:emails[$(type)].primary], [columnHeaderName:Other Email, mapsTo:emails[other].value], [columnHeaderName:Recovery Email, mapsTo:emails[recovery].value], [columnHeaderName:Work Email Verified, mapsTo:emails[work].verified], [columnHeaderName:Home Email Verified, mapsTo:emails[home].verified], [columnHeaderName:Other Email Verified, mapsTo:emails[other].verified], [columnHeaderName:Recovery Email Verified, mapsTo:emails[recovery].verified]]  - idcsPii: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: complex  - uniqueness: none

This option is a JSON list with items of type MeEmails.  For documentation on MeEmails please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/MeEmails.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--phone-numbers', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Phone numbers

**SCIM++ Properties:**  - idcsCompositeKey: [value, type]  - idcsCsvAttributeNameMappings: [[columnHeaderName:Work Phone, mapsTo:phoneNumbers[work].value], [columnHeaderName:Mobile No, mapsTo:phoneNumbers[mobile].value], [columnHeaderName:Home Phone, mapsTo:phoneNumbers[home].value], [columnHeaderName:Fax, mapsTo:phoneNumbers[fax].value], [columnHeaderName:Pager, mapsTo:phoneNumbers[pager].value], [columnHeaderName:Other Phone, mapsTo:phoneNumbers[other].value], [columnHeaderName:Recovery Phone, mapsTo:phoneNumbers[recovery].value], [columnHeaderName:Primary Phone Type, mapsTo:phoneNumbers[$(type)].primary]]  - idcsPii: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: complex  - uniqueness: none

This option is a JSON list with items of type MePhoneNumbers.  For documentation on MePhoneNumbers please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/MePhoneNumbers.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--ims', type=custom_types.CLI_COMPLEX_TYPE, help=u"""User's instant messaging addresses

**SCIM++ Properties:**  - idcsCompositeKey: [value, type]  - idcsPii: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: complex  - uniqueness: none

This option is a JSON list with items of type MeIms.  For documentation on MeIms please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/MeIms.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--photos', type=custom_types.CLI_COMPLEX_TYPE, help=u"""URLs of photos for the User

**SCIM++ Properties:**  - idcsCompositeKey: [value, type]  - idcsPii: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: complex  - uniqueness: none

This option is a JSON list with items of type MePhotos.  For documentation on MePhotos please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/MePhotos.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--addresses', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A physical mailing address for this User, as described in (address Element). Canonical Type Values of work, home, and other. The value attribute is a complex type with the following sub-attributes.

**SCIM++ Properties:**  - idcsCompositeKey: [type]  - idcsCsvAttributeNameMappings: [[columnHeaderName:Work Address Street, deprecatedColumnHeaderName:Work Street Address, mapsTo:addresses[work].streetAddress], [columnHeaderName:Work Address Locality, deprecatedColumnHeaderName:Work City, mapsTo:addresses[work].locality], [columnHeaderName:Work Address Region, deprecatedColumnHeaderName:Work State, mapsTo:addresses[work].region], [columnHeaderName:Work Address Postal Code, deprecatedColumnHeaderName:Work Postal Code, mapsTo:addresses[work].postalCode], [columnHeaderName:Work Address Country, deprecatedColumnHeaderName:Work Country, mapsTo:addresses[work].country], [columnHeaderName:Work Address Formatted, mapsTo:addresses[work].formatted], [columnHeaderName:Home Address Formatted, mapsTo:addresses[home].formatted], [columnHeaderName:Other Address Formatted, mapsTo:addresses[other].formatted], [columnHeaderName:Home Address Street, mapsTo:addresses[home].streetAddress], [columnHeaderName:Other Address Street, mapsTo:addresses[other].streetAddress], [columnHeaderName:Home Address Locality, mapsTo:addresses[home].locality], [columnHeaderName:Other Address Locality, mapsTo:addresses[other].locality], [columnHeaderName:Home Address Region, mapsTo:addresses[home].region], [columnHeaderName:Other Address Region, mapsTo:addresses[other].region], [columnHeaderName:Home Address Country, mapsTo:addresses[home].country], [columnHeaderName:Other Address Country, mapsTo:addresses[other].country], [columnHeaderName:Home Address Postal Code, mapsTo:addresses[home].postalCode], [columnHeaderName:Other Address Postal Code, mapsTo:addresses[other].postalCode], [columnHeaderName:Primary Address Type, mapsTo:addresses[$(type)].primary]]  - idcsPii: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: complex  - uniqueness: none

This option is a JSON list with items of type Addresses.  For documentation on addresses please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/Addresses.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--groups', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of groups that the user belongs to, either thorough direct membership, nested groups, or dynamically calculated

**SCIM++ Properties:**  - idcsCompositeKey: [value]  - idcsSearchable: true  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type MeGroups.  For documentation on MeGroups please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/MeGroups.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--entitlements', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of entitlements for the User that represent a thing the User has.

**SCIM++ Properties:**  - idcsCompositeKey: [value, type]  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: complex  - uniqueness: none

This option is a JSON list with items of type MeEntitlements.  For documentation on MeEntitlements please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/MeEntitlements.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--roles', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of roles for the User that collectively represent who the User is; e.g., 'Student', 'Faculty'.

**SCIM++ Properties:**  - idcsCompositeKey: [value, type]  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: complex  - uniqueness: none

This option is a JSON list with items of type MeRoles.  For documentation on MeRoles please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/MeRoles.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--x509-certificates', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of certificates issued to the User.

**SCIM++ Properties:**  - idcsCompositeKey: [value]  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: complex  - uniqueness: none

This option is a JSON list with items of type MeX509Certificates.  For documentation on MeX509Certificates please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/MeX509Certificates.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasextensionenterprise2-0-user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionuser-user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionpassword-state-user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionuser-state-user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionme-user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionposix-user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionmfa-user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionsecurity-questions-user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionself-registration-user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionterms-of-use-user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextension-oci-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionuser-credentials-user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensioncapabilities-user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensiondb-credentials-user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'name': {'module': 'identity_domains', 'class': 'MeName'}, 'emails': {'module': 'identity_domains', 'class': 'list[MeEmails]'}, 'phone-numbers': {'module': 'identity_domains', 'class': 'list[MePhoneNumbers]'}, 'ims': {'module': 'identity_domains', 'class': 'list[MeIms]'}, 'photos': {'module': 'identity_domains', 'class': 'list[MePhotos]'}, 'addresses': {'module': 'identity_domains', 'class': 'list[Addresses]'}, 'groups': {'module': 'identity_domains', 'class': 'list[MeGroups]'}, 'entitlements': {'module': 'identity_domains', 'class': 'list[MeEntitlements]'}, 'roles': {'module': 'identity_domains', 'class': 'list[MeRoles]'}, 'x509-certificates': {'module': 'identity_domains', 'class': 'list[MeX509Certificates]'}, 'urnietfparamsscimschemasextensionenterprise2-0-user': {'module': 'identity_domains', 'class': 'ExtensionEnterprise20User'}, 'urnietfparamsscimschemasoracleidcsextensionuser-user': {'module': 'identity_domains', 'class': 'ExtensionUserUser'}, 'urnietfparamsscimschemasoracleidcsextensionpassword-state-user': {'module': 'identity_domains', 'class': 'ExtensionPasswordStateUser'}, 'urnietfparamsscimschemasoracleidcsextensionuser-state-user': {'module': 'identity_domains', 'class': 'ExtensionUserStateUser'}, 'urnietfparamsscimschemasoracleidcsextensionme-user': {'module': 'identity_domains', 'class': 'ExtensionMeUser'}, 'urnietfparamsscimschemasoracleidcsextensionposix-user': {'module': 'identity_domains', 'class': 'ExtensionPosixUser'}, 'urnietfparamsscimschemasoracleidcsextensionmfa-user': {'module': 'identity_domains', 'class': 'ExtensionMfaUser'}, 'urnietfparamsscimschemasoracleidcsextensionsecurity-questions-user': {'module': 'identity_domains', 'class': 'ExtensionSecurityQuestionsUser'}, 'urnietfparamsscimschemasoracleidcsextensionself-registration-user': {'module': 'identity_domains', 'class': 'ExtensionSelfRegistrationUser'}, 'urnietfparamsscimschemasoracleidcsextensionterms-of-use-user': {'module': 'identity_domains', 'class': 'ExtensionTermsOfUseUser'}, 'urnietfparamsscimschemasoracleidcsextension-oci-tags': {'module': 'identity_domains', 'class': 'ExtensionOCITags'}, 'urnietfparamsscimschemasoracleidcsextensionuser-credentials-user': {'module': 'identity_domains', 'class': 'ExtensionUserCredentialsUser'}, 'urnietfparamsscimschemasoracleidcsextensioncapabilities-user': {'module': 'identity_domains', 'class': 'ExtensionCapabilitiesUser'}, 'urnietfparamsscimschemasoracleidcsextensiondb-credentials-user': {'module': 'identity_domains', 'class': 'ExtensionDbCredentialsUser'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'name': {'module': 'identity_domains', 'class': 'MeName'}, 'emails': {'module': 'identity_domains', 'class': 'list[MeEmails]'}, 'phone-numbers': {'module': 'identity_domains', 'class': 'list[MePhoneNumbers]'}, 'ims': {'module': 'identity_domains', 'class': 'list[MeIms]'}, 'photos': {'module': 'identity_domains', 'class': 'list[MePhotos]'}, 'addresses': {'module': 'identity_domains', 'class': 'list[Addresses]'}, 'groups': {'module': 'identity_domains', 'class': 'list[MeGroups]'}, 'entitlements': {'module': 'identity_domains', 'class': 'list[MeEntitlements]'}, 'roles': {'module': 'identity_domains', 'class': 'list[MeRoles]'}, 'x509-certificates': {'module': 'identity_domains', 'class': 'list[MeX509Certificates]'}, 'urnietfparamsscimschemasextensionenterprise2-0-user': {'module': 'identity_domains', 'class': 'ExtensionEnterprise20User'}, 'urnietfparamsscimschemasoracleidcsextensionuser-user': {'module': 'identity_domains', 'class': 'ExtensionUserUser'}, 'urnietfparamsscimschemasoracleidcsextensionpassword-state-user': {'module': 'identity_domains', 'class': 'ExtensionPasswordStateUser'}, 'urnietfparamsscimschemasoracleidcsextensionuser-state-user': {'module': 'identity_domains', 'class': 'ExtensionUserStateUser'}, 'urnietfparamsscimschemasoracleidcsextensionme-user': {'module': 'identity_domains', 'class': 'ExtensionMeUser'}, 'urnietfparamsscimschemasoracleidcsextensionposix-user': {'module': 'identity_domains', 'class': 'ExtensionPosixUser'}, 'urnietfparamsscimschemasoracleidcsextensionmfa-user': {'module': 'identity_domains', 'class': 'ExtensionMfaUser'}, 'urnietfparamsscimschemasoracleidcsextensionsecurity-questions-user': {'module': 'identity_domains', 'class': 'ExtensionSecurityQuestionsUser'}, 'urnietfparamsscimschemasoracleidcsextensionself-registration-user': {'module': 'identity_domains', 'class': 'ExtensionSelfRegistrationUser'}, 'urnietfparamsscimschemasoracleidcsextensionterms-of-use-user': {'module': 'identity_domains', 'class': 'ExtensionTermsOfUseUser'}, 'urnietfparamsscimschemasoracleidcsextension-oci-tags': {'module': 'identity_domains', 'class': 'ExtensionOCITags'}, 'urnietfparamsscimschemasoracleidcsextensionuser-credentials-user': {'module': 'identity_domains', 'class': 'ExtensionUserCredentialsUser'}, 'urnietfparamsscimschemasoracleidcsextensioncapabilities-user': {'module': 'identity_domains', 'class': 'ExtensionCapabilitiesUser'}, 'urnietfparamsscimschemasoracleidcsextensiondb-credentials-user': {'module': 'identity_domains', 'class': 'ExtensionDbCredentialsUser'}}, output_type={'module': 'identity_domains', 'class': 'Me'})
@cli_util.wrap_exceptions
def create_me(ctx, from_json, schemas, user_name, authorization, resource_type_schema_version, attributes, attribute_sets, id, ocid, meta, idcs_created_by, idcs_last_modified_by, idcs_prevented_operations, tags, delete_in_progress, idcs_last_upgraded_in_release, domain_ocid, compartment_ocid, tenancy_ocid, external_id, description, display_name, nick_name, profile_url, title, user_type, locale, preferred_language, timezone, active, password, name, emails, phone_numbers, ims, photos, addresses, groups, entitlements, roles, x509_certificates, urnietfparamsscimschemasextensionenterprise2_0_user, urnietfparamsscimschemasoracleidcsextensionuser_user, urnietfparamsscimschemasoracleidcsextensionpassword_state_user, urnietfparamsscimschemasoracleidcsextensionuser_state_user, urnietfparamsscimschemasoracleidcsextensionme_user, urnietfparamsscimschemasoracleidcsextensionposix_user, urnietfparamsscimschemasoracleidcsextensionmfa_user, urnietfparamsscimschemasoracleidcsextensionsecurity_questions_user, urnietfparamsscimschemasoracleidcsextensionself_registration_user, urnietfparamsscimschemasoracleidcsextensionterms_of_use_user, urnietfparamsscimschemasoracleidcsextension_oci_tags, urnietfparamsscimschemasoracleidcsextensionuser_credentials_user, urnietfparamsscimschemasoracleidcsextensioncapabilities_user, urnietfparamsscimschemasoracleidcsextensiondb_credentials_user):

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if attributes is not None:
        kwargs['attributes'] = attributes
    if attribute_sets is not None and len(attribute_sets) > 0:
        kwargs['attribute_sets'] = attribute_sets

    _details = {}
    _details['schemas'] = cli_util.parse_json_parameter("schemas", schemas)
    _details['userName'] = user_name

    if id is not None:
        _details['id'] = id

    if ocid is not None:
        _details['ocid'] = ocid

    if meta is not None:
        _details['meta'] = cli_util.parse_json_parameter("meta", meta)

    if idcs_created_by is not None:
        _details['idcsCreatedBy'] = cli_util.parse_json_parameter("idcs_created_by", idcs_created_by)

    if idcs_last_modified_by is not None:
        _details['idcsLastModifiedBy'] = cli_util.parse_json_parameter("idcs_last_modified_by", idcs_last_modified_by)

    if idcs_prevented_operations is not None:
        _details['idcsPreventedOperations'] = cli_util.parse_json_parameter("idcs_prevented_operations", idcs_prevented_operations)

    if tags is not None:
        _details['tags'] = cli_util.parse_json_parameter("tags", tags)

    if delete_in_progress is not None:
        _details['deleteInProgress'] = delete_in_progress

    if idcs_last_upgraded_in_release is not None:
        _details['idcsLastUpgradedInRelease'] = idcs_last_upgraded_in_release

    if domain_ocid is not None:
        _details['domainOcid'] = domain_ocid

    if compartment_ocid is not None:
        _details['compartmentOcid'] = compartment_ocid

    if tenancy_ocid is not None:
        _details['tenancyOcid'] = tenancy_ocid

    if external_id is not None:
        _details['externalId'] = external_id

    if description is not None:
        _details['description'] = description

    if display_name is not None:
        _details['displayName'] = display_name

    if nick_name is not None:
        _details['nickName'] = nick_name

    if profile_url is not None:
        _details['profileUrl'] = profile_url

    if title is not None:
        _details['title'] = title

    if user_type is not None:
        _details['userType'] = user_type

    if locale is not None:
        _details['locale'] = locale

    if preferred_language is not None:
        _details['preferredLanguage'] = preferred_language

    if timezone is not None:
        _details['timezone'] = timezone

    if active is not None:
        _details['active'] = active

    if password is not None:
        _details['password'] = password

    if name is not None:
        _details['name'] = cli_util.parse_json_parameter("name", name)

    if emails is not None:
        _details['emails'] = cli_util.parse_json_parameter("emails", emails)

    if phone_numbers is not None:
        _details['phoneNumbers'] = cli_util.parse_json_parameter("phone_numbers", phone_numbers)

    if ims is not None:
        _details['ims'] = cli_util.parse_json_parameter("ims", ims)

    if photos is not None:
        _details['photos'] = cli_util.parse_json_parameter("photos", photos)

    if addresses is not None:
        _details['addresses'] = cli_util.parse_json_parameter("addresses", addresses)

    if groups is not None:
        _details['groups'] = cli_util.parse_json_parameter("groups", groups)

    if entitlements is not None:
        _details['entitlements'] = cli_util.parse_json_parameter("entitlements", entitlements)

    if roles is not None:
        _details['roles'] = cli_util.parse_json_parameter("roles", roles)

    if x509_certificates is not None:
        _details['x509Certificates'] = cli_util.parse_json_parameter("x509_certificates", x509_certificates)

    if urnietfparamsscimschemasextensionenterprise2_0_user is not None:
        _details['urn:ietf:params:scim:schemas:extension:enterprise:2.0:User'] = cli_util.parse_json_parameter("urnietfparamsscimschemasextensionenterprise2_0_user", urnietfparamsscimschemasextensionenterprise2_0_user)

    if urnietfparamsscimschemasoracleidcsextensionuser_user is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:user:User'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionuser_user", urnietfparamsscimschemasoracleidcsextensionuser_user)

    if urnietfparamsscimschemasoracleidcsextensionpassword_state_user is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:passwordState:User'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionpassword_state_user", urnietfparamsscimschemasoracleidcsextensionpassword_state_user)

    if urnietfparamsscimschemasoracleidcsextensionuser_state_user is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:userState:User'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionuser_state_user", urnietfparamsscimschemasoracleidcsextensionuser_state_user)

    if urnietfparamsscimschemasoracleidcsextensionme_user is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:me:User'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionme_user", urnietfparamsscimschemasoracleidcsextensionme_user)

    if urnietfparamsscimschemasoracleidcsextensionposix_user is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:posix:User'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionposix_user", urnietfparamsscimschemasoracleidcsextensionposix_user)

    if urnietfparamsscimschemasoracleidcsextensionmfa_user is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:mfa:User'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionmfa_user", urnietfparamsscimschemasoracleidcsextensionmfa_user)

    if urnietfparamsscimschemasoracleidcsextensionsecurity_questions_user is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:securityQuestions:User'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionsecurity_questions_user", urnietfparamsscimschemasoracleidcsextensionsecurity_questions_user)

    if urnietfparamsscimschemasoracleidcsextensionself_registration_user is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:selfRegistration:User'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionself_registration_user", urnietfparamsscimschemasoracleidcsextensionself_registration_user)

    if urnietfparamsscimschemasoracleidcsextensionterms_of_use_user is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:termsOfUse:User'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionterms_of_use_user", urnietfparamsscimschemasoracleidcsextensionterms_of_use_user)

    if urnietfparamsscimschemasoracleidcsextension_oci_tags is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:OCITags'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextension_oci_tags", urnietfparamsscimschemasoracleidcsextension_oci_tags)

    if urnietfparamsscimschemasoracleidcsextensionuser_credentials_user is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:userCredentials:User'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionuser_credentials_user", urnietfparamsscimschemasoracleidcsextensionuser_credentials_user)

    if urnietfparamsscimschemasoracleidcsextensioncapabilities_user is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:capabilities:User'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensioncapabilities_user", urnietfparamsscimschemasoracleidcsextensioncapabilities_user)

    if urnietfparamsscimschemasoracleidcsextensiondb_credentials_user is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:dbCredentials:User'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensiondb_credentials_user", urnietfparamsscimschemasoracleidcsextensiondb_credentials_user)

    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.create_me(
        me=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@my_api_key_group.command(name=cli_util.override('identity_domains.create_my_api_key.command_name', 'create'), help=u"""Add a user's own API key.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](createMyApiKey)""")
@cli_util.option('--schemas', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--fingerprint', required=True, help=u"""Fingerprint

**Added In:** 2010242156

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - type: string  - mutability: readOnly  - required: true  - returned: default""")
@cli_util.option('--key', required=True, help=u"""Key

**Added In:** 2010242156

**SCIM++ Properties:**  - caseExact: true  - idcsPii: true  - type: string  - mutability: immutable  - required: true  - returned: default""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--id', help=u"""Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--ocid', help=u"""Unique OCI identifier for the SCIM Resource.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: string  - uniqueness: global""")
@cli_util.option('--meta', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-created-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-last-modified-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-prevented-operations', type=custom_types.CliCaseInsensitiveChoice(["replace", "update", "delete"]), help=u"""Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of tags on this resource.

**SCIM++ Properties:**  - idcsCompositeKey: [key, value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type Tags.  For documentation on tags please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/Tags.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--delete-in-progress', type=click.BOOL, help=u"""A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--idcs-last-upgraded-in-release', help=u"""The release number when the resource was upgraded.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--domain-ocid', help=u"""OCI Domain Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--compartment-ocid', help=u"""OCI Compartment Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--tenancy-ocid', help=u"""OCI Tenant Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--description', help=u"""Description

**Added In:** 2101262133

**SCIM++ Properties:**  - caseExact: false  - type: string  - mutability: readWrite  - required: false  - returned: default""")
@cli_util.option('--user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'user': {'module': 'identity_domains', 'class': 'MyApiKeyUser'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'user': {'module': 'identity_domains', 'class': 'MyApiKeyUser'}}, output_type={'module': 'identity_domains', 'class': 'MyApiKey'})
@cli_util.wrap_exceptions
def create_my_api_key(ctx, from_json, schemas, fingerprint, key, authorization, resource_type_schema_version, id, ocid, meta, idcs_created_by, idcs_last_modified_by, idcs_prevented_operations, tags, delete_in_progress, idcs_last_upgraded_in_release, domain_ocid, compartment_ocid, tenancy_ocid, description, user):

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version

    _details = {}
    _details['schemas'] = cli_util.parse_json_parameter("schemas", schemas)
    _details['fingerprint'] = fingerprint
    _details['key'] = key

    if id is not None:
        _details['id'] = id

    if ocid is not None:
        _details['ocid'] = ocid

    if meta is not None:
        _details['meta'] = cli_util.parse_json_parameter("meta", meta)

    if idcs_created_by is not None:
        _details['idcsCreatedBy'] = cli_util.parse_json_parameter("idcs_created_by", idcs_created_by)

    if idcs_last_modified_by is not None:
        _details['idcsLastModifiedBy'] = cli_util.parse_json_parameter("idcs_last_modified_by", idcs_last_modified_by)

    if idcs_prevented_operations is not None:
        _details['idcsPreventedOperations'] = cli_util.parse_json_parameter("idcs_prevented_operations", idcs_prevented_operations)

    if tags is not None:
        _details['tags'] = cli_util.parse_json_parameter("tags", tags)

    if delete_in_progress is not None:
        _details['deleteInProgress'] = delete_in_progress

    if idcs_last_upgraded_in_release is not None:
        _details['idcsLastUpgradedInRelease'] = idcs_last_upgraded_in_release

    if domain_ocid is not None:
        _details['domainOcid'] = domain_ocid

    if compartment_ocid is not None:
        _details['compartmentOcid'] = compartment_ocid

    if tenancy_ocid is not None:
        _details['tenancyOcid'] = tenancy_ocid

    if description is not None:
        _details['description'] = description

    if user is not None:
        _details['user'] = cli_util.parse_json_parameter("user", user)

    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.create_my_api_key(
        my_api_key=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@my_auth_token_group.command(name=cli_util.override('identity_domains.create_my_auth_token.command_name', 'create'), help=u"""Create a user's own Auth token.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](createMyAuthToken)""")
@cli_util.option('--schemas', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--id', help=u"""Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--ocid', help=u"""Unique OCI identifier for the SCIM Resource.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: string  - uniqueness: global""")
@cli_util.option('--meta', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-created-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-last-modified-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-prevented-operations', type=custom_types.CliCaseInsensitiveChoice(["replace", "update", "delete"]), help=u"""Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of tags on this resource.

**SCIM++ Properties:**  - idcsCompositeKey: [key, value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type Tags.  For documentation on tags please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/Tags.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--delete-in-progress', type=click.BOOL, help=u"""A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--idcs-last-upgraded-in-release', help=u"""The release number when the resource was upgraded.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--domain-ocid', help=u"""OCI Domain Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--compartment-ocid', help=u"""OCI Compartment Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--tenancy-ocid', help=u"""OCI Tenant Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--description', help=u"""Description

**Added In:** 2010242156

**SCIM++ Properties:**  - caseExact: false  - type: string  - mutability: readWrite  - required: false  - returned: default""")
@cli_util.option('--status', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "INACTIVE"]), help=u"""The user's credential status.

**Added In:** 2109090424

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: never  - type: string  - uniqueness: none""")
@cli_util.option('--expires-on', help=u"""When the user's credential expire.

**Added In:** 2109090424

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: dateTime  - uniqueness: none""")
@cli_util.option('--user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'user': {'module': 'identity_domains', 'class': 'MyAuthTokenUser'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'user': {'module': 'identity_domains', 'class': 'MyAuthTokenUser'}}, output_type={'module': 'identity_domains', 'class': 'MyAuthToken'})
@cli_util.wrap_exceptions
def create_my_auth_token(ctx, from_json, schemas, authorization, resource_type_schema_version, id, ocid, meta, idcs_created_by, idcs_last_modified_by, idcs_prevented_operations, tags, delete_in_progress, idcs_last_upgraded_in_release, domain_ocid, compartment_ocid, tenancy_ocid, description, status, expires_on, user):

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version

    _details = {}
    _details['schemas'] = cli_util.parse_json_parameter("schemas", schemas)

    if id is not None:
        _details['id'] = id

    if ocid is not None:
        _details['ocid'] = ocid

    if meta is not None:
        _details['meta'] = cli_util.parse_json_parameter("meta", meta)

    if idcs_created_by is not None:
        _details['idcsCreatedBy'] = cli_util.parse_json_parameter("idcs_created_by", idcs_created_by)

    if idcs_last_modified_by is not None:
        _details['idcsLastModifiedBy'] = cli_util.parse_json_parameter("idcs_last_modified_by", idcs_last_modified_by)

    if idcs_prevented_operations is not None:
        _details['idcsPreventedOperations'] = cli_util.parse_json_parameter("idcs_prevented_operations", idcs_prevented_operations)

    if tags is not None:
        _details['tags'] = cli_util.parse_json_parameter("tags", tags)

    if delete_in_progress is not None:
        _details['deleteInProgress'] = delete_in_progress

    if idcs_last_upgraded_in_release is not None:
        _details['idcsLastUpgradedInRelease'] = idcs_last_upgraded_in_release

    if domain_ocid is not None:
        _details['domainOcid'] = domain_ocid

    if compartment_ocid is not None:
        _details['compartmentOcid'] = compartment_ocid

    if tenancy_ocid is not None:
        _details['tenancyOcid'] = tenancy_ocid

    if description is not None:
        _details['description'] = description

    if status is not None:
        _details['status'] = status

    if expires_on is not None:
        _details['expiresOn'] = expires_on

    if user is not None:
        _details['user'] = cli_util.parse_json_parameter("user", user)

    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.create_my_auth_token(
        my_auth_token=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@my_authentication_factor_initiator_group.command(name=cli_util.override('identity_domains.create_my_authentication_factor_initiator.command_name', 'create'), help=u"""Initiate Self Service Enrollment using the Requested MFA Factor

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](createMyAuthenticationFactorInitiator)""")
@cli_util.option('--schemas', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--auth-factor', required=True, type=custom_types.CliCaseInsensitiveChoice(["EMAIL", "TOTP", "PUSH", "SMS", "VOICE", "PHONE_CALL", "THIRDPARTY", "FIDO_AUTHENTICATOR", "YUBICO_OTP"]), help=u"""Auth Factor represents the type of multi-factor authentication channel for which the request has been initiated.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--device-id', required=True, help=u"""Enrolled Device id on which the multi factor has been initiated.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--id', help=u"""Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--ocid', help=u"""Unique OCI identifier for the SCIM Resource.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: string  - uniqueness: global""")
@cli_util.option('--meta', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-created-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-last-modified-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-prevented-operations', type=custom_types.CliCaseInsensitiveChoice(["replace", "update", "delete"]), help=u"""Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of tags on this resource.

**SCIM++ Properties:**  - idcsCompositeKey: [key, value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type Tags.  For documentation on tags please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/Tags.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--delete-in-progress', type=click.BOOL, help=u"""A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--idcs-last-upgraded-in-release', help=u"""The release number when the resource was upgraded.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--domain-ocid', help=u"""OCI Domain Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--compartment-ocid', help=u"""OCI Compartment Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--tenancy-ocid', help=u"""OCI Tenant Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--type', type=custom_types.CliCaseInsensitiveChoice(["SAML", "OIDC"]), help=u"""Authentication flow type either SAML / OIDC

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--request-id', help=u"""Unique RequestId generated for each initiator request.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--user-name', help=u"""Name of the user who initiates the request.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none  - idcsPii: true""")
@cli_util.option('--scenario', type=custom_types.CliCaseInsensitiveChoice(["ENROLLMENT", "AUTHENTICATION"]), help=u"""Specifies the scenario to initiate.

**SCIM++ Properties:**  - type: string  - multiValued: false  - required: false  - mutability: readWrite  - returned: default  - uniqueness: none  - idcsSearchable: false""")
@cli_util.option('--third-party-factor', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--preference-type', type=custom_types.CliCaseInsensitiveChoice(["PASSWORDLESS", "MFA"]), help=u"""Indicates whether to user passwordless factor to be updated or mfa factor to be updated

**SCIM++ Properties:**  - type: string  - multiValued: false  - required: false  - mutability: writeOnly  - returned: never  - uniqueness: none""")
@cli_util.option('--additional-attributes', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Additional attributes which will be sent as part of a push notification

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: complex  - uniqueness: none

This option is a JSON list with items of type MyAuthenticationFactorInitiatorAdditionalAttributes.  For documentation on MyAuthenticationFactorInitiatorAdditionalAttributes please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/MyAuthenticationFactorInitiatorAdditionalAttributes.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--is-acc-rec-enabled', type=click.BOOL, help=u"""Flag indicates whether the device is enrolled in account recovery

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@json_skeleton_utils.get_cli_json_input_option({'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'third-party-factor': {'module': 'identity_domains', 'class': 'MyAuthenticationFactorInitiatorThirdPartyFactor'}, 'additional-attributes': {'module': 'identity_domains', 'class': 'list[MyAuthenticationFactorInitiatorAdditionalAttributes]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'third-party-factor': {'module': 'identity_domains', 'class': 'MyAuthenticationFactorInitiatorThirdPartyFactor'}, 'additional-attributes': {'module': 'identity_domains', 'class': 'list[MyAuthenticationFactorInitiatorAdditionalAttributes]'}}, output_type={'module': 'identity_domains', 'class': 'MyAuthenticationFactorInitiator'})
@cli_util.wrap_exceptions
def create_my_authentication_factor_initiator(ctx, from_json, schemas, auth_factor, device_id, authorization, resource_type_schema_version, id, ocid, meta, idcs_created_by, idcs_last_modified_by, idcs_prevented_operations, tags, delete_in_progress, idcs_last_upgraded_in_release, domain_ocid, compartment_ocid, tenancy_ocid, type, request_id, user_name, scenario, third_party_factor, preference_type, additional_attributes, is_acc_rec_enabled):

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version

    _details = {}
    _details['schemas'] = cli_util.parse_json_parameter("schemas", schemas)
    _details['authFactor'] = auth_factor
    _details['deviceId'] = device_id

    if id is not None:
        _details['id'] = id

    if ocid is not None:
        _details['ocid'] = ocid

    if meta is not None:
        _details['meta'] = cli_util.parse_json_parameter("meta", meta)

    if idcs_created_by is not None:
        _details['idcsCreatedBy'] = cli_util.parse_json_parameter("idcs_created_by", idcs_created_by)

    if idcs_last_modified_by is not None:
        _details['idcsLastModifiedBy'] = cli_util.parse_json_parameter("idcs_last_modified_by", idcs_last_modified_by)

    if idcs_prevented_operations is not None:
        _details['idcsPreventedOperations'] = cli_util.parse_json_parameter("idcs_prevented_operations", idcs_prevented_operations)

    if tags is not None:
        _details['tags'] = cli_util.parse_json_parameter("tags", tags)

    if delete_in_progress is not None:
        _details['deleteInProgress'] = delete_in_progress

    if idcs_last_upgraded_in_release is not None:
        _details['idcsLastUpgradedInRelease'] = idcs_last_upgraded_in_release

    if domain_ocid is not None:
        _details['domainOcid'] = domain_ocid

    if compartment_ocid is not None:
        _details['compartmentOcid'] = compartment_ocid

    if tenancy_ocid is not None:
        _details['tenancyOcid'] = tenancy_ocid

    if type is not None:
        _details['type'] = type

    if request_id is not None:
        _details['requestId'] = request_id

    if user_name is not None:
        _details['userName'] = user_name

    if scenario is not None:
        _details['scenario'] = scenario

    if third_party_factor is not None:
        _details['thirdPartyFactor'] = cli_util.parse_json_parameter("third_party_factor", third_party_factor)

    if preference_type is not None:
        _details['preferenceType'] = preference_type

    if additional_attributes is not None:
        _details['additionalAttributes'] = cli_util.parse_json_parameter("additional_attributes", additional_attributes)

    if is_acc_rec_enabled is not None:
        _details['isAccRecEnabled'] = is_acc_rec_enabled

    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.create_my_authentication_factor_initiator(
        my_authentication_factor_initiator=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@my_authentication_factor_validator_group.command(name=cli_util.override('identity_domains.create_my_authentication_factor_validator.command_name', 'create'), help=u"""Validate Self Service Enrollment using the Requested MFA Factor

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](createMyAuthenticationFactorValidator)""")
@cli_util.option('--schemas', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--auth-factor', required=True, type=custom_types.CliCaseInsensitiveChoice(["USERNAME_PASSWORD", "PUSH", "TOTP", "EMAIL", "SMS", "VOICE", "BYPASSCODE", "SECURITY_QUESTIONS", "TRUST_TOKEN", "PHONE_CALL", "THIRDPARTY", "FIDO_AUTHENTICATOR", "YUBICO_OTP", "KMSI_TOKEN"]), help=u"""Authentication Factor which is being validated

**SCIM++ Properties:**  - type: string  - multiValued: false  - required: true  - mutability: readWrite  - returned: default  - uniqueness: none  - idcsSearchable: false""")
@cli_util.option('--scenario', required=True, type=custom_types.CliCaseInsensitiveChoice(["ENROLLMENT", "AUTHENTICATION"]), help=u"""Specifies whether the service is being used to enroll or validate a factor

**SCIM++ Properties:**  - type: string  - multiValued: false  - required: true  - mutability: readWrite  - returned: default  - uniqueness: none  - idcsSearchable: false""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--id', help=u"""Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--ocid', help=u"""Unique OCI identifier for the SCIM Resource.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: string  - uniqueness: global""")
@cli_util.option('--meta', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-created-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-last-modified-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-prevented-operations', type=custom_types.CliCaseInsensitiveChoice(["replace", "update", "delete"]), help=u"""Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of tags on this resource.

**SCIM++ Properties:**  - idcsCompositeKey: [key, value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type Tags.  For documentation on tags please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/Tags.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--delete-in-progress', type=click.BOOL, help=u"""A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--idcs-last-upgraded-in-release', help=u"""The release number when the resource was upgraded.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--domain-ocid', help=u"""OCI Domain Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--compartment-ocid', help=u"""OCI Compartment Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--tenancy-ocid', help=u"""OCI Tenant Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--request-id', help=u"""Request ID which is being validated

**SCIM++ Properties:**  - type: string  - multiValued: false  - required: false  - mutability: readWrite  - returned: default  - uniqueness: none  - idcsSearchable: false""")
@cli_util.option('--otp-code', help=u"""The One Time Passcode which needs to be validated

**SCIM++ Properties:**  - type: string  - multiValued: false  - required: false  - mutability: readWrite  - returned: never  - uniqueness: none  - idcsSensitive: encrypt  - idcsSearchable: false""")
@cli_util.option('--device-id', help=u"""Device id whose factor is being validated

**SCIM++ Properties:**  - type: string  - multiValued: false  - required: false  - mutability: readWrite  - returned: default  - uniqueness: none  - idcsSearchable: false""")
@cli_util.option('--status', type=custom_types.CliCaseInsensitiveChoice(["SUCCESS", "FAILURE"]), help=u"""Validation status returned in the response

**SCIM++ Properties:**  - type: string  - multiValued: false  - required: false  - mutability: readOnly  - returned: default  - uniqueness: none  - idcsSearchable: false""")
@cli_util.option('--user-id', help=u"""User guid for whom the validation has initiated. Optional.

**SCIM++ Properties:**  - type: string  - multiValued: false  - required: false  - mutability: readWrite  - returned: default  - uniqueness: none  - idcsSearchable: false""")
@cli_util.option('--user-name', help=u"""User name for whom the validation has initiated

**SCIM++ Properties:**  - type: string  - multiValued: false  - required: false  - mutability: readWrite  - returned: default  - uniqueness: none  - idcsSearchable: false  - idcsPii: true""")
@cli_util.option('--display-name', help=u"""Display name of the verified device

**SCIM++ Properties:**  - type: string  - multiValued: false  - required: false  - mutability: readWrite  - returned: default  - uniqueness: none  - idcsSearchable: false""")
@cli_util.option('--message', help=u"""Validator message which is passed by the client. When it is a PUSH notification, it can be a rejection message.

**SCIM++ Properties:**  - type: string  - multiValued: false  - required: false  - mutability: readWrite  - returned: default  - uniqueness: none  - idcsSearchable: false""")
@cli_util.option('--type', type=custom_types.CliCaseInsensitiveChoice(["SAML", "OIDC"]), help=u"""type indicating whether the flow is OIDC, SAML etc.,

**SCIM++ Properties:**  - type: string  - multiValued: false  - required: false  - mutability: writeOnly  - returned: default  - uniqueness: none""")
@cli_util.option('--update-user-preference', type=click.BOOL, help=u"""Indicates whether to update user preferred mfa factor or not

**SCIM++ Properties:**  - type: boolean  - multiValued: false  - required: false  - mutability: writeOnly  - returned: never  - uniqueness: none""")
@cli_util.option('--preference-type', type=custom_types.CliCaseInsensitiveChoice(["PASSWORDLESS", "MFA"]), help=u"""Indicates whether to user passwordless factor to be updated or mfa factor to be updated

**SCIM++ Properties:**  - type: string  - multiValued: false  - required: false  - mutability: writeOnly  - returned: never  - uniqueness: none""")
@cli_util.option('--security-questions', type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of security questions the user has submitted to get authenticated.

**SCIM++ Properties:**  - type: complex  - multiValued: true  - required: false  - mutability: writeOnly  - returned: never  - uniqueness: none  - idcsSearchable: false

This option is a JSON list with items of type MyAuthenticationFactorValidatorSecurityQuestions.  For documentation on MyAuthenticationFactorValidatorSecurityQuestions please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/MyAuthenticationFactorValidatorSecurityQuestions.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--name', help=u"""Name of the client to be trusted

**SCIM++ Properties:**  - type: string  - multiValued: false  - required: false  - mutability: writeOnly  - returned: never  - uniqueness: none""")
@cli_util.option('--platform', help=u"""Platform of the client to be trusted

**SCIM++ Properties:**  - type: string  - multiValued: false  - required: false  - mutability: writeOnly  - returned: never  - uniqueness: none""")
@cli_util.option('--location', help=u"""Location of the trusted client.

**SCIM++ Properties:**  - type: string  - multiValued: false  - required: false  - mutability: writeOnly  - returned: never  - uniqueness: none""")
@cli_util.option('--trusted-token-id', help=u"""Trusted token resource identifier.

**SCIM++ Properties:**  - type: string  - multiValued: false  - required: false  - mutability: writeOnly  - returned: never  - uniqueness: none""")
@cli_util.option('--kmsi-token-id', help=u"""KMSI token resource identifier.

**SCIM++ Properties:**  - type: string  - multiValued: false  - required: false  - mutability: writeOnly  - returned: never  - uniqueness: none""")
@cli_util.option('--policy-enabled-second-factors', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Sign-On Policy dictated allowed second factors.

**SCIM++ Properties:**  - type: string  - multiValued: true  - required: false  - mutability: writeOnly  - returned: never  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--create-trusted-agent', type=click.BOOL, help=u"""Indicates to create trust token.

**SCIM++ Properties:**  - type: boolean  - multiValued: false  - required: false  - mutability: writeOnly  - returned: never  - uniqueness: none""")
@cli_util.option('--create-kmsi-token', type=click.BOOL, help=u"""Indicates to create kmsi token.

**SCIM++ Properties:**  - type: boolean  - multiValued: false  - required: false  - mutability: writeOnly  - returned: never  - uniqueness: none""")
@cli_util.option('--is-acc-rec-enabled', type=click.BOOL, help=u"""Flag indicates whether the factor is enrolled in account recovery. If the value is not provided or false, then it will be treated as MFA factor validation.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--policy-trusted-frequency-mins', type=click.INT, help=u"""Sign-On Policy dictated validity duration for trusted client in Minutes.

**SCIM++ Properties:**  - type: integer  - multiValued: false  - required: false  - mutability: writeOnly  - returned: never  - uniqueness: none""")
@cli_util.option('--third-party-factor', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--additional-attributes', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Additional attributes which will be sent as part of a push notification

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: complex  - uniqueness: none

This option is a JSON list with items of type MyAuthenticationFactorValidatorAdditionalAttributes.  For documentation on MyAuthenticationFactorValidatorAdditionalAttributes please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/MyAuthenticationFactorValidatorAdditionalAttributes.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'security-questions': {'module': 'identity_domains', 'class': 'list[MyAuthenticationFactorValidatorSecurityQuestions]'}, 'policy-enabled-second-factors': {'module': 'identity_domains', 'class': 'list[string]'}, 'third-party-factor': {'module': 'identity_domains', 'class': 'MyAuthenticationFactorValidatorThirdPartyFactor'}, 'additional-attributes': {'module': 'identity_domains', 'class': 'list[MyAuthenticationFactorValidatorAdditionalAttributes]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'security-questions': {'module': 'identity_domains', 'class': 'list[MyAuthenticationFactorValidatorSecurityQuestions]'}, 'policy-enabled-second-factors': {'module': 'identity_domains', 'class': 'list[string]'}, 'third-party-factor': {'module': 'identity_domains', 'class': 'MyAuthenticationFactorValidatorThirdPartyFactor'}, 'additional-attributes': {'module': 'identity_domains', 'class': 'list[MyAuthenticationFactorValidatorAdditionalAttributes]'}}, output_type={'module': 'identity_domains', 'class': 'MyAuthenticationFactorValidator'})
@cli_util.wrap_exceptions
def create_my_authentication_factor_validator(ctx, from_json, schemas, auth_factor, scenario, authorization, resource_type_schema_version, id, ocid, meta, idcs_created_by, idcs_last_modified_by, idcs_prevented_operations, tags, delete_in_progress, idcs_last_upgraded_in_release, domain_ocid, compartment_ocid, tenancy_ocid, request_id, otp_code, device_id, status, user_id, user_name, display_name, message, type, update_user_preference, preference_type, security_questions, name, platform, location, trusted_token_id, kmsi_token_id, policy_enabled_second_factors, create_trusted_agent, create_kmsi_token, is_acc_rec_enabled, policy_trusted_frequency_mins, third_party_factor, additional_attributes):

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version

    _details = {}
    _details['schemas'] = cli_util.parse_json_parameter("schemas", schemas)
    _details['authFactor'] = auth_factor
    _details['scenario'] = scenario

    if id is not None:
        _details['id'] = id

    if ocid is not None:
        _details['ocid'] = ocid

    if meta is not None:
        _details['meta'] = cli_util.parse_json_parameter("meta", meta)

    if idcs_created_by is not None:
        _details['idcsCreatedBy'] = cli_util.parse_json_parameter("idcs_created_by", idcs_created_by)

    if idcs_last_modified_by is not None:
        _details['idcsLastModifiedBy'] = cli_util.parse_json_parameter("idcs_last_modified_by", idcs_last_modified_by)

    if idcs_prevented_operations is not None:
        _details['idcsPreventedOperations'] = cli_util.parse_json_parameter("idcs_prevented_operations", idcs_prevented_operations)

    if tags is not None:
        _details['tags'] = cli_util.parse_json_parameter("tags", tags)

    if delete_in_progress is not None:
        _details['deleteInProgress'] = delete_in_progress

    if idcs_last_upgraded_in_release is not None:
        _details['idcsLastUpgradedInRelease'] = idcs_last_upgraded_in_release

    if domain_ocid is not None:
        _details['domainOcid'] = domain_ocid

    if compartment_ocid is not None:
        _details['compartmentOcid'] = compartment_ocid

    if tenancy_ocid is not None:
        _details['tenancyOcid'] = tenancy_ocid

    if request_id is not None:
        _details['requestId'] = request_id

    if otp_code is not None:
        _details['otpCode'] = otp_code

    if device_id is not None:
        _details['deviceId'] = device_id

    if status is not None:
        _details['status'] = status

    if user_id is not None:
        _details['userId'] = user_id

    if user_name is not None:
        _details['userName'] = user_name

    if display_name is not None:
        _details['displayName'] = display_name

    if message is not None:
        _details['message'] = message

    if type is not None:
        _details['type'] = type

    if update_user_preference is not None:
        _details['updateUserPreference'] = update_user_preference

    if preference_type is not None:
        _details['preferenceType'] = preference_type

    if security_questions is not None:
        _details['securityQuestions'] = cli_util.parse_json_parameter("security_questions", security_questions)

    if name is not None:
        _details['name'] = name

    if platform is not None:
        _details['platform'] = platform

    if location is not None:
        _details['location'] = location

    if trusted_token_id is not None:
        _details['trustedTokenId'] = trusted_token_id

    if kmsi_token_id is not None:
        _details['kmsiTokenId'] = kmsi_token_id

    if policy_enabled_second_factors is not None:
        _details['policyEnabledSecondFactors'] = cli_util.parse_json_parameter("policy_enabled_second_factors", policy_enabled_second_factors)

    if create_trusted_agent is not None:
        _details['createTrustedAgent'] = create_trusted_agent

    if create_kmsi_token is not None:
        _details['createKmsiToken'] = create_kmsi_token

    if is_acc_rec_enabled is not None:
        _details['isAccRecEnabled'] = is_acc_rec_enabled

    if policy_trusted_frequency_mins is not None:
        _details['policyTrustedFrequencyMins'] = policy_trusted_frequency_mins

    if third_party_factor is not None:
        _details['thirdPartyFactor'] = cli_util.parse_json_parameter("third_party_factor", third_party_factor)

    if additional_attributes is not None:
        _details['additionalAttributes'] = cli_util.parse_json_parameter("additional_attributes", additional_attributes)

    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.create_my_authentication_factor_validator(
        my_authentication_factor_validator=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@my_authentication_factors_remover_group.command(name=cli_util.override('identity_domains.create_my_authentication_factors_remover.command_name', 'create'), help=u"""Remove All Authentication Factor Channels for a User

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](createMyAuthenticationFactorsRemover)""")
@cli_util.option('--schemas', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--user', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--id', help=u"""Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--ocid', help=u"""Unique OCI identifier for the SCIM Resource.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: string  - uniqueness: global""")
@cli_util.option('--meta', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-created-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-last-modified-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-prevented-operations', type=custom_types.CliCaseInsensitiveChoice(["replace", "update", "delete"]), help=u"""Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of tags on this resource.

**SCIM++ Properties:**  - idcsCompositeKey: [key, value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type Tags.  For documentation on tags please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/Tags.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--delete-in-progress', type=click.BOOL, help=u"""A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--idcs-last-upgraded-in-release', help=u"""The release number when the resource was upgraded.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--domain-ocid', help=u"""OCI Domain Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--compartment-ocid', help=u"""OCI Compartment Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--tenancy-ocid', help=u"""OCI Tenant Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--type', type=custom_types.CliCaseInsensitiveChoice(["KMSI", "MFA", "ACCOUNTRECOVERY", "ALL"]), help=u"""Specifies the type of factors to remove. Either MFA factors or AccountRecovery factors or All factors

**SCIM++ Properties:**  - type: string  - multiValued: false  - required: false  - mutability: readWrite  - returned: default  - uniqueness: none  - idcsSearchable: false""")
@cli_util.option('--token', help=u"""Specifies the token to be removed

**SCIM++ Properties:**  - type: string  - multiValued: false  - required: false  - mutability: readWrite  - returned: request  - uniqueness: none  - idcsSearchable: false""")
@json_skeleton_utils.get_cli_json_input_option({'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'user': {'module': 'identity_domains', 'class': 'MyAuthenticationFactorsRemoverUser'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'user': {'module': 'identity_domains', 'class': 'MyAuthenticationFactorsRemoverUser'}}, output_type={'module': 'identity_domains', 'class': 'MyAuthenticationFactorsRemover'})
@cli_util.wrap_exceptions
def create_my_authentication_factors_remover(ctx, from_json, schemas, user, authorization, resource_type_schema_version, id, ocid, meta, idcs_created_by, idcs_last_modified_by, idcs_prevented_operations, tags, delete_in_progress, idcs_last_upgraded_in_release, domain_ocid, compartment_ocid, tenancy_ocid, type, token):

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version

    _details = {}
    _details['schemas'] = cli_util.parse_json_parameter("schemas", schemas)
    _details['user'] = cli_util.parse_json_parameter("user", user)

    if id is not None:
        _details['id'] = id

    if ocid is not None:
        _details['ocid'] = ocid

    if meta is not None:
        _details['meta'] = cli_util.parse_json_parameter("meta", meta)

    if idcs_created_by is not None:
        _details['idcsCreatedBy'] = cli_util.parse_json_parameter("idcs_created_by", idcs_created_by)

    if idcs_last_modified_by is not None:
        _details['idcsLastModifiedBy'] = cli_util.parse_json_parameter("idcs_last_modified_by", idcs_last_modified_by)

    if idcs_prevented_operations is not None:
        _details['idcsPreventedOperations'] = cli_util.parse_json_parameter("idcs_prevented_operations", idcs_prevented_operations)

    if tags is not None:
        _details['tags'] = cli_util.parse_json_parameter("tags", tags)

    if delete_in_progress is not None:
        _details['deleteInProgress'] = delete_in_progress

    if idcs_last_upgraded_in_release is not None:
        _details['idcsLastUpgradedInRelease'] = idcs_last_upgraded_in_release

    if domain_ocid is not None:
        _details['domainOcid'] = domain_ocid

    if compartment_ocid is not None:
        _details['compartmentOcid'] = compartment_ocid

    if tenancy_ocid is not None:
        _details['tenancyOcid'] = tenancy_ocid

    if type is not None:
        _details['type'] = type

    if token is not None:
        _details['token'] = token

    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.create_my_authentication_factors_remover(
        my_authentication_factors_remover=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@my_customer_secret_key_group.command(name=cli_util.override('identity_domains.create_my_customer_secret_key.command_name', 'create'), help=u"""Add a user's own customer secret key.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](createMyCustomerSecretKey)""")
@cli_util.option('--schemas', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--id', help=u"""Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--ocid', help=u"""Unique OCI identifier for the SCIM Resource.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: string  - uniqueness: global""")
@cli_util.option('--meta', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-created-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-last-modified-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-prevented-operations', type=custom_types.CliCaseInsensitiveChoice(["replace", "update", "delete"]), help=u"""Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of tags on this resource.

**SCIM++ Properties:**  - idcsCompositeKey: [key, value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type Tags.  For documentation on tags please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/Tags.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--delete-in-progress', type=click.BOOL, help=u"""A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--idcs-last-upgraded-in-release', help=u"""The release number when the resource was upgraded.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--domain-ocid', help=u"""OCI Domain Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--compartment-ocid', help=u"""OCI Compartment Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--tenancy-ocid', help=u"""OCI Tenant Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--display-name', help=u"""Display Name

**SCIM++ Properties:**  - caseExact: false  - type: string  - mutability: readWrite  - required: false  - returned: default""")
@cli_util.option('--description', help=u"""Description

**SCIM++ Properties:**  - caseExact: false  - type: string  - mutability: readWrite  - required: false  - returned: default""")
@cli_util.option('--status', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "INACTIVE"]), help=u"""The user's credential status.

**Added In:** 2109090424

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: never  - type: string  - uniqueness: none""")
@cli_util.option('--expires-on', help=u"""When the user's credential expire.

**Added In:** 2109090424

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: dateTime  - uniqueness: none""")
@cli_util.option('--access-key', help=u"""The access key.

**SCIM++ Properties:**  - caseExact: true  - type: string  - mutability: readOnly  - required: false  - returned: default""")
@cli_util.option('--user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'user': {'module': 'identity_domains', 'class': 'MyCustomerSecretKeyUser'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'user': {'module': 'identity_domains', 'class': 'MyCustomerSecretKeyUser'}}, output_type={'module': 'identity_domains', 'class': 'MyCustomerSecretKey'})
@cli_util.wrap_exceptions
def create_my_customer_secret_key(ctx, from_json, schemas, authorization, resource_type_schema_version, id, ocid, meta, idcs_created_by, idcs_last_modified_by, idcs_prevented_operations, tags, delete_in_progress, idcs_last_upgraded_in_release, domain_ocid, compartment_ocid, tenancy_ocid, display_name, description, status, expires_on, access_key, user):

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version

    _details = {}
    _details['schemas'] = cli_util.parse_json_parameter("schemas", schemas)

    if id is not None:
        _details['id'] = id

    if ocid is not None:
        _details['ocid'] = ocid

    if meta is not None:
        _details['meta'] = cli_util.parse_json_parameter("meta", meta)

    if idcs_created_by is not None:
        _details['idcsCreatedBy'] = cli_util.parse_json_parameter("idcs_created_by", idcs_created_by)

    if idcs_last_modified_by is not None:
        _details['idcsLastModifiedBy'] = cli_util.parse_json_parameter("idcs_last_modified_by", idcs_last_modified_by)

    if idcs_prevented_operations is not None:
        _details['idcsPreventedOperations'] = cli_util.parse_json_parameter("idcs_prevented_operations", idcs_prevented_operations)

    if tags is not None:
        _details['tags'] = cli_util.parse_json_parameter("tags", tags)

    if delete_in_progress is not None:
        _details['deleteInProgress'] = delete_in_progress

    if idcs_last_upgraded_in_release is not None:
        _details['idcsLastUpgradedInRelease'] = idcs_last_upgraded_in_release

    if domain_ocid is not None:
        _details['domainOcid'] = domain_ocid

    if compartment_ocid is not None:
        _details['compartmentOcid'] = compartment_ocid

    if tenancy_ocid is not None:
        _details['tenancyOcid'] = tenancy_ocid

    if display_name is not None:
        _details['displayName'] = display_name

    if description is not None:
        _details['description'] = description

    if status is not None:
        _details['status'] = status

    if expires_on is not None:
        _details['expiresOn'] = expires_on

    if access_key is not None:
        _details['accessKey'] = access_key

    if user is not None:
        _details['user'] = cli_util.parse_json_parameter("user", user)

    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.create_my_customer_secret_key(
        my_customer_secret_key=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@my_o_auth2_client_credential_group.command(name=cli_util.override('identity_domains.create_my_o_auth2_client_credential.command_name', 'create'), help=u"""Create a user's own OAuth2 client credential.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](createMyOAuth2ClientCredential)""")
@cli_util.option('--schemas', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--name', required=True, help=u"""Name

**SCIM++ Properties:**  - caseExact: false  - type: string  - mutability: readWrite  - required: true  - returned: default""")
@cli_util.option('--scopes', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""Scopes

**SCIM++ Properties:**  - caseExact: false  - idcsCompositeKey: [audience, scope]  - type: complex  - mutability: readWrite  - multiValued: true  - required: true  - returned: default""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--id', help=u"""Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--ocid', help=u"""Unique OCI identifier for the SCIM Resource.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: string  - uniqueness: global""")
@cli_util.option('--meta', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-created-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-last-modified-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-prevented-operations', type=custom_types.CliCaseInsensitiveChoice(["replace", "update", "delete"]), help=u"""Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of tags on this resource.

**SCIM++ Properties:**  - idcsCompositeKey: [key, value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type Tags.  For documentation on tags please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/Tags.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--delete-in-progress', type=click.BOOL, help=u"""A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--idcs-last-upgraded-in-release', help=u"""The release number when the resource was upgraded.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--domain-ocid', help=u"""OCI Domain Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--compartment-ocid', help=u"""OCI Compartment Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--tenancy-ocid', help=u"""OCI Tenant Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--description', help=u"""Description

**Added In:** 2101262133

**SCIM++ Properties:**  - caseExact: false  - type: string  - mutability: readWrite  - required: false  - returned: default""")
@cli_util.option('--status', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "INACTIVE"]), help=u"""The user's credential status.

**Added In:** 2109090424

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: never  - type: string  - uniqueness: none""")
@cli_util.option('--expires-on', help=u"""When the user's credentials expire.

**Added In:** 2109090424

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: dateTime  - uniqueness: none""")
@cli_util.option('--is-reset-secret', type=click.BOOL, help=u"""Specifies whether the secret must be reset.

**Added In:** 2109090424

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: writeOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'scopes': {'module': 'identity_domains', 'class': 'list[MyOAuth2ClientCredentialScopes]'}, 'user': {'module': 'identity_domains', 'class': 'MyOAuth2ClientCredentialUser'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'scopes': {'module': 'identity_domains', 'class': 'list[MyOAuth2ClientCredentialScopes]'}, 'user': {'module': 'identity_domains', 'class': 'MyOAuth2ClientCredentialUser'}}, output_type={'module': 'identity_domains', 'class': 'MyOAuth2ClientCredential'})
@cli_util.wrap_exceptions
def create_my_o_auth2_client_credential(ctx, from_json, schemas, name, scopes, authorization, resource_type_schema_version, id, ocid, meta, idcs_created_by, idcs_last_modified_by, idcs_prevented_operations, tags, delete_in_progress, idcs_last_upgraded_in_release, domain_ocid, compartment_ocid, tenancy_ocid, description, status, expires_on, is_reset_secret, user):

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version

    _details = {}
    _details['schemas'] = cli_util.parse_json_parameter("schemas", schemas)
    _details['name'] = name
    _details['scopes'] = cli_util.parse_json_parameter("scopes", scopes)

    if id is not None:
        _details['id'] = id

    if ocid is not None:
        _details['ocid'] = ocid

    if meta is not None:
        _details['meta'] = cli_util.parse_json_parameter("meta", meta)

    if idcs_created_by is not None:
        _details['idcsCreatedBy'] = cli_util.parse_json_parameter("idcs_created_by", idcs_created_by)

    if idcs_last_modified_by is not None:
        _details['idcsLastModifiedBy'] = cli_util.parse_json_parameter("idcs_last_modified_by", idcs_last_modified_by)

    if idcs_prevented_operations is not None:
        _details['idcsPreventedOperations'] = cli_util.parse_json_parameter("idcs_prevented_operations", idcs_prevented_operations)

    if tags is not None:
        _details['tags'] = cli_util.parse_json_parameter("tags", tags)

    if delete_in_progress is not None:
        _details['deleteInProgress'] = delete_in_progress

    if idcs_last_upgraded_in_release is not None:
        _details['idcsLastUpgradedInRelease'] = idcs_last_upgraded_in_release

    if domain_ocid is not None:
        _details['domainOcid'] = domain_ocid

    if compartment_ocid is not None:
        _details['compartmentOcid'] = compartment_ocid

    if tenancy_ocid is not None:
        _details['tenancyOcid'] = tenancy_ocid

    if description is not None:
        _details['description'] = description

    if status is not None:
        _details['status'] = status

    if expires_on is not None:
        _details['expiresOn'] = expires_on

    if is_reset_secret is not None:
        _details['isResetSecret'] = is_reset_secret

    if user is not None:
        _details['user'] = cli_util.parse_json_parameter("user", user)

    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.create_my_o_auth2_client_credential(
        my_o_auth2_client_credential=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@my_request_group.command(name=cli_util.override('identity_domains.create_my_request.command_name', 'create'), help=u"""Create a Request

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](createMyRequest)""")
@cli_util.option('--schemas', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--justification', required=True, help=u"""justification

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: true  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--requesting', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--attributes', help=u"""A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.""")
@cli_util.option('--attribute-sets', type=custom_types.CliCaseInsensitiveChoice(["all", "always", "never", "request", "default"]), multiple=True, help=u"""A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.""")
@cli_util.option('--id', help=u"""Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--ocid', help=u"""Unique OCI identifier for the SCIM Resource.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: string  - uniqueness: global""")
@cli_util.option('--meta', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-created-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-last-modified-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-prevented-operations', type=custom_types.CliCaseInsensitiveChoice(["replace", "update", "delete"]), help=u"""Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of tags on this resource.

**SCIM++ Properties:**  - idcsCompositeKey: [key, value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type Tags.  For documentation on tags please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/Tags.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--delete-in-progress', type=click.BOOL, help=u"""A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--idcs-last-upgraded-in-release', help=u"""The release number when the resource was upgraded.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--domain-ocid', help=u"""OCI Domain Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--compartment-ocid', help=u"""OCI Compartment Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--tenancy-ocid', help=u"""OCI Tenant Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--status', type=custom_types.CliCaseInsensitiveChoice(["CREATED", "COMPLETE", "IN_PROGRESS", "APPROVED", "REJECTED", "CANCELED", "EXPIRED", "FAILED"]), help=u"""status

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--action', type=custom_types.CliCaseInsensitiveChoice(["CANCEL", "ESCALATE"]), help=u"""Requestor can set action to CANCEL to cancel the request or to ESCALATE to escalate the request while the request status is IN_PROGRESS. Requestor can't escalate the request if canceling or escalation is in progress.

**Added In:** 2307071836

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--expires', help=u"""Time by when Request expires

**Added In:** 2307071836

**SCIM++ Properties:**  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: dateTime  - uniqueness: none""")
@cli_util.option('--approval-details', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Approvals created for this request.

**Added In:** 2307071836

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type MyRequestApprovalDetails.  For documentation on MyRequestApprovalDetails please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/MyRequestApprovalDetails.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--requestor', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'approval-details': {'module': 'identity_domains', 'class': 'list[MyRequestApprovalDetails]'}, 'requestor': {'module': 'identity_domains', 'class': 'MyRequestRequestor'}, 'requesting': {'module': 'identity_domains', 'class': 'MyRequestRequesting'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'approval-details': {'module': 'identity_domains', 'class': 'list[MyRequestApprovalDetails]'}, 'requestor': {'module': 'identity_domains', 'class': 'MyRequestRequestor'}, 'requesting': {'module': 'identity_domains', 'class': 'MyRequestRequesting'}}, output_type={'module': 'identity_domains', 'class': 'MyRequest'})
@cli_util.wrap_exceptions
def create_my_request(ctx, from_json, schemas, justification, requesting, authorization, resource_type_schema_version, attributes, attribute_sets, id, ocid, meta, idcs_created_by, idcs_last_modified_by, idcs_prevented_operations, tags, delete_in_progress, idcs_last_upgraded_in_release, domain_ocid, compartment_ocid, tenancy_ocid, status, action, expires, approval_details, requestor):

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if attributes is not None:
        kwargs['attributes'] = attributes
    if attribute_sets is not None and len(attribute_sets) > 0:
        kwargs['attribute_sets'] = attribute_sets

    _details = {}
    _details['schemas'] = cli_util.parse_json_parameter("schemas", schemas)
    _details['justification'] = justification
    _details['requesting'] = cli_util.parse_json_parameter("requesting", requesting)

    if id is not None:
        _details['id'] = id

    if ocid is not None:
        _details['ocid'] = ocid

    if meta is not None:
        _details['meta'] = cli_util.parse_json_parameter("meta", meta)

    if idcs_created_by is not None:
        _details['idcsCreatedBy'] = cli_util.parse_json_parameter("idcs_created_by", idcs_created_by)

    if idcs_last_modified_by is not None:
        _details['idcsLastModifiedBy'] = cli_util.parse_json_parameter("idcs_last_modified_by", idcs_last_modified_by)

    if idcs_prevented_operations is not None:
        _details['idcsPreventedOperations'] = cli_util.parse_json_parameter("idcs_prevented_operations", idcs_prevented_operations)

    if tags is not None:
        _details['tags'] = cli_util.parse_json_parameter("tags", tags)

    if delete_in_progress is not None:
        _details['deleteInProgress'] = delete_in_progress

    if idcs_last_upgraded_in_release is not None:
        _details['idcsLastUpgradedInRelease'] = idcs_last_upgraded_in_release

    if domain_ocid is not None:
        _details['domainOcid'] = domain_ocid

    if compartment_ocid is not None:
        _details['compartmentOcid'] = compartment_ocid

    if tenancy_ocid is not None:
        _details['tenancyOcid'] = tenancy_ocid

    if status is not None:
        _details['status'] = status

    if action is not None:
        _details['action'] = action

    if expires is not None:
        _details['expires'] = expires

    if approval_details is not None:
        _details['approvalDetails'] = cli_util.parse_json_parameter("approval_details", approval_details)

    if requestor is not None:
        _details['requestor'] = cli_util.parse_json_parameter("requestor", requestor)

    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.create_my_request(
        my_request=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@my_smtp_credential_group.command(name=cli_util.override('identity_domains.create_my_smtp_credential.command_name', 'create'), help=u"""Create a user's own SMTP credential.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](createMySmtpCredential)""")
@cli_util.option('--schemas', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--user-name', required=True, help=u"""User name

**SCIM++ Properties:**  - caseExact: false  - type: string  - mutability: readOnly  - required: true  - returned: default""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--id', help=u"""Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--ocid', help=u"""Unique OCI identifier for the SCIM Resource.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: string  - uniqueness: global""")
@cli_util.option('--meta', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-created-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-last-modified-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-prevented-operations', type=custom_types.CliCaseInsensitiveChoice(["replace", "update", "delete"]), help=u"""Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of tags on this resource.

**SCIM++ Properties:**  - idcsCompositeKey: [key, value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type Tags.  For documentation on tags please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/Tags.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--delete-in-progress', type=click.BOOL, help=u"""A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--idcs-last-upgraded-in-release', help=u"""The release number when the resource was upgraded.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--domain-ocid', help=u"""OCI Domain Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--compartment-ocid', help=u"""OCI Compartment Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--tenancy-ocid', help=u"""OCI Tenant Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--description', help=u"""Description

**SCIM++ Properties:**  - caseExact: false  - type: string  - mutability: readWrite  - required: false  - returned: default""")
@cli_util.option('--status', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "INACTIVE"]), help=u"""User credential status

**Added In:** 2109090424

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: never  - type: string  - uniqueness: none""")
@cli_util.option('--expires-on', help=u"""User credential expires on

**Added In:** 2109090424

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: dateTime  - uniqueness: none""")
@cli_util.option('--user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'user': {'module': 'identity_domains', 'class': 'MySmtpCredentialUser'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'user': {'module': 'identity_domains', 'class': 'MySmtpCredentialUser'}}, output_type={'module': 'identity_domains', 'class': 'MySmtpCredential'})
@cli_util.wrap_exceptions
def create_my_smtp_credential(ctx, from_json, schemas, user_name, authorization, resource_type_schema_version, id, ocid, meta, idcs_created_by, idcs_last_modified_by, idcs_prevented_operations, tags, delete_in_progress, idcs_last_upgraded_in_release, domain_ocid, compartment_ocid, tenancy_ocid, description, status, expires_on, user):

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version

    _details = {}
    _details['schemas'] = cli_util.parse_json_parameter("schemas", schemas)
    _details['userName'] = user_name

    if id is not None:
        _details['id'] = id

    if ocid is not None:
        _details['ocid'] = ocid

    if meta is not None:
        _details['meta'] = cli_util.parse_json_parameter("meta", meta)

    if idcs_created_by is not None:
        _details['idcsCreatedBy'] = cli_util.parse_json_parameter("idcs_created_by", idcs_created_by)

    if idcs_last_modified_by is not None:
        _details['idcsLastModifiedBy'] = cli_util.parse_json_parameter("idcs_last_modified_by", idcs_last_modified_by)

    if idcs_prevented_operations is not None:
        _details['idcsPreventedOperations'] = cli_util.parse_json_parameter("idcs_prevented_operations", idcs_prevented_operations)

    if tags is not None:
        _details['tags'] = cli_util.parse_json_parameter("tags", tags)

    if delete_in_progress is not None:
        _details['deleteInProgress'] = delete_in_progress

    if idcs_last_upgraded_in_release is not None:
        _details['idcsLastUpgradedInRelease'] = idcs_last_upgraded_in_release

    if domain_ocid is not None:
        _details['domainOcid'] = domain_ocid

    if compartment_ocid is not None:
        _details['compartmentOcid'] = compartment_ocid

    if tenancy_ocid is not None:
        _details['tenancyOcid'] = tenancy_ocid

    if description is not None:
        _details['description'] = description

    if status is not None:
        _details['status'] = status

    if expires_on is not None:
        _details['expiresOn'] = expires_on

    if user is not None:
        _details['user'] = cli_util.parse_json_parameter("user", user)

    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.create_my_smtp_credential(
        my_smtp_credential=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@my_support_account_group.command(name=cli_util.override('identity_domains.create_my_support_account.command_name', 'create'), help=u"""Create a user's own support account.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](createMySupportAccount)""")
@cli_util.option('--schemas', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--token', required=True, help=u"""User Support Account Token

**Added In:** 2102181953

**SCIM++ Properties:**  - caseExact: false  - multiValued: false  - required: true  - returned: never  - type: string  - uniqueness: none""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--id', help=u"""Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--ocid', help=u"""Unique OCI identifier for the SCIM Resource.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: string  - uniqueness: global""")
@cli_util.option('--meta', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-created-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-last-modified-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-prevented-operations', type=custom_types.CliCaseInsensitiveChoice(["replace", "update", "delete"]), help=u"""Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of tags on this resource.

**SCIM++ Properties:**  - idcsCompositeKey: [key, value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type Tags.  For documentation on tags please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/Tags.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--delete-in-progress', type=click.BOOL, help=u"""A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--idcs-last-upgraded-in-release', help=u"""The release number when the resource was upgraded.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--domain-ocid', help=u"""OCI Domain Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--compartment-ocid', help=u"""OCI Compartment Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--tenancy-ocid', help=u"""OCI Tenant Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--provider', type=custom_types.CliCaseInsensitiveChoice(["MOS"]), help=u"""User Support Account Provider

**Added In:** 2102181953

**SCIM++ Properties:**  - caseExact: false  - multiValued: false  - idcsSearchable: true  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--user-id', help=u"""User Support User Id

**Added In:** 2102181953

**SCIM++ Properties:**  - caseExact: false  - multiValued: false  - mutability: readOnly  - idcsSearchable: true  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'user': {'module': 'identity_domains', 'class': 'MySupportAccountUser'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'user': {'module': 'identity_domains', 'class': 'MySupportAccountUser'}}, output_type={'module': 'identity_domains', 'class': 'MySupportAccount'})
@cli_util.wrap_exceptions
def create_my_support_account(ctx, from_json, schemas, token, authorization, resource_type_schema_version, id, ocid, meta, idcs_created_by, idcs_last_modified_by, idcs_prevented_operations, tags, delete_in_progress, idcs_last_upgraded_in_release, domain_ocid, compartment_ocid, tenancy_ocid, provider, user_id, user):

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version

    _details = {}
    _details['schemas'] = cli_util.parse_json_parameter("schemas", schemas)
    _details['token'] = token

    if id is not None:
        _details['id'] = id

    if ocid is not None:
        _details['ocid'] = ocid

    if meta is not None:
        _details['meta'] = cli_util.parse_json_parameter("meta", meta)

    if idcs_created_by is not None:
        _details['idcsCreatedBy'] = cli_util.parse_json_parameter("idcs_created_by", idcs_created_by)

    if idcs_last_modified_by is not None:
        _details['idcsLastModifiedBy'] = cli_util.parse_json_parameter("idcs_last_modified_by", idcs_last_modified_by)

    if idcs_prevented_operations is not None:
        _details['idcsPreventedOperations'] = cli_util.parse_json_parameter("idcs_prevented_operations", idcs_prevented_operations)

    if tags is not None:
        _details['tags'] = cli_util.parse_json_parameter("tags", tags)

    if delete_in_progress is not None:
        _details['deleteInProgress'] = delete_in_progress

    if idcs_last_upgraded_in_release is not None:
        _details['idcsLastUpgradedInRelease'] = idcs_last_upgraded_in_release

    if domain_ocid is not None:
        _details['domainOcid'] = domain_ocid

    if compartment_ocid is not None:
        _details['compartmentOcid'] = compartment_ocid

    if tenancy_ocid is not None:
        _details['tenancyOcid'] = tenancy_ocid

    if provider is not None:
        _details['provider'] = provider

    if user_id is not None:
        _details['userId'] = user_id

    if user is not None:
        _details['user'] = cli_util.parse_json_parameter("user", user)

    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.create_my_support_account(
        my_support_account=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@my_user_db_credential_group.command(name=cli_util.override('identity_domains.create_my_user_db_credential.command_name', 'create'), help=u"""Create a user's own database (DB) credential.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](createMyUserDbCredential)""")
@cli_util.option('--schemas', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--db-password', required=True, help=u"""The user's database password.

**SCIM++ Properties:**  - type: string  - mutability: immutable  - returned: default  - required: true""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--id', help=u"""Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--ocid', help=u"""Unique OCI identifier for the SCIM Resource.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: string  - uniqueness: global""")
@cli_util.option('--meta', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-created-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-last-modified-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-prevented-operations', type=custom_types.CliCaseInsensitiveChoice(["replace", "update", "delete"]), help=u"""Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of tags on this resource.

**SCIM++ Properties:**  - idcsCompositeKey: [key, value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type Tags.  For documentation on tags please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/Tags.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--delete-in-progress', type=click.BOOL, help=u"""A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--idcs-last-upgraded-in-release', help=u"""The release number when the resource was upgraded.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--domain-ocid', help=u"""OCI Domain Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--compartment-ocid', help=u"""OCI Compartment Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--tenancy-ocid', help=u"""OCI Tenant Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--name', help=u"""Name

**Added In:** 2109090424

**SCIM++ Properties:**  - caseExact: false  - type: string  - mutability: readOnly  - required: false  - returned: default""")
@cli_util.option('--description', help=u"""Description

**Added In:** 2109020413

**SCIM++ Properties:**  - caseExact: false  - type: string  - mutability: readWrite  - required: false  - returned: default""")
@cli_util.option('--mixed-db-password', help=u"""The user's database password with mixed salt.

**SCIM++ Properties:**  - type: string  - mutability: readOnly  - returned: default  - required: false""")
@cli_util.option('--salt', help=u"""The salt of the password.

**SCIM++ Properties:**  - type: string  - mutability: readOnly  - returned: default  - required: false""")
@cli_util.option('--mixed-salt', help=u"""The mixed salt of the password.

**SCIM++ Properties:**  - type: string  - mutability: readOnly  - returned: default  - required: false""")
@cli_util.option('--last-set-date', help=u"""A DateTime that specifies the date and time when the current database password was set.

**SCIM++ Properties:**  - type: dateTime  - mutability: readOnly  - returned: default""")
@cli_util.option('--expired', type=click.BOOL, help=u"""Indicates that the database password has expired.

**SCIM++ Properties:**  - type: boolean  - mutability: readOnly  - returned: default""")
@cli_util.option('--status', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "INACTIVE"]), help=u"""User credential status

**Added In:** 2109090424

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: never  - type: string  - uniqueness: none""")
@cli_util.option('--expires-on', help=u"""When the user credential expires.

**Added In:** 2109090424

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: dateTime  - uniqueness: none""")
@cli_util.option('--user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'user': {'module': 'identity_domains', 'class': 'MyUserDbCredentialsUser'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'user': {'module': 'identity_domains', 'class': 'MyUserDbCredentialsUser'}}, output_type={'module': 'identity_domains', 'class': 'MyUserDbCredential'})
@cli_util.wrap_exceptions
def create_my_user_db_credential(ctx, from_json, schemas, db_password, authorization, resource_type_schema_version, id, ocid, meta, idcs_created_by, idcs_last_modified_by, idcs_prevented_operations, tags, delete_in_progress, idcs_last_upgraded_in_release, domain_ocid, compartment_ocid, tenancy_ocid, name, description, mixed_db_password, salt, mixed_salt, last_set_date, expired, status, expires_on, user):

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version

    _details = {}
    _details['schemas'] = cli_util.parse_json_parameter("schemas", schemas)
    _details['dbPassword'] = db_password

    if id is not None:
        _details['id'] = id

    if ocid is not None:
        _details['ocid'] = ocid

    if meta is not None:
        _details['meta'] = cli_util.parse_json_parameter("meta", meta)

    if idcs_created_by is not None:
        _details['idcsCreatedBy'] = cli_util.parse_json_parameter("idcs_created_by", idcs_created_by)

    if idcs_last_modified_by is not None:
        _details['idcsLastModifiedBy'] = cli_util.parse_json_parameter("idcs_last_modified_by", idcs_last_modified_by)

    if idcs_prevented_operations is not None:
        _details['idcsPreventedOperations'] = cli_util.parse_json_parameter("idcs_prevented_operations", idcs_prevented_operations)

    if tags is not None:
        _details['tags'] = cli_util.parse_json_parameter("tags", tags)

    if delete_in_progress is not None:
        _details['deleteInProgress'] = delete_in_progress

    if idcs_last_upgraded_in_release is not None:
        _details['idcsLastUpgradedInRelease'] = idcs_last_upgraded_in_release

    if domain_ocid is not None:
        _details['domainOcid'] = domain_ocid

    if compartment_ocid is not None:
        _details['compartmentOcid'] = compartment_ocid

    if tenancy_ocid is not None:
        _details['tenancyOcid'] = tenancy_ocid

    if name is not None:
        _details['name'] = name

    if description is not None:
        _details['description'] = description

    if mixed_db_password is not None:
        _details['mixedDbPassword'] = mixed_db_password

    if salt is not None:
        _details['salt'] = salt

    if mixed_salt is not None:
        _details['mixedSalt'] = mixed_salt

    if last_set_date is not None:
        _details['lastSetDate'] = last_set_date

    if expired is not None:
        _details['expired'] = expired

    if status is not None:
        _details['status'] = status

    if expires_on is not None:
        _details['expiresOn'] = expires_on

    if user is not None:
        _details['user'] = cli_util.parse_json_parameter("user", user)

    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.create_my_user_db_credential(
        my_user_db_credential=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@network_perimeter_group.command(name=cli_util.override('identity_domains.create_network_perimeter.command_name', 'create'), help=u"""Create a NetworkPerimeter

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](createNetworkPerimeter)""")
@cli_util.option('--schemas', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--name', required=True, help=u"""NetworkPerimeter name

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: true  - returned: always  - type: string  - uniqueness: server""")
@cli_util.option('--ip-addresses', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""IPAddresses or Ranges assigned to the NetworkPerimeter

**SCIM++ Properties:**  - idcsCompositeKey: [value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: true  - returned: default  - type: complex  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--attributes', help=u"""A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.""")
@cli_util.option('--attribute-sets', type=custom_types.CliCaseInsensitiveChoice(["all", "always", "never", "request", "default"]), multiple=True, help=u"""A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.""")
@cli_util.option('--id', help=u"""Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--ocid', help=u"""Unique OCI identifier for the SCIM Resource.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: string  - uniqueness: global""")
@cli_util.option('--meta', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-created-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-last-modified-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-prevented-operations', type=custom_types.CliCaseInsensitiveChoice(["replace", "update", "delete"]), help=u"""Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of tags on this resource.

**SCIM++ Properties:**  - idcsCompositeKey: [key, value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type Tags.  For documentation on tags please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/Tags.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--delete-in-progress', type=click.BOOL, help=u"""A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--idcs-last-upgraded-in-release', help=u"""The release number when the resource was upgraded.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--domain-ocid', help=u"""OCI Domain Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--compartment-ocid', help=u"""OCI Compartment Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--tenancy-ocid', help=u"""OCI Tenant Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--external-id', help=u"""An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value.  The value of the externalId attribute is always issued be the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--description', help=u"""NetworkPerimeter Description

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@json_skeleton_utils.get_cli_json_input_option({'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'ip-addresses': {'module': 'identity_domains', 'class': 'list[NetworkPerimeterIpAddresses]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'ip-addresses': {'module': 'identity_domains', 'class': 'list[NetworkPerimeterIpAddresses]'}}, output_type={'module': 'identity_domains', 'class': 'NetworkPerimeter'})
@cli_util.wrap_exceptions
def create_network_perimeter(ctx, from_json, schemas, name, ip_addresses, authorization, resource_type_schema_version, attributes, attribute_sets, id, ocid, meta, idcs_created_by, idcs_last_modified_by, idcs_prevented_operations, tags, delete_in_progress, idcs_last_upgraded_in_release, domain_ocid, compartment_ocid, tenancy_ocid, external_id, description):

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if attributes is not None:
        kwargs['attributes'] = attributes
    if attribute_sets is not None and len(attribute_sets) > 0:
        kwargs['attribute_sets'] = attribute_sets

    _details = {}
    _details['schemas'] = cli_util.parse_json_parameter("schemas", schemas)
    _details['name'] = name
    _details['ipAddresses'] = cli_util.parse_json_parameter("ip_addresses", ip_addresses)

    if id is not None:
        _details['id'] = id

    if ocid is not None:
        _details['ocid'] = ocid

    if meta is not None:
        _details['meta'] = cli_util.parse_json_parameter("meta", meta)

    if idcs_created_by is not None:
        _details['idcsCreatedBy'] = cli_util.parse_json_parameter("idcs_created_by", idcs_created_by)

    if idcs_last_modified_by is not None:
        _details['idcsLastModifiedBy'] = cli_util.parse_json_parameter("idcs_last_modified_by", idcs_last_modified_by)

    if idcs_prevented_operations is not None:
        _details['idcsPreventedOperations'] = cli_util.parse_json_parameter("idcs_prevented_operations", idcs_prevented_operations)

    if tags is not None:
        _details['tags'] = cli_util.parse_json_parameter("tags", tags)

    if delete_in_progress is not None:
        _details['deleteInProgress'] = delete_in_progress

    if idcs_last_upgraded_in_release is not None:
        _details['idcsLastUpgradedInRelease'] = idcs_last_upgraded_in_release

    if domain_ocid is not None:
        _details['domainOcid'] = domain_ocid

    if compartment_ocid is not None:
        _details['compartmentOcid'] = compartment_ocid

    if tenancy_ocid is not None:
        _details['tenancyOcid'] = tenancy_ocid

    if external_id is not None:
        _details['externalId'] = external_id

    if description is not None:
        _details['description'] = description

    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.create_network_perimeter(
        network_perimeter=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@o_auth2_client_credential_group.command(name=cli_util.override('identity_domains.create_o_auth2_client_credential.command_name', 'create'), help=u"""Add a user's OAuth2 client credentials.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](createOAuth2ClientCredential)""")
@cli_util.option('--schemas', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--name', required=True, help=u"""Name

**SCIM++ Properties:**  - caseExact: false  - type: string  - mutability: readWrite  - required: true  - returned: default""")
@cli_util.option('--scopes', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""Scopes

**SCIM++ Properties:**  - caseExact: false  - idcsCompositeKey: [audience, scope]  - type: complex  - mutability: readWrite  - multiValued: true  - required: true  - returned: default""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--attributes', help=u"""A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.""")
@cli_util.option('--attribute-sets', type=custom_types.CliCaseInsensitiveChoice(["all", "always", "never", "request", "default"]), multiple=True, help=u"""A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.""")
@cli_util.option('--id', help=u"""Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--ocid', help=u"""Unique OCI identifier for the SCIM Resource.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: string  - uniqueness: global""")
@cli_util.option('--meta', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-created-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-last-modified-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-prevented-operations', type=custom_types.CliCaseInsensitiveChoice(["replace", "update", "delete"]), help=u"""Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of tags on this resource.

**SCIM++ Properties:**  - idcsCompositeKey: [key, value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type Tags.  For documentation on tags please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/Tags.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--delete-in-progress', type=click.BOOL, help=u"""A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--idcs-last-upgraded-in-release', help=u"""The release number when the resource was upgraded.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--domain-ocid', help=u"""OCI Domain Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--compartment-ocid', help=u"""OCI Compartment Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--tenancy-ocid', help=u"""OCI Tenant Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--description', help=u"""Description

**Added In:** 2101262133

**SCIM++ Properties:**  - caseExact: false  - type: string  - mutability: readWrite  - required: false  - returned: default""")
@cli_util.option('--status', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "INACTIVE"]), help=u"""The user's credential status.

**Added In:** 2109090424

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: never  - type: string  - uniqueness: none""")
@cli_util.option('--expires-on', help=u"""When the user's credentials expire.

**Added In:** 2109090424

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: dateTime  - uniqueness: none""")
@cli_util.option('--is-reset-secret', type=click.BOOL, help=u"""Specifies whether the secret must be reset.

**Added In:** 2109090424

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: writeOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--secret', help=u"""Secret

**SCIM++ Properties:**  - caseExact: false  - type: string  - mutability: readOnly  - required: false  - returned: default  - idcsScimCompliant: false  - idcsSensitive: hash_sc""")
@cli_util.option('--user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionself-change-user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'scopes': {'module': 'identity_domains', 'class': 'list[OAuth2ClientCredentialScopes]'}, 'user': {'module': 'identity_domains', 'class': 'OAuth2ClientCredentialUser'}, 'urnietfparamsscimschemasoracleidcsextensionself-change-user': {'module': 'identity_domains', 'class': 'ExtensionSelfChangeUser'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'scopes': {'module': 'identity_domains', 'class': 'list[OAuth2ClientCredentialScopes]'}, 'user': {'module': 'identity_domains', 'class': 'OAuth2ClientCredentialUser'}, 'urnietfparamsscimschemasoracleidcsextensionself-change-user': {'module': 'identity_domains', 'class': 'ExtensionSelfChangeUser'}}, output_type={'module': 'identity_domains', 'class': 'OAuth2ClientCredential'})
@cli_util.wrap_exceptions
def create_o_auth2_client_credential(ctx, from_json, schemas, name, scopes, authorization, resource_type_schema_version, attributes, attribute_sets, id, ocid, meta, idcs_created_by, idcs_last_modified_by, idcs_prevented_operations, tags, delete_in_progress, idcs_last_upgraded_in_release, domain_ocid, compartment_ocid, tenancy_ocid, description, status, expires_on, is_reset_secret, secret, user, urnietfparamsscimschemasoracleidcsextensionself_change_user):

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if attributes is not None:
        kwargs['attributes'] = attributes
    if attribute_sets is not None and len(attribute_sets) > 0:
        kwargs['attribute_sets'] = attribute_sets

    _details = {}
    _details['schemas'] = cli_util.parse_json_parameter("schemas", schemas)
    _details['name'] = name
    _details['scopes'] = cli_util.parse_json_parameter("scopes", scopes)

    if id is not None:
        _details['id'] = id

    if ocid is not None:
        _details['ocid'] = ocid

    if meta is not None:
        _details['meta'] = cli_util.parse_json_parameter("meta", meta)

    if idcs_created_by is not None:
        _details['idcsCreatedBy'] = cli_util.parse_json_parameter("idcs_created_by", idcs_created_by)

    if idcs_last_modified_by is not None:
        _details['idcsLastModifiedBy'] = cli_util.parse_json_parameter("idcs_last_modified_by", idcs_last_modified_by)

    if idcs_prevented_operations is not None:
        _details['idcsPreventedOperations'] = cli_util.parse_json_parameter("idcs_prevented_operations", idcs_prevented_operations)

    if tags is not None:
        _details['tags'] = cli_util.parse_json_parameter("tags", tags)

    if delete_in_progress is not None:
        _details['deleteInProgress'] = delete_in_progress

    if idcs_last_upgraded_in_release is not None:
        _details['idcsLastUpgradedInRelease'] = idcs_last_upgraded_in_release

    if domain_ocid is not None:
        _details['domainOcid'] = domain_ocid

    if compartment_ocid is not None:
        _details['compartmentOcid'] = compartment_ocid

    if tenancy_ocid is not None:
        _details['tenancyOcid'] = tenancy_ocid

    if description is not None:
        _details['description'] = description

    if status is not None:
        _details['status'] = status

    if expires_on is not None:
        _details['expiresOn'] = expires_on

    if is_reset_secret is not None:
        _details['isResetSecret'] = is_reset_secret

    if secret is not None:
        _details['secret'] = secret

    if user is not None:
        _details['user'] = cli_util.parse_json_parameter("user", user)

    if urnietfparamsscimschemasoracleidcsextensionself_change_user is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:selfChange:User'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionself_change_user", urnietfparamsscimschemasoracleidcsextensionself_change_user)

    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.create_o_auth2_client_credential(
        o_auth2_client_credential=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@o_auth_client_certificate_group.command(name=cli_util.override('identity_domains.create_o_auth_client_certificate.command_name', 'create'), help=u"""Create an OAuth Client Certificate

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](createOAuthClientCertificate)""")
@cli_util.option('--schemas', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--certificate-alias', required=True, help=u"""Certificate alias

**SCIM++ Properties:**  - type: string  - multiValued: false  - required: true  - caseExact: false  - mutability: readWrite  - returned: always  - uniqueness: none  - idcsSearchable: true""")
@cli_util.option('--x509-base64-certificate', required=True, help=u"""Base 64Key data attribute

**SCIM++ Properties:**  - caseExact: true  - multiValued: false  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--id', help=u"""Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--ocid', help=u"""Unique OCI identifier for the SCIM Resource.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: string  - uniqueness: global""")
@cli_util.option('--meta', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-created-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-last-modified-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-prevented-operations', type=custom_types.CliCaseInsensitiveChoice(["replace", "update", "delete"]), help=u"""Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of tags on this resource.

**SCIM++ Properties:**  - idcsCompositeKey: [key, value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type Tags.  For documentation on tags please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/Tags.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--delete-in-progress', type=click.BOOL, help=u"""A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--idcs-last-upgraded-in-release', help=u"""The release number when the resource was upgraded.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--domain-ocid', help=u"""OCI Domain Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--compartment-ocid', help=u"""OCI Compartment Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--tenancy-ocid', help=u"""OCI Tenant Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--external-id', help=u"""An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

**SCIM++ Properties:**  - type: string  - multiValued: false  - required: false  - caseExact: false  - mutability: readWrite  - returned: default  - uniqueness: none""")
@cli_util.option('--key-store-name', help=u"""Key store name

**SCIM++ Properties:**  - type: string  - multiValued: false  - required: false  - caseExact: false  - returned: always  - uniqueness: none""")
@cli_util.option('--map', help=u"""Map

**SCIM++ Properties:**  - type: string  - multiValued: false  - required: false  - caseExact: false  - returned: always  - uniqueness: none""")
@cli_util.option('--key-store-password', help=u"""Key store password

**SCIM++ Properties:**  - type: string  - multiValued: false  - idcsSensitive: none  - required: false  - caseExact: true  - returned: never  - uniqueness: none""")
@cli_util.option('--key-store-id', help=u"""Key store ID

**SCIM++ Properties:**  - type: string  - multiValued: false  - required: false  - caseExact: true  - returned: never  - uniqueness: none  - idcsSearchable: true""")
@cli_util.option('--sha1-thumbprint', help=u"""SHA-1 Thumbprint

**SCIM++ Properties:**  - type: string  - multiValued: false  - idcsSearchable: true  - required: false  - caseExact: true  - returned: default  - uniqueness: none""")
@cli_util.option('--sha256-thumbprint', help=u"""SHA-256 Thumbprint

**SCIM++ Properties:**  - type: string  - multiValued: false  - idcsSearchable: true  - required: false  - caseExact: true  - returned: default  - uniqueness: none""")
@cli_util.option('--cert-start-date', help=u"""Certificate start date

**SCIM++ Properties:**  - type: dateTime  - multiValued: false  - required: false  - caseExact: true  - mutability: readWrite  - returned: default  - uniqueness: none""")
@cli_util.option('--cert-end-date', help=u"""Certificate end date

**SCIM++ Properties:**  - type: dateTime  - multiValued: false  - required: false  - caseExact: true  - mutability: readWrite  - returned: default  - uniqueness: none""")
@json_skeleton_utils.get_cli_json_input_option({'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}}, output_type={'module': 'identity_domains', 'class': 'OAuthClientCertificate'})
@cli_util.wrap_exceptions
def create_o_auth_client_certificate(ctx, from_json, schemas, certificate_alias, x509_base64_certificate, authorization, resource_type_schema_version, id, ocid, meta, idcs_created_by, idcs_last_modified_by, idcs_prevented_operations, tags, delete_in_progress, idcs_last_upgraded_in_release, domain_ocid, compartment_ocid, tenancy_ocid, external_id, key_store_name, map, key_store_password, key_store_id, sha1_thumbprint, sha256_thumbprint, cert_start_date, cert_end_date):

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version

    _details = {}
    _details['schemas'] = cli_util.parse_json_parameter("schemas", schemas)
    _details['certificateAlias'] = certificate_alias
    _details['x509Base64Certificate'] = x509_base64_certificate

    if id is not None:
        _details['id'] = id

    if ocid is not None:
        _details['ocid'] = ocid

    if meta is not None:
        _details['meta'] = cli_util.parse_json_parameter("meta", meta)

    if idcs_created_by is not None:
        _details['idcsCreatedBy'] = cli_util.parse_json_parameter("idcs_created_by", idcs_created_by)

    if idcs_last_modified_by is not None:
        _details['idcsLastModifiedBy'] = cli_util.parse_json_parameter("idcs_last_modified_by", idcs_last_modified_by)

    if idcs_prevented_operations is not None:
        _details['idcsPreventedOperations'] = cli_util.parse_json_parameter("idcs_prevented_operations", idcs_prevented_operations)

    if tags is not None:
        _details['tags'] = cli_util.parse_json_parameter("tags", tags)

    if delete_in_progress is not None:
        _details['deleteInProgress'] = delete_in_progress

    if idcs_last_upgraded_in_release is not None:
        _details['idcsLastUpgradedInRelease'] = idcs_last_upgraded_in_release

    if domain_ocid is not None:
        _details['domainOcid'] = domain_ocid

    if compartment_ocid is not None:
        _details['compartmentOcid'] = compartment_ocid

    if tenancy_ocid is not None:
        _details['tenancyOcid'] = tenancy_ocid

    if external_id is not None:
        _details['externalId'] = external_id

    if key_store_name is not None:
        _details['keyStoreName'] = key_store_name

    if map is not None:
        _details['map'] = map

    if key_store_password is not None:
        _details['keyStorePassword'] = key_store_password

    if key_store_id is not None:
        _details['keyStoreId'] = key_store_id

    if sha1_thumbprint is not None:
        _details['sha1Thumbprint'] = sha1_thumbprint

    if sha256_thumbprint is not None:
        _details['sha256Thumbprint'] = sha256_thumbprint

    if cert_start_date is not None:
        _details['certStartDate'] = cert_start_date

    if cert_end_date is not None:
        _details['certEndDate'] = cert_end_date

    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.create_o_auth_client_certificate(
        o_auth_client_certificate=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@o_auth_partner_certificate_group.command(name=cli_util.override('identity_domains.create_o_auth_partner_certificate.command_name', 'create'), help=u"""Create an OAuth Partner Certificate

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](createOAuthPartnerCertificate)""")
@cli_util.option('--schemas', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--certificate-alias', required=True, help=u"""Certificate alias

**SCIM++ Properties:**  - type: string  - multiValued: false  - required: true  - caseExact: false  - mutability: readWrite  - returned: always  - uniqueness: none  - idcsSearchable: true""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--id', help=u"""Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--ocid', help=u"""Unique OCI identifier for the SCIM Resource.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: string  - uniqueness: global""")
@cli_util.option('--meta', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-created-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-last-modified-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-prevented-operations', type=custom_types.CliCaseInsensitiveChoice(["replace", "update", "delete"]), help=u"""Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of tags on this resource.

**SCIM++ Properties:**  - idcsCompositeKey: [key, value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type Tags.  For documentation on tags please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/Tags.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--delete-in-progress', type=click.BOOL, help=u"""A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--idcs-last-upgraded-in-release', help=u"""The release number when the resource was upgraded.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--domain-ocid', help=u"""OCI Domain Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--compartment-ocid', help=u"""OCI Compartment Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--tenancy-ocid', help=u"""OCI Tenant Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--external-id', help=u"""An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

**SCIM++ Properties:**  - type: string  - multiValued: false  - required: false  - caseExact: false  - mutability: readWrite  - returned: default  - uniqueness: none""")
@cli_util.option('--key-store-name', help=u"""Key store name

**SCIM++ Properties:**  - type: string  - multiValued: false  - required: false  - caseExact: false  - returned: always  - uniqueness: none""")
@cli_util.option('--map', help=u"""Map

**SCIM++ Properties:**  - type: string  - multiValued: false  - required: false  - caseExact: false  - returned: always  - uniqueness: none""")
@cli_util.option('--key-store-password', help=u"""Key store password

**SCIM++ Properties:**  - type: string  - multiValued: false  - idcsSensitive: none  - required: false  - caseExact: true  - returned: never  - uniqueness: none""")
@cli_util.option('--key-store-id', help=u"""Key store ID

**SCIM++ Properties:**  - type: string  - multiValued: false  - required: false  - caseExact: true  - returned: never  - uniqueness: none  - idcsSearchable: true""")
@cli_util.option('--sha1-thumbprint', help=u"""SHA-1 Thumbprint

**SCIM++ Properties:**  - type: string  - multiValued: false  - required: false  - caseExact: true  - returned: default  - idcsSearchable: true  - uniqueness: none""")
@cli_util.option('--sha256-thumbprint', help=u"""SHA-256 Thumbprint

**SCIM++ Properties:**  - type: string  - multiValued: false  - required: false  - caseExact: true  - returned: default  - idcsSearchable: true  - uniqueness: none""")
@cli_util.option('--cert-start-date', help=u"""Certificate start date

**SCIM++ Properties:**  - type: dateTime  - multiValued: false  - required: false  - caseExact: true  - mutability: readWrite  - returned: default  - uniqueness: none""")
@cli_util.option('--x509-base64-certificate', help=u"""Base 64Key data attribute

**SCIM++ Properties:**  - caseExact: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--cert-end-date', help=u"""Certificate end date

**SCIM++ Properties:**  - type: dateTime  - multiValued: false  - required: false  - caseExact: true  - mutability: readWrite  - returned: default  - uniqueness: none""")
@json_skeleton_utils.get_cli_json_input_option({'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}}, output_type={'module': 'identity_domains', 'class': 'OAuthPartnerCertificate'})
@cli_util.wrap_exceptions
def create_o_auth_partner_certificate(ctx, from_json, schemas, certificate_alias, authorization, resource_type_schema_version, id, ocid, meta, idcs_created_by, idcs_last_modified_by, idcs_prevented_operations, tags, delete_in_progress, idcs_last_upgraded_in_release, domain_ocid, compartment_ocid, tenancy_ocid, external_id, key_store_name, map, key_store_password, key_store_id, sha1_thumbprint, sha256_thumbprint, cert_start_date, x509_base64_certificate, cert_end_date):

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version

    _details = {}
    _details['schemas'] = cli_util.parse_json_parameter("schemas", schemas)
    _details['certificateAlias'] = certificate_alias

    if id is not None:
        _details['id'] = id

    if ocid is not None:
        _details['ocid'] = ocid

    if meta is not None:
        _details['meta'] = cli_util.parse_json_parameter("meta", meta)

    if idcs_created_by is not None:
        _details['idcsCreatedBy'] = cli_util.parse_json_parameter("idcs_created_by", idcs_created_by)

    if idcs_last_modified_by is not None:
        _details['idcsLastModifiedBy'] = cli_util.parse_json_parameter("idcs_last_modified_by", idcs_last_modified_by)

    if idcs_prevented_operations is not None:
        _details['idcsPreventedOperations'] = cli_util.parse_json_parameter("idcs_prevented_operations", idcs_prevented_operations)

    if tags is not None:
        _details['tags'] = cli_util.parse_json_parameter("tags", tags)

    if delete_in_progress is not None:
        _details['deleteInProgress'] = delete_in_progress

    if idcs_last_upgraded_in_release is not None:
        _details['idcsLastUpgradedInRelease'] = idcs_last_upgraded_in_release

    if domain_ocid is not None:
        _details['domainOcid'] = domain_ocid

    if compartment_ocid is not None:
        _details['compartmentOcid'] = compartment_ocid

    if tenancy_ocid is not None:
        _details['tenancyOcid'] = tenancy_ocid

    if external_id is not None:
        _details['externalId'] = external_id

    if key_store_name is not None:
        _details['keyStoreName'] = key_store_name

    if map is not None:
        _details['map'] = map

    if key_store_password is not None:
        _details['keyStorePassword'] = key_store_password

    if key_store_id is not None:
        _details['keyStoreId'] = key_store_id

    if sha1_thumbprint is not None:
        _details['sha1Thumbprint'] = sha1_thumbprint

    if sha256_thumbprint is not None:
        _details['sha256Thumbprint'] = sha256_thumbprint

    if cert_start_date is not None:
        _details['certStartDate'] = cert_start_date

    if x509_base64_certificate is not None:
        _details['x509Base64Certificate'] = x509_base64_certificate

    if cert_end_date is not None:
        _details['certEndDate'] = cert_end_date

    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.create_o_auth_partner_certificate(
        o_auth_partner_certificate=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@password_policy_group.command(name=cli_util.override('identity_domains.create_password_policy.command_name', 'create'), help=u"""Create a password policy.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](createPasswordPolicy)""")
@cli_util.option('--schemas', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--name', required=True, help=u"""A String that is the name of the policy to display to the user. This is the only mandatory attribute for a password policy.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: true  - returned: always  - type: string  - uniqueness: server""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--attributes', help=u"""A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.""")
@cli_util.option('--attribute-sets', type=custom_types.CliCaseInsensitiveChoice(["all", "always", "never", "request", "default"]), multiple=True, help=u"""A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.""")
@cli_util.option('--id', help=u"""Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--ocid', help=u"""Unique OCI identifier for the SCIM Resource.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: string  - uniqueness: global""")
@cli_util.option('--meta', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-created-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-last-modified-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-prevented-operations', type=custom_types.CliCaseInsensitiveChoice(["replace", "update", "delete"]), help=u"""Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of tags on this resource.

**SCIM++ Properties:**  - idcsCompositeKey: [key, value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type Tags.  For documentation on tags please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/Tags.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--delete-in-progress', type=click.BOOL, help=u"""A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--idcs-last-upgraded-in-release', help=u"""The release number when the resource was upgraded.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--domain-ocid', help=u"""OCI Domain Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--compartment-ocid', help=u"""OCI Compartment Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--tenancy-ocid', help=u"""OCI Tenant Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--external-id', help=u"""An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

**SCIM++ Properties:**  - caseExact: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--description', help=u"""A String that describes the password policy

**SCIM++ Properties:**  - caseExact: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--max-length', type=click.INT, help=u"""The maximum password length (in characters). A value of 0 or no value indicates no maximum length restriction.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: integer  - uniqueness: none""")
@cli_util.option('--min-length', type=click.INT, help=u"""The minimum password length (in characters). A value of 0 or no value indicates no minimum length restriction.

**SCIM++ Properties:**  - caseExact: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: integer  - uniqueness: none""")
@cli_util.option('--min-alphas', type=click.INT, help=u"""The minimum number of alphabetic characters in a password.  A value of 0 or no value indicates no minimum alphas restriction.

**SCIM++ Properties:**  - caseExact: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: integer  - uniqueness: none""")
@cli_util.option('--min-numerals', type=click.INT, help=u"""The minimum number of numeric characters in a password.  A value of 0 or no value indicates no minimum numeric character restriction.

**SCIM++ Properties:**  - caseExact: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: integer  - uniqueness: none""")
@cli_util.option('--min-alpha-numerals', type=click.INT, help=u"""The minimum number of a combination of alphabetic and numeric characters in a password.  A value of 0 or no value indicates no minimum alphanumeric character restriction.

**SCIM++ Properties:**  - caseExact: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: integer  - uniqueness: none""")
@cli_util.option('--min-special-chars', type=click.INT, help=u"""The minimum number of special characters in a password. A value of 0 or no value indicates no minimum special characters restriction.

**SCIM++ Properties:**  - caseExact: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: integer  - uniqueness: none""")
@cli_util.option('--max-special-chars', type=click.INT, help=u"""The maximum number of special characters in a password.  A value of 0 or no value indicates no maximum special characters restriction.

**SCIM++ Properties:**  - caseExact: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: integer  - uniqueness: none""")
@cli_util.option('--min-lower-case', type=click.INT, help=u"""The minimum number of lowercase alphabetic characters in a password.  A value of 0 or no value indicates no minimum lowercase restriction.

**SCIM++ Properties:**  - caseExact: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: integer  - uniqueness: none""")
@cli_util.option('--min-upper-case', type=click.INT, help=u"""The minimum number of uppercase alphabetic characters in a password. A value of 0 or no value indicates no minimum uppercase restriction.

**SCIM++ Properties:**  - caseExact: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: integer  - uniqueness: none""")
@cli_util.option('--min-unique-chars', type=click.INT, help=u"""The minimum number of unique characters in a password.  A value of 0 or no value indicates no minimum unique characters restriction.

**SCIM++ Properties:**  - caseExact: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: integer  - uniqueness: none""")
@cli_util.option('--max-repeated-chars', type=click.INT, help=u"""The maximum number of repeated characters allowed in a password.  A value of 0 or no value indicates no such restriction.

**SCIM++ Properties:**  - caseExact: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: integer  - uniqueness: none""")
@cli_util.option('--starts-with-alphabet', type=click.BOOL, help=u"""Indicates that the password must begin with an alphabetic character

**SCIM++ Properties:**  - caseExact: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--first-name-disallowed', type=click.BOOL, help=u"""Indicates a sequence of characters that match the user's first name of given name cannot be the password. Password validation against policy will be ignored if length of first name is less than or equal to 3 characters.

**SCIM++ Properties:**  - caseExact: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--last-name-disallowed', type=click.BOOL, help=u"""Indicates a sequence of characters that match the user's last name of given name cannot be the password. Password validation against policy will be ignored if length of last name is less than or equal to 3 characters.

**SCIM++ Properties:**  - caseExact: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--user-name-disallowed', type=click.BOOL, help=u"""Indicates a sequence of characters that match the username cannot be the password. Password validation against policy will be ignored if length of user name is less than or equal to 3 characters.

**SCIM++ Properties:**  - caseExact: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--disallowed-user-attribute-values', type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of User attributes whose values are not allowed in the password.

**Added In:** 2303212224

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--min-password-age', type=click.INT, help=u"""Minimum time after which the user can resubmit the reset password request

**SCIM++ Properties:**  - caseExact: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: integer  - uniqueness: none""")
@cli_util.option('--password-expires-after', type=click.INT, help=u"""The number of days after which the password expires automatically

**SCIM++ Properties:**  - caseExact: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: integer  - uniqueness: none""")
@cli_util.option('--password-expire-warning', type=click.INT, help=u"""An integer indicating the number of days before which the user should be warned about password expiry.

**SCIM++ Properties:**  - caseExact: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: integer  - uniqueness: none""")
@cli_util.option('--required-chars', help=u"""A String value whose contents indicate a set of characters that must appear, in any sequence, in a password value

**SCIM++ Properties:**  - caseExact: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--disallowed-chars', help=u"""A String value whose contents indicate a set of characters that cannot appear, in any sequence, in a password value

**SCIM++ Properties:**  - caseExact: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--allowed-chars', help=u"""A String value whose contents indicate a set of characters that can appear, in any sequence, in a password value

**SCIM++ Properties:**  - caseExact: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--disallowed-substrings', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A String value whose contents indicate a set of substrings that cannot appear, in any sequence, in a password value

**SCIM++ Properties:**  - caseExact: false  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--dictionary-word-disallowed', type=click.BOOL, help=u"""Indicates whether the password can match a dictionary word

**SCIM++ Properties:**  - caseExact: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--dictionary-location', help=u"""A Reference value that contains the URI of a dictionary of words not allowed to appear within a password value

**SCIM++ Properties:**  - caseExact: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--dictionary-delimiter', help=u"""A delimiter used to separate characters in the dictionary file

**SCIM++ Properties:**  - caseExact: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--max-incorrect-attempts', type=click.INT, help=u"""An integer that represents the maximum number of failed logins before an account is locked

**SCIM++ Properties:**  - caseExact: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: integer  - uniqueness: none""")
@cli_util.option('--lockout-duration', type=click.INT, help=u"""The time period in minutes to lock out a user account when the threshold of invalid login attempts is reached. The available range is from 5 through 1440 minutes (24 hours).

**SCIM++ Properties:**  - caseExact: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: integer  - uniqueness: none""")
@cli_util.option('--num-passwords-in-history', type=click.INT, help=u"""The number of passwords that will be kept in history that may not be used as a password

**SCIM++ Properties:**  - caseExact: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: integer  - uniqueness: none""")
@cli_util.option('--password-strength', type=custom_types.CliCaseInsensitiveChoice(["Simple", "Standard", "Custom"]), help=u"""Indicates whether the password policy is configured as Simple, Standard, or Custom.

**SCIM++ Properties:**  - caseExact: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--force-password-reset', type=click.BOOL, help=u"""Indicates whether all of the users should be forced to reset their password on the next login (to comply with new password policy changes)

**SCIM++ Properties:**  - caseExact: false  - multiValued: false  - mutability: writeOnly  - required: false  - returned: never  - type: boolean  - uniqueness: none""")
@cli_util.option('--distinct-characters', type=click.INT, help=u"""The number of distinct characters between old password and new password

**Added In:** 2303212224

**SCIM++ Properties:**  - caseExact: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: integer  - uniqueness: none""")
@cli_util.option('--priority', type=click.INT, help=u"""Password policy priority

**Added In:** 20.1.3

**SCIM++ Properties:**  - caseExact: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: integer  - idcsMinValue: 1  - uniqueness: server""")
@cli_util.option('--groups', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of groups that the password policy belongs to.

**Added In:** 20.1.3

**SCIM++ Properties:**  - caseExact: false  - idcsCompositeKey: [value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: complex  - uniqueness: none

This option is a JSON list with items of type PasswordPolicyGroups.  For documentation on PasswordPolicyGroups please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/PasswordPolicyGroups.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--configured-password-policy-rules', type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of password policy rules that have values set. This map of stringKey:stringValue pairs can be used to aid users while setting/resetting password

**SCIM++ Properties:**  - caseExact: false  - idcsCompositeKey: [key]  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type PasswordPolicyConfiguredPasswordPolicyRules.  For documentation on PasswordPolicyConfiguredPasswordPolicyRules please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/PasswordPolicyConfiguredPasswordPolicyRules.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'disallowed-user-attribute-values': {'module': 'identity_domains', 'class': 'list[string]'}, 'disallowed-substrings': {'module': 'identity_domains', 'class': 'list[string]'}, 'groups': {'module': 'identity_domains', 'class': 'list[PasswordPolicyGroups]'}, 'configured-password-policy-rules': {'module': 'identity_domains', 'class': 'list[PasswordPolicyConfiguredPasswordPolicyRules]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'disallowed-user-attribute-values': {'module': 'identity_domains', 'class': 'list[string]'}, 'disallowed-substrings': {'module': 'identity_domains', 'class': 'list[string]'}, 'groups': {'module': 'identity_domains', 'class': 'list[PasswordPolicyGroups]'}, 'configured-password-policy-rules': {'module': 'identity_domains', 'class': 'list[PasswordPolicyConfiguredPasswordPolicyRules]'}}, output_type={'module': 'identity_domains', 'class': 'PasswordPolicy'})
@cli_util.wrap_exceptions
def create_password_policy(ctx, from_json, schemas, name, authorization, resource_type_schema_version, attributes, attribute_sets, id, ocid, meta, idcs_created_by, idcs_last_modified_by, idcs_prevented_operations, tags, delete_in_progress, idcs_last_upgraded_in_release, domain_ocid, compartment_ocid, tenancy_ocid, external_id, description, max_length, min_length, min_alphas, min_numerals, min_alpha_numerals, min_special_chars, max_special_chars, min_lower_case, min_upper_case, min_unique_chars, max_repeated_chars, starts_with_alphabet, first_name_disallowed, last_name_disallowed, user_name_disallowed, disallowed_user_attribute_values, min_password_age, password_expires_after, password_expire_warning, required_chars, disallowed_chars, allowed_chars, disallowed_substrings, dictionary_word_disallowed, dictionary_location, dictionary_delimiter, max_incorrect_attempts, lockout_duration, num_passwords_in_history, password_strength, force_password_reset, distinct_characters, priority, groups, configured_password_policy_rules):

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if attributes is not None:
        kwargs['attributes'] = attributes
    if attribute_sets is not None and len(attribute_sets) > 0:
        kwargs['attribute_sets'] = attribute_sets

    _details = {}
    _details['schemas'] = cli_util.parse_json_parameter("schemas", schemas)
    _details['name'] = name

    if id is not None:
        _details['id'] = id

    if ocid is not None:
        _details['ocid'] = ocid

    if meta is not None:
        _details['meta'] = cli_util.parse_json_parameter("meta", meta)

    if idcs_created_by is not None:
        _details['idcsCreatedBy'] = cli_util.parse_json_parameter("idcs_created_by", idcs_created_by)

    if idcs_last_modified_by is not None:
        _details['idcsLastModifiedBy'] = cli_util.parse_json_parameter("idcs_last_modified_by", idcs_last_modified_by)

    if idcs_prevented_operations is not None:
        _details['idcsPreventedOperations'] = cli_util.parse_json_parameter("idcs_prevented_operations", idcs_prevented_operations)

    if tags is not None:
        _details['tags'] = cli_util.parse_json_parameter("tags", tags)

    if delete_in_progress is not None:
        _details['deleteInProgress'] = delete_in_progress

    if idcs_last_upgraded_in_release is not None:
        _details['idcsLastUpgradedInRelease'] = idcs_last_upgraded_in_release

    if domain_ocid is not None:
        _details['domainOcid'] = domain_ocid

    if compartment_ocid is not None:
        _details['compartmentOcid'] = compartment_ocid

    if tenancy_ocid is not None:
        _details['tenancyOcid'] = tenancy_ocid

    if external_id is not None:
        _details['externalId'] = external_id

    if description is not None:
        _details['description'] = description

    if max_length is not None:
        _details['maxLength'] = max_length

    if min_length is not None:
        _details['minLength'] = min_length

    if min_alphas is not None:
        _details['minAlphas'] = min_alphas

    if min_numerals is not None:
        _details['minNumerals'] = min_numerals

    if min_alpha_numerals is not None:
        _details['minAlphaNumerals'] = min_alpha_numerals

    if min_special_chars is not None:
        _details['minSpecialChars'] = min_special_chars

    if max_special_chars is not None:
        _details['maxSpecialChars'] = max_special_chars

    if min_lower_case is not None:
        _details['minLowerCase'] = min_lower_case

    if min_upper_case is not None:
        _details['minUpperCase'] = min_upper_case

    if min_unique_chars is not None:
        _details['minUniqueChars'] = min_unique_chars

    if max_repeated_chars is not None:
        _details['maxRepeatedChars'] = max_repeated_chars

    if starts_with_alphabet is not None:
        _details['startsWithAlphabet'] = starts_with_alphabet

    if first_name_disallowed is not None:
        _details['firstNameDisallowed'] = first_name_disallowed

    if last_name_disallowed is not None:
        _details['lastNameDisallowed'] = last_name_disallowed

    if user_name_disallowed is not None:
        _details['userNameDisallowed'] = user_name_disallowed

    if disallowed_user_attribute_values is not None:
        _details['disallowedUserAttributeValues'] = cli_util.parse_json_parameter("disallowed_user_attribute_values", disallowed_user_attribute_values)

    if min_password_age is not None:
        _details['minPasswordAge'] = min_password_age

    if password_expires_after is not None:
        _details['passwordExpiresAfter'] = password_expires_after

    if password_expire_warning is not None:
        _details['passwordExpireWarning'] = password_expire_warning

    if required_chars is not None:
        _details['requiredChars'] = required_chars

    if disallowed_chars is not None:
        _details['disallowedChars'] = disallowed_chars

    if allowed_chars is not None:
        _details['allowedChars'] = allowed_chars

    if disallowed_substrings is not None:
        _details['disallowedSubstrings'] = cli_util.parse_json_parameter("disallowed_substrings", disallowed_substrings)

    if dictionary_word_disallowed is not None:
        _details['dictionaryWordDisallowed'] = dictionary_word_disallowed

    if dictionary_location is not None:
        _details['dictionaryLocation'] = dictionary_location

    if dictionary_delimiter is not None:
        _details['dictionaryDelimiter'] = dictionary_delimiter

    if max_incorrect_attempts is not None:
        _details['maxIncorrectAttempts'] = max_incorrect_attempts

    if lockout_duration is not None:
        _details['lockoutDuration'] = lockout_duration

    if num_passwords_in_history is not None:
        _details['numPasswordsInHistory'] = num_passwords_in_history

    if password_strength is not None:
        _details['passwordStrength'] = password_strength

    if force_password_reset is not None:
        _details['forcePasswordReset'] = force_password_reset

    if distinct_characters is not None:
        _details['distinctCharacters'] = distinct_characters

    if priority is not None:
        _details['priority'] = priority

    if groups is not None:
        _details['groups'] = cli_util.parse_json_parameter("groups", groups)

    if configured_password_policy_rules is not None:
        _details['configuredPasswordPolicyRules'] = cli_util.parse_json_parameter("configured_password_policy_rules", configured_password_policy_rules)

    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.create_password_policy(
        password_policy=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@policy_group.command(name=cli_util.override('identity_domains.create_policy.command_name', 'create'), help=u"""Create a Policy.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](createPolicy)""")
@cli_util.option('--schemas', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--name', required=True, help=u"""Policy name

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: true  - returned: always  - type: string  - uniqueness: none""")
@cli_util.option('--policy-type', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--attributes', help=u"""A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.""")
@cli_util.option('--attribute-sets', type=custom_types.CliCaseInsensitiveChoice(["all", "always", "never", "request", "default"]), multiple=True, help=u"""A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.""")
@cli_util.option('--id', help=u"""Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--ocid', help=u"""Unique OCI identifier for the SCIM Resource.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: string  - uniqueness: global""")
@cli_util.option('--meta', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-created-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-last-modified-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-prevented-operations', type=custom_types.CliCaseInsensitiveChoice(["replace", "update", "delete"]), help=u"""Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of tags on this resource.

**SCIM++ Properties:**  - idcsCompositeKey: [key, value]  - idcsCsvAttributeNameMappings: [[columnHeaderName:Tag Key, mapsTo:tags.key], [columnHeaderName:Tag Value, mapsTo:tags.value]]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type Tags.  For documentation on tags please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/Tags.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--delete-in-progress', type=click.BOOL, help=u"""A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--idcs-last-upgraded-in-release', help=u"""The release number when the resource was upgraded.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--domain-ocid', help=u"""OCI Domain Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--compartment-ocid', help=u"""OCI Compartment Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--tenancy-ocid', help=u"""OCI Tenant Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--external-id', help=u"""An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value.  The value of the externalId attribute is always issued be the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--description', help=u"""Policy Description

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--active', type=click.BOOL, help=u"""If true, Policy is active.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--policy-groovy', help=u"""The Groovy script that is run instead of the policy, if the policy type allows the policy to be a Groovy script.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--rules', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Rules assigned to this policy

**SCIM++ Properties:**  - idcsCompositeKey: [value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type PolicyRules.  For documentation on PolicyRules please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/PolicyRules.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionociconsolesignonpolicyconsent-policy', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'rules': {'module': 'identity_domains', 'class': 'list[PolicyRules]'}, 'policy-type': {'module': 'identity_domains', 'class': 'PolicyPolicyType'}, 'urnietfparamsscimschemasoracleidcsextensionociconsolesignonpolicyconsent-policy': {'module': 'identity_domains', 'class': 'PolicyExtensionOciconsolesignonpolicyconsentPolicy'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'rules': {'module': 'identity_domains', 'class': 'list[PolicyRules]'}, 'policy-type': {'module': 'identity_domains', 'class': 'PolicyPolicyType'}, 'urnietfparamsscimschemasoracleidcsextensionociconsolesignonpolicyconsent-policy': {'module': 'identity_domains', 'class': 'PolicyExtensionOciconsolesignonpolicyconsentPolicy'}}, output_type={'module': 'identity_domains', 'class': 'Policy'})
@cli_util.wrap_exceptions
def create_policy(ctx, from_json, schemas, name, policy_type, authorization, resource_type_schema_version, attributes, attribute_sets, id, ocid, meta, idcs_created_by, idcs_last_modified_by, idcs_prevented_operations, tags, delete_in_progress, idcs_last_upgraded_in_release, domain_ocid, compartment_ocid, tenancy_ocid, external_id, description, active, policy_groovy, rules, urnietfparamsscimschemasoracleidcsextensionociconsolesignonpolicyconsent_policy):

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if attributes is not None:
        kwargs['attributes'] = attributes
    if attribute_sets is not None and len(attribute_sets) > 0:
        kwargs['attribute_sets'] = attribute_sets

    _details = {}
    _details['schemas'] = cli_util.parse_json_parameter("schemas", schemas)
    _details['name'] = name
    _details['policyType'] = cli_util.parse_json_parameter("policy_type", policy_type)

    if id is not None:
        _details['id'] = id

    if ocid is not None:
        _details['ocid'] = ocid

    if meta is not None:
        _details['meta'] = cli_util.parse_json_parameter("meta", meta)

    if idcs_created_by is not None:
        _details['idcsCreatedBy'] = cli_util.parse_json_parameter("idcs_created_by", idcs_created_by)

    if idcs_last_modified_by is not None:
        _details['idcsLastModifiedBy'] = cli_util.parse_json_parameter("idcs_last_modified_by", idcs_last_modified_by)

    if idcs_prevented_operations is not None:
        _details['idcsPreventedOperations'] = cli_util.parse_json_parameter("idcs_prevented_operations", idcs_prevented_operations)

    if tags is not None:
        _details['tags'] = cli_util.parse_json_parameter("tags", tags)

    if delete_in_progress is not None:
        _details['deleteInProgress'] = delete_in_progress

    if idcs_last_upgraded_in_release is not None:
        _details['idcsLastUpgradedInRelease'] = idcs_last_upgraded_in_release

    if domain_ocid is not None:
        _details['domainOcid'] = domain_ocid

    if compartment_ocid is not None:
        _details['compartmentOcid'] = compartment_ocid

    if tenancy_ocid is not None:
        _details['tenancyOcid'] = tenancy_ocid

    if external_id is not None:
        _details['externalId'] = external_id

    if description is not None:
        _details['description'] = description

    if active is not None:
        _details['active'] = active

    if policy_groovy is not None:
        _details['policyGroovy'] = policy_groovy

    if rules is not None:
        _details['rules'] = cli_util.parse_json_parameter("rules", rules)

    if urnietfparamsscimschemasoracleidcsextensionociconsolesignonpolicyconsent_policy is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:ociconsolesignonpolicyconsent:Policy'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionociconsolesignonpolicyconsent_policy", urnietfparamsscimschemasoracleidcsextensionociconsolesignonpolicyconsent_policy)

    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.create_policy(
        policy=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@restore_oci_console_policy_group.command(name=cli_util.override('identity_domains.create_restore_oci_console_policy.command_name', 'create'), help=u"""Create a RestoreOciConsolePolicy entry to restore Policy to factory default.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](createRestoreOciConsolePolicy)""")
@cli_util.option('--schemas', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""**SCIM++ Properties:** - caseExact: false - idcsSearchable: false - multiValued: true - mutability: readWrite - required: true - returned: default - type: string - uniqueness: none REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--consent', required=True, type=click.BOOL, help=u"""**SCIM++ Properties:** - idcsSearchable: false - multiValued: false - required: true - mutability: writeOnly - returned: default - type: boolean Consent to be provided for restoring the Oci Console SignOn Policy to Factory Defaults. Defaults to false""")
@cli_util.option('--reason', required=True, help=u"""**SCIM++ Properties:** - idcsSearchable: false - multiValued: false - mutability: writeOnly - required: true - returned: default - type: string Detailed reason when domain admin opts to restore the Oci Console SignOn Policy to Factory Defaults""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--id', help=u"""**SCIM++ Properties:** - caseExact: false - idcsSearchable: true - multiValued: false - mutability: readOnly - required: false - returned: always - type: string - uniqueness: global Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.""")
@cli_util.option('--ocid', help=u"""**SCIM++ Properties:** - caseExact: true - idcsSearchable: true - multiValued: false - mutability: immutable - required: false - returned: default - type: string - uniqueness: global Unique OCI identifier for the SCIM Resource.""")
@cli_util.option('--meta', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-created-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-last-modified-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-prevented-operations', type=custom_types.CliCaseInsensitiveChoice(["replace", "update", "delete"]), help=u"""**SCIM++ Properties:** - idcsSearchable: false - multiValued: true - mutability: readOnly - required: false - returned: request - type: string - uniqueness: none Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.""")
@cli_util.option('--tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""**SCIM++ Properties:** - idcsCompositeKey: [key, value] - idcsCsvAttributeNameMappings: [[columnHeaderName:Tag Key, mapsTo:tags.key], [columnHeaderName:Tag Value, mapsTo:tags.value]] - idcsSearchable: true - multiValued: true - mutability: readWrite - required: false - returned: request - type: complex - uniqueness: none A list of tags on this resource.

This option is a JSON list with items of type Tags.  For documentation on tags please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/Tags.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--delete-in-progress', type=click.BOOL, help=u"""**SCIM++ Properties:** - caseExact: false - idcsSearchable: true - multiValued: false - mutability: readOnly - required: false - returned: default - type: boolean - uniqueness: none A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.""")
@cli_util.option('--idcs-last-upgraded-in-release', help=u"""**SCIM++ Properties:** - caseExact: false - idcsSearchable: false - multiValued: false - mutability: readOnly - required: false - returned: request - type: string - uniqueness: none The release number when the resource was upgraded.""")
@cli_util.option('--domain-ocid', help=u"""**SCIM++ Properties:** - caseExact: false - idcsSearchable: false - multiValued: false - mutability: readOnly - required: false - returned: default - type: string - uniqueness: none OCI Domain Id (ocid) in which the resource lives.""")
@cli_util.option('--compartment-ocid', help=u"""**SCIM++ Properties:** - caseExact: false - idcsSearchable: false - multiValued: false - mutability: readOnly - required: false - returned: default - type: string - uniqueness: none OCI Compartment Id (ocid) in which the resource lives.""")
@cli_util.option('--tenancy-ocid', help=u"""**SCIM++ Properties:** - caseExact: false - idcsSearchable: false - multiValued: false - mutability: readOnly - required: false - returned: default - type: string - uniqueness: none OCI Tenant Id (ocid) in which the resource lives.""")
@json_skeleton_utils.get_cli_json_input_option({'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}}, output_type={'module': 'identity_domains', 'class': 'RestoreOciConsolePolicy'})
@cli_util.wrap_exceptions
def create_restore_oci_console_policy(ctx, from_json, schemas, consent, reason, authorization, resource_type_schema_version, id, ocid, meta, idcs_created_by, idcs_last_modified_by, idcs_prevented_operations, tags, delete_in_progress, idcs_last_upgraded_in_release, domain_ocid, compartment_ocid, tenancy_ocid):

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version

    _details = {}
    _details['schemas'] = cli_util.parse_json_parameter("schemas", schemas)
    _details['consent'] = consent
    _details['reason'] = reason

    if id is not None:
        _details['id'] = id

    if ocid is not None:
        _details['ocid'] = ocid

    if meta is not None:
        _details['meta'] = cli_util.parse_json_parameter("meta", meta)

    if idcs_created_by is not None:
        _details['idcsCreatedBy'] = cli_util.parse_json_parameter("idcs_created_by", idcs_created_by)

    if idcs_last_modified_by is not None:
        _details['idcsLastModifiedBy'] = cli_util.parse_json_parameter("idcs_last_modified_by", idcs_last_modified_by)

    if idcs_prevented_operations is not None:
        _details['idcsPreventedOperations'] = cli_util.parse_json_parameter("idcs_prevented_operations", idcs_prevented_operations)

    if tags is not None:
        _details['tags'] = cli_util.parse_json_parameter("tags", tags)

    if delete_in_progress is not None:
        _details['deleteInProgress'] = delete_in_progress

    if idcs_last_upgraded_in_release is not None:
        _details['idcsLastUpgradedInRelease'] = idcs_last_upgraded_in_release

    if domain_ocid is not None:
        _details['domainOcid'] = domain_ocid

    if compartment_ocid is not None:
        _details['compartmentOcid'] = compartment_ocid

    if tenancy_ocid is not None:
        _details['tenancyOcid'] = tenancy_ocid

    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.create_restore_oci_console_policy(
        restore_oci_console_policy=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@rule_group.command(name=cli_util.override('identity_domains.create_rule.command_name', 'create'), help=u"""Create a Rule.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](createRule)""")
@cli_util.option('--schemas', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--name', required=True, help=u"""Rule name

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: true  - returned: always  - type: string  - uniqueness: none""")
@cli_util.option('--condition', required=True, help=u"""SCIM filters

**Deprecated Since: 17.3.4**

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--policy-type', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('---return', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""The return values are the then portion of a Rule

**SCIM++ Properties:**  - idcsCompositeKey: [name]  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: true  - returned: default  - type: complex  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--attributes', help=u"""A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.""")
@cli_util.option('--attribute-sets', type=custom_types.CliCaseInsensitiveChoice(["all", "always", "never", "request", "default"]), multiple=True, help=u"""A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.""")
@cli_util.option('--id', help=u"""Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--ocid', help=u"""Unique OCI identifier for the SCIM Resource.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: string  - uniqueness: global""")
@cli_util.option('--meta', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-created-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-last-modified-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-prevented-operations', type=custom_types.CliCaseInsensitiveChoice(["replace", "update", "delete"]), help=u"""Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of tags on this resource.

**SCIM++ Properties:**  - idcsCompositeKey: [key, value]  - idcsCsvAttributeNameMappings: [[columnHeaderName:Tag Key, mapsTo:tags.key], [columnHeaderName:Tag Value, mapsTo:tags.value]]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type Tags.  For documentation on tags please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/Tags.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--delete-in-progress', type=click.BOOL, help=u"""A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--idcs-last-upgraded-in-release', help=u"""The release number when the resource was upgraded.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--domain-ocid', help=u"""OCI Domain Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--compartment-ocid', help=u"""OCI Compartment Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--tenancy-ocid', help=u"""OCI Tenant Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--external-id', help=u"""An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value.  The value of the externalId attribute is always issued be the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--description', help=u"""Rule Description

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--active', type=click.BOOL, help=u"""If true, rule is active

**SCIM++ Properties:**  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--locked', type=click.BOOL, help=u"""Shows if the rule is locked

**SCIM++ Properties:**  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--rule-groovy', help=u"""The Groovy script that is run instead of the rule, if policy type allows the rule to be a Groovy script.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--condition-group', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionociconsolesignonpolicyconsent-policy', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'condition-group': {'module': 'identity_domains', 'class': 'RuleConditionGroup'}, 'policy-type': {'module': 'identity_domains', 'class': 'RulePolicyType'}, '-return': {'module': 'identity_domains', 'class': 'list[RuleReturn]'}, 'urnietfparamsscimschemasoracleidcsextensionociconsolesignonpolicyconsent-policy': {'module': 'identity_domains', 'class': 'RuleExtensionOciconsolesignonpolicyconsentPolicy'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'condition-group': {'module': 'identity_domains', 'class': 'RuleConditionGroup'}, 'policy-type': {'module': 'identity_domains', 'class': 'RulePolicyType'}, '-return': {'module': 'identity_domains', 'class': 'list[RuleReturn]'}, 'urnietfparamsscimschemasoracleidcsextensionociconsolesignonpolicyconsent-policy': {'module': 'identity_domains', 'class': 'RuleExtensionOciconsolesignonpolicyconsentPolicy'}}, output_type={'module': 'identity_domains', 'class': 'Rule'})
@cli_util.wrap_exceptions
def create_rule(ctx, from_json, schemas, name, condition, policy_type, _return, authorization, resource_type_schema_version, attributes, attribute_sets, id, ocid, meta, idcs_created_by, idcs_last_modified_by, idcs_prevented_operations, tags, delete_in_progress, idcs_last_upgraded_in_release, domain_ocid, compartment_ocid, tenancy_ocid, external_id, description, active, locked, rule_groovy, condition_group, urnietfparamsscimschemasoracleidcsextensionociconsolesignonpolicyconsent_policy):

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if attributes is not None:
        kwargs['attributes'] = attributes
    if attribute_sets is not None and len(attribute_sets) > 0:
        kwargs['attribute_sets'] = attribute_sets

    _details = {}
    _details['schemas'] = cli_util.parse_json_parameter("schemas", schemas)
    _details['name'] = name
    _details['condition'] = condition
    _details['policyType'] = cli_util.parse_json_parameter("policy_type", policy_type)
    _details['return'] = cli_util.parse_json_parameter("_return", _return)

    if id is not None:
        _details['id'] = id

    if ocid is not None:
        _details['ocid'] = ocid

    if meta is not None:
        _details['meta'] = cli_util.parse_json_parameter("meta", meta)

    if idcs_created_by is not None:
        _details['idcsCreatedBy'] = cli_util.parse_json_parameter("idcs_created_by", idcs_created_by)

    if idcs_last_modified_by is not None:
        _details['idcsLastModifiedBy'] = cli_util.parse_json_parameter("idcs_last_modified_by", idcs_last_modified_by)

    if idcs_prevented_operations is not None:
        _details['idcsPreventedOperations'] = cli_util.parse_json_parameter("idcs_prevented_operations", idcs_prevented_operations)

    if tags is not None:
        _details['tags'] = cli_util.parse_json_parameter("tags", tags)

    if delete_in_progress is not None:
        _details['deleteInProgress'] = delete_in_progress

    if idcs_last_upgraded_in_release is not None:
        _details['idcsLastUpgradedInRelease'] = idcs_last_upgraded_in_release

    if domain_ocid is not None:
        _details['domainOcid'] = domain_ocid

    if compartment_ocid is not None:
        _details['compartmentOcid'] = compartment_ocid

    if tenancy_ocid is not None:
        _details['tenancyOcid'] = tenancy_ocid

    if external_id is not None:
        _details['externalId'] = external_id

    if description is not None:
        _details['description'] = description

    if active is not None:
        _details['active'] = active

    if locked is not None:
        _details['locked'] = locked

    if rule_groovy is not None:
        _details['ruleGroovy'] = rule_groovy

    if condition_group is not None:
        _details['conditionGroup'] = cli_util.parse_json_parameter("condition_group", condition_group)

    if urnietfparamsscimschemasoracleidcsextensionociconsolesignonpolicyconsent_policy is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:ociconsolesignonpolicyconsent:Policy'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionociconsolesignonpolicyconsent_policy", urnietfparamsscimschemasoracleidcsextensionociconsolesignonpolicyconsent_policy)

    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.create_rule(
        rule=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@security_question_group.command(name=cli_util.override('identity_domains.create_security_question.command_name', 'create'), help=u"""Create a security question.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](createSecurityQuestion)""")
@cli_util.option('--schemas', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--active', required=True, type=click.BOOL, help=u"""This indicates if the question is selected by the Security Admin and is available for the end user.

**SCIM++ Properties:**  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: true  - returned: always  - type: boolean  - uniqueness: none""")
@cli_util.option('--type', required=True, type=custom_types.CliCaseInsensitiveChoice(["default", "custom"]), help=u"""This indicates if the question is a Custom Question added by the Security Admin.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: true  - returned: always  - type: string  - uniqueness: none""")
@cli_util.option('--question-text', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""Locale values for the Question

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: true  - returned: always  - idcsCompositeKey: [locale]  - type: complex  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--attributes', help=u"""A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.""")
@cli_util.option('--attribute-sets', type=custom_types.CliCaseInsensitiveChoice(["all", "always", "never", "request", "default"]), multiple=True, help=u"""A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.""")
@cli_util.option('--id', help=u"""Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--ocid', help=u"""Unique OCI identifier for the SCIM Resource.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: string  - uniqueness: global""")
@cli_util.option('--meta', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-created-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-last-modified-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-prevented-operations', type=custom_types.CliCaseInsensitiveChoice(["replace", "update", "delete"]), help=u"""Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of tags on this resource.

**SCIM++ Properties:**  - idcsCompositeKey: [key, value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type Tags.  For documentation on tags please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/Tags.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--delete-in-progress', type=click.BOOL, help=u"""A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--idcs-last-upgraded-in-release', help=u"""The release number when the resource was upgraded.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--domain-ocid', help=u"""OCI Domain Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--compartment-ocid', help=u"""OCI Compartment Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--tenancy-ocid', help=u"""OCI Tenant Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--external-id', help=u"""An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@json_skeleton_utils.get_cli_json_input_option({'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'question-text': {'module': 'identity_domains', 'class': 'list[SecurityQuestionQuestionText]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'question-text': {'module': 'identity_domains', 'class': 'list[SecurityQuestionQuestionText]'}}, output_type={'module': 'identity_domains', 'class': 'SecurityQuestion'})
@cli_util.wrap_exceptions
def create_security_question(ctx, from_json, schemas, active, type, question_text, authorization, resource_type_schema_version, attributes, attribute_sets, id, ocid, meta, idcs_created_by, idcs_last_modified_by, idcs_prevented_operations, tags, delete_in_progress, idcs_last_upgraded_in_release, domain_ocid, compartment_ocid, tenancy_ocid, external_id):

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if attributes is not None:
        kwargs['attributes'] = attributes
    if attribute_sets is not None and len(attribute_sets) > 0:
        kwargs['attribute_sets'] = attribute_sets

    _details = {}
    _details['schemas'] = cli_util.parse_json_parameter("schemas", schemas)
    _details['active'] = active
    _details['type'] = type
    _details['questionText'] = cli_util.parse_json_parameter("question_text", question_text)

    if id is not None:
        _details['id'] = id

    if ocid is not None:
        _details['ocid'] = ocid

    if meta is not None:
        _details['meta'] = cli_util.parse_json_parameter("meta", meta)

    if idcs_created_by is not None:
        _details['idcsCreatedBy'] = cli_util.parse_json_parameter("idcs_created_by", idcs_created_by)

    if idcs_last_modified_by is not None:
        _details['idcsLastModifiedBy'] = cli_util.parse_json_parameter("idcs_last_modified_by", idcs_last_modified_by)

    if idcs_prevented_operations is not None:
        _details['idcsPreventedOperations'] = cli_util.parse_json_parameter("idcs_prevented_operations", idcs_prevented_operations)

    if tags is not None:
        _details['tags'] = cli_util.parse_json_parameter("tags", tags)

    if delete_in_progress is not None:
        _details['deleteInProgress'] = delete_in_progress

    if idcs_last_upgraded_in_release is not None:
        _details['idcsLastUpgradedInRelease'] = idcs_last_upgraded_in_release

    if domain_ocid is not None:
        _details['domainOcid'] = domain_ocid

    if compartment_ocid is not None:
        _details['compartmentOcid'] = compartment_ocid

    if tenancy_ocid is not None:
        _details['tenancyOcid'] = tenancy_ocid

    if external_id is not None:
        _details['externalId'] = external_id

    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.create_security_question(
        security_question=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@self_registration_profile_group.command(name=cli_util.override('identity_domains.create_self_registration_profile.command_name', 'create'), help=u"""Create a self-registration profile.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](createSelfRegistrationProfile)""")
@cli_util.option('--schemas', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--name', required=True, help=u"""Name of the profile

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: true  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--activation-email-required', required=True, type=click.BOOL, help=u"""**SCIM++ Properties:** - caseExact: false - idcsSearchable: true - multiValued: false - mutability: readWrite - required: true - returned: default - type: boolean - uniqueness: none A Boolean value that indicates whether Account verification email is required to be sent before login or not""")
@cli_util.option('--number-of-days-redirect-url-is-valid', required=True, type=click.INT, help=u"""Number of days redirect URL is valid

**SCIM++ Properties:**  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: true  - returned: default  - type: integer  - uniqueness: none""")
@cli_util.option('--show-on-login-page', required=True, type=click.BOOL, help=u"""A Boolean value that indicates whether the profile should be displayed on login page

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: true  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--redirect-url', required=True, help=u"""This URL will be replaced in email notification sent to user. When activation email required is set to true, user is created in \\\"pending verification\\\" state, upon clicking this link user will be able to activate himself. When activation email required is set to false, user is created in \\\"verified\\\" state, this link will be used to verify user's email.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--consent-text-present', required=True, type=click.BOOL, help=u"""A boolean value that indicates whether the consent text is present.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: true  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--display-name', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""Registration page name

**SCIM++ Properties:**  - idcsCompositeKey: [locale]  - idcsMultiLanguage: true  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: true  - returned: default  - type: complex  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--email-template', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--attributes', help=u"""A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.""")
@cli_util.option('--attribute-sets', type=custom_types.CliCaseInsensitiveChoice(["all", "always", "never", "request", "default"]), multiple=True, help=u"""A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.""")
@cli_util.option('--id', help=u"""Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--ocid', help=u"""Unique OCI identifier for the SCIM Resource.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: string  - uniqueness: global""")
@cli_util.option('--meta', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-created-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-last-modified-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-prevented-operations', type=custom_types.CliCaseInsensitiveChoice(["replace", "update", "delete"]), help=u"""Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of tags on this resource.

**SCIM++ Properties:**  - idcsCompositeKey: [key, value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type Tags.  For documentation on tags please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/Tags.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--delete-in-progress', type=click.BOOL, help=u"""A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--idcs-last-upgraded-in-release', help=u"""The release number when the resource was upgraded.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--domain-ocid', help=u"""OCI Domain Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--compartment-ocid', help=u"""OCI Compartment Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--tenancy-ocid', help=u"""OCI Tenant Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--external-id', help=u"""An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

**SCIM++ Properties:**  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--active', type=click.BOOL, help=u"""A Boolean value that indicates whether the profile is enabled or not

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--allowed-email-domains', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A Multivalue String value for Email domains which are valid for this profile

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--disallowed-email-domains', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A Multivalue String Value for Email domains to be handled as exceptions

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--header-logo', help=u"""Reference to header logo

**SCIM++ Properties:**  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: reference""")
@cli_util.option('--footer-logo', help=u"""References to footer logo

**SCIM++ Properties:**  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: reference""")
@cli_util.option('--after-submit-text', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Text to be displayed on UI after doing self registration

**SCIM++ Properties:**  - idcsCompositeKey: [locale]  - idcsMultiLanguage: true  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: complex  - uniqueness: none

This option is a JSON list with items of type SelfRegistrationProfileAfterSubmitText.  For documentation on SelfRegistrationProfileAfterSubmitText please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/SelfRegistrationProfileAfterSubmitText.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--user-attributes', type=custom_types.CLI_COMPLEX_TYPE, help=u"""**SCIM++ Properties:** - idcsCompositeKey: [value] - idcsSearchable: true - multiValued: true - mutability: readWrite - required: false - returned: default - type: complex - uniqueness: none User Attributes

This option is a JSON list with items of type SelfRegistrationProfileUserAttributes.  For documentation on SelfRegistrationProfileUserAttributes please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/SelfRegistrationProfileUserAttributes.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--default-groups', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Default groups assigned to the user

**SCIM++ Properties:**  - idcsCompositeKey: [value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - type: complex

This option is a JSON list with items of type SelfRegistrationProfileDefaultGroups.  For documentation on SelfRegistrationProfileDefaultGroups please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/SelfRegistrationProfileDefaultGroups.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--header-text', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Header text

**SCIM++ Properties:**  - idcsCompositeKey: [locale]  - idcsMultiLanguage: true  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: complex  - uniqueness: none

This option is a JSON list with items of type SelfRegistrationProfileHeaderText.  For documentation on SelfRegistrationProfileHeaderText please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/SelfRegistrationProfileHeaderText.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--footer-text', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Footer text

**SCIM++ Properties:**  - idcsCompositeKey: [locale]  - idcsMultiLanguage: true  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: complex  - uniqueness: none

This option is a JSON list with items of type SelfRegistrationProfileFooterText.  For documentation on SelfRegistrationProfileFooterText please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/SelfRegistrationProfileFooterText.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--consent-text', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Consent text

**SCIM++ Properties:**  - idcsCompositeKey: [locale]  - idcsMultiLanguage: true  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: complex  - uniqueness: none

This option is a JSON list with items of type SelfRegistrationProfileConsentText.  For documentation on SelfRegistrationProfileConsentText please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/SelfRegistrationProfileConsentText.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'allowed-email-domains': {'module': 'identity_domains', 'class': 'list[string]'}, 'disallowed-email-domains': {'module': 'identity_domains', 'class': 'list[string]'}, 'display-name': {'module': 'identity_domains', 'class': 'list[SelfRegistrationProfileDisplayName]'}, 'after-submit-text': {'module': 'identity_domains', 'class': 'list[SelfRegistrationProfileAfterSubmitText]'}, 'user-attributes': {'module': 'identity_domains', 'class': 'list[SelfRegistrationProfileUserAttributes]'}, 'email-template': {'module': 'identity_domains', 'class': 'SelfRegistrationProfileEmailTemplate'}, 'default-groups': {'module': 'identity_domains', 'class': 'list[SelfRegistrationProfileDefaultGroups]'}, 'header-text': {'module': 'identity_domains', 'class': 'list[SelfRegistrationProfileHeaderText]'}, 'footer-text': {'module': 'identity_domains', 'class': 'list[SelfRegistrationProfileFooterText]'}, 'consent-text': {'module': 'identity_domains', 'class': 'list[SelfRegistrationProfileConsentText]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'allowed-email-domains': {'module': 'identity_domains', 'class': 'list[string]'}, 'disallowed-email-domains': {'module': 'identity_domains', 'class': 'list[string]'}, 'display-name': {'module': 'identity_domains', 'class': 'list[SelfRegistrationProfileDisplayName]'}, 'after-submit-text': {'module': 'identity_domains', 'class': 'list[SelfRegistrationProfileAfterSubmitText]'}, 'user-attributes': {'module': 'identity_domains', 'class': 'list[SelfRegistrationProfileUserAttributes]'}, 'email-template': {'module': 'identity_domains', 'class': 'SelfRegistrationProfileEmailTemplate'}, 'default-groups': {'module': 'identity_domains', 'class': 'list[SelfRegistrationProfileDefaultGroups]'}, 'header-text': {'module': 'identity_domains', 'class': 'list[SelfRegistrationProfileHeaderText]'}, 'footer-text': {'module': 'identity_domains', 'class': 'list[SelfRegistrationProfileFooterText]'}, 'consent-text': {'module': 'identity_domains', 'class': 'list[SelfRegistrationProfileConsentText]'}}, output_type={'module': 'identity_domains', 'class': 'SelfRegistrationProfile'})
@cli_util.wrap_exceptions
def create_self_registration_profile(ctx, from_json, schemas, name, activation_email_required, number_of_days_redirect_url_is_valid, show_on_login_page, redirect_url, consent_text_present, display_name, email_template, authorization, resource_type_schema_version, attributes, attribute_sets, id, ocid, meta, idcs_created_by, idcs_last_modified_by, idcs_prevented_operations, tags, delete_in_progress, idcs_last_upgraded_in_release, domain_ocid, compartment_ocid, tenancy_ocid, external_id, active, allowed_email_domains, disallowed_email_domains, header_logo, footer_logo, after_submit_text, user_attributes, default_groups, header_text, footer_text, consent_text):

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if attributes is not None:
        kwargs['attributes'] = attributes
    if attribute_sets is not None and len(attribute_sets) > 0:
        kwargs['attribute_sets'] = attribute_sets

    _details = {}
    _details['schemas'] = cli_util.parse_json_parameter("schemas", schemas)
    _details['name'] = name
    _details['activationEmailRequired'] = activation_email_required
    _details['numberOfDaysRedirectUrlIsValid'] = number_of_days_redirect_url_is_valid
    _details['showOnLoginPage'] = show_on_login_page
    _details['redirectUrl'] = redirect_url
    _details['consentTextPresent'] = consent_text_present
    _details['displayName'] = cli_util.parse_json_parameter("display_name", display_name)
    _details['emailTemplate'] = cli_util.parse_json_parameter("email_template", email_template)

    if id is not None:
        _details['id'] = id

    if ocid is not None:
        _details['ocid'] = ocid

    if meta is not None:
        _details['meta'] = cli_util.parse_json_parameter("meta", meta)

    if idcs_created_by is not None:
        _details['idcsCreatedBy'] = cli_util.parse_json_parameter("idcs_created_by", idcs_created_by)

    if idcs_last_modified_by is not None:
        _details['idcsLastModifiedBy'] = cli_util.parse_json_parameter("idcs_last_modified_by", idcs_last_modified_by)

    if idcs_prevented_operations is not None:
        _details['idcsPreventedOperations'] = cli_util.parse_json_parameter("idcs_prevented_operations", idcs_prevented_operations)

    if tags is not None:
        _details['tags'] = cli_util.parse_json_parameter("tags", tags)

    if delete_in_progress is not None:
        _details['deleteInProgress'] = delete_in_progress

    if idcs_last_upgraded_in_release is not None:
        _details['idcsLastUpgradedInRelease'] = idcs_last_upgraded_in_release

    if domain_ocid is not None:
        _details['domainOcid'] = domain_ocid

    if compartment_ocid is not None:
        _details['compartmentOcid'] = compartment_ocid

    if tenancy_ocid is not None:
        _details['tenancyOcid'] = tenancy_ocid

    if external_id is not None:
        _details['externalId'] = external_id

    if active is not None:
        _details['active'] = active

    if allowed_email_domains is not None:
        _details['allowedEmailDomains'] = cli_util.parse_json_parameter("allowed_email_domains", allowed_email_domains)

    if disallowed_email_domains is not None:
        _details['disallowedEmailDomains'] = cli_util.parse_json_parameter("disallowed_email_domains", disallowed_email_domains)

    if header_logo is not None:
        _details['headerLogo'] = header_logo

    if footer_logo is not None:
        _details['footerLogo'] = footer_logo

    if after_submit_text is not None:
        _details['afterSubmitText'] = cli_util.parse_json_parameter("after_submit_text", after_submit_text)

    if user_attributes is not None:
        _details['userAttributes'] = cli_util.parse_json_parameter("user_attributes", user_attributes)

    if default_groups is not None:
        _details['defaultGroups'] = cli_util.parse_json_parameter("default_groups", default_groups)

    if header_text is not None:
        _details['headerText'] = cli_util.parse_json_parameter("header_text", header_text)

    if footer_text is not None:
        _details['footerText'] = cli_util.parse_json_parameter("footer_text", footer_text)

    if consent_text is not None:
        _details['consentText'] = cli_util.parse_json_parameter("consent_text", consent_text)

    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.create_self_registration_profile(
        self_registration_profile=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@smtp_credential_group.command(name=cli_util.override('identity_domains.create_smtp_credential.command_name', 'create'), help=u"""Create a user's SMTP credentials.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](createSmtpCredential)""")
@cli_util.option('--schemas', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--user-name', required=True, help=u"""User name

**SCIM++ Properties:**  - caseExact: false  - type: string  - mutability: readOnly  - required: true  - returned: default""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--attributes', help=u"""A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.""")
@cli_util.option('--attribute-sets', type=custom_types.CliCaseInsensitiveChoice(["all", "always", "never", "request", "default"]), multiple=True, help=u"""A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.""")
@cli_util.option('--id', help=u"""Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--ocid', help=u"""Unique OCI identifier for the SCIM Resource.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: string  - uniqueness: global""")
@cli_util.option('--meta', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-created-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-last-modified-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-prevented-operations', type=custom_types.CliCaseInsensitiveChoice(["replace", "update", "delete"]), help=u"""Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of tags on this resource.

**SCIM++ Properties:**  - idcsCompositeKey: [key, value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type Tags.  For documentation on tags please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/Tags.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--delete-in-progress', type=click.BOOL, help=u"""A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--idcs-last-upgraded-in-release', help=u"""The release number when the resource was upgraded.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--domain-ocid', help=u"""OCI Domain Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--compartment-ocid', help=u"""OCI Compartment Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--tenancy-ocid', help=u"""OCI Tenant Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--description', help=u"""Description

**SCIM++ Properties:**  - caseExact: false  - type: string  - mutability: readWrite  - required: false  - returned: default""")
@cli_util.option('--status', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "INACTIVE"]), help=u"""User credential status

**Added In:** 2109090424

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: never  - type: string  - uniqueness: none""")
@cli_util.option('--expires-on', help=u"""User credential expires on

**Added In:** 2109090424

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: dateTime  - uniqueness: none""")
@cli_util.option('--password', help=u"""Password

**SCIM++ Properties:**  - caseExact: true  - type: string  - mutability: readOnly  - required: false  - returned: default  - idcsSensitive: hash_sc""")
@cli_util.option('--user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionself-change-user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'user': {'module': 'identity_domains', 'class': 'SmtpCredentialUser'}, 'urnietfparamsscimschemasoracleidcsextensionself-change-user': {'module': 'identity_domains', 'class': 'ExtensionSelfChangeUser'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'user': {'module': 'identity_domains', 'class': 'SmtpCredentialUser'}, 'urnietfparamsscimschemasoracleidcsextensionself-change-user': {'module': 'identity_domains', 'class': 'ExtensionSelfChangeUser'}}, output_type={'module': 'identity_domains', 'class': 'SmtpCredential'})
@cli_util.wrap_exceptions
def create_smtp_credential(ctx, from_json, schemas, user_name, authorization, resource_type_schema_version, attributes, attribute_sets, id, ocid, meta, idcs_created_by, idcs_last_modified_by, idcs_prevented_operations, tags, delete_in_progress, idcs_last_upgraded_in_release, domain_ocid, compartment_ocid, tenancy_ocid, description, status, expires_on, password, user, urnietfparamsscimschemasoracleidcsextensionself_change_user):

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if attributes is not None:
        kwargs['attributes'] = attributes
    if attribute_sets is not None and len(attribute_sets) > 0:
        kwargs['attribute_sets'] = attribute_sets

    _details = {}
    _details['schemas'] = cli_util.parse_json_parameter("schemas", schemas)
    _details['userName'] = user_name

    if id is not None:
        _details['id'] = id

    if ocid is not None:
        _details['ocid'] = ocid

    if meta is not None:
        _details['meta'] = cli_util.parse_json_parameter("meta", meta)

    if idcs_created_by is not None:
        _details['idcsCreatedBy'] = cli_util.parse_json_parameter("idcs_created_by", idcs_created_by)

    if idcs_last_modified_by is not None:
        _details['idcsLastModifiedBy'] = cli_util.parse_json_parameter("idcs_last_modified_by", idcs_last_modified_by)

    if idcs_prevented_operations is not None:
        _details['idcsPreventedOperations'] = cli_util.parse_json_parameter("idcs_prevented_operations", idcs_prevented_operations)

    if tags is not None:
        _details['tags'] = cli_util.parse_json_parameter("tags", tags)

    if delete_in_progress is not None:
        _details['deleteInProgress'] = delete_in_progress

    if idcs_last_upgraded_in_release is not None:
        _details['idcsLastUpgradedInRelease'] = idcs_last_upgraded_in_release

    if domain_ocid is not None:
        _details['domainOcid'] = domain_ocid

    if compartment_ocid is not None:
        _details['compartmentOcid'] = compartment_ocid

    if tenancy_ocid is not None:
        _details['tenancyOcid'] = tenancy_ocid

    if description is not None:
        _details['description'] = description

    if status is not None:
        _details['status'] = status

    if expires_on is not None:
        _details['expiresOn'] = expires_on

    if password is not None:
        _details['password'] = password

    if user is not None:
        _details['user'] = cli_util.parse_json_parameter("user", user)

    if urnietfparamsscimschemasoracleidcsextensionself_change_user is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:selfChange:User'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionself_change_user", urnietfparamsscimschemasoracleidcsextensionself_change_user)

    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.create_smtp_credential(
        smtp_credential=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@social_identity_provider_group.command(name=cli_util.override('identity_domains.create_social_identity_provider.command_name', 'create'), help=u"""Create a Social Identity Provider

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](createSocialIdentityProvider)""")
@cli_util.option('--schemas', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--name', required=True, help=u"""Social provider name

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: true  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--enabled', required=True, type=click.BOOL, help=u"""Whether the IDP is enabled or not

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: true  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--account-linking-enabled', required=True, type=click.BOOL, help=u"""Whether account linking is enabled

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: true  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--registration-enabled', required=True, type=click.BOOL, help=u"""Whether registration is enabled

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: true  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--show-on-login', required=True, type=click.BOOL, help=u"""Whether show on login

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: true  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--consumer-key', required=True, help=u"""Social IDP Client Application Client ID

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--consumer-secret', required=True, help=u"""Social IDP Client Application Client Secret

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: false  - idcsSensitive: encrypt  - multiValued: false  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--service-provider-name', required=True, help=u"""Service Provider Name

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: true  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--id', help=u"""Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--ocid', help=u"""Unique OCI identifier for the SCIM Resource.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: string  - uniqueness: global""")
@cli_util.option('--meta', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-created-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-last-modified-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-prevented-operations', type=custom_types.CliCaseInsensitiveChoice(["replace", "update", "delete"]), help=u"""Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of tags on this resource.

**SCIM++ Properties:**  - idcsCompositeKey: [key, value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type Tags.  For documentation on tags please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/Tags.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--delete-in-progress', type=click.BOOL, help=u"""A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--idcs-last-upgraded-in-release', help=u"""The release number when the resource was upgraded.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--domain-ocid', help=u"""OCI Domain Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--compartment-ocid', help=u"""OCI Compartment Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--tenancy-ocid', help=u"""OCI Tenant Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--description', help=u"""Social IDP description

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--social-jit-provisioning-enabled', type=click.BOOL, help=u"""Whether Social JIT Provisioning is enabled

**Added In:** 2307282043

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--jit-prov-group-static-list-enabled', type=click.BOOL, help=u"""Set to true to indicate Social JIT User Provisioning Groups should be assigned from a static list

**Added In:** 2309290043

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--jit-prov-assigned-groups', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Lists the groups each social JIT-provisioned user is a member. Just-in-Time user-provisioning applies this static list when jitProvGroupStaticListEnabled:true.

**Added In:** 2309290043

**SCIM++ Properties:**  - idcsCompositeKey: [value]  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: complex  - uniqueness: none

This option is a JSON list with items of type SocialIdentityProviderJitProvAssignedGroups.  For documentation on SocialIdentityProviderJitProvAssignedGroups please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/SocialIdentityProviderJitProvAssignedGroups.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--auto-redirect-enabled', type=click.BOOL, help=u"""Whether social auto redirect is enabled. The IDP policy should be configured with only one Social IDP, and without username/password selected.

**Added In:** 2310202314

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--status', type=custom_types.CliCaseInsensitiveChoice(["created", "deleted"]), help=u"""Status

**Added In:** 17.4.6

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--id-attribute', help=u"""Id attribute used for account linking

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: false  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--authz-url', help=u"""Social IDP Authorization URL

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--access-token-url', help=u"""Social IDP Access token URL

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--profile-url', help=u"""Social IDP User profile URL

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--scope', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Scope to request

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--admin-scope', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Admin scope to request

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--apple-dev-id', help=u"""Apple Developer ID

**Added In:** 2311180004

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--apple-key-id', help=u"""Apple Private Key ID

**Added In:** 2311180004

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--clock-skew-in-seconds', type=click.INT, help=u"""Social IDP allowed clock skew time

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: integer  - uniqueness: none""")
@cli_util.option('--redirect-url', help=u"""redirect URL for social idp

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--icon-url', help=u"""ICON URL for social idp

**Added In:** 17.4.6

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--discovery-url', help=u"""Discovery URL

**Added In:** 17.4.6

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--client-credential-in-payload', type=click.BOOL, help=u"""Whether the client credential is contained in payload

**Added In:** 18.4.2

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--refresh-token-url', help=u"""Social IDP Refresh token URL

**Added In:** 19.1.4

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--relay-idp-param-mappings', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Relay Param variable for Social IDP

**Added In:** 2305190132

**SCIM++ Properties:**  - idcsCompositeKey: [relayParamKey]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: complex  - uniqueness: none

This option is a JSON list with items of type SocialIdentityProviderRelayIdpParamMappings.  For documentation on SocialIdentityProviderRelayIdpParamMappings please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/SocialIdentityProviderRelayIdpParamMappings.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'jit-prov-assigned-groups': {'module': 'identity_domains', 'class': 'list[SocialIdentityProviderJitProvAssignedGroups]'}, 'scope': {'module': 'identity_domains', 'class': 'list[string]'}, 'admin-scope': {'module': 'identity_domains', 'class': 'list[string]'}, 'relay-idp-param-mappings': {'module': 'identity_domains', 'class': 'list[SocialIdentityProviderRelayIdpParamMappings]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'jit-prov-assigned-groups': {'module': 'identity_domains', 'class': 'list[SocialIdentityProviderJitProvAssignedGroups]'}, 'scope': {'module': 'identity_domains', 'class': 'list[string]'}, 'admin-scope': {'module': 'identity_domains', 'class': 'list[string]'}, 'relay-idp-param-mappings': {'module': 'identity_domains', 'class': 'list[SocialIdentityProviderRelayIdpParamMappings]'}}, output_type={'module': 'identity_domains', 'class': 'SocialIdentityProvider'})
@cli_util.wrap_exceptions
def create_social_identity_provider(ctx, from_json, schemas, name, enabled, account_linking_enabled, registration_enabled, show_on_login, consumer_key, consumer_secret, service_provider_name, authorization, resource_type_schema_version, id, ocid, meta, idcs_created_by, idcs_last_modified_by, idcs_prevented_operations, tags, delete_in_progress, idcs_last_upgraded_in_release, domain_ocid, compartment_ocid, tenancy_ocid, description, social_jit_provisioning_enabled, jit_prov_group_static_list_enabled, jit_prov_assigned_groups, auto_redirect_enabled, status, id_attribute, authz_url, access_token_url, profile_url, scope, admin_scope, apple_dev_id, apple_key_id, clock_skew_in_seconds, redirect_url, icon_url, discovery_url, client_credential_in_payload, refresh_token_url, relay_idp_param_mappings):

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version

    _details = {}
    _details['schemas'] = cli_util.parse_json_parameter("schemas", schemas)
    _details['name'] = name
    _details['enabled'] = enabled
    _details['accountLinkingEnabled'] = account_linking_enabled
    _details['registrationEnabled'] = registration_enabled
    _details['showOnLogin'] = show_on_login
    _details['consumerKey'] = consumer_key
    _details['consumerSecret'] = consumer_secret
    _details['serviceProviderName'] = service_provider_name

    if id is not None:
        _details['id'] = id

    if ocid is not None:
        _details['ocid'] = ocid

    if meta is not None:
        _details['meta'] = cli_util.parse_json_parameter("meta", meta)

    if idcs_created_by is not None:
        _details['idcsCreatedBy'] = cli_util.parse_json_parameter("idcs_created_by", idcs_created_by)

    if idcs_last_modified_by is not None:
        _details['idcsLastModifiedBy'] = cli_util.parse_json_parameter("idcs_last_modified_by", idcs_last_modified_by)

    if idcs_prevented_operations is not None:
        _details['idcsPreventedOperations'] = cli_util.parse_json_parameter("idcs_prevented_operations", idcs_prevented_operations)

    if tags is not None:
        _details['tags'] = cli_util.parse_json_parameter("tags", tags)

    if delete_in_progress is not None:
        _details['deleteInProgress'] = delete_in_progress

    if idcs_last_upgraded_in_release is not None:
        _details['idcsLastUpgradedInRelease'] = idcs_last_upgraded_in_release

    if domain_ocid is not None:
        _details['domainOcid'] = domain_ocid

    if compartment_ocid is not None:
        _details['compartmentOcid'] = compartment_ocid

    if tenancy_ocid is not None:
        _details['tenancyOcid'] = tenancy_ocid

    if description is not None:
        _details['description'] = description

    if social_jit_provisioning_enabled is not None:
        _details['socialJitProvisioningEnabled'] = social_jit_provisioning_enabled

    if jit_prov_group_static_list_enabled is not None:
        _details['jitProvGroupStaticListEnabled'] = jit_prov_group_static_list_enabled

    if jit_prov_assigned_groups is not None:
        _details['jitProvAssignedGroups'] = cli_util.parse_json_parameter("jit_prov_assigned_groups", jit_prov_assigned_groups)

    if auto_redirect_enabled is not None:
        _details['autoRedirectEnabled'] = auto_redirect_enabled

    if status is not None:
        _details['status'] = status

    if id_attribute is not None:
        _details['idAttribute'] = id_attribute

    if authz_url is not None:
        _details['authzUrl'] = authz_url

    if access_token_url is not None:
        _details['accessTokenUrl'] = access_token_url

    if profile_url is not None:
        _details['profileUrl'] = profile_url

    if scope is not None:
        _details['scope'] = cli_util.parse_json_parameter("scope", scope)

    if admin_scope is not None:
        _details['adminScope'] = cli_util.parse_json_parameter("admin_scope", admin_scope)

    if apple_dev_id is not None:
        _details['appleDevId'] = apple_dev_id

    if apple_key_id is not None:
        _details['appleKeyId'] = apple_key_id

    if clock_skew_in_seconds is not None:
        _details['clockSkewInSeconds'] = clock_skew_in_seconds

    if redirect_url is not None:
        _details['redirectUrl'] = redirect_url

    if icon_url is not None:
        _details['iconUrl'] = icon_url

    if discovery_url is not None:
        _details['discoveryUrl'] = discovery_url

    if client_credential_in_payload is not None:
        _details['clientCredentialInPayload'] = client_credential_in_payload

    if refresh_token_url is not None:
        _details['refreshTokenUrl'] = refresh_token_url

    if relay_idp_param_mappings is not None:
        _details['relayIdpParamMappings'] = cli_util.parse_json_parameter("relay_idp_param_mappings", relay_idp_param_mappings)

    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.create_social_identity_provider(
        social_identity_provider=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@user_group.command(name=cli_util.override('identity_domains.create_user.command_name', 'create'), help=u"""Create a user.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](createUser)""")
@cli_util.option('--schemas', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--user-name', required=True, help=u"""User name

**SCIM++ Properties:**  - caseExact: false  - idcsCsvAttributeName: User ID  - idcsCsvAttributeNameMappings: [[columnHeaderName:User Name, deprecatedColumnHeaderName:User ID]]  - idcsPii: true  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: true  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--attributes', help=u"""A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.""")
@cli_util.option('--attribute-sets', type=custom_types.CliCaseInsensitiveChoice(["all", "always", "never", "request", "default"]), multiple=True, help=u"""A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.""")
@cli_util.option('--id', help=u"""Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--ocid', help=u"""Unique OCI identifier for the SCIM Resource.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: string  - uniqueness: global""")
@cli_util.option('--meta', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-created-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-last-modified-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-prevented-operations', type=custom_types.CliCaseInsensitiveChoice(["replace", "update", "delete"]), help=u"""Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of tags on this resource.

**SCIM++ Properties:**  - idcsCompositeKey: [key, value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type Tags.  For documentation on tags please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/Tags.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--delete-in-progress', type=click.BOOL, help=u"""A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--idcs-last-upgraded-in-release', help=u"""The release number when the resource was upgraded.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--domain-ocid', help=u"""OCI Domain Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--compartment-ocid', help=u"""OCI Compartment Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--tenancy-ocid', help=u"""OCI Tenant Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--external-id', help=u"""An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

**SCIM++ Properties:**  - caseExact: false  - idcsCsvAttributeNameMappings: [[columnHeaderName:External Id]]  - idcsPii: true  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--description', help=u"""Description of the user

**Added In:** 2012271618

**SCIM++ Properties:**  - caseExact: false  - idcsPii: true  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--display-name', help=u"""Display name

**SCIM++ Properties:**  - caseExact: false  - idcsCsvAttributeName: Display Name  - idcsCsvAttributeNameMappings: [[columnHeaderName:Display Name]]  - idcsPii: true  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--nick-name', help=u"""Nick name

**SCIM++ Properties:**  - caseExact: false  - idcsCsvAttributeName: Nick Name  - idcsCsvAttributeNameMappings: [[columnHeaderName:Nick Name]]  - idcsPii: true  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--profile-url', help=u"""A fully-qualified URL to a page representing the User's online profile

**SCIM++ Properties:**  - caseExact: false  - idcsCsvAttributeName: Profile URL  - idcsCsvAttributeNameMappings: [[columnHeaderName:Profile Url]]  - idcsPii: true  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: reference  - uniqueness: none""")
@cli_util.option('--title', help=u"""Title

**SCIM++ Properties:**  - caseExact: false  - idcsCsvAttributeName: Title  - idcsCsvAttributeNameMappings: [[columnHeaderName:Title]]  - idcsPii: true  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--user-type', type=custom_types.CliCaseInsensitiveChoice(["Contractor", "Employee", "Intern", "Temp", "External", "Service", "Generic"]), help=u"""Used to identify the organization-to-user relationship

**SCIM++ Properties:**  - caseExact: false  - idcsCsvAttributeName: User Type  - idcsCsvAttributeNameMappings: [[columnHeaderName:User Type]]  - idcsPii: true  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--locale', help=u"""Used to indicate the User's default location for purposes of localizing items such as currency, date and time format, numerical representations, and so on.

**SCIM++ Properties:**  - caseExact: false  - idcsCsvAttributeName: Locale  - idcsCsvAttributeNameMappings: [[columnHeaderName:Locale]]  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--preferred-language', help=u"""User's preferred written or spoken language used for localized user interfaces

**SCIM++ Properties:**  - caseExact: false  - idcsCsvAttributeName: Preferred Language  - idcsCsvAttributeNameMappings: [[columnHeaderName:Preferred Language]]  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--timezone', help=u"""User's timezone

**SCIM++ Properties:**  - caseExact: false  - idcsCanonicalValueSourceFilter: attrName eq \"timezones\" and attrValues.value eq \"$(timezone)\"  - idcsCanonicalValueSourceResourceType: AllowedValue  - idcsCsvAttributeName: TimeZone  - idcsCsvAttributeNameMappings: [[columnHeaderName:Time Zone, deprecatedColumnHeaderName:TimeZone]]  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--active', type=click.BOOL, help=u"""User status

**SCIM++ Properties:**  - caseExact: false  - idcsCsvAttributeName: Active  - idcsCsvAttributeNameMappings: [[columnHeaderName:Active]]  - idcsSearchable: true  - multiValued: false  - mutability: readWrite  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--password', help=u"""Password attribute. Max length for password is controlled via Password Policy.

**SCIM++ Properties:**  - idcsCsvAttributeName: Password  - idcsCsvAttributeNameMappings: [[columnHeaderName:Password]]  - idcsPii: true  - idcsSearchable: false  - idcsSensitive: hash  - multiValued: false  - mutability: writeOnly  - required: false  - returned: never  - type: string  - uniqueness: none""")
@cli_util.option('--name', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--emails', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A complex attribute representing emails

**SCIM++ Properties:**  - idcsCompositeKey: [value, type]  - idcsCsvAttributeNameMappings: [[columnHeaderName:Work Email, mapsTo:emails[work].value], [columnHeaderName:Home Email, mapsTo:emails[home].value], [columnHeaderName:Primary Email Type, mapsTo:emails[$(type)].primary], [columnHeaderName:Other Email, mapsTo:emails[other].value], [columnHeaderName:Recovery Email, mapsTo:emails[recovery].value], [columnHeaderName:Work Email Verified, mapsTo:emails[work].verified], [columnHeaderName:Home Email Verified, mapsTo:emails[home].verified], [columnHeaderName:Other Email Verified, mapsTo:emails[other].verified], [columnHeaderName:Recovery Email Verified, mapsTo:emails[recovery].verified]]  - idcsPii: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: complex  - uniqueness: none

This option is a JSON list with items of type UserEmails.  For documentation on UserEmails please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/UserEmails.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--phone-numbers', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Phone numbers

**SCIM++ Properties:**  - idcsCompositeKey: [value, type]  - idcsCsvAttributeNameMappings: [[columnHeaderName:Work Phone, mapsTo:phoneNumbers[work].value], [columnHeaderName:Mobile No, mapsTo:phoneNumbers[mobile].value], [columnHeaderName:Home Phone, mapsTo:phoneNumbers[home].value], [columnHeaderName:Fax, mapsTo:phoneNumbers[fax].value], [columnHeaderName:Pager, mapsTo:phoneNumbers[pager].value], [columnHeaderName:Other Phone, mapsTo:phoneNumbers[other].value], [columnHeaderName:Recovery Phone, mapsTo:phoneNumbers[recovery].value], [columnHeaderName:Primary Phone Type, mapsTo:phoneNumbers[$(type)].primary]]  - idcsPii: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: complex  - uniqueness: none

This option is a JSON list with items of type UserPhoneNumbers.  For documentation on UserPhoneNumbers please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/UserPhoneNumbers.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--ims', type=custom_types.CLI_COMPLEX_TYPE, help=u"""User's instant messaging addresses

**SCIM++ Properties:**  - idcsCompositeKey: [value, type]  - idcsPii: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: complex  - uniqueness: none

This option is a JSON list with items of type UserIms.  For documentation on UserIms please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/UserIms.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--photos', type=custom_types.CLI_COMPLEX_TYPE, help=u"""URLs of photos for the User

**SCIM++ Properties:**  - idcsCompositeKey: [value, type]  - idcsPii: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: complex  - uniqueness: none

This option is a JSON list with items of type UserPhotos.  For documentation on UserPhotos please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/UserPhotos.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--addresses', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A physical mailing address for this User, as described in (address Element). Canonical Type Values of work, home, and other. The value attribute is a complex type with the following sub-attributes.

**SCIM++ Properties:**  - idcsCompositeKey: [type]  - idcsCsvAttributeNameMappings: [[columnHeaderName:Work Address Street, deprecatedColumnHeaderName:Work Street Address, mapsTo:addresses[work].streetAddress], [columnHeaderName:Work Address Locality, deprecatedColumnHeaderName:Work City, mapsTo:addresses[work].locality], [columnHeaderName:Work Address Region, deprecatedColumnHeaderName:Work State, mapsTo:addresses[work].region], [columnHeaderName:Work Address Postal Code, deprecatedColumnHeaderName:Work Postal Code, mapsTo:addresses[work].postalCode], [columnHeaderName:Work Address Country, deprecatedColumnHeaderName:Work Country, mapsTo:addresses[work].country], [columnHeaderName:Work Address Formatted, mapsTo:addresses[work].formatted], [columnHeaderName:Home Address Formatted, mapsTo:addresses[home].formatted], [columnHeaderName:Other Address Formatted, mapsTo:addresses[other].formatted], [columnHeaderName:Home Address Street, mapsTo:addresses[home].streetAddress], [columnHeaderName:Other Address Street, mapsTo:addresses[other].streetAddress], [columnHeaderName:Home Address Locality, mapsTo:addresses[home].locality], [columnHeaderName:Other Address Locality, mapsTo:addresses[other].locality], [columnHeaderName:Home Address Region, mapsTo:addresses[home].region], [columnHeaderName:Other Address Region, mapsTo:addresses[other].region], [columnHeaderName:Home Address Country, mapsTo:addresses[home].country], [columnHeaderName:Other Address Country, mapsTo:addresses[other].country], [columnHeaderName:Home Address Postal Code, mapsTo:addresses[home].postalCode], [columnHeaderName:Other Address Postal Code, mapsTo:addresses[other].postalCode], [columnHeaderName:Primary Address Type, mapsTo:addresses[$(type)].primary]]  - idcsPii: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: complex  - uniqueness: none

This option is a JSON list with items of type Addresses.  For documentation on addresses please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/Addresses.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--groups', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of groups that the user belongs to, either thorough direct membership, nested groups, or dynamically calculated

**SCIM++ Properties:**  - idcsCompositeKey: [value]  - idcsSearchable: true  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type UserGroups.  For documentation on UserGroups please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/UserGroups.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--entitlements', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of entitlements for the User that represent a thing the User has.

**SCIM++ Properties:**  - idcsCompositeKey: [value, type]  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: complex  - uniqueness: none

This option is a JSON list with items of type UserEntitlements.  For documentation on UserEntitlements please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/UserEntitlements.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--roles', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of roles for the User that collectively represent who the User is; e.g., 'Student', 'Faculty'.

**SCIM++ Properties:**  - idcsCompositeKey: [value, type]  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: complex  - uniqueness: none

This option is a JSON list with items of type UserRoles.  For documentation on UserRoles please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/UserRoles.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--x509-certificates', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of certificates issued to the User.

**SCIM++ Properties:**  - idcsCompositeKey: [value]  - multiValued: true  - mutability: readWrite  - required: false  - returned: default  - type: complex  - uniqueness: none

This option is a JSON list with items of type UserX509Certificates.  For documentation on UserX509Certificates please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/UserX509Certificates.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasextensionenterprise2-0-user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionuser-user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionpassword-state-user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionuser-state-user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionposix-user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionkerberos-user-user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionmfa-user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionadaptive-user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionsff-user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionsecurity-questions-user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionself-registration-user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionsocial-account-user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensiondb-user-user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionterms-of-use-user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionpasswordless-user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextension-oci-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionuser-credentials-user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensioncapabilities-user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensiondb-credentials-user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionself-change-user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'name': {'module': 'identity_domains', 'class': 'UserName'}, 'emails': {'module': 'identity_domains', 'class': 'list[UserEmails]'}, 'phone-numbers': {'module': 'identity_domains', 'class': 'list[UserPhoneNumbers]'}, 'ims': {'module': 'identity_domains', 'class': 'list[UserIms]'}, 'photos': {'module': 'identity_domains', 'class': 'list[UserPhotos]'}, 'addresses': {'module': 'identity_domains', 'class': 'list[Addresses]'}, 'groups': {'module': 'identity_domains', 'class': 'list[UserGroups]'}, 'entitlements': {'module': 'identity_domains', 'class': 'list[UserEntitlements]'}, 'roles': {'module': 'identity_domains', 'class': 'list[UserRoles]'}, 'x509-certificates': {'module': 'identity_domains', 'class': 'list[UserX509Certificates]'}, 'urnietfparamsscimschemasextensionenterprise2-0-user': {'module': 'identity_domains', 'class': 'ExtensionEnterprise20User'}, 'urnietfparamsscimschemasoracleidcsextensionuser-user': {'module': 'identity_domains', 'class': 'ExtensionUserUser'}, 'urnietfparamsscimschemasoracleidcsextensionpassword-state-user': {'module': 'identity_domains', 'class': 'ExtensionPasswordStateUser'}, 'urnietfparamsscimschemasoracleidcsextensionuser-state-user': {'module': 'identity_domains', 'class': 'ExtensionUserStateUser'}, 'urnietfparamsscimschemasoracleidcsextensionposix-user': {'module': 'identity_domains', 'class': 'ExtensionPosixUser'}, 'urnietfparamsscimschemasoracleidcsextensionkerberos-user-user': {'module': 'identity_domains', 'class': 'ExtensionKerberosUserUser'}, 'urnietfparamsscimschemasoracleidcsextensionmfa-user': {'module': 'identity_domains', 'class': 'ExtensionMfaUser'}, 'urnietfparamsscimschemasoracleidcsextensionadaptive-user': {'module': 'identity_domains', 'class': 'ExtensionAdaptiveUser'}, 'urnietfparamsscimschemasoracleidcsextensionsff-user': {'module': 'identity_domains', 'class': 'ExtensionSffUser'}, 'urnietfparamsscimschemasoracleidcsextensionsecurity-questions-user': {'module': 'identity_domains', 'class': 'ExtensionSecurityQuestionsUser'}, 'urnietfparamsscimschemasoracleidcsextensionself-registration-user': {'module': 'identity_domains', 'class': 'ExtensionSelfRegistrationUser'}, 'urnietfparamsscimschemasoracleidcsextensionsocial-account-user': {'module': 'identity_domains', 'class': 'ExtensionSocialAccountUser'}, 'urnietfparamsscimschemasoracleidcsextensiondb-user-user': {'module': 'identity_domains', 'class': 'ExtensionDbUserUser'}, 'urnietfparamsscimschemasoracleidcsextensionterms-of-use-user': {'module': 'identity_domains', 'class': 'ExtensionTermsOfUseUser'}, 'urnietfparamsscimschemasoracleidcsextensionpasswordless-user': {'module': 'identity_domains', 'class': 'ExtensionPasswordlessUser'}, 'urnietfparamsscimschemasoracleidcsextension-oci-tags': {'module': 'identity_domains', 'class': 'ExtensionOCITags'}, 'urnietfparamsscimschemasoracleidcsextensionuser-credentials-user': {'module': 'identity_domains', 'class': 'ExtensionUserCredentialsUser'}, 'urnietfparamsscimschemasoracleidcsextensioncapabilities-user': {'module': 'identity_domains', 'class': 'ExtensionCapabilitiesUser'}, 'urnietfparamsscimschemasoracleidcsextensiondb-credentials-user': {'module': 'identity_domains', 'class': 'ExtensionDbCredentialsUser'}, 'urnietfparamsscimschemasoracleidcsextensionself-change-user': {'module': 'identity_domains', 'class': 'ExtensionSelfChangeUser'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'name': {'module': 'identity_domains', 'class': 'UserName'}, 'emails': {'module': 'identity_domains', 'class': 'list[UserEmails]'}, 'phone-numbers': {'module': 'identity_domains', 'class': 'list[UserPhoneNumbers]'}, 'ims': {'module': 'identity_domains', 'class': 'list[UserIms]'}, 'photos': {'module': 'identity_domains', 'class': 'list[UserPhotos]'}, 'addresses': {'module': 'identity_domains', 'class': 'list[Addresses]'}, 'groups': {'module': 'identity_domains', 'class': 'list[UserGroups]'}, 'entitlements': {'module': 'identity_domains', 'class': 'list[UserEntitlements]'}, 'roles': {'module': 'identity_domains', 'class': 'list[UserRoles]'}, 'x509-certificates': {'module': 'identity_domains', 'class': 'list[UserX509Certificates]'}, 'urnietfparamsscimschemasextensionenterprise2-0-user': {'module': 'identity_domains', 'class': 'ExtensionEnterprise20User'}, 'urnietfparamsscimschemasoracleidcsextensionuser-user': {'module': 'identity_domains', 'class': 'ExtensionUserUser'}, 'urnietfparamsscimschemasoracleidcsextensionpassword-state-user': {'module': 'identity_domains', 'class': 'ExtensionPasswordStateUser'}, 'urnietfparamsscimschemasoracleidcsextensionuser-state-user': {'module': 'identity_domains', 'class': 'ExtensionUserStateUser'}, 'urnietfparamsscimschemasoracleidcsextensionposix-user': {'module': 'identity_domains', 'class': 'ExtensionPosixUser'}, 'urnietfparamsscimschemasoracleidcsextensionkerberos-user-user': {'module': 'identity_domains', 'class': 'ExtensionKerberosUserUser'}, 'urnietfparamsscimschemasoracleidcsextensionmfa-user': {'module': 'identity_domains', 'class': 'ExtensionMfaUser'}, 'urnietfparamsscimschemasoracleidcsextensionadaptive-user': {'module': 'identity_domains', 'class': 'ExtensionAdaptiveUser'}, 'urnietfparamsscimschemasoracleidcsextensionsff-user': {'module': 'identity_domains', 'class': 'ExtensionSffUser'}, 'urnietfparamsscimschemasoracleidcsextensionsecurity-questions-user': {'module': 'identity_domains', 'class': 'ExtensionSecurityQuestionsUser'}, 'urnietfparamsscimschemasoracleidcsextensionself-registration-user': {'module': 'identity_domains', 'class': 'ExtensionSelfRegistrationUser'}, 'urnietfparamsscimschemasoracleidcsextensionsocial-account-user': {'module': 'identity_domains', 'class': 'ExtensionSocialAccountUser'}, 'urnietfparamsscimschemasoracleidcsextensiondb-user-user': {'module': 'identity_domains', 'class': 'ExtensionDbUserUser'}, 'urnietfparamsscimschemasoracleidcsextensionterms-of-use-user': {'module': 'identity_domains', 'class': 'ExtensionTermsOfUseUser'}, 'urnietfparamsscimschemasoracleidcsextensionpasswordless-user': {'module': 'identity_domains', 'class': 'ExtensionPasswordlessUser'}, 'urnietfparamsscimschemasoracleidcsextension-oci-tags': {'module': 'identity_domains', 'class': 'ExtensionOCITags'}, 'urnietfparamsscimschemasoracleidcsextensionuser-credentials-user': {'module': 'identity_domains', 'class': 'ExtensionUserCredentialsUser'}, 'urnietfparamsscimschemasoracleidcsextensioncapabilities-user': {'module': 'identity_domains', 'class': 'ExtensionCapabilitiesUser'}, 'urnietfparamsscimschemasoracleidcsextensiondb-credentials-user': {'module': 'identity_domains', 'class': 'ExtensionDbCredentialsUser'}, 'urnietfparamsscimschemasoracleidcsextensionself-change-user': {'module': 'identity_domains', 'class': 'ExtensionSelfChangeUser'}}, output_type={'module': 'identity_domains', 'class': 'User'})
@cli_util.wrap_exceptions
def create_user(ctx, from_json, schemas, user_name, authorization, resource_type_schema_version, attributes, attribute_sets, id, ocid, meta, idcs_created_by, idcs_last_modified_by, idcs_prevented_operations, tags, delete_in_progress, idcs_last_upgraded_in_release, domain_ocid, compartment_ocid, tenancy_ocid, external_id, description, display_name, nick_name, profile_url, title, user_type, locale, preferred_language, timezone, active, password, name, emails, phone_numbers, ims, photos, addresses, groups, entitlements, roles, x509_certificates, urnietfparamsscimschemasextensionenterprise2_0_user, urnietfparamsscimschemasoracleidcsextensionuser_user, urnietfparamsscimschemasoracleidcsextensionpassword_state_user, urnietfparamsscimschemasoracleidcsextensionuser_state_user, urnietfparamsscimschemasoracleidcsextensionposix_user, urnietfparamsscimschemasoracleidcsextensionkerberos_user_user, urnietfparamsscimschemasoracleidcsextensionmfa_user, urnietfparamsscimschemasoracleidcsextensionadaptive_user, urnietfparamsscimschemasoracleidcsextensionsff_user, urnietfparamsscimschemasoracleidcsextensionsecurity_questions_user, urnietfparamsscimschemasoracleidcsextensionself_registration_user, urnietfparamsscimschemasoracleidcsextensionsocial_account_user, urnietfparamsscimschemasoracleidcsextensiondb_user_user, urnietfparamsscimschemasoracleidcsextensionterms_of_use_user, urnietfparamsscimschemasoracleidcsextensionpasswordless_user, urnietfparamsscimschemasoracleidcsextension_oci_tags, urnietfparamsscimschemasoracleidcsextensionuser_credentials_user, urnietfparamsscimschemasoracleidcsextensioncapabilities_user, urnietfparamsscimschemasoracleidcsextensiondb_credentials_user, urnietfparamsscimschemasoracleidcsextensionself_change_user):

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if attributes is not None:
        kwargs['attributes'] = attributes
    if attribute_sets is not None and len(attribute_sets) > 0:
        kwargs['attribute_sets'] = attribute_sets

    _details = {}
    _details['schemas'] = cli_util.parse_json_parameter("schemas", schemas)
    _details['userName'] = user_name

    if id is not None:
        _details['id'] = id

    if ocid is not None:
        _details['ocid'] = ocid

    if meta is not None:
        _details['meta'] = cli_util.parse_json_parameter("meta", meta)

    if idcs_created_by is not None:
        _details['idcsCreatedBy'] = cli_util.parse_json_parameter("idcs_created_by", idcs_created_by)

    if idcs_last_modified_by is not None:
        _details['idcsLastModifiedBy'] = cli_util.parse_json_parameter("idcs_last_modified_by", idcs_last_modified_by)

    if idcs_prevented_operations is not None:
        _details['idcsPreventedOperations'] = cli_util.parse_json_parameter("idcs_prevented_operations", idcs_prevented_operations)

    if tags is not None:
        _details['tags'] = cli_util.parse_json_parameter("tags", tags)

    if delete_in_progress is not None:
        _details['deleteInProgress'] = delete_in_progress

    if idcs_last_upgraded_in_release is not None:
        _details['idcsLastUpgradedInRelease'] = idcs_last_upgraded_in_release

    if domain_ocid is not None:
        _details['domainOcid'] = domain_ocid

    if compartment_ocid is not None:
        _details['compartmentOcid'] = compartment_ocid

    if tenancy_ocid is not None:
        _details['tenancyOcid'] = tenancy_ocid

    if external_id is not None:
        _details['externalId'] = external_id

    if description is not None:
        _details['description'] = description

    if display_name is not None:
        _details['displayName'] = display_name

    if nick_name is not None:
        _details['nickName'] = nick_name

    if profile_url is not None:
        _details['profileUrl'] = profile_url

    if title is not None:
        _details['title'] = title

    if user_type is not None:
        _details['userType'] = user_type

    if locale is not None:
        _details['locale'] = locale

    if preferred_language is not None:
        _details['preferredLanguage'] = preferred_language

    if timezone is not None:
        _details['timezone'] = timezone

    if active is not None:
        _details['active'] = active

    if password is not None:
        _details['password'] = password

    if name is not None:
        _details['name'] = cli_util.parse_json_parameter("name", name)

    if emails is not None:
        _details['emails'] = cli_util.parse_json_parameter("emails", emails)

    if phone_numbers is not None:
        _details['phoneNumbers'] = cli_util.parse_json_parameter("phone_numbers", phone_numbers)

    if ims is not None:
        _details['ims'] = cli_util.parse_json_parameter("ims", ims)

    if photos is not None:
        _details['photos'] = cli_util.parse_json_parameter("photos", photos)

    if addresses is not None:
        _details['addresses'] = cli_util.parse_json_parameter("addresses", addresses)

    if groups is not None:
        _details['groups'] = cli_util.parse_json_parameter("groups", groups)

    if entitlements is not None:
        _details['entitlements'] = cli_util.parse_json_parameter("entitlements", entitlements)

    if roles is not None:
        _details['roles'] = cli_util.parse_json_parameter("roles", roles)

    if x509_certificates is not None:
        _details['x509Certificates'] = cli_util.parse_json_parameter("x509_certificates", x509_certificates)

    if urnietfparamsscimschemasextensionenterprise2_0_user is not None:
        _details['urn:ietf:params:scim:schemas:extension:enterprise:2.0:User'] = cli_util.parse_json_parameter("urnietfparamsscimschemasextensionenterprise2_0_user", urnietfparamsscimschemasextensionenterprise2_0_user)

    if urnietfparamsscimschemasoracleidcsextensionuser_user is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:user:User'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionuser_user", urnietfparamsscimschemasoracleidcsextensionuser_user)

    if urnietfparamsscimschemasoracleidcsextensionpassword_state_user is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:passwordState:User'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionpassword_state_user", urnietfparamsscimschemasoracleidcsextensionpassword_state_user)

    if urnietfparamsscimschemasoracleidcsextensionuser_state_user is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:userState:User'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionuser_state_user", urnietfparamsscimschemasoracleidcsextensionuser_state_user)

    if urnietfparamsscimschemasoracleidcsextensionposix_user is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:posix:User'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionposix_user", urnietfparamsscimschemasoracleidcsextensionposix_user)

    if urnietfparamsscimschemasoracleidcsextensionkerberos_user_user is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:kerberosUser:User'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionkerberos_user_user", urnietfparamsscimschemasoracleidcsextensionkerberos_user_user)

    if urnietfparamsscimschemasoracleidcsextensionmfa_user is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:mfa:User'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionmfa_user", urnietfparamsscimschemasoracleidcsextensionmfa_user)

    if urnietfparamsscimschemasoracleidcsextensionadaptive_user is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:adaptive:User'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionadaptive_user", urnietfparamsscimschemasoracleidcsextensionadaptive_user)

    if urnietfparamsscimschemasoracleidcsextensionsff_user is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:sff:User'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionsff_user", urnietfparamsscimschemasoracleidcsextensionsff_user)

    if urnietfparamsscimschemasoracleidcsextensionsecurity_questions_user is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:securityQuestions:User'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionsecurity_questions_user", urnietfparamsscimschemasoracleidcsextensionsecurity_questions_user)

    if urnietfparamsscimschemasoracleidcsextensionself_registration_user is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:selfRegistration:User'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionself_registration_user", urnietfparamsscimschemasoracleidcsextensionself_registration_user)

    if urnietfparamsscimschemasoracleidcsextensionsocial_account_user is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:socialAccount:User'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionsocial_account_user", urnietfparamsscimschemasoracleidcsextensionsocial_account_user)

    if urnietfparamsscimschemasoracleidcsextensiondb_user_user is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:dbUser:User'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensiondb_user_user", urnietfparamsscimschemasoracleidcsextensiondb_user_user)

    if urnietfparamsscimschemasoracleidcsextensionterms_of_use_user is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:termsOfUse:User'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionterms_of_use_user", urnietfparamsscimschemasoracleidcsextensionterms_of_use_user)

    if urnietfparamsscimschemasoracleidcsextensionpasswordless_user is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:passwordless:User'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionpasswordless_user", urnietfparamsscimschemasoracleidcsextensionpasswordless_user)

    if urnietfparamsscimschemasoracleidcsextension_oci_tags is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:OCITags'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextension_oci_tags", urnietfparamsscimschemasoracleidcsextension_oci_tags)

    if urnietfparamsscimschemasoracleidcsextensionuser_credentials_user is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:userCredentials:User'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionuser_credentials_user", urnietfparamsscimschemasoracleidcsextensionuser_credentials_user)

    if urnietfparamsscimschemasoracleidcsextensioncapabilities_user is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:capabilities:User'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensioncapabilities_user", urnietfparamsscimschemasoracleidcsextensioncapabilities_user)

    if urnietfparamsscimschemasoracleidcsextensiondb_credentials_user is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:dbCredentials:User'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensiondb_credentials_user", urnietfparamsscimschemasoracleidcsextensiondb_credentials_user)

    if urnietfparamsscimschemasoracleidcsextensionself_change_user is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:selfChange:User'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionself_change_user", urnietfparamsscimschemasoracleidcsextensionself_change_user)

    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.create_user(
        user=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@user_db_credential_group.command(name=cli_util.override('identity_domains.create_user_db_credential.command_name', 'create'), help=u"""Create a user's database (DB) credentials.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](createUserDbCredential)""")
@cli_util.option('--schemas', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: true  - mutability: readWrite  - required: true  - returned: default  - type: string  - uniqueness: none""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--db-password', required=True, help=u"""The user's database password.

**SCIM++ Properties:**  - type: string  - mutability: immutable  - returned: default  - required: true""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--attributes', help=u"""A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.""")
@cli_util.option('--attribute-sets', type=custom_types.CliCaseInsensitiveChoice(["all", "always", "never", "request", "default"]), multiple=True, help=u"""A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.""")
@cli_util.option('--id', help=u"""Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: always  - type: string  - uniqueness: global""")
@cli_util.option('--ocid', help=u"""Unique OCI identifier for the SCIM Resource.

**SCIM++ Properties:**  - caseExact: true  - idcsSearchable: true  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: string  - uniqueness: global""")
@cli_util.option('--meta', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-created-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-last-modified-by', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--idcs-prevented-operations', type=custom_types.CliCaseInsensitiveChoice(["replace", "update", "delete"]), help=u"""Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

**SCIM++ Properties:**  - idcsSearchable: false  - multiValued: true  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of tags on this resource.

**SCIM++ Properties:**  - idcsCompositeKey: [key, value]  - idcsSearchable: true  - multiValued: true  - mutability: readWrite  - required: false  - returned: request  - type: complex  - uniqueness: none

This option is a JSON list with items of type Tags.  For documentation on tags please see our API reference: https://docs.cloud.oracle.com/api/#/en/identitydomains/v1/datatypes/Tags.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--delete-in-progress', type=click.BOOL, help=u"""A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: true  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: boolean  - uniqueness: none""")
@cli_util.option('--idcs-last-upgraded-in-release', help=u"""The release number when the resource was upgraded.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: request  - type: string  - uniqueness: none""")
@cli_util.option('--domain-ocid', help=u"""OCI Domain Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--compartment-ocid', help=u"""OCI Compartment Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--tenancy-ocid', help=u"""OCI Tenant Id (ocid) in which the resource lives.

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readOnly  - required: false  - returned: default  - type: string  - uniqueness: none""")
@cli_util.option('--name', help=u"""Name

**Added In:** 2109090424

**SCIM++ Properties:**  - caseExact: false  - type: string  - mutability: readOnly  - required: false  - returned: default""")
@cli_util.option('--description', help=u"""Description

**Added In:** 2109020413

**SCIM++ Properties:**  - caseExact: false  - type: string  - mutability: readWrite  - required: false  - returned: default""")
@cli_util.option('--mixed-db-password', help=u"""The user's database password with mixed salt.

**SCIM++ Properties:**  - type: string  - mutability: readOnly  - returned: default  - required: false""")
@cli_util.option('--salt', help=u"""The salt of the password.

**SCIM++ Properties:**  - type: string  - mutability: readOnly  - returned: default  - required: false""")
@cli_util.option('--mixed-salt', help=u"""The mixed salt of the password.

**SCIM++ Properties:**  - type: string  - mutability: readOnly  - returned: default  - required: false""")
@cli_util.option('--last-set-date', help=u"""A DateTime that specifies the date and time when the current database password was set.

**SCIM++ Properties:**  - type: dateTime  - mutability: readOnly  - returned: default""")
@cli_util.option('--expired', type=click.BOOL, help=u"""Indicates that the database password has expired.

**SCIM++ Properties:**  - type: boolean  - mutability: readOnly  - returned: default""")
@cli_util.option('--status', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "INACTIVE"]), help=u"""User credential status

**Added In:** 2109090424

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: readWrite  - required: false  - returned: never  - type: string  - uniqueness: none""")
@cli_util.option('--expires-on', help=u"""When the user credential expires.

**Added In:** 2109090424

**SCIM++ Properties:**  - caseExact: false  - idcsSearchable: false  - multiValued: false  - mutability: immutable  - required: false  - returned: default  - type: dateTime  - uniqueness: none""")
@cli_util.option('--user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--urnietfparamsscimschemasoracleidcsextensionself-change-user', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'user': {'module': 'identity_domains', 'class': 'UserDbCredentialsUser'}, 'urnietfparamsscimschemasoracleidcsextensionself-change-user': {'module': 'identity_domains', 'class': 'ExtensionSelfChangeUser'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'schemas': {'module': 'identity_domains', 'class': 'list[string]'}, 'meta': {'module': 'identity_domains', 'class': 'Meta'}, 'idcs-created-by': {'module': 'identity_domains', 'class': 'IdcsCreatedBy'}, 'idcs-last-modified-by': {'module': 'identity_domains', 'class': 'IdcsLastModifiedBy'}, 'tags': {'module': 'identity_domains', 'class': 'list[Tags]'}, 'user': {'module': 'identity_domains', 'class': 'UserDbCredentialsUser'}, 'urnietfparamsscimschemasoracleidcsextensionself-change-user': {'module': 'identity_domains', 'class': 'ExtensionSelfChangeUser'}}, output_type={'module': 'identity_domains', 'class': 'UserDbCredential'})
@cli_util.wrap_exceptions
def create_user_db_credential(ctx, from_json, schemas, db_password, authorization, resource_type_schema_version, attributes, attribute_sets, id, ocid, meta, idcs_created_by, idcs_last_modified_by, idcs_prevented_operations, tags, delete_in_progress, idcs_last_upgraded_in_release, domain_ocid, compartment_ocid, tenancy_ocid, name, description, mixed_db_password, salt, mixed_salt, last_set_date, expired, status, expires_on, user, urnietfparamsscimschemasoracleidcsextensionself_change_user):

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if attributes is not None:
        kwargs['attributes'] = attributes
    if attribute_sets is not None and len(attribute_sets) > 0:
        kwargs['attribute_sets'] = attribute_sets

    _details = {}
    _details['schemas'] = cli_util.parse_json_parameter("schemas", schemas)
    _details['dbPassword'] = db_password

    if id is not None:
        _details['id'] = id

    if ocid is not None:
        _details['ocid'] = ocid

    if meta is not None:
        _details['meta'] = cli_util.parse_json_parameter("meta", meta)

    if idcs_created_by is not None:
        _details['idcsCreatedBy'] = cli_util.parse_json_parameter("idcs_created_by", idcs_created_by)

    if idcs_last_modified_by is not None:
        _details['idcsLastModifiedBy'] = cli_util.parse_json_parameter("idcs_last_modified_by", idcs_last_modified_by)

    if idcs_prevented_operations is not None:
        _details['idcsPreventedOperations'] = cli_util.parse_json_parameter("idcs_prevented_operations", idcs_prevented_operations)

    if tags is not None:
        _details['tags'] = cli_util.parse_json_parameter("tags", tags)

    if delete_in_progress is not None:
        _details['deleteInProgress'] = delete_in_progress

    if idcs_last_upgraded_in_release is not None:
        _details['idcsLastUpgradedInRelease'] = idcs_last_upgraded_in_release

    if domain_ocid is not None:
        _details['domainOcid'] = domain_ocid

    if compartment_ocid is not None:
        _details['compartmentOcid'] = compartment_ocid

    if tenancy_ocid is not None:
        _details['tenancyOcid'] = tenancy_ocid

    if name is not None:
        _details['name'] = name

    if description is not None:
        _details['description'] = description

    if mixed_db_password is not None:
        _details['mixedDbPassword'] = mixed_db_password

    if salt is not None:
        _details['salt'] = salt

    if mixed_salt is not None:
        _details['mixedSalt'] = mixed_salt

    if last_set_date is not None:
        _details['lastSetDate'] = last_set_date

    if expired is not None:
        _details['expired'] = expired

    if status is not None:
        _details['status'] = status

    if expires_on is not None:
        _details['expiresOn'] = expires_on

    if user is not None:
        _details['user'] = cli_util.parse_json_parameter("user", user)

    if urnietfparamsscimschemasoracleidcsextensionself_change_user is not None:
        _details['urn:ietf:params:scim:schemas:oracle:idcs:extension:selfChange:User'] = cli_util.parse_json_parameter("urnietfparamsscimschemasoracleidcsextensionself_change_user", urnietfparamsscimschemasoracleidcsextensionself_change_user)

    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.create_user_db_credential(
        user_db_credential=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@api_key_group.command(name=cli_util.override('identity_domains.delete_api_key.command_name', 'delete'), help=u"""Delete a user's API key.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](deleteApiKey)""")
@cli_util.option('--api-key-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--force-delete', type=click.BOOL, help=u"""To force delete the resource and all its references (if any).""")
@cli_util.option('--if-match', help=u"""Used to make the request conditional on an ETag""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_api_key(ctx, from_json, api_key_id, authorization, resource_type_schema_version, force_delete, if_match):

    if isinstance(api_key_id, six.string_types) and len(api_key_id.strip()) == 0:
        raise click.UsageError('Parameter --api-key-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if force_delete is not None:
        kwargs['force_delete'] = force_delete
    if if_match is not None:
        kwargs['if_match'] = if_match
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.delete_api_key(
        api_key_id=api_key_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@app_group.command(name=cli_util.override('identity_domains.delete_app.command_name', 'delete'), help=u"""Delete an App

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](deleteApp)""")
@cli_util.option('--app-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--force-delete', type=click.BOOL, help=u"""To force delete the resource and all its references (if any).""")
@cli_util.option('--if-match', help=u"""Used to make the request conditional on an ETag""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_app(ctx, from_json, app_id, authorization, resource_type_schema_version, force_delete, if_match):

    if isinstance(app_id, six.string_types) and len(app_id.strip()) == 0:
        raise click.UsageError('Parameter --app-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if force_delete is not None:
        kwargs['force_delete'] = force_delete
    if if_match is not None:
        kwargs['if_match'] = if_match
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.delete_app(
        app_id=app_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@app_role_group.command(name=cli_util.override('identity_domains.delete_app_role.command_name', 'delete'), help=u"""Delete an AppRole

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](deleteAppRole)""")
@cli_util.option('--app-role-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--force-delete', type=click.BOOL, help=u"""To force delete the resource and all its references (if any).""")
@cli_util.option('--if-match', help=u"""Used to make the request conditional on an ETag""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_app_role(ctx, from_json, app_role_id, authorization, resource_type_schema_version, force_delete, if_match):

    if isinstance(app_role_id, six.string_types) and len(app_role_id.strip()) == 0:
        raise click.UsageError('Parameter --app-role-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if force_delete is not None:
        kwargs['force_delete'] = force_delete
    if if_match is not None:
        kwargs['if_match'] = if_match
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.delete_app_role(
        app_role_id=app_role_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@approval_workflow_group.command(name=cli_util.override('identity_domains.delete_approval_workflow.command_name', 'delete'), help=u"""Delete ApprovalWorkflow

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](deleteApprovalWorkflow)""")
@cli_util.option('--approval-workflow-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--force-delete', type=click.BOOL, help=u"""To force delete the resource and all its references (if any).""")
@cli_util.option('--if-match', help=u"""Used to make the request conditional on an ETag""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_approval_workflow(ctx, from_json, approval_workflow_id, authorization, resource_type_schema_version, force_delete, if_match):

    if isinstance(approval_workflow_id, six.string_types) and len(approval_workflow_id.strip()) == 0:
        raise click.UsageError('Parameter --approval-workflow-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if force_delete is not None:
        kwargs['force_delete'] = force_delete
    if if_match is not None:
        kwargs['if_match'] = if_match
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.delete_approval_workflow(
        approval_workflow_id=approval_workflow_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@approval_workflow_assignment_group.command(name=cli_util.override('identity_domains.delete_approval_workflow_assignment.command_name', 'delete'), help=u"""Delete Approval Workflow Assignment

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](deleteApprovalWorkflowAssignment)""")
@cli_util.option('--approval-workflow-assignment-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--force-delete', type=click.BOOL, help=u"""To force delete the resource and all its references (if any).""")
@cli_util.option('--if-match', help=u"""Used to make the request conditional on an ETag""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_approval_workflow_assignment(ctx, from_json, approval_workflow_assignment_id, authorization, resource_type_schema_version, force_delete, if_match):

    if isinstance(approval_workflow_assignment_id, six.string_types) and len(approval_workflow_assignment_id.strip()) == 0:
        raise click.UsageError('Parameter --approval-workflow-assignment-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if force_delete is not None:
        kwargs['force_delete'] = force_delete
    if if_match is not None:
        kwargs['if_match'] = if_match
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.delete_approval_workflow_assignment(
        approval_workflow_assignment_id=approval_workflow_assignment_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@approval_workflow_step_group.command(name=cli_util.override('identity_domains.delete_approval_workflow_step.command_name', 'delete'), help=u"""Delete ApprovalWorkflowStep

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](deleteApprovalWorkflowStep)""")
@cli_util.option('--approval-workflow-step-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--force-delete', type=click.BOOL, help=u"""To force delete the resource and all its references (if any).""")
@cli_util.option('--if-match', help=u"""Used to make the request conditional on an ETag""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_approval_workflow_step(ctx, from_json, approval_workflow_step_id, authorization, resource_type_schema_version, force_delete, if_match):

    if isinstance(approval_workflow_step_id, six.string_types) and len(approval_workflow_step_id.strip()) == 0:
        raise click.UsageError('Parameter --approval-workflow-step-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if force_delete is not None:
        kwargs['force_delete'] = force_delete
    if if_match is not None:
        kwargs['if_match'] = if_match
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.delete_approval_workflow_step(
        approval_workflow_step_id=approval_workflow_step_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@auth_token_group.command(name=cli_util.override('identity_domains.delete_auth_token.command_name', 'delete'), help=u"""Delete a user's Auth token.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](deleteAuthToken)""")
@cli_util.option('--auth-token-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--force-delete', type=click.BOOL, help=u"""To force delete the resource and all its references (if any).""")
@cli_util.option('--if-match', help=u"""Used to make the request conditional on an ETag""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_auth_token(ctx, from_json, auth_token_id, authorization, resource_type_schema_version, force_delete, if_match):

    if isinstance(auth_token_id, six.string_types) and len(auth_token_id.strip()) == 0:
        raise click.UsageError('Parameter --auth-token-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if force_delete is not None:
        kwargs['force_delete'] = force_delete
    if if_match is not None:
        kwargs['if_match'] = if_match
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.delete_auth_token(
        auth_token_id=auth_token_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@cloud_gate_group.command(name=cli_util.override('identity_domains.delete_cloud_gate.command_name', 'delete'), help=u"""Delete a Cloud Gate

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](deleteCloudGate)""")
@cli_util.option('--cloud-gate-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--force-delete', type=click.BOOL, help=u"""To force delete the resource and all its references (if any).""")
@cli_util.option('--if-match', help=u"""Used to make the request conditional on an ETag""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_cloud_gate(ctx, from_json, cloud_gate_id, authorization, resource_type_schema_version, force_delete, if_match):

    if isinstance(cloud_gate_id, six.string_types) and len(cloud_gate_id.strip()) == 0:
        raise click.UsageError('Parameter --cloud-gate-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if force_delete is not None:
        kwargs['force_delete'] = force_delete
    if if_match is not None:
        kwargs['if_match'] = if_match
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.delete_cloud_gate(
        cloud_gate_id=cloud_gate_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@cloud_gate_mapping_group.command(name=cli_util.override('identity_domains.delete_cloud_gate_mapping.command_name', 'delete'), help=u"""Delete a Cloud Gate mapping

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](deleteCloudGateMapping)""")
@cli_util.option('--cloud-gate-mapping-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--force-delete', type=click.BOOL, help=u"""To force delete the resource and all its references (if any).""")
@cli_util.option('--if-match', help=u"""Used to make the request conditional on an ETag""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_cloud_gate_mapping(ctx, from_json, cloud_gate_mapping_id, authorization, resource_type_schema_version, force_delete, if_match):

    if isinstance(cloud_gate_mapping_id, six.string_types) and len(cloud_gate_mapping_id.strip()) == 0:
        raise click.UsageError('Parameter --cloud-gate-mapping-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if force_delete is not None:
        kwargs['force_delete'] = force_delete
    if if_match is not None:
        kwargs['if_match'] = if_match
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.delete_cloud_gate_mapping(
        cloud_gate_mapping_id=cloud_gate_mapping_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@cloud_gate_server_group.command(name=cli_util.override('identity_domains.delete_cloud_gate_server.command_name', 'delete'), help=u"""Delete a Cloud Gate server

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](deleteCloudGateServer)""")
@cli_util.option('--cloud-gate-server-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--force-delete', type=click.BOOL, help=u"""To force delete the resource and all its references (if any).""")
@cli_util.option('--if-match', help=u"""Used to make the request conditional on an ETag""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_cloud_gate_server(ctx, from_json, cloud_gate_server_id, authorization, resource_type_schema_version, force_delete, if_match):

    if isinstance(cloud_gate_server_id, six.string_types) and len(cloud_gate_server_id.strip()) == 0:
        raise click.UsageError('Parameter --cloud-gate-server-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if force_delete is not None:
        kwargs['force_delete'] = force_delete
    if if_match is not None:
        kwargs['if_match'] = if_match
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.delete_cloud_gate_server(
        cloud_gate_server_id=cloud_gate_server_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@condition_group.command(name=cli_util.override('identity_domains.delete_condition.command_name', 'delete'), help=u"""Delete a condition.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](deleteCondition)""")
@cli_util.option('--condition-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--force-delete', type=click.BOOL, help=u"""To force delete the resource and all its references (if any).""")
@cli_util.option('--if-match', help=u"""Used to make the request conditional on an ETag""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_condition(ctx, from_json, condition_id, authorization, resource_type_schema_version, force_delete, if_match):

    if isinstance(condition_id, six.string_types) and len(condition_id.strip()) == 0:
        raise click.UsageError('Parameter --condition-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if force_delete is not None:
        kwargs['force_delete'] = force_delete
    if if_match is not None:
        kwargs['if_match'] = if_match
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.delete_condition(
        condition_id=condition_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@customer_secret_key_group.command(name=cli_util.override('identity_domains.delete_customer_secret_key.command_name', 'delete'), help=u"""Delete a user's customer secret key.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](deleteCustomerSecretKey)""")
@cli_util.option('--customer-secret-key-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--force-delete', type=click.BOOL, help=u"""To force delete the resource and all its references (if any).""")
@cli_util.option('--if-match', help=u"""Used to make the request conditional on an ETag""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_customer_secret_key(ctx, from_json, customer_secret_key_id, authorization, resource_type_schema_version, force_delete, if_match):

    if isinstance(customer_secret_key_id, six.string_types) and len(customer_secret_key_id.strip()) == 0:
        raise click.UsageError('Parameter --customer-secret-key-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if force_delete is not None:
        kwargs['force_delete'] = force_delete
    if if_match is not None:
        kwargs['if_match'] = if_match
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.delete_customer_secret_key(
        customer_secret_key_id=customer_secret_key_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@dynamic_resource_group_group.command(name=cli_util.override('identity_domains.delete_dynamic_resource_group.command_name', 'delete'), help=u"""Delete a Dynamic Resource Group.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](deleteDynamicResourceGroup)""")
@cli_util.option('--dynamic-resource-group-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--force-delete', type=click.BOOL, help=u"""To force delete the resource and all its references (if any).""")
@cli_util.option('--if-match', help=u"""Used to make the request conditional on an ETag""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_dynamic_resource_group(ctx, from_json, dynamic_resource_group_id, authorization, resource_type_schema_version, force_delete, if_match):

    if isinstance(dynamic_resource_group_id, six.string_types) and len(dynamic_resource_group_id.strip()) == 0:
        raise click.UsageError('Parameter --dynamic-resource-group-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if force_delete is not None:
        kwargs['force_delete'] = force_delete
    if if_match is not None:
        kwargs['if_match'] = if_match
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.delete_dynamic_resource_group(
        dynamic_resource_group_id=dynamic_resource_group_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@grant_group.command(name=cli_util.override('identity_domains.delete_grant.command_name', 'delete'), help=u"""Remove a Grantee from an AppRole

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](deleteGrant)""")
@cli_util.option('--grant-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--force-delete', type=click.BOOL, help=u"""To force delete the resource and all its references (if any).""")
@cli_util.option('--if-match', help=u"""Used to make the request conditional on an ETag""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_grant(ctx, from_json, grant_id, authorization, resource_type_schema_version, force_delete, if_match):

    if isinstance(grant_id, six.string_types) and len(grant_id.strip()) == 0:
        raise click.UsageError('Parameter --grant-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if force_delete is not None:
        kwargs['force_delete'] = force_delete
    if if_match is not None:
        kwargs['if_match'] = if_match
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.delete_grant(
        grant_id=grant_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@group_group.command(name=cli_util.override('identity_domains.delete_group.command_name', 'delete'), help=u"""Delete a group.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](deleteGroup)""")
@cli_util.option('--group-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--force-delete', type=click.BOOL, help=u"""To force delete the resource and all its references (if any).""")
@cli_util.option('--if-match', help=u"""Used to make the request conditional on an ETag""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_group(ctx, from_json, group_id, authorization, resource_type_schema_version, force_delete, if_match):

    if isinstance(group_id, six.string_types) and len(group_id.strip()) == 0:
        raise click.UsageError('Parameter --group-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if force_delete is not None:
        kwargs['force_delete'] = force_delete
    if if_match is not None:
        kwargs['if_match'] = if_match
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.delete_group(
        group_id=group_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@identity_propagation_trust_group.command(name=cli_util.override('identity_domains.delete_identity_propagation_trust.command_name', 'delete'), help=u"""Delete an existing Identity Propagation Trust configuration.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](deleteIdentityPropagationTrust)""")
@cli_util.option('--identity-propagation-trust-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--force-delete', type=click.BOOL, help=u"""To force delete the resource and all its references (if any).""")
@cli_util.option('--if-match', help=u"""Used to make the request conditional on an ETag""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_identity_propagation_trust(ctx, from_json, identity_propagation_trust_id, authorization, resource_type_schema_version, force_delete, if_match):

    if isinstance(identity_propagation_trust_id, six.string_types) and len(identity_propagation_trust_id.strip()) == 0:
        raise click.UsageError('Parameter --identity-propagation-trust-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if force_delete is not None:
        kwargs['force_delete'] = force_delete
    if if_match is not None:
        kwargs['if_match'] = if_match
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.delete_identity_propagation_trust(
        identity_propagation_trust_id=identity_propagation_trust_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@identity_provider_group.command(name=cli_util.override('identity_domains.delete_identity_provider.command_name', 'delete'), help=u"""Delete an Identity Provider

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](deleteIdentityProvider)""")
@cli_util.option('--identity-provider-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--force-delete', type=click.BOOL, help=u"""To force delete the resource and all its references (if any).""")
@cli_util.option('--if-match', help=u"""Used to make the request conditional on an ETag""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_identity_provider(ctx, from_json, identity_provider_id, authorization, resource_type_schema_version, force_delete, if_match):

    if isinstance(identity_provider_id, six.string_types) and len(identity_provider_id.strip()) == 0:
        raise click.UsageError('Parameter --identity-provider-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if force_delete is not None:
        kwargs['force_delete'] = force_delete
    if if_match is not None:
        kwargs['if_match'] = if_match
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.delete_identity_provider(
        identity_provider_id=identity_provider_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@my_api_key_group.command(name=cli_util.override('identity_domains.delete_my_api_key.command_name', 'delete'), help=u"""Delete a user's own API key.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](deleteMyApiKey)""")
@cli_util.option('--my-api-key-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--force-delete', type=click.BOOL, help=u"""To force delete the resource and all its references (if any).""")
@cli_util.option('--if-match', help=u"""Used to make the request conditional on an ETag""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_my_api_key(ctx, from_json, my_api_key_id, authorization, resource_type_schema_version, force_delete, if_match):

    if isinstance(my_api_key_id, six.string_types) and len(my_api_key_id.strip()) == 0:
        raise click.UsageError('Parameter --my-api-key-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if force_delete is not None:
        kwargs['force_delete'] = force_delete
    if if_match is not None:
        kwargs['if_match'] = if_match
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.delete_my_api_key(
        my_api_key_id=my_api_key_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@my_auth_token_group.command(name=cli_util.override('identity_domains.delete_my_auth_token.command_name', 'delete'), help=u"""Delete a user's own Auth token.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](deleteMyAuthToken)""")
@cli_util.option('--my-auth-token-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--force-delete', type=click.BOOL, help=u"""To force delete the resource and all its references (if any).""")
@cli_util.option('--if-match', help=u"""Used to make the request conditional on an ETag""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_my_auth_token(ctx, from_json, my_auth_token_id, authorization, resource_type_schema_version, force_delete, if_match):

    if isinstance(my_auth_token_id, six.string_types) and len(my_auth_token_id.strip()) == 0:
        raise click.UsageError('Parameter --my-auth-token-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if force_delete is not None:
        kwargs['force_delete'] = force_delete
    if if_match is not None:
        kwargs['if_match'] = if_match
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.delete_my_auth_token(
        my_auth_token_id=my_auth_token_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@my_customer_secret_key_group.command(name=cli_util.override('identity_domains.delete_my_customer_secret_key.command_name', 'delete'), help=u"""Delete a user's own customer secret key.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](deleteMyCustomerSecretKey)""")
@cli_util.option('--my-customer-secret-key-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--force-delete', type=click.BOOL, help=u"""To force delete the resource and all its references (if any).""")
@cli_util.option('--if-match', help=u"""Used to make the request conditional on an ETag""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_my_customer_secret_key(ctx, from_json, my_customer_secret_key_id, authorization, resource_type_schema_version, force_delete, if_match):

    if isinstance(my_customer_secret_key_id, six.string_types) and len(my_customer_secret_key_id.strip()) == 0:
        raise click.UsageError('Parameter --my-customer-secret-key-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if force_delete is not None:
        kwargs['force_delete'] = force_delete
    if if_match is not None:
        kwargs['if_match'] = if_match
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.delete_my_customer_secret_key(
        my_customer_secret_key_id=my_customer_secret_key_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@my_device_group.command(name=cli_util.override('identity_domains.delete_my_device.command_name', 'delete'), help=u"""Delete a Device

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](deleteMyDevice)""")
@cli_util.option('--my-device-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--force-delete', type=click.BOOL, help=u"""To force delete the resource and all its references (if any).""")
@cli_util.option('--if-match', help=u"""Used to make the request conditional on an ETag""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_my_device(ctx, from_json, my_device_id, authorization, resource_type_schema_version, force_delete, if_match):

    if isinstance(my_device_id, six.string_types) and len(my_device_id.strip()) == 0:
        raise click.UsageError('Parameter --my-device-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if force_delete is not None:
        kwargs['force_delete'] = force_delete
    if if_match is not None:
        kwargs['if_match'] = if_match
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.delete_my_device(
        my_device_id=my_device_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@my_o_auth2_client_credential_group.command(name=cli_util.override('identity_domains.delete_my_o_auth2_client_credential.command_name', 'delete'), help=u"""Delete a user's own OAuth2 client credential.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](deleteMyOAuth2ClientCredential)""")
@cli_util.option('--my-o-auth2-client-credential-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--force-delete', type=click.BOOL, help=u"""To force delete the resource and all its references (if any).""")
@cli_util.option('--if-match', help=u"""Used to make the request conditional on an ETag""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_my_o_auth2_client_credential(ctx, from_json, my_o_auth2_client_credential_id, authorization, resource_type_schema_version, force_delete, if_match):

    if isinstance(my_o_auth2_client_credential_id, six.string_types) and len(my_o_auth2_client_credential_id.strip()) == 0:
        raise click.UsageError('Parameter --my-o-auth2-client-credential-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if force_delete is not None:
        kwargs['force_delete'] = force_delete
    if if_match is not None:
        kwargs['if_match'] = if_match
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.delete_my_o_auth2_client_credential(
        my_o_auth2_client_credential_id=my_o_auth2_client_credential_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@my_smtp_credential_group.command(name=cli_util.override('identity_domains.delete_my_smtp_credential.command_name', 'delete'), help=u"""Delete a user's own SMTP credential.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](deleteMySmtpCredential)""")
@cli_util.option('--my-smtp-credential-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--force-delete', type=click.BOOL, help=u"""To force delete the resource and all its references (if any).""")
@cli_util.option('--if-match', help=u"""Used to make the request conditional on an ETag""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_my_smtp_credential(ctx, from_json, my_smtp_credential_id, authorization, resource_type_schema_version, force_delete, if_match):

    if isinstance(my_smtp_credential_id, six.string_types) and len(my_smtp_credential_id.strip()) == 0:
        raise click.UsageError('Parameter --my-smtp-credential-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if force_delete is not None:
        kwargs['force_delete'] = force_delete
    if if_match is not None:
        kwargs['if_match'] = if_match
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.delete_my_smtp_credential(
        my_smtp_credential_id=my_smtp_credential_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@my_support_account_group.command(name=cli_util.override('identity_domains.delete_my_support_account.command_name', 'delete'), help=u"""Delete a user's own support account.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](deleteMySupportAccount)""")
@cli_util.option('--my-support-account-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--force-delete', type=click.BOOL, help=u"""To force delete the resource and all its references (if any).""")
@cli_util.option('--if-match', help=u"""Used to make the request conditional on an ETag""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_my_support_account(ctx, from_json, my_support_account_id, authorization, resource_type_schema_version, force_delete, if_match):

    if isinstance(my_support_account_id, six.string_types) and len(my_support_account_id.strip()) == 0:
        raise click.UsageError('Parameter --my-support-account-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if force_delete is not None:
        kwargs['force_delete'] = force_delete
    if if_match is not None:
        kwargs['if_match'] = if_match
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.delete_my_support_account(
        my_support_account_id=my_support_account_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@my_trusted_user_agent_group.command(name=cli_util.override('identity_domains.delete_my_trusted_user_agent.command_name', 'delete'), help=u"""Delete a Trusted User Agent

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](deleteMyTrustedUserAgent)""")
@cli_util.option('--my-trusted-user-agent-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--force-delete', type=click.BOOL, help=u"""To force delete the resource and all its references (if any).""")
@cli_util.option('--if-match', help=u"""Used to make the request conditional on an ETag""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_my_trusted_user_agent(ctx, from_json, my_trusted_user_agent_id, authorization, resource_type_schema_version, force_delete, if_match):

    if isinstance(my_trusted_user_agent_id, six.string_types) and len(my_trusted_user_agent_id.strip()) == 0:
        raise click.UsageError('Parameter --my-trusted-user-agent-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if force_delete is not None:
        kwargs['force_delete'] = force_delete
    if if_match is not None:
        kwargs['if_match'] = if_match
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.delete_my_trusted_user_agent(
        my_trusted_user_agent_id=my_trusted_user_agent_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@my_user_db_credential_group.command(name=cli_util.override('identity_domains.delete_my_user_db_credential.command_name', 'delete'), help=u"""Delete a user's own database (DB) credential.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](deleteMyUserDbCredential)""")
@cli_util.option('--my-user-db-credential-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--force-delete', type=click.BOOL, help=u"""To force delete the resource and all its references (if any).""")
@cli_util.option('--if-match', help=u"""Used to make the request conditional on an ETag""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_my_user_db_credential(ctx, from_json, my_user_db_credential_id, authorization, resource_type_schema_version, force_delete, if_match):

    if isinstance(my_user_db_credential_id, six.string_types) and len(my_user_db_credential_id.strip()) == 0:
        raise click.UsageError('Parameter --my-user-db-credential-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if force_delete is not None:
        kwargs['force_delete'] = force_delete
    if if_match is not None:
        kwargs['if_match'] = if_match
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.delete_my_user_db_credential(
        my_user_db_credential_id=my_user_db_credential_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@network_perimeter_group.command(name=cli_util.override('identity_domains.delete_network_perimeter.command_name', 'delete'), help=u"""Delete a NetworkPerimeter

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](deleteNetworkPerimeter)""")
@cli_util.option('--network-perimeter-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--force-delete', type=click.BOOL, help=u"""To force delete the resource and all its references (if any).""")
@cli_util.option('--if-match', help=u"""Used to make the request conditional on an ETag""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_network_perimeter(ctx, from_json, network_perimeter_id, authorization, resource_type_schema_version, force_delete, if_match):

    if isinstance(network_perimeter_id, six.string_types) and len(network_perimeter_id.strip()) == 0:
        raise click.UsageError('Parameter --network-perimeter-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if force_delete is not None:
        kwargs['force_delete'] = force_delete
    if if_match is not None:
        kwargs['if_match'] = if_match
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.delete_network_perimeter(
        network_perimeter_id=network_perimeter_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@o_auth2_client_credential_group.command(name=cli_util.override('identity_domains.delete_o_auth2_client_credential.command_name', 'delete'), help=u"""Delete a user's OAuth2 client credentials.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](deleteOAuth2ClientCredential)""")
@cli_util.option('--o-auth2-client-credential-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--force-delete', type=click.BOOL, help=u"""To force delete the resource and all its references (if any).""")
@cli_util.option('--if-match', help=u"""Used to make the request conditional on an ETag""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_o_auth2_client_credential(ctx, from_json, o_auth2_client_credential_id, authorization, resource_type_schema_version, force_delete, if_match):

    if isinstance(o_auth2_client_credential_id, six.string_types) and len(o_auth2_client_credential_id.strip()) == 0:
        raise click.UsageError('Parameter --o-auth2-client-credential-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if force_delete is not None:
        kwargs['force_delete'] = force_delete
    if if_match is not None:
        kwargs['if_match'] = if_match
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.delete_o_auth2_client_credential(
        o_auth2_client_credential_id=o_auth2_client_credential_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@o_auth_client_certificate_group.command(name=cli_util.override('identity_domains.delete_o_auth_client_certificate.command_name', 'delete'), help=u"""Delete an OAuth Client Certificate

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](deleteOAuthClientCertificate)""")
@cli_util.option('--o-auth-client-certificate-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--force-delete', type=click.BOOL, help=u"""To force delete the resource and all its references (if any).""")
@cli_util.option('--if-match', help=u"""Used to make the request conditional on an ETag""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_o_auth_client_certificate(ctx, from_json, o_auth_client_certificate_id, authorization, resource_type_schema_version, force_delete, if_match):

    if isinstance(o_auth_client_certificate_id, six.string_types) and len(o_auth_client_certificate_id.strip()) == 0:
        raise click.UsageError('Parameter --o-auth-client-certificate-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if force_delete is not None:
        kwargs['force_delete'] = force_delete
    if if_match is not None:
        kwargs['if_match'] = if_match
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.delete_o_auth_client_certificate(
        o_auth_client_certificate_id=o_auth_client_certificate_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@o_auth_partner_certificate_group.command(name=cli_util.override('identity_domains.delete_o_auth_partner_certificate.command_name', 'delete'), help=u"""Delete an OAuth Partner Certificate

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](deleteOAuthPartnerCertificate)""")
@cli_util.option('--o-auth-partner-certificate-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--force-delete', type=click.BOOL, help=u"""To force delete the resource and all its references (if any).""")
@cli_util.option('--if-match', help=u"""Used to make the request conditional on an ETag""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_o_auth_partner_certificate(ctx, from_json, o_auth_partner_certificate_id, authorization, resource_type_schema_version, force_delete, if_match):

    if isinstance(o_auth_partner_certificate_id, six.string_types) and len(o_auth_partner_certificate_id.strip()) == 0:
        raise click.UsageError('Parameter --o-auth-partner-certificate-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if force_delete is not None:
        kwargs['force_delete'] = force_delete
    if if_match is not None:
        kwargs['if_match'] = if_match
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.delete_o_auth_partner_certificate(
        o_auth_partner_certificate_id=o_auth_partner_certificate_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@password_policy_group.command(name=cli_util.override('identity_domains.delete_password_policy.command_name', 'delete'), help=u"""Delete a password policy.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](deletePasswordPolicy)""")
@cli_util.option('--password-policy-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--force-delete', type=click.BOOL, help=u"""To force delete the resource and all its references (if any).""")
@cli_util.option('--if-match', help=u"""Used to make the request conditional on an ETag""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_password_policy(ctx, from_json, password_policy_id, authorization, resource_type_schema_version, force_delete, if_match):

    if isinstance(password_policy_id, six.string_types) and len(password_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --password-policy-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if force_delete is not None:
        kwargs['force_delete'] = force_delete
    if if_match is not None:
        kwargs['if_match'] = if_match
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.delete_password_policy(
        password_policy_id=password_policy_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@policy_group.command(name=cli_util.override('identity_domains.delete_policy.command_name', 'delete'), help=u"""Delete a Policy.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](deletePolicy)""")
@cli_util.option('--policy-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--force-delete', type=click.BOOL, help=u"""To force delete the resource and all its references (if any).""")
@cli_util.option('--if-match', help=u"""Used to make the request conditional on an ETag""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_policy(ctx, from_json, policy_id, authorization, resource_type_schema_version, force_delete, if_match):

    if isinstance(policy_id, six.string_types) and len(policy_id.strip()) == 0:
        raise click.UsageError('Parameter --policy-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if force_delete is not None:
        kwargs['force_delete'] = force_delete
    if if_match is not None:
        kwargs['if_match'] = if_match
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.delete_policy(
        policy_id=policy_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@rule_group.command(name=cli_util.override('identity_domains.delete_rule.command_name', 'delete'), help=u"""Delete a Rule.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](deleteRule)""")
@cli_util.option('--rule-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--force-delete', type=click.BOOL, help=u"""To force delete the resource and all its references (if any).""")
@cli_util.option('--if-match', help=u"""Used to make the request conditional on an ETag""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_rule(ctx, from_json, rule_id, authorization, resource_type_schema_version, force_delete, if_match):

    if isinstance(rule_id, six.string_types) and len(rule_id.strip()) == 0:
        raise click.UsageError('Parameter --rule-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if force_delete is not None:
        kwargs['force_delete'] = force_delete
    if if_match is not None:
        kwargs['if_match'] = if_match
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.delete_rule(
        rule_id=rule_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@security_question_group.command(name=cli_util.override('identity_domains.delete_security_question.command_name', 'delete'), help=u"""Delete a security question.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](deleteSecurityQuestion)""")
@cli_util.option('--security-question-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--force-delete', type=click.BOOL, help=u"""To force delete the resource and all its references (if any).""")
@cli_util.option('--if-match', help=u"""Used to make the request conditional on an ETag""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_security_question(ctx, from_json, security_question_id, authorization, resource_type_schema_version, force_delete, if_match):

    if isinstance(security_question_id, six.string_types) and len(security_question_id.strip()) == 0:
        raise click.UsageError('Parameter --security-question-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if force_delete is not None:
        kwargs['force_delete'] = force_delete
    if if_match is not None:
        kwargs['if_match'] = if_match
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.delete_security_question(
        security_question_id=security_question_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@self_registration_profile_group.command(name=cli_util.override('identity_domains.delete_self_registration_profile.command_name', 'delete'), help=u"""Delete a self-registration profile.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](deleteSelfRegistrationProfile)""")
@cli_util.option('--self-registration-profile-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--force-delete', type=click.BOOL, help=u"""To force delete the resource and all its references (if any).""")
@cli_util.option('--if-match', help=u"""Used to make the request conditional on an ETag""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_self_registration_profile(ctx, from_json, self_registration_profile_id, authorization, resource_type_schema_version, force_delete, if_match):

    if isinstance(self_registration_profile_id, six.string_types) and len(self_registration_profile_id.strip()) == 0:
        raise click.UsageError('Parameter --self-registration-profile-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if force_delete is not None:
        kwargs['force_delete'] = force_delete
    if if_match is not None:
        kwargs['if_match'] = if_match
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.delete_self_registration_profile(
        self_registration_profile_id=self_registration_profile_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@smtp_credential_group.command(name=cli_util.override('identity_domains.delete_smtp_credential.command_name', 'delete'), help=u"""Delete a user's SMTP credentials.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](deleteSmtpCredential)""")
@cli_util.option('--smtp-credential-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--force-delete', type=click.BOOL, help=u"""To force delete the resource and all its references (if any).""")
@cli_util.option('--if-match', help=u"""Used to make the request conditional on an ETag""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_smtp_credential(ctx, from_json, smtp_credential_id, authorization, resource_type_schema_version, force_delete, if_match):

    if isinstance(smtp_credential_id, six.string_types) and len(smtp_credential_id.strip()) == 0:
        raise click.UsageError('Parameter --smtp-credential-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if force_delete is not None:
        kwargs['force_delete'] = force_delete
    if if_match is not None:
        kwargs['if_match'] = if_match
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.delete_smtp_credential(
        smtp_credential_id=smtp_credential_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@social_identity_provider_group.command(name=cli_util.override('identity_domains.delete_social_identity_provider.command_name', 'delete'), help=u"""Delete a Social Identity Provider

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](deleteSocialIdentityProvider)""")
@cli_util.option('--social-identity-provider-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--force-delete', type=click.BOOL, help=u"""To force delete the resource and all its references (if any).""")
@cli_util.option('--if-match', help=u"""Used to make the request conditional on an ETag""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_social_identity_provider(ctx, from_json, social_identity_provider_id, authorization, resource_type_schema_version, force_delete, if_match):

    if isinstance(social_identity_provider_id, six.string_types) and len(social_identity_provider_id.strip()) == 0:
        raise click.UsageError('Parameter --social-identity-provider-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if force_delete is not None:
        kwargs['force_delete'] = force_delete
    if if_match is not None:
        kwargs['if_match'] = if_match
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.delete_social_identity_provider(
        social_identity_provider_id=social_identity_provider_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@user_group.command(name=cli_util.override('identity_domains.delete_user.command_name', 'delete'), help=u"""Delete a user.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](deleteUser)""")
@cli_util.option('--user-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--force-delete', type=click.BOOL, help=u"""To force delete the resource and all its references (if any).""")
@cli_util.option('--if-match', help=u"""Used to make the request conditional on an ETag""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_user(ctx, from_json, user_id, authorization, resource_type_schema_version, force_delete, if_match):

    if isinstance(user_id, six.string_types) and len(user_id.strip()) == 0:
        raise click.UsageError('Parameter --user-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if force_delete is not None:
        kwargs['force_delete'] = force_delete
    if if_match is not None:
        kwargs['if_match'] = if_match
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.delete_user(
        user_id=user_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@user_db_credential_group.command(name=cli_util.override('identity_domains.delete_user_db_credential.command_name', 'delete'), help=u"""Delete a user's database (DB) credentials.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](deleteUserDbCredential)""")
@cli_util.option('--user-db-credential-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--force-delete', type=click.BOOL, help=u"""To force delete the resource and all its references (if any).""")
@cli_util.option('--if-match', help=u"""Used to make the request conditional on an ETag""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_user_db_credential(ctx, from_json, user_db_credential_id, authorization, resource_type_schema_version, force_delete, if_match):

    if isinstance(user_db_credential_id, six.string_types) and len(user_db_credential_id.strip()) == 0:
        raise click.UsageError('Parameter --user-db-credential-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if force_delete is not None:
        kwargs['force_delete'] = force_delete
    if if_match is not None:
        kwargs['if_match'] = if_match
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.delete_user_db_credential(
        user_db_credential_id=user_db_credential_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@account_mgmt_info_group.command(name=cli_util.override('identity_domains.get_account_mgmt_info.command_name', 'get'), help=u"""Get Account Mgmt Info

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](getAccountMgmtInfo)""")
@cli_util.option('--account-mgmt-info-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--attributes', help=u"""A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.""")
@cli_util.option('--attribute-sets', type=custom_types.CliCaseInsensitiveChoice(["all", "always", "never", "request", "default"]), multiple=True, help=u"""A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'identity_domains', 'class': 'AccountMgmtInfo'})
@cli_util.wrap_exceptions
def get_account_mgmt_info(ctx, from_json, account_mgmt_info_id, authorization, resource_type_schema_version, attributes, attribute_sets):

    if isinstance(account_mgmt_info_id, six.string_types) and len(account_mgmt_info_id.strip()) == 0:
        raise click.UsageError('Parameter --account-mgmt-info-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if attributes is not None:
        kwargs['attributes'] = attributes
    if attribute_sets is not None and len(attribute_sets) > 0:
        kwargs['attribute_sets'] = attribute_sets
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.get_account_mgmt_info(
        account_mgmt_info_id=account_mgmt_info_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@account_recovery_setting_group.command(name=cli_util.override('identity_domains.get_account_recovery_setting.command_name', 'get'), help=u"""Get an account recovery setting.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](getAccountRecoverySetting)""")
@cli_util.option('--account-recovery-setting-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--attributes', help=u"""A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.""")
@cli_util.option('--attribute-sets', type=custom_types.CliCaseInsensitiveChoice(["all", "always", "never", "request", "default"]), multiple=True, help=u"""A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'identity_domains', 'class': 'AccountRecoverySetting'})
@cli_util.wrap_exceptions
def get_account_recovery_setting(ctx, from_json, account_recovery_setting_id, authorization, resource_type_schema_version, attributes, attribute_sets):

    if isinstance(account_recovery_setting_id, six.string_types) and len(account_recovery_setting_id.strip()) == 0:
        raise click.UsageError('Parameter --account-recovery-setting-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if attributes is not None:
        kwargs['attributes'] = attributes
    if attribute_sets is not None and len(attribute_sets) > 0:
        kwargs['attribute_sets'] = attribute_sets
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.get_account_recovery_setting(
        account_recovery_setting_id=account_recovery_setting_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@api_key_group.command(name=cli_util.override('identity_domains.get_api_key.command_name', 'get'), help=u"""Get a user's API key.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](getApiKey)""")
@cli_util.option('--api-key-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--attributes', help=u"""A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.""")
@cli_util.option('--attribute-sets', type=custom_types.CliCaseInsensitiveChoice(["all", "always", "never", "request", "default"]), multiple=True, help=u"""A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'identity_domains', 'class': 'ApiKey'})
@cli_util.wrap_exceptions
def get_api_key(ctx, from_json, api_key_id, authorization, resource_type_schema_version, attributes, attribute_sets):

    if isinstance(api_key_id, six.string_types) and len(api_key_id.strip()) == 0:
        raise click.UsageError('Parameter --api-key-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if attributes is not None:
        kwargs['attributes'] = attributes
    if attribute_sets is not None and len(attribute_sets) > 0:
        kwargs['attribute_sets'] = attribute_sets
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.get_api_key(
        api_key_id=api_key_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@app_group.command(name=cli_util.override('identity_domains.get_app.command_name', 'get'), help=u"""Get an App

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](getApp)""")
@cli_util.option('--app-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--attributes', help=u"""A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.""")
@cli_util.option('--attribute-sets', type=custom_types.CliCaseInsensitiveChoice(["all", "always", "never", "request", "default"]), multiple=True, help=u"""A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'identity_domains', 'class': 'App'})
@cli_util.wrap_exceptions
def get_app(ctx, from_json, app_id, authorization, resource_type_schema_version, attributes, attribute_sets):

    if isinstance(app_id, six.string_types) and len(app_id.strip()) == 0:
        raise click.UsageError('Parameter --app-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if attributes is not None:
        kwargs['attributes'] = attributes
    if attribute_sets is not None and len(attribute_sets) > 0:
        kwargs['attribute_sets'] = attribute_sets
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.get_app(
        app_id=app_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@app_role_group.command(name=cli_util.override('identity_domains.get_app_role.command_name', 'get'), help=u"""Get an AppRole

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](getAppRole)""")
@cli_util.option('--app-role-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--attributes', help=u"""A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.""")
@cli_util.option('--attribute-sets', type=custom_types.CliCaseInsensitiveChoice(["all", "always", "never", "request", "default"]), multiple=True, help=u"""A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'identity_domains', 'class': 'AppRole'})
@cli_util.wrap_exceptions
def get_app_role(ctx, from_json, app_role_id, authorization, resource_type_schema_version, attributes, attribute_sets):

    if isinstance(app_role_id, six.string_types) and len(app_role_id.strip()) == 0:
        raise click.UsageError('Parameter --app-role-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if attributes is not None:
        kwargs['attributes'] = attributes
    if attribute_sets is not None and len(attribute_sets) > 0:
        kwargs['attribute_sets'] = attribute_sets
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.get_app_role(
        app_role_id=app_role_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@approval_workflow_group.command(name=cli_util.override('identity_domains.get_approval_workflow.command_name', 'get'), help=u"""Get ApprovalWorkflow

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](getApprovalWorkflow)""")
@cli_util.option('--approval-workflow-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--attributes', help=u"""A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.""")
@cli_util.option('--attribute-sets', type=custom_types.CliCaseInsensitiveChoice(["all", "always", "never", "request", "default"]), multiple=True, help=u"""A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'identity_domains', 'class': 'ApprovalWorkflow'})
@cli_util.wrap_exceptions
def get_approval_workflow(ctx, from_json, approval_workflow_id, authorization, resource_type_schema_version, attributes, attribute_sets):

    if isinstance(approval_workflow_id, six.string_types) and len(approval_workflow_id.strip()) == 0:
        raise click.UsageError('Parameter --approval-workflow-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if attributes is not None:
        kwargs['attributes'] = attributes
    if attribute_sets is not None and len(attribute_sets) > 0:
        kwargs['attribute_sets'] = attribute_sets
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.get_approval_workflow(
        approval_workflow_id=approval_workflow_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@approval_workflow_assignment_group.command(name=cli_util.override('identity_domains.get_approval_workflow_assignment.command_name', 'get'), help=u"""Get an Approval Workflow Assignment

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](getApprovalWorkflowAssignment)""")
@cli_util.option('--approval-workflow-assignment-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--attributes', help=u"""A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.""")
@cli_util.option('--attribute-sets', type=custom_types.CliCaseInsensitiveChoice(["all", "always", "never", "request", "default"]), multiple=True, help=u"""A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'identity_domains', 'class': 'ApprovalWorkflowAssignment'})
@cli_util.wrap_exceptions
def get_approval_workflow_assignment(ctx, from_json, approval_workflow_assignment_id, authorization, resource_type_schema_version, attributes, attribute_sets):

    if isinstance(approval_workflow_assignment_id, six.string_types) and len(approval_workflow_assignment_id.strip()) == 0:
        raise click.UsageError('Parameter --approval-workflow-assignment-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if attributes is not None:
        kwargs['attributes'] = attributes
    if attribute_sets is not None and len(attribute_sets) > 0:
        kwargs['attribute_sets'] = attribute_sets
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.get_approval_workflow_assignment(
        approval_workflow_assignment_id=approval_workflow_assignment_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@approval_workflow_step_group.command(name=cli_util.override('identity_domains.get_approval_workflow_step.command_name', 'get'), help=u"""Get ApprovalWorkflowStep

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](getApprovalWorkflowStep)""")
@cli_util.option('--approval-workflow-step-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--attributes', help=u"""A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.""")
@cli_util.option('--attribute-sets', type=custom_types.CliCaseInsensitiveChoice(["all", "always", "never", "request", "default"]), multiple=True, help=u"""A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'identity_domains', 'class': 'ApprovalWorkflowStep'})
@cli_util.wrap_exceptions
def get_approval_workflow_step(ctx, from_json, approval_workflow_step_id, authorization, resource_type_schema_version, attributes, attribute_sets):

    if isinstance(approval_workflow_step_id, six.string_types) and len(approval_workflow_step_id.strip()) == 0:
        raise click.UsageError('Parameter --approval-workflow-step-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if attributes is not None:
        kwargs['attributes'] = attributes
    if attribute_sets is not None and len(attribute_sets) > 0:
        kwargs['attribute_sets'] = attribute_sets
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.get_approval_workflow_step(
        approval_workflow_step_id=approval_workflow_step_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@auth_token_group.command(name=cli_util.override('identity_domains.get_auth_token.command_name', 'get'), help=u"""Get a user's Auth token.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](getAuthToken)""")
@cli_util.option('--auth-token-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--attributes', help=u"""A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.""")
@cli_util.option('--attribute-sets', type=custom_types.CliCaseInsensitiveChoice(["all", "always", "never", "request", "default"]), multiple=True, help=u"""A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'identity_domains', 'class': 'AuthToken'})
@cli_util.wrap_exceptions
def get_auth_token(ctx, from_json, auth_token_id, authorization, resource_type_schema_version, attributes, attribute_sets):

    if isinstance(auth_token_id, six.string_types) and len(auth_token_id.strip()) == 0:
        raise click.UsageError('Parameter --auth-token-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if attributes is not None:
        kwargs['attributes'] = attributes
    if attribute_sets is not None and len(attribute_sets) > 0:
        kwargs['attribute_sets'] = attribute_sets
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.get_auth_token(
        auth_token_id=auth_token_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@authentication_factor_setting_group.command(name=cli_util.override('identity_domains.get_authentication_factor_setting.command_name', 'get'), help=u"""Get Authentication Factor Settings

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](getAuthenticationFactorSetting)""")
@cli_util.option('--authentication-factor-setting-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--attributes', help=u"""A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.""")
@cli_util.option('--attribute-sets', type=custom_types.CliCaseInsensitiveChoice(["all", "always", "never", "request", "default"]), multiple=True, help=u"""A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'identity_domains', 'class': 'AuthenticationFactorSetting'})
@cli_util.wrap_exceptions
def get_authentication_factor_setting(ctx, from_json, authentication_factor_setting_id, authorization, resource_type_schema_version, attributes, attribute_sets):

    if isinstance(authentication_factor_setting_id, six.string_types) and len(authentication_factor_setting_id.strip()) == 0:
        raise click.UsageError('Parameter --authentication-factor-setting-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if attributes is not None:
        kwargs['attributes'] = attributes
    if attribute_sets is not None and len(attribute_sets) > 0:
        kwargs['attribute_sets'] = attribute_sets
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.get_authentication_factor_setting(
        authentication_factor_setting_id=authentication_factor_setting_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@branding_setting_group.command(name=cli_util.override('identity_domains.get_branding_setting.command_name', 'get'), help=u"""Get Branding Settings

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](getBrandingSetting)""")
@cli_util.option('--branding-setting-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--attributes', help=u"""A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.""")
@cli_util.option('--attribute-sets', type=custom_types.CliCaseInsensitiveChoice(["all", "always", "never", "request", "default"]), multiple=True, help=u"""A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'identity_domains', 'class': 'BrandingSetting'})
@cli_util.wrap_exceptions
def get_branding_setting(ctx, from_json, branding_setting_id, authorization, resource_type_schema_version, attributes, attribute_sets):

    if isinstance(branding_setting_id, six.string_types) and len(branding_setting_id.strip()) == 0:
        raise click.UsageError('Parameter --branding-setting-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if attributes is not None:
        kwargs['attributes'] = attributes
    if attribute_sets is not None and len(attribute_sets) > 0:
        kwargs['attribute_sets'] = attribute_sets
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.get_branding_setting(
        branding_setting_id=branding_setting_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@cloud_gate_group.command(name=cli_util.override('identity_domains.get_cloud_gate.command_name', 'get'), help=u"""Get a Cloud Gate

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](getCloudGate)""")
@cli_util.option('--cloud-gate-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--attributes', help=u"""A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.""")
@cli_util.option('--attribute-sets', type=custom_types.CliCaseInsensitiveChoice(["all", "always", "never", "request", "default"]), multiple=True, help=u"""A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'identity_domains', 'class': 'CloudGate'})
@cli_util.wrap_exceptions
def get_cloud_gate(ctx, from_json, cloud_gate_id, authorization, resource_type_schema_version, attributes, attribute_sets):

    if isinstance(cloud_gate_id, six.string_types) and len(cloud_gate_id.strip()) == 0:
        raise click.UsageError('Parameter --cloud-gate-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if attributes is not None:
        kwargs['attributes'] = attributes
    if attribute_sets is not None and len(attribute_sets) > 0:
        kwargs['attribute_sets'] = attribute_sets
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.get_cloud_gate(
        cloud_gate_id=cloud_gate_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@cloud_gate_mapping_group.command(name=cli_util.override('identity_domains.get_cloud_gate_mapping.command_name', 'get'), help=u"""Get a Cloud Gate mapping

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](getCloudGateMapping)""")
@cli_util.option('--cloud-gate-mapping-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--attributes', help=u"""A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.""")
@cli_util.option('--attribute-sets', type=custom_types.CliCaseInsensitiveChoice(["all", "always", "never", "request", "default"]), multiple=True, help=u"""A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'identity_domains', 'class': 'CloudGateMapping'})
@cli_util.wrap_exceptions
def get_cloud_gate_mapping(ctx, from_json, cloud_gate_mapping_id, authorization, resource_type_schema_version, attributes, attribute_sets):

    if isinstance(cloud_gate_mapping_id, six.string_types) and len(cloud_gate_mapping_id.strip()) == 0:
        raise click.UsageError('Parameter --cloud-gate-mapping-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if attributes is not None:
        kwargs['attributes'] = attributes
    if attribute_sets is not None and len(attribute_sets) > 0:
        kwargs['attribute_sets'] = attribute_sets
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.get_cloud_gate_mapping(
        cloud_gate_mapping_id=cloud_gate_mapping_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@cloud_gate_server_group.command(name=cli_util.override('identity_domains.get_cloud_gate_server.command_name', 'get'), help=u"""Get a Cloud Gate server

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](getCloudGateServer)""")
@cli_util.option('--cloud-gate-server-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--attributes', help=u"""A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.""")
@cli_util.option('--attribute-sets', type=custom_types.CliCaseInsensitiveChoice(["all", "always", "never", "request", "default"]), multiple=True, help=u"""A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'identity_domains', 'class': 'CloudGateServer'})
@cli_util.wrap_exceptions
def get_cloud_gate_server(ctx, from_json, cloud_gate_server_id, authorization, resource_type_schema_version, attributes, attribute_sets):

    if isinstance(cloud_gate_server_id, six.string_types) and len(cloud_gate_server_id.strip()) == 0:
        raise click.UsageError('Parameter --cloud-gate-server-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if attributes is not None:
        kwargs['attributes'] = attributes
    if attribute_sets is not None and len(attribute_sets) > 0:
        kwargs['attribute_sets'] = attribute_sets
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.get_cloud_gate_server(
        cloud_gate_server_id=cloud_gate_server_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@condition_group.command(name=cli_util.override('identity_domains.get_condition.command_name', 'get'), help=u"""Get a condition.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](getCondition)""")
@cli_util.option('--condition-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--attributes', help=u"""A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.""")
@cli_util.option('--attribute-sets', type=custom_types.CliCaseInsensitiveChoice(["all", "always", "never", "request", "default"]), multiple=True, help=u"""A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'identity_domains', 'class': 'Condition'})
@cli_util.wrap_exceptions
def get_condition(ctx, from_json, condition_id, authorization, resource_type_schema_version, attributes, attribute_sets):

    if isinstance(condition_id, six.string_types) and len(condition_id.strip()) == 0:
        raise click.UsageError('Parameter --condition-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if attributes is not None:
        kwargs['attributes'] = attributes
    if attribute_sets is not None and len(attribute_sets) > 0:
        kwargs['attribute_sets'] = attribute_sets
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.get_condition(
        condition_id=condition_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@customer_secret_key_group.command(name=cli_util.override('identity_domains.get_customer_secret_key.command_name', 'get'), help=u"""Get a user's customer secret key.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](getCustomerSecretKey)""")
@cli_util.option('--customer-secret-key-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--attributes', help=u"""A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.""")
@cli_util.option('--attribute-sets', type=custom_types.CliCaseInsensitiveChoice(["all", "always", "never", "request", "default"]), multiple=True, help=u"""A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'identity_domains', 'class': 'CustomerSecretKey'})
@cli_util.wrap_exceptions
def get_customer_secret_key(ctx, from_json, customer_secret_key_id, authorization, resource_type_schema_version, attributes, attribute_sets):

    if isinstance(customer_secret_key_id, six.string_types) and len(customer_secret_key_id.strip()) == 0:
        raise click.UsageError('Parameter --customer-secret-key-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if attributes is not None:
        kwargs['attributes'] = attributes
    if attribute_sets is not None and len(attribute_sets) > 0:
        kwargs['attribute_sets'] = attribute_sets
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.get_customer_secret_key(
        customer_secret_key_id=customer_secret_key_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@dynamic_resource_group_group.command(name=cli_util.override('identity_domains.get_dynamic_resource_group.command_name', 'get'), help=u"""Get a Dynamic Resource Group.

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](getDynamicResourceGroup)""")
@cli_util.option('--dynamic-resource-group-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--attributes', help=u"""A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.""")
@cli_util.option('--attribute-sets', type=custom_types.CliCaseInsensitiveChoice(["all", "always", "never", "request", "default"]), multiple=True, help=u"""A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'identity_domains', 'class': 'DynamicResourceGroup'})
@cli_util.wrap_exceptions
def get_dynamic_resource_group(ctx, from_json, dynamic_resource_group_id, authorization, resource_type_schema_version, attributes, attribute_sets):

    if isinstance(dynamic_resource_group_id, six.string_types) and len(dynamic_resource_group_id.strip()) == 0:
        raise click.UsageError('Parameter --dynamic-resource-group-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if attributes is not None:
        kwargs['attributes'] = attributes
    if attribute_sets is not None and len(attribute_sets) > 0:
        kwargs['attribute_sets'] = attribute_sets
    client = cli_util.build_client('identity_domains', 'identity_domains', ctx)
    result = client.get_dynamic_resource_group(
        dynamic_resource_group_id=dynamic_resource_group_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@grant_group.command(name=cli_util.override('identity_domains.get_grant.command_name', 'get'), help=u"""Get a Grant

The top level --endpoint parameter must be supplied for this operation. \n[Command Reference](getGrant)""")
@cli_util.option('--grant-id', required=True, help=u"""ID of the resource""")
@cli_util.option('--authorization', help=u"""The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.""")
@cli_util.option('--resource-type-schema-version', help=u"""An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.""")
@cli_util.option('--attributes', help=u"""A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.""")
@cli_util.option('--attribute-sets', type=custom_types.CliCaseInsensitiveChoice(["all", "always", "never", "request", "default"]), multiple=True, help=u"""A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'identity_domains', 'class': 'Grant'})
@cli_util.wrap_exceptions
def get_grant(ctx, from_json, grant_id, authorization, resource_type_schema_version, attributes, attribute_sets):

    if isinstance(grant_id, six.string_types) and len(grant_id.strip()) == 0:
        raise click.UsageError('Parameter --grant-id cannot be whitespace or empty string')

    kwargs = {}
    if authorization is not None:
        kwargs['authorization'] = authorization
    if resource_type_schema_version is not None:
        kwargs['resource_type_schema_version'] = resource_type_schema_version
    if attributes is not None:
        kwargs['attributes'] = attributes
    if attribute_sets is not None and len(attribute_sets) > 0:
        kwargs['attribute_sets'] = attribute_sets
  