# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 0.0.1

from __future__ import print_function
import click
import oci  # noqa: F401
import six  # noqa: F401
import sys  # noqa: F401
from oci_cli import cli_constants  # noqa: F401
from oci_cli import cli_util
from oci_cli import json_skeleton_utils
from oci_cli import custom_types  # noqa: F401
from oci_cli.aliasing import CommandGroupWithAlias
from services.announcements_service.src.oci_cli_announcements_service.generated import announce_service_cli


@click.command(cli_util.override('service.service_root_group.command_name', 'service'), cls=CommandGroupWithAlias, help=cli_util.override('service.service_root_group.help', """Manage Oracle Cloud Infrastructure console announcements."""), short_help=cli_util.override('service.service_root_group.short_help', """Announcements Service API"""))
@cli_util.help_option_group
def service_root_group():
    pass


@click.command(cli_util.override('service.service_group.command_name', 'service'), cls=CommandGroupWithAlias, help="""Summary of the service object.""")
@cli_util.help_option_group
def service_group():
    pass


announce_service_cli.announce_service_group.add_command(service_root_group)
service_root_group.add_command(service_group)


@service_group.command(name=cli_util.override('service.list_services.command_name', 'list'), help=u"""List all active services \n[Command Reference](listServices)""")
@cli_util.option('--compartment-id', required=True, help=u"""The OCID of the compartment.""")
@cli_util.option('--platform-type', type=custom_types.CliCaseInsensitiveChoice(["IAAS", "SAAS", "PAAS"]), help=u"""A filter to return only announcements affecting a specific platform.""")
@cli_util.option('--comms-manager-name', type=custom_types.CliCaseInsensitiveChoice(["CN", "FUSION", "AS", "ERF"]), help=u"""Filter by comms manager name""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return in a paginated \"List\" call.""")
@cli_util.option('--page', help=u"""The value of the `opc-next-page` response header from the previous \"List\" call.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["serviceName"]), help=u"""Sort by service name parameter""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, whether ascending ('ASC') or descending ('DESC').""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'announcements_service', 'class': 'ServicesCollection'})
@cli_util.wrap_exceptions
def list_services(ctx, from_json, all_pages, page_size, compartment_id, platform_type, comms_manager_name, limit, page, sort_by, sort_order):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if platform_type is not None:
        kwargs['platform_type'] = platform_type
    if comms_manager_name is not None:
        kwargs['comms_manager_name'] = comms_manager_name
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('announcements_service', 'service', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_services,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_services,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_services(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)
