# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241031

from __future__ import print_function
import click
import oci  # noqa: F401
import six  # noqa: F401
import sys  # noqa: F401
from oci_cli import cli_constants  # noqa: F401
from oci_cli import cli_util
from oci_cli import json_skeleton_utils
from oci_cli import custom_types  # noqa: F401
from oci_cli.aliasing import CommandGroupWithAlias
from services.resource_analytics.src.oci_cli_resource_analytics.generated import resource_analytics_service_cli


@click.command(cli_util.override('monitored_region.monitored_region_root_group.command_name', 'monitored-region'), cls=CommandGroupWithAlias, help=cli_util.override('monitored_region.monitored_region_root_group.help', """Use the Resource Analytics API to manage Resource Analytics Instances."""), short_help=cli_util.override('monitored_region.monitored_region_root_group.short_help', """Resource Analytics API"""))
@cli_util.help_option_group
def monitored_region_root_group():
    pass


@click.command(cli_util.override('monitored_region.monitored_region_collection_group.command_name', 'monitored-region-collection'), cls=CommandGroupWithAlias, help="""Results of a MonitoredRegion search. Contains both MonitoredRegionSummary items and other information, such as metadata.""")
@cli_util.help_option_group
def monitored_region_collection_group():
    pass


@click.command(cli_util.override('monitored_region.monitored_region_group.command_name', 'monitored-region'), cls=CommandGroupWithAlias, help="""A MonitoredRegion is a region to collect data for the associated ResourceAnalyticsInstance.

To use any of the API operations, you must be authorized in an IAM policy. If you're not authorized, talk to an administrator. If you're an administrator who needs to write policies to give users access, see [Getting Started with Policies].""")
@cli_util.help_option_group
def monitored_region_group():
    pass


resource_analytics_service_cli.resource_analytics_service_group.add_command(monitored_region_root_group)
monitored_region_root_group.add_command(monitored_region_collection_group)
monitored_region_root_group.add_command(monitored_region_group)


@monitored_region_group.command(name=cli_util.override('monitored_region.create_monitored_region.command_name', 'create'), help=u"""Creates a MonitoredRegion. \n[Command Reference](createMonitoredRegion)""")
@cli_util.option('--resource-analytics-instance-id', required=True, help=u"""The [OCID] of the ResourceAnalyticsInstance associated with this MonitoredRegion.""")
@cli_util.option('--region-id', required=True, help=u"""The [Region Identifier] of this MonitoredRegion.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'resource_analytics', 'class': 'MonitoredRegion'})
@cli_util.wrap_exceptions
def create_monitored_region(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, resource_analytics_instance_id, region_id):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['resourceAnalyticsInstanceId'] = resource_analytics_instance_id
    _details['regionId'] = region_id

    client = cli_util.build_client('resource_analytics', 'monitored_region', ctx)
    result = client.create_monitored_region(
        create_monitored_region_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@monitored_region_group.command(name=cli_util.override('monitored_region.delete_monitored_region.command_name', 'delete'), help=u"""Deletes a MonitoredRegion. \n[Command Reference](deleteMonitoredRegion)""")
@cli_util.option('--monitored-region-id', required=True, help=u"""The [OCID] of the MonitoredRegion.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_monitored_region(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, monitored_region_id, if_match):

    if isinstance(monitored_region_id, six.string_types) and len(monitored_region_id.strip()) == 0:
        raise click.UsageError('Parameter --monitored-region-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('resource_analytics', 'monitored_region', ctx)
    result = client.delete_monitored_region(
        monitored_region_id=monitored_region_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Please retrieve the work request to find its current state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@monitored_region_group.command(name=cli_util.override('monitored_region.get_monitored_region.command_name', 'get'), help=u"""Gets information about a MonitoredRegion. \n[Command Reference](getMonitoredRegion)""")
@cli_util.option('--monitored-region-id', required=True, help=u"""The [OCID] of the MonitoredRegion.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'resource_analytics', 'class': 'MonitoredRegion'})
@cli_util.wrap_exceptions
def get_monitored_region(ctx, from_json, monitored_region_id):

    if isinstance(monitored_region_id, six.string_types) and len(monitored_region_id.strip()) == 0:
        raise click.UsageError('Parameter --monitored-region-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('resource_analytics', 'monitored_region', ctx)
    result = client.get_monitored_region(
        monitored_region_id=monitored_region_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@monitored_region_collection_group.command(name=cli_util.override('monitored_region.list_monitored_regions.command_name', 'list'), help=u"""Gets a list of MonitoredRegions. \n[Command Reference](listMonitoredRegions)""")
@cli_util.option('--resource-analytics-instance-id', help=u"""The [OCID] of a ResourceAnalyticsInstance.""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]), help=u"""A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.""")
@cli_util.option('--id', help=u"""The [OCID] of the MonitoredRegion.""")
@cli_util.option('--limit', type=click.INT, help=u"""For list pagination. The maximum number of results per page, or items to return in a paginated \"List\" call. For important details about how pagination works, see [List Pagination].""")
@cli_util.option('--page', help=u"""For list pagination. The value of the opc-next-page response header from the previous \"List\" call. For important details about how pagination works, see [List Pagination].""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either ascending (`ASC`) or descending (`DESC`).""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["TIME_CREATED", "REGION_ID"]), help=u"""The field to sort by. You can provide only one sort order. Default order for `TIME_CREATED` is descending. Default order for `REGION_ID` is ascending.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'resource_analytics', 'class': 'MonitoredRegionCollection'})
@cli_util.wrap_exceptions
def list_monitored_regions(ctx, from_json, all_pages, page_size, resource_analytics_instance_id, lifecycle_state, id, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if resource_analytics_instance_id is not None:
        kwargs['resource_analytics_instance_id'] = resource_analytics_instance_id
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    if id is not None:
        kwargs['id'] = id
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('resource_analytics', 'monitored_region', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_monitored_regions,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_monitored_regions,
            limit,
            page_size,
            **kwargs
        )
    else:
        result = client.list_monitored_regions(
            **kwargs
        )
    cli_util.render_response(result, ctx)
