# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220315

from __future__ import print_function
import click
import oci  # noqa: F401
import six  # noqa: F401
import sys  # noqa: F401
from oci_cli import cli_constants  # noqa: F401
from oci_cli import cli_util
from oci_cli import json_skeleton_utils
from oci_cli import custom_types  # noqa: F401
from oci_cli.aliasing import CommandGroupWithAlias
from services.redis.src.oci_cli_redis.generated import redis_service_cli


@click.command(cli_util.override('redis_identity.redis_identity_root_group.command_name', 'redis-identity'), cls=CommandGroupWithAlias, help=cli_util.override('redis_identity.redis_identity_root_group.help', """Use the OCI Cache API to create and manage clusters. A cluster is a memory-based storage solution. For more information, see [OCI Cache]."""), short_help=cli_util.override('redis_identity.redis_identity_root_group.short_help', """OCI Cache API"""))
@cli_util.help_option_group
def redis_identity_root_group():
    pass


@click.command(cli_util.override('redis_identity.create_identity_token_details_group.command_name', 'create-identity-token-details'), cls=CommandGroupWithAlias, help="""Generate an Identity token for Redis cluster""")
@cli_util.help_option_group
def create_identity_token_details_group():
    pass


redis_service_cli.redis_service_group.add_command(redis_identity_root_group)
redis_identity_root_group.add_command(create_identity_token_details_group)


@create_identity_token_details_group.command(name=cli_util.override('redis_identity.create_identity_token.command_name', 'create-identity-token'), help=u"""Generates an identity token to sign in with the specified redis user for the redis cluster \n[Command Reference](createIdentityToken)""")
@cli_util.option('--public-key', required=True, help=u"""User public key pair""")
@cli_util.option('--redis-user', required=True, help=u"""Redis User generating identity token.""")
@cli_util.option('--redis-cluster-id', required=True, help=u"""The [OCID] of the cluster.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'redis', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'redis', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'redis', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'redis', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'redis', 'class': 'IdentityTokenDetailsResponse'})
@cli_util.wrap_exceptions
def create_identity_token(ctx, from_json, public_key, redis_user, redis_cluster_id, freeform_tags, defined_tags, if_match):

    if isinstance(redis_cluster_id, six.string_types) and len(redis_cluster_id.strip()) == 0:
        raise click.UsageError('Parameter --redis-cluster-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['publicKey'] = public_key
    _details['redisUser'] = redis_user

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('redis', 'redis_identity', ctx)
    result = client.create_identity_token(
        redis_cluster_id=redis_cluster_id,
        create_identity_token_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)
