# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531

from __future__ import print_function
import click
import oci  # noqa: F401
import six  # noqa: F401
import sys  # noqa: F401
from oci_cli.cli_root import cli
from oci_cli import cli_constants  # noqa: F401
from oci_cli import cli_util
from oci_cli import json_skeleton_utils
from oci_cli import custom_types  # noqa: F401
from oci_cli.aliasing import CommandGroupWithAlias


@cli.command(cli_util.override('generative_ai_agent_runtime.generative_ai_agent_runtime_root_group.command_name', 'generative-ai-agent-runtime'), cls=CommandGroupWithAlias, help=cli_util.override('generative_ai_agent_runtime.generative_ai_agent_runtime_root_group.help', """OCI Generative AI Agents is a fully managed service that combines the power of large language models (LLMs) with an intelligent retrieval system to create contextually relevant answers by searching your knowledge base, making your AI applications smart and efficient.

OCI Generative AI Agents supports several ways to onboard your data and then allows you and your customers to interact with your data using a chat interface or API.

Use the Generative AI Agents Client API to create and manage client chat sessions. A session represents an interactive conversation initiated by a user through an API to engage with an agent. It involves a series of exchanges where the user sends queries or prompts, and the agent responds with relevant information, actions, or assistance based on the user's input. The session persists for the duration of the interaction, maintaining context and continuity to provide coherent and meaningful responses throughout the conversation.

For creating and managing agents, knowledge bases, data sources, endpoints, and data ingestion jobs see the [Generative AI Agents Management API].

To learn more about the service, see the [Generative AI Agents documentation]."""), short_help=cli_util.override('generative_ai_agent_runtime.generative_ai_agent_runtime_root_group.short_help', """Generative AI Agents Client API"""))
@cli_util.help_option_group
def generative_ai_agent_runtime_root_group():
    pass


@click.command(cli_util.override('generative_ai_agent_runtime.knowledge_base_metadata_summary_group.command_name', 'knowledge-base-metadata-summary'), cls=CommandGroupWithAlias, help="""Represents metadata about a field including its name, type, supported operations, and possible values.""")
@cli_util.help_option_group
def knowledge_base_metadata_summary_group():
    pass


@click.command(cli_util.override('generative_ai_agent_runtime.session_group.command_name', 'session'), cls=CommandGroupWithAlias, help="""A session represents an interactive conversation initiated by a user through an API to engage with an agent. It involves a series of exchanges where the user sends queries or prompts, and the agent responds with relevant information, actions, or assistance based on the user's input. The session persists for the duration of the interaction, maintaining context and continuity to provide coherent and meaningful responses throughout the conversation.""")
@cli_util.help_option_group
def session_group():
    pass


@click.command(cli_util.override('generative_ai_agent_runtime.agent_endpoint_group.command_name', 'agent-endpoint'), cls=CommandGroupWithAlias, help="""""")
@cli_util.help_option_group
def agent_endpoint_group():
    pass


generative_ai_agent_runtime_root_group.add_command(knowledge_base_metadata_summary_group)
generative_ai_agent_runtime_root_group.add_command(session_group)
generative_ai_agent_runtime_root_group.add_command(agent_endpoint_group)


@agent_endpoint_group.command(name=cli_util.override('generative_ai_agent_runtime.chat.command_name', 'chat'), help=u"""Chat on endpoint with provided messages. \n[Command Reference](chat)""")
@cli_util.option('--agent-endpoint-id', required=True, help=u"""A unique ID for the endpoint.""")
@cli_util.option('--user-message', help=u"""The input user message content for the chat.""")
@cli_util.option('--should-stream', type=click.BOOL, help=u"""Whether to stream the response.""")
@cli_util.option('--session-id', help=u"""Optional sessionId. If not provided, will chat without any prior context.""")
@cli_util.option('--tool-parameters', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A map where each key is a toolId and the value contains tool type and additional dynamic parameters. This field is deprecated and will be removed after July 02 2026.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--tool-inputs', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Array of tool input objects, each specifying a tool's ID, type, and corresponding input parameters required for execution.

This option is a JSON list with items of type ToolInput.  For documentation on ToolInput please see our API reference: https://docs.cloud.oracle.com/api/#/en/generativeaiagentruntime/20240531/datatypes/ToolInput.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--performed-actions', type=custom_types.CLI_COMPLEX_TYPE, help=u"""A list of actions that have been performed based on prior required actions.

This option is a JSON list with items of type PerformedAction.  For documentation on PerformedAction please see our API reference: https://docs.cloud.oracle.com/api/#/en/generativeaiagentruntime/20240531/datatypes/PerformedAction.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@json_skeleton_utils.get_cli_json_input_option({'tool-parameters': {'module': 'generative_ai_agent_runtime', 'class': 'dict(str, string)'}, 'tool-inputs': {'module': 'generative_ai_agent_runtime', 'class': 'list[ToolInput]'}, 'performed-actions': {'module': 'generative_ai_agent_runtime', 'class': 'list[PerformedAction]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'tool-parameters': {'module': 'generative_ai_agent_runtime', 'class': 'dict(str, string)'}, 'tool-inputs': {'module': 'generative_ai_agent_runtime', 'class': 'list[ToolInput]'}, 'performed-actions': {'module': 'generative_ai_agent_runtime', 'class': 'list[PerformedAction]'}}, output_type={'module': 'generative_ai_agent_runtime', 'class': 'ChatResult'})
@cli_util.wrap_exceptions
def chat(ctx, from_json, agent_endpoint_id, user_message, should_stream, session_id, tool_parameters, tool_inputs, performed_actions, if_match):

    if isinstance(agent_endpoint_id, six.string_types) and len(agent_endpoint_id.strip()) == 0:
        raise click.UsageError('Parameter --agent-endpoint-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if user_message is not None:
        _details['userMessage'] = user_message

    if should_stream is not None:
        _details['shouldStream'] = should_stream

    if session_id is not None:
        _details['sessionId'] = session_id

    if tool_parameters is not None:
        _details['toolParameters'] = cli_util.parse_json_parameter("tool_parameters", tool_parameters)

    if tool_inputs is not None:
        _details['toolInputs'] = cli_util.parse_json_parameter("tool_inputs", tool_inputs)

    if performed_actions is not None:
        _details['performedActions'] = cli_util.parse_json_parameter("performed_actions", performed_actions)

    client = cli_util.build_client('generative_ai_agent_runtime', 'generative_ai_agent_runtime', ctx)
    result = client.chat(
        agent_endpoint_id=agent_endpoint_id,
        chat_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@session_group.command(name=cli_util.override('generative_ai_agent_runtime.create_session.command_name', 'create'), help=u"""A session represents an interactive conversation initiated by a user through an API to engage with an  agent. It involves a series of exchanges where the user sends queries or prompts, and the agent responds with relevant information, actions, or assistance based on the user's input. The session persists for the duration of the interaction, maintaining context and continuity to provide coherent and meaningful responses throughout the conversation.Creates an agent session.

Use this API to create an agent session. \n[Command Reference](createSession)""")
@cli_util.option('--agent-endpoint-id', required=True, help=u"""A unique ID for the endpoint.""")
@cli_util.option('--display-name', help=u"""The name of the session. A session names doesn't have to be unique and you can change the session name later.""")
@cli_util.option('--description', help=u"""An optional description of the session.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'generative_ai_agent_runtime', 'class': 'Session'})
@cli_util.wrap_exceptions
def create_session(ctx, from_json, agent_endpoint_id, display_name, description):

    if isinstance(agent_endpoint_id, six.string_types) and len(agent_endpoint_id.strip()) == 0:
        raise click.UsageError('Parameter --agent-endpoint-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if display_name is not None:
        _details['displayName'] = display_name

    if description is not None:
        _details['description'] = description

    client = cli_util.build_client('generative_ai_agent_runtime', 'generative_ai_agent_runtime', ctx)
    result = client.create_session(
        agent_endpoint_id=agent_endpoint_id,
        create_session_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@session_group.command(name=cli_util.override('generative_ai_agent_runtime.delete_session.command_name', 'delete'), help=u"""Delete a session and all its associated information. \n[Command Reference](deleteSession)""")
@cli_util.option('--agent-endpoint-id', required=True, help=u"""A unique ID for the endpoint.""")
@cli_util.option('--session-id', required=True, help=u"""A unique ID for the session.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_session(ctx, from_json, agent_endpoint_id, session_id, if_match):

    if isinstance(agent_endpoint_id, six.string_types) and len(agent_endpoint_id.strip()) == 0:
        raise click.UsageError('Parameter --agent-endpoint-id cannot be whitespace or empty string')

    if isinstance(session_id, six.string_types) and len(session_id.strip()) == 0:
        raise click.UsageError('Parameter --session-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('generative_ai_agent_runtime', 'generative_ai_agent_runtime', ctx)
    result = client.delete_session(
        agent_endpoint_id=agent_endpoint_id,
        session_id=session_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@session_group.command(name=cli_util.override('generative_ai_agent_runtime.get_session.command_name', 'get'), help=u"""Return the session resource identified by the session ID. \n[Command Reference](getSession)""")
@cli_util.option('--agent-endpoint-id', required=True, help=u"""A unique ID for the endpoint.""")
@cli_util.option('--session-id', required=True, help=u"""A unique ID for the session.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'generative_ai_agent_runtime', 'class': 'Session'})
@cli_util.wrap_exceptions
def get_session(ctx, from_json, agent_endpoint_id, session_id):

    if isinstance(agent_endpoint_id, six.string_types) and len(agent_endpoint_id.strip()) == 0:
        raise click.UsageError('Parameter --agent-endpoint-id cannot be whitespace or empty string')

    if isinstance(session_id, six.string_types) and len(session_id.strip()) == 0:
        raise click.UsageError('Parameter --session-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('generative_ai_agent_runtime', 'generative_ai_agent_runtime', ctx)
    result = client.get_session(
        agent_endpoint_id=agent_endpoint_id,
        session_id=session_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@knowledge_base_metadata_summary_group.command(name=cli_util.override('generative_ai_agent_runtime.retrieve_metadata.command_name', 'retrieve-metadata'), help=u"""Returns metadata of provided knowledgeBase. Return available metadata with information of field names, their types, supported operations, and possible values. \n[Command Reference](retrieveMetadata)""")
@cli_util.option('--knowledge-base-id', required=True, help=u"""A unique ID for the Knowledge Base.""")
@cli_util.option('--filters', type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of metadata filters to narrow down the retrieved metadata

This option is a JSON list with items of type MetadataFilter.  For documentation on MetadataFilter please see our API reference: https://docs.cloud.oracle.com/api/#/en/generativeaiagentruntime/20240531/datatypes/MetadataFilter.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@json_skeleton_utils.get_cli_json_input_option({'filters': {'module': 'generative_ai_agent_runtime', 'class': 'list[MetadataFilter]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'filters': {'module': 'generative_ai_agent_runtime', 'class': 'list[MetadataFilter]'}}, output_type={'module': 'generative_ai_agent_runtime', 'class': 'list[KnowledgeBaseMetadataSummary]'})
@cli_util.wrap_exceptions
def retrieve_metadata(ctx, from_json, knowledge_base_id, filters, if_match):

    if isinstance(knowledge_base_id, six.string_types) and len(knowledge_base_id.strip()) == 0:
        raise click.UsageError('Parameter --knowledge-base-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if filters is not None:
        _details['filters'] = cli_util.parse_json_parameter("filters", filters)

    client = cli_util.build_client('generative_ai_agent_runtime', 'generative_ai_agent_runtime', ctx)
    result = client.retrieve_metadata(
        knowledge_base_id=knowledge_base_id,
        retrieve_metadata_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@session_group.command(name=cli_util.override('generative_ai_agent_runtime.update_session.command_name', 'update'), help=u"""Update session metadata, including but not limited to description, tags. \n[Command Reference](updateSession)""")
@cli_util.option('--agent-endpoint-id', required=True, help=u"""A unique ID for the endpoint.""")
@cli_util.option('--session-id', required=True, help=u"""A unique ID for the session.""")
@cli_util.option('--display-name', help=u"""The name of the session. A session names doesn't have to be unique and you can change the session name later.""")
@cli_util.option('--description', help=u"""A description of the session.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'generative_ai_agent_runtime', 'class': 'Session'})
@cli_util.wrap_exceptions
def update_session(ctx, from_json, agent_endpoint_id, session_id, display_name, description, if_match):

    if isinstance(agent_endpoint_id, six.string_types) and len(agent_endpoint_id.strip()) == 0:
        raise click.UsageError('Parameter --agent-endpoint-id cannot be whitespace or empty string')

    if isinstance(session_id, six.string_types) and len(session_id.strip()) == 0:
        raise click.UsageError('Parameter --session-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if display_name is not None:
        _details['displayName'] = display_name

    if description is not None:
        _details['description'] = description

    client = cli_util.build_client('generative_ai_agent_runtime', 'generative_ai_agent_runtime', ctx)
    result = client.update_session(
        agent_endpoint_id=agent_endpoint_id,
        session_id=session_id,
        update_session_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)
