# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228

from __future__ import print_function
import click
import oci  # noqa: F401
import six  # noqa: F401
import sys  # noqa: F401
from oci_cli import cli_constants  # noqa: F401
from oci_cli import cli_util
from oci_cli import json_skeleton_utils
from oci_cli import custom_types  # noqa: F401
from oci_cli.aliasing import CommandGroupWithAlias
from services.fleet_apps_management.src.oci_cli_fleet_apps_management.generated import fleet_apps_management_service_cli


@click.command(cli_util.override('fleet_apps_management_catalog.fleet_apps_management_catalog_root_group.command_name', 'fleet-apps-management-catalog'), cls=CommandGroupWithAlias, help=cli_util.override('fleet_apps_management_catalog.fleet_apps_management_catalog_root_group.help', """Fleet Application Management provides a centralized platform to help you automate resource management tasks, validate patch compliance, and enhance operational efficiency across an enterprise."""), short_help=cli_util.override('fleet_apps_management_catalog.fleet_apps_management_catalog_root_group.short_help', """Fleet Application Management Service API"""))
@cli_util.help_option_group
def fleet_apps_management_catalog_root_group():
    pass


@click.command(cli_util.override('fleet_apps_management_catalog.catalog_item_group.command_name', 'catalog-item'), cls=CommandGroupWithAlias, help="""A description of a CatalogItem resource.

To use any of the API operations, you must be authorized in an IAM policy. If you're not authorized, talk to an administrator. If you're an administrator who needs to write policies to give users access, see [Getting Started with Policies].""")
@cli_util.help_option_group
def catalog_item_group():
    pass


@click.command(cli_util.override('fleet_apps_management_catalog.catalog_item_collection_group.command_name', 'catalog-item-collection'), cls=CommandGroupWithAlias, help="""The results of a CatalogItem search containing list of CatalogItemSummary items""")
@cli_util.help_option_group
def catalog_item_collection_group():
    pass


fleet_apps_management_service_cli.fleet_apps_management_service_group.add_command(fleet_apps_management_catalog_root_group)
fleet_apps_management_catalog_root_group.add_command(catalog_item_group)
fleet_apps_management_catalog_root_group.add_command(catalog_item_collection_group)


@catalog_item_group.command(name=cli_util.override('fleet_apps_management_catalog.change_catalog_item_compartment.command_name', 'change-compartment'), help=u"""Moves a CatalogItem into a different compartment within the same tenancy. For information about moving resources between compartments, see [Moving Resources to a Different Compartment]. \n[Command Reference](changeCatalogItemCompartment)""")
@cli_util.option('--catalog-item-id', required=True, help=u"""The [OCID] of the CatalogItem.""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment to move the CatalogItem to""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def change_catalog_item_compartment(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, catalog_item_id, compartment_id, if_match):

    if isinstance(catalog_item_id, six.string_types) and len(catalog_item_id.strip()) == 0:
        raise click.UsageError('Parameter --catalog-item-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management_catalog', ctx)
    result = client.change_catalog_item_compartment(
        catalog_item_id=catalog_item_id,
        change_catalog_item_compartment_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@catalog_item_group.command(name=cli_util.override('fleet_apps_management_catalog.clone_catalog_item.command_name', 'clone'), help=u"""Clones a CatalogItem into a different compartment within the same tenancy. For information about moving resources between compartments, see [Moving Resources to a Different Compartment]. \n[Command Reference](cloneCatalogItem)""")
@cli_util.option('--catalog-item-id', required=True, help=u"""The [OCID] of the CatalogItem.""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment to clone the CatalogItem to""")
@cli_util.option('--version-description', help=u"""Version description about the catalog item.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'fleet_apps_management', 'class': 'CatalogItem'})
@cli_util.wrap_exceptions
def clone_catalog_item(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, catalog_item_id, compartment_id, version_description, if_match):

    if isinstance(catalog_item_id, six.string_types) and len(catalog_item_id.strip()) == 0:
        raise click.UsageError('Parameter --catalog-item-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id

    if version_description is not None:
        _details['versionDescription'] = version_description

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management_catalog', ctx)
    result = client.clone_catalog_item(
        catalog_item_id=catalog_item_id,
        clone_catalog_item_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@catalog_item_group.command(name=cli_util.override('fleet_apps_management_catalog.create_catalog_item.command_name', 'create'), help=u"""Creates a CatalogItem. \n[Command Reference](createCatalogItem)""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment.""")
@cli_util.option('--config-source-type', required=True, help=u"""Config source type Eg: STACK_TEMPLATE_CATALOG_SOURCE, PAR_CATALOG_SOURCE, GIT_CATALOG_SOURCE, MARKETPLACE_CATALOG_SOURCE.""")
@cli_util.option('--description', required=True, help=u"""The description of the CatalogItem.""")
@cli_util.option('--display-name', required=True, help=u"""The CatalogItem name.""")
@cli_util.option('--package-type', required=True, help=u"""Config package type Eg: TF_PACKAGE, NON_TF_PACKAGE, CONFIG_FILE.""")
@cli_util.option('--version-description', help=u"""Version description about the catalog item.""")
@cli_util.option('--short-description', help=u"""Short description about the catalog item.""")
@cli_util.option('--time-released', type=custom_types.CLI_DATETIME, help=u"""The date and time the CatalogItem was released, in the format defined by [RFC 3339]. Example: `2016-08-25T21:10:29.600Z`""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--catalog-source-payload', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--listing-id', help=u"""The catalog listing Id.""")
@cli_util.option('--listing-version', help=u"""The catalog package version.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'catalog-source-payload': {'module': 'fleet_apps_management', 'class': 'CatalogSourcePayload'}, 'freeform-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'catalog-source-payload': {'module': 'fleet_apps_management', 'class': 'CatalogSourcePayload'}, 'freeform-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'fleet_apps_management', 'class': 'CatalogItem'})
@cli_util.wrap_exceptions
def create_catalog_item(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, compartment_id, config_source_type, description, display_name, package_type, version_description, short_description, time_released, catalog_source_payload, listing_id, listing_version, freeform_tags, defined_tags):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id
    _details['configSourceType'] = config_source_type
    _details['description'] = description
    _details['displayName'] = display_name
    _details['packageType'] = package_type

    if version_description is not None:
        _details['versionDescription'] = version_description

    if short_description is not None:
        _details['shortDescription'] = short_description

    if time_released is not None:
        _details['timeReleased'] = time_released

    if catalog_source_payload is not None:
        _details['catalogSourcePayload'] = cli_util.parse_json_parameter("catalog_source_payload", catalog_source_payload)

    if listing_id is not None:
        _details['listingId'] = listing_id

    if listing_version is not None:
        _details['listingVersion'] = listing_version

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management_catalog', ctx)
    result = client.create_catalog_item(
        create_catalog_item_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@catalog_item_group.command(name=cli_util.override('fleet_apps_management_catalog.create_catalog_item_catalog_git_source_config.command_name', 'create-catalog-item-catalog-git-source-config'), help=u"""Creates a CatalogItem. \n[Command Reference](createCatalogItem)""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment.""")
@cli_util.option('--config-source-type', required=True, help=u"""Config source type Eg: STACK_TEMPLATE_CATALOG_SOURCE, PAR_CATALOG_SOURCE, GIT_CATALOG_SOURCE, MARKETPLACE_CATALOG_SOURCE.""")
@cli_util.option('--description', required=True, help=u"""The description of the CatalogItem.""")
@cli_util.option('--display-name', required=True, help=u"""The CatalogItem name.""")
@cli_util.option('--package-type', required=True, help=u"""Config package type Eg: TF_PACKAGE, NON_TF_PACKAGE, CONFIG_FILE.""")
@cli_util.option('--version-description', help=u"""Version description about the catalog item.""")
@cli_util.option('--short-description', help=u"""Short description about the catalog item.""")
@cli_util.option('--time-released', type=custom_types.CLI_DATETIME, help=u"""The date and time the CatalogItem was released, in the format defined by [RFC 3339]. Example: `2016-08-25T21:10:29.600Z`""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--listing-id', help=u"""The catalog listing Id.""")
@cli_util.option('--listing-version', help=u"""The catalog package version.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--catalog-source-payload-working-directory', help=u"""File path to the directory to use for running Terraform. If not specified, the root directory is used.""")
@cli_util.option('--catalog-source-payload-branch-name', help=u"""branch Name""")
@cli_util.option('--catalog-source-payload-configuration-source-provider-id', help=u"""configuration Source Provider [OCID]""")
@cli_util.option('--catalog-source-payload-repository-url', help=u"""repository Url""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'fleet_apps_management', 'class': 'CatalogItem'})
@cli_util.wrap_exceptions
def create_catalog_item_catalog_git_source_config(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, compartment_id, config_source_type, description, display_name, package_type, version_description, short_description, time_released, listing_id, listing_version, freeform_tags, defined_tags, catalog_source_payload_working_directory, catalog_source_payload_branch_name, catalog_source_payload_configuration_source_provider_id, catalog_source_payload_repository_url):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['catalogSourcePayload'] = {}
    _details['compartmentId'] = compartment_id
    _details['configSourceType'] = config_source_type
    _details['description'] = description
    _details['displayName'] = display_name
    _details['packageType'] = package_type

    if version_description is not None:
        _details['versionDescription'] = version_description

    if short_description is not None:
        _details['shortDescription'] = short_description

    if time_released is not None:
        _details['timeReleased'] = time_released

    if listing_id is not None:
        _details['listingId'] = listing_id

    if listing_version is not None:
        _details['listingVersion'] = listing_version

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    if catalog_source_payload_working_directory is not None:
        _details['catalogSourcePayload']['workingDirectory'] = catalog_source_payload_working_directory

    if catalog_source_payload_branch_name is not None:
        _details['catalogSourcePayload']['branchName'] = catalog_source_payload_branch_name

    if catalog_source_payload_configuration_source_provider_id is not None:
        _details['catalogSourcePayload']['configurationSourceProviderId'] = catalog_source_payload_configuration_source_provider_id

    if catalog_source_payload_repository_url is not None:
        _details['catalogSourcePayload']['repositoryUrl'] = catalog_source_payload_repository_url

    _details['catalogSourcePayload']['configSourceType'] = 'GIT_CATALOG_SOURCE'

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management_catalog', ctx)
    result = client.create_catalog_item(
        create_catalog_item_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@catalog_item_group.command(name=cli_util.override('fleet_apps_management_catalog.create_catalog_item_catalog_source_template_config.command_name', 'create-catalog-item-catalog-source-template-config'), help=u"""Creates a CatalogItem. \n[Command Reference](createCatalogItem)""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment.""")
@cli_util.option('--config-source-type', required=True, help=u"""Config source type Eg: STACK_TEMPLATE_CATALOG_SOURCE, PAR_CATALOG_SOURCE, GIT_CATALOG_SOURCE, MARKETPLACE_CATALOG_SOURCE.""")
@cli_util.option('--description', required=True, help=u"""The description of the CatalogItem.""")
@cli_util.option('--display-name', required=True, help=u"""The CatalogItem name.""")
@cli_util.option('--package-type', required=True, help=u"""Config package type Eg: TF_PACKAGE, NON_TF_PACKAGE, CONFIG_FILE.""")
@cli_util.option('--version-description', help=u"""Version description about the catalog item.""")
@cli_util.option('--short-description', help=u"""Short description about the catalog item.""")
@cli_util.option('--time-released', type=custom_types.CLI_DATETIME, help=u"""The date and time the CatalogItem was released, in the format defined by [RFC 3339]. Example: `2016-08-25T21:10:29.600Z`""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--listing-id', help=u"""The catalog listing Id.""")
@cli_util.option('--listing-version', help=u"""The catalog package version.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--catalog-source-payload-working-directory', help=u"""File path to the directory to use for running Terraform. If not specified, the root directory is used.""")
@cli_util.option('--catalog-source-payload-zip-file-base64-encoded', help=u"""The Base64 encoded template. This payload will trigger CreateTemplate API, where the parameter will be passed.""")
@cli_util.option('--catalog-source-payload-description', help=u"""Template Description""")
@cli_util.option('--catalog-source-payload-long-description', help=u"""Template Long Description""")
@cli_util.option('--catalog-source-payload-template-display-name', help=u"""Template Display Name""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'fleet_apps_management', 'class': 'CatalogItem'})
@cli_util.wrap_exceptions
def create_catalog_item_catalog_source_template_config(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, compartment_id, config_source_type, description, display_name, package_type, version_description, short_description, time_released, listing_id, listing_version, freeform_tags, defined_tags, catalog_source_payload_working_directory, catalog_source_payload_zip_file_base64_encoded, catalog_source_payload_description, catalog_source_payload_long_description, catalog_source_payload_template_display_name):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['catalogSourcePayload'] = {}
    _details['compartmentId'] = compartment_id
    _details['configSourceType'] = config_source_type
    _details['description'] = description
    _details['displayName'] = display_name
    _details['packageType'] = package_type

    if version_description is not None:
        _details['versionDescription'] = version_description

    if short_description is not None:
        _details['shortDescription'] = short_description

    if time_released is not None:
        _details['timeReleased'] = time_released

    if listing_id is not None:
        _details['listingId'] = listing_id

    if listing_version is not None:
        _details['listingVersion'] = listing_version

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    if catalog_source_payload_working_directory is not None:
        _details['catalogSourcePayload']['workingDirectory'] = catalog_source_payload_working_directory

    if catalog_source_payload_zip_file_base64_encoded is not None:
        _details['catalogSourcePayload']['zipFileBase64Encoded'] = catalog_source_payload_zip_file_base64_encoded

    if catalog_source_payload_description is not None:
        _details['catalogSourcePayload']['description'] = catalog_source_payload_description

    if catalog_source_payload_long_description is not None:
        _details['catalogSourcePayload']['longDescription'] = catalog_source_payload_long_description

    if catalog_source_payload_template_display_name is not None:
        _details['catalogSourcePayload']['templateDisplayName'] = catalog_source_payload_template_display_name

    _details['catalogSourcePayload']['configSourceType'] = 'STACK_TEMPLATE_CATALOG_SOURCE'

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management_catalog', ctx)
    result = client.create_catalog_item(
        create_catalog_item_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@catalog_item_group.command(name=cli_util.override('fleet_apps_management_catalog.create_catalog_item_catalog_par_source_config.command_name', 'create-catalog-item-catalog-par-source-config'), help=u"""Creates a CatalogItem. \n[Command Reference](createCatalogItem)""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment.""")
@cli_util.option('--config-source-type', required=True, help=u"""Config source type Eg: STACK_TEMPLATE_CATALOG_SOURCE, PAR_CATALOG_SOURCE, GIT_CATALOG_SOURCE, MARKETPLACE_CATALOG_SOURCE.""")
@cli_util.option('--description', required=True, help=u"""The description of the CatalogItem.""")
@cli_util.option('--display-name', required=True, help=u"""The CatalogItem name.""")
@cli_util.option('--package-type', required=True, help=u"""Config package type Eg: TF_PACKAGE, NON_TF_PACKAGE, CONFIG_FILE.""")
@cli_util.option('--version-description', help=u"""Version description about the catalog item.""")
@cli_util.option('--short-description', help=u"""Short description about the catalog item.""")
@cli_util.option('--time-released', type=custom_types.CLI_DATETIME, help=u"""The date and time the CatalogItem was released, in the format defined by [RFC 3339]. Example: `2016-08-25T21:10:29.600Z`""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--listing-id', help=u"""The catalog listing Id.""")
@cli_util.option('--listing-version', help=u"""The catalog package version.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--catalog-source-payload-working-directory', help=u"""File path to the directory to use for running Terraform. If not specified, the root directory is used.""")
@cli_util.option('--catalog-source-payload-namespace-name', help=u"""nameSpace""")
@cli_util.option('--catalog-source-payload-bucket-name', help=u"""bucket name""")
@cli_util.option('--catalog-source-payload-object-name', help=u"""object name""")
@cli_util.option('--catalog-source-payload-access-uri', help=u"""access uri""")
@cli_util.option('--catalog-source-payload-time-expires', type=custom_types.CLI_DATETIME, help=u"""The date and time expires, in the format defined by [RFC 3339].

Example: `2016-08-25T21:10:29.600Z`""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'fleet_apps_management', 'class': 'CatalogItem'})
@cli_util.wrap_exceptions
def create_catalog_item_catalog_par_source_config(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, compartment_id, config_source_type, description, display_name, package_type, version_description, short_description, time_released, listing_id, listing_version, freeform_tags, defined_tags, catalog_source_payload_working_directory, catalog_source_payload_namespace_name, catalog_source_payload_bucket_name, catalog_source_payload_object_name, catalog_source_payload_access_uri, catalog_source_payload_time_expires):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['catalogSourcePayload'] = {}
    _details['compartmentId'] = compartment_id
    _details['configSourceType'] = config_source_type
    _details['description'] = description
    _details['displayName'] = display_name
    _details['packageType'] = package_type

    if version_description is not None:
        _details['versionDescription'] = version_description

    if short_description is not None:
        _details['shortDescription'] = short_description

    if time_released is not None:
        _details['timeReleased'] = time_released

    if listing_id is not None:
        _details['listingId'] = listing_id

    if listing_version is not None:
        _details['listingVersion'] = listing_version

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    if catalog_source_payload_working_directory is not None:
        _details['catalogSourcePayload']['workingDirectory'] = catalog_source_payload_working_directory

    if catalog_source_payload_namespace_name is not None:
        _details['catalogSourcePayload']['namespaceName'] = catalog_source_payload_namespace_name

    if catalog_source_payload_bucket_name is not None:
        _details['catalogSourcePayload']['bucketName'] = catalog_source_payload_bucket_name

    if catalog_source_payload_object_name is not None:
        _details['catalogSourcePayload']['objectName'] = catalog_source_payload_object_name

    if catalog_source_payload_access_uri is not None:
        _details['catalogSourcePayload']['accessUri'] = catalog_source_payload_access_uri

    if catalog_source_payload_time_expires is not None:
        _details['catalogSourcePayload']['timeExpires'] = catalog_source_payload_time_expires

    _details['catalogSourcePayload']['configSourceType'] = 'PAR_CATALOG_SOURCE'

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management_catalog', ctx)
    result = client.create_catalog_item(
        create_catalog_item_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@catalog_item_group.command(name=cli_util.override('fleet_apps_management_catalog.create_catalog_item_catalog_marketplace_source_config.command_name', 'create-catalog-item-catalog-marketplace-source-config'), help=u"""Creates a CatalogItem. \n[Command Reference](createCatalogItem)""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment.""")
@cli_util.option('--config-source-type', required=True, help=u"""Config source type Eg: STACK_TEMPLATE_CATALOG_SOURCE, PAR_CATALOG_SOURCE, GIT_CATALOG_SOURCE, MARKETPLACE_CATALOG_SOURCE.""")
@cli_util.option('--description', required=True, help=u"""The description of the CatalogItem.""")
@cli_util.option('--display-name', required=True, help=u"""The CatalogItem name.""")
@cli_util.option('--package-type', required=True, help=u"""Config package type Eg: TF_PACKAGE, NON_TF_PACKAGE, CONFIG_FILE.""")
@cli_util.option('--version-description', help=u"""Version description about the catalog item.""")
@cli_util.option('--short-description', help=u"""Short description about the catalog item.""")
@cli_util.option('--time-released', type=custom_types.CLI_DATETIME, help=u"""The date and time the CatalogItem was released, in the format defined by [RFC 3339]. Example: `2016-08-25T21:10:29.600Z`""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--listing-id', help=u"""The catalog listing Id.""")
@cli_util.option('--listing-version', help=u"""The catalog package version.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--catalog-source-payload-working-directory', help=u"""File path to the directory to use for running Terraform. If not specified, the root directory is used.""")
@cli_util.option('--catalog-source-payload-listing-id', help=u"""This listing Id parameter of Payload.""")
@cli_util.option('--catalog-source-payload-version', help=u"""This version parameter of Payload.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'fleet_apps_management', 'class': 'CatalogItem'})
@cli_util.wrap_exceptions
def create_catalog_item_catalog_marketplace_source_config(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, compartment_id, config_source_type, description, display_name, package_type, version_description, short_description, time_released, listing_id, listing_version, freeform_tags, defined_tags, catalog_source_payload_working_directory, catalog_source_payload_listing_id, catalog_source_payload_version):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['catalogSourcePayload'] = {}
    _details['compartmentId'] = compartment_id
    _details['configSourceType'] = config_source_type
    _details['description'] = description
    _details['displayName'] = display_name
    _details['packageType'] = package_type

    if version_description is not None:
        _details['versionDescription'] = version_description

    if short_description is not None:
        _details['shortDescription'] = short_description

    if time_released is not None:
        _details['timeReleased'] = time_released

    if listing_id is not None:
        _details['listingId'] = listing_id

    if listing_version is not None:
        _details['listingVersion'] = listing_version

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    if catalog_source_payload_working_directory is not None:
        _details['catalogSourcePayload']['workingDirectory'] = catalog_source_payload_working_directory

    if catalog_source_payload_listing_id is not None:
        _details['catalogSourcePayload']['listingId'] = catalog_source_payload_listing_id

    if catalog_source_payload_version is not None:
        _details['catalogSourcePayload']['version'] = catalog_source_payload_version

    _details['catalogSourcePayload']['configSourceType'] = 'MARKETPLACE_CATALOG_SOURCE'

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management_catalog', ctx)
    result = client.create_catalog_item(
        create_catalog_item_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@catalog_item_group.command(name=cli_util.override('fleet_apps_management_catalog.delete_catalog_item.command_name', 'delete'), help=u"""Deletes a CatalogItem. \n[Command Reference](deleteCatalogItem)""")
@cli_util.option('--catalog-item-id', required=True, help=u"""The [OCID] of the CatalogItem.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_catalog_item(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, catalog_item_id, if_match):

    if isinstance(catalog_item_id, six.string_types) and len(catalog_item_id.strip()) == 0:
        raise click.UsageError('Parameter --catalog-item-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management_catalog', ctx)
    result = client.delete_catalog_item(
        catalog_item_id=catalog_item_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Please retrieve the work request to find its current state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@catalog_item_group.command(name=cli_util.override('fleet_apps_management_catalog.get_catalog_item.command_name', 'get'), help=u"""Gets information about a CatalogItem. \n[Command Reference](getCatalogItem)""")
@cli_util.option('--catalog-item-id', required=True, help=u"""The [OCID] of the CatalogItem.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'fleet_apps_management', 'class': 'CatalogItem'})
@cli_util.wrap_exceptions
def get_catalog_item(ctx, from_json, catalog_item_id):

    if isinstance(catalog_item_id, six.string_types) and len(catalog_item_id.strip()) == 0:
        raise click.UsageError('Parameter --catalog-item-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management_catalog', ctx)
    result = client.get_catalog_item(
        catalog_item_id=catalog_item_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@catalog_item_collection_group.command(name=cli_util.override('fleet_apps_management_catalog.list_catalog_items.command_name', 'list-catalog-items'), help=u"""Gets a list of Catalog Items in a compartment. \n[Command Reference](listCatalogItems)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ID of the compartment in which to list resources.""")
@cli_util.option('--config-source-type', help=u"""The [ConfigSourceType] Eg: STACK_TEMPLATE_CATALOG_SOURCE, PAR_CATALOG_SOURCE, URL_CATALOG_SOURCE, MARKETPLACE_CATALOG_SOURCE.""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]), help=u"""A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName", "timeBackfillLastChecked"]), help=u"""The field to sort by. You can provide only one sort by. Default value for `timeCreated` is descending. Default order for `displayName` is ascending""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the entire display name given.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@cli_util.option('--catalog-listing-id', help=u"""catalogListingId of the package. This is an integer whose min and max length are specified.""")
@cli_util.option('--catalog-listing-version-criteria', type=custom_types.CliCaseInsensitiveChoice(["LIST_ALL_VERSIONS", "LIST_EARLIEST_VERSION_ONLY", "LIST_LATEST_VERSION_ONLY"]), help=u"""Parameter to list all catalog items only with latest version or list all catalog items with all versions.""")
@cli_util.option('--should-list-public-items', type=click.BOOL, help=u"""The indicator to append Public Items from the root compartment to any query, when set to TRUE.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'fleet_apps_management', 'class': 'CatalogItemCollection'})
@cli_util.wrap_exceptions
def list_catalog_items(ctx, from_json, all_pages, page_size, compartment_id, config_source_type, lifecycle_state, sort_order, sort_by, display_name, limit, page, catalog_listing_id, catalog_listing_version_criteria, should_list_public_items):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if config_source_type is not None:
        kwargs['config_source_type'] = config_source_type
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if display_name is not None:
        kwargs['display_name'] = display_name
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if catalog_listing_id is not None:
        kwargs['catalog_listing_id'] = catalog_listing_id
    if catalog_listing_version_criteria is not None:
        kwargs['catalog_listing_version_criteria'] = catalog_listing_version_criteria
    if should_list_public_items is not None:
        kwargs['should_list_public_items'] = should_list_public_items
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management_catalog', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_catalog_items,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_catalog_items,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_catalog_items(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@catalog_item_group.command(name=cli_util.override('fleet_apps_management_catalog.update_catalog_item.command_name', 'update'), help=u"""Updates a CatalogItem. \n[Command Reference](updateCatalogItem)""")
@cli_util.option('--catalog-item-id', required=True, help=u"""The [OCID] of the CatalogItem.""")
@cli_util.option('--description', help=u"""The description of the CatalogItem.""")
@cli_util.option('--version-description', help=u"""Version description about the catalog item.""")
@cli_util.option('--short-description', help=u"""Short description about the catalog item.""")
@cli_util.option('--display-name', help=u"""The CatalogItem name.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'fleet_apps_management', 'class': 'dict(str, dict(str, object))'}})
@cli_util.wrap_exceptions
def update_catalog_item(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, catalog_item_id, description, version_description, short_description, display_name, freeform_tags, defined_tags, if_match):

    if isinstance(catalog_item_id, six.string_types) and len(catalog_item_id.strip()) == 0:
        raise click.UsageError('Parameter --catalog-item-id cannot be whitespace or empty string')
    if not force:
        if freeform_tags or defined_tags:
            if not click.confirm("WARNING: Updates to freeform-tags and defined-tags will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if description is not None:
        _details['description'] = description

    if version_description is not None:
        _details['versionDescription'] = version_description

    if short_description is not None:
        _details['shortDescription'] = short_description

    if display_name is not None:
        _details['displayName'] = display_name

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('fleet_apps_management', 'fleet_apps_management_catalog', ctx)
    result = client.update_catalog_item(
        catalog_item_id=catalog_item_id,
        update_catalog_item_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)
