# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230801

from __future__ import print_function
import click
import oci  # noqa: F401
import six  # noqa: F401
import sys  # noqa: F401
from oci_cli import cli_constants  # noqa: F401
from oci_cli import cli_util
from oci_cli import json_skeleton_utils
from oci_cli import custom_types  # noqa: F401
from oci_cli.aliasing import CommandGroupWithAlias
from services.delegate_access_control.src.oci_cli_delegate_access_control.generated import delegate_access_control_service_cli


@click.command(cli_util.override('delegate_access_control.delegate_access_control_root_group.command_name', 'delegate-access-control'), cls=CommandGroupWithAlias, help=cli_util.override('delegate_access_control.delegate_access_control_root_group.help', """Oracle Delegate Access Control allows ExaCC and ExaCS customers to delegate management of their Exadata resources operators outside their tenancies.
With Delegate Access Control, Support Providers can deliver managed services using comprehensive and robust tooling built on the OCI platform.
Customers maintain control over who has access to the delegated resources in their tenancy and what actions can be taken.
Enterprises managing resources across multiple tenants can use Delegate Access Control to streamline management tasks.
Using logging service, customers can view a near real-time audit report of all actions performed by a Service Provider operator."""), short_help=cli_util.override('delegate_access_control.delegate_access_control_root_group.short_help', """Oracle Delegate Access Control API"""))
@cli_util.help_option_group
def delegate_access_control_root_group():
    pass


@click.command(cli_util.override('delegate_access_control.service_provider_action_group.command_name', 'service-provider-action'), cls=CommandGroupWithAlias, help="""Details of the Service Provider Action. Service provider actions are a pre-defined set of commands available to the support operator on different layers of the infrastructure. Although the groupings may differ depending on the infrastructure layers, the groups are designed to enable the support operator access to commands to resolve a specific set of issues.""")
@cli_util.help_option_group
def service_provider_action_group():
    pass


@click.command(cli_util.override('delegate_access_control.delegated_resource_access_request_audit_log_report_group.command_name', 'delegated-resource-access-request-audit-log-report'), cls=CommandGroupWithAlias, help="""The audit log report details.""")
@cli_util.help_option_group
def delegated_resource_access_request_audit_log_report_group():
    pass


@click.command(cli_util.override('delegate_access_control.delegation_control_group.command_name', 'delegation-control'), cls=CommandGroupWithAlias, help="""Delegation Control enables you to grant, audit, or revoke the access Oracle has to your Exadata Cloud infrastructure, and obtain audit reports of all actions taken by a human operator, in a near real-time manner.""")
@cli_util.help_option_group
def delegation_control_group():
    pass


@click.command(cli_util.override('delegate_access_control.service_provider_group.command_name', 'service-provider'), cls=CommandGroupWithAlias, help="""Details of the Service Provider. Service provider offers services to the customer to support the delegated resources.""")
@cli_util.help_option_group
def service_provider_group():
    pass


@click.command(cli_util.override('delegate_access_control.delegated_resource_access_request_group.command_name', 'delegated-resource-access-request'), cls=CommandGroupWithAlias, help="""A support operator raises Delegated Resource Access Request when they need access to any infrastructure resource governed by Delegation Control. The Delegated Resource Access Request identifies the target resource and the set of Service Provider Actions. Delegated Resource Access Request handling depends upon the Delegation Control that governs the target resource, and the set of Service Provider Actions listed for approval in the Delegated Resource Access Request. If all of the Service Provider Actions listed in the Delegated Resource Access Request are in the pre-approved list in the Delegation Control that governs the target resource, then the Delegated Resource Access Request is automatically approved. If not, then the Delegated Resource Access Request requires explicit approval from the approver group specified by the Delegation Control governing the target resource.

You can approve or reject a Delegated Resource Access Request. You can also revoke the approval of an already approved Delegated Resource Access Request. While creating a Delegated Resource Access Request, the support operator specifies the duration of access. You have the option to approve the entire duration or reduce or even increase the time duration. A support operator can also request for an extension. The approval for such an extension is processed the same way the original Delegated Resource Access Request was processed.""")
@cli_util.help_option_group
def delegated_resource_access_request_group():
    pass


@click.command(cli_util.override('delegate_access_control.delegation_subscription_group.command_name', 'delegation-subscription'), cls=CommandGroupWithAlias, help="""Details of the Delegation Subscription.""")
@cli_util.help_option_group
def delegation_subscription_group():
    pass


delegate_access_control_service_cli.delegate_access_control_service_group.add_command(delegate_access_control_root_group)
delegate_access_control_root_group.add_command(service_provider_action_group)
delegate_access_control_root_group.add_command(delegated_resource_access_request_audit_log_report_group)
delegate_access_control_root_group.add_command(delegation_control_group)
delegate_access_control_root_group.add_command(service_provider_group)
delegate_access_control_root_group.add_command(delegated_resource_access_request_group)
delegate_access_control_root_group.add_command(delegation_subscription_group)
# oci delegate_access_control delegate_access_control --> oci delegate_access_control
delegate_access_control_service_cli.delegate_access_control_service_group.commands.pop(delegate_access_control_root_group.name)
delegate_access_control_service_cli.delegate_access_control_service_group.add_command(service_provider_action_group)
delegate_access_control_service_cli.delegate_access_control_service_group.add_command(delegated_resource_access_request_audit_log_report_group)
delegate_access_control_service_cli.delegate_access_control_service_group.add_command(delegation_control_group)
delegate_access_control_service_cli.delegate_access_control_service_group.add_command(service_provider_group)
delegate_access_control_service_cli.delegate_access_control_service_group.add_command(delegated_resource_access_request_group)
delegate_access_control_service_cli.delegate_access_control_service_group.add_command(delegation_subscription_group)


@delegated_resource_access_request_group.command(name=cli_util.override('delegate_access_control.approve_delegated_resource_access_request.command_name', 'approve'), help=u"""Approves a Delegated Resource Access Request. \n[Command Reference](approveDelegatedResourceAccessRequest)""")
@cli_util.option('--delegated-resource-access-request-id', required=True, help=u"""Unique Delegated Resource Access Request identifier""")
@cli_util.option('--approver-comment', help=u"""Comment by the approver during approval.""")
@cli_util.option('--additional-message', help=u"""Message that needs to be displayed to the operator.""")
@cli_util.option('--time-approved-for-access', type=custom_types.CLI_DATETIME, help=u"""Access start time that is actually approved by the customer in [RFC 3339]timestamp format, e.g. '2020-05-22T21:10:29.600Z'.""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def approve_delegated_resource_access_request(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, delegated_resource_access_request_id, approver_comment, additional_message, time_approved_for_access, if_match):

    if isinstance(delegated_resource_access_request_id, six.string_types) and len(delegated_resource_access_request_id.strip()) == 0:
        raise click.UsageError('Parameter --delegated-resource-access-request-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if approver_comment is not None:
        _details['approverComment'] = approver_comment

    if additional_message is not None:
        _details['additionalMessage'] = additional_message

    if time_approved_for_access is not None:
        _details['timeApprovedForAccess'] = time_approved_for_access

    client = cli_util.build_client('delegate_access_control', 'delegate_access_control', ctx)
    result = client.approve_delegated_resource_access_request(
        delegated_resource_access_request_id=delegated_resource_access_request_id,
        approve_delegated_resource_access_request_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@delegation_control_group.command(name=cli_util.override('delegate_access_control.change_delegation_control_compartment.command_name', 'change-compartment'), help=u"""Moves the Delegation Control resource into a different compartment. When provided, 'If-Match' is checked against 'ETag' values of the resource. \n[Command Reference](changeDelegationControlCompartment)""")
@cli_util.option('--delegation-control-id', required=True, help=u"""unique Delegation Control identifier""")
@cli_util.option('--compartment-id', help=u"""The OCID of the new compartment to contain the Delegation Control.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def change_delegation_control_compartment(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, delegation_control_id, compartment_id, if_match):

    if isinstance(delegation_control_id, six.string_types) and len(delegation_control_id.strip()) == 0:
        raise click.UsageError('Parameter --delegation-control-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if compartment_id is not None:
        _details['compartmentId'] = compartment_id

    client = cli_util.build_client('delegate_access_control', 'delegate_access_control', ctx)
    result = client.change_delegation_control_compartment(
        delegation_control_id=delegation_control_id,
        change_delegation_control_compartment_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@delegation_subscription_group.command(name=cli_util.override('delegate_access_control.change_delegation_subscription_compartment.command_name', 'change-compartment'), help=u"""Moves the Delegation Subscription resource into a different compartment. When provided, 'If-Match' is checked against 'ETag' values of the resource. \n[Command Reference](changeDelegationSubscriptionCompartment)""")
@cli_util.option('--delegation-subscription-id', required=True, help=u"""unique Delegation Subscription identifier""")
@cli_util.option('--compartment-id', help=u"""The OCID of the new compartment to contain the Delegation Subscription.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def change_delegation_subscription_compartment(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, delegation_subscription_id, compartment_id, if_match):

    if isinstance(delegation_subscription_id, six.string_types) and len(delegation_subscription_id.strip()) == 0:
        raise click.UsageError('Parameter --delegation-subscription-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if compartment_id is not None:
        _details['compartmentId'] = compartment_id

    client = cli_util.build_client('delegate_access_control', 'delegate_access_control', ctx)
    result = client.change_delegation_subscription_compartment(
        delegation_subscription_id=delegation_subscription_id,
        change_delegation_subscription_compartment_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@delegation_control_group.command(name=cli_util.override('delegate_access_control.create_delegation_control.command_name', 'create'), help=u"""Creates a Delegation Control. \n[Command Reference](createDelegationControl)""")
@cli_util.option('--compartment-id', required=True, help=u"""The OCID of the compartment that contains this Delegation Control.""")
@cli_util.option('--display-name', required=True, help=u"""Name of the Delegation Control. The name does not need to be unique.""")
@cli_util.option('--delegation-subscription-ids', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of Delegation Subscription OCID that are allowed for this Delegation Control. The allowed subscriptions will determine the available Service Provider Actions. Only support operators for the allowed subscriptions are allowed to create Delegated Resource Access Request.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--resource-ids', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""The OCID of the selected resources that this Delegation Control is applicable to.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--resource-type', required=True, type=custom_types.CliCaseInsensitiveChoice(["VMCLUSTER", "CLOUDVMCLUSTER"]), help=u"""Resource type for which the Delegation Control is applicable to.""")
@cli_util.option('--notification-topic-id', required=True, help=u"""The OCID of the OCI Notification topic to publish messages related to this Delegation Control.""")
@cli_util.option('--notification-message-format', required=True, help=u"""The format of the OCI Notification messages for this Delegation Control.""")
@cli_util.option('--description', help=u"""Description of the Delegation Control.""")
@cli_util.option('--num-approvals-required', type=click.INT, help=u"""number of approvals required.""")
@cli_util.option('--pre-approved-service-provider-action-names', type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of pre-approved Service Provider Action names. The list of pre-defined Service Provider Actions can be obtained from the ListServiceProviderActions API. Delegated Resource Access Requests associated with a resource governed by this Delegation Control will be automatically approved if the Delegated Resource Access Request only contain Service Provider Actions in the pre-approved list.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--is-auto-approve-during-maintenance', type=click.BOOL, help=u"""Set to true to allow all Delegated Resource Access Request to be approved automatically during maintenance.""")
@cli_util.option('--vault-id', help=u"""The OCID of the OCI Vault that will store the secrets containing the SSH keys to access the resource governed by this Delegation Control by Delegate Access Control Service. This property is required when resourceType is CLOUDVMCLUSTER. Delegate Access Control Service will generate the SSH keys and store them as secrets in the OCI Vault.""")
@cli_util.option('--vault-key-id', help=u"""The OCID of the Master Encryption Key in the OCI Vault specified by vaultId. This key will be used to encrypt the SSH keys to access the resource governed by this Delegation Control by Delegate Access Control Service. This property is required when resourceType is CLOUDVMCLUSTER.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags].

Example: `{\"Department\": \"Finance\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags].

Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'pre-approved-service-provider-action-names': {'module': 'delegate_access_control', 'class': 'list[string]'}, 'delegation-subscription-ids': {'module': 'delegate_access_control', 'class': 'list[string]'}, 'resource-ids': {'module': 'delegate_access_control', 'class': 'list[string]'}, 'freeform-tags': {'module': 'delegate_access_control', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'delegate_access_control', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'pre-approved-service-provider-action-names': {'module': 'delegate_access_control', 'class': 'list[string]'}, 'delegation-subscription-ids': {'module': 'delegate_access_control', 'class': 'list[string]'}, 'resource-ids': {'module': 'delegate_access_control', 'class': 'list[string]'}, 'freeform-tags': {'module': 'delegate_access_control', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'delegate_access_control', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'delegate_access_control', 'class': 'DelegationControl'})
@cli_util.wrap_exceptions
def create_delegation_control(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, compartment_id, display_name, delegation_subscription_ids, resource_ids, resource_type, notification_topic_id, notification_message_format, description, num_approvals_required, pre_approved_service_provider_action_names, is_auto_approve_during_maintenance, vault_id, vault_key_id, freeform_tags, defined_tags):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id
    _details['displayName'] = display_name
    _details['delegationSubscriptionIds'] = cli_util.parse_json_parameter("delegation_subscription_ids", delegation_subscription_ids)
    _details['resourceIds'] = cli_util.parse_json_parameter("resource_ids", resource_ids)
    _details['resourceType'] = resource_type
    _details['notificationTopicId'] = notification_topic_id
    _details['notificationMessageFormat'] = notification_message_format

    if description is not None:
        _details['description'] = description

    if num_approvals_required is not None:
        _details['numApprovalsRequired'] = num_approvals_required

    if pre_approved_service_provider_action_names is not None:
        _details['preApprovedServiceProviderActionNames'] = cli_util.parse_json_parameter("pre_approved_service_provider_action_names", pre_approved_service_provider_action_names)

    if is_auto_approve_during_maintenance is not None:
        _details['isAutoApproveDuringMaintenance'] = is_auto_approve_during_maintenance

    if vault_id is not None:
        _details['vaultId'] = vault_id

    if vault_key_id is not None:
        _details['vaultKeyId'] = vault_key_id

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('delegate_access_control', 'delegate_access_control', ctx)
    result = client.create_delegation_control(
        create_delegation_control_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@delegation_subscription_group.command(name=cli_util.override('delegate_access_control.create_delegation_subscription.command_name', 'create'), help=u"""Creates Delegation Subscription in Delegation Control. \n[Command Reference](createDelegationSubscription)""")
@cli_util.option('--compartment-id', required=True, help=u"""The OCID of the compartment that contains the Delegation Control.""")
@cli_util.option('--service-provider-id', required=True, help=u"""Unique identifier of the Service Provider.""")
@cli_util.option('--subscribed-service-type', required=True, type=custom_types.CliCaseInsensitiveChoice(["TROUBLESHOOTING", "ASSISTED_PATCHING"]), help=u"""Subscribed Service Provider Service Type.""")
@cli_util.option('--description', help=u"""Description of the Delegation Subscription.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags].

Example: `{\"Department\": \"Finance\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags].

Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'delegate_access_control', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'delegate_access_control', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'delegate_access_control', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'delegate_access_control', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'delegate_access_control', 'class': 'DelegationSubscription'})
@cli_util.wrap_exceptions
def create_delegation_subscription(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, compartment_id, service_provider_id, subscribed_service_type, description, freeform_tags, defined_tags):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id
    _details['serviceProviderId'] = service_provider_id
    _details['subscribedServiceType'] = subscribed_service_type

    if description is not None:
        _details['description'] = description

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('delegate_access_control', 'delegate_access_control', ctx)
    result = client.create_delegation_subscription(
        create_delegation_subscription_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@delegation_control_group.command(name=cli_util.override('delegate_access_control.delete_delegation_control.command_name', 'delete'), help=u"""Deletes a Delegation Control. You cannot delete a Delegation Control if it is assigned to govern any target resource currently or in the future. In that case, first, delete all of the current and future assignments before deleting the Delegation Control. A Delegation Control that was previously assigned to a target resource is marked as DELETED following a successful deletion. However, it is not completely deleted from the system. This is to ensure auditing information for the accesses done under the Delegation Control is preserved for future needs. The system purges the deleted Delegation Control only when all of the audit data associated with the Delegation Control are also deleted. Therefore, you cannot reuse the name of the deleted Delegation Control until the system purges the Delegation Control. \n[Command Reference](deleteDelegationControl)""")
@cli_util.option('--delegation-control-id', required=True, help=u"""unique Delegation Control identifier""")
@cli_util.option('--description', help=u"""Reason why this Delegation Control is deleted.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_delegation_control(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, delegation_control_id, description, if_match):

    if isinstance(delegation_control_id, six.string_types) and len(delegation_control_id.strip()) == 0:
        raise click.UsageError('Parameter --delegation-control-id cannot be whitespace or empty string')

    kwargs = {}
    if description is not None:
        kwargs['description'] = description
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('delegate_access_control', 'delegate_access_control', ctx)
    result = client.delete_delegation_control(
        delegation_control_id=delegation_control_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Please retrieve the work request to find its current state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@delegation_subscription_group.command(name=cli_util.override('delegate_access_control.delete_delegation_subscription.command_name', 'delete'), help=u"""eletes an Delegation Subscription in Delegation Control. \n[Command Reference](deleteDelegationSubscription)""")
@cli_util.option('--delegation-subscription-id', required=True, help=u"""unique Delegation Subscription identifier""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_delegation_subscription(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, delegation_subscription_id, if_match):

    if isinstance(delegation_subscription_id, six.string_types) and len(delegation_subscription_id.strip()) == 0:
        raise click.UsageError('Parameter --delegation-subscription-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('delegate_access_control', 'delegate_access_control', ctx)
    result = client.delete_delegation_subscription(
        delegation_subscription_id=delegation_subscription_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Please retrieve the work request to find its current state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@delegated_resource_access_request_group.command(name=cli_util.override('delegate_access_control.get_delegated_resource_access_request.command_name', 'get'), help=u"""Gets details of a Delegated Resource Access Request. \n[Command Reference](getDelegatedResourceAccessRequest)""")
@cli_util.option('--delegated-resource-access-request-id', required=True, help=u"""Unique Delegated Resource Access Request identifier""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'delegate_access_control', 'class': 'DelegatedResourceAccessRequest'})
@cli_util.wrap_exceptions
def get_delegated_resource_access_request(ctx, from_json, delegated_resource_access_request_id):

    if isinstance(delegated_resource_access_request_id, six.string_types) and len(delegated_resource_access_request_id.strip()) == 0:
        raise click.UsageError('Parameter --delegated-resource-access-request-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('delegate_access_control', 'delegate_access_control', ctx)
    result = client.get_delegated_resource_access_request(
        delegated_resource_access_request_id=delegated_resource_access_request_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@delegated_resource_access_request_audit_log_report_group.command(name=cli_util.override('delegate_access_control.get_delegated_resource_access_request_audit_log_report.command_name', 'get'), help=u"""Gets the audit log report for the given Delegated Resource Access Request. \n[Command Reference](getDelegatedResourceAccessRequestAuditLogReport)""")
@cli_util.option('--delegated-resource-access-request-id', required=True, help=u"""Unique Delegated Resource Access Request identifier""")
@cli_util.option('--is-process-tree-enabled', type=click.BOOL, help=u"""Set to true to enable process tree computation in audit report""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'delegate_access_control', 'class': 'DelegatedResourceAccessRequestAuditLogReport'})
@cli_util.wrap_exceptions
def get_delegated_resource_access_request_audit_log_report(ctx, from_json, delegated_resource_access_request_id, is_process_tree_enabled):

    if isinstance(delegated_resource_access_request_id, six.string_types) and len(delegated_resource_access_request_id.strip()) == 0:
        raise click.UsageError('Parameter --delegated-resource-access-request-id cannot be whitespace or empty string')

    kwargs = {}
    if is_process_tree_enabled is not None:
        kwargs['is_process_tree_enabled'] = is_process_tree_enabled
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('delegate_access_control', 'delegate_access_control', ctx)
    result = client.get_delegated_resource_access_request_audit_log_report(
        delegated_resource_access_request_id=delegated_resource_access_request_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@delegation_control_group.command(name=cli_util.override('delegate_access_control.get_delegation_control.command_name', 'get'), help=u"""Gets the Delegation Control associated with the specified Delegation Control ID. \n[Command Reference](getDelegationControl)""")
@cli_util.option('--delegation-control-id', required=True, help=u"""unique Delegation Control identifier""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'delegate_access_control', 'class': 'DelegationControl'})
@cli_util.wrap_exceptions
def get_delegation_control(ctx, from_json, delegation_control_id):

    if isinstance(delegation_control_id, six.string_types) and len(delegation_control_id.strip()) == 0:
        raise click.UsageError('Parameter --delegation-control-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('delegate_access_control', 'delegate_access_control', ctx)
    result = client.get_delegation_control(
        delegation_control_id=delegation_control_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@delegation_subscription_group.command(name=cli_util.override('delegate_access_control.get_delegation_subscription.command_name', 'get'), help=u"""Gets a DelegationSubscription by identifier \n[Command Reference](getDelegationSubscription)""")
@cli_util.option('--delegation-subscription-id', required=True, help=u"""unique Delegation Subscription identifier""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'delegate_access_control', 'class': 'DelegationSubscription'})
@cli_util.wrap_exceptions
def get_delegation_subscription(ctx, from_json, delegation_subscription_id):

    if isinstance(delegation_subscription_id, six.string_types) and len(delegation_subscription_id.strip()) == 0:
        raise click.UsageError('Parameter --delegation-subscription-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('delegate_access_control', 'delegate_access_control', ctx)
    result = client.get_delegation_subscription(
        delegation_subscription_id=delegation_subscription_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@service_provider_group.command(name=cli_util.override('delegate_access_control.get_service_provider.command_name', 'get'), help=u"""Gets a ServiceProvider by identifier \n[Command Reference](getServiceProvider)""")
@cli_util.option('--service-provider-id', required=True, help=u"""unique Service Provider identifier""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'delegate_access_control', 'class': 'ServiceProvider'})
@cli_util.wrap_exceptions
def get_service_provider(ctx, from_json, service_provider_id):

    if isinstance(service_provider_id, six.string_types) and len(service_provider_id.strip()) == 0:
        raise click.UsageError('Parameter --service-provider-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('delegate_access_control', 'delegate_access_control', ctx)
    result = client.get_service_provider(
        service_provider_id=service_provider_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@service_provider_action_group.command(name=cli_util.override('delegate_access_control.get_service_provider_action.command_name', 'get'), help=u"""Gets the Service Provider Action associated with the specified Service Provider Action ID. \n[Command Reference](getServiceProviderAction)""")
@cli_util.option('--service-provider-action-id', required=True, help=u"""Unique Oracle supplied identifier associated with the Service Provider Action.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'delegate_access_control', 'class': 'ServiceProviderAction'})
@cli_util.wrap_exceptions
def get_service_provider_action(ctx, from_json, service_provider_action_id):

    if isinstance(service_provider_action_id, six.string_types) and len(service_provider_action_id.strip()) == 0:
        raise click.UsageError('Parameter --service-provider-action-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('delegate_access_control', 'delegate_access_control', ctx)
    result = client.get_service_provider_action(
        service_provider_action_id=service_provider_action_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@delegated_resource_access_request_group.command(name=cli_util.override('delegate_access_control.list_delegated_resource_access_request_histories.command_name', 'list-delegated-resource-access-request-histories'), help=u"""Returns a history of all status associated with the Delegated Resource Access RequestId. \n[Command Reference](listDelegatedResourceAccessRequestHistories)""")
@cli_util.option('--delegated-resource-access-request-id', required=True, help=u"""Unique Delegated Resource Access Request identifier""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'asc' or 'desc'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timestamp"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timestamp is descending. If no value is specified, timestamp is default.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'delegate_access_control', 'class': 'DelegatedResourceAccessRequestHistoryCollection'})
@cli_util.wrap_exceptions
def list_delegated_resource_access_request_histories(ctx, from_json, all_pages, page_size, delegated_resource_access_request_id, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(delegated_resource_access_request_id, six.string_types) and len(delegated_resource_access_request_id.strip()) == 0:
        raise click.UsageError('Parameter --delegated-resource-access-request-id cannot be whitespace or empty string')

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('delegate_access_control', 'delegate_access_control', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_delegated_resource_access_request_histories,
            delegated_resource_access_request_id=delegated_resource_access_request_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_delegated_resource_access_request_histories,
            limit,
            page_size,
            delegated_resource_access_request_id=delegated_resource_access_request_id,
            **kwargs
        )
    else:
        result = client.list_delegated_resource_access_request_histories(
            delegated_resource_access_request_id=delegated_resource_access_request_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@delegated_resource_access_request_group.command(name=cli_util.override('delegate_access_control.list_delegated_resource_access_requests.command_name', 'list'), help=u"""Lists all Delegated Resource Access Requests in the compartment. Note that only one of lifecycleState or requestStatus query parameter can be used. \n[Command Reference](listDelegatedResourceAccessRequests)""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment.""")
@cli_util.option('--delegation-control-id', help=u"""unique Delegation Control identifier""")
@cli_util.option('--resource-id', help=u"""A filter to return only Delegated Resource Access Requests for the given resource identifier.""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED", "NEEDS_ATTENTION"]), help=u"""A filter to return only Delegated Resource Access Requests whose lifecycleState matches the given Delegated Resource Access Request lifecycleState.""")
@cli_util.option('--request-status', type=custom_types.CliCaseInsensitiveChoice(["CREATED", "APPROVAL_WAITING", "OPERATOR_ASSIGNMENT_WAITING", "PREAPPROVED", "APPROVED", "APPROVED_FOR_FUTURE", "REJECTED", "DEPLOYED", "DEPLOY_FAILED", "UNDEPLOYED", "UNDEPLOY_FAILED", "CLOSE_FAILED", "REVOKE_FAILED", "EXPIRY_FAILED", "REVOKING", "REVOKED", "EXTENDING", "EXTENDED", "EXTENSION_REJECTED", "EXTENSION_FAILED", "COMPLETING", "COMPLETED", "EXPIRED"]), help=u"""A filter to return only Delegated Resource Access Requests whose status matches the given Delegated Resource Access Request status.""")
@cli_util.option('--time-start', type=custom_types.CLI_DATETIME, help=u"""Query start time in UTC in ISO 8601 format(inclusive). Example 2019-10-30T00:00:00Z (yyyy-MM-ddThh:mm:ssZ). timeIntervalStart and timeIntervalEnd parameters cannot be used together.""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--time-end', type=custom_types.CLI_DATETIME, help=u"""Query end time in UTC in ISO 8601 format(inclusive). Example 2019-10-30T00:00:00Z (yyyy-MM-ddThh:mm:ssZ). timeIntervalStart and timeIntervalEnd parameters cannot be used together.""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'asc' or 'desc'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending. If no value is specified, default is timeCreated.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'delegate_access_control', 'class': 'DelegatedResourceAccessRequestSummaryCollection'})
@cli_util.wrap_exceptions
def list_delegated_resource_access_requests(ctx, from_json, all_pages, page_size, compartment_id, delegation_control_id, resource_id, lifecycle_state, request_status, time_start, time_end, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if delegation_control_id is not None:
        kwargs['delegation_control_id'] = delegation_control_id
    if resource_id is not None:
        kwargs['resource_id'] = resource_id
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    if request_status is not None:
        kwargs['request_status'] = request_status
    if time_start is not None:
        kwargs['time_start'] = time_start
    if time_end is not None:
        kwargs['time_end'] = time_end
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('delegate_access_control', 'delegate_access_control', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_delegated_resource_access_requests,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_delegated_resource_access_requests,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_delegated_resource_access_requests(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@delegation_control_group.command(name=cli_util.override('delegate_access_control.list_delegation_control_resources.command_name', 'list-delegation-control-resources'), help=u"""Returns a list of resources associated with the Delegation Control. \n[Command Reference](listDelegationControlResources)""")
@cli_util.option('--delegation-control-id', required=True, help=u"""unique Delegation Control identifier""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'delegate_access_control', 'class': 'DelegationControlResourceCollection'})
@cli_util.wrap_exceptions
def list_delegation_control_resources(ctx, from_json, all_pages, page_size, delegation_control_id, limit, page):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(delegation_control_id, six.string_types) and len(delegation_control_id.strip()) == 0:
        raise click.UsageError('Parameter --delegation-control-id cannot be whitespace or empty string')

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('delegate_access_control', 'delegate_access_control', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_delegation_control_resources,
            delegation_control_id=delegation_control_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_delegation_control_resources,
            limit,
            page_size,
            delegation_control_id=delegation_control_id,
            **kwargs
        )
    else:
        result = client.list_delegation_control_resources(
            delegation_control_id=delegation_control_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@delegation_control_group.command(name=cli_util.override('delegate_access_control.list_delegation_controls.command_name', 'list'), help=u"""Lists the Delegation Controls in the compartment. \n[Command Reference](listDelegationControls)""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment.""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "ACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED", "NEEDS_ATTENTION"]), help=u"""A filter to return only Delegation Control resources whose lifecycleState matches the given Delegation Control lifecycle state.""")
@cli_util.option('--display-name', help=u"""A filter to return Delegation Control resources that match the given display name.""")
@cli_util.option('--resource-type', type=custom_types.CliCaseInsensitiveChoice(["VMCLUSTER", "CLOUDVMCLUSTER"]), help=u"""A filter to return only resources that match the given resource type.""")
@cli_util.option('--resource-id', help=u"""A filter to return Delegation Control resources that match the given resource ID.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'asc' or 'desc'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending. If no value is specified, default is timeCreated.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'delegate_access_control', 'class': 'DelegationControlSummaryCollection'})
@cli_util.wrap_exceptions
def list_delegation_controls(ctx, from_json, all_pages, page_size, compartment_id, lifecycle_state, display_name, resource_type, resource_id, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    if display_name is not None:
        kwargs['display_name'] = display_name
    if resource_type is not None:
        kwargs['resource_type'] = resource_type
    if resource_id is not None:
        kwargs['resource_id'] = resource_id
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('delegate_access_control', 'delegate_access_control', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_delegation_controls,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_delegation_controls,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_delegation_controls(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@delegation_subscription_group.command(name=cli_util.override('delegate_access_control.list_delegation_subscriptions.command_name', 'list'), help=u"""Lists the Delegation Subscriptions in Delegation Control. \n[Command Reference](listDelegationSubscriptions)""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment.""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "ACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED"]), help=u"""A filter to return only Delegation Subscription resources whose lifecycleState matches the given Delegation Subscription lifecycle state.""")
@cli_util.option('--display-name', help=u"""A filter to return Delegation Subscription resources that match the given display name.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'asc' or 'desc'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending. If no value is specified, timeCreated is default.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'delegate_access_control', 'class': 'DelegationSubscriptionSummaryCollection'})
@cli_util.wrap_exceptions
def list_delegation_subscriptions(ctx, from_json, all_pages, page_size, compartment_id, lifecycle_state, display_name, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    if display_name is not None:
        kwargs['display_name'] = display_name
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('delegate_access_control', 'delegate_access_control', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_delegation_subscriptions,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_delegation_subscriptions,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_delegation_subscriptions(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@service_provider_action_group.command(name=cli_util.override('delegate_access_control.list_service_provider_actions.command_name', 'list'), help=u"""Lists all the ServiceProviderActions available in the system. \n[Command Reference](listServiceProviderActions)""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment.""")
@cli_util.option('--name', help=u"""A filter to return only resources that match the entire name given.""")
@cli_util.option('--resource-type', type=custom_types.CliCaseInsensitiveChoice(["VMCLUSTER", "CLOUDVMCLUSTER"]), help=u"""A filter to return only resources that match the given resource type.""")
@cli_util.option('--service-provider-service-type', type=custom_types.CliCaseInsensitiveChoice(["TROUBLESHOOTING", "ASSISTED_PATCHING"]), multiple=True, help=u"""A filter to return only resources that match the given Service Provider service type.""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "INACTIVE"]), help=u"""A filter to return only resources whose lifecycleState matches the given Service Provider Action lifecycleState.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'asc' or 'desc'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "name"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for name is ascending. If no value is specified, default is timeCreated.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'delegate_access_control', 'class': 'ServiceProviderActionSummaryCollection'})
@cli_util.wrap_exceptions
def list_service_provider_actions(ctx, from_json, all_pages, page_size, compartment_id, name, resource_type, service_provider_service_type, lifecycle_state, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if name is not None:
        kwargs['name'] = name
    if resource_type is not None:
        kwargs['resource_type'] = resource_type
    if service_provider_service_type is not None and len(service_provider_service_type) > 0:
        kwargs['service_provider_service_type'] = service_provider_service_type
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('delegate_access_control', 'delegate_access_control', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_service_provider_actions,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_service_provider_actions,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_service_provider_actions(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@delegated_resource_access_request_group.command(name=cli_util.override('delegate_access_control.list_service_provider_interactions.command_name', 'list-service-provider-interactions'), help=u"""Lists the MoreInformation interaction between customer and support operators. \n[Command Reference](listServiceProviderInteractions)""")
@cli_util.option('--delegated-resource-access-request-id', required=True, help=u"""Unique Delegated Resource Access Request identifier""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'delegate_access_control', 'class': 'ServiceProviderInteractionCollection'})
@cli_util.wrap_exceptions
def list_service_provider_interactions(ctx, from_json, all_pages, page_size, delegated_resource_access_request_id, limit, page):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(delegated_resource_access_request_id, six.string_types) and len(delegated_resource_access_request_id.strip()) == 0:
        raise click.UsageError('Parameter --delegated-resource-access-request-id cannot be whitespace or empty string')

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('delegate_access_control', 'delegate_access_control', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_service_provider_interactions,
            delegated_resource_access_request_id=delegated_resource_access_request_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_service_provider_interactions,
            limit,
            page_size,
            delegated_resource_access_request_id=delegated_resource_access_request_id,
            **kwargs
        )
    else:
        result = client.list_service_provider_interactions(
            delegated_resource_access_request_id=delegated_resource_access_request_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@service_provider_group.command(name=cli_util.override('delegate_access_control.list_service_providers.command_name', 'list'), help=u"""Lists the Service Providers. \n[Command Reference](listServiceProviders)""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment.""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "ACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED"]), help=u"""A filter to return only Service Provider resources whose lifecycleState matches the given Service Provider lifecycle state.""")
@cli_util.option('--name', help=u"""A filter to return Service Provider resources that match the given name.""")
@cli_util.option('--supported-resource-type', type=custom_types.CliCaseInsensitiveChoice(["VMCLUSTER", "CLOUDVMCLUSTER"]), help=u"""A filter to return only Service Provider resources whose supported resource type matches the given resource type.""")
@cli_util.option('--service-provider-type', type=custom_types.CliCaseInsensitiveChoice(["ORACLE_PROVIDED"]), help=u"""A filter to return only Service Provider resources whose provider type matches the given provider type.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'asc' or 'desc'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for name is ascending. If no value is specified, timeCreated is default.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'delegate_access_control', 'class': 'ServiceProviderSummaryCollection'})
@cli_util.wrap_exceptions
def list_service_providers(ctx, from_json, all_pages, page_size, compartment_id, lifecycle_state, name, supported_resource_type, service_provider_type, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    if name is not None:
        kwargs['name'] = name
    if supported_resource_type is not None:
        kwargs['supported_resource_type'] = supported_resource_type
    if service_provider_type is not None:
        kwargs['service_provider_type'] = service_provider_type
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('delegate_access_control', 'delegate_access_control', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_service_providers,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_service_providers,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_service_providers(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@delegated_resource_access_request_group.command(name=cli_util.override('delegate_access_control.reject_delegated_resource_access_request.command_name', 'reject'), help=u"""Rejects a Delegated Resource Access Request. \n[Command Reference](rejectDelegatedResourceAccessRequest)""")
@cli_util.option('--delegated-resource-access-request-id', required=True, help=u"""Unique Delegated Resource Access Request identifier""")
@cli_util.option('--approver-comment', help=u"""Comment by the approver explaining why the request is rejected.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def reject_delegated_resource_access_request(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, delegated_resource_access_request_id, approver_comment, if_match):

    if isinstance(delegated_resource_access_request_id, six.string_types) and len(delegated_resource_access_request_id.strip()) == 0:
        raise click.UsageError('Parameter --delegated-resource-access-request-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if approver_comment is not None:
        _details['approverComment'] = approver_comment

    client = cli_util.build_client('delegate_access_control', 'delegate_access_control', ctx)
    result = client.reject_delegated_resource_access_request(
        delegated_resource_access_request_id=delegated_resource_access_request_id,
        reject_delegated_resource_access_request_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@delegated_resource_access_request_group.command(name=cli_util.override('delegate_access_control.revoke_delegated_resource_access_request.command_name', 'revoke'), help=u"""Revokes an already approved Delegated Resource Access Request. \n[Command Reference](revokeDelegatedResourceAccessRequest)""")
@cli_util.option('--delegated-resource-access-request-id', required=True, help=u"""Unique Delegated Resource Access Request identifier""")
@cli_util.option('--approver-comment', help=u"""Comment specified by the approver explaining why the approval is revoked.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def revoke_delegated_resource_access_request(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, delegated_resource_access_request_id, approver_comment, if_match):

    if isinstance(delegated_resource_access_request_id, six.string_types) and len(delegated_resource_access_request_id.strip()) == 0:
        raise click.UsageError('Parameter --delegated-resource-access-request-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if approver_comment is not None:
        _details['approverComment'] = approver_comment

    client = cli_util.build_client('delegate_access_control', 'delegate_access_control', ctx)
    result = client.revoke_delegated_resource_access_request(
        delegated_resource_access_request_id=delegated_resource_access_request_id,
        revoke_delegated_resource_access_request_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@delegated_resource_access_request_group.command(name=cli_util.override('delegate_access_control.service_provider_interaction_request.command_name', 'service-provider-interaction-request'), help=u"""Posts query for additional information for the given Delegated Resource Access Request. \n[Command Reference](serviceProviderInteractionRequest)""")
@cli_util.option('--delegated-resource-access-request-id', required=True, help=u"""Unique Delegated Resource Access Request identifier""")
@cli_util.option('--more-info-details', help=u"""Questions for operator to provide more information.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def service_provider_interaction_request(ctx, from_json, delegated_resource_access_request_id, more_info_details, if_match):

    if isinstance(delegated_resource_access_request_id, six.string_types) and len(delegated_resource_access_request_id.strip()) == 0:
        raise click.UsageError('Parameter --delegated-resource-access-request-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if more_info_details is not None:
        _details['moreInfoDetails'] = more_info_details

    client = cli_util.build_client('delegate_access_control', 'delegate_access_control', ctx)
    result = client.service_provider_interaction_request(
        delegated_resource_access_request_id=delegated_resource_access_request_id,
        service_provider_interaction_request_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@delegation_control_group.command(name=cli_util.override('delegate_access_control.update_delegation_control.command_name', 'update'), help=u"""Updates the existing DelegationControl for a given Delegation Control ID. \n[Command Reference](updateDelegationControl)""")
@cli_util.option('--delegation-control-id', required=True, help=u"""unique Delegation Control identifier""")
@cli_util.option('--display-name', help=u"""Name of the Delegation Control. The name does not need to be unique.""")
@cli_util.option('--description', help=u"""Description of the Delegation Control.""")
@cli_util.option('--num-approvals-required', type=click.INT, help=u"""number of approvals required.""")
@cli_util.option('--delegation-subscription-ids', type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of Delegation Subscription OCID that are allowed for this Delegation Control. The allowed subscriptions will determine the available Service Provider Actions. Only support operators for the allowed subscriptions are allowed to create Delegated Resource Access Request.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--is-auto-approve-during-maintenance', type=click.BOOL, help=u"""Set to true to allow all Delegated Resource Access Request to be approved automatically during maintenance.""")
@cli_util.option('--resource-ids', type=custom_types.CLI_COMPLEX_TYPE, help=u"""The OCID of the selected resources that this Delegation Control is applicable to.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--pre-approved-service-provider-action-names', type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of pre-approved Service Provider Action names. The list of pre-defined Service Provider Actions can be obtained from the ListServiceProviderActions API. Delegated Resource Access Requests associated with a resource governed by this Delegation Control will be automatically approved if the Delegated Resource Access Request only contain Service Provider Actions in the pre-approved list.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--notification-topic-id', help=u"""The OCID of the OCI Notification topic to publish messages related to this Delegation Control.""")
@cli_util.option('--notification-message-format', help=u"""The format of the OCI Notification messages for this Delegation Control.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags].

Example: `{\"Department\": \"Finance\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags].

Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'delegation-subscription-ids': {'module': 'delegate_access_control', 'class': 'list[string]'}, 'resource-ids': {'module': 'delegate_access_control', 'class': 'list[string]'}, 'pre-approved-service-provider-action-names': {'module': 'delegate_access_control', 'class': 'list[string]'}, 'freeform-tags': {'module': 'delegate_access_control', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'delegate_access_control', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'delegation-subscription-ids': {'module': 'delegate_access_control', 'class': 'list[string]'}, 'resource-ids': {'module': 'delegate_access_control', 'class': 'list[string]'}, 'pre-approved-service-provider-action-names': {'module': 'delegate_access_control', 'class': 'list[string]'}, 'freeform-tags': {'module': 'delegate_access_control', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'delegate_access_control', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'delegate_access_control', 'class': 'DelegationControl'})
@cli_util.wrap_exceptions
def update_delegation_control(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, delegation_control_id, display_name, description, num_approvals_required, delegation_subscription_ids, is_auto_approve_during_maintenance, resource_ids, pre_approved_service_provider_action_names, notification_topic_id, notification_message_format, freeform_tags, defined_tags, if_match):

    if isinstance(delegation_control_id, six.string_types) and len(delegation_control_id.strip()) == 0:
        raise click.UsageError('Parameter --delegation-control-id cannot be whitespace or empty string')
    if not force:
        if delegation_subscription_ids or resource_ids or pre_approved_service_provider_action_names or freeform_tags or defined_tags:
            if not click.confirm("WARNING: Updates to delegation-subscription-ids and resource-ids and pre-approved-service-provider-action-names and freeform-tags and defined-tags will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if display_name is not None:
        _details['displayName'] = display_name

    if description is not None:
        _details['description'] = description

    if num_approvals_required is not None:
        _details['numApprovalsRequired'] = num_approvals_required

    if delegation_subscription_ids is not None:
        _details['delegationSubscriptionIds'] = cli_util.parse_json_parameter("delegation_subscription_ids", delegation_subscription_ids)

    if is_auto_approve_during_maintenance is not None:
        _details['isAutoApproveDuringMaintenance'] = is_auto_approve_during_maintenance

    if resource_ids is not None:
        _details['resourceIds'] = cli_util.parse_json_parameter("resource_ids", resource_ids)

    if pre_approved_service_provider_action_names is not None:
        _details['preApprovedServiceProviderActionNames'] = cli_util.parse_json_parameter("pre_approved_service_provider_action_names", pre_approved_service_provider_action_names)

    if notification_topic_id is not None:
        _details['notificationTopicId'] = notification_topic_id

    if notification_message_format is not None:
        _details['notificationMessageFormat'] = notification_message_format

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('delegate_access_control', 'delegate_access_control', ctx)
    result = client.update_delegation_control(
        delegation_control_id=delegation_control_id,
        update_delegation_control_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@delegation_subscription_group.command(name=cli_util.override('delegate_access_control.update_delegation_subscription.command_name', 'update'), help=u"""Updates the existing DelegationSubscription for a given Delegation Subscription ID. \n[Command Reference](updateDelegationSubscription)""")
@cli_util.option('--delegation-subscription-id', required=True, help=u"""unique Delegation Subscription identifier""")
@cli_util.option('--description', help=u"""Description of the Delegation Subscription.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags].

Example: `{\"Department\": \"Finance\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags].

Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'delegate_access_control', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'delegate_access_control', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'delegate_access_control', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'delegate_access_control', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'delegate_access_control', 'class': 'DelegationSubscription'})
@cli_util.wrap_exceptions
def update_delegation_subscription(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, delegation_subscription_id, description, freeform_tags, defined_tags, if_match):

    if isinstance(delegation_subscription_id, six.string_types) and len(delegation_subscription_id.strip()) == 0:
        raise click.UsageError('Parameter --delegation-subscription-id cannot be whitespace or empty string')
    if not force:
        if freeform_tags or defined_tags:
            if not click.confirm("WARNING: Updates to freeform-tags and defined-tags will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if description is not None:
        _details['description'] = description

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('delegate_access_control', 'delegate_access_control', ctx)
    result = client.update_delegation_subscription(
        delegation_subscription_id=delegation_subscription_id,
        update_delegation_subscription_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)
