# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240501

from __future__ import print_function
import click
import oci  # noqa: F401
import six  # noqa: F401
import sys  # noqa: F401
from oci_cli import cli_constants  # noqa: F401
from oci_cli import cli_util
from oci_cli import json_skeleton_utils
from oci_cli import custom_types  # noqa: F401
from oci_cli.aliasing import CommandGroupWithAlias
from services.dbmulticloud.src.oci_cli_dbmulticloud.generated import dbmulticloud_service_cli


@click.command(cli_util.override('multi_cloud_resource_discovery.multi_cloud_resource_discovery_root_group.command_name', 'multi-cloud-resource-discovery'), cls=CommandGroupWithAlias, help=cli_util.override('multi_cloud_resource_discovery.multi_cloud_resource_discovery_root_group.help', """<b>Microsoft Azure:</b> <br>
<b>Oracle Azure Connector Resource:</b>:&nbsp;&nbsp;The Oracle Azure Connector Resource is used to install the Azure Arc Server on an Exadata VM cluster in Oracle Exadata Database Service on Dedicated Infrastructure (ExaDB-D).
 The supported method to install the Azure Arc Server (Azure Identity) on the Exadata VM cluster:
<ul>
 <li>Using a Bearer Access Token</li>
</ul>

<b>Oracle Azure Blob Container Resource:</b>&nbsp;&nbsp;The Oracle Azure Blob Container Resource is used to capture the details of an Azure Blob Container.
This resource can then be reused across multiple Exadata VM clusters in Oracle Exadata Database Service on Dedicated Infrastructure (ExaDB-D) to mount the Azure container.

<b>Oracle Azure Blob Mount Resource:</b>&nbsp;&nbsp;The Oracle Azure Blob Mount Resource is used to mount an Azure Blob Container on an Exadata VM cluster in Oracle Exadata Database Service on Dedicated Infrastructure (ExaDB-D).
It relies on both the Oracle Azure Connector and the Oracle Azure Blob Container Resource to perform the mount operation.

<b>Discover Azure Vaults and Keys Resource:</b>&nbsp;&nbsp;The Discover Oracle Azure Vaults and Azure Keys Resource is used to discover Azure Vaults and the associated encryption keys available in your Azure project.

<b>Oracle Azure Vault:</b>&nbsp;&nbsp;The Oracle Azure Vault Resource is used to manage Azure Vaults within Oracle Cloud Infrastructure (OCI) for use with services such as Oracle Exadata Database Service on Dedicated Infrastructure.

<b>Oracle Azure Key:</b>&nbsp;&nbsp;Oracle Azure Key Resource is used to register and manage a Oracle Azure Key Key within Oracle Cloud Infrastructure (OCI) under an associated Azure Vault.

<br>

<b>Google Cloud:</b><br>
<b>Oracle Google Cloud Connector Resource:</b>&nbsp;&nbsp;The Oracle Google Cloud Connector Resource is used to install the Google Cloud Identity Connector on an Exadata VM cluster in Oracle Exadata Database Service on Dedicated Infrastructure (ExaDB-D).

<b>Discover Google Key Rings and Keys Resource:</b>&nbsp;&nbsp;The Discover Google Key Rings and Keys Resource is used to discover Google Cloud Key Rings and the associated encryption keys available in your Google Cloud project.

<b>Google Key Rings Resource:</b>&nbsp;&nbsp;The Google Key Rings Resource is used to register and manage Google Cloud Key Rings within Oracle Cloud Infrastructure (OCI) for use with services such as Oracle Exadata Database Service on Dedicated Infrastructure.

<b>Google Key Resource:</b>&nbsp;&nbsp;The Google Key Resource is used to register and manage a Google Cloud Key within Oracle Cloud Infrastructure (OCI) under an associated Google Key Ring."""), short_help=cli_util.override('multi_cloud_resource_discovery.multi_cloud_resource_discovery_root_group.short_help', """Oracle Database MultiCloud Data Plane Integration"""))
@cli_util.help_option_group
def multi_cloud_resource_discovery_root_group():
    pass


@click.command(cli_util.override('multi_cloud_resource_discovery.multi_cloud_resource_discovery_group.command_name', 'multi-cloud-resource-discovery'), cls=CommandGroupWithAlias, help="""Multicloud Resource Discovery resource object""")
@cli_util.help_option_group
def multi_cloud_resource_discovery_group():
    pass


dbmulticloud_service_cli.dbmulticloud_service_group.add_command(multi_cloud_resource_discovery_root_group)
multi_cloud_resource_discovery_root_group.add_command(multi_cloud_resource_discovery_group)


@multi_cloud_resource_discovery_group.command(name=cli_util.override('multi_cloud_resource_discovery.change_multi_cloud_resource_discovery_compartment.command_name', 'change-compartment'), help=u"""Moves the Multicloud Resource Discovery resource into a different compartment. When provided, 'If-Match' is checked against 'ETag' values of the resource. \n[Command Reference](changeMultiCloudResourceDiscoveryCompartment)""")
@cli_util.option('--multi-cloud-resource-discovery-id', required=True, help=u"""The [OCID] of the Multicloud Discovery Resource.""")
@cli_util.option('--compartment-id', help=u"""The [OCID] of the new compartment that contains Multicloud Resource Discovery resource.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags].

Example: `{\"Department\": \"Finance\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags].

Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--system-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""System tags for this resource. Each key is predefined and scoped to a namespace.

Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'dbmulticloud', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'dbmulticloud', 'class': 'dict(str, dict(str, object))'}, 'system-tags': {'module': 'dbmulticloud', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'dbmulticloud', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'dbmulticloud', 'class': 'dict(str, dict(str, object))'}, 'system-tags': {'module': 'dbmulticloud', 'class': 'dict(str, dict(str, object))'}})
@cli_util.wrap_exceptions
def change_multi_cloud_resource_discovery_compartment(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, multi_cloud_resource_discovery_id, compartment_id, freeform_tags, defined_tags, system_tags, if_match):

    if isinstance(multi_cloud_resource_discovery_id, six.string_types) and len(multi_cloud_resource_discovery_id.strip()) == 0:
        raise click.UsageError('Parameter --multi-cloud-resource-discovery-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if compartment_id is not None:
        _details['compartmentId'] = compartment_id

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    if system_tags is not None:
        _details['systemTags'] = cli_util.parse_json_parameter("system_tags", system_tags)

    client = cli_util.build_client('dbmulticloud', 'multi_cloud_resource_discovery', ctx)
    result = client.change_multi_cloud_resource_discovery_compartment(
        multi_cloud_resource_discovery_id=multi_cloud_resource_discovery_id,
        change_multi_cloud_resource_discovery_compartment_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@multi_cloud_resource_discovery_group.command(name=cli_util.override('multi_cloud_resource_discovery.create_multi_cloud_resource_discovery.command_name', 'create'), help=u"""Discovers Multicloud Resource and their associated resources based on the information provided. \n[Command Reference](createMultiCloudResourceDiscovery)""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment that contains Multicloud Resource Discovery resource.""")
@cli_util.option('--display-name', required=True, help=u"""Display name of the Multicloud Resource Discovery resource.""")
@cli_util.option('--oracle-db-connector-id', required=True, help=u"""The [OCID] of the Oracle DB Connector resource.""")
@cli_util.option('--resource-type', required=True, help=u"""Resource Type to discover.""")
@cli_util.option('--resources-filter', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Discover resource using attributes as key-value pair. For GCP supported attributes (keyRing) For Azure supported attributes (keyVault) GCP Example `{\"keyRing\": \"projects/db-mc-dataplane/locations/global/keyRings/dbmci-keyring\"}` or `{\"keyRing\": \"dbmci-keyring\"}` Azure Example `{\"keyVault\": \"/subscriptions/fd42b73d-5f28-4a23-ae7c-ca08c625fe07/resourceGroups/yumfei0808Test/providers/Microsoft.KeyVault/managedHSMs/orp7HSM001\"}` or `{\"keyVault\": \"orp7HSM001\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags].

Example: `{\"Department\": \"Finance\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags].

Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'resources-filter': {'module': 'dbmulticloud', 'class': 'dict(str, string)'}, 'freeform-tags': {'module': 'dbmulticloud', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'dbmulticloud', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'resources-filter': {'module': 'dbmulticloud', 'class': 'dict(str, string)'}, 'freeform-tags': {'module': 'dbmulticloud', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'dbmulticloud', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'dbmulticloud', 'class': 'MultiCloudResourceDiscovery'})
@cli_util.wrap_exceptions
def create_multi_cloud_resource_discovery(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, compartment_id, display_name, oracle_db_connector_id, resource_type, resources_filter, freeform_tags, defined_tags, if_match):

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id
    _details['displayName'] = display_name
    _details['oracleDbConnectorId'] = oracle_db_connector_id
    _details['resourceType'] = resource_type

    if resources_filter is not None:
        _details['resourcesFilter'] = cli_util.parse_json_parameter("resources_filter", resources_filter)

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('dbmulticloud', 'multi_cloud_resource_discovery', ctx)
    result = client.create_multi_cloud_resource_discovery(
        create_multi_cloud_resource_discovery_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@multi_cloud_resource_discovery_group.command(name=cli_util.override('multi_cloud_resource_discovery.delete_multi_cloud_resource_discovery.command_name', 'delete'), help=u"""Deletes the Multicloud Resource Discovery resource and removes its associated metadata from Oracle Cloud Infrastructure. \n[Command Reference](deleteMultiCloudResourceDiscovery)""")
@cli_util.option('--multi-cloud-resource-discovery-id', required=True, help=u"""The [OCID] of the Multicloud Discovery Resource.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_multi_cloud_resource_discovery(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, multi_cloud_resource_discovery_id, if_match):

    if isinstance(multi_cloud_resource_discovery_id, six.string_types) and len(multi_cloud_resource_discovery_id.strip()) == 0:
        raise click.UsageError('Parameter --multi-cloud-resource-discovery-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('dbmulticloud', 'multi_cloud_resource_discovery', ctx)
    result = client.delete_multi_cloud_resource_discovery(
        multi_cloud_resource_discovery_id=multi_cloud_resource_discovery_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Please retrieve the work request to find its current state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@multi_cloud_resource_discovery_group.command(name=cli_util.override('multi_cloud_resource_discovery.get_multi_cloud_resource_discovery.command_name', 'get'), help=u"""Retrieves detailed information about a Multicloud discovered resource by specifying its unique resource [OCID]. \n[Command Reference](getMultiCloudResourceDiscovery)""")
@cli_util.option('--multi-cloud-resource-discovery-id', required=True, help=u"""The [OCID] of the Multicloud Discovery Resource.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'asc' or 'desc'.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'dbmulticloud', 'class': 'MultiCloudResourceDiscovery'})
@cli_util.wrap_exceptions
def get_multi_cloud_resource_discovery(ctx, from_json, multi_cloud_resource_discovery_id, limit, page, sort_order):

    if isinstance(multi_cloud_resource_discovery_id, six.string_types) and len(multi_cloud_resource_discovery_id.strip()) == 0:
        raise click.UsageError('Parameter --multi-cloud-resource-discovery-id cannot be whitespace or empty string')

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('dbmulticloud', 'multi_cloud_resource_discovery', ctx)
    result = client.get_multi_cloud_resource_discovery(
        multi_cloud_resource_discovery_id=multi_cloud_resource_discovery_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@multi_cloud_resource_discovery_group.command(name=cli_util.override('multi_cloud_resource_discovery.list_multi_cloud_resource_discoveries.command_name', 'list'), help=u"""Lists all Multicloud Resource Discovery resources based on the specified filters. \n[Command Reference](listMultiCloudResourceDiscoveries)""")
@cli_util.option('--compartment-id', required=True, help=u"""The [ID] of the compartment.""")
@cli_util.option('--display-name', help=u"""A filter to return Oracle DB Multicloud Discovery resources that match the specified display name.""")
@cli_util.option('--multi-cloud-resource-discovery-id', help=u"""The [OCID] of the Multicloud Discovery resource.""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "SUCCEEDED", "UPDATING", "CANCELING", "CANCELED", "FAILED", "NEEDS_ATTENTION"]), help=u"""A filter to return only resources that match the specified lifecycle state. The state value is case-insensitive.""")
@cli_util.option('--oracle-db-azure-connector-id', help=u"""A filter to return Oracle DB Azure Azure Identity Connector resources.""")
@cli_util.option('--resource-type', type=custom_types.CliCaseInsensitiveChoice(["VAULTS", "STORAGE", "GCP_KEY_RINGS"]), help=u"""The type of Multicloud Resource.""")
@cli_util.option('--resources-filter', multiple=True, help=u"""Specifies the type(s) of resources to discover in the target cloud provider.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'asc' or 'desc'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending. If no value is specified, default is timeCreated.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({'resources-filter': {'module': 'dbmulticloud', 'class': 'list[string]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'resources-filter': {'module': 'dbmulticloud', 'class': 'list[string]'}}, output_type={'module': 'dbmulticloud', 'class': 'MultiCloudResourceDiscoverySummaryCollection'})
@cli_util.wrap_exceptions
def list_multi_cloud_resource_discoveries(ctx, from_json, all_pages, page_size, compartment_id, display_name, multi_cloud_resource_discovery_id, lifecycle_state, oracle_db_azure_connector_id, resource_type, resources_filter, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if display_name is not None:
        kwargs['display_name'] = display_name
    if multi_cloud_resource_discovery_id is not None:
        kwargs['multi_cloud_resource_discovery_id'] = multi_cloud_resource_discovery_id
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    if oracle_db_azure_connector_id is not None:
        kwargs['oracle_db_azure_connector_id'] = oracle_db_azure_connector_id
    if resource_type is not None:
        kwargs['resource_type'] = resource_type
    if resources_filter is not None and len(resources_filter) > 0:
        kwargs['resources_filter'] = resources_filter
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('dbmulticloud', 'multi_cloud_resource_discovery', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_multi_cloud_resource_discoveries,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_multi_cloud_resource_discoveries,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_multi_cloud_resource_discoveries(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@multi_cloud_resource_discovery_group.command(name=cli_util.override('multi_cloud_resource_discovery.update_multi_cloud_resource_discovery.command_name', 'update'), help=u"""Modifies the properties of an Azure discovered resource identified by the specified resource [OCID]. \n[Command Reference](updateMultiCloudResourceDiscovery)""")
@cli_util.option('--multi-cloud-resource-discovery-id', required=True, help=u"""The [OCID] of the Multicloud Discovery Resource.""")
@cli_util.option('--compartment-id', help=u"""The [OCID] of the compartment that contains Multicloud Resource Discovery resource.""")
@cli_util.option('--display-name', help=u"""Display name of the Multicloud Resource Discovery resource.""")
@cli_util.option('--oracle-db-connector-id', help=u"""The [OCID] of the Oracle DB Connector resource.""")
@cli_util.option('--resource-type', help=u"""Resource Type to discover.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags].

Example: `{\"Department\": \"Finance\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags].

Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'dbmulticloud', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'dbmulticloud', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'dbmulticloud', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'dbmulticloud', 'class': 'dict(str, dict(str, object))'}})
@cli_util.wrap_exceptions
def update_multi_cloud_resource_discovery(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, multi_cloud_resource_discovery_id, compartment_id, display_name, oracle_db_connector_id, resource_type, freeform_tags, defined_tags, if_match):

    if isinstance(multi_cloud_resource_discovery_id, six.string_types) and len(multi_cloud_resource_discovery_id.strip()) == 0:
        raise click.UsageError('Parameter --multi-cloud-resource-discovery-id cannot be whitespace or empty string')
    if not force:
        if freeform_tags or defined_tags:
            if not click.confirm("WARNING: Updates to freeform-tags and defined-tags will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if compartment_id is not None:
        _details['compartmentId'] = compartment_id

    if display_name is not None:
        _details['displayName'] = display_name

    if oracle_db_connector_id is not None:
        _details['oracleDbConnectorId'] = oracle_db_connector_id

    if resource_type is not None:
        _details['resourceType'] = resource_type

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('dbmulticloud', 'multi_cloud_resource_discovery', ctx)
    result = client.update_multi_cloud_resource_discovery(
        multi_cloud_resource_discovery_id=multi_cloud_resource_discovery_id,
        update_multi_cloud_resource_discovery_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)
