# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241130

from __future__ import print_function
import click
import oci  # noqa: F401
import six  # noqa: F401
import sys  # noqa: F401
from oci_cli import cli_constants  # noqa: F401
from oci_cli import cli_util
from oci_cli import json_skeleton_utils
from oci_cli import custom_types  # noqa: F401
from oci_cli.aliasing import CommandGroupWithAlias
from services.apiaccesscontrol.src.oci_cli_apiaccesscontrol.generated import apiaccesscontrol_service_cli


@click.command(cli_util.override('api_metadata.api_metadata_root_group.command_name', 'api-metadata'), cls=CommandGroupWithAlias, help=cli_util.override('api_metadata.api_metadata_root_group.help', """This service is used to restrict the control plane service apis; so that everybody won't be
able to access those apis.
There are two main resouces defined as a part of this service
1. PrivilegedApiControl: This is created by the customer which defines which service apis are
   controlled and who can access it.
2. PrivilegedApiRequest: This is a request object again created by the customer operators who           seek access to those privileged apis. After a request is obtained based on the                       PrivilegedAccessControl for which the api belongs to, either it can be approved so that the          requested person can execute the service apis or it will wait for the customer to approve it."""), short_help=cli_util.override('api_metadata.api_metadata_root_group.short_help', """Oracle API Access Control"""))
@cli_util.help_option_group
def api_metadata_root_group():
    pass


@click.command(cli_util.override('api_metadata.api_metadata_group.command_name', 'api-metadata'), cls=CommandGroupWithAlias, help="""An ApiDetail contains details such as the service it belongs to, the name of the api, the type of api, and the parameters of the api if it contains.

To use any of the API operations, you must be authorized in an IAM policy. If you're not authorized, talk to an administrator. If you're an administrator who needs to write policies to give users access, see [Getting Started with Policies].""")
@cli_util.help_option_group
def api_metadata_group():
    pass


apiaccesscontrol_service_cli.apiaccesscontrol_service_group.add_command(api_metadata_root_group)
api_metadata_root_group.add_command(api_metadata_group)


@api_metadata_group.command(name=cli_util.override('api_metadata.get_api_metadata.command_name', 'get'), help=u"""Gets information about a ApiMetadata. \n[Command Reference](getApiMetadata)""")
@cli_util.option('--api-metadata-id', required=True, help=u"""The [OCID] of the PrivilegedApiControl.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'apiaccesscontrol', 'class': 'ApiMetadata'})
@cli_util.wrap_exceptions
def get_api_metadata(ctx, from_json, api_metadata_id):

    if isinstance(api_metadata_id, six.string_types) and len(api_metadata_id.strip()) == 0:
        raise click.UsageError('Parameter --api-metadata-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('apiaccesscontrol', 'api_metadata', ctx)
    result = client.get_api_metadata(
        api_metadata_id=api_metadata_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@api_metadata_group.command(name=cli_util.override('api_metadata.list_api_metadata.command_name', 'list'), help=u"""Gets a list of ApiMetadata. \n[Command Reference](listApiMetadata)""")
@cli_util.option('--compartment-id', help=u"""The [OCID] of the compartment in which to list resources.""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]), help=u"""A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.""")
@cli_util.option('--resource-type', help=u"""A filter to return only lists of resources that match the entire given service type.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the given display name exactly.""")
@cli_util.option('--limit', type=click.INT, help=u"""For list pagination. The maximum number of results per page, or items to return in a paginated \"List\" call. For important details about how pagination works, see [List Pagination].""")
@cli_util.option('--page', help=u"""For list pagination. The value of the opc-next-page response header from the previous \"List\" call. For important details about how pagination works, see [List Pagination].""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either ascending (`ASC`) or descending (`DESC`).""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. You can provide only one sort order. Default order for `timeCreated` is descending. Default order for `displayName` is ascending.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'apiaccesscontrol', 'class': 'ApiMetadataCollection'})
@cli_util.wrap_exceptions
def list_api_metadata(ctx, from_json, all_pages, page_size, compartment_id, lifecycle_state, resource_type, display_name, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if compartment_id is not None:
        kwargs['compartment_id'] = compartment_id
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    if resource_type is not None:
        kwargs['resource_type'] = resource_type
    if display_name is not None:
        kwargs['display_name'] = display_name
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('apiaccesscontrol', 'api_metadata', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_api_metadata,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_api_metadata,
            limit,
            page_size,
            **kwargs
        )
    else:
        result = client.list_api_metadata(
            **kwargs
        )
    cli_util.render_response(result, ctx)


@api_metadata_group.command(name=cli_util.override('api_metadata.list_api_metadata_by_entity_types.command_name', 'list-api-metadata-by-entity-types'), help=u"""Gets a list of ApiMetadata Grouped By Entity Types. \n[Command Reference](listApiMetadataByEntityTypes)""")
@cli_util.option('--compartment-id', help=u"""The [OCID] of the compartment in which to list resources.""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]), help=u"""A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.""")
@cli_util.option('--resource-type', help=u"""A filter to return only lists of resources that match the entire given service type.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the given display name exactly.""")
@cli_util.option('--limit', type=click.INT, help=u"""For list pagination. The maximum number of results per page, or items to return in a paginated \"List\" call. For important details about how pagination works, see [List Pagination].""")
@cli_util.option('--page', help=u"""For list pagination. The value of the opc-next-page response header from the previous \"List\" call. For important details about how pagination works, see [List Pagination].""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either ascending (`ASC`) or descending (`DESC`).""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. You can provide only one sort order. Default order for `timeCreated` is descending. Default order for `displayName` is ascending.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'apiaccesscontrol', 'class': 'ApiMetadataByEntityTypeCollection'})
@cli_util.wrap_exceptions
def list_api_metadata_by_entity_types(ctx, from_json, all_pages, page_size, compartment_id, lifecycle_state, resource_type, display_name, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if compartment_id is not None:
        kwargs['compartment_id'] = compartment_id
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    if resource_type is not None:
        kwargs['resource_type'] = resource_type
    if display_name is not None:
        kwargs['display_name'] = display_name
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('apiaccesscontrol', 'api_metadata', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_api_metadata_by_entity_types,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_api_metadata_by_entity_types,
            limit,
            page_size,
            **kwargs
        )
    else:
        result = client.list_api_metadata_by_entity_types(
            **kwargs
        )
    cli_util.render_response(result, ctx)
